///
/// KeyEncoding.hpp
/// This file was generated by nitrogen. DO NOT MODIFY THIS FILE.
/// https://github.com/mrousavy/nitro
/// Copyright © 2024 Marc Rousavy @ Margelo
///

#pragma once

#include <cmath>
#if __has_include(<NitroModules/JSIConverter.hpp>)
#include <NitroModules/JSIConverter.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif
#if __has_include(<NitroModules/NitroDefines.hpp>)
#include <NitroModules/NitroDefines.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif

namespace margelo::nitro::crypto {

  /**
   * An enum which can be represented as a JavaScript enum (KeyEncoding).
   */
  enum class KeyEncoding {
    KKEYENCODINGPKCS1      SWIFT_NAME(kkeyencodingpkcs1) = 0,
    KKEYENCODINGPKCS8      SWIFT_NAME(kkeyencodingpkcs8) = 1,
    KKEYENCODINGSPKI      SWIFT_NAME(kkeyencodingspki) = 2,
    KKEYENCODINGSEC1      SWIFT_NAME(kkeyencodingsec1) = 3,
  } CLOSED_ENUM;

} // namespace margelo::nitro::crypto

namespace margelo::nitro {

  using namespace margelo::nitro::crypto;

  // C++ KeyEncoding <> JS KeyEncoding (enum)
  template <>
  struct JSIConverter<KeyEncoding> {
    static inline KeyEncoding fromJSI(jsi::Runtime& runtime, const jsi::Value& arg) {
      int enumValue = JSIConverter<int>::fromJSI(runtime, arg);
      return static_cast<KeyEncoding>(enumValue);
    }
    static inline jsi::Value toJSI(jsi::Runtime& runtime, KeyEncoding arg) {
      int enumValue = static_cast<int>(arg);
      return JSIConverter<int>::toJSI(runtime, enumValue);
    }
    static inline bool canConvert(jsi::Runtime& runtime, const jsi::Value& value) {
      if (!value.isNumber()) {
        return false;
      }
      double integer;
      double fraction = modf(value.getNumber(), &integer);
      if (fraction != 0.0) {
        // It is some kind of floating point number - our enums are ints.
        return false;
      }
      // Check if we are within the bounds of the enum.
      return integer >= 0 && integer <= 3;
    }
  };

} // namespace margelo::nitro
