///
/// JWK.hpp
/// This file was generated by nitrogen. DO NOT MODIFY THIS FILE.
/// https://github.com/mrousavy/nitro
/// Copyright © 2024 Marc Rousavy @ Margelo
///

#pragma once

#if __has_include(<NitroModules/JSIConverter.hpp>)
#include <NitroModules/JSIConverter.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif
#if __has_include(<NitroModules/NitroDefines.hpp>)
#include <NitroModules/NitroDefines.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif

// Forward declaration of `JWKkty` to properly resolve imports.
namespace margelo::nitro::crypto { enum class JWKkty; }
// Forward declaration of `JWKuse` to properly resolve imports.
namespace margelo::nitro::crypto { enum class JWKuse; }
// Forward declaration of `KeyUsage` to properly resolve imports.
namespace margelo::nitro::crypto { enum class KeyUsage; }

#include <optional>
#include "JWKkty.hpp"
#include "JWKuse.hpp"
#include <vector>
#include "KeyUsage.hpp"
#include <string>

namespace margelo::nitro::crypto {

  /**
   * A struct which can be represented as a JavaScript object (JWK).
   */
  struct JWK {
  public:
    std::optional<JWKkty> kty     SWIFT_PRIVATE;
    std::optional<JWKuse> use     SWIFT_PRIVATE;
    std::optional<std::vector<KeyUsage>> key_ops     SWIFT_PRIVATE;
    std::optional<std::string> alg     SWIFT_PRIVATE;
    std::optional<std::string> crv     SWIFT_PRIVATE;
    std::optional<std::string> kid     SWIFT_PRIVATE;
    std::optional<std::string> x5u     SWIFT_PRIVATE;
    std::optional<std::vector<std::string>> x5c     SWIFT_PRIVATE;
    std::optional<std::string> x5t     SWIFT_PRIVATE;
    std::optional<std::string> x5t_256     SWIFT_PRIVATE;
    std::optional<std::string> n     SWIFT_PRIVATE;
    std::optional<std::string> e     SWIFT_PRIVATE;
    std::optional<std::string> d     SWIFT_PRIVATE;
    std::optional<std::string> p     SWIFT_PRIVATE;
    std::optional<std::string> q     SWIFT_PRIVATE;
    std::optional<std::string> x     SWIFT_PRIVATE;
    std::optional<std::string> y     SWIFT_PRIVATE;
    std::optional<std::string> k     SWIFT_PRIVATE;
    std::optional<std::string> dp     SWIFT_PRIVATE;
    std::optional<std::string> dq     SWIFT_PRIVATE;
    std::optional<std::string> qi     SWIFT_PRIVATE;
    std::optional<bool> ext     SWIFT_PRIVATE;

  public:
    explicit JWK(std::optional<JWKkty> kty, std::optional<JWKuse> use, std::optional<std::vector<KeyUsage>> key_ops, std::optional<std::string> alg, std::optional<std::string> crv, std::optional<std::string> kid, std::optional<std::string> x5u, std::optional<std::vector<std::string>> x5c, std::optional<std::string> x5t, std::optional<std::string> x5t_256, std::optional<std::string> n, std::optional<std::string> e, std::optional<std::string> d, std::optional<std::string> p, std::optional<std::string> q, std::optional<std::string> x, std::optional<std::string> y, std::optional<std::string> k, std::optional<std::string> dp, std::optional<std::string> dq, std::optional<std::string> qi, std::optional<bool> ext): kty(kty), use(use), key_ops(key_ops), alg(alg), crv(crv), kid(kid), x5u(x5u), x5c(x5c), x5t(x5t), x5t_256(x5t_256), n(n), e(e), d(d), p(p), q(q), x(x), y(y), k(k), dp(dp), dq(dq), qi(qi), ext(ext) {}
  };

} // namespace margelo::nitro::crypto

namespace margelo::nitro {

  using namespace margelo::nitro::crypto;

  // C++ JWK <> JS JWK (object)
  template <>
  struct JSIConverter<JWK> {
    static inline JWK fromJSI(jsi::Runtime& runtime, const jsi::Value& arg) {
      jsi::Object obj = arg.asObject(runtime);
      return JWK(
        JSIConverter<std::optional<JWKkty>>::fromJSI(runtime, obj.getProperty(runtime, "kty")),
        JSIConverter<std::optional<JWKuse>>::fromJSI(runtime, obj.getProperty(runtime, "use")),
        JSIConverter<std::optional<std::vector<KeyUsage>>>::fromJSI(runtime, obj.getProperty(runtime, "key_ops")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "alg")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "crv")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "kid")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "x5u")),
        JSIConverter<std::optional<std::vector<std::string>>>::fromJSI(runtime, obj.getProperty(runtime, "x5c")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "x5t")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "x5t#256")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "n")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "e")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "d")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "p")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "q")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "x")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "y")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "k")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "dp")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "dq")),
        JSIConverter<std::optional<std::string>>::fromJSI(runtime, obj.getProperty(runtime, "qi")),
        JSIConverter<std::optional<bool>>::fromJSI(runtime, obj.getProperty(runtime, "ext"))
      );
    }
    static inline jsi::Value toJSI(jsi::Runtime& runtime, const JWK& arg) {
      jsi::Object obj(runtime);
      obj.setProperty(runtime, "kty", JSIConverter<std::optional<JWKkty>>::toJSI(runtime, arg.kty));
      obj.setProperty(runtime, "use", JSIConverter<std::optional<JWKuse>>::toJSI(runtime, arg.use));
      obj.setProperty(runtime, "key_ops", JSIConverter<std::optional<std::vector<KeyUsage>>>::toJSI(runtime, arg.key_ops));
      obj.setProperty(runtime, "alg", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.alg));
      obj.setProperty(runtime, "crv", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.crv));
      obj.setProperty(runtime, "kid", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.kid));
      obj.setProperty(runtime, "x5u", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.x5u));
      obj.setProperty(runtime, "x5c", JSIConverter<std::optional<std::vector<std::string>>>::toJSI(runtime, arg.x5c));
      obj.setProperty(runtime, "x5t", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.x5t));
      obj.setProperty(runtime, "x5t#256", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.x5t_256));
      obj.setProperty(runtime, "n", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.n));
      obj.setProperty(runtime, "e", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.e));
      obj.setProperty(runtime, "d", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.d));
      obj.setProperty(runtime, "p", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.p));
      obj.setProperty(runtime, "q", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.q));
      obj.setProperty(runtime, "x", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.x));
      obj.setProperty(runtime, "y", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.y));
      obj.setProperty(runtime, "k", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.k));
      obj.setProperty(runtime, "dp", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.dp));
      obj.setProperty(runtime, "dq", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.dq));
      obj.setProperty(runtime, "qi", JSIConverter<std::optional<std::string>>::toJSI(runtime, arg.qi));
      obj.setProperty(runtime, "ext", JSIConverter<std::optional<bool>>::toJSI(runtime, arg.ext));
      return obj;
    }
    static inline bool canConvert(jsi::Runtime& runtime, const jsi::Value& value) {
      if (!value.isObject()) {
        return false;
      }
      jsi::Object obj = value.getObject(runtime);
      if (!JSIConverter<std::optional<JWKkty>>::canConvert(runtime, obj.getProperty(runtime, "kty"))) return false;
      if (!JSIConverter<std::optional<JWKuse>>::canConvert(runtime, obj.getProperty(runtime, "use"))) return false;
      if (!JSIConverter<std::optional<std::vector<KeyUsage>>>::canConvert(runtime, obj.getProperty(runtime, "key_ops"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "alg"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "crv"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "kid"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "x5u"))) return false;
      if (!JSIConverter<std::optional<std::vector<std::string>>>::canConvert(runtime, obj.getProperty(runtime, "x5c"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "x5t"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "x5t#256"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "n"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "e"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "d"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "p"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "q"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "x"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "y"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "k"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "dp"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "dq"))) return false;
      if (!JSIConverter<std::optional<std::string>>::canConvert(runtime, obj.getProperty(runtime, "qi"))) return false;
      if (!JSIConverter<std::optional<bool>>::canConvert(runtime, obj.getProperty(runtime, "ext"))) return false;
      return true;
    }
  };

} // namespace margelo::nitro
