///
/// HybridKeyObjectHandleSpec.hpp
/// This file was generated by nitrogen. DO NOT MODIFY THIS FILE.
/// https://github.com/mrousavy/nitro
/// Copyright © 2024 Marc Rousavy @ Margelo
///

#pragma once

#if __has_include(<NitroModules/HybridObject.hpp>)
#include <NitroModules/HybridObject.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif

// Forward declaration of `ArrayBuffer` to properly resolve imports.
namespace NitroModules { class ArrayBuffer; }
// Forward declaration of `KFormatType` to properly resolve imports.
namespace margelo::nitro::crypto { enum class KFormatType; }
// Forward declaration of `KeyEncoding` to properly resolve imports.
namespace margelo::nitro::crypto { enum class KeyEncoding; }
// Forward declaration of `JWK` to properly resolve imports.
namespace margelo::nitro::crypto { struct JWK; }
// Forward declaration of `CFRGKeyPairType` to properly resolve imports.
namespace margelo::nitro::crypto { enum class CFRGKeyPairType; }
// Forward declaration of `KeyType` to properly resolve imports.
namespace margelo::nitro::crypto { enum class KeyType; }
// Forward declaration of `NamedCurve` to properly resolve imports.
namespace margelo::nitro::crypto { enum class NamedCurve; }
// Forward declaration of `KeyDetail` to properly resolve imports.
namespace margelo::nitro::crypto { struct KeyDetail; }

#include <NitroModules/ArrayBuffer.hpp>
#include <optional>
#include "KFormatType.hpp"
#include "KeyEncoding.hpp"
#include <string>
#include "JWK.hpp"
#include "CFRGKeyPairType.hpp"
#include "KeyType.hpp"
#include <variant>
#include "NamedCurve.hpp"
#include "KeyDetail.hpp"

namespace margelo::nitro::crypto {

  using namespace margelo::nitro;

  /**
   * An abstract base class for `KeyObjectHandle`
   * Inherit this class to create instances of `HybridKeyObjectHandleSpec` in C++.
   * You must explicitly call `HybridObject`'s constructor yourself, because it is virtual.
   * @example
   * ```cpp
   * class HybridKeyObjectHandle: public HybridKeyObjectHandleSpec {
   * public:
   *   HybridKeyObjectHandle(...): HybridObject(TAG) { ... }
   *   // ...
   * };
   * ```
   */
  class HybridKeyObjectHandleSpec: public virtual HybridObject {
    public:
      // Constructor
      explicit HybridKeyObjectHandleSpec(): HybridObject(TAG) { }

      // Destructor
      virtual ~HybridKeyObjectHandleSpec() { }

    public:
      // Properties
      

    public:
      // Methods
      virtual std::shared_ptr<ArrayBuffer> exportKey(std::optional<KFormatType> format, std::optional<KeyEncoding> type, const std::optional<std::string>& cipher, const std::optional<std::shared_ptr<ArrayBuffer>>& passphrase) = 0;
      virtual JWK exportJwk(const JWK& key, bool handleRsaPss) = 0;
      virtual CFRGKeyPairType getAsymmetricKeyType() = 0;
      virtual bool init(KeyType keyType, const std::variant<std::string, std::shared_ptr<ArrayBuffer>>& key, std::optional<KFormatType> format, std::optional<KeyEncoding> type, const std::optional<std::shared_ptr<ArrayBuffer>>& passphrase) = 0;
      virtual bool initECRaw(const std::string& curveName, const std::shared_ptr<ArrayBuffer>& keyData) = 0;
      virtual std::optional<KeyType> initJwk(const JWK& keyData, std::optional<NamedCurve> namedCurve) = 0;
      virtual KeyDetail keyDetail() = 0;

    protected:
      // Hybrid Setup
      void loadHybridMethods() override;

    protected:
      // Tag for logging
      static constexpr auto TAG = "KeyObjectHandle";
  };

} // namespace margelo::nitro::crypto
