///
/// CFRGKeyPairType.hpp
/// This file was generated by nitrogen. DO NOT MODIFY THIS FILE.
/// https://github.com/mrousavy/nitro
/// Copyright © 2024 Marc Rousavy @ Margelo
///

#pragma once

#if __has_include(<NitroModules/NitroHash.hpp>)
#include <NitroModules/NitroHash.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif
#if __has_include(<NitroModules/JSIConverter.hpp>)
#include <NitroModules/JSIConverter.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif
#if __has_include(<NitroModules/NitroDefines.hpp>)
#include <NitroModules/NitroDefines.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif

namespace margelo::nitro::crypto {

  /**
   * An enum which can be represented as a JavaScript union (CFRGKeyPairType).
   */
  enum class CFRGKeyPairType {
    ED25519      SWIFT_NAME(ed25519) = 0,
    ED448      SWIFT_NAME(ed448) = 1,
    X25519      SWIFT_NAME(x25519) = 2,
    X448      SWIFT_NAME(x448) = 3,
  } CLOSED_ENUM;

} // namespace margelo::nitro::crypto

namespace margelo::nitro {

  using namespace margelo::nitro::crypto;

  // C++ CFRGKeyPairType <> JS CFRGKeyPairType (union)
  template <>
  struct JSIConverter<CFRGKeyPairType> {
    static inline CFRGKeyPairType fromJSI(jsi::Runtime& runtime, const jsi::Value& arg) {
      std::string unionValue = JSIConverter<std::string>::fromJSI(runtime, arg);
      switch (hashString(unionValue.c_str(), unionValue.size())) {
        case hashString("ed25519"): return CFRGKeyPairType::ED25519;
        case hashString("ed448"): return CFRGKeyPairType::ED448;
        case hashString("x25519"): return CFRGKeyPairType::X25519;
        case hashString("x448"): return CFRGKeyPairType::X448;
        default: [[unlikely]]
          throw std::invalid_argument("Cannot convert \"" + unionValue + "\" to enum CFRGKeyPairType - invalid value!");
      }
    }
    static inline jsi::Value toJSI(jsi::Runtime& runtime, CFRGKeyPairType arg) {
      switch (arg) {
        case CFRGKeyPairType::ED25519: return JSIConverter<std::string>::toJSI(runtime, "ed25519");
        case CFRGKeyPairType::ED448: return JSIConverter<std::string>::toJSI(runtime, "ed448");
        case CFRGKeyPairType::X25519: return JSIConverter<std::string>::toJSI(runtime, "x25519");
        case CFRGKeyPairType::X448: return JSIConverter<std::string>::toJSI(runtime, "x448");
        default: [[unlikely]]
          throw std::invalid_argument("Cannot convert CFRGKeyPairType to JS - invalid value: "
                                    + std::to_string(static_cast<int>(arg)) + "!");
      }
    }
    static inline bool canConvert(jsi::Runtime& runtime, const jsi::Value& value) {
      if (!value.isString()) {
        return false;
      }
      std::string unionValue = JSIConverter<std::string>::fromJSI(runtime, value);
      switch (hashString(unionValue.c_str(), unionValue.size())) {
        case hashString("ed25519"):
        case hashString("ed448"):
        case hashString("x25519"):
        case hashString("x448"):
          return true;
        default:
          return false;
      }
    }
  };

} // namespace margelo::nitro
