require "json"

package = JSON.parse(File.read(File.join(__dir__, "package.json")))

Pod::UI.puts "[QuickCrypto] crypto just got quicker 💨"

Pod::Spec.new do |s|
  s.name         = "QuickCrypto"
  s.version      = package["version"]
  s.summary      = package["description"]
  s.homepage     = package["homepage"]
  s.license      = package["license"]
  s.authors      = package["authors"]

  s.platforms    = { :ios => min_ios_version_supported }
  s.source       = { :git => "https://github.com/margelo/react-native-quick-crypto.git", :tag => "#{s.version}" }

  s.source_files = [
    # implementation (Swift)
    "ios/**/*.{swift}",
    # ios (Objective-C++)
    "ios/**/*.{h,m,mm}",
    # implementation (C++)
    "cpp/**/*.{hpp,cpp}",
    # dependencies (C++)
    "deps/**/*.{hpp,cpp}",
    # dependencies (C)
    "deps/**/*.{h,c}",
  ]

  # Add all files generated by Nitrogen
  load 'nitrogen/generated/ios/QuickCrypto+autolinking.rb'
  add_nitrogen_files(s)

  install_modules_dependencies(s)
  s.dependency "OpenSSL-Universal"

end
