<?php
namespace test;
require 'Phiber.php';
use bin\Restrictions;
use Exception;
use phiber\Phiber;

class User
{

    private $id;
    private $name;
    private $email;
    private $password;

    function get($prop)
    {
        return $this->$prop;
    }

    function set($prop, $value)
    {
        $this->$prop = $value;
    }

    public function validadeInfos()
    {
        if ($this->name != null && $this->name != "") {
            if ($this->email != null && $this->email != "") {
                if ($this->password != null && $this->password != "") {
                    return true;
                }
            }
        }
        return false;
    }

    public function create()
    {
        try {
            if ($this->validadeInfos()) {
                if (Phiber::openPersist()->create($this)) {
                    return json_encode(
                        [
                            "message" => "Success!!!",
                            "type_message" => "INFO"
                        ]
                    );
                } else {
                    return json_encode(
                        [
                            "message" => "Someting wrong happened",
                            "type_message" => "ERROR"
                        ]
                    );
                }
            } else {
                return json_encode(
                    [
                        "message" => "Invalid past values",
                        "type_message" => "ERROR"
                    ]
                );
            }

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function retrave()
    {
        $criteria = Phiber::openPersist();
        $restrictionName = "";
        $restrictionEmail = "";

        /* Here I created a retriction for each attribute */
        if ($this->name != null && $this->name != "") {
            $restrictionName = Restrictions::like("name", $this->name);
            $criteria->add($restrictionName);

        } else if ($this->email != null && $this->email != "") {
            $restrictionEmail = Restrictions::like("email", $this->email);
            $criteria->add($restrictionEmail);

        }
        /* And here I created a conjunction "AND" with the two restrictions*/
        $criteria->add(Restrictions::and($restrictionEmail,$restrictionName));
        return json_encode($criteria->select($this));
    }

    public function update()
    {
        try {
            $criteria = Phiber::openPersist();


            $criteria->add(Restrictions::eq("id", $this->id));
            /*  Here I added a condition "equal" in WHERE of the query.
                The responsible class that creates the query, will return something like this.
                Select from user where id = :condition_id;
                After that, it will be done the binding of values and will be substituted
                the ":condition_id" by your value.
                Read the API doc book to know more about restrictions.
            */

            if ($this->validadeInfos()) {
                if ($criteria->update($this)) {
                    return json_encode(
                        [
                            "message" => "Success!!!",
                            "type_message" => "INFO"
                        ]
                    );
                } else {
                    return json_encode(
                        [
                            "message" => "Someting wrong happened",
                            "type_message" => "ERROR"
                        ]
                    );
                }
            } else {
                return json_encode(
                    [
                        "message" => "Invalid past values",
                        "type_message" => "ERROR"
                    ]
                );
            }

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function delete()
    {
        $criteria = Phiber::openPersist();


        $criteria->add(Restrictions::eq("id", $this->id));
        /*  Here I added a condition "equal" in WHERE of the query.
            The responsible class that creates the query, will return something like this.
            Select from user where id = :condition_id;
            After that, it will be done the binding of values and will be substituted
            the ":condition_id" by your value.
            Read the API doc book to know more about restrictions.
        */

        if ($criteria->delete($this)) {
            return json_encode(
                [
                    "message" => "Success!!!",
                    "type_message" => "INFO"
                ]
            );
        } else {
            return json_encode(
                [
                    "message" => "Someting wrong happened",
                    "type_message" => "ERROR"
                ]
            );
        }
    }


}