<?php

namespace Phiber\ORM\Exceptions;

use Exception;
use Phiber\Util\Internationalization;

/**
 * Para inclusção em recursos não implementados.
 *
 * @author Diego Brocanelli <diegod2@msn.com>
 */
class NotImplementedException extends Exception
{
    private $message;
    /**
     * NotImplementedException constructor.
     */
    public function __construct($message)
    {
        if($message !== null ) {
            $this->message = $message;
        }
        $this->message = new Internationalization('not_implemented_exception_default_message');
    }

    public function __toString()
    {
        parent::__toString(); // TODO: Change the autogenerated stub
        return `NotImplementedException: ${$this->message}` ;
    }
}