Protocol Buffers for Delphi
===========================

Проект имеет краткое наименование protobuf-delphi и портировал некоторую часть кода проекта из Protocol Buffers for Java.
На тот момент времени, этот проект мне показался более ясным и чистым по сравнению с другими реализациями.

Почему появился этот проект
---------------------------

Когда Google выложил в opensource исходные тексты для Protocol Buffers.
Я был поражён идеями заложенными в нем, компактностью данных и его эффективностью, скоростью его обработки, особенно по сравнению с xml.

Первая версия порта на Delphi была подготовлена в 2007 году, в ходе выполнения проекта на моей основной работе.
Надо было передавать на клиентское приложение большую таблицу с данными. 
Эта операция выполнялась работала медленно. Была поставлена задача как то увеличить скорость работы и уменьшить объем трафика, отправляемого с сервера на клиентское приложение поверх https. 
До этого, для этих же целей использовался XML.

После завершения перехода на  формат данных Protocol Buffers стало возможно загрузить намного больший объём данных и значительно повысить производительность.

Довольно быстро был сделан порт на Delphi, ограниченный по функциональности.
Были реализованы низкоуровневые абстракции протокола, не было генерации кода.
Но это не мешало нам его использовать в веб-сервисах, и реализованной функциональности было достаточно для проекта.

Зная, структуру сообщения, можно было отправлять и получать данные по этому протоколу.
Год спустя я разместил код на сайте https://sourceforge.net/p/protobuf-delphi.

Другие приложения Protocol Buffers
----------------------------------

Вероятно многим покажется интересным, использование этого формата для хранения данных как на внешних носителях (диск, сеть) так и в оперативной памяти программы . 

Если знать особенности физического хранения данных в Protocol Buffers, можно реализовать интересные вещи. 

В начале записи есть поле хранящее длину записи. 
Также всегда можно пропустить ненужные поля записей.
В зависмости от типа они имеют либо фиксированную длину либо если поле имеет переменную длину, тогда в начале поля будет содержаться длина этого поля.
Поэтому записи легко отделить одну от другой, также иногда может быть полезным пропустить ненужную часть записи.

Данные в дереве можно проиндексировать например B-tree структурой или hashmap.
Это позволяет получить быстрый произвольный доступ по ключу к искомой записи.

Процесс чтения может быть применён к отдельной упакованной записи.

Данные в этом формате имеют значительной компрессию 
по сравнению обычным хранением объектов в памяти:
 - бинарные данные пишутся достаточно эффективно;
 - поля со значениями равными значению по умолчанию не пишутся;
 - к этой структуре, можно добавить словарь для часто используемых символьных значений.

У нас в проекте получалась значительная экономия расхода памяти 
по сравнению если хранить обычные объекты.
В некоторых случаях выигрыш был 20 и более раз.
Без потери скорости доступа к данным.
Это особенно полезно если данные являются immutable.

Похожие форматы используются для физического хранения данных в промышленных СУБД.

То есть в умелых руках этот формат данных является могучей вещью.

Немного истории
---------------

Кстати, конечно не всё в этом формате является изобретением Google.
Скорее мало что нового изобрели в Google.   

IMHO ноги растут из формата ASN.1. Когда я увидал документацию этого формата был поражён насколько они совпадают.

Наиболее важная заслуга Google в популяризации этого формата данных и в публикации исходного кода в opensource.

ASN.1 аналогичен по назначению и используется с protocol buffers и Apache Thrift, которые также являются языками описания интерфейса для кроссплатформенной сериализации данных. Как и эти языки, он имеет схему (в ASN.1 называемую "модулем") и набор кодировок, обычно тип-длина-значение кодировок. Однако ASN.1, определенный в 1984 г., предшествует им на многие годы. 
Он также включает в себя более широкий спектр базовых типов данных, некоторые из которых устарели, и имеет больше возможностей для расширения. Одно сообщение ASN.1 может включать данные из нескольких модулей, определенных в нескольких стандартах, и даже стандарты, определенные с интервалом в несколько лет.
