# Унифицированные метаданные

Основное назначение унифицированных метаданных обеспечить реализацию обобщённых 
коллекций, исключив раздувание кода и не теряя его эффективности. 
Для этого метаданные дополняются набором элементарных операций для некоторого типа. 
Элементарные операции используются при реализации коллекции.  
Цель этой работы: понять насколько это уменьшит раздувание кода, 
оценить эффективность полученного кода, его гибкость и удобство использования коллекциями. 
Мы продолжаем использовать типизированные регионы памяти.

## Задачи
 - Обеспечить описание: встроенных типов Дельфи, статический массив, кортеж.
 - Предполагается что типы данных статический массив и кортеж 
 может быть декларирован и создан во время исполнения программы «runtime». 
 - Определить состав и семантику элементарных операций для каждого типа данных
 - Структура должна быть пригодна как для встроенных типов Дельфи, 
 так и для типов структура которых декларируется и формируется в runtime.
 - Реализовать типизированный регион памяти с использованием унифицированных метаданных.

## Тип Дельфи
Для описания типа Дельфи используем стандартный механизм Typeinfo и Rtti.

## Кортеж
Кортеж — это конечная упорядоченная последовательность элементов произвольного типа. 
Многие языки программирования предлагают альтернативу кортежам, известным как типы записей, 
с неупорядоченными элементами, доступ, к которым осуществляется по имени поля. 
В случае кортежа доступ выполняется по порядковому номеру элемента. 
Основная причина использования кортежа, это желание работать с набором элементов произвольного 
типа в коллекциях. Когда у нас есть только метаданные и операции для отдельной компоненты типа 
и нет большого желания определять и реализовывать операции для производных типов.

## Статический массив
Статический массив – для его описания достаточно указать длину массива и тип элемента.
Доступ к элементу выполняется по индексу. 
Для единообразия индексация элементов начинается с 0. 
Элементом массива может быть любой тип, включая массив.

