# Кортеж

## Задачи
 - Определить семантику и операции для кортежа.
 - Реализовать структуры для работы с кортежами и их элементами.
 - Реализовать типизированный регион памяти для кортежей.

### Кортеж

Кортеж — это конечная упорядоченная последовательность элементов.
Многие языки программирования предлагают альтернативу кортежам, известным как типы записей, с неупорядоченными элементами, доступ, к которым осуществляется по имени поля.
Мы кортежи планируем помещать в типизированном регионе памяти.
```
TsgPair<T1, T2> = record
type
  PT1 = ^T1;
  PT2 = ^T2;
var
  Value: T1;
  Value: T2;
end;
```
Нежелательно явно декларировать такую структуру: если определить такую структуру,
мы столкнёмся с проблемами, связанными с расположением такой структуры в памяти.
Параметры структуры зависят от используемой модели памяти 32/64 bits и параметров выравнивания элементов кортежа в памяти.
Для работы с кортежами мы будем использовать метаданные. 
Метаданные для кортежа будут определены в runtime при инициализации кортежа.
```
  TsgTupleMeta = record
  const
    AllignTuple = sizeof(Pointer); // Align tuple to the word boundary
  var
    TypeInfo: Pointer;
    Size: Cardinal;    // Memory size
    Offset: Cardinal;  // The offset of an element in a tuple
    h: hMeta;
  public
    procedure Init<T>(Offset: Cardinal);
    // Determine the offset to the start of the next tuple.
    function NextTupleOffset(Allign: Boolean): Cardinal;
  end;
```
Работа с кортежами у нас будет через построитель кортежей, регион памяти и прокси объекты.
Построитель является посредником для работы с кортежами, размещёнными в регионе памяти.
В коде программы для манипуляций с кортежами мы будем пользоваться прокси объектами.
Прокси объект — это промежуточная структура, которая содержат ссылку на кортеж 
в регионе памяти и его метаданные.

### Операции для кортежа
 - `Init<T1, ...>` - создает прокси для работы с кортежём
 - `Free(TTuple)` - метод освобождения пямяти кортежа
 - `Assign(TTuple)` - присваивает содержимое одного кортежа другому
 - `Swap` - поменять местами содержимое двух кортежей
 - `Get(Index: Integer)` - вернуть ссылку на элемент кортежа
 - `Tie` - возвращает кортеж указателей на элементы кортежа

### Элемент кортежа
Каждый элемент кортежа имеет тип, размер и смещение в кортеже.
Тип определяет способ выполнения операций с элементом кортежа.
Размер и смещение нужны для организации доступа к элементу кортежа.

 - `procedure Assign(pvalue: PT1);` присвоить значение
 - `function GetPvalue: T1;`  вернуть ссылку на значение
