# Регион памяти

Данная реализация коллекций опирается на механизм управления памятью 
на основе типизированных регионов памяти. 
Регион памяти хранит объекты одного типа.

Управление с использованием типизированного региона памяти позволяет организовать 
выделение памяти группе объектов в пределах одного и более блоков памяти.
Каждый из блоков должен быть достаточно большим, чтобы внутри него можно было 
выделить память для многих объектов.

В конце использования, все выделенные объекты в одном регионе памяти, 
могут быть эффективно освобождены одной операцией.
Как и выделение стека, регионы памяти облегчают выделение и освобождение памяти 
с низкими накладными расходами; но они более гибкие, позволяя объектам жить дольше, 
чем кадр стека, в котором они были размещены.

У нас реализовано два варианта региона памяти.

## Непрерывный регион памяти
Все объекты в области выделяются в едином непрерывном диапазоне адресов памяти, 
аналогично тому, как обычно выделяются память для стека.
Атрибуты региона: тип, размер, емкость, количество выделенных элементов.
С учётом того что нам известен размер и тип элемента мы можем 
обращаться к объектам региона как к элементам массива используя индекс.
Объект (элемент) региона может быть перемещён.
Непрерывный регион используется для регулярных структур данных, 
таких как: массивы, стеки, магазин или очередь.

## Сегментированный регион памяти
Связанный список нескольких непрерывных регионов.
Сегментированный регион реализуется как связанный список больших блоков памяти; 
В структуре данных региона присутствует указатель на следующую свободную позицию 
внутри блока, и, если блок заполнен до конца, система управления памятью выделяет 
новый блок и добавляет его в список.
Атрибуты региона: тип, размер, ёмкость, количество выделенных элементов.
Элемент региона не может быть перемещён и обращение к нему выполняется по его адресу.
Сегментированный регион используется для динамических структур данных 
таких как: список, дерево или словарь.

## Непрерывный регион 
Операции: 
1. Добавить
2. Удалить
3. Присвоить
4. Очистить
5. Вернуть элемент по индексу
6. Обменять два элемента  
7. Сортировка

## Сегментированный регион памяти
Операции: 
1. Добавить
2. Удалить
3. Присвоить
4. Очистить
5. Вернуть элемент по его адресу

Функции:
1. Нотификация при выполнении операций
2. Проверка вхождения указателя в регион
3. Для объектов обеспечить поддержку OwnedObject
4. Повторное использование элементов региона
5. Счётчик элементов
6. Для сегмента памяти GetItemPtr(Index: Cardinal): Pointer;

## Метаданные
Типизированный регион содержит метаданные.
Метаданные содержат размер и набор булевских флагов и seed в упакованной записи.
```
hMeta = record
  TypeKind     5   System.TTypeKind 0..22
  Reserved     1
  ManagedType  1   Boolean -- управляемый тип
  HasWeakRef   1   Boolean -- тип содержит слабые ссылки
               8
  RangeCheck   1   Boolean -- проверять валидность индекса или указателя
  Notification 1   Boolean -- нотификация при выполнении операций 
  Owned        1   Boolean -- объекты принадлежат региону
  RemoveAction 2   TRemoveAction 0..2 -- поведение при удалении из коллекции
end;
```

В поле **seed** помещается константное значение и используется для индикации является ли эта структура валидной.
 
Поведение при удалении из коллекции.
```
TRemoveAction = (
  HoldValue = 0,  // удерживать значение элемента
  Clear = 1,      // очистить значение элемента
  Reuse = 2);     // очистить значение элемента и разрешить повторное использование
```