(* Standard Generic Library (SGL) for Pascal
 * Copyright (c) 2020 Marat Shaimardanov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *)

program SglTests;

{$IFDEF CONSOLE_TESTRUNNER}
{$APPTYPE CONSOLE}
{$ENDIF}

uses
  FastMM4,
  DUnitTestRunner,
  Oz.SGL.Heap in '..\src\Oz.SGL.Heap.pas',
  Oz.SGL.Collections in '..\src\Oz.SGL.Collections.pas',
  Oz.SGL.HandleManager in '..\src\Oz.SGL.HandleManager.pas',
  Oz.SGL.Hash in '..\src\Oz.SGL.Hash.pas',
  Oz.SGL.Utils in '..\src\Oz.SGL.Utils.pas',
  Oz.SGL.Test in 'Oz.SGL.Test.pas';

{$R *.RES}

begin
  DUnitTestRunner.RunRegisteredTests;
end.

