/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/// <amd-module name="@angular/compiler-cli/src/ngtsc/typecheck/src/api" />
import { BoundTarget, DirectiveMeta } from '@angular/compiler';
import * as ts from 'typescript';
import { Reference } from '../../metadata';
/**
 * Extension of `DirectiveMeta` that includes additional information required to type-check the
 * usage of a particular directive.
 */
export interface TypeCheckableDirectiveMeta extends DirectiveMeta {
    ref: Reference<ts.ClassDeclaration>;
    queries: string[];
    ngTemplateGuards: string[];
    hasNgTemplateContextGuard: boolean;
}
/**
 * Metadata required in addition to a component class in order to generate a type check block (TCB)
 * for that component.
 */
export interface TypeCheckBlockMetadata {
    /**
     * Semantic information about the template of the component.
     */
    boundTarget: BoundTarget<TypeCheckableDirectiveMeta>;
    /**
     * The name of the requested type check block function.
     */
    fnName: string;
}
export interface TypeCtorMetadata {
    /**
     * The name of the requested type constructor function.
     */
    fnName: string;
    /**
     * Whether to generate a body for the function or not.
     */
    body: boolean;
    /**
     * Input, output, and query field names in the type which should be included as constructor input.
     */
    fields: {
        inputs: string[];
        outputs: string[];
        queries: string[];
    };
}
