/*
 * jQuery Mobile Framework : "navbar" plugin
 * Copyright (c) jQuery Project
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 */

(function($, undefined) {

  $.widget("mobile.navbar", $.mobile.widget, {
    options: {
      iconpos: "top",
      grid: null,
      initSelector: ":jqmData(role='navbar')"
    },

    _create: function() {

      var $navbar = this.element,
              $navbtns = $navbar.find("a"),
              iconpos = $navbtns.filter(":jqmData(icon)").length ?
                      this.options.iconpos : undefined;

      $navbar.addClass("ui-navbar")
              .attr("role", "navigation")
              .find("ul")
              .grid({ grid: this.options.grid });

      if (!iconpos) {
        $navbar.addClass("ui-navbar-noicons");
      }

      $navbtns.buttonMarkup({
        corners:  false,
        shadow:    false,
        iconpos:  iconpos
      });

      $navbar.delegate("a", "vclick", function(event) {
        $navbtns.not(".ui-state-persist").removeClass($.mobile.activeBtnClass);
        $(this).addClass($.mobile.activeBtnClass);
      });
    }
  });

//auto self-init widgets
  $(document).bind("pagecreate create", function(e) {
    $($.mobile.navbar.prototype.options.initSelector, e.target).navbar();
  });

})(jQuery);
