/*
 * jQuery Mobile Framework : "listview" filter extension
 * Copyright (c) jQuery Project
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 */

(function($, undefined) {

  $.mobile.listview.prototype.options.filter = false;
  $.mobile.listview.prototype.options.filterPlaceholder = "Filter items...";
  $.mobile.listview.prototype.options.filterTheme = "c";
  $.mobile.listview.prototype.options.filterCallback = function(text, searchValue) {
    return text.toLowerCase().indexOf(searchValue) === -1;
  };

  $(":jqmData(role='listview')").live("listviewcreate", function() {

    var list = $(this),
            listview = list.data("listview");

    if (!listview.options.filter) {
      return;
    }

    var wrapper = $("<form>", {
      "class": "ui-listview-filter ui-bar-" + listview.options.filterTheme,
      "role": "search"
    }),
            search = $("<input>", {
              placeholder: listview.options.filterPlaceholder
            })
                    .attr("data-" + $.mobile.ns + "type", "search")
                    .jqmData("lastval", "")
                    .bind("keyup change", function() {

                      var $this = $(this),
                              val = this.value.toLowerCase(),
                              listItems = null,
                              lastval = $this.jqmData("lastval") + "",
                              childItems = false,
                              itemtext = "",
                              item, change;

                      // Change val as lastval for next execution
                      $this.jqmData("lastval", val);

                      change = val.replace(new RegExp("^" + lastval), "");

                      if (val.length < lastval.length || change.length != ( val.length - lastval.length )) {

                        // Removed chars or pasted something totaly different, check all items
                        listItems = list.children();
                      } else {

                        // Only chars added, not removed, only use visible subset
                        listItems = list.children(":not(.ui-screen-hidden)");
                      }

                      if (val) {

                        // This handles hiding regular rows without the text we search for
                        // and any list dividers without regular rows shown under it

                        for (var i = listItems.length - 1; i >= 0; i--) {
                          item = $(listItems[ i ]);
                          itemtext = item.jqmData("filtertext") || item.text();

                          if (item.is("li:jqmData(role=list-divider)")) {

                            item.toggleClass("ui-filter-hidequeue", !childItems);

                            // New bucket!
                            childItems = false;

                          } else if (listview.options.filterCallback(itemtext, val)) {

                            //mark to be hidden
                            item.toggleClass("ui-filter-hidequeue", true);
                          } else {

                            // There"s a shown item in the bucket
                            childItems = true;
                          }
                        }

                        // Show items, not marked to be hidden
                        listItems
                                .filter(":not(.ui-filter-hidequeue)")
                                .toggleClass("ui-screen-hidden", false);

                        // Hide items, marked to be hidden
                        listItems
                                .filter(".ui-filter-hidequeue")
                                .toggleClass("ui-screen-hidden", true)
                                .toggleClass("ui-filter-hidequeue", false);

                      } else {

                        //filtervalue is empty => show all
                        listItems.toggleClass("ui-screen-hidden", false);
                      }
                      listview._refreshCorners();
                    })
                    .appendTo(wrapper)
                    .textinput();

    if ($(this).jqmData("inset")) {
      wrapper.addClass("ui-listview-filter-inset");
    }

    wrapper.bind("submit", function() {
      return false;
    })
            .insertBefore(list);
  });

})(jQuery);