/*
 * jsTree hotkeys plugin
 * Enables keyboard navigation for all tree instances
 * Depends on the jstree ui & jquery hotkeys plugins
 */
(function ($) {
  var bound = [];

  function exec(i, event) {
    var f = $.jstree._focused(), tmp;
    if (f && f.data && f.data.hotkeys && f.data.hotkeys.enabled) {
      tmp = f._get_settings().hotkeys[i];
      if (tmp) {
        return tmp.call(f, event);
      }
    }
  }

  $.jstree.plugin("hotkeys", {
    __init : function () {
      if (typeof $.hotkeys === "undefined") {
        throw "jsTree hotkeys: jQuery hotkeys plugin not included.";
      }
      if (!this.data.ui) {
        throw "jsTree hotkeys: jsTree UI plugin not included.";
      }
      $.each(this._get_settings().hotkeys, function (i, v) {
        if (v !== false && $.inArray(i, bound) == -1) {
          $(document).bind("keydown", i, function (event) {
            return exec(i, event);
          });
          bound.push(i);
        }
      });
      this.get_container()
              .bind("lock.jstree", $.proxy(function () {
        if (this.data.hotkeys.enabled) {
          this.data.hotkeys.enabled = false;
          this.data.hotkeys.revert = true;
        }
      }, this))
              .bind("unlock.jstree", $.proxy(function () {
        if (this.data.hotkeys.revert) {
          this.data.hotkeys.enabled = true;
        }
      }, this));
      this.enable_hotkeys();
    },
    defaults : {
      "up" : function () {
        var o = this.data.ui.hovered || this.data.ui.last_selected || -1;
        this.hover_node(this._get_prev(o));
        return false;
      },
      "ctrl+up" : function () {
        var o = this.data.ui.hovered || this.data.ui.last_selected || -1;
        this.hover_node(this._get_prev(o));
        return false;
      },
      "shift+up" : function () {
        var o = this.data.ui.hovered || this.data.ui.last_selected || -1;
        this.hover_node(this._get_prev(o));
        return false;
      },
      "down" : function () {
        var o = this.data.ui.hovered || this.data.ui.last_selected || -1;
        this.hover_node(this._get_next(o));
        return false;
      },
      "ctrl+down" : function () {
        var o = this.data.ui.hovered || this.data.ui.last_selected || -1;
        this.hover_node(this._get_next(o));
        return false;
      },
      "shift+down" : function () {
        var o = this.data.ui.hovered || this.data.ui.last_selected || -1;
        this.hover_node(this._get_next(o));
        return false;
      },
      "left" : function () {
        var o = this.data.ui.hovered || this.data.ui.last_selected;
        if (o) {
          if (o.hasClass("jstree-open")) {
            this.close_node(o);
          }
          else {
            this.hover_node(this._get_prev(o));
          }
        }
        return false;
      },
      "ctrl+left" : function () {
        var o = this.data.ui.hovered || this.data.ui.last_selected;
        if (o) {
          if (o.hasClass("jstree-open")) {
            this.close_node(o);
          }
          else {
            this.hover_node(this._get_prev(o));
          }
        }
        return false;
      },
      "shift+left" : function () {
        var o = this.data.ui.hovered || this.data.ui.last_selected;
        if (o) {
          if (o.hasClass("jstree-open")) {
            this.close_node(o);
          }
          else {
            this.hover_node(this._get_prev(o));
          }
        }
        return false;
      },
      "right" : function () {
        var o = this.data.ui.hovered || this.data.ui.last_selected;
        if (o && o.length) {
          if (o.hasClass("jstree-closed")) {
            this.open_node(o);
          }
          else {
            this.hover_node(this._get_next(o));
          }
        }
        return false;
      },
      "ctrl+right" : function () {
        var o = this.data.ui.hovered || this.data.ui.last_selected;
        if (o && o.length) {
          if (o.hasClass("jstree-closed")) {
            this.open_node(o);
          }
          else {
            this.hover_node(this._get_next(o));
          }
        }
        return false;
      },
      "shift+right" : function () {
        var o = this.data.ui.hovered || this.data.ui.last_selected;
        if (o && o.length) {
          if (o.hasClass("jstree-closed")) {
            this.open_node(o);
          }
          else {
            this.hover_node(this._get_next(o));
          }
        }
        return false;
      },
      "space" : function () {
        if (this.data.ui.hovered) {
          this.data.ui.hovered.children("a:eq(0)").click();
        }
        return false;
      },
      "ctrl+space" : function (event) {
        event.type = "click";
        if (this.data.ui.hovered) {
          this.data.ui.hovered.children("a:eq(0)").trigger(event);
        }
        return false;
      },
      "shift+space" : function (event) {
        event.type = "click";
        if (this.data.ui.hovered) {
          this.data.ui.hovered.children("a:eq(0)").trigger(event);
        }
        return false;
      },
      "f2" : function () {
        this.rename(this.data.ui.hovered || this.data.ui.last_selected);
      },
      "del" : function () {
        this.remove(this.data.ui.hovered || this._get_node(null));
      }
    },
    _fn : {
      enable_hotkeys : function () {
        this.data.hotkeys.enabled = true;
      },
      disable_hotkeys : function () {
        this.data.hotkeys.enabled = false;
      }
    }
  });
})(jQuery);