/**
 * @license
 * jQuery Tools @VERSION Mousewheel
 *
 * NO COPYRIGHTS OR LICENSES. DO WHAT YOU LIKE.
 *
 * http://flowplayer.org/tools/toolbox/mousewheel.html
 *
 * based on jquery.event.wheel.js ~ rev 1 ~
 * Copyright (c) 2008, Three Dub Media
 * http://threedubmedia.com
 *
 * Since: Mar 2010
 * Date: @DATE
 */
(function($) {

  $.fn.mousewheel = function(fn) {
    return this[ fn ? "bind" : "trigger" ]("wheel", fn);
  };

  // special event config
  $.event.special.wheel = {
    setup: function() {
      $.event.add(this, wheelEvents, wheelHandler, {});
    },
    teardown: function() {
      $.event.remove(this, wheelEvents, wheelHandler);
    }
  };

  // events to bind ( browser sniffed... )
  var wheelEvents = !$.browser.mozilla ? "mousewheel" : // IE, opera, safari
          "DOMMouseScroll" + ( $.browser.version < "1.9" ? " mousemove" : "" ); // firefox

  // shared event handler
  function wheelHandler(event) {

    switch (event.type) {

      // FF2 has incorrect event positions
      case "mousemove":
        return $.extend(event.data, { // store the correct properties
          clientX: event.clientX, clientY: event.clientY,
          pageX: event.pageX, pageY: event.pageY
        });

      // firefox
      case "DOMMouseScroll":
        $.extend(event, event.data); // fix event properties in FF2
        event.delta = -event.detail / 3; // normalize delta
        break;

      // IE, opera, safari
      case "mousewheel":
        event.delta = event.wheelDelta / 120;
        break;
    }

    event.type = "wheel"; // hijack the event
    return $.event.handle.call(this, event, event.delta);
  }

})(jQuery); 

