//>>excludeStart("jqmBuildExclude", pragmas.jqmBuildExclude);
//>>description: Extends the table widget to reflow on narrower screens
//>>label: Table: reflow
//>>group: Widgets
//>>css.structure: ../css/structure/jquery.mobile.table.reflow.css


define( [ "jquery", "./table" ], function( jQuery ) {
//>>excludeEnd("jqmBuildExclude");
(function( $, undefined ) {

$.mobile.table.prototype.options.mode = "reflow";

$.mobile.table.prototype.options.classes = $.extend(
  $.mobile.table.prototype.options.classes,
  {
    reflowTable: "ui-table-reflow",
    cellLabels: "ui-table-cell-label"
  }
);

$.mobile.document.delegate( ":jqmData(role='table')", "tablecreate tableupdate", function( e ) {

  var $table = $( this ),
    event = e.type,
    self = $table.data( "mobile-table" ),
    o = self.options;
  // If it's not reflow mode, return here.
  if( o.mode !== "reflow" ){
    return;
  }
  if ( o.eventsOnly !== false ){
    if (event !== "tableupdate") {
      self.element.addClass( o.classes.reflowTable );
    }
    // get headers in reverse order so that top-level headers are appended last
    var reverseHeaders =  $( self.allHeaders.get().reverse() );
    // create the hide/show toggles
    reverseHeaders.each(function(i){
      var $cells = $( this ).jqmData( "cells" ),
        colstart = $( this ).jqmData( "colstart" ),
        hierarchyClass = $cells.not( this ).filter( "thead th" ).length && " ui-table-cell-label-top",
        text = $(this).text();

        if( text !== ""  ){

          if( hierarchyClass ){
            var iteration = parseInt( $( this ).attr( "colspan" ), 10 ),
              filter = "";

            if( iteration ){
              filter = "td:nth-child("+ iteration +"n + " + ( colstart ) +")";
            }
            $cells.filter( filter ).prepend( "<b class='" + o.classes.cellLabels + hierarchyClass + "'>" + text + "</b>"  );
          }
          else {
            $cells.prepend( "<b class='" + o.classes.cellLabels + "'>" + text + "</b>"  );
          }

        }
    });
  }
});

})( jQuery );
//>>excludeStart("jqmBuildExclude", pragmas.jqmBuildExclude);
});
//>>excludeEnd("jqmBuildExclude");