/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.image;

import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.datatype.CoordTransform;
import com.flagstone.transform.datatype.HorizontalAlign;
import com.flagstone.transform.datatype.VerticalAlign;
import com.flagstone.transform.fillstyle.BitmapFill;
import com.flagstone.transform.fillstyle.FillStyle;
import com.flagstone.transform.image.ImageTag;
import com.flagstone.transform.linestyle.LineStyle;
import com.flagstone.transform.linestyle.LineStyle1;
import com.flagstone.transform.linestyle.LineStyle2;
import com.flagstone.transform.shape.DefineShape3;
import com.flagstone.transform.shape.DefineShape4;
import com.flagstone.transform.shape.Line;
import com.flagstone.transform.shape.Shape;
import com.flagstone.transform.shape.ShapeRecord;
import com.flagstone.transform.shape.ShapeStyle;
import com.flagstone.transform.shape.ShapeStyle2;
import com.flagstone.transform.shape.ShapeTag;
import java.util.ArrayList;

public final class ImageShape {
    private static final int TWIPS_PER_PIXEL = 20;
    private transient HorizontalAlign xAlign;
    private transient VerticalAlign yAlign;
    private transient LineStyle style;

    public void setStyle(LineStyle lineStyle) {
        this.style = (LineStyle)lineStyle.copy();
    }

    public void setRegistration(HorizontalAlign halign, VerticalAlign valign) {
        this.xAlign = halign;
        this.yAlign = valign;
    }

    public ShapeTag defineShape(int uid, ImageTag image) {
        int xOffset = this.xAlign == HorizontalAlign.LEFT ? -(image.getWidth() >> 2) : (this.xAlign == HorizontalAlign.RIGHT ? image.getWidth() >> 2 : 0);
        int yOffset = this.yAlign == VerticalAlign.TOP ? -(image.getHeight() >> 2) : (this.yAlign == VerticalAlign.BOTTOM ? image.getHeight() >> 2 : 0);
        return this.defineShape(uid, image, xOffset, yOffset, this.style);
    }

    public ShapeTag defineShape(int uid, ImageTag image, int xOrigin, int yOrigin, LineStyle border) {
        ShapeTag definition;
        Bounds bounds = this.getBounds(xOrigin, yOrigin, image.getWidth(), image.getHeight(), border);
        Shape shape = this.getShape(xOrigin, yOrigin, image.getWidth(), image.getHeight(), border);
        if (border == null || border instanceof LineStyle1) {
            definition = new DefineShape3(uid, bounds, new ArrayList<FillStyle>(), new ArrayList<LineStyle>(), shape);
        } else {
            Bounds edges = this.getEdges(xOrigin, yOrigin, image.getWidth(), image.getHeight());
            definition = new DefineShape4(uid, bounds, edges, new ArrayList<FillStyle>(), new ArrayList<LineStyle>(), shape);
        }
        if (border != null) {
            definition.add(border);
        }
        definition.add(this.getFillStyle(image.getIdentifier(), xOrigin, yOrigin));
        return definition;
    }

    private Bounds getBounds(int xOrigin, int yOrigin, int width, int height, LineStyle border) {
        int lineWidth = border instanceof LineStyle1 ? ((LineStyle1)border).getWidth() / 2 : (border instanceof LineStyle2 ? ((LineStyle2)border).getWidth() / 2 : 0);
        Bounds bounds = new Bounds(-xOrigin * 20 - lineWidth, -yOrigin * 20 - lineWidth, (width - xOrigin) * 20 + lineWidth, (height - yOrigin) * 20 + lineWidth);
        return bounds;
    }

    private Bounds getEdges(int xOrigin, int yOrigin, int width, int height) {
        return new Bounds(-xOrigin * 20, -yOrigin * 20, (width - xOrigin) * 20, (height - yOrigin) * 20);
    }

    private Shape getShape(int xOrigin, int yOrigin, int width, int height, LineStyle border) {
        Shape shape = new Shape(new ArrayList<ShapeRecord>());
        if (this.style instanceof LineStyle2) {
            ShapeStyle2 shapeStyle = new ShapeStyle2();
            shapeStyle.setLineStyle(1);
            shapeStyle.setFillStyle(1);
            shapeStyle.setMove(-xOrigin * 20, -yOrigin * 20);
            shape.add(shapeStyle);
        } else {
            ShapeStyle shapeStyle = new ShapeStyle();
            shapeStyle.setLineStyle(border == null ? 0 : 1);
            shapeStyle.setFillStyle(1);
            shapeStyle.setMove(-xOrigin * 20, -yOrigin * 20);
            shape.add(shapeStyle);
        }
        shape.add(new Line(width * 20, 0));
        shape.add(new Line(0, height * 20));
        shape.add(new Line(-width * 20, 0));
        shape.add(new Line(0, -height * 20));
        return shape;
    }

    private FillStyle getFillStyle(int uid, int xOrigin, int yOrigin) {
        CoordTransform transform = new CoordTransform(20.0f, 20.0f, 0.0f, 0.0f, -xOrigin * 20, -yOrigin * 20);
        return new BitmapFill(false, false, uid, transform);
    }
}

