/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.text;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class TextSettings
implements MovieTag {
    private static final String FORMAT = "TextSettings: { identifier=%d; useAdvanced=%s; grid=%s; thickness=%f; sharpness=%f}";
    private transient int identifier;
    private transient int rendering;
    private transient int thickness;
    private transient int sharpness;

    public TextSettings(SWFDecoder coder) throws IOException {
        if ((coder.readUnsignedShort() & 0x3F) == 63) {
            coder.readInt();
        }
        this.identifier = coder.readUnsignedShort();
        this.rendering = coder.readByte();
        this.thickness = coder.readInt();
        this.sharpness = coder.readInt();
        coder.readByte();
    }

    public TextSettings(int uid, boolean advanced, Grid grid, float thick, float sharp) {
        this.setIdentifier(uid);
        this.useAdvanced(advanced);
        this.setGrid(grid);
        this.setThickness(thick);
        this.setSharpness(sharp);
    }

    public TextSettings(TextSettings object) {
        this.identifier = object.identifier;
        this.rendering = object.rendering;
        this.thickness = object.thickness;
        this.sharpness = object.sharpness;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public boolean useAdvanced() {
        return (this.rendering & 0x40) != 0;
    }

    public void useAdvanced(boolean flag) {
        this.rendering |= 0x40;
    }

    public Grid getGrid() {
        Grid alignment = (this.rendering & 0x10) > 0 ? Grid.SUBPIXEL : ((this.rendering & 8) > 0 ? Grid.PIXEL : Grid.NONE);
        return alignment;
    }

    public void setGrid(Grid alignment) {
        this.rendering &= 0xFFFFFF87;
        switch (alignment) {
            case PIXEL: {
                this.rendering |= 8;
                break;
            }
            case SUBPIXEL: {
                this.rendering |= 0x10;
                break;
            }
        }
    }

    public float getThickness() {
        return Float.intBitsToFloat(this.thickness);
    }

    public void setThickness(float level) {
        this.thickness = Float.floatToIntBits(level);
    }

    public float getSharpness() {
        return Float.intBitsToFloat(this.sharpness);
    }

    public void setSharpness(float level) {
        this.sharpness = Float.floatToIntBits(level);
    }

    @Override
    public TextSettings copy() {
        return new TextSettings(this);
    }

    public String toString() {
        return String.format(FORMAT, new Object[]{this.identifier, String.valueOf(this.useAdvanced()), this.getGrid(), Float.valueOf((float)this.thickness / 65536.0f), Float.valueOf((float)this.sharpness / 65536.0f)});
    }

    @Override
    public int prepareToEncode(Context context) {
        return 14;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeShort(4748);
        coder.writeShort(this.identifier);
        coder.writeByte(this.rendering);
        coder.writeInt(this.thickness);
        coder.writeInt(this.sharpness);
        coder.writeByte(0);
    }

    public static enum Grid {
        NONE,
        PIXEL,
        SUBPIXEL;

    }
}

