/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.shape;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.Copyable;
import com.flagstone.transform.coder.DecoderRegistry;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncodeable;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.shape.ShapeData;
import com.flagstone.transform.shape.ShapeRecord;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Shape
implements SWFEncodeable,
Copyable<Shape> {
    public static final int MIN_COORD = -65536;
    public static final int MAX_COORD = 65535;
    private static final String FORMAT = "Shape: { records=%s}";
    private List<ShapeRecord> objects;
    private transient boolean isEncoded;

    public static Shape shapeFromData(ShapeData shapeData) throws IOException {
        byte[] data = shapeData.getData();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        SWFDecoder coder = new SWFDecoder(stream);
        Context context = new Context();
        context.setRegistry(DecoderRegistry.getDefault());
        context.put(2, 2);
        return new Shape(coder, context);
    }

    public Shape(SWFDecoder coder, Context context) throws IOException {
        this.objects = new ArrayList<ShapeRecord>();
        int sizes = coder.readByte();
        context.put(11, (sizes & 0xF0) >> 4);
        context.put(12, sizes & 0xF);
        SWFFactory<ShapeRecord> decoder = context.getRegistry().getShapeDecoder();
        while (coder.scanBits(6, false) != 0) {
            decoder.getObject(this.objects, coder, context);
        }
        coder.readBits(6, false);
        coder.alignToByte();
    }

    public Shape() {
        this.objects = new ArrayList<ShapeRecord>();
    }

    public Shape(List<ShapeRecord> list) {
        this.setObjects(list);
    }

    public Shape(Shape object) {
        this.objects = new ArrayList<ShapeRecord>(object.objects.size());
        for (ShapeRecord record : object.objects) {
            this.objects.add((ShapeRecord)record.copy());
        }
    }

    public Shape add(ShapeRecord anObject) {
        if (anObject == null) {
            throw new IllegalArgumentException();
        }
        this.objects.add(anObject);
        return this;
    }

    public List<ShapeRecord> getObjects() {
        return this.objects;
    }

    public void setObjects(List<ShapeRecord> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.objects = list;
    }

    @Override
    public Shape copy() {
        return new Shape(this);
    }

    public String toString() {
        return String.format(FORMAT, this.objects);
    }

    @Override
    public int prepareToEncode(Context context) {
        int length = 0;
        boolean bl = this.isEncoded = this.objects.size() == 1 && this.objects.get(0) instanceof ShapeData;
        if (this.isEncoded) {
            length += this.objects.get(0).prepareToEncode(context);
        } else {
            context.put(15, 0);
            int numberOfBits = 21;
            for (ShapeRecord record : this.objects) {
                numberOfBits += record.prepareToEncode(context);
            }
            length += numberOfBits >>> 3;
        }
        return length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.isEncoded) {
            this.objects.get(0).encode(coder, context);
        } else {
            int bits = context.get(11) << 4;
            coder.writeByte(bits |= context.get(12).intValue());
            for (ShapeRecord record : this.objects) {
                record.encode(coder, context);
            }
            coder.writeBits(0, 6);
            coder.alignToByte();
        }
    }
}

