/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.shape;

import com.flagstone.transform.coder.Coder;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.shape.ShapeRecord;
import java.io.IOException;

public final class Line
implements ShapeRecord {
    private static final String FORMAT = "Line: (%d, %d)";
    private transient int xCoord;
    private transient int yCoord;
    private transient boolean vertical;
    private transient boolean general;
    private transient int size;

    public Line(SWFDecoder coder) throws IOException {
        this.size = coder.readBits(4, false) + 2;
        if (coder.readBits(1, false) == 0) {
            if (coder.readBits(1, false) == 0) {
                this.xCoord = coder.readBits(this.size, true);
                this.yCoord = 0;
            } else {
                this.xCoord = 0;
                this.yCoord = coder.readBits(this.size, true);
            }
        } else {
            this.xCoord = coder.readBits(this.size, true);
            this.yCoord = coder.readBits(this.size, true);
        }
    }

    public Line(int coordX, int coordY) {
        this.setPoint(coordX, coordY);
    }

    public Line(Line object) {
        this.xCoord = object.xCoord;
        this.yCoord = object.yCoord;
    }

    public int getX() {
        return this.xCoord;
    }

    public int getY() {
        return this.yCoord;
    }

    public void setPoint(int coordX, int coordY) {
        if (coordX < -65536 || coordX > 65535) {
            throw new IllegalArgumentRangeException(-65536, 65535, coordX);
        }
        this.xCoord = coordX;
        if (coordY < -65536 || coordY > 65535) {
            throw new IllegalArgumentRangeException(-65536, 65535, coordY);
        }
        this.yCoord = coordY;
    }

    @Override
    public Line copy() {
        return new Line(this);
    }

    public String toString() {
        return String.format(FORMAT, this.xCoord, this.yCoord);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.vertical = this.xCoord == 0;
        this.general = this.xCoord != 0 && this.yCoord != 0;
        this.size = Coder.maxSize(this.xCoord, this.yCoord, 1);
        int numberOfBits = 7;
        numberOfBits = this.general ? (numberOfBits += this.size << 1) : (numberOfBits += 1 + this.size);
        context.put(15, context.get(15) + numberOfBits);
        return numberOfBits;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeBits(3, 2);
        coder.writeBits(this.size - 2, 4);
        coder.writeBits(this.general ? 1 : 0, 1);
        if (this.general) {
            coder.writeBits(this.xCoord, this.size);
            coder.writeBits(this.yCoord, this.size);
        } else {
            coder.writeBits(this.vertical ? 1 : 0, 1);
            coder.writeBits(this.vertical ? this.yCoord : this.xCoord, this.size);
        }
    }
}

