/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.shape;

import com.flagstone.transform.coder.Coder;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.fillstyle.FillStyle;
import com.flagstone.transform.linestyle.LineStyle;
import com.flagstone.transform.linestyle.LineStyle1;
import com.flagstone.transform.linestyle.LineStyle2;
import com.flagstone.transform.shape.Shape;
import com.flagstone.transform.shape.ShapeData;
import com.flagstone.transform.shape.ShapeTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DefineShape
implements ShapeTag {
    private static final String FORMAT = "DefineShape: { identifier=%d; bounds=%s; fillStyles=%s; lineStyles=%s; shape=%s}";
    private int identifier;
    private Bounds bounds;
    private List<FillStyle> fillStyles;
    private List<LineStyle> lineStyles;
    private Shape shape;
    private transient int length;
    private transient int fillBits;
    private transient int lineBits;

    public DefineShape(SWFDecoder coder, Context context) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        this.bounds = new Bounds(coder);
        this.fillStyles = new ArrayList<FillStyle>();
        this.lineStyles = new ArrayList<LineStyle>();
        context.put(2, 2);
        int fillStyleCount = coder.readByte();
        SWFFactory<FillStyle> decoder = context.getRegistry().getFillStyleDecoder();
        for (int i = 0; i < fillStyleCount; ++i) {
            decoder.getObject(this.fillStyles, coder, context);
        }
        int lineStyleCount = coder.readByte();
        for (int i = 0; i < lineStyleCount; ++i) {
            this.lineStyles.add(new LineStyle1(coder, context));
        }
        if (context.getRegistry().getShapeDecoder() == null) {
            this.shape = new Shape();
            this.shape.add(new ShapeData(this.length - coder.bytesRead(), coder));
        } else {
            this.shape = new Shape(coder, context);
        }
        context.remove(2);
        coder.check(this.length);
        coder.unmark();
    }

    public DefineShape(int uid, Bounds rect, List<FillStyle> fills, List<LineStyle> lines, Shape aShape) {
        this.setIdentifier(uid);
        this.setBounds(rect);
        this.setFillStyles(fills);
        this.setLineStyles(lines);
        this.setShape(aShape);
    }

    public DefineShape(DefineShape object) {
        this.identifier = object.identifier;
        this.bounds = object.bounds;
        this.fillStyles = new ArrayList<FillStyle>(object.fillStyles.size());
        for (FillStyle fillStyle : object.fillStyles) {
            this.fillStyles.add((FillStyle)fillStyle.copy());
        }
        this.lineStyles = new ArrayList<LineStyle>(object.lineStyles.size());
        for (LineStyle lineStyle : object.lineStyles) {
            this.lineStyles.add((LineStyle)lineStyle.copy());
        }
        this.shape = object.shape.copy();
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    @Override
    public DefineShape add(LineStyle style) {
        if (style == null || style instanceof LineStyle2) {
            throw new IllegalArgumentException();
        }
        this.lineStyles.add(style);
        return this;
    }

    @Override
    public DefineShape add(FillStyle style) {
        if (style == null) {
            throw new IllegalArgumentException();
        }
        this.fillStyles.add(style);
        return this;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public List<FillStyle> getFillStyles() {
        return this.fillStyles;
    }

    @Override
    public List<LineStyle> getLineStyles() {
        return this.lineStyles;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public void setBounds(Bounds rect) {
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        this.bounds = rect;
    }

    @Override
    public void setFillStyles(List<FillStyle> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.fillStyles = list;
    }

    @Override
    public void setLineStyles(List<LineStyle> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.lineStyles = list;
    }

    @Override
    public void setShape(Shape aShape) {
        if (aShape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = aShape;
    }

    @Override
    public DefineShape copy() {
        return new DefineShape(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.bounds, this.fillStyles, this.lineStyles, this.shape);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.fillBits = Coder.unsignedSize(this.fillStyles.size());
        this.lineBits = Coder.unsignedSize(this.lineStyles.size());
        if (context.contains(9)) {
            if (this.fillBits == 0) {
                this.fillBits = 1;
            }
            if (this.lineBits == 0) {
                this.lineBits = 1;
            }
        }
        this.length = 2 + this.bounds.prepareToEncode(context);
        ++this.length;
        for (FillStyle fillStyle : this.fillStyles) {
            this.length += fillStyle.prepareToEncode(context);
        }
        ++this.length;
        for (LineStyle lineStyle : this.lineStyles) {
            this.length += lineStyle.prepareToEncode(context);
        }
        context.put(11, this.fillBits);
        context.put(12, this.lineBits);
        this.length += this.shape.prepareToEncode(context);
        context.put(11, 0);
        context.put(12, 0);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(191);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x80 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        this.bounds.encode(coder, context);
        coder.writeByte(this.fillStyles.size());
        for (FillStyle fillStyle : this.fillStyles) {
            fillStyle.encode(coder, context);
        }
        coder.writeByte(this.lineStyles.size());
        for (LineStyle lineStyle : this.lineStyles) {
            lineStyle.encode(coder, context);
        }
        context.put(11, this.fillBits);
        context.put(12, this.lineBits);
        this.shape.encode(coder, context);
        context.put(11, 0);
        context.put(12, 0);
        coder.check(this.length);
        coder.unmark();
    }
}

