/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.font;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.font.GlyphAlignment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class FontAlignment
implements MovieTag {
    private static final String FORMAT = "FontAlignment: { identifier=%d; strokeWidth=%s; zones=%s}";
    private int identifier;
    private transient int hints;
    private List<GlyphAlignment> zones;
    private transient int length;

    public FontAlignment(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        this.hints = coder.readByte();
        this.zones = new ArrayList<GlyphAlignment>();
        while (coder.bytesRead() < this.length) {
            this.zones.add(new GlyphAlignment(coder));
        }
        coder.check(this.length);
        coder.unmark();
    }

    public FontAlignment(int uid, StrokeWidth stroke, List<GlyphAlignment> list) {
        this.setIdentifier(uid);
        this.setStrokeWidth(stroke);
        this.setZones(list);
    }

    public FontAlignment(FontAlignment object) {
        this.identifier = object.identifier;
        this.hints = object.hints;
        this.zones = new ArrayList<GlyphAlignment>(object.zones);
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public StrokeWidth getStrokeWidth() {
        StrokeWidth stroke;
        switch (this.hints) {
            case 64: {
                stroke = StrokeWidth.MEDIUM;
                break;
            }
            case 128: {
                stroke = StrokeWidth.THICK;
                break;
            }
            default: {
                stroke = StrokeWidth.THIN;
            }
        }
        return stroke;
    }

    public void setStrokeWidth(StrokeWidth stroke) {
        switch (stroke) {
            case MEDIUM: {
                this.hints = 64;
                break;
            }
            case THICK: {
                this.hints = 128;
                break;
            }
            default: {
                this.hints = 0;
            }
        }
    }

    public List<GlyphAlignment> getZones() {
        return this.zones;
    }

    public void setZones(List<GlyphAlignment> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.zones = list;
    }

    public FontAlignment addZone(GlyphAlignment zone) {
        if (zone == null) {
            throw new IllegalArgumentException();
        }
        this.zones.add(zone);
        return this;
    }

    @Override
    public FontAlignment copy() {
        return new FontAlignment(this);
    }

    public String toString() {
        return String.format(FORMAT, new Object[]{this.identifier, this.getStrokeWidth(), this.zones});
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 3;
        for (GlyphAlignment zone : this.zones) {
            this.length += zone.prepareToEncode(context);
        }
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(4735);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x1240 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        coder.writeByte(this.hints);
        for (GlyphAlignment zone : this.zones) {
            zone.encode(coder, context);
        }
        coder.check(this.length);
        coder.unmark();
    }

    public static enum StrokeWidth {
        THIN,
        MEDIUM,
        THICK;

    }
}

