/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.fillstyle;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.CoordTransform;
import com.flagstone.transform.fillstyle.FillStyle;
import com.flagstone.transform.fillstyle.GradientType;
import com.flagstone.transform.fillstyle.MorphGradient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class MorphGradientFill
implements FillStyle {
    private static final String FORMAT = "MorphGradientFill: { start=%s; end=%s; gradients=%s}";
    private int type;
    private CoordTransform startTransform;
    private CoordTransform endTransform;
    private List<MorphGradient> gradients;
    private transient int count;

    public MorphGradientFill(int fillType, SWFDecoder coder, Context context) throws IOException {
        this.type = fillType;
        this.startTransform = new CoordTransform(coder);
        this.endTransform = new CoordTransform(coder);
        this.count = coder.readByte() & 0xF;
        this.gradients = new ArrayList<MorphGradient>(this.count);
        for (int i = 0; i < this.count; ++i) {
            this.gradients.add(new MorphGradient(coder, context));
        }
    }

    public MorphGradientFill(GradientType gradientType, CoordTransform start, CoordTransform end, List<MorphGradient> grads) {
        this.setType(gradientType);
        this.setStartTransform(start);
        this.setEndTransform(end);
        this.setGradients(grads);
    }

    public MorphGradientFill(MorphGradientFill object) {
        this.type = object.type;
        this.startTransform = object.startTransform;
        this.endTransform = object.endTransform;
        this.gradients = new ArrayList<MorphGradient>(object.gradients.size());
        for (MorphGradient gradient : object.gradients) {
            this.gradients.add(gradient.copy());
        }
    }

    public MorphGradientFill add(MorphGradient aGradient) {
        if (aGradient == null) {
            throw new IllegalArgumentException();
        }
        if (this.gradients.size() == 15) {
            throw new IllegalStateException("Maximum number of gradients exceeded.");
        }
        this.gradients.add(aGradient);
        return this;
    }

    public GradientType getType() {
        GradientType value = this.type == 16 ? GradientType.LINEAR : GradientType.RADIAL;
        return value;
    }

    public void setType(GradientType gradientType) {
        this.type = gradientType == GradientType.LINEAR ? 16 : 18;
    }

    public CoordTransform getStartTransform() {
        return this.startTransform;
    }

    public CoordTransform getEndTransform() {
        return this.endTransform;
    }

    public List<MorphGradient> getGradients() {
        return this.gradients;
    }

    public void setStartTransform(CoordTransform matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException();
        }
        this.startTransform = matrix;
    }

    public void setEndTransform(CoordTransform matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException();
        }
        this.endTransform = matrix;
    }

    public void setGradients(List<MorphGradient> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        if (list.size() > 15) {
            throw new IllegalStateException("Maximum number of gradients exceeded.");
        }
        this.gradients = list;
    }

    @Override
    public MorphGradientFill copy() {
        return new MorphGradientFill(this);
    }

    public String toString() {
        return String.format(FORMAT, this.startTransform, this.endTransform, this.gradients);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.count = this.gradients.size();
        return 2 + this.startTransform.prepareToEncode(context) + this.endTransform.prepareToEncode(context) + this.count * 10;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(this.type);
        this.startTransform.encode(coder, context);
        this.endTransform.encode(coder, context);
        coder.writeByte(this.count);
        for (MorphGradient gradient : this.gradients) {
            gradient.encode(coder, context);
        }
    }
}

