/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.fillstyle;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.CoordTransform;
import com.flagstone.transform.fillstyle.FillStyle;
import com.flagstone.transform.fillstyle.Gradient;
import com.flagstone.transform.fillstyle.GradientType;
import com.flagstone.transform.fillstyle.Interpolation;
import com.flagstone.transform.fillstyle.Spread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class GradientFill
implements FillStyle {
    private static final int SPREAD_MASK = 192;
    private static final int INTER_MASK = 48;
    private static final int GRADIENT_MASK = 15;
    private static final String FORMAT = "GradientFill: { transform=%s; gradients=%s}";
    private transient int type;
    private int spread;
    private int interpolation;
    private CoordTransform transform;
    private List<Gradient> gradients;
    private transient int count;

    public GradientFill(int fillType, SWFDecoder coder, Context context) throws IOException {
        this.type = fillType;
        this.transform = new CoordTransform(coder);
        this.count = coder.readByte();
        this.spread = this.count & 0xC0;
        this.interpolation = this.count & 0x30;
        this.count &= 0xF;
        this.gradients = new ArrayList<Gradient>(this.count);
        for (int i = 0; i < this.count; ++i) {
            this.gradients.add(new Gradient(coder, context));
        }
    }

    public GradientFill(GradientType gradientType, CoordTransform matrix, List<Gradient> list) {
        this.setType(gradientType);
        this.setTransform(matrix);
        this.setGradients(list);
    }

    public GradientFill(GradientType gradientType, CoordTransform matrix, Spread spreadType, Interpolation interpolationType, List<Gradient> list) {
        this.setType(gradientType);
        this.setTransform(matrix);
        this.setSpread(spreadType);
        this.setInterpolation(interpolationType);
        this.setGradients(list);
    }

    public GradientFill(GradientFill object) {
        this.type = object.type;
        this.transform = object.transform;
        this.gradients = new ArrayList<Gradient>(object.gradients);
    }

    public GradientType getType() {
        GradientType value = this.type == 16 ? GradientType.LINEAR : GradientType.RADIAL;
        return value;
    }

    public void setType(GradientType gradientType) {
        this.type = gradientType == GradientType.LINEAR ? 16 : 18;
    }

    public Spread getSpread() {
        return Spread.fromInt(this.spread);
    }

    public void setSpread(Spread spreadType) {
        this.spread = spreadType.getValue();
    }

    public Interpolation getInterpolation() {
        return Interpolation.fromInt(this.interpolation);
    }

    public void setInterpolation(Interpolation interpolationType) {
        this.interpolation = interpolationType.getValue();
    }

    public CoordTransform getTransform() {
        return this.transform;
    }

    public List<Gradient> getGradients() {
        return this.gradients;
    }

    public void setTransform(CoordTransform matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException();
        }
        this.transform = matrix;
    }

    public void setGradients(List<Gradient> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        if (list.size() > 15) {
            throw new IllegalStateException("Maximum number of gradients exceeded.");
        }
        this.gradients = list;
    }

    public GradientFill add(Gradient aGradient) {
        if (aGradient == null) {
            throw new IllegalArgumentException();
        }
        if (this.gradients.size() == 15) {
            throw new IllegalStateException("Maximum number of gradients exceeded.");
        }
        this.gradients.add(aGradient);
        return this;
    }

    @Override
    public GradientFill copy() {
        return new GradientFill(this);
    }

    public String toString() {
        return String.format(FORMAT, this.transform, this.gradients);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.count = this.gradients.size();
        return 2 + this.transform.prepareToEncode(context) + this.count * (context.contains(3) ? 5 : 4);
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(this.type);
        this.transform.encode(coder, context);
        coder.writeByte(this.count | this.spread | this.interpolation);
        for (Gradient gradient : this.gradients) {
            gradient.encode(coder, context);
        }
    }
}

