/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.fillstyle;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncodeable;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.Color;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class Gradient
implements SWFEncodeable {
    public static final int MAX_GRADIENTS = 15;
    private static final int MAX_RATIO = 255;
    private static final String FORMAT = "Gradient: { ratio=%d; color=%s}";
    private final transient int ratio;
    private final transient Color color;

    public Gradient(SWFDecoder coder, Context context) throws IOException {
        this.ratio = coder.readByte();
        this.color = new Color(coder, context);
    }

    public Gradient(int aRatio, Color aColor) {
        if (aRatio < 0 || aRatio > 255) {
            throw new IllegalArgumentRangeException(0, 255, aRatio);
        }
        this.ratio = aRatio;
        if (aColor == null) {
            throw new IllegalArgumentException();
        }
        this.color = aColor;
    }

    public int getRatio() {
        return this.ratio;
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return String.format(FORMAT, this.ratio, this.color);
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == null) {
            result = false;
        } else if (object == this) {
            result = true;
        } else if (object instanceof Gradient) {
            Gradient gradient = (Gradient)object;
            result = this.ratio == gradient.ratio && this.color.equals(gradient.color);
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return this.ratio * 31 + this.color.hashCode();
    }

    @Override
    public int prepareToEncode(Context context) {
        return 1 + this.color.prepareToEncode(context);
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(this.ratio);
        this.color.encode(coder, context);
    }
}

