/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class Jump
implements Action {
    private static final String FORMAT = "Jump: { offset=%d}";
    private static final int MIN_CODE_JUMP = Short.MIN_VALUE;
    private static final int MAX_CODE_JUMP = Short.MAX_VALUE;
    private final transient int offset;

    public Jump(SWFDecoder coder) throws IOException {
        coder.readUnsignedShort();
        this.offset = coder.readSignedShort();
    }

    public Jump(int anOffset) {
        if (anOffset < Short.MIN_VALUE || anOffset > Short.MAX_VALUE) {
            throw new IllegalArgumentRangeException(Short.MIN_VALUE, Short.MAX_VALUE, anOffset);
        }
        this.offset = anOffset;
    }

    public Jump(Jump object) {
        this.offset = object.offset;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public Jump copy() {
        return this;
    }

    public String toString() {
        return String.format(FORMAT, this.offset);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 5;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(153);
        coder.writeShort(2);
        coder.writeShort(this.offset);
    }
}

