/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Coder;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ScenesAndLabels
implements MovieTag {
    private static final String FORMAT = "ScenesAndLabels: { scenes=%s; labels=%s}";
    private Map<Integer, String> scenes;
    private Map<Integer, String> labels;
    private transient int length;

    public ScenesAndLabels(SWFDecoder coder) throws IOException {
        int i;
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        int count = coder.readVarInt();
        this.scenes = new LinkedHashMap<Integer, String>(count);
        for (i = 0; i < count; ++i) {
            this.scenes.put(coder.readVarInt(), coder.readString());
        }
        count = coder.readVarInt();
        this.labels = new LinkedHashMap<Integer, String>(count);
        for (i = 0; i < count; ++i) {
            this.labels.put(coder.readVarInt(), coder.readString());
        }
        coder.check(this.length);
        coder.unmark();
    }

    public ScenesAndLabels() {
        this.scenes = new LinkedHashMap<Integer, String>();
        this.labels = new LinkedHashMap<Integer, String>();
    }

    public ScenesAndLabels(Map<Integer, String> sceneMap, Map<Integer, String> labelMap) {
        this.scenes = sceneMap;
        this.labels = labelMap;
    }

    public ScenesAndLabels(ScenesAndLabels object) {
        this.scenes = new LinkedHashMap<Integer, String>(object.scenes);
        this.labels = new LinkedHashMap<Integer, String>(object.labels);
    }

    public ScenesAndLabels addScene(int offset, String name) {
        if (offset < 0 || offset > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, offset);
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.scenes.put(offset, name);
        return this;
    }

    public Map<Integer, String> getScenes() {
        return this.scenes;
    }

    public void setScenes(Map<Integer, String> map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        this.scenes = map;
    }

    public ScenesAndLabels addLabel(int offset, String name) {
        if (offset < 0 || offset > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, offset);
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.labels.put(offset, name);
        return this;
    }

    public Map<Integer, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<Integer, String> map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        this.labels = map;
    }

    @Override
    public ScenesAndLabels copy() {
        return new ScenesAndLabels(this);
    }

    public String toString() {
        return String.format(FORMAT, this.scenes, this.labels);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = Coder.sizeVariableU32(this.scenes.size());
        for (Integer offset : this.scenes.keySet()) {
            this.length += Coder.sizeVariableU32(offset) + context.strlen(this.scenes.get(offset));
        }
        this.length += Coder.sizeVariableU32(this.labels.size());
        for (Integer offset : this.labels.keySet()) {
            this.length += Coder.sizeVariableU32(offset) + context.strlen(this.labels.get(offset));
        }
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(5567);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x1580 | this.length);
        }
        coder.mark();
        coder.writeVarInt(this.scenes.size());
        for (Integer identifier : this.scenes.keySet()) {
            coder.writeVarInt(identifier);
            coder.writeString(this.scenes.get(identifier));
        }
        coder.writeVarInt(this.labels.size());
        for (Integer identifier : this.labels.keySet()) {
            coder.writeVarInt(identifier);
            coder.writeString(this.labels.get(identifier));
        }
        coder.check(this.length);
        coder.unmark();
    }
}

