/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.EventHandler;
import com.flagstone.transform.MovieTag;
import com.flagstone.transform.PlaceType;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.datatype.Blend;
import com.flagstone.transform.datatype.ColorTransform;
import com.flagstone.transform.datatype.CoordTransform;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.filter.Filter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Place3
implements MovieTag {
    private static final String FORMAT = "PlaceObject3: { type=%s; layer=%d; bitmapCache=%d; identifier=%d; transform=%s; colorTransform=%s; ratio=%d; clippingDepth=%d; name=%s; className=%s; filters=%s; blend=%s; clipEvents=%s}";
    private PlaceType type;
    private int layer;
    private String className;
    private Integer bitmapCache;
    private int identifier;
    private CoordTransform transform;
    private ColorTransform colorTransform;
    private Integer ratio;
    private String name;
    private Integer depth;
    private List<Filter> filters;
    private Integer blend;
    private List<EventHandler> events;
    private transient int length;
    private transient boolean hasBlend;
    private transient boolean hasFilters;
    private transient boolean hasImage;

    public static Place3 show(int identifier, int layer, int xCoord, int yCoord) {
        Place3 object = new Place3();
        object.setType(PlaceType.NEW);
        object.setLayer(layer);
        object.setIdentifier(identifier);
        object.setTransform(CoordTransform.translate(xCoord, yCoord));
        return object;
    }

    public static Place3 move(int layer, int xCoord, int yCoord) {
        Place3 object = new Place3();
        object.setType(PlaceType.MODIFY);
        object.setLayer(layer);
        object.setTransform(CoordTransform.translate(xCoord, yCoord));
        return object;
    }

    public static Place3 replace(int identifier, int layer) {
        Place3 object = new Place3();
        object.setType(PlaceType.REPLACE);
        object.setLayer(layer);
        object.setIdentifier(identifier);
        return object;
    }

    public static Place3 replace(int identifier, int layer, int xCoord, int yCoord) {
        Place3 object = new Place3();
        object.setType(PlaceType.REPLACE);
        object.setLayer(layer);
        object.setIdentifier(identifier);
        object.setTransform(CoordTransform.translate(xCoord, yCoord));
        return object;
    }

    public Place3(SWFDecoder coder, Context context) throws IOException {
        context.put(3, 1);
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        int bits = coder.readByte();
        boolean hasEvents = (bits & 0x80) != 0;
        boolean hasDepth = (bits & 0x40) != 0;
        boolean hasName = (bits & 0x20) != 0;
        boolean hasRatio = (bits & 0x10) != 0;
        boolean hasColorTransform = (bits & 8) != 0;
        boolean hasTransform = (bits & 4) != 0;
        switch (bits & 3) {
            case 0: {
                this.type = PlaceType.MODIFY;
                break;
            }
            case 1: {
                this.type = PlaceType.MODIFY;
                break;
            }
            case 2: {
                this.type = PlaceType.NEW;
                break;
            }
            default: {
                this.type = PlaceType.REPLACE;
            }
        }
        bits = coder.readByte();
        this.hasImage = (bits & 0x10) != 0;
        boolean hasClassName = (bits & 8) != 0;
        boolean hasBitmapCache = (bits & 4) != 0;
        this.hasBlend = (bits & 2) != 0;
        this.hasFilters = (bits & 1) != 0;
        this.layer = coder.readUnsignedShort();
        if (hasClassName) {
            this.className = coder.readString();
        }
        if (this.type == PlaceType.NEW || this.type == PlaceType.REPLACE) {
            this.identifier = coder.readUnsignedShort();
        }
        if (hasTransform) {
            this.transform = new CoordTransform(coder);
        }
        if (hasColorTransform) {
            this.colorTransform = new ColorTransform(coder, context);
        }
        if (hasRatio) {
            this.ratio = coder.readUnsignedShort();
        }
        if (hasName) {
            this.name = coder.readString();
        }
        if (hasDepth) {
            this.depth = coder.readUnsignedShort();
        }
        this.filters = new ArrayList<Filter>();
        if (this.hasFilters) {
            SWFFactory<Filter> decoder = context.getRegistry().getFilterDecoder();
            int count = coder.readByte();
            for (int i = 0; i < count; ++i) {
                decoder.getObject(this.filters, coder, context);
            }
        }
        if (this.hasBlend) {
            this.blend = coder.readByte();
        }
        if (hasBitmapCache) {
            this.bitmapCache = coder.readByte();
        }
        this.events = new ArrayList<EventHandler>();
        if (hasEvents) {
            int event;
            coder.readUnsignedShort();
            coder.readInt();
            while ((event = coder.readInt()) != 0) {
                this.events.add(new EventHandler(event, coder, context));
            }
        }
        context.remove(3);
        coder.check(this.length);
        coder.unmark();
    }

    public Place3() {
        this.filters = new ArrayList<Filter>();
        this.events = new ArrayList<EventHandler>();
    }

    public Place3(Place3 object) {
        this.type = object.type;
        this.layer = object.layer;
        this.bitmapCache = object.bitmapCache;
        this.className = object.className;
        this.identifier = object.identifier;
        if (object.transform != null) {
            this.transform = object.transform;
        }
        if (object.colorTransform != null) {
            this.colorTransform = object.colorTransform;
        }
        this.ratio = object.ratio;
        this.depth = object.depth;
        this.name = object.name;
        this.filters = new ArrayList<Filter>(object.filters);
        this.blend = object.blend;
        this.events = new ArrayList<EventHandler>(object.events.size());
        for (EventHandler event : object.events) {
            this.events.add(event.copy());
        }
    }

    public PlaceType getType() {
        return this.type;
    }

    public Place3 setType(PlaceType aType) {
        this.type = aType;
        return this;
    }

    public int getLayer() {
        return this.layer;
    }

    public Place3 setLayer(int aLayer) {
        if (aLayer < 1 || aLayer > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, aLayer);
        }
        this.layer = aLayer;
        return this;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public Place3 setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
        return this;
    }

    public CoordTransform getTransform() {
        return this.transform;
    }

    public Place3 setTransform(CoordTransform matrix) {
        this.transform = matrix;
        return this;
    }

    public ColorTransform getColorTransform() {
        return this.colorTransform;
    }

    public Place3 setColorTransform(ColorTransform cxform) {
        this.colorTransform = cxform;
        return this;
    }

    public Integer getRatio() {
        return this.ratio;
    }

    public Place3 setRatio(Integer aNumber) {
        if (aNumber != null && (aNumber < 0 || aNumber > 65535)) {
            throw new IllegalArgumentRangeException(1, 65535, aNumber);
        }
        this.ratio = aNumber;
        return this;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public Place3 setDepth(Integer aNumber) {
        if (aNumber != null && (aNumber < 1 || aNumber > 65535)) {
            throw new IllegalArgumentRangeException(1, 65535, aNumber);
        }
        this.depth = aNumber;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Place3 setName(String aString) {
        this.name = aString;
        return this;
    }

    public Integer getBitmapCache() {
        return this.bitmapCache;
    }

    public Place3 setBitmapCache(Integer cache) {
        this.bitmapCache = cache;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public Place3 setClassName(String aName) {
        this.className = aName;
        return this;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.filters = list;
    }

    public Blend getBlend() {
        return Blend.fromInt(this.blend);
    }

    public Place3 setBlend(Blend mode) {
        this.blend = mode.getValue();
        return this;
    }

    public Place3 add(EventHandler aClipEvent) {
        if (aClipEvent == null) {
            throw new IllegalArgumentException();
        }
        this.events.add(aClipEvent);
        return this;
    }

    public List<EventHandler> getEvents() {
        return this.events;
    }

    public void setEvents(List<EventHandler> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.events = list;
    }

    public Place3 add(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException();
        }
        this.filters.add(filter);
        return this;
    }

    @Override
    public Place3 copy() {
        return new Place3(this);
    }

    public String toString() {
        return String.format(FORMAT, new Object[]{this.type, this.layer, this.bitmapCache, this.identifier, this.transform, this.colorTransform, this.ratio, this.depth, this.name, this.className, this.filters, this.blend, this.events});
    }

    @Override
    public int prepareToEncode(Context context) {
        context.put(3, 1);
        this.hasBlend = this.blend != null;
        this.hasFilters = true ^ this.filters.isEmpty();
        this.length = 4;
        this.length += this.type == PlaceType.NEW || this.type == PlaceType.REPLACE ? 2 : 0;
        this.length += this.transform == null ? 0 : this.transform.prepareToEncode(context);
        this.length += this.colorTransform == null ? 0 : this.colorTransform.prepareToEncode(context);
        this.length += this.ratio == null ? 0 : 2;
        this.length += this.depth == null ? 0 : 2;
        this.length += this.name == null ? 0 : context.strlen(this.name);
        this.length += this.className == null ? 0 : context.strlen(this.className);
        if (this.hasFilters) {
            ++this.length;
            for (Filter filter : this.filters) {
                this.length += filter.prepareToEncode(context);
            }
        }
        if (this.hasBlend) {
            ++this.length;
        }
        if (this.bitmapCache != null) {
            ++this.length;
        }
        if (!this.events.isEmpty()) {
            this.length += 6;
            for (EventHandler handler : this.events) {
                this.length += handler.prepareToEncode(context);
            }
            this.length += 4;
        }
        context.remove(3);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(4543);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x1180 | this.length);
        }
        coder.mark();
        context.put(3, 1);
        int bits = 0;
        bits |= this.events.isEmpty() ? 0 : 128;
        bits |= this.depth == null ? 0 : 64;
        bits |= this.name == null ? 0 : 32;
        bits |= this.ratio == null ? 0 : 16;
        bits |= this.colorTransform == null ? 0 : 8;
        bits |= this.transform == null ? 0 : 4;
        switch (this.type) {
            case MODIFY: {
                bits |= 1;
                break;
            }
            case NEW: {
                bits |= 2;
                break;
            }
            default: {
                bits |= 1;
                bits |= 2;
            }
        }
        coder.writeByte(bits);
        bits = 0;
        bits |= this.hasImage ? 16 : 0;
        bits |= this.className == null ? 0 : 8;
        bits |= this.bitmapCache == null ? 0 : 4;
        bits |= this.hasBlend ? 2 : 0;
        coder.writeByte(bits |= this.hasFilters ? 1 : 0);
        coder.writeShort(this.layer);
        if (this.className != null) {
            coder.writeString(this.className);
        }
        if (this.type == PlaceType.NEW || this.type == PlaceType.REPLACE) {
            coder.writeShort(this.identifier);
        }
        if (this.transform != null) {
            this.transform.encode(coder, context);
        }
        if (this.colorTransform != null) {
            this.colorTransform.encode(coder, context);
        }
        if (this.ratio != null) {
            coder.writeShort(this.ratio);
        }
        if (this.name != null) {
            coder.writeString(this.name);
        }
        if (this.depth != null) {
            coder.writeShort(this.depth);
        }
        if (this.hasFilters) {
            coder.writeByte(this.filters.size());
            for (Filter filter : this.filters) {
                filter.encode(coder, context);
            }
        }
        if (this.hasBlend) {
            coder.writeByte(this.blend);
        }
        if (this.bitmapCache != null) {
            coder.writeByte(this.bitmapCache);
        }
        if (!this.events.isEmpty()) {
            int eventMask = 0;
            coder.writeShort(0);
            for (EventHandler handler : this.events) {
                eventMask |= handler.getEventCode();
            }
            coder.writeInt(eventMask);
            for (EventHandler handler : this.events) {
                handler.encode(coder, context);
            }
            coder.writeInt(0);
        }
        context.remove(3);
        coder.check(this.length);
        coder.unmark();
    }
}

