/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;
import java.util.Arrays;

public final class MovieData
implements MovieTag {
    private static final String FORMAT = "MovieData: { data=byte<%d> ...}";
    private final transient byte[] data;

    public MovieData(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        this.data = Arrays.copyOf(bytes, bytes.length);
    }

    public MovieData(MovieData object) {
        this.data = object.data;
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public MovieData copy() {
        return new MovieData(this);
    }

    public String toString() {
        return String.format(FORMAT, this.data.length);
    }

    @Override
    public int prepareToEncode(Context context) {
        return this.data.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeBytes(this.data);
    }
}

