/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.doubletype.ossa.OutOfRangeException;
import org.doubletype.ossa.module.GlyphFile;
import org.doubletype.ossa.module.TypefaceFile;
import org.doubletype.ossa.truetype.TTCodePage;
import org.doubletype.ossa.truetype.TTUnicodeRange;

public class Engine {
    private TypefaceFile m_typeface;
    private GlyphFile m_root;

    public void setAdvanceWidth(int a_value) {
        if (this.m_root == null) {
            return;
        }
        this.m_root.setAdvanceWidth(a_value);
    }

    public void buildNewTypeface(String a_name, File a_dir) throws FileNotFoundException {
        if (a_name == null || a_name.equals("")) {
            return;
        }
        TypefaceFile typeface = new TypefaceFile(a_name, a_dir);
        typeface.setAuthor("no body");
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        typeface.setCopyrightYear(format.format(new Date()));
        typeface.setFontFamilyName(a_name);
        typeface.addCodePage(TTCodePage.US_ASCII.toString());
        typeface.addCodePage(TTCodePage.Latin_1.toString());
        this.setTypeface(typeface);
    }

    public void addDefaultGlyphs() {
        this.m_typeface.addRequiredGlyphs();
        this.m_typeface.addBasicLatinGlyphs();
    }

    public void setTypeface(TypefaceFile a_typeface) {
        this.m_typeface = a_typeface;
    }

    public GlyphFile addNewGlyph(long a_unicode) {
        GlyphFile retval = this.m_typeface.createGlyph(a_unicode);
        this.addGlyphToTypeface(retval);
        return retval;
    }

    public void checkUnicodeBlock(long a_unicode) {
        TTUnicodeRange range = TTUnicodeRange.of(a_unicode);
        if (range == null) {
            return;
        }
        if (this.m_typeface.containsUnicodeRange(range.toString())) {
            return;
        }
        this.m_typeface.addUnicodeRange(range.toString());
    }

    private void addGlyphToTypeface(GlyphFile a_file) {
        this.m_typeface.addGlyph(a_file);
        this.setRoot(a_file);
    }

    public void buildTrueType() {
        if (this.m_typeface == null) {
            return;
        }
        try {
            this.m_typeface.buildTTF();
            this.m_typeface.getFont();
        }
        catch (Exception e) {
            Logger.getLogger(Engine.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public TypefaceFile getTypeface() {
        return this.m_typeface;
    }

    public File getGlyphPath() {
        return this.m_typeface.getGlyphPath();
    }

    public GlyphFile getRoot() {
        return this.m_root;
    }

    public void setRoot(GlyphFile a_file) {
        this.m_root = a_file;
    }

    public void addCodePage(String a_codePage) {
        if (this.m_typeface == null) {
            return;
        }
        this.m_typeface.addCodePage(a_codePage);
    }

    public void removeCodePage(String a_codePage) {
        if (this.m_typeface == null) {
            return;
        }
        this.m_typeface.removeCodePage(a_codePage);
    }

    public void setAuthor(String a_value) {
        if (this.m_typeface == null) {
            return;
        }
        this.m_typeface.setAuthor(a_value);
    }

    public void setCopyrightYear(String a_value) {
        if (this.m_typeface == null) {
            return;
        }
        this.m_typeface.setCopyrightYear(a_value);
    }

    public void setCreationDate(Date a_value) {
        if (this.m_typeface == null) {
            return;
        }
        this.m_typeface.setCreationDate(a_value);
    }

    public void setModificationDate(Date a_value) {
        if (this.m_typeface == null) {
            return;
        }
        this.m_typeface.setModificationDate(a_value);
    }

    public void setFontFamilyName(String a_value) {
        if (this.m_typeface == null) {
            return;
        }
        this.m_typeface.setFontFamilyName(a_value);
    }

    public void setTypefaceLicense(String a_value) {
        if (this.m_typeface == null) {
            return;
        }
        this.m_typeface.setLicense(a_value);
    }

    public void setBaseline(double a_value) {
        if (this.m_typeface == null) {
            return;
        }
        double min = this.m_typeface.getBottomSideBearing();
        double max = this.m_typeface.getMeanline();
        if (a_value < min) {
            a_value = min;
        }
        if (a_value > max) {
            a_value = max;
        }
        try {
            this.m_typeface.setDescender(a_value - min);
            this.m_typeface.setAscender(this.m_typeface.getEm() - this.m_typeface.getTopSideBearing() - a_value);
            this.m_typeface.setXHeight(max - a_value);
        }
        catch (OutOfRangeException e) {
            e.printStackTrace();
        }
    }

    public void setMeanline(double a_value) {
        if (this.m_typeface == null) {
            return;
        }
        double min = this.m_typeface.getBaseline();
        double max = this.m_typeface.getEm() - this.m_typeface.getTopSideBearing();
        if (a_value < min) {
            a_value = min;
        }
        if (a_value > max) {
            a_value = max;
        }
        try {
            this.m_typeface.setXHeight(a_value - min);
        }
        catch (OutOfRangeException e) {
            e.printStackTrace();
        }
    }
}

