# Static Reverse Engineering [SRE]

### *SRE - Dissecting Malware for Static Analysis & the Complete Command-line Tool*

SRE is designed to dissect the PE files (EXE, DLL) for Static Reversing and Analysis of the malware samples, suspicious executables and extracting the valuable data without execution. It is built with comprehensive analyse techniques to identify malicious infrastructure, libraries etc., and generate results as text files under the **_analysis_result_binaryname_** directory generated by this tool, which are useful for further custom in-depth analysis, Dynamic Analysis and to write a detailed technical report. 

**_TIP_:**  If the binary file's name is *'malware.exe'*, recommended to rename as *'malware_exe'* to create meaningful output directory and file names. <br /><br />



 ### *Key Features* 
**Static Analysis:** Performs thorough static analysis on the given binary file(s) nine modules and provides an extensive knowledge of the binary file's suspicious characteristics, malicious behaviors, and potential risks.
-   Integrity Analyse
-   Metadata Analyse
-   Packers Detection
-   APIs Analyse
-   Strings Analyse
-   IoCs Extraction
-   Malicious Behaviour Analyse
-   Disassmembly Dump
-   VirusTotal Check &emsp; _<Note: this will not submit the samples to VT.>_

**200+ Checkpoints:** These nine distinct modules are encompass more than 200 checkpoints which cover a wide range of analysis techniques, aiming to provide a comprehensive data of the binary file.

**Textfile based Output:** The tool saves the analysis outcome as text file. This format is chosen to facilitate easy readable-format, review, and further analysis of the collected information. It allows analysts to search, filter, and process the data efficiently.  Also makes it very easy to write custom *'Yara rules'*.<br />

**Advantages:**
- The complete command-line tool with text files as output. <first of it's kind, I guess!>
- The outcome text files are useful for further analyzing the results, creating a detailed report, and writing custom Yara rules. They are also very handy during Dynamic Analysis of the sample.
- It is a command-line tool that is easy to use, automate further, and customizable for in-depth dynamic analysis research.

**Limitations:**
-  No fancy GUI treats!  Its all command-line.
-  Supports only EXE, DLL file formates (as of now).<br /><br />



### *Requirements*
- Python 3.10 and above.<br />
- Use '_requirements.txt_' file for the pre-requisite installation packages and and they will be installed using:<br />
 ```python
 pip install -r requirements.txt
 ```
- Here are the full list of Python packages as requirements, in case if you need them.<br />
  - re, math, magic, yara
  - os, sys, subprocess, platform
  - pefile, lief
  - json, requests
  - datetime, time
  - hashlib, argparse

- VirusTotal API Key needs to be palced in *'api_key.txt'* file under **config** directory.<br />
- Also make sure yara rule files are unzipped and placed under **config** directory.<br /><br />

### *Usage*
for Linux terminal
```python
$ python3 SRE.py [options] [filename]
```
for Windows cmd promopt
```python
> python3 SREwin.py [options] [filename]
```
```
arguments:
   filename    ~state file path [to scan single file] or state folder path [to scan multiple files] 
 
options:
   -h,    --help	  show this help message and exit
   -V,    --verbose	  enable verbose terminal output            
   -f,    --file	  check the file type only (before analyse)
   -v,    --version	  show version info               
   -i,    --info	  show author, email and url info            
   -l,    --license 	  show license info
```


<br />
