# Large Language Models Showcase

Welcome to the Large Language Models Showcase! This repository is a curated collection of interesting _applications_, _use cases_, _Github repos_ and _tutorials_ that use state-of-the-art language models, such as GPT-3 and other large language models. Whether you're a language enthusiast, a machine learning researcher, or just someone interested in the capabilities of AI, this repository is the perfect place to explore the world of natural language processing and see what these powerful models are capable of.

In this repository, you'll find a variety of examples and demonstrations of language models being used for text generation, search, question answering and more. You'll also find tutorials and resources for building your own applications, as well as links to other repositories and resources for further learning.

---

# Showcases

## *June 6, 2023*

## BabyAGI
[Github](https://github.com/yoheinakajima/babyagi)

> This Python script is an example of an AI-powered task management system. The system uses OpenAI and vector databases such as Chroma or Weaviate to create, prioritize, and execute tasks. The main idea behind this system is that it creates tasks based on the result of previous tasks and a predefined objective. The script then uses OpenAI's natural language processing (NLP) capabilities to create new tasks based on the objective, and Chroma/Weaviate to store and retrieve task results for context. This is a pared-down version of the original Task-Driven Autonomous Agent (Mar 28, 2023).

---

## REMO
[Github](https://github.com/daveshap/REMO_Framework)

> Rolling Episodic Memory Organizer (REMO) for autonomous AI systemsREMO: Recursive Episodic Memory Organizer. Efficient, scalable memory management. Organizes conversational data into taxonomical ranks. Each rank clusters semantically similar elements. Powerful tool for context-aware AI systems. Improves conversational capabilities, recall accuracy.

---

## Window.ai
[Github](https://github.com/alexanderatallah/window.ai)

> Window AI is a browser extension that lets you configure AI models in one place and use them on the web. For developers: easily make multi-model apps free from API costs and limits - just use the injected window.ai library. Leverage decentralized AI.For users: control the AI you use on the web, whether it's external (like OpenAI), proxied, or local, to protect privacy. For model providers: plug into an ecosystem of users without requiring developers to change their apps.

---

## OpenChatKit
[Github](https://github.com/togethercomputer/OpenChatKit)

> OpenChatKit provides a powerful, open-source base to create both specialized and general purpose chatbots for various applications. The kit includes an instruction-tuned language models, a moderation model, and an extensible retrieval system for including up-to-date responses from custom repositories.

---

## Alpaca-Turbo
[Github](https://github.com/ViperX7/Alpaca-Turbo)

> Alpaca-Turbo is a frontend to use large language models that can be run locally without much setup required. It is a user-friendly web UI for the llama.cpp , with unique features that make it stand out from other implementations. The goal is to provide a seamless chat experience that is easy to configure and use, without sacrificing speed or functionality.

---

## Motorhead
[Github](https://github.com/getmetal/motorhead)

> When building chat applications using LLMs, memory handling is something that has to be built every time. Motorhead is a server to assist with that process.

---

## GPTCache
[Github](https://github.com/zilliztech/gptcache)

> ChatGPT and various large language models (LLMs) boast incredible versatility, enabling the development of a wide range of applications. However, as your application grows in popularity and encounters higher traffic levels, the expenses related to LLM API calls can become substantial. Additionally, LLM services might exhibit slow response times, especially when dealing with a significant number of requests.To tackle this challenge, we have created GPTCache, a project dedicated to building a semantic cache for storing LLM responses.

---

## Babyagi-asi
[Github](https://github.com/oliveirabruno01/babyagi-asi)

> This Python script is an example of a LLM-powered autonomous agent. The system uses OpenAI API to create and execute tasks. The core idea of the project is to provide the assistant with the tools it needs to do any task - if it's smart enough. It can arbitrarily execute code and control its own flow and memory, for a sufficiently intelligent agent, either by pre-training, fine-tuning or prompt-optimization, this should be enough (if it is possible at all).
---

## EVAL
[Github](https://github.com/corca-ai/EVAL)
> EVAL(Elastic Versatile Agent with Langchain) will execute all your requests. Just like an eval method!
---

## Building LLM applications for production
[Blog](https://huyenchip.com/2023/04/11/llm-engineering.html)
> A question that I’ve been asked a lot recently is how large language models (LLMs) will change machine learning workflows. After working with several companies who are working with LLM applications and personally going down a rabbit hole building my applications...
---

## Chameleon
[Github](https://github.com/lupantech/chameleon-llm)
> Chameleon is a plug-and-play compositional reasoning framework that augments LLMs with various types of tools. Chameleon synthesizes programs to compose various tools, including LLM models, off-the-shelf vision models, web search engines, Python functions, and rule-based modules tailored to user interests. Built on top of an LLM as a natural language planner, Chameleon infers the appropriate sequence of tools to compose and execute in order to generate a final response.
---

## FastChat
[Github](https://github.com/lm-sys/FastChat)
> An open platform for training, serving, and evaluating large language models. Release repo for Vicuna and FastChat-T5.
---

## Vicuna: An Open-Source Chatbot Impressing GPT-4 with 90%* ChatGPT Quality
[Github](https://lmsys.org/blog/2023-03-30-vicuna/)
> We introduce Vicuna-13B, an open-source chatbot trained by fine-tuning LLaMA on user-shared conversations collected from ShareGPT. Preliminary evaluation using GPT-4 as a judge shows Vicuna-13B achieves more than 90%* quality of OpenAI ChatGPT and Google Bard while outperforming other models like LLaMA and Stanford Alpaca in more than 90%* of cases.
---

## Mr. Ranedeer: Your personalized AI Tutor
[Github](https://github.com/JushBJJ/Mr.-Ranedeer-AI-Tutor)
> Unlock the potential of GPT-4 with Mr. Ranedeer AI Tutor, a customizable prompt that delivers personalized learning experiences for users with diverse needs and interests.
---

## Releasing 3B and 7B RedPajama-INCITE family of models
[Blog](https://www.together.xyz/blog/redpajama-models-v1)
> The RedPajama project aims to create a set of leading open-source models and to rigorously understand the ingredients that yield good performance.
---

## OpenLM Research
[Github](https://github.com/openlm-research/open_llama)
> we are releasing our public preview of OpenLLaMA, a permissively licensed open source reproduction of Meta AI’s LLaMA 7B trained on the RedPajama dataset. Our model weights can serve as the drop in replacement of LLaMA 7B in existing implementations. We also provide a smaller 3B variant of LLaMA model.
---

## Knowledge
[Github](https://github.com/KnowledgeCanvas/knowledge)
> Dive into a more interactive learning experience with Knowledge's new Chat feature! Engage in dynamic conversations with your Projects and Sources, leveraging the power of Large Language Models. Ask questions, explore concepts, and deepen your understanding, all within an intuitive chat interface.
---

## MLC LLM
[Github](https://github.com/mlc-ai/mlc-llm)
> MLC LLM is a universal solution that allows any language models to be deployed natively on a diverse set of hardware backends and native applications, plus a productive framework for everyone to further optimize model performance for their own use cases.
---

## Amazing-Bard-Prompts
[Github](https://github.com/dsdanielpark/amazing-bard-prompts)
> The interactive artificial intelligence Google-Bard released by Google AI officially supports English, Korean, and Japanese. Therefore, we share prompts for better use of Google Bard. Amazing-Bard-Prompts is a fork of Awesome-ChatGPT-Prompts and translated with Google's Translate Engine. Contributors can modify CSV files to edit, review, and suggest prompts that are suitable for Google Bard.
---

## Openai-cookbook
[Github](https://github.com/openai/openai-cookbook)
> The OpenAI Cookbook shares example code for accomplishing common tasks with the OpenAI API.
---

## Introduction to Large Language Models for Generative AI
[Github](https://www.assemblyai.com/blog/introduction-large-language-models-generative-ai/)
> Generative AI language models like ChatGPT are changing the way humans and AI interact and work together, but how do these models actually work? Learn everything you need to know about modern Generative AI for language in this simple guide.
---

## Superagent
[Github](https://github.com/homanp/superagent)
> SuperAgent is a powerful tool that simplifies the configuration and deployment of LLM (Large Language Model) Agents to production. It provides a range of features and functionalities to make it easier for developers to build, manage and deploy AI agents to production including features such as built in memory and document retrieval via vector dbs, powerful tools, webhooks, cron jobs etc.
---

## e2b
[Github](https://github.com/e2b-dev/e2b)
> Developer-first AgentOps platform - deploy, test, and monitor AI agents
---

## Zeno Build
[Github](https://github.com/zeno-ml/zeno-build)
> Zeno Build is a tool for developers who want to quickly build, compare, and iterate on applications using large language models.
---

## ChatAll
[Github](https://github.com/sunner/ChatALL)
> Concurrently chat with ChatGPT, Bing Chat, bard, Alpaca, Vincuna, Claude, ChatGLM, MOSS, iFlytek Spark, ERNIE and more, discover the best answers.
---

## PrivateGPT-app
[Github](https://github.com/menloparklab/privateGPT-app)
> A fastAPI backend and a streamlit UI for privateGPT. Interact privately with your documents as a webapp using the power of GPT, 100% privately, no data leaks.
---

## llm-numbers
[Github](https://github.com/ray-project/llm-numbers)
> At Google, there was a document put together by Jeff Dean, the legendary engineer, called Numbers every Engineer should know. It’s really useful to have a similar set of numbers for LLM developers to know that are useful for back-of-the envelope calculations. Here we share particular numbers we at Anyscale use, why the number is important and how to use it to your advantage.
---

## Generative AI for Document Understanding with Hugging Face and Amazon SageMaker
[Github](https://www.philschmid.de/sagemaker-donut)
> In this tutorial, you will learn how to fine-tune and deploy Donut-base for document-understand/document-parsing using Hugging Face Transformers and Amazon SageMaker. 
---

## PandaGPT: One Model to Instruction-Follow Them All
[Website](https://panda-gpt.github.io/)
> PandaGPT is a general-purpose instruction-following model that can both see and hear. Our pilot experiments show that PandaGPT can perform complex tasks such as detailed image description generation, writing stories inspired by videos, and answering questions about audios.
---

## April & May, 2023
## LangChain

[Github](https://github.com/hwchase17/langchain)

> Building applications with LLMs through composability

---

## ChatGPT memory

[Github](https://github.com/continuum-llms/chatgpt-memory)

> Allows to scale the ChatGPT API to multiple simultaneous sessions with infinite contextual and adaptive memory powered by GPT and Redis datastore.

---

## Awesome ChatGPT Prompts

[Github](https://github.com/f/awesome-chatgpt-prompts)

> This is a collection of prompt examples to be used with the ChatGPT model.

---

## JARVIS

[Girhub](https://github.com/microsoft/JARVIS)

> JARVIS, a system to connect LLMs with ML community

## Marvin

[Github](https://github.com/PrefectHQ/marvin)

> a batteries-included library for building AI-powered software. Marvin's job is to integrate AI directly into your codebase by making it look and feel like any other function.

---

## LlamaIndex (GPT Index)

[Github](https://github.com/jerryjliu/llama_index)

> LlamaIndex (GPT Index) is a project that provides a central interface to connect your LLM's with external data.

---

## OntoGPT

[Github](https://github.com/monarch-initiative/ontogpt)

> Generation of Ontologies and Knowledge Bases using GPT.A knowledge extraction tool that uses a large language model to extract semantic information from text

---

## Building a Multi-User Chatbot with Langchain and Pinecone in Next.JS

[Blog](https://www.pinecone.io/learn/javascript-chatbot/?utm_content=244434553&utm_medium=social&utm_source=twitter&hss_channel=tw-1287624141001109504)

> Building a chatbot has become a hot skill, and with the release of ChatGPT we see a huge number of chat applications being released.

---

## Efficient Large Language Model training

[Blog](https://www.philschmid.de/fine-tune-flan-t5-peft)

> Efficient Large Language Model training with LoRA and Hugging Face

---

## ChatDoctor: A Medical Chat Model Fine-tuned on LLaMA Model using Medical Domain Knowledge

[Github](https://github.com/Kent0n-Li/ChatDoctor)

> ChatDoctor: A Medical Chat Model Fine-tuned on LLaMA Model using Medical Domain Knowledge

---

## GPT4All

[Github](https://github.com/nomic-ai/gpt4all)

> gpt4all: an ecosystem of open-source chatbots trained on a massive collections of clean assistant data including code, stories and dialogue. Demo, data, and code to train an assistant-style large language model with ~800k GPT-3.5-Turbo Generations based on LLaMa

---

## Dataless Knowledge Fusion by Merging Weights of Language Models

[Github](https://github.com/bloomberg/dataless-model-merging)

> This repository contains the experimental code to reproduce the results in Dataless Knowledge Fusion by Merging Weights of Language Models, a paper to be published during the Eleventh International Conference on Learning Representations (ICLR 2023), to be held May 1-5, 2023 in Kigali, Rwanda.

---

## Prompt Engineering Guide

[Github](https://github.com/dair-ai/Prompt-Engineering-Guide)

> Guides, papers, lecture, notebooks and resources for prompt engineering

---

## Kor

[Website](https://eyurtsev.github.io/kor/)

> This is a half-baked prototype that “helps” you extract structured data from text using large language models (LLMs)

---

## Memory-assisted prompt editing to improve GPT-3 after deployment

[Github](https://github.com/madaan/memprompt)

> A method to fix GPT-3 after deployment with user feedback, without re-training.

---

## ChatGPT (LLMs) vs. Knowledge Graphs

[Blog](https://thecaglereport.com/2023/03/24/chatgpt-llms-vs-knowledge-graphs/)

> This article focuses more on how ChatGPT works at a conceptual level and how it compares to knowledge graphs.

---

## GPT-4 & LangChain - Create a ChatGPT Chatbot for Your PDF Files

[Github](https://github.com/PineappleExpress808/gpt4-pdf-chatbot-langchain)

> Use the new GPT-4 api to build a chatGPT chatbot for multiple Large PDF files.

---

## Leveraging LangChain and Large Language Models for Accurate PDF-Based Question Answering

[Github](https://github.com/mallahyari/drqa)

> This repo is to help you build a powerful question answering system that can accurately answer questions by combining Langchain and large language models (LLMs) including OpenAI's GPT3 models.

---

## ColossalChat

[Github](https://github.com/hpcaitech/ColossalAI/tree/main/applications/Chat)

> ColossalChat is the project to implement LLM with RLHF, powered by the Colossal-AI project.Coati stands for ColossalAI Talking Intelligence. It is the name for the module implemented in this project and is also the name of the large language model developed by the ColossalChat project.

---

## YouTube Semantic Search

[Github](https://github.com/transitive-bullshit/yt-semantic-search)

> OpenAI-powered semantic search for any YouTube playlist – featuring the All-In Podcast.

---

## Sketch

[Github](https://github.com/approximatelabs/sketch)

> Sketch is an AI code-writing assistant for pandas users that understands the context of your data, greatly improving the relevance of suggestions. Sketch is usable in seconds and doesn't require adding a plugin to your IDE.

---

## Vicuna: An Open-Source Chatbot Impressing GPT-4 with 90%\* ChatGPT Quality

[Website](https://vicuna.lmsys.org/)

> We introduce Vicuna-13B, an open-source chatbot trained by fine-tuning LLaMA on user-shared conversations collected from ShareGPT. Preliminary evaluation using GPT-4 as a judge shows Vicuna-13B achieves more than 90%_ quality of OpenAI ChatGPT and Google Bard while outperforming other models like LLaMA and Stanford Alpaca in more than 90%_ of cases.

---

## Agents in Haystack: Make LLMs resolve complex tasks

[Website](https://haystack.deepset.ai/blog/introducing-haystack-agents?utm_content=243448908&utm_medium=social&utm_source=linkedin&hss_channel=lcp-18582479)

> Introducing the Agent to the Haystack ecosystem. The implementation of Agents is inspired by two papers: the MRKL Systems paper (pronounced ‘miracle’ 😉) and the ReAct paper. If you like reading papers, I highly recommend these two. Here, I’ll explain how we’re introducing this functionality to Haystack.

---

## FastChat

[Girhub](https://github.com/lm-sys/FastChat)

> An open platform for training, serving, and evaluating large language model based chatbots.

---

## LMQL

[Website](https://lmql.ai/)

> LMQL is a programming language for language model interaction.

---

## Next.js OpenAI Doc Search Starter

[Girhub](https://github.com/supabase-community/nextjs-openai-doc-search?og=v2)

> Template for building your own custom ChatGPT style doc search powered by Next.js, OpenAI, and Supabase.

---

## Python bindings for llama.cpp

[Github](https://github.com/abetlen/llama-cpp-python)

> Simple Python bindings for llama.cpp library.

---

## StackLLaMA: A hands-on guide to train LLaMA with RLHF

[Website](https://huggingface.co/blog/stackllama)

> Models such as ChatGPT, GPT-4, and Claude are powerful language models that have been fine-tuned using a method called Reinforcement Learning from Human Feedback (RLHF) to be better aligned with how we expect them to behave and would like to use them.

---

## CodeSquire

[Website](https://codesquire.ai/)

> AI code writing assistant for data scientists, engineers, and analysts.Get code completions and suggestions as you type.

---

## Vscode-chatgpt

[Github](https://chatgptai.dev/)

> A Visual Studio Code - ChatGPT Integration

---

## GPTCache

[Github](https://github.com/zilliztech/gptcache)

> The GitHub repository "gptcache" is a high-performance cache system for large-scale language models like GPT. It aims to reduce the inference latency and cost of GPT models by caching intermediate results.

---

## Semantic Search using LlamaIndex and Langchain

[Blog](https://blog.futuresmart.ai/semantic-search-using-llamaindex-and-langchain)

> The blog post discusses the implementation of semantic search using LlamaIndex and LangChain. LlamaIndex is a fast and memory-efficient indexing system, while LangChain is a language model that can convert queries into embeddings for semantic search.

---

## Auto-GPT: An Autonomous GPT-4 Experiment

[Github](https://github.com/Torantulino/Auto-GPT)

> Auto-GPT is an experimental open-source application showcasing the capabilities of the GPT-4 language model. This program, driven by GPT-4, autonomously develops and manages businesses to increase net worth. As one of the first examples of GPT-4 running fully autonomously, Auto-GPT pushes the boundaries of what is possible with AI.

---

## Accelerating LLaMA with Fabric: A Comprehensive Guide to Training and Fine-Tuning LLaMA

[Website](https://lightning.ai/pages/community/tutorial/accelerating-llama-with-fabric-a-comprehensive-guide-to-training-and-fine-tuning-llama/)

> In this tutorial, we will learn how to train and fine-tune LLaMA (Large Language Model Meta AI). Lit-LLaMA, a rewrite of LLaMA, can run inference on an 8 GB consumer GPU. We will also discover how it utilizes Lightning Fabric to accelerate the PyTorch code.

---

## Tabby

[Github](https://github.com/TabbyML/tabby)

> It provides a user-friendly interface for interactive data analysis and exploration. It allows users to easily filter, sort, and visualize data, and also includes functionality for machine learning and natural language processing.

---

## Openplayground

[Github](https://github.com/nat/openplayground)

> The GitHub repository "openplayground" provides an interactive playground for exploring machine learning algorithms and neural networks. It includes pre-built models and datasets, as well as the ability to upload custom data and models.

---

## Open LLM Leaderboard from Hugging Face

[Website](https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard)

> With the plethora of large language models (LLMs) and chatbots being released week upon week, often with grandiose claims of their performance, it can be hard to filter out the genuine progress that is being made by the open-source community and which model is the current state of the art. The 🤗 Open LLM Leaderboard aims to track, rank and evaluate LLMs and chatbots as they are released. 🤗 A key advantage of this leaderboard is that anyone from the community can submit a model for automated evaluation on the 🤗 GPU cluster, as long as it is a 🤗 Transformers model with weights on the Hub. Evaluation of models with delta-weights for non-commercial licensed models are also supported, such as LLaMa.

---

## Contribution

Contributions to this repository are welcome and encouraged! If you have any interesting applications or tutorials that use language models, please feel free to submit a pull request. Let's showcase the power of AI language models together!

## License

This repository is licensed under the [MIT License](./LICENSE).
