#include <stdint.h>
#include <stdlib.h>

int dec_to_str(const int num, char ostr[])
{
	int quot, i;
	char rem;

	quot = num;
	i = 0;
	do {
		rem = (quot % 10) + '0';
		quot /= 10;
		ostr[i++] = rem;
	} while (quot);

	int start, end;
	char temp;
	for (end = i - 1, start = 0; start < end; end--, start++) {
		temp = ostr[start];
		ostr[start] = ostr[end];
		ostr[end] = temp;
	}

	ostr[i] = '\0';
	return i;
}

int hex_to_str(const int num, char ostr[])
{
	int index = 32;
	int val;
	int cnt = 0;

	do {
		index -= 4;
		val = (num >> index) & 0xf;
	} while (!val && index);

	ostr[cnt++] = '0';
	ostr[cnt++] = 'x';
	do {
		if (val > 9)
			val = 'A' + (val - 10);
		else
			val += '0';
		ostr[cnt++] = val;
		index -= 4;
		val = (num >> index) & 0xf;
	} while (index >= 0);

	ostr[cnt] = '\0';
	return cnt;
}

size_t strlen(const char *s)
{
	int i;
	for (i = 0; s[i]; i++)
		;

	return i;
}

char *strcpy(char *dest, const char *src)
{
	int i;

	for (i = 0; src[i]; i++)
		dest[i] = src[i];

	dest[i] = '\0';	
	return dest;
}

char *strncpy(char *dest, const char *src, size_t n)
{
	size_t i;

	for (i = 0; i < n && src[i] != '\0'; i++)
		dest[i] = src[i];

	for (; i < n; i++)
		dest[i] = '\0';
	
	return dest;
}

int strcmp(const char *s1, const char *s2)
{
	int i;

	for (i = 0; s1[i]; i++) {
		if (s1[i] != s2[i])
			return s1[i] - s2[i];
	}
	return 0;
}

int strncmp(const char *s1, const char *s2, size_t n)
{
	size_t i;

	for (i = 0; i < n; i++) {
		if (s1[i] != s2[i])
			return s1[i] - s2[i];
		else if (s1[i] == '\0')
			return 0;
	}

	return 0;
}

void *memcpy(void *dest, const void *src, size_t n)
{
	size_t index = 0;
	uint8_t *t_dest = (uint8_t *) dest;
	uint8_t *t_src = (uint8_t *) src;

	if ((((size_t) dest ^ (size_t) src) & 0x3) == 0) {
		/* We can align src and dest on word boundary */
		int size = (size_t) dest & 0x3;
		while (size-- && index < n) {
			*t_dest++ = *t_src++;
			index++;
		}

		uint32_t *w_dest = (uint32_t *) t_dest;
		uint32_t *w_src = (uint32_t *) t_src;
		while (index < (n - sizeof(uint32_t))) {
			*w_dest++ = *w_src++;
			index += sizeof(uint32_t);
		}
		t_dest = (uint8_t *) w_dest;
		t_src = (uint8_t *) w_src;
	}

	while (index < n) {
		*t_dest++ = *t_src++;
		index++;
	}

	return dest;
}

void *memset(void *s, int c, size_t n)
{
	uint8_t *src = (uint8_t *) s;
	size_t i;

	for (i = 0; i < n; i++)
		src[i] = c;
	return s;
}

void *memsetw(uint16_t *s, uint16_t c, size_t n)
{
	size_t i;

	for (i = 0; i < n; i++)
		s[i] = c;
	return s;
}

long int strtox(const char *nptr, int size)
{
        long int val = 0;
        int i;
        for (i = 0; i < size; i++) {
                if (nptr[i] == ' ')
                        continue;
                val <<= 4;
                if (nptr[i] >= '0' && nptr[i] <= '9')
                        val += nptr[i] - '0';
                else if (nptr[i] >= 'a' && nptr[i] <= 'f')
                        val += (10 + (nptr[i] - 'a'));
                else if (nptr[i] >= 'A' && nptr[i] <= 'F')
                        val += 10 + (nptr[i] - 'A');
        }

        return val;
}

