/******************************************************************************/
/***                        DATABASE DEFINITION                             ***/
/******************************************************************************/

SET NAMES NONE;

SET CLIENTLIB 'fbclient.dll';

CREATE DATABASE 'localhost:employee.fdb'
USER 'SYSDBA'
PAGE_SIZE 4096
DEFAULT CHARACTER SET NONE COLLATION NONE;



/******************************************************************************/
/***                                Domains                                 ***/
/******************************************************************************/

CREATE DOMAIN ADDRESSLINE AS
VARCHAR(30);

CREATE DOMAIN BUDGET AS
NUMERIC(15,2)
DEFAULT 50000
CHECK (VALUE > 10000 AND VALUE <= 2000000);

CREATE DOMAIN COUNTRYNAME AS
VARCHAR(15);

CREATE DOMAIN CUSTNO AS
INTEGER
CHECK (VALUE > 1000);

CREATE DOMAIN DEPTNO AS
CHAR(3)
CHECK (VALUE = '000' OR (VALUE > '0' AND VALUE <= '999') OR VALUE IS NULL);

CREATE DOMAIN EMPNO AS
SMALLINT;

CREATE DOMAIN FIB$BOOLEAN AS
SMALLINT
DEFAULT 1
NOT NULL
CHECK (VALUE IN (0,1));

CREATE DOMAIN FIRSTNAME AS
VARCHAR(15);

CREATE DOMAIN JOBCODE AS
VARCHAR(5)
CHECK (VALUE > '99999');

CREATE DOMAIN JOBGRADE AS
SMALLINT
CHECK (VALUE BETWEEN 0 AND 6);

CREATE DOMAIN LASTNAME AS
VARCHAR(20);

CREATE DOMAIN PHONENUMBER AS
VARCHAR(20);

CREATE DOMAIN PONUMBER AS
CHAR(8)
CHECK (VALUE STARTING WITH 'V');

CREATE DOMAIN PRODTYPE AS
VARCHAR(12)
DEFAULT 'software'
NOT NULL
CHECK (VALUE IN ('software', 'hardware', 'other', 'N/A'));

CREATE DOMAIN PROJNO AS
CHAR(5)
CHECK (VALUE = UPPER (VALUE));

CREATE DOMAIN SALARY AS
NUMERIC(15,2)
DEFAULT 0
CHECK (VALUE > 0);

CREATE DOMAIN TGUID AS
CHAR(16) CHARACTER SET OCTETS;



/******************************************************************************/
/***                               Generators                               ***/
/******************************************************************************/

CREATE GENERATOR CUST_NO_GEN START WITH 0 INCREMENT BY 1;
SET GENERATOR CUST_NO_GEN TO 1015;

CREATE GENERATOR DEPT_NO_GEN START WITH 0 INCREMENT BY 1;
SET GENERATOR DEPT_NO_GEN TO 0;

CREATE GENERATOR EMP_NO_GEN START WITH 0 INCREMENT BY 1;
SET GENERATOR EMP_NO_GEN TO 145;

CREATE GENERATOR FIB$APP_STATISTICS_GEN_ID START WITH 0 INCREMENT BY 1;
SET GENERATOR FIB$APP_STATISTICS_GEN_ID TO 141;

CREATE GENERATOR FIB$FIELD_INFO_VERSION START WITH 0 INCREMENT BY 1;
SET GENERATOR FIB$FIELD_INFO_VERSION TO 70;

CREATE GENERATOR GEN_BIGTABLE_ID START WITH 0 INCREMENT BY 1;
SET GENERATOR GEN_BIGTABLE_ID TO 1000000;

CREATE GENERATOR GEN_UNICODE_TABLE_ID START WITH 0 INCREMENT BY 1;
SET GENERATOR GEN_UNICODE_TABLE_ID TO 5;



/******************************************************************************/
/***                               Exceptions                               ***/
/******************************************************************************/

CREATE EXCEPTION CUSTOMER_CHECK 'Overdue balance -- can''t ship.';

CREATE EXCEPTION CUSTOMER_ON_HOLD 'This customer is on hold.';

CREATE EXCEPTION ORDER_ALREADY_SHIPPED 'Order status is ''shipped.''';

CREATE EXCEPTION REASSIGN_SALES 'Reassign the sales records before deleting this employee.';

CREATE EXCEPTION UNKNOWN_EMP_ID 'Invalid employee number or project id.';



/******************************************************************************/
/***                           Stored procedures                            ***/
/******************************************************************************/



SET TERM ^ ;

CREATE PROCEDURE ADD_EMP_PROJ (
    EMP_NO SMALLINT,
    PROJ_ID CHAR(5))
AS
BEGIN
  EXIT;
END^





CREATE PROCEDURE ALL_LANGS
RETURNS (
    CODE VARCHAR(5),
    GRADE VARCHAR(5),
    COUNTRY VARCHAR(15),
    LANG VARCHAR(15))
AS
BEGIN
  SUSPEND;
END^





CREATE PROCEDURE DELETE_EMPLOYEE (
    EMP_NUM INTEGER)
AS
BEGIN
  EXIT;
END^





CREATE PROCEDURE DEPT_BUDGET (
    DNO CHAR(3))
RETURNS (
    TOT NUMERIC(15,2))
AS
BEGIN
  SUSPEND;
END^





CREATE PROCEDURE GEN_BIGTABLE_CONTENT (
    CNT INTEGER)
RETURNS (
    PROGRESS INTEGER)
AS
BEGIN
  SUSPEND;
END^





CREATE PROCEDURE GET_EMP_PROJ (
    EMP_NO SMALLINT)
RETURNS (
    PROJ_ID CHAR(5))
AS
BEGIN
  SUSPEND;
END^





CREATE PROCEDURE MAIL_LABEL (
    CUST_NO INTEGER)
RETURNS (
    LINE1 CHAR(40),
    LINE2 CHAR(40),
    LINE3 CHAR(40),
    LINE4 CHAR(40),
    LINE5 CHAR(40),
    LINE6 CHAR(40))
AS
BEGIN
  SUSPEND;
END^





CREATE PROCEDURE ORG_CHART
RETURNS (
    HEAD_DEPT CHAR(25),
    DEPARTMENT CHAR(25),
    MNGR_NAME CHAR(20),
    TITLE CHAR(5),
    EMP_CNT INTEGER)
AS
BEGIN
  SUSPEND;
END^





CREATE PROCEDURE SHIP_ORDER (
    PO_NUM CHAR(8))
AS
BEGIN
  EXIT;
END^





CREATE PROCEDURE SHOW_LANGS (
    CODE VARCHAR(5),
    GRADE SMALLINT,
    CTY VARCHAR(15))
RETURNS (
    LANGUAGES VARCHAR(15))
AS
BEGIN
  SUSPEND;
END^





CREATE PROCEDURE SUB_TOT_BUDGET (
    HEAD_DEPT CHAR(3))
RETURNS (
    TOT_BUDGET NUMERIC(15,2),
    AVG_BUDGET NUMERIC(15,2),
    MIN_BUDGET NUMERIC(15,2),
    MAX_BUDGET NUMERIC(15,2))
AS
BEGIN
  SUSPEND;
END^






SET TERM ; ^



/******************************************************************************/
/***                                 Tables                                 ***/
/******************************************************************************/



CREATE TABLE BIGTABLE (
    ID           INTEGER NOT NULL,
    NAME         VARCHAR(30),
    LAST_UPDATE  DATE
);

CREATE TABLE BIGTABLE_DETAIL (
    ID           INTEGER NOT NULL,
    INT_VALUE    INTEGER NOT NULL,
    BIGTABLE_ID  INTEGER NOT NULL
);

CREATE TABLE BLOBFLT (
    GUID      TGUID NOT NULL,
    NAME      VARCHAR(50) NOT NULL,
    BLOBDATA  BLOB SUB_TYPE -15 SEGMENT SIZE 80
);

CREATE TABLE COUNTRY (
    COUNTRY   COUNTRYNAME NOT NULL,
    CURRENCY  VARCHAR(10) NOT NULL
);

CREATE TABLE CUSTOMER (
    CUST_NO         CUSTNO NOT NULL,
    CUSTOMER        VARCHAR(25) NOT NULL,
    CONTACT_FIRST   FIRSTNAME,
    CONTACT_LAST    LASTNAME,
    PHONE_NO        PHONENUMBER,
    ADDRESS_LINE1   ADDRESSLINE,
    ADDRESS_LINE2   ADDRESSLINE,
    CITY            VARCHAR(25),
    STATE_PROVINCE  VARCHAR(15),
    COUNTRY         COUNTRYNAME,
    POSTAL_CODE     VARCHAR(12),
    ON_HOLD         CHAR(1) DEFAULT NULL
);

CREATE TABLE DEPARTMENT (
    DEPT_NO     DEPTNO NOT NULL,
    DEPARTMENT  VARCHAR(25) NOT NULL,
    HEAD_DEPT   DEPTNO,
    MNGR_NO     EMPNO,
    BUDGET      BUDGET,
    LOCATION    VARCHAR(15),
    PHONE_NO    PHONENUMBER DEFAULT '555-1234',
    DEPT_NO1    CUSTNO
);

CREATE TABLE EMPLOYEE (
    EMP_NO       EMPNO NOT NULL,
    FIRST_NAME   FIRSTNAME NOT NULL,
    LAST_NAME    LASTNAME NOT NULL,
    PHONE_EXT    VARCHAR(4),
    HIRE_DATE    DATE DEFAULT 'NOW' NOT NULL,
    DEPT_NO      DEPTNO NOT NULL,
    JOB_CODE     JOBCODE NOT NULL,
    JOB_GRADE    JOBGRADE NOT NULL,
    JOB_COUNTRY  COUNTRYNAME NOT NULL,
    SALARY       SALARY NOT NULL,
    FULL_NAME    COMPUTED BY (last_name || ', ' || first_name)
);

CREATE TABLE EMPLOYEE_PROJECT (
    EMP_NO   EMPNO NOT NULL,
    PROJ_ID  PROJNO NOT NULL
);

CREATE TABLE FIB$APP_STATISTICS (
    ID               INTEGER NOT NULL,
    APP_ID           VARCHAR(12),
    SQL_TEXT         BLOB SUB_TYPE 2 SEGMENT SIZE 1,
    EXECUTECOUNT     INTEGER,
    PREPARECOUNT     INTEGER,
    SUMTIMEEXECUTE   INTEGER,
    AVGTIMEEXECUTE   INTEGER,
    MAXTIMEEXECUTE   INTEGER,
    MAXTIME_PARAMS   BLOB SUB_TYPE 2 SEGMENT SIZE 1,
    LASTTIMEEXECUTE  INTEGER,
    LOG_DATE         DATE,
    CMP_NAME         VARCHAR(256),
    ATTACHMENT_ID    INTEGER
);

CREATE TABLE FIB$DATASETS_INFO (
    DS_ID                        INTEGER NOT NULL,
    DESCRIPTION                  VARCHAR(40),
    SELECT_SQL                   BLOB SUB_TYPE 1 SEGMENT SIZE 80,
    UPDATE_SQL                   BLOB SUB_TYPE 1 SEGMENT SIZE 80,
    INSERT_SQL                   BLOB SUB_TYPE 1 SEGMENT SIZE 80,
    DELETE_SQL                   BLOB SUB_TYPE 1 SEGMENT SIZE 80,
    REFRESH_SQL                  BLOB SUB_TYPE 1 SEGMENT SIZE 80,
    NAME_GENERATOR               VARCHAR(68),
    KEY_FIELD                    VARCHAR(68),
    UPDATE_TABLE_NAME            VARCHAR(68),
    UPDATE_ONLY_MODIFIED_FIELDS  FIB$BOOLEAN NOT NULL,
    CONDITIONS                   BLOB SUB_TYPE 1 SEGMENT SIZE 80,
    FIB$VERSION                  INTEGER
);

CREATE TABLE FIB$ERROR_MESSAGES (
    CONSTRAINT_NAME  VARCHAR(67) NOT NULL,
    MESSAGE_STRING   VARCHAR(100),
    FIB$VERSION      INTEGER,
    CONSTR_TYPE      VARCHAR(11) DEFAULT 'UNIQUE' NOT NULL
);

CREATE TABLE FIB$FIELDS_INFO (
    TABLE_NAME      VARCHAR(31) NOT NULL,
    FIELD_NAME      VARCHAR(31) NOT NULL,
    DISPLAY_LABEL   VARCHAR(25),
    VISIBLE         FIB$BOOLEAN DEFAULT 1 NOT NULL,
    DISPLAY_FORMAT  VARCHAR(15),
    EDIT_FORMAT     VARCHAR(15),
    TRIGGERED       FIB$BOOLEAN DEFAULT 0 NOT NULL,
    DISPLAY_WIDTH   INTEGER DEFAULT 0,
    FIB$VERSION     INTEGER,
    EDIT_MASK       VARCHAR(21)
);

CREATE TABLE JOB (
    JOB_CODE         JOBCODE NOT NULL,
    JOB_GRADE        JOBGRADE NOT NULL,
    JOB_COUNTRY      COUNTRYNAME NOT NULL,
    JOB_TITLE        VARCHAR(25) NOT NULL,
    MIN_SALARY       SALARY NOT NULL,
    MAX_SALARY       SALARY NOT NULL,
    JOB_REQUIREMENT  BLOB SUB_TYPE 1 SEGMENT SIZE 400,
    LANGUAGE_REQ     VARCHAR(15) [1:5]
);

CREATE TABLE PROJ_DEPT_BUDGET (
    PROJ_YEAR         INTEGER NOT NULL,
    PROJ_ID           PROJNO NOT NULL,
    DEPT_NO           DEPTNO NOT NULL,
    QUART_HEAD_CNT    INTEGER,
    PROJECTED_BUDGET  BUDGET
);

CREATE TABLE PROJECT (
    PROJ_ID      PROJNO NOT NULL,
    PROJ_NAME    VARCHAR(20) NOT NULL,
    PROJ_DESC    BLOB SUB_TYPE 1 SEGMENT SIZE 800,
    TEAM_LEADER  EMPNO,
    PRODUCT      PRODTYPE
);

CREATE TABLE SALARY_HISTORY (
    EMP_NO          EMPNO NOT NULL,
    CHANGE_DATE     DATE DEFAULT 'NOW' NOT NULL,
    UPDATER_ID      VARCHAR(20) NOT NULL,
    OLD_SALARY      SALARY NOT NULL,
    PERCENT_CHANGE  DOUBLE PRECISION DEFAULT 0 NOT NULL,
    NEW_SALARY      COMPUTED BY (old_salary + old_salary * percent_change / 100)
);

CREATE TABLE SALES (
    PO_NUMBER     PONUMBER NOT NULL,
    CUST_NO       CUSTNO NOT NULL,
    SALES_REP     EMPNO,
    ORDER_STATUS  VARCHAR(7) DEFAULT 'new' NOT NULL,
    ORDER_DATE    DATE DEFAULT 'now' NOT NULL,
    SHIP_DATE     DATE,
    DATE_NEEDED   DATE,
    PAID          CHAR(1) DEFAULT 'n',
    QTY_ORDERED   INTEGER DEFAULT 1 NOT NULL,
    TOTAL_VALUE   NUMERIC(9,2) NOT NULL,
    DISCOUNT      FLOAT DEFAULT 0 NOT NULL,
    ITEM_TYPE     PRODTYPE,
    AGED          COMPUTED BY (ship_date - order_date)
);



/******************************************************************************/
/***                                 Views                                  ***/
/******************************************************************************/


/* View: PHONE_LIST */
CREATE VIEW PHONE_LIST(
    EMP_NO,
    FIRST_NAME,
    LAST_NAME,
    PHONE_EXT,
    LOCATION,
    PHONE_NO)
AS
SELECT
    emp_no, first_name, last_name, phone_ext, location, phone_no
    FROM employee, department
    WHERE employee.dept_no = department.dept_no
;


INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1, 'ITEM #1__ITEM #1', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2, 'ITEM #2__ITEM #2', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3, 'ITEM #3__ITEM #3', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4, 'ITEM #4__ITEM #4', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5, 'ITEM #5__ITEM #5', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6, 'ITEM #6__ITEM #6', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7, 'ITEM #7__ITEM #7', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8, 'ITEM #8__ITEM #8', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9, 'ITEM #9__ITEM #9', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (10, 'ITEM #10__ITEM #10', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (11, 'ITEM #11__ITEM #11', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (12, 'ITEM #12__ITEM #12', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (13, 'ITEM #13__ITEM #13', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (14, 'ITEM #14__ITEM #14', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (15, 'ITEM #15__ITEM #15', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (16, 'ITEM #16__ITEM #16', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (17, 'ITEM #17__ITEM #17', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (18, 'ITEM #18__ITEM #18', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (19, 'ITEM #19__ITEM #19', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (20, 'ITEM #20__ITEM #20', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (21, 'ITEM #21__ITEM #21', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (22, 'ITEM #22__ITEM #22', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (23, 'ITEM #23__ITEM #23', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (24, 'ITEM #24__ITEM #24', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (25, 'ITEM #25__ITEM #25', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (26, 'ITEM #26__ITEM #26', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (27, 'ITEM #27__ITEM #27', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (28, 'ITEM #28__ITEM #28', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (29, 'ITEM #29__ITEM #29', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (30, 'ITEM #30__ITEM #30', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (31, 'ITEM #31__ITEM #31', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (32, 'ITEM #32__ITEM #32', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (33, 'ITEM #33__ITEM #33', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (34, 'ITEM #34__ITEM #34', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (35, 'ITEM #35__ITEM #35', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (36, 'ITEM #36__ITEM #36', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (37, 'ITEM #37__ITEM #37', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (38, 'ITEM #38__ITEM #38', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (39, 'ITEM #39__ITEM #39', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (40, 'ITEM #40__ITEM #40', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (41, 'ITEM #41__ITEM #41', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (42, 'ITEM #42__ITEM #42', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (43, 'ITEM #43__ITEM #43', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (44, 'ITEM #44__ITEM #44', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (45, 'ITEM #45__ITEM #45', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (46, 'ITEM #46__ITEM #46', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (47, 'ITEM #47__ITEM #47', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (48, 'ITEM #48__ITEM #48', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (49, 'ITEM #49__ITEM #49', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (50, 'ITEM #50__ITEM #50', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (51, 'ITEM #51__ITEM #51', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (52, 'ITEM #52__ITEM #52', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (53, 'ITEM #53__ITEM #53', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (54, 'ITEM #54__ITEM #54', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (55, 'ITEM #55__ITEM #55', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (56, 'ITEM #56__ITEM #56', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (57, 'ITEM #57__ITEM #57', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (58, 'ITEM #58__ITEM #58', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (59, 'ITEM #59__ITEM #59', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (60, 'ITEM #60__ITEM #60', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (61, 'ITEM #61__ITEM #61', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (62, 'ITEM #62__ITEM #62', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (63, 'ITEM #63__ITEM #63', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (64, 'ITEM #64__ITEM #64', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (65, 'ITEM #65__ITEM #65', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (66, 'ITEM #66__ITEM #66', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (67, 'ITEM #67__ITEM #67', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (68, 'ITEM #68__ITEM #68', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (69, 'ITEM #69__ITEM #69', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (70, 'ITEM #70__ITEM #70', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (71, 'ITEM #71__ITEM #71', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (72, 'ITEM #72__ITEM #72', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (73, 'ITEM #73__ITEM #73', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (74, 'ITEM #74__ITEM #74', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (75, 'ITEM #75__ITEM #75', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (76, 'ITEM #76__ITEM #76', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (77, 'ITEM #77__ITEM #77', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (78, 'ITEM #78__ITEM #78', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (79, 'ITEM #79__ITEM #79', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (80, 'ITEM #80__ITEM #80', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (81, 'ITEM #81__ITEM #81', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (82, 'ITEM #82__ITEM #82', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (83, 'ITEM #83__ITEM #83', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (84, 'ITEM #84__ITEM #84', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (85, 'ITEM #85__ITEM #85', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (86, 'ITEM #86__ITEM #86', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (87, 'ITEM #87__ITEM #87', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (88, 'ITEM #88__ITEM #88', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (89, 'ITEM #89__ITEM #89', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (90, 'ITEM #90__ITEM #90', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (91, 'ITEM #91__ITEM #91', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (92, 'ITEM #92__ITEM #92', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (93, 'ITEM #93__ITEM #93', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (94, 'ITEM #94__ITEM #94', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (95, 'ITEM #95__ITEM #95', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (96, 'ITEM #96__ITEM #96', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (97, 'ITEM #97__ITEM #97', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (98, 'ITEM #98__ITEM #98', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (99, 'ITEM #99__ITEM #99', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (100, 'ITEM #100__ITEM #100', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (101, 'ITEM #101__ITEM #101', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (102, 'ITEM #102__ITEM #102', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (103, 'ITEM #103__ITEM #103', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (104, 'ITEM #104__ITEM #104', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (105, 'ITEM #105__ITEM #105', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (106, 'ITEM #106__ITEM #106', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (107, 'ITEM #107__ITEM #107', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (108, 'ITEM #108__ITEM #108', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (109, 'ITEM #109__ITEM #109', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (110, 'ITEM #110__ITEM #110', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (111, 'ITEM #111__ITEM #111', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (112, 'ITEM #112__ITEM #112', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (113, 'ITEM #113__ITEM #113', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (114, 'ITEM #114__ITEM #114', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (115, 'ITEM #115__ITEM #115', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (116, 'ITEM #116__ITEM #116', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (117, 'ITEM #117__ITEM #117', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (118, 'ITEM #118__ITEM #118', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (119, 'ITEM #119__ITEM #119', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (120, 'ITEM #120__ITEM #120', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (121, 'ITEM #121__ITEM #121', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (122, 'ITEM #122__ITEM #122', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (123, 'ITEM #123__ITEM #123', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (124, 'ITEM #124__ITEM #124', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (125, 'ITEM #125__ITEM #125', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (126, 'ITEM #126__ITEM #126', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (127, 'ITEM #127__ITEM #127', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (128, 'ITEM #128__ITEM #128', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (129, 'ITEM #129__ITEM #129', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (130, 'ITEM #130__ITEM #130', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (131, 'ITEM #131__ITEM #131', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (132, 'ITEM #132__ITEM #132', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (133, 'ITEM #133__ITEM #133', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (134, 'ITEM #134__ITEM #134', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (135, 'ITEM #135__ITEM #135', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (136, 'ITEM #136__ITEM #136', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (137, 'ITEM #137__ITEM #137', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (138, 'ITEM #138__ITEM #138', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (139, 'ITEM #139__ITEM #139', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (140, 'ITEM #140__ITEM #140', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (141, 'ITEM #141__ITEM #141', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (142, 'ITEM #142__ITEM #142', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (143, 'ITEM #143__ITEM #143', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (144, 'ITEM #144__ITEM #144', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (145, 'ITEM #145__ITEM #145', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (146, 'ITEM #146__ITEM #146', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (147, 'ITEM #147__ITEM #147', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (148, 'ITEM #148__ITEM #148', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (149, 'ITEM #149__ITEM #149', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (150, 'ITEM #150__ITEM #150', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (151, 'ITEM #151__ITEM #151', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (152, 'ITEM #152__ITEM #152', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (153, 'ITEM #153__ITEM #153', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (154, 'ITEM #154__ITEM #154', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (155, 'ITEM #155__ITEM #155', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (156, 'ITEM #156__ITEM #156', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (157, 'ITEM #157__ITEM #157', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (158, 'ITEM #158__ITEM #158', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (159, 'ITEM #159__ITEM #159', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (160, 'ITEM #160__ITEM #160', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (161, 'ITEM #161__ITEM #161', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (162, 'ITEM #162__ITEM #162', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (163, 'ITEM #163__ITEM #163', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (164, 'ITEM #164__ITEM #164', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (165, 'ITEM #165__ITEM #165', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (166, 'ITEM #166__ITEM #166', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (167, 'ITEM #167__ITEM #167', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (168, 'ITEM #168__ITEM #168', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (169, 'ITEM #169__ITEM #169', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (170, 'ITEM #170__ITEM #170', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (171, 'ITEM #171__ITEM #171', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (172, 'ITEM #172__ITEM #172', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (173, 'ITEM #173__ITEM #173', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (174, 'ITEM #174__ITEM #174', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (175, 'ITEM #175__ITEM #175', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (176, 'ITEM #176__ITEM #176', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (177, 'ITEM #177__ITEM #177', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (178, 'ITEM #178__ITEM #178', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (179, 'ITEM #179__ITEM #179', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (180, 'ITEM #180__ITEM #180', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (181, 'ITEM #181__ITEM #181', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (182, 'ITEM #182__ITEM #182', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (183, 'ITEM #183__ITEM #183', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (184, 'ITEM #184__ITEM #184', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (185, 'ITEM #185__ITEM #185', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (186, 'ITEM #186__ITEM #186', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (187, 'ITEM #187__ITEM #187', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (188, 'ITEM #188__ITEM #188', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (189, 'ITEM #189__ITEM #189', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (190, 'ITEM #190__ITEM #190', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (191, 'ITEM #191__ITEM #191', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (192, 'ITEM #192__ITEM #192', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (193, 'ITEM #193__ITEM #193', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (194, 'ITEM #194__ITEM #194', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (195, 'ITEM #195__ITEM #195', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (196, 'ITEM #196__ITEM #196', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (197, 'ITEM #197__ITEM #197', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (198, 'ITEM #198__ITEM #198', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (199, 'ITEM #199__ITEM #199', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (200, 'ITEM #200__ITEM #200', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (201, 'ITEM #201__ITEM #201', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (202, 'ITEM #202__ITEM #202', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (203, 'ITEM #203__ITEM #203', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (204, 'ITEM #204__ITEM #204', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (205, 'ITEM #205__ITEM #205', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (206, 'ITEM #206__ITEM #206', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (207, 'ITEM #207__ITEM #207', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (208, 'ITEM #208__ITEM #208', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (209, 'ITEM #209__ITEM #209', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (210, 'ITEM #210__ITEM #210', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (211, 'ITEM #211__ITEM #211', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (212, 'ITEM #212__ITEM #212', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (213, 'ITEM #213__ITEM #213', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (214, 'ITEM #214__ITEM #214', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (215, 'ITEM #215__ITEM #215', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (216, 'ITEM #216__ITEM #216', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (217, 'ITEM #217__ITEM #217', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (218, 'ITEM #218__ITEM #218', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (219, 'ITEM #219__ITEM #219', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (220, 'ITEM #220__ITEM #220', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (221, 'ITEM #221__ITEM #221', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (222, 'ITEM #222__ITEM #222', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (223, 'ITEM #223__ITEM #223', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (224, 'ITEM #224__ITEM #224', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (225, 'ITEM #225__ITEM #225', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (226, 'ITEM #226__ITEM #226', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (227, 'ITEM #227__ITEM #227', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (228, 'ITEM #228__ITEM #228', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (229, 'ITEM #229__ITEM #229', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (230, 'ITEM #230__ITEM #230', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (231, 'ITEM #231__ITEM #231', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (232, 'ITEM #232__ITEM #232', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (233, 'ITEM #233__ITEM #233', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (234, 'ITEM #234__ITEM #234', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (235, 'ITEM #235__ITEM #235', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (236, 'ITEM #236__ITEM #236', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (237, 'ITEM #237__ITEM #237', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (238, 'ITEM #238__ITEM #238', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (239, 'ITEM #239__ITEM #239', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (240, 'ITEM #240__ITEM #240', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (241, 'ITEM #241__ITEM #241', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (242, 'ITEM #242__ITEM #242', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (243, 'ITEM #243__ITEM #243', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (244, 'ITEM #244__ITEM #244', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (245, 'ITEM #245__ITEM #245', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (246, 'ITEM #246__ITEM #246', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (247, 'ITEM #247__ITEM #247', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (248, 'ITEM #248__ITEM #248', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (249, 'ITEM #249__ITEM #249', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (250, 'ITEM #250__ITEM #250', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (251, 'ITEM #251__ITEM #251', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (252, 'ITEM #252__ITEM #252', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (253, 'ITEM #253__ITEM #253', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (254, 'ITEM #254__ITEM #254', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (255, 'ITEM #255__ITEM #255', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (256, 'ITEM #256__ITEM #256', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (257, 'ITEM #257__ITEM #257', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (258, 'ITEM #258__ITEM #258', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (259, 'ITEM #259__ITEM #259', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (260, 'ITEM #260__ITEM #260', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (261, 'ITEM #261__ITEM #261', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (262, 'ITEM #262__ITEM #262', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (263, 'ITEM #263__ITEM #263', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (264, 'ITEM #264__ITEM #264', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (265, 'ITEM #265__ITEM #265', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (266, 'ITEM #266__ITEM #266', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (267, 'ITEM #267__ITEM #267', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (268, 'ITEM #268__ITEM #268', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (269, 'ITEM #269__ITEM #269', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (270, 'ITEM #270__ITEM #270', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (271, 'ITEM #271__ITEM #271', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (272, 'ITEM #272__ITEM #272', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (273, 'ITEM #273__ITEM #273', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (274, 'ITEM #274__ITEM #274', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (275, 'ITEM #275__ITEM #275', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (276, 'ITEM #276__ITEM #276', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (277, 'ITEM #277__ITEM #277', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (278, 'ITEM #278__ITEM #278', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (279, 'ITEM #279__ITEM #279', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (280, 'ITEM #280__ITEM #280', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (281, 'ITEM #281__ITEM #281', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (282, 'ITEM #282__ITEM #282', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (283, 'ITEM #283__ITEM #283', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (284, 'ITEM #284__ITEM #284', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (285, 'ITEM #285__ITEM #285', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (286, 'ITEM #286__ITEM #286', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (287, 'ITEM #287__ITEM #287', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (288, 'ITEM #288__ITEM #288', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (289, 'ITEM #289__ITEM #289', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (290, 'ITEM #290__ITEM #290', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (291, 'ITEM #291__ITEM #291', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (292, 'ITEM #292__ITEM #292', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (293, 'ITEM #293__ITEM #293', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (294, 'ITEM #294__ITEM #294', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (295, 'ITEM #295__ITEM #295', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (296, 'ITEM #296__ITEM #296', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (297, 'ITEM #297__ITEM #297', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (298, 'ITEM #298__ITEM #298', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (299, 'ITEM #299__ITEM #299', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (300, 'ITEM #300__ITEM #300', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (301, 'ITEM #301__ITEM #301', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (302, 'ITEM #302__ITEM #302', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (303, 'ITEM #303__ITEM #303', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (304, 'ITEM #304__ITEM #304', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (305, 'ITEM #305__ITEM #305', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (306, 'ITEM #306__ITEM #306', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (307, 'ITEM #307__ITEM #307', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (308, 'ITEM #308__ITEM #308', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (309, 'ITEM #309__ITEM #309', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (310, 'ITEM #310__ITEM #310', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (311, 'ITEM #311__ITEM #311', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (312, 'ITEM #312__ITEM #312', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (313, 'ITEM #313__ITEM #313', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (314, 'ITEM #314__ITEM #314', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (315, 'ITEM #315__ITEM #315', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (316, 'ITEM #316__ITEM #316', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (317, 'ITEM #317__ITEM #317', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (318, 'ITEM #318__ITEM #318', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (319, 'ITEM #319__ITEM #319', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (320, 'ITEM #320__ITEM #320', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (321, 'ITEM #321__ITEM #321', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (322, 'ITEM #322__ITEM #322', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (323, 'ITEM #323__ITEM #323', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (324, 'ITEM #324__ITEM #324', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (325, 'ITEM #325__ITEM #325', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (326, 'ITEM #326__ITEM #326', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (327, 'ITEM #327__ITEM #327', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (328, 'ITEM #328__ITEM #328', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (329, 'ITEM #329__ITEM #329', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (330, 'ITEM #330__ITEM #330', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (331, 'ITEM #331__ITEM #331', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (332, 'ITEM #332__ITEM #332', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (333, 'ITEM #333__ITEM #333', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (334, 'ITEM #334__ITEM #334', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (335, 'ITEM #335__ITEM #335', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (336, 'ITEM #336__ITEM #336', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (337, 'ITEM #337__ITEM #337', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (338, 'ITEM #338__ITEM #338', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (339, 'ITEM #339__ITEM #339', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (340, 'ITEM #340__ITEM #340', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (341, 'ITEM #341__ITEM #341', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (342, 'ITEM #342__ITEM #342', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (343, 'ITEM #343__ITEM #343', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (344, 'ITEM #344__ITEM #344', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (345, 'ITEM #345__ITEM #345', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (346, 'ITEM #346__ITEM #346', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (347, 'ITEM #347__ITEM #347', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (348, 'ITEM #348__ITEM #348', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (349, 'ITEM #349__ITEM #349', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (350, 'ITEM #350__ITEM #350', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (351, 'ITEM #351__ITEM #351', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (352, 'ITEM #352__ITEM #352', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (353, 'ITEM #353__ITEM #353', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (354, 'ITEM #354__ITEM #354', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (355, 'ITEM #355__ITEM #355', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (356, 'ITEM #356__ITEM #356', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (357, 'ITEM #357__ITEM #357', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (358, 'ITEM #358__ITEM #358', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (359, 'ITEM #359__ITEM #359', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (360, 'ITEM #360__ITEM #360', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (361, 'ITEM #361__ITEM #361', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (362, 'ITEM #362__ITEM #362', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (363, 'ITEM #363__ITEM #363', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (364, 'ITEM #364__ITEM #364', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (365, 'ITEM #365__ITEM #365', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (366, 'ITEM #366__ITEM #366', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (367, 'ITEM #367__ITEM #367', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (368, 'ITEM #368__ITEM #368', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (369, 'ITEM #369__ITEM #369', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (370, 'ITEM #370__ITEM #370', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (371, 'ITEM #371__ITEM #371', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (372, 'ITEM #372__ITEM #372', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (373, 'ITEM #373__ITEM #373', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (374, 'ITEM #374__ITEM #374', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (375, 'ITEM #375__ITEM #375', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (376, 'ITEM #376__ITEM #376', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (377, 'ITEM #377__ITEM #377', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (378, 'ITEM #378__ITEM #378', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (379, 'ITEM #379__ITEM #379', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (380, 'ITEM #380__ITEM #380', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (381, 'ITEM #381__ITEM #381', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (382, 'ITEM #382__ITEM #382', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (383, 'ITEM #383__ITEM #383', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (384, 'ITEM #384__ITEM #384', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (385, 'ITEM #385__ITEM #385', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (386, 'ITEM #386__ITEM #386', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (387, 'ITEM #387__ITEM #387', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (388, 'ITEM #388__ITEM #388', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (389, 'ITEM #389__ITEM #389', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (390, 'ITEM #390__ITEM #390', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (391, 'ITEM #391__ITEM #391', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (392, 'ITEM #392__ITEM #392', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (393, 'ITEM #393__ITEM #393', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (394, 'ITEM #394__ITEM #394', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (395, 'ITEM #395__ITEM #395', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (396, 'ITEM #396__ITEM #396', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (397, 'ITEM #397__ITEM #397', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (398, 'ITEM #398__ITEM #398', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (399, 'ITEM #399__ITEM #399', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (400, 'ITEM #400__ITEM #400', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (401, 'ITEM #401__ITEM #401', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (402, 'ITEM #402__ITEM #402', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (403, 'ITEM #403__ITEM #403', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (404, 'ITEM #404__ITEM #404', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (405, 'ITEM #405__ITEM #405', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (406, 'ITEM #406__ITEM #406', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (407, 'ITEM #407__ITEM #407', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (408, 'ITEM #408__ITEM #408', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (409, 'ITEM #409__ITEM #409', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (410, 'ITEM #410__ITEM #410', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (411, 'ITEM #411__ITEM #411', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (412, 'ITEM #412__ITEM #412', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (413, 'ITEM #413__ITEM #413', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (414, 'ITEM #414__ITEM #414', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (415, 'ITEM #415__ITEM #415', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (416, 'ITEM #416__ITEM #416', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (417, 'ITEM #417__ITEM #417', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (418, 'ITEM #418__ITEM #418', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (419, 'ITEM #419__ITEM #419', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (420, 'ITEM #420__ITEM #420', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (421, 'ITEM #421__ITEM #421', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (422, 'ITEM #422__ITEM #422', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (423, 'ITEM #423__ITEM #423', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (424, 'ITEM #424__ITEM #424', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (425, 'ITEM #425__ITEM #425', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (426, 'ITEM #426__ITEM #426', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (427, 'ITEM #427__ITEM #427', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (428, 'ITEM #428__ITEM #428', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (429, 'ITEM #429__ITEM #429', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (430, 'ITEM #430__ITEM #430', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (431, 'ITEM #431__ITEM #431', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (432, 'ITEM #432__ITEM #432', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (433, 'ITEM #433__ITEM #433', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (434, 'ITEM #434__ITEM #434', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (435, 'ITEM #435__ITEM #435', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (436, 'ITEM #436__ITEM #436', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (437, 'ITEM #437__ITEM #437', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (438, 'ITEM #438__ITEM #438', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (439, 'ITEM #439__ITEM #439', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (440, 'ITEM #440__ITEM #440', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (441, 'ITEM #441__ITEM #441', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (442, 'ITEM #442__ITEM #442', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (443, 'ITEM #443__ITEM #443', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (444, 'ITEM #444__ITEM #444', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (445, 'ITEM #445__ITEM #445', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (446, 'ITEM #446__ITEM #446', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (447, 'ITEM #447__ITEM #447', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (448, 'ITEM #448__ITEM #448', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (449, 'ITEM #449__ITEM #449', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (450, 'ITEM #450__ITEM #450', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (451, 'ITEM #451__ITEM #451', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (452, 'ITEM #452__ITEM #452', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (453, 'ITEM #453__ITEM #453', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (454, 'ITEM #454__ITEM #454', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (455, 'ITEM #455__ITEM #455', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (456, 'ITEM #456__ITEM #456', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (457, 'ITEM #457__ITEM #457', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (458, 'ITEM #458__ITEM #458', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (459, 'ITEM #459__ITEM #459', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (460, 'ITEM #460__ITEM #460', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (461, 'ITEM #461__ITEM #461', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (462, 'ITEM #462__ITEM #462', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (463, 'ITEM #463__ITEM #463', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (464, 'ITEM #464__ITEM #464', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (465, 'ITEM #465__ITEM #465', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (466, 'ITEM #466__ITEM #466', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (467, 'ITEM #467__ITEM #467', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (468, 'ITEM #468__ITEM #468', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (469, 'ITEM #469__ITEM #469', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (470, 'ITEM #470__ITEM #470', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (471, 'ITEM #471__ITEM #471', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (472, 'ITEM #472__ITEM #472', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (473, 'ITEM #473__ITEM #473', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (474, 'ITEM #474__ITEM #474', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (475, 'ITEM #475__ITEM #475', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (476, 'ITEM #476__ITEM #476', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (477, 'ITEM #477__ITEM #477', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (478, 'ITEM #478__ITEM #478', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (479, 'ITEM #479__ITEM #479', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (480, 'ITEM #480__ITEM #480', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (481, 'ITEM #481__ITEM #481', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (482, 'ITEM #482__ITEM #482', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (483, 'ITEM #483__ITEM #483', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (484, 'ITEM #484__ITEM #484', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (485, 'ITEM #485__ITEM #485', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (486, 'ITEM #486__ITEM #486', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (487, 'ITEM #487__ITEM #487', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (488, 'ITEM #488__ITEM #488', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (489, 'ITEM #489__ITEM #489', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (490, 'ITEM #490__ITEM #490', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (491, 'ITEM #491__ITEM #491', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (492, 'ITEM #492__ITEM #492', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (493, 'ITEM #493__ITEM #493', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (494, 'ITEM #494__ITEM #494', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (495, 'ITEM #495__ITEM #495', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (496, 'ITEM #496__ITEM #496', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (497, 'ITEM #497__ITEM #497', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (498, 'ITEM #498__ITEM #498', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (499, 'ITEM #499__ITEM #499', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (500, 'ITEM #500__ITEM #500', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (501, 'ITEM #501__ITEM #501', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (502, 'ITEM #502__ITEM #502', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (503, 'ITEM #503__ITEM #503', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (504, 'ITEM #504__ITEM #504', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (505, 'ITEM #505__ITEM #505', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (506, 'ITEM #506__ITEM #506', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (507, 'ITEM #507__ITEM #507', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (508, 'ITEM #508__ITEM #508', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (509, 'ITEM #509__ITEM #509', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (510, 'ITEM #510__ITEM #510', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (511, 'ITEM #511__ITEM #511', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (512, 'ITEM #512__ITEM #512', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (513, 'ITEM #513__ITEM #513', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (514, 'ITEM #514__ITEM #514', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (515, 'ITEM #515__ITEM #515', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (516, 'ITEM #516__ITEM #516', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (517, 'ITEM #517__ITEM #517', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (518, 'ITEM #518__ITEM #518', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (519, 'ITEM #519__ITEM #519', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (520, 'ITEM #520__ITEM #520', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (521, 'ITEM #521__ITEM #521', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (522, 'ITEM #522__ITEM #522', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (523, 'ITEM #523__ITEM #523', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (524, 'ITEM #524__ITEM #524', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (525, 'ITEM #525__ITEM #525', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (526, 'ITEM #526__ITEM #526', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (527, 'ITEM #527__ITEM #527', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (528, 'ITEM #528__ITEM #528', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (529, 'ITEM #529__ITEM #529', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (530, 'ITEM #530__ITEM #530', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (531, 'ITEM #531__ITEM #531', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (532, 'ITEM #532__ITEM #532', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (533, 'ITEM #533__ITEM #533', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (534, 'ITEM #534__ITEM #534', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (535, 'ITEM #535__ITEM #535', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (536, 'ITEM #536__ITEM #536', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (537, 'ITEM #537__ITEM #537', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (538, 'ITEM #538__ITEM #538', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (539, 'ITEM #539__ITEM #539', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (540, 'ITEM #540__ITEM #540', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (541, 'ITEM #541__ITEM #541', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (542, 'ITEM #542__ITEM #542', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (543, 'ITEM #543__ITEM #543', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (544, 'ITEM #544__ITEM #544', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (545, 'ITEM #545__ITEM #545', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (546, 'ITEM #546__ITEM #546', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (547, 'ITEM #547__ITEM #547', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (548, 'ITEM #548__ITEM #548', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (549, 'ITEM #549__ITEM #549', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (550, 'ITEM #550__ITEM #550', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (551, 'ITEM #551__ITEM #551', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (552, 'ITEM #552__ITEM #552', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (553, 'ITEM #553__ITEM #553', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (554, 'ITEM #554__ITEM #554', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (555, 'ITEM #555__ITEM #555', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (556, 'ITEM #556__ITEM #556', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (557, 'ITEM #557__ITEM #557', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (558, 'ITEM #558__ITEM #558', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (559, 'ITEM #559__ITEM #559', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (560, 'ITEM #560__ITEM #560', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (561, 'ITEM #561__ITEM #561', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (562, 'ITEM #562__ITEM #562', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (563, 'ITEM #563__ITEM #563', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (564, 'ITEM #564__ITEM #564', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (565, 'ITEM #565__ITEM #565', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (566, 'ITEM #566__ITEM #566', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (567, 'ITEM #567__ITEM #567', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (568, 'ITEM #568__ITEM #568', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (569, 'ITEM #569__ITEM #569', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (570, 'ITEM #570__ITEM #570', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (571, 'ITEM #571__ITEM #571', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (572, 'ITEM #572__ITEM #572', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (573, 'ITEM #573__ITEM #573', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (574, 'ITEM #574__ITEM #574', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (575, 'ITEM #575__ITEM #575', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (576, 'ITEM #576__ITEM #576', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (577, 'ITEM #577__ITEM #577', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (578, 'ITEM #578__ITEM #578', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (579, 'ITEM #579__ITEM #579', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (580, 'ITEM #580__ITEM #580', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (581, 'ITEM #581__ITEM #581', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (582, 'ITEM #582__ITEM #582', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (583, 'ITEM #583__ITEM #583', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (584, 'ITEM #584__ITEM #584', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (585, 'ITEM #585__ITEM #585', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (586, 'ITEM #586__ITEM #586', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (587, 'ITEM #587__ITEM #587', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (588, 'ITEM #588__ITEM #588', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (589, 'ITEM #589__ITEM #589', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (590, 'ITEM #590__ITEM #590', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (591, 'ITEM #591__ITEM #591', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (592, 'ITEM #592__ITEM #592', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (593, 'ITEM #593__ITEM #593', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (594, 'ITEM #594__ITEM #594', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (595, 'ITEM #595__ITEM #595', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (596, 'ITEM #596__ITEM #596', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (597, 'ITEM #597__ITEM #597', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (598, 'ITEM #598__ITEM #598', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (599, 'ITEM #599__ITEM #599', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (600, 'ITEM #600__ITEM #600', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (601, 'ITEM #601__ITEM #601', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (602, 'ITEM #602__ITEM #602', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (603, 'ITEM #603__ITEM #603', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (604, 'ITEM #604__ITEM #604', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (605, 'ITEM #605__ITEM #605', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (606, 'ITEM #606__ITEM #606', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (607, 'ITEM #607__ITEM #607', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (608, 'ITEM #608__ITEM #608', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (609, 'ITEM #609__ITEM #609', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (610, 'ITEM #610__ITEM #610', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (611, 'ITEM #611__ITEM #611', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (612, 'ITEM #612__ITEM #612', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (613, 'ITEM #613__ITEM #613', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (614, 'ITEM #614__ITEM #614', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (615, 'ITEM #615__ITEM #615', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (616, 'ITEM #616__ITEM #616', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (617, 'ITEM #617__ITEM #617', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (618, 'ITEM #618__ITEM #618', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (619, 'ITEM #619__ITEM #619', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (620, 'ITEM #620__ITEM #620', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (621, 'ITEM #621__ITEM #621', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (622, 'ITEM #622__ITEM #622', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (623, 'ITEM #623__ITEM #623', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (624, 'ITEM #624__ITEM #624', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (625, 'ITEM #625__ITEM #625', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (626, 'ITEM #626__ITEM #626', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (627, 'ITEM #627__ITEM #627', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (628, 'ITEM #628__ITEM #628', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (629, 'ITEM #629__ITEM #629', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (630, 'ITEM #630__ITEM #630', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (631, 'ITEM #631__ITEM #631', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (632, 'ITEM #632__ITEM #632', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (633, 'ITEM #633__ITEM #633', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (634, 'ITEM #634__ITEM #634', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (635, 'ITEM #635__ITEM #635', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (636, 'ITEM #636__ITEM #636', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (637, 'ITEM #637__ITEM #637', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (638, 'ITEM #638__ITEM #638', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (639, 'ITEM #639__ITEM #639', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (640, 'ITEM #640__ITEM #640', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (641, 'ITEM #641__ITEM #641', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (642, 'ITEM #642__ITEM #642', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (643, 'ITEM #643__ITEM #643', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (644, 'ITEM #644__ITEM #644', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (645, 'ITEM #645__ITEM #645', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (646, 'ITEM #646__ITEM #646', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (647, 'ITEM #647__ITEM #647', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (648, 'ITEM #648__ITEM #648', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (649, 'ITEM #649__ITEM #649', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (650, 'ITEM #650__ITEM #650', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (651, 'ITEM #651__ITEM #651', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (652, 'ITEM #652__ITEM #652', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (653, 'ITEM #653__ITEM #653', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (654, 'ITEM #654__ITEM #654', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (655, 'ITEM #655__ITEM #655', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (656, 'ITEM #656__ITEM #656', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (657, 'ITEM #657__ITEM #657', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (658, 'ITEM #658__ITEM #658', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (659, 'ITEM #659__ITEM #659', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (660, 'ITEM #660__ITEM #660', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (661, 'ITEM #661__ITEM #661', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (662, 'ITEM #662__ITEM #662', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (663, 'ITEM #663__ITEM #663', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (664, 'ITEM #664__ITEM #664', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (665, 'ITEM #665__ITEM #665', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (666, 'ITEM #666__ITEM #666', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (667, 'ITEM #667__ITEM #667', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (668, 'ITEM #668__ITEM #668', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (669, 'ITEM #669__ITEM #669', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (670, 'ITEM #670__ITEM #670', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (671, 'ITEM #671__ITEM #671', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (672, 'ITEM #672__ITEM #672', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (673, 'ITEM #673__ITEM #673', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (674, 'ITEM #674__ITEM #674', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (675, 'ITEM #675__ITEM #675', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (676, 'ITEM #676__ITEM #676', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (677, 'ITEM #677__ITEM #677', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (678, 'ITEM #678__ITEM #678', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (679, 'ITEM #679__ITEM #679', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (680, 'ITEM #680__ITEM #680', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (681, 'ITEM #681__ITEM #681', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (682, 'ITEM #682__ITEM #682', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (683, 'ITEM #683__ITEM #683', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (684, 'ITEM #684__ITEM #684', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (685, 'ITEM #685__ITEM #685', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (686, 'ITEM #686__ITEM #686', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (687, 'ITEM #687__ITEM #687', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (688, 'ITEM #688__ITEM #688', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (689, 'ITEM #689__ITEM #689', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (690, 'ITEM #690__ITEM #690', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (691, 'ITEM #691__ITEM #691', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (692, 'ITEM #692__ITEM #692', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (693, 'ITEM #693__ITEM #693', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (694, 'ITEM #694__ITEM #694', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (695, 'ITEM #695__ITEM #695', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (696, 'ITEM #696__ITEM #696', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (697, 'ITEM #697__ITEM #697', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (698, 'ITEM #698__ITEM #698', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (699, 'ITEM #699__ITEM #699', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (700, 'ITEM #700__ITEM #700', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (701, 'ITEM #701__ITEM #701', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (702, 'ITEM #702__ITEM #702', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (703, 'ITEM #703__ITEM #703', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (704, 'ITEM #704__ITEM #704', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (705, 'ITEM #705__ITEM #705', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (706, 'ITEM #706__ITEM #706', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (707, 'ITEM #707__ITEM #707', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (708, 'ITEM #708__ITEM #708', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (709, 'ITEM #709__ITEM #709', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (710, 'ITEM #710__ITEM #710', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (711, 'ITEM #711__ITEM #711', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (712, 'ITEM #712__ITEM #712', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (713, 'ITEM #713__ITEM #713', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (714, 'ITEM #714__ITEM #714', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (715, 'ITEM #715__ITEM #715', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (716, 'ITEM #716__ITEM #716', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (717, 'ITEM #717__ITEM #717', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (718, 'ITEM #718__ITEM #718', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (719, 'ITEM #719__ITEM #719', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (720, 'ITEM #720__ITEM #720', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (721, 'ITEM #721__ITEM #721', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (722, 'ITEM #722__ITEM #722', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (723, 'ITEM #723__ITEM #723', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (724, 'ITEM #724__ITEM #724', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (725, 'ITEM #725__ITEM #725', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (726, 'ITEM #726__ITEM #726', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (727, 'ITEM #727__ITEM #727', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (728, 'ITEM #728__ITEM #728', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (729, 'ITEM #729__ITEM #729', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (730, 'ITEM #730__ITEM #730', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (731, 'ITEM #731__ITEM #731', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (732, 'ITEM #732__ITEM #732', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (733, 'ITEM #733__ITEM #733', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (734, 'ITEM #734__ITEM #734', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (735, 'ITEM #735__ITEM #735', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (736, 'ITEM #736__ITEM #736', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (737, 'ITEM #737__ITEM #737', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (738, 'ITEM #738__ITEM #738', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (739, 'ITEM #739__ITEM #739', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (740, 'ITEM #740__ITEM #740', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (741, 'ITEM #741__ITEM #741', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (742, 'ITEM #742__ITEM #742', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (743, 'ITEM #743__ITEM #743', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (744, 'ITEM #744__ITEM #744', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (745, 'ITEM #745__ITEM #745', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (746, 'ITEM #746__ITEM #746', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (747, 'ITEM #747__ITEM #747', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (748, 'ITEM #748__ITEM #748', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (749, 'ITEM #749__ITEM #749', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (750, 'ITEM #750__ITEM #750', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (751, 'ITEM #751__ITEM #751', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (752, 'ITEM #752__ITEM #752', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (753, 'ITEM #753__ITEM #753', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (754, 'ITEM #754__ITEM #754', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (755, 'ITEM #755__ITEM #755', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (756, 'ITEM #756__ITEM #756', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (757, 'ITEM #757__ITEM #757', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (758, 'ITEM #758__ITEM #758', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (759, 'ITEM #759__ITEM #759', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (760, 'ITEM #760__ITEM #760', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (761, 'ITEM #761__ITEM #761', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (762, 'ITEM #762__ITEM #762', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (763, 'ITEM #763__ITEM #763', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (764, 'ITEM #764__ITEM #764', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (765, 'ITEM #765__ITEM #765', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (766, 'ITEM #766__ITEM #766', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (767, 'ITEM #767__ITEM #767', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (768, 'ITEM #768__ITEM #768', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (769, 'ITEM #769__ITEM #769', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (770, 'ITEM #770__ITEM #770', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (771, 'ITEM #771__ITEM #771', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (772, 'ITEM #772__ITEM #772', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (773, 'ITEM #773__ITEM #773', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (774, 'ITEM #774__ITEM #774', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (775, 'ITEM #775__ITEM #775', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (776, 'ITEM #776__ITEM #776', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (777, 'ITEM #777__ITEM #777', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (778, 'ITEM #778__ITEM #778', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (779, 'ITEM #779__ITEM #779', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (780, 'ITEM #780__ITEM #780', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (781, 'ITEM #781__ITEM #781', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (782, 'ITEM #782__ITEM #782', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (783, 'ITEM #783__ITEM #783', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (784, 'ITEM #784__ITEM #784', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (785, 'ITEM #785__ITEM #785', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (786, 'ITEM #786__ITEM #786', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (787, 'ITEM #787__ITEM #787', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (788, 'ITEM #788__ITEM #788', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (789, 'ITEM #789__ITEM #789', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (790, 'ITEM #790__ITEM #790', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (791, 'ITEM #791__ITEM #791', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (792, 'ITEM #792__ITEM #792', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (793, 'ITEM #793__ITEM #793', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (794, 'ITEM #794__ITEM #794', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (795, 'ITEM #795__ITEM #795', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (796, 'ITEM #796__ITEM #796', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (797, 'ITEM #797__ITEM #797', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (798, 'ITEM #798__ITEM #798', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (799, 'ITEM #799__ITEM #799', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (800, 'ITEM #800__ITEM #800', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (801, 'ITEM #801__ITEM #801', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (802, 'ITEM #802__ITEM #802', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (803, 'ITEM #803__ITEM #803', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (804, 'ITEM #804__ITEM #804', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (805, 'ITEM #805__ITEM #805', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (806, 'ITEM #806__ITEM #806', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (807, 'ITEM #807__ITEM #807', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (808, 'ITEM #808__ITEM #808', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (809, 'ITEM #809__ITEM #809', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (810, 'ITEM #810__ITEM #810', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (811, 'ITEM #811__ITEM #811', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (812, 'ITEM #812__ITEM #812', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (813, 'ITEM #813__ITEM #813', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (814, 'ITEM #814__ITEM #814', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (815, 'ITEM #815__ITEM #815', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (816, 'ITEM #816__ITEM #816', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (817, 'ITEM #817__ITEM #817', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (818, 'ITEM #818__ITEM #818', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (819, 'ITEM #819__ITEM #819', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (820, 'ITEM #820__ITEM #820', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (821, 'ITEM #821__ITEM #821', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (822, 'ITEM #822__ITEM #822', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (823, 'ITEM #823__ITEM #823', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (824, 'ITEM #824__ITEM #824', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (825, 'ITEM #825__ITEM #825', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (826, 'ITEM #826__ITEM #826', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (827, 'ITEM #827__ITEM #827', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (828, 'ITEM #828__ITEM #828', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (829, 'ITEM #829__ITEM #829', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (830, 'ITEM #830__ITEM #830', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (831, 'ITEM #831__ITEM #831', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (832, 'ITEM #832__ITEM #832', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (833, 'ITEM #833__ITEM #833', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (834, 'ITEM #834__ITEM #834', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (835, 'ITEM #835__ITEM #835', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (836, 'ITEM #836__ITEM #836', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (837, 'ITEM #837__ITEM #837', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (838, 'ITEM #838__ITEM #838', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (839, 'ITEM #839__ITEM #839', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (840, 'ITEM #840__ITEM #840', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (841, 'ITEM #841__ITEM #841', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (842, 'ITEM #842__ITEM #842', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (843, 'ITEM #843__ITEM #843', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (844, 'ITEM #844__ITEM #844', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (845, 'ITEM #845__ITEM #845', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (846, 'ITEM #846__ITEM #846', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (847, 'ITEM #847__ITEM #847', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (848, 'ITEM #848__ITEM #848', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (849, 'ITEM #849__ITEM #849', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (850, 'ITEM #850__ITEM #850', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (851, 'ITEM #851__ITEM #851', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (852, 'ITEM #852__ITEM #852', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (853, 'ITEM #853__ITEM #853', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (854, 'ITEM #854__ITEM #854', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (855, 'ITEM #855__ITEM #855', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (856, 'ITEM #856__ITEM #856', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (857, 'ITEM #857__ITEM #857', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (858, 'ITEM #858__ITEM #858', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (859, 'ITEM #859__ITEM #859', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (860, 'ITEM #860__ITEM #860', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (861, 'ITEM #861__ITEM #861', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (862, 'ITEM #862__ITEM #862', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (863, 'ITEM #863__ITEM #863', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (864, 'ITEM #864__ITEM #864', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (865, 'ITEM #865__ITEM #865', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (866, 'ITEM #866__ITEM #866', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (867, 'ITEM #867__ITEM #867', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (868, 'ITEM #868__ITEM #868', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (869, 'ITEM #869__ITEM #869', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (870, 'ITEM #870__ITEM #870', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (871, 'ITEM #871__ITEM #871', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (872, 'ITEM #872__ITEM #872', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (873, 'ITEM #873__ITEM #873', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (874, 'ITEM #874__ITEM #874', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (875, 'ITEM #875__ITEM #875', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (876, 'ITEM #876__ITEM #876', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (877, 'ITEM #877__ITEM #877', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (878, 'ITEM #878__ITEM #878', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (879, 'ITEM #879__ITEM #879', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (880, 'ITEM #880__ITEM #880', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (881, 'ITEM #881__ITEM #881', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (882, 'ITEM #882__ITEM #882', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (883, 'ITEM #883__ITEM #883', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (884, 'ITEM #884__ITEM #884', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (885, 'ITEM #885__ITEM #885', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (886, 'ITEM #886__ITEM #886', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (887, 'ITEM #887__ITEM #887', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (888, 'ITEM #888__ITEM #888', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (889, 'ITEM #889__ITEM #889', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (890, 'ITEM #890__ITEM #890', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (891, 'ITEM #891__ITEM #891', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (892, 'ITEM #892__ITEM #892', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (893, 'ITEM #893__ITEM #893', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (894, 'ITEM #894__ITEM #894', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (895, 'ITEM #895__ITEM #895', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (896, 'ITEM #896__ITEM #896', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (897, 'ITEM #897__ITEM #897', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (898, 'ITEM #898__ITEM #898', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (899, 'ITEM #899__ITEM #899', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (900, 'ITEM #900__ITEM #900', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (901, 'ITEM #901__ITEM #901', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (902, 'ITEM #902__ITEM #902', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (903, 'ITEM #903__ITEM #903', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (904, 'ITEM #904__ITEM #904', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (905, 'ITEM #905__ITEM #905', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (906, 'ITEM #906__ITEM #906', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (907, 'ITEM #907__ITEM #907', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (908, 'ITEM #908__ITEM #908', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (909, 'ITEM #909__ITEM #909', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (910, 'ITEM #910__ITEM #910', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (911, 'ITEM #911__ITEM #911', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (912, 'ITEM #912__ITEM #912', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (913, 'ITEM #913__ITEM #913', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (914, 'ITEM #914__ITEM #914', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (915, 'ITEM #915__ITEM #915', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (916, 'ITEM #916__ITEM #916', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (917, 'ITEM #917__ITEM #917', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (918, 'ITEM #918__ITEM #918', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (919, 'ITEM #919__ITEM #919', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (920, 'ITEM #920__ITEM #920', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (921, 'ITEM #921__ITEM #921', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (922, 'ITEM #922__ITEM #922', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (923, 'ITEM #923__ITEM #923', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (924, 'ITEM #924__ITEM #924', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (925, 'ITEM #925__ITEM #925', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (926, 'ITEM #926__ITEM #926', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (927, 'ITEM #927__ITEM #927', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (928, 'ITEM #928__ITEM #928', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (929, 'ITEM #929__ITEM #929', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (930, 'ITEM #930__ITEM #930', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (931, 'ITEM #931__ITEM #931', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (932, 'ITEM #932__ITEM #932', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (933, 'ITEM #933__ITEM #933', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (934, 'ITEM #934__ITEM #934', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (935, 'ITEM #935__ITEM #935', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (936, 'ITEM #936__ITEM #936', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (937, 'ITEM #937__ITEM #937', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (938, 'ITEM #938__ITEM #938', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (939, 'ITEM #939__ITEM #939', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (940, 'ITEM #940__ITEM #940', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (941, 'ITEM #941__ITEM #941', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (942, 'ITEM #942__ITEM #942', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (943, 'ITEM #943__ITEM #943', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (944, 'ITEM #944__ITEM #944', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (945, 'ITEM #945__ITEM #945', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (946, 'ITEM #946__ITEM #946', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (947, 'ITEM #947__ITEM #947', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (948, 'ITEM #948__ITEM #948', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (949, 'ITEM #949__ITEM #949', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (950, 'ITEM #950__ITEM #950', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (951, 'ITEM #951__ITEM #951', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (952, 'ITEM #952__ITEM #952', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (953, 'ITEM #953__ITEM #953', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (954, 'ITEM #954__ITEM #954', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (955, 'ITEM #955__ITEM #955', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (956, 'ITEM #956__ITEM #956', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (957, 'ITEM #957__ITEM #957', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (958, 'ITEM #958__ITEM #958', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (959, 'ITEM #959__ITEM #959', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (960, 'ITEM #960__ITEM #960', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (961, 'ITEM #961__ITEM #961', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (962, 'ITEM #962__ITEM #962', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (963, 'ITEM #963__ITEM #963', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (964, 'ITEM #964__ITEM #964', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (965, 'ITEM #965__ITEM #965', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (966, 'ITEM #966__ITEM #966', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (967, 'ITEM #967__ITEM #967', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (968, 'ITEM #968__ITEM #968', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (969, 'ITEM #969__ITEM #969', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (970, 'ITEM #970__ITEM #970', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (971, 'ITEM #971__ITEM #971', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (972, 'ITEM #972__ITEM #972', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (973, 'ITEM #973__ITEM #973', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (974, 'ITEM #974__ITEM #974', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (975, 'ITEM #975__ITEM #975', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (976, 'ITEM #976__ITEM #976', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (977, 'ITEM #977__ITEM #977', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (978, 'ITEM #978__ITEM #978', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (979, 'ITEM #979__ITEM #979', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (980, 'ITEM #980__ITEM #980', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (981, 'ITEM #981__ITEM #981', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (982, 'ITEM #982__ITEM #982', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (983, 'ITEM #983__ITEM #983', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (984, 'ITEM #984__ITEM #984', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (985, 'ITEM #985__ITEM #985', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (986, 'ITEM #986__ITEM #986', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (987, 'ITEM #987__ITEM #987', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (988, 'ITEM #988__ITEM #988', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (989, 'ITEM #989__ITEM #989', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (990, 'ITEM #990__ITEM #990', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (991, 'ITEM #991__ITEM #991', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (992, 'ITEM #992__ITEM #992', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (993, 'ITEM #993__ITEM #993', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (994, 'ITEM #994__ITEM #994', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (995, 'ITEM #995__ITEM #995', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (996, 'ITEM #996__ITEM #996', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (997, 'ITEM #997__ITEM #997', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (998, 'ITEM #998__ITEM #998', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (999, 'ITEM #999__ITEM #999', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1000, 'ITEM #1000__ITEM #1000', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1001, 'ITEM #1001__ITEM #1001', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1002, 'ITEM #1002__ITEM #1002', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1003, 'ITEM #1003__ITEM #1003', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1004, 'ITEM #1004__ITEM #1004', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1005, 'ITEM #1005__ITEM #1005', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1006, 'ITEM #1006__ITEM #1006', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1007, 'ITEM #1007__ITEM #1007', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1008, 'ITEM #1008__ITEM #1008', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1009, 'ITEM #1009__ITEM #1009', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1010, 'ITEM #1010__ITEM #1010', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1011, 'ITEM #1011__ITEM #1011', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1012, 'ITEM #1012__ITEM #1012', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1013, 'ITEM #1013__ITEM #1013', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1014, 'ITEM #1014__ITEM #1014', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1015, 'ITEM #1015__ITEM #1015', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1016, 'ITEM #1016__ITEM #1016', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1017, 'ITEM #1017__ITEM #1017', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1018, 'ITEM #1018__ITEM #1018', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1019, 'ITEM #1019__ITEM #1019', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1020, 'ITEM #1020__ITEM #1020', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1021, 'ITEM #1021__ITEM #1021', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1022, 'ITEM #1022__ITEM #1022', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1023, 'ITEM #1023__ITEM #1023', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1024, 'ITEM #1024__ITEM #1024', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1025, 'ITEM #1025__ITEM #1025', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1026, 'ITEM #1026__ITEM #1026', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1027, 'ITEM #1027__ITEM #1027', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1028, 'ITEM #1028__ITEM #1028', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1029, 'ITEM #1029__ITEM #1029', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1030, 'ITEM #1030__ITEM #1030', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1031, 'ITEM #1031__ITEM #1031', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1032, 'ITEM #1032__ITEM #1032', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1033, 'ITEM #1033__ITEM #1033', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1034, 'ITEM #1034__ITEM #1034', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1035, 'ITEM #1035__ITEM #1035', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1036, 'ITEM #1036__ITEM #1036', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1037, 'ITEM #1037__ITEM #1037', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1038, 'ITEM #1038__ITEM #1038', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1039, 'ITEM #1039__ITEM #1039', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1040, 'ITEM #1040__ITEM #1040', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1041, 'ITEM #1041__ITEM #1041', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1042, 'ITEM #1042__ITEM #1042', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1043, 'ITEM #1043__ITEM #1043', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1044, 'ITEM #1044__ITEM #1044', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1045, 'ITEM #1045__ITEM #1045', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1046, 'ITEM #1046__ITEM #1046', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1047, 'ITEM #1047__ITEM #1047', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1048, 'ITEM #1048__ITEM #1048', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1049, 'ITEM #1049__ITEM #1049', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1050, 'ITEM #1050__ITEM #1050', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1051, 'ITEM #1051__ITEM #1051', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1052, 'ITEM #1052__ITEM #1052', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1053, 'ITEM #1053__ITEM #1053', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1054, 'ITEM #1054__ITEM #1054', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1055, 'ITEM #1055__ITEM #1055', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1056, 'ITEM #1056__ITEM #1056', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1057, 'ITEM #1057__ITEM #1057', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1058, 'ITEM #1058__ITEM #1058', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1059, 'ITEM #1059__ITEM #1059', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1060, 'ITEM #1060__ITEM #1060', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1061, 'ITEM #1061__ITEM #1061', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1062, 'ITEM #1062__ITEM #1062', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1063, 'ITEM #1063__ITEM #1063', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1064, 'ITEM #1064__ITEM #1064', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1065, 'ITEM #1065__ITEM #1065', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1066, 'ITEM #1066__ITEM #1066', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1067, 'ITEM #1067__ITEM #1067', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1068, 'ITEM #1068__ITEM #1068', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1069, 'ITEM #1069__ITEM #1069', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1070, 'ITEM #1070__ITEM #1070', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1071, 'ITEM #1071__ITEM #1071', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1072, 'ITEM #1072__ITEM #1072', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1073, 'ITEM #1073__ITEM #1073', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1074, 'ITEM #1074__ITEM #1074', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1075, 'ITEM #1075__ITEM #1075', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1076, 'ITEM #1076__ITEM #1076', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1077, 'ITEM #1077__ITEM #1077', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1078, 'ITEM #1078__ITEM #1078', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1079, 'ITEM #1079__ITEM #1079', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1080, 'ITEM #1080__ITEM #1080', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1081, 'ITEM #1081__ITEM #1081', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1082, 'ITEM #1082__ITEM #1082', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1083, 'ITEM #1083__ITEM #1083', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1084, 'ITEM #1084__ITEM #1084', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1085, 'ITEM #1085__ITEM #1085', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1086, 'ITEM #1086__ITEM #1086', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1087, 'ITEM #1087__ITEM #1087', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1088, 'ITEM #1088__ITEM #1088', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1089, 'ITEM #1089__ITEM #1089', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1090, 'ITEM #1090__ITEM #1090', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1091, 'ITEM #1091__ITEM #1091', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1092, 'ITEM #1092__ITEM #1092', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1093, 'ITEM #1093__ITEM #1093', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1094, 'ITEM #1094__ITEM #1094', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1095, 'ITEM #1095__ITEM #1095', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1096, 'ITEM #1096__ITEM #1096', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1097, 'ITEM #1097__ITEM #1097', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1098, 'ITEM #1098__ITEM #1098', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1099, 'ITEM #1099__ITEM #1099', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1100, 'ITEM #1100__ITEM #1100', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1101, 'ITEM #1101__ITEM #1101', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1102, 'ITEM #1102__ITEM #1102', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1103, 'ITEM #1103__ITEM #1103', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1104, 'ITEM #1104__ITEM #1104', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1105, 'ITEM #1105__ITEM #1105', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1106, 'ITEM #1106__ITEM #1106', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1107, 'ITEM #1107__ITEM #1107', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1108, 'ITEM #1108__ITEM #1108', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1109, 'ITEM #1109__ITEM #1109', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1110, 'ITEM #1110__ITEM #1110', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1111, 'ITEM #1111__ITEM #1111', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1112, 'ITEM #1112__ITEM #1112', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1113, 'ITEM #1113__ITEM #1113', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1114, 'ITEM #1114__ITEM #1114', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1115, 'ITEM #1115__ITEM #1115', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1116, 'ITEM #1116__ITEM #1116', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1117, 'ITEM #1117__ITEM #1117', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1118, 'ITEM #1118__ITEM #1118', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1119, 'ITEM #1119__ITEM #1119', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1120, 'ITEM #1120__ITEM #1120', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1121, 'ITEM #1121__ITEM #1121', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1122, 'ITEM #1122__ITEM #1122', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1123, 'ITEM #1123__ITEM #1123', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1124, 'ITEM #1124__ITEM #1124', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1125, 'ITEM #1125__ITEM #1125', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1126, 'ITEM #1126__ITEM #1126', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1127, 'ITEM #1127__ITEM #1127', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1128, 'ITEM #1128__ITEM #1128', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1129, 'ITEM #1129__ITEM #1129', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1130, 'ITEM #1130__ITEM #1130', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1131, 'ITEM #1131__ITEM #1131', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1132, 'ITEM #1132__ITEM #1132', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1133, 'ITEM #1133__ITEM #1133', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1134, 'ITEM #1134__ITEM #1134', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1135, 'ITEM #1135__ITEM #1135', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1136, 'ITEM #1136__ITEM #1136', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1137, 'ITEM #1137__ITEM #1137', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1138, 'ITEM #1138__ITEM #1138', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1139, 'ITEM #1139__ITEM #1139', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1140, 'ITEM #1140__ITEM #1140', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1141, 'ITEM #1141__ITEM #1141', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1142, 'ITEM #1142__ITEM #1142', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1143, 'ITEM #1143__ITEM #1143', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1144, 'ITEM #1144__ITEM #1144', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1145, 'ITEM #1145__ITEM #1145', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1146, 'ITEM #1146__ITEM #1146', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1147, 'ITEM #1147__ITEM #1147', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1148, 'ITEM #1148__ITEM #1148', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1149, 'ITEM #1149__ITEM #1149', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1150, 'ITEM #1150__ITEM #1150', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1151, 'ITEM #1151__ITEM #1151', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1152, 'ITEM #1152__ITEM #1152', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1153, 'ITEM #1153__ITEM #1153', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1154, 'ITEM #1154__ITEM #1154', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1155, 'ITEM #1155__ITEM #1155', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1156, 'ITEM #1156__ITEM #1156', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1157, 'ITEM #1157__ITEM #1157', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1158, 'ITEM #1158__ITEM #1158', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1159, 'ITEM #1159__ITEM #1159', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1160, 'ITEM #1160__ITEM #1160', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1161, 'ITEM #1161__ITEM #1161', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1162, 'ITEM #1162__ITEM #1162', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1163, 'ITEM #1163__ITEM #1163', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1164, 'ITEM #1164__ITEM #1164', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1165, 'ITEM #1165__ITEM #1165', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1166, 'ITEM #1166__ITEM #1166', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1167, 'ITEM #1167__ITEM #1167', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1168, 'ITEM #1168__ITEM #1168', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1169, 'ITEM #1169__ITEM #1169', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1170, 'ITEM #1170__ITEM #1170', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1171, 'ITEM #1171__ITEM #1171', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1172, 'ITEM #1172__ITEM #1172', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1173, 'ITEM #1173__ITEM #1173', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1174, 'ITEM #1174__ITEM #1174', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1175, 'ITEM #1175__ITEM #1175', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1176, 'ITEM #1176__ITEM #1176', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1177, 'ITEM #1177__ITEM #1177', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1178, 'ITEM #1178__ITEM #1178', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1179, 'ITEM #1179__ITEM #1179', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1180, 'ITEM #1180__ITEM #1180', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1181, 'ITEM #1181__ITEM #1181', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1182, 'ITEM #1182__ITEM #1182', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1183, 'ITEM #1183__ITEM #1183', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1184, 'ITEM #1184__ITEM #1184', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1185, 'ITEM #1185__ITEM #1185', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1186, 'ITEM #1186__ITEM #1186', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1187, 'ITEM #1187__ITEM #1187', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1188, 'ITEM #1188__ITEM #1188', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1189, 'ITEM #1189__ITEM #1189', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1190, 'ITEM #1190__ITEM #1190', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1191, 'ITEM #1191__ITEM #1191', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1192, 'ITEM #1192__ITEM #1192', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1193, 'ITEM #1193__ITEM #1193', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1194, 'ITEM #1194__ITEM #1194', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1195, 'ITEM #1195__ITEM #1195', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1196, 'ITEM #1196__ITEM #1196', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1197, 'ITEM #1197__ITEM #1197', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1198, 'ITEM #1198__ITEM #1198', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1199, 'ITEM #1199__ITEM #1199', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1200, 'ITEM #1200__ITEM #1200', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1201, 'ITEM #1201__ITEM #1201', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1202, 'ITEM #1202__ITEM #1202', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1203, 'ITEM #1203__ITEM #1203', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1204, 'ITEM #1204__ITEM #1204', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1205, 'ITEM #1205__ITEM #1205', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1206, 'ITEM #1206__ITEM #1206', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1207, 'ITEM #1207__ITEM #1207', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1208, 'ITEM #1208__ITEM #1208', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1209, 'ITEM #1209__ITEM #1209', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1210, 'ITEM #1210__ITEM #1210', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1211, 'ITEM #1211__ITEM #1211', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1212, 'ITEM #1212__ITEM #1212', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1213, 'ITEM #1213__ITEM #1213', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1214, 'ITEM #1214__ITEM #1214', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1215, 'ITEM #1215__ITEM #1215', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1216, 'ITEM #1216__ITEM #1216', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1217, 'ITEM #1217__ITEM #1217', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1218, 'ITEM #1218__ITEM #1218', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1219, 'ITEM #1219__ITEM #1219', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1220, 'ITEM #1220__ITEM #1220', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1221, 'ITEM #1221__ITEM #1221', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1222, 'ITEM #1222__ITEM #1222', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1223, 'ITEM #1223__ITEM #1223', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1224, 'ITEM #1224__ITEM #1224', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1225, 'ITEM #1225__ITEM #1225', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1226, 'ITEM #1226__ITEM #1226', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1227, 'ITEM #1227__ITEM #1227', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1228, 'ITEM #1228__ITEM #1228', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1229, 'ITEM #1229__ITEM #1229', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1230, 'ITEM #1230__ITEM #1230', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1231, 'ITEM #1231__ITEM #1231', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1232, 'ITEM #1232__ITEM #1232', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1233, 'ITEM #1233__ITEM #1233', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1234, 'ITEM #1234__ITEM #1234', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1235, 'ITEM #1235__ITEM #1235', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1236, 'ITEM #1236__ITEM #1236', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1237, 'ITEM #1237__ITEM #1237', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1238, 'ITEM #1238__ITEM #1238', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1239, 'ITEM #1239__ITEM #1239', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1240, 'ITEM #1240__ITEM #1240', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1241, 'ITEM #1241__ITEM #1241', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1242, 'ITEM #1242__ITEM #1242', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1243, 'ITEM #1243__ITEM #1243', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1244, 'ITEM #1244__ITEM #1244', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1245, 'ITEM #1245__ITEM #1245', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1246, 'ITEM #1246__ITEM #1246', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1247, 'ITEM #1247__ITEM #1247', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1248, 'ITEM #1248__ITEM #1248', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1249, 'ITEM #1249__ITEM #1249', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1250, 'ITEM #1250__ITEM #1250', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1251, 'ITEM #1251__ITEM #1251', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1252, 'ITEM #1252__ITEM #1252', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1253, 'ITEM #1253__ITEM #1253', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1254, 'ITEM #1254__ITEM #1254', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1255, 'ITEM #1255__ITEM #1255', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1256, 'ITEM #1256__ITEM #1256', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1257, 'ITEM #1257__ITEM #1257', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1258, 'ITEM #1258__ITEM #1258', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1259, 'ITEM #1259__ITEM #1259', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1260, 'ITEM #1260__ITEM #1260', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1261, 'ITEM #1261__ITEM #1261', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1262, 'ITEM #1262__ITEM #1262', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1263, 'ITEM #1263__ITEM #1263', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1264, 'ITEM #1264__ITEM #1264', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1265, 'ITEM #1265__ITEM #1265', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1266, 'ITEM #1266__ITEM #1266', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1267, 'ITEM #1267__ITEM #1267', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1268, 'ITEM #1268__ITEM #1268', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1269, 'ITEM #1269__ITEM #1269', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1270, 'ITEM #1270__ITEM #1270', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1271, 'ITEM #1271__ITEM #1271', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1272, 'ITEM #1272__ITEM #1272', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1273, 'ITEM #1273__ITEM #1273', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1274, 'ITEM #1274__ITEM #1274', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1275, 'ITEM #1275__ITEM #1275', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1276, 'ITEM #1276__ITEM #1276', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1277, 'ITEM #1277__ITEM #1277', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1278, 'ITEM #1278__ITEM #1278', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1279, 'ITEM #1279__ITEM #1279', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1280, 'ITEM #1280__ITEM #1280', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1281, 'ITEM #1281__ITEM #1281', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1282, 'ITEM #1282__ITEM #1282', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1283, 'ITEM #1283__ITEM #1283', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1284, 'ITEM #1284__ITEM #1284', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1285, 'ITEM #1285__ITEM #1285', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1286, 'ITEM #1286__ITEM #1286', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1287, 'ITEM #1287__ITEM #1287', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1288, 'ITEM #1288__ITEM #1288', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1289, 'ITEM #1289__ITEM #1289', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1290, 'ITEM #1290__ITEM #1290', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1291, 'ITEM #1291__ITEM #1291', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1292, 'ITEM #1292__ITEM #1292', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1293, 'ITEM #1293__ITEM #1293', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1294, 'ITEM #1294__ITEM #1294', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1295, 'ITEM #1295__ITEM #1295', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1296, 'ITEM #1296__ITEM #1296', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1297, 'ITEM #1297__ITEM #1297', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1298, 'ITEM #1298__ITEM #1298', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1299, 'ITEM #1299__ITEM #1299', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1300, 'ITEM #1300__ITEM #1300', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1301, 'ITEM #1301__ITEM #1301', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1302, 'ITEM #1302__ITEM #1302', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1303, 'ITEM #1303__ITEM #1303', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1304, 'ITEM #1304__ITEM #1304', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1305, 'ITEM #1305__ITEM #1305', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1306, 'ITEM #1306__ITEM #1306', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1307, 'ITEM #1307__ITEM #1307', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1308, 'ITEM #1308__ITEM #1308', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1309, 'ITEM #1309__ITEM #1309', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1310, 'ITEM #1310__ITEM #1310', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1311, 'ITEM #1311__ITEM #1311', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1312, 'ITEM #1312__ITEM #1312', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1313, 'ITEM #1313__ITEM #1313', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1314, 'ITEM #1314__ITEM #1314', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1315, 'ITEM #1315__ITEM #1315', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1316, 'ITEM #1316__ITEM #1316', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1317, 'ITEM #1317__ITEM #1317', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1318, 'ITEM #1318__ITEM #1318', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1319, 'ITEM #1319__ITEM #1319', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1320, 'ITEM #1320__ITEM #1320', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1321, 'ITEM #1321__ITEM #1321', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1322, 'ITEM #1322__ITEM #1322', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1323, 'ITEM #1323__ITEM #1323', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1324, 'ITEM #1324__ITEM #1324', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1325, 'ITEM #1325__ITEM #1325', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1326, 'ITEM #1326__ITEM #1326', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1327, 'ITEM #1327__ITEM #1327', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1328, 'ITEM #1328__ITEM #1328', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1329, 'ITEM #1329__ITEM #1329', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1330, 'ITEM #1330__ITEM #1330', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1331, 'ITEM #1331__ITEM #1331', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1332, 'ITEM #1332__ITEM #1332', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1333, 'ITEM #1333__ITEM #1333', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1334, 'ITEM #1334__ITEM #1334', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1335, 'ITEM #1335__ITEM #1335', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1336, 'ITEM #1336__ITEM #1336', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1337, 'ITEM #1337__ITEM #1337', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1338, 'ITEM #1338__ITEM #1338', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1339, 'ITEM #1339__ITEM #1339', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1340, 'ITEM #1340__ITEM #1340', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1341, 'ITEM #1341__ITEM #1341', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1342, 'ITEM #1342__ITEM #1342', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1343, 'ITEM #1343__ITEM #1343', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1344, 'ITEM #1344__ITEM #1344', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1345, 'ITEM #1345__ITEM #1345', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1346, 'ITEM #1346__ITEM #1346', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1347, 'ITEM #1347__ITEM #1347', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1348, 'ITEM #1348__ITEM #1348', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1349, 'ITEM #1349__ITEM #1349', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1350, 'ITEM #1350__ITEM #1350', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1351, 'ITEM #1351__ITEM #1351', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1352, 'ITEM #1352__ITEM #1352', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1353, 'ITEM #1353__ITEM #1353', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1354, 'ITEM #1354__ITEM #1354', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1355, 'ITEM #1355__ITEM #1355', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1356, 'ITEM #1356__ITEM #1356', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1357, 'ITEM #1357__ITEM #1357', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1358, 'ITEM #1358__ITEM #1358', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1359, 'ITEM #1359__ITEM #1359', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1360, 'ITEM #1360__ITEM #1360', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1361, 'ITEM #1361__ITEM #1361', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1362, 'ITEM #1362__ITEM #1362', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1363, 'ITEM #1363__ITEM #1363', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1364, 'ITEM #1364__ITEM #1364', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1365, 'ITEM #1365__ITEM #1365', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1366, 'ITEM #1366__ITEM #1366', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1367, 'ITEM #1367__ITEM #1367', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1368, 'ITEM #1368__ITEM #1368', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1369, 'ITEM #1369__ITEM #1369', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1370, 'ITEM #1370__ITEM #1370', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1371, 'ITEM #1371__ITEM #1371', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1372, 'ITEM #1372__ITEM #1372', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1373, 'ITEM #1373__ITEM #1373', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1374, 'ITEM #1374__ITEM #1374', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1375, 'ITEM #1375__ITEM #1375', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1376, 'ITEM #1376__ITEM #1376', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1377, 'ITEM #1377__ITEM #1377', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1378, 'ITEM #1378__ITEM #1378', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1379, 'ITEM #1379__ITEM #1379', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1380, 'ITEM #1380__ITEM #1380', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1381, 'ITEM #1381__ITEM #1381', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1382, 'ITEM #1382__ITEM #1382', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1383, 'ITEM #1383__ITEM #1383', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1384, 'ITEM #1384__ITEM #1384', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1385, 'ITEM #1385__ITEM #1385', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1386, 'ITEM #1386__ITEM #1386', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1387, 'ITEM #1387__ITEM #1387', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1388, 'ITEM #1388__ITEM #1388', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1389, 'ITEM #1389__ITEM #1389', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1390, 'ITEM #1390__ITEM #1390', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1391, 'ITEM #1391__ITEM #1391', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1392, 'ITEM #1392__ITEM #1392', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1393, 'ITEM #1393__ITEM #1393', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1394, 'ITEM #1394__ITEM #1394', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1395, 'ITEM #1395__ITEM #1395', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1396, 'ITEM #1396__ITEM #1396', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1397, 'ITEM #1397__ITEM #1397', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1398, 'ITEM #1398__ITEM #1398', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1399, 'ITEM #1399__ITEM #1399', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1400, 'ITEM #1400__ITEM #1400', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1401, 'ITEM #1401__ITEM #1401', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1402, 'ITEM #1402__ITEM #1402', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1403, 'ITEM #1403__ITEM #1403', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1404, 'ITEM #1404__ITEM #1404', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1405, 'ITEM #1405__ITEM #1405', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1406, 'ITEM #1406__ITEM #1406', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1407, 'ITEM #1407__ITEM #1407', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1408, 'ITEM #1408__ITEM #1408', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1409, 'ITEM #1409__ITEM #1409', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1410, 'ITEM #1410__ITEM #1410', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1411, 'ITEM #1411__ITEM #1411', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1412, 'ITEM #1412__ITEM #1412', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1413, 'ITEM #1413__ITEM #1413', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1414, 'ITEM #1414__ITEM #1414', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1415, 'ITEM #1415__ITEM #1415', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1416, 'ITEM #1416__ITEM #1416', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1417, 'ITEM #1417__ITEM #1417', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1418, 'ITEM #1418__ITEM #1418', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1419, 'ITEM #1419__ITEM #1419', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1420, 'ITEM #1420__ITEM #1420', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1421, 'ITEM #1421__ITEM #1421', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1422, 'ITEM #1422__ITEM #1422', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1423, 'ITEM #1423__ITEM #1423', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1424, 'ITEM #1424__ITEM #1424', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1425, 'ITEM #1425__ITEM #1425', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1426, 'ITEM #1426__ITEM #1426', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1427, 'ITEM #1427__ITEM #1427', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1428, 'ITEM #1428__ITEM #1428', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1429, 'ITEM #1429__ITEM #1429', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1430, 'ITEM #1430__ITEM #1430', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1431, 'ITEM #1431__ITEM #1431', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1432, 'ITEM #1432__ITEM #1432', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1433, 'ITEM #1433__ITEM #1433', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1434, 'ITEM #1434__ITEM #1434', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1435, 'ITEM #1435__ITEM #1435', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1436, 'ITEM #1436__ITEM #1436', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1437, 'ITEM #1437__ITEM #1437', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1438, 'ITEM #1438__ITEM #1438', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1439, 'ITEM #1439__ITEM #1439', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1440, 'ITEM #1440__ITEM #1440', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1441, 'ITEM #1441__ITEM #1441', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1442, 'ITEM #1442__ITEM #1442', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1443, 'ITEM #1443__ITEM #1443', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1444, 'ITEM #1444__ITEM #1444', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1445, 'ITEM #1445__ITEM #1445', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1446, 'ITEM #1446__ITEM #1446', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1447, 'ITEM #1447__ITEM #1447', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1448, 'ITEM #1448__ITEM #1448', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1449, 'ITEM #1449__ITEM #1449', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1450, 'ITEM #1450__ITEM #1450', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1451, 'ITEM #1451__ITEM #1451', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1452, 'ITEM #1452__ITEM #1452', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1453, 'ITEM #1453__ITEM #1453', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1454, 'ITEM #1454__ITEM #1454', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1455, 'ITEM #1455__ITEM #1455', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1456, 'ITEM #1456__ITEM #1456', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1457, 'ITEM #1457__ITEM #1457', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1458, 'ITEM #1458__ITEM #1458', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1459, 'ITEM #1459__ITEM #1459', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1460, 'ITEM #1460__ITEM #1460', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1461, 'ITEM #1461__ITEM #1461', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1462, 'ITEM #1462__ITEM #1462', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1463, 'ITEM #1463__ITEM #1463', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1464, 'ITEM #1464__ITEM #1464', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1465, 'ITEM #1465__ITEM #1465', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1466, 'ITEM #1466__ITEM #1466', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1467, 'ITEM #1467__ITEM #1467', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1468, 'ITEM #1468__ITEM #1468', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1469, 'ITEM #1469__ITEM #1469', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1470, 'ITEM #1470__ITEM #1470', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1471, 'ITEM #1471__ITEM #1471', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1472, 'ITEM #1472__ITEM #1472', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1473, 'ITEM #1473__ITEM #1473', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1474, 'ITEM #1474__ITEM #1474', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1475, 'ITEM #1475__ITEM #1475', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1476, 'ITEM #1476__ITEM #1476', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1477, 'ITEM #1477__ITEM #1477', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1478, 'ITEM #1478__ITEM #1478', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1479, 'ITEM #1479__ITEM #1479', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1480, 'ITEM #1480__ITEM #1480', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1481, 'ITEM #1481__ITEM #1481', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1482, 'ITEM #1482__ITEM #1482', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1483, 'ITEM #1483__ITEM #1483', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1484, 'ITEM #1484__ITEM #1484', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1485, 'ITEM #1485__ITEM #1485', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1486, 'ITEM #1486__ITEM #1486', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1487, 'ITEM #1487__ITEM #1487', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1488, 'ITEM #1488__ITEM #1488', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1489, 'ITEM #1489__ITEM #1489', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1490, 'ITEM #1490__ITEM #1490', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1491, 'ITEM #1491__ITEM #1491', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1492, 'ITEM #1492__ITEM #1492', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1493, 'ITEM #1493__ITEM #1493', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1494, 'ITEM #1494__ITEM #1494', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1495, 'ITEM #1495__ITEM #1495', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1496, 'ITEM #1496__ITEM #1496', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1497, 'ITEM #1497__ITEM #1497', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1498, 'ITEM #1498__ITEM #1498', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1499, 'ITEM #1499__ITEM #1499', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1500, 'ITEM #1500__ITEM #1500', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1501, 'ITEM #1501__ITEM #1501', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1502, 'ITEM #1502__ITEM #1502', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1503, 'ITEM #1503__ITEM #1503', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1504, 'ITEM #1504__ITEM #1504', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1505, 'ITEM #1505__ITEM #1505', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1506, 'ITEM #1506__ITEM #1506', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1507, 'ITEM #1507__ITEM #1507', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1508, 'ITEM #1508__ITEM #1508', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1509, 'ITEM #1509__ITEM #1509', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1510, 'ITEM #1510__ITEM #1510', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1511, 'ITEM #1511__ITEM #1511', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1512, 'ITEM #1512__ITEM #1512', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1513, 'ITEM #1513__ITEM #1513', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1514, 'ITEM #1514__ITEM #1514', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1515, 'ITEM #1515__ITEM #1515', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1516, 'ITEM #1516__ITEM #1516', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1517, 'ITEM #1517__ITEM #1517', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1518, 'ITEM #1518__ITEM #1518', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1519, 'ITEM #1519__ITEM #1519', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1520, 'ITEM #1520__ITEM #1520', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1521, 'ITEM #1521__ITEM #1521', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1522, 'ITEM #1522__ITEM #1522', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1523, 'ITEM #1523__ITEM #1523', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1524, 'ITEM #1524__ITEM #1524', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1525, 'ITEM #1525__ITEM #1525', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1526, 'ITEM #1526__ITEM #1526', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1527, 'ITEM #1527__ITEM #1527', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1528, 'ITEM #1528__ITEM #1528', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1529, 'ITEM #1529__ITEM #1529', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1530, 'ITEM #1530__ITEM #1530', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1531, 'ITEM #1531__ITEM #1531', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1532, 'ITEM #1532__ITEM #1532', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1533, 'ITEM #1533__ITEM #1533', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1534, 'ITEM #1534__ITEM #1534', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1535, 'ITEM #1535__ITEM #1535', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1536, 'ITEM #1536__ITEM #1536', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1537, 'ITEM #1537__ITEM #1537', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1538, 'ITEM #1538__ITEM #1538', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1539, 'ITEM #1539__ITEM #1539', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1540, 'ITEM #1540__ITEM #1540', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1541, 'ITEM #1541__ITEM #1541', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1542, 'ITEM #1542__ITEM #1542', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1543, 'ITEM #1543__ITEM #1543', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1544, 'ITEM #1544__ITEM #1544', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1545, 'ITEM #1545__ITEM #1545', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1546, 'ITEM #1546__ITEM #1546', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1547, 'ITEM #1547__ITEM #1547', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1548, 'ITEM #1548__ITEM #1548', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1549, 'ITEM #1549__ITEM #1549', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1550, 'ITEM #1550__ITEM #1550', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1551, 'ITEM #1551__ITEM #1551', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1552, 'ITEM #1552__ITEM #1552', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1553, 'ITEM #1553__ITEM #1553', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1554, 'ITEM #1554__ITEM #1554', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1555, 'ITEM #1555__ITEM #1555', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1556, 'ITEM #1556__ITEM #1556', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1557, 'ITEM #1557__ITEM #1557', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1558, 'ITEM #1558__ITEM #1558', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1559, 'ITEM #1559__ITEM #1559', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1560, 'ITEM #1560__ITEM #1560', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1561, 'ITEM #1561__ITEM #1561', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1562, 'ITEM #1562__ITEM #1562', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1563, 'ITEM #1563__ITEM #1563', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1564, 'ITEM #1564__ITEM #1564', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1565, 'ITEM #1565__ITEM #1565', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1566, 'ITEM #1566__ITEM #1566', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1567, 'ITEM #1567__ITEM #1567', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1568, 'ITEM #1568__ITEM #1568', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1569, 'ITEM #1569__ITEM #1569', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1570, 'ITEM #1570__ITEM #1570', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1571, 'ITEM #1571__ITEM #1571', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1572, 'ITEM #1572__ITEM #1572', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1573, 'ITEM #1573__ITEM #1573', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1574, 'ITEM #1574__ITEM #1574', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1575, 'ITEM #1575__ITEM #1575', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1576, 'ITEM #1576__ITEM #1576', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1577, 'ITEM #1577__ITEM #1577', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1578, 'ITEM #1578__ITEM #1578', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1579, 'ITEM #1579__ITEM #1579', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1580, 'ITEM #1580__ITEM #1580', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1581, 'ITEM #1581__ITEM #1581', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1582, 'ITEM #1582__ITEM #1582', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1583, 'ITEM #1583__ITEM #1583', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1584, 'ITEM #1584__ITEM #1584', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1585, 'ITEM #1585__ITEM #1585', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1586, 'ITEM #1586__ITEM #1586', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1587, 'ITEM #1587__ITEM #1587', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1588, 'ITEM #1588__ITEM #1588', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1589, 'ITEM #1589__ITEM #1589', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1590, 'ITEM #1590__ITEM #1590', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1591, 'ITEM #1591__ITEM #1591', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1592, 'ITEM #1592__ITEM #1592', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1593, 'ITEM #1593__ITEM #1593', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1594, 'ITEM #1594__ITEM #1594', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1595, 'ITEM #1595__ITEM #1595', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1596, 'ITEM #1596__ITEM #1596', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1597, 'ITEM #1597__ITEM #1597', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1598, 'ITEM #1598__ITEM #1598', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1599, 'ITEM #1599__ITEM #1599', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1600, 'ITEM #1600__ITEM #1600', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1601, 'ITEM #1601__ITEM #1601', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1602, 'ITEM #1602__ITEM #1602', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1603, 'ITEM #1603__ITEM #1603', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1604, 'ITEM #1604__ITEM #1604', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1605, 'ITEM #1605__ITEM #1605', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1606, 'ITEM #1606__ITEM #1606', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1607, 'ITEM #1607__ITEM #1607', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1608, 'ITEM #1608__ITEM #1608', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1609, 'ITEM #1609__ITEM #1609', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1610, 'ITEM #1610__ITEM #1610', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1611, 'ITEM #1611__ITEM #1611', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1612, 'ITEM #1612__ITEM #1612', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1613, 'ITEM #1613__ITEM #1613', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1614, 'ITEM #1614__ITEM #1614', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1615, 'ITEM #1615__ITEM #1615', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1616, 'ITEM #1616__ITEM #1616', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1617, 'ITEM #1617__ITEM #1617', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1618, 'ITEM #1618__ITEM #1618', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1619, 'ITEM #1619__ITEM #1619', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1620, 'ITEM #1620__ITEM #1620', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1621, 'ITEM #1621__ITEM #1621', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1622, 'ITEM #1622__ITEM #1622', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1623, 'ITEM #1623__ITEM #1623', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1624, 'ITEM #1624__ITEM #1624', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1625, 'ITEM #1625__ITEM #1625', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1626, 'ITEM #1626__ITEM #1626', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1627, 'ITEM #1627__ITEM #1627', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1628, 'ITEM #1628__ITEM #1628', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1629, 'ITEM #1629__ITEM #1629', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1630, 'ITEM #1630__ITEM #1630', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1631, 'ITEM #1631__ITEM #1631', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1632, 'ITEM #1632__ITEM #1632', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1633, 'ITEM #1633__ITEM #1633', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1634, 'ITEM #1634__ITEM #1634', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1635, 'ITEM #1635__ITEM #1635', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1636, 'ITEM #1636__ITEM #1636', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1637, 'ITEM #1637__ITEM #1637', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1638, 'ITEM #1638__ITEM #1638', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1639, 'ITEM #1639__ITEM #1639', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1640, 'ITEM #1640__ITEM #1640', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1641, 'ITEM #1641__ITEM #1641', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1642, 'ITEM #1642__ITEM #1642', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1643, 'ITEM #1643__ITEM #1643', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1644, 'ITEM #1644__ITEM #1644', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1645, 'ITEM #1645__ITEM #1645', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1646, 'ITEM #1646__ITEM #1646', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1647, 'ITEM #1647__ITEM #1647', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1648, 'ITEM #1648__ITEM #1648', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1649, 'ITEM #1649__ITEM #1649', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1650, 'ITEM #1650__ITEM #1650', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1651, 'ITEM #1651__ITEM #1651', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1652, 'ITEM #1652__ITEM #1652', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1653, 'ITEM #1653__ITEM #1653', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1654, 'ITEM #1654__ITEM #1654', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1655, 'ITEM #1655__ITEM #1655', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1656, 'ITEM #1656__ITEM #1656', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1657, 'ITEM #1657__ITEM #1657', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1658, 'ITEM #1658__ITEM #1658', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1659, 'ITEM #1659__ITEM #1659', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1660, 'ITEM #1660__ITEM #1660', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1661, 'ITEM #1661__ITEM #1661', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1662, 'ITEM #1662__ITEM #1662', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1663, 'ITEM #1663__ITEM #1663', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1664, 'ITEM #1664__ITEM #1664', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1665, 'ITEM #1665__ITEM #1665', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1666, 'ITEM #1666__ITEM #1666', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1667, 'ITEM #1667__ITEM #1667', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1668, 'ITEM #1668__ITEM #1668', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1669, 'ITEM #1669__ITEM #1669', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1670, 'ITEM #1670__ITEM #1670', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1671, 'ITEM #1671__ITEM #1671', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1672, 'ITEM #1672__ITEM #1672', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1673, 'ITEM #1673__ITEM #1673', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1674, 'ITEM #1674__ITEM #1674', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1675, 'ITEM #1675__ITEM #1675', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1676, 'ITEM #1676__ITEM #1676', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1677, 'ITEM #1677__ITEM #1677', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1678, 'ITEM #1678__ITEM #1678', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1679, 'ITEM #1679__ITEM #1679', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1680, 'ITEM #1680__ITEM #1680', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1681, 'ITEM #1681__ITEM #1681', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1682, 'ITEM #1682__ITEM #1682', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1683, 'ITEM #1683__ITEM #1683', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1684, 'ITEM #1684__ITEM #1684', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1685, 'ITEM #1685__ITEM #1685', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1686, 'ITEM #1686__ITEM #1686', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1687, 'ITEM #1687__ITEM #1687', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1688, 'ITEM #1688__ITEM #1688', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1689, 'ITEM #1689__ITEM #1689', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1690, 'ITEM #1690__ITEM #1690', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1691, 'ITEM #1691__ITEM #1691', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1692, 'ITEM #1692__ITEM #1692', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1693, 'ITEM #1693__ITEM #1693', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1694, 'ITEM #1694__ITEM #1694', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1695, 'ITEM #1695__ITEM #1695', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1696, 'ITEM #1696__ITEM #1696', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1697, 'ITEM #1697__ITEM #1697', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1698, 'ITEM #1698__ITEM #1698', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1699, 'ITEM #1699__ITEM #1699', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1700, 'ITEM #1700__ITEM #1700', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1701, 'ITEM #1701__ITEM #1701', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1702, 'ITEM #1702__ITEM #1702', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1703, 'ITEM #1703__ITEM #1703', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1704, 'ITEM #1704__ITEM #1704', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1705, 'ITEM #1705__ITEM #1705', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1706, 'ITEM #1706__ITEM #1706', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1707, 'ITEM #1707__ITEM #1707', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1708, 'ITEM #1708__ITEM #1708', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1709, 'ITEM #1709__ITEM #1709', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1710, 'ITEM #1710__ITEM #1710', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1711, 'ITEM #1711__ITEM #1711', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1712, 'ITEM #1712__ITEM #1712', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1713, 'ITEM #1713__ITEM #1713', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1714, 'ITEM #1714__ITEM #1714', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1715, 'ITEM #1715__ITEM #1715', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1716, 'ITEM #1716__ITEM #1716', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1717, 'ITEM #1717__ITEM #1717', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1718, 'ITEM #1718__ITEM #1718', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1719, 'ITEM #1719__ITEM #1719', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1720, 'ITEM #1720__ITEM #1720', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1721, 'ITEM #1721__ITEM #1721', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1722, 'ITEM #1722__ITEM #1722', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1723, 'ITEM #1723__ITEM #1723', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1724, 'ITEM #1724__ITEM #1724', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1725, 'ITEM #1725__ITEM #1725', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1726, 'ITEM #1726__ITEM #1726', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1727, 'ITEM #1727__ITEM #1727', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1728, 'ITEM #1728__ITEM #1728', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1729, 'ITEM #1729__ITEM #1729', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1730, 'ITEM #1730__ITEM #1730', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1731, 'ITEM #1731__ITEM #1731', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1732, 'ITEM #1732__ITEM #1732', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1733, 'ITEM #1733__ITEM #1733', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1734, 'ITEM #1734__ITEM #1734', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1735, 'ITEM #1735__ITEM #1735', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1736, 'ITEM #1736__ITEM #1736', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1737, 'ITEM #1737__ITEM #1737', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1738, 'ITEM #1738__ITEM #1738', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1739, 'ITEM #1739__ITEM #1739', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1740, 'ITEM #1740__ITEM #1740', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1741, 'ITEM #1741__ITEM #1741', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1742, 'ITEM #1742__ITEM #1742', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1743, 'ITEM #1743__ITEM #1743', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1744, 'ITEM #1744__ITEM #1744', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1745, 'ITEM #1745__ITEM #1745', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1746, 'ITEM #1746__ITEM #1746', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1747, 'ITEM #1747__ITEM #1747', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1748, 'ITEM #1748__ITEM #1748', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1749, 'ITEM #1749__ITEM #1749', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1750, 'ITEM #1750__ITEM #1750', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1751, 'ITEM #1751__ITEM #1751', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1752, 'ITEM #1752__ITEM #1752', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1753, 'ITEM #1753__ITEM #1753', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1754, 'ITEM #1754__ITEM #1754', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1755, 'ITEM #1755__ITEM #1755', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1756, 'ITEM #1756__ITEM #1756', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1757, 'ITEM #1757__ITEM #1757', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1758, 'ITEM #1758__ITEM #1758', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1759, 'ITEM #1759__ITEM #1759', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1760, 'ITEM #1760__ITEM #1760', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1761, 'ITEM #1761__ITEM #1761', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1762, 'ITEM #1762__ITEM #1762', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1763, 'ITEM #1763__ITEM #1763', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1764, 'ITEM #1764__ITEM #1764', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1765, 'ITEM #1765__ITEM #1765', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1766, 'ITEM #1766__ITEM #1766', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1767, 'ITEM #1767__ITEM #1767', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1768, 'ITEM #1768__ITEM #1768', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1769, 'ITEM #1769__ITEM #1769', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1770, 'ITEM #1770__ITEM #1770', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1771, 'ITEM #1771__ITEM #1771', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1772, 'ITEM #1772__ITEM #1772', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1773, 'ITEM #1773__ITEM #1773', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1774, 'ITEM #1774__ITEM #1774', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1775, 'ITEM #1775__ITEM #1775', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1776, 'ITEM #1776__ITEM #1776', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1777, 'ITEM #1777__ITEM #1777', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1778, 'ITEM #1778__ITEM #1778', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1779, 'ITEM #1779__ITEM #1779', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1780, 'ITEM #1780__ITEM #1780', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1781, 'ITEM #1781__ITEM #1781', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1782, 'ITEM #1782__ITEM #1782', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1783, 'ITEM #1783__ITEM #1783', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1784, 'ITEM #1784__ITEM #1784', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1785, 'ITEM #1785__ITEM #1785', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1786, 'ITEM #1786__ITEM #1786', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1787, 'ITEM #1787__ITEM #1787', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1788, 'ITEM #1788__ITEM #1788', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1789, 'ITEM #1789__ITEM #1789', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1790, 'ITEM #1790__ITEM #1790', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1791, 'ITEM #1791__ITEM #1791', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1792, 'ITEM #1792__ITEM #1792', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1793, 'ITEM #1793__ITEM #1793', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1794, 'ITEM #1794__ITEM #1794', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1795, 'ITEM #1795__ITEM #1795', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1796, 'ITEM #1796__ITEM #1796', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1797, 'ITEM #1797__ITEM #1797', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1798, 'ITEM #1798__ITEM #1798', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1799, 'ITEM #1799__ITEM #1799', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1800, 'ITEM #1800__ITEM #1800', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1801, 'ITEM #1801__ITEM #1801', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1802, 'ITEM #1802__ITEM #1802', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1803, 'ITEM #1803__ITEM #1803', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1804, 'ITEM #1804__ITEM #1804', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1805, 'ITEM #1805__ITEM #1805', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1806, 'ITEM #1806__ITEM #1806', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1807, 'ITEM #1807__ITEM #1807', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1808, 'ITEM #1808__ITEM #1808', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1809, 'ITEM #1809__ITEM #1809', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1810, 'ITEM #1810__ITEM #1810', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1811, 'ITEM #1811__ITEM #1811', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1812, 'ITEM #1812__ITEM #1812', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1813, 'ITEM #1813__ITEM #1813', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1814, 'ITEM #1814__ITEM #1814', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1815, 'ITEM #1815__ITEM #1815', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1816, 'ITEM #1816__ITEM #1816', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1817, 'ITEM #1817__ITEM #1817', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1818, 'ITEM #1818__ITEM #1818', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1819, 'ITEM #1819__ITEM #1819', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1820, 'ITEM #1820__ITEM #1820', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1821, 'ITEM #1821__ITEM #1821', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1822, 'ITEM #1822__ITEM #1822', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1823, 'ITEM #1823__ITEM #1823', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1824, 'ITEM #1824__ITEM #1824', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1825, 'ITEM #1825__ITEM #1825', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1826, 'ITEM #1826__ITEM #1826', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1827, 'ITEM #1827__ITEM #1827', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1828, 'ITEM #1828__ITEM #1828', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1829, 'ITEM #1829__ITEM #1829', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1830, 'ITEM #1830__ITEM #1830', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1831, 'ITEM #1831__ITEM #1831', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1832, 'ITEM #1832__ITEM #1832', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1833, 'ITEM #1833__ITEM #1833', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1834, 'ITEM #1834__ITEM #1834', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1835, 'ITEM #1835__ITEM #1835', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1836, 'ITEM #1836__ITEM #1836', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1837, 'ITEM #1837__ITEM #1837', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1838, 'ITEM #1838__ITEM #1838', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1839, 'ITEM #1839__ITEM #1839', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1840, 'ITEM #1840__ITEM #1840', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1841, 'ITEM #1841__ITEM #1841', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1842, 'ITEM #1842__ITEM #1842', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1843, 'ITEM #1843__ITEM #1843', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1844, 'ITEM #1844__ITEM #1844', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1845, 'ITEM #1845__ITEM #1845', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1846, 'ITEM #1846__ITEM #1846', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1847, 'ITEM #1847__ITEM #1847', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1848, 'ITEM #1848__ITEM #1848', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1849, 'ITEM #1849__ITEM #1849', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1850, 'ITEM #1850__ITEM #1850', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1851, 'ITEM #1851__ITEM #1851', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1852, 'ITEM #1852__ITEM #1852', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1853, 'ITEM #1853__ITEM #1853', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1854, 'ITEM #1854__ITEM #1854', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1855, 'ITEM #1855__ITEM #1855', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1856, 'ITEM #1856__ITEM #1856', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1857, 'ITEM #1857__ITEM #1857', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1858, 'ITEM #1858__ITEM #1858', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1859, 'ITEM #1859__ITEM #1859', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1860, 'ITEM #1860__ITEM #1860', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1861, 'ITEM #1861__ITEM #1861', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1862, 'ITEM #1862__ITEM #1862', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1863, 'ITEM #1863__ITEM #1863', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1864, 'ITEM #1864__ITEM #1864', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1865, 'ITEM #1865__ITEM #1865', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1866, 'ITEM #1866__ITEM #1866', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1867, 'ITEM #1867__ITEM #1867', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1868, 'ITEM #1868__ITEM #1868', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1869, 'ITEM #1869__ITEM #1869', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1870, 'ITEM #1870__ITEM #1870', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1871, 'ITEM #1871__ITEM #1871', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1872, 'ITEM #1872__ITEM #1872', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1873, 'ITEM #1873__ITEM #1873', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1874, 'ITEM #1874__ITEM #1874', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1875, 'ITEM #1875__ITEM #1875', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1876, 'ITEM #1876__ITEM #1876', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1877, 'ITEM #1877__ITEM #1877', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1878, 'ITEM #1878__ITEM #1878', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1879, 'ITEM #1879__ITEM #1879', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1880, 'ITEM #1880__ITEM #1880', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1881, 'ITEM #1881__ITEM #1881', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1882, 'ITEM #1882__ITEM #1882', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1883, 'ITEM #1883__ITEM #1883', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1884, 'ITEM #1884__ITEM #1884', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1885, 'ITEM #1885__ITEM #1885', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1886, 'ITEM #1886__ITEM #1886', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1887, 'ITEM #1887__ITEM #1887', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1888, 'ITEM #1888__ITEM #1888', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1889, 'ITEM #1889__ITEM #1889', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1890, 'ITEM #1890__ITEM #1890', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1891, 'ITEM #1891__ITEM #1891', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1892, 'ITEM #1892__ITEM #1892', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1893, 'ITEM #1893__ITEM #1893', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1894, 'ITEM #1894__ITEM #1894', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1895, 'ITEM #1895__ITEM #1895', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1896, 'ITEM #1896__ITEM #1896', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1897, 'ITEM #1897__ITEM #1897', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1898, 'ITEM #1898__ITEM #1898', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1899, 'ITEM #1899__ITEM #1899', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1900, 'ITEM #1900__ITEM #1900', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1901, 'ITEM #1901__ITEM #1901', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1902, 'ITEM #1902__ITEM #1902', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1903, 'ITEM #1903__ITEM #1903', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1904, 'ITEM #1904__ITEM #1904', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1905, 'ITEM #1905__ITEM #1905', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1906, 'ITEM #1906__ITEM #1906', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1907, 'ITEM #1907__ITEM #1907', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1908, 'ITEM #1908__ITEM #1908', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1909, 'ITEM #1909__ITEM #1909', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1910, 'ITEM #1910__ITEM #1910', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1911, 'ITEM #1911__ITEM #1911', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1912, 'ITEM #1912__ITEM #1912', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1913, 'ITEM #1913__ITEM #1913', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1914, 'ITEM #1914__ITEM #1914', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1915, 'ITEM #1915__ITEM #1915', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1916, 'ITEM #1916__ITEM #1916', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1917, 'ITEM #1917__ITEM #1917', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1918, 'ITEM #1918__ITEM #1918', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1919, 'ITEM #1919__ITEM #1919', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1920, 'ITEM #1920__ITEM #1920', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1921, 'ITEM #1921__ITEM #1921', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1922, 'ITEM #1922__ITEM #1922', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1923, 'ITEM #1923__ITEM #1923', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1924, 'ITEM #1924__ITEM #1924', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1925, 'ITEM #1925__ITEM #1925', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1926, 'ITEM #1926__ITEM #1926', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1927, 'ITEM #1927__ITEM #1927', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1928, 'ITEM #1928__ITEM #1928', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1929, 'ITEM #1929__ITEM #1929', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1930, 'ITEM #1930__ITEM #1930', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1931, 'ITEM #1931__ITEM #1931', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1932, 'ITEM #1932__ITEM #1932', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1933, 'ITEM #1933__ITEM #1933', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1934, 'ITEM #1934__ITEM #1934', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1935, 'ITEM #1935__ITEM #1935', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1936, 'ITEM #1936__ITEM #1936', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1937, 'ITEM #1937__ITEM #1937', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1938, 'ITEM #1938__ITEM #1938', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1939, 'ITEM #1939__ITEM #1939', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1940, 'ITEM #1940__ITEM #1940', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1941, 'ITEM #1941__ITEM #1941', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1942, 'ITEM #1942__ITEM #1942', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1943, 'ITEM #1943__ITEM #1943', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1944, 'ITEM #1944__ITEM #1944', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1945, 'ITEM #1945__ITEM #1945', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1946, 'ITEM #1946__ITEM #1946', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1947, 'ITEM #1947__ITEM #1947', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1948, 'ITEM #1948__ITEM #1948', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1949, 'ITEM #1949__ITEM #1949', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1950, 'ITEM #1950__ITEM #1950', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1951, 'ITEM #1951__ITEM #1951', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1952, 'ITEM #1952__ITEM #1952', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1953, 'ITEM #1953__ITEM #1953', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1954, 'ITEM #1954__ITEM #1954', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1955, 'ITEM #1955__ITEM #1955', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1956, 'ITEM #1956__ITEM #1956', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1957, 'ITEM #1957__ITEM #1957', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1958, 'ITEM #1958__ITEM #1958', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1959, 'ITEM #1959__ITEM #1959', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1960, 'ITEM #1960__ITEM #1960', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1961, 'ITEM #1961__ITEM #1961', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1962, 'ITEM #1962__ITEM #1962', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1963, 'ITEM #1963__ITEM #1963', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1964, 'ITEM #1964__ITEM #1964', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1965, 'ITEM #1965__ITEM #1965', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1966, 'ITEM #1966__ITEM #1966', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1967, 'ITEM #1967__ITEM #1967', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1968, 'ITEM #1968__ITEM #1968', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1969, 'ITEM #1969__ITEM #1969', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1970, 'ITEM #1970__ITEM #1970', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1971, 'ITEM #1971__ITEM #1971', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1972, 'ITEM #1972__ITEM #1972', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1973, 'ITEM #1973__ITEM #1973', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1974, 'ITEM #1974__ITEM #1974', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1975, 'ITEM #1975__ITEM #1975', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1976, 'ITEM #1976__ITEM #1976', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1977, 'ITEM #1977__ITEM #1977', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1978, 'ITEM #1978__ITEM #1978', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1979, 'ITEM #1979__ITEM #1979', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1980, 'ITEM #1980__ITEM #1980', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1981, 'ITEM #1981__ITEM #1981', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1982, 'ITEM #1982__ITEM #1982', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1983, 'ITEM #1983__ITEM #1983', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1984, 'ITEM #1984__ITEM #1984', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1985, 'ITEM #1985__ITEM #1985', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1986, 'ITEM #1986__ITEM #1986', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1987, 'ITEM #1987__ITEM #1987', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1988, 'ITEM #1988__ITEM #1988', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1989, 'ITEM #1989__ITEM #1989', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1990, 'ITEM #1990__ITEM #1990', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1991, 'ITEM #1991__ITEM #1991', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1992, 'ITEM #1992__ITEM #1992', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1993, 'ITEM #1993__ITEM #1993', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1994, 'ITEM #1994__ITEM #1994', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1995, 'ITEM #1995__ITEM #1995', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1996, 'ITEM #1996__ITEM #1996', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1997, 'ITEM #1997__ITEM #1997', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1998, 'ITEM #1998__ITEM #1998', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (1999, 'ITEM #1999__ITEM #1999', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2000, 'ITEM #2000__ITEM #2000', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2001, 'ITEM #2001__ITEM #2001', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2002, 'ITEM #2002__ITEM #2002', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2003, 'ITEM #2003__ITEM #2003', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2004, 'ITEM #2004__ITEM #2004', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2005, 'ITEM #2005__ITEM #2005', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2006, 'ITEM #2006__ITEM #2006', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2007, 'ITEM #2007__ITEM #2007', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2008, 'ITEM #2008__ITEM #2008', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2009, 'ITEM #2009__ITEM #2009', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2010, 'ITEM #2010__ITEM #2010', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2011, 'ITEM #2011__ITEM #2011', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2012, 'ITEM #2012__ITEM #2012', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2013, 'ITEM #2013__ITEM #2013', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2014, 'ITEM #2014__ITEM #2014', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2015, 'ITEM #2015__ITEM #2015', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2016, 'ITEM #2016__ITEM #2016', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2017, 'ITEM #2017__ITEM #2017', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2018, 'ITEM #2018__ITEM #2018', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2019, 'ITEM #2019__ITEM #2019', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2020, 'ITEM #2020__ITEM #2020', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2021, 'ITEM #2021__ITEM #2021', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2022, 'ITEM #2022__ITEM #2022', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2023, 'ITEM #2023__ITEM #2023', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2024, 'ITEM #2024__ITEM #2024', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2025, 'ITEM #2025__ITEM #2025', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2026, 'ITEM #2026__ITEM #2026', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2027, 'ITEM #2027__ITEM #2027', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2028, 'ITEM #2028__ITEM #2028', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2029, 'ITEM #2029__ITEM #2029', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2030, 'ITEM #2030__ITEM #2030', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2031, 'ITEM #2031__ITEM #2031', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2032, 'ITEM #2032__ITEM #2032', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2033, 'ITEM #2033__ITEM #2033', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2034, 'ITEM #2034__ITEM #2034', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2035, 'ITEM #2035__ITEM #2035', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2036, 'ITEM #2036__ITEM #2036', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2037, 'ITEM #2037__ITEM #2037', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2038, 'ITEM #2038__ITEM #2038', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2039, 'ITEM #2039__ITEM #2039', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2040, 'ITEM #2040__ITEM #2040', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2041, 'ITEM #2041__ITEM #2041', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2042, 'ITEM #2042__ITEM #2042', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2043, 'ITEM #2043__ITEM #2043', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2044, 'ITEM #2044__ITEM #2044', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2045, 'ITEM #2045__ITEM #2045', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2046, 'ITEM #2046__ITEM #2046', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2047, 'ITEM #2047__ITEM #2047', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2048, 'ITEM #2048__ITEM #2048', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2049, 'ITEM #2049__ITEM #2049', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2050, 'ITEM #2050__ITEM #2050', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2051, 'ITEM #2051__ITEM #2051', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2052, 'ITEM #2052__ITEM #2052', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2053, 'ITEM #2053__ITEM #2053', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2054, 'ITEM #2054__ITEM #2054', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2055, 'ITEM #2055__ITEM #2055', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2056, 'ITEM #2056__ITEM #2056', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2057, 'ITEM #2057__ITEM #2057', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2058, 'ITEM #2058__ITEM #2058', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2059, 'ITEM #2059__ITEM #2059', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2060, 'ITEM #2060__ITEM #2060', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2061, 'ITEM #2061__ITEM #2061', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2062, 'ITEM #2062__ITEM #2062', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2063, 'ITEM #2063__ITEM #2063', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2064, 'ITEM #2064__ITEM #2064', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2065, 'ITEM #2065__ITEM #2065', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2066, 'ITEM #2066__ITEM #2066', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2067, 'ITEM #2067__ITEM #2067', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2068, 'ITEM #2068__ITEM #2068', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2069, 'ITEM #2069__ITEM #2069', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2070, 'ITEM #2070__ITEM #2070', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2071, 'ITEM #2071__ITEM #2071', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2072, 'ITEM #2072__ITEM #2072', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2073, 'ITEM #2073__ITEM #2073', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2074, 'ITEM #2074__ITEM #2074', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2075, 'ITEM #2075__ITEM #2075', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2076, 'ITEM #2076__ITEM #2076', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2077, 'ITEM #2077__ITEM #2077', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2078, 'ITEM #2078__ITEM #2078', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2079, 'ITEM #2079__ITEM #2079', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2080, 'ITEM #2080__ITEM #2080', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2081, 'ITEM #2081__ITEM #2081', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2082, 'ITEM #2082__ITEM #2082', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2083, 'ITEM #2083__ITEM #2083', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2084, 'ITEM #2084__ITEM #2084', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2085, 'ITEM #2085__ITEM #2085', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2086, 'ITEM #2086__ITEM #2086', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2087, 'ITEM #2087__ITEM #2087', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2088, 'ITEM #2088__ITEM #2088', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2089, 'ITEM #2089__ITEM #2089', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2090, 'ITEM #2090__ITEM #2090', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2091, 'ITEM #2091__ITEM #2091', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2092, 'ITEM #2092__ITEM #2092', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2093, 'ITEM #2093__ITEM #2093', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2094, 'ITEM #2094__ITEM #2094', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2095, 'ITEM #2095__ITEM #2095', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2096, 'ITEM #2096__ITEM #2096', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2097, 'ITEM #2097__ITEM #2097', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2098, 'ITEM #2098__ITEM #2098', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2099, 'ITEM #2099__ITEM #2099', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2100, 'ITEM #2100__ITEM #2100', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2101, 'ITEM #2101__ITEM #2101', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2102, 'ITEM #2102__ITEM #2102', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2103, 'ITEM #2103__ITEM #2103', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2104, 'ITEM #2104__ITEM #2104', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2105, 'ITEM #2105__ITEM #2105', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2106, 'ITEM #2106__ITEM #2106', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2107, 'ITEM #2107__ITEM #2107', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2108, 'ITEM #2108__ITEM #2108', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2109, 'ITEM #2109__ITEM #2109', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2110, 'ITEM #2110__ITEM #2110', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2111, 'ITEM #2111__ITEM #2111', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2112, 'ITEM #2112__ITEM #2112', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2113, 'ITEM #2113__ITEM #2113', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2114, 'ITEM #2114__ITEM #2114', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2115, 'ITEM #2115__ITEM #2115', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2116, 'ITEM #2116__ITEM #2116', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2117, 'ITEM #2117__ITEM #2117', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2118, 'ITEM #2118__ITEM #2118', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2119, 'ITEM #2119__ITEM #2119', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2120, 'ITEM #2120__ITEM #2120', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2121, 'ITEM #2121__ITEM #2121', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2122, 'ITEM #2122__ITEM #2122', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2123, 'ITEM #2123__ITEM #2123', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2124, 'ITEM #2124__ITEM #2124', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2125, 'ITEM #2125__ITEM #2125', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2126, 'ITEM #2126__ITEM #2126', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2127, 'ITEM #2127__ITEM #2127', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2128, 'ITEM #2128__ITEM #2128', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2129, 'ITEM #2129__ITEM #2129', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2130, 'ITEM #2130__ITEM #2130', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2131, 'ITEM #2131__ITEM #2131', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2132, 'ITEM #2132__ITEM #2132', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2133, 'ITEM #2133__ITEM #2133', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2134, 'ITEM #2134__ITEM #2134', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2135, 'ITEM #2135__ITEM #2135', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2136, 'ITEM #2136__ITEM #2136', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2137, 'ITEM #2137__ITEM #2137', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2138, 'ITEM #2138__ITEM #2138', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2139, 'ITEM #2139__ITEM #2139', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2140, 'ITEM #2140__ITEM #2140', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2141, 'ITEM #2141__ITEM #2141', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2142, 'ITEM #2142__ITEM #2142', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2143, 'ITEM #2143__ITEM #2143', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2144, 'ITEM #2144__ITEM #2144', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2145, 'ITEM #2145__ITEM #2145', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2146, 'ITEM #2146__ITEM #2146', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2147, 'ITEM #2147__ITEM #2147', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2148, 'ITEM #2148__ITEM #2148', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2149, 'ITEM #2149__ITEM #2149', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2150, 'ITEM #2150__ITEM #2150', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2151, 'ITEM #2151__ITEM #2151', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2152, 'ITEM #2152__ITEM #2152', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2153, 'ITEM #2153__ITEM #2153', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2154, 'ITEM #2154__ITEM #2154', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2155, 'ITEM #2155__ITEM #2155', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2156, 'ITEM #2156__ITEM #2156', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2157, 'ITEM #2157__ITEM #2157', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2158, 'ITEM #2158__ITEM #2158', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2159, 'ITEM #2159__ITEM #2159', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2160, 'ITEM #2160__ITEM #2160', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2161, 'ITEM #2161__ITEM #2161', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2162, 'ITEM #2162__ITEM #2162', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2163, 'ITEM #2163__ITEM #2163', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2164, 'ITEM #2164__ITEM #2164', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2165, 'ITEM #2165__ITEM #2165', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2166, 'ITEM #2166__ITEM #2166', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2167, 'ITEM #2167__ITEM #2167', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2168, 'ITEM #2168__ITEM #2168', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2169, 'ITEM #2169__ITEM #2169', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2170, 'ITEM #2170__ITEM #2170', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2171, 'ITEM #2171__ITEM #2171', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2172, 'ITEM #2172__ITEM #2172', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2173, 'ITEM #2173__ITEM #2173', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2174, 'ITEM #2174__ITEM #2174', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2175, 'ITEM #2175__ITEM #2175', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2176, 'ITEM #2176__ITEM #2176', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2177, 'ITEM #2177__ITEM #2177', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2178, 'ITEM #2178__ITEM #2178', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2179, 'ITEM #2179__ITEM #2179', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2180, 'ITEM #2180__ITEM #2180', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2181, 'ITEM #2181__ITEM #2181', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2182, 'ITEM #2182__ITEM #2182', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2183, 'ITEM #2183__ITEM #2183', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2184, 'ITEM #2184__ITEM #2184', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2185, 'ITEM #2185__ITEM #2185', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2186, 'ITEM #2186__ITEM #2186', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2187, 'ITEM #2187__ITEM #2187', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2188, 'ITEM #2188__ITEM #2188', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2189, 'ITEM #2189__ITEM #2189', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2190, 'ITEM #2190__ITEM #2190', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2191, 'ITEM #2191__ITEM #2191', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2192, 'ITEM #2192__ITEM #2192', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2193, 'ITEM #2193__ITEM #2193', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2194, 'ITEM #2194__ITEM #2194', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2195, 'ITEM #2195__ITEM #2195', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2196, 'ITEM #2196__ITEM #2196', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2197, 'ITEM #2197__ITEM #2197', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2198, 'ITEM #2198__ITEM #2198', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2199, 'ITEM #2199__ITEM #2199', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2200, 'ITEM #2200__ITEM #2200', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2201, 'ITEM #2201__ITEM #2201', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2202, 'ITEM #2202__ITEM #2202', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2203, 'ITEM #2203__ITEM #2203', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2204, 'ITEM #2204__ITEM #2204', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2205, 'ITEM #2205__ITEM #2205', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2206, 'ITEM #2206__ITEM #2206', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2207, 'ITEM #2207__ITEM #2207', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2208, 'ITEM #2208__ITEM #2208', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2209, 'ITEM #2209__ITEM #2209', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2210, 'ITEM #2210__ITEM #2210', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2211, 'ITEM #2211__ITEM #2211', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2212, 'ITEM #2212__ITEM #2212', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2213, 'ITEM #2213__ITEM #2213', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2214, 'ITEM #2214__ITEM #2214', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2215, 'ITEM #2215__ITEM #2215', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2216, 'ITEM #2216__ITEM #2216', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2217, 'ITEM #2217__ITEM #2217', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2218, 'ITEM #2218__ITEM #2218', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2219, 'ITEM #2219__ITEM #2219', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2220, 'ITEM #2220__ITEM #2220', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2221, 'ITEM #2221__ITEM #2221', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2222, 'ITEM #2222__ITEM #2222', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2223, 'ITEM #2223__ITEM #2223', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2224, 'ITEM #2224__ITEM #2224', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2225, 'ITEM #2225__ITEM #2225', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2226, 'ITEM #2226__ITEM #2226', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2227, 'ITEM #2227__ITEM #2227', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2228, 'ITEM #2228__ITEM #2228', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2229, 'ITEM #2229__ITEM #2229', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2230, 'ITEM #2230__ITEM #2230', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2231, 'ITEM #2231__ITEM #2231', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2232, 'ITEM #2232__ITEM #2232', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2233, 'ITEM #2233__ITEM #2233', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2234, 'ITEM #2234__ITEM #2234', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2235, 'ITEM #2235__ITEM #2235', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2236, 'ITEM #2236__ITEM #2236', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2237, 'ITEM #2237__ITEM #2237', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2238, 'ITEM #2238__ITEM #2238', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2239, 'ITEM #2239__ITEM #2239', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2240, 'ITEM #2240__ITEM #2240', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2241, 'ITEM #2241__ITEM #2241', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2242, 'ITEM #2242__ITEM #2242', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2243, 'ITEM #2243__ITEM #2243', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2244, 'ITEM #2244__ITEM #2244', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2245, 'ITEM #2245__ITEM #2245', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2246, 'ITEM #2246__ITEM #2246', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2247, 'ITEM #2247__ITEM #2247', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2248, 'ITEM #2248__ITEM #2248', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2249, 'ITEM #2249__ITEM #2249', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2250, 'ITEM #2250__ITEM #2250', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2251, 'ITEM #2251__ITEM #2251', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2252, 'ITEM #2252__ITEM #2252', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2253, 'ITEM #2253__ITEM #2253', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2254, 'ITEM #2254__ITEM #2254', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2255, 'ITEM #2255__ITEM #2255', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2256, 'ITEM #2256__ITEM #2256', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2257, 'ITEM #2257__ITEM #2257', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2258, 'ITEM #2258__ITEM #2258', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2259, 'ITEM #2259__ITEM #2259', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2260, 'ITEM #2260__ITEM #2260', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2261, 'ITEM #2261__ITEM #2261', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2262, 'ITEM #2262__ITEM #2262', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2263, 'ITEM #2263__ITEM #2263', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2264, 'ITEM #2264__ITEM #2264', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2265, 'ITEM #2265__ITEM #2265', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2266, 'ITEM #2266__ITEM #2266', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2267, 'ITEM #2267__ITEM #2267', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2268, 'ITEM #2268__ITEM #2268', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2269, 'ITEM #2269__ITEM #2269', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2270, 'ITEM #2270__ITEM #2270', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2271, 'ITEM #2271__ITEM #2271', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2272, 'ITEM #2272__ITEM #2272', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2273, 'ITEM #2273__ITEM #2273', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2274, 'ITEM #2274__ITEM #2274', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2275, 'ITEM #2275__ITEM #2275', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2276, 'ITEM #2276__ITEM #2276', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2277, 'ITEM #2277__ITEM #2277', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2278, 'ITEM #2278__ITEM #2278', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2279, 'ITEM #2279__ITEM #2279', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2280, 'ITEM #2280__ITEM #2280', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2281, 'ITEM #2281__ITEM #2281', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2282, 'ITEM #2282__ITEM #2282', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2283, 'ITEM #2283__ITEM #2283', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2284, 'ITEM #2284__ITEM #2284', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2285, 'ITEM #2285__ITEM #2285', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2286, 'ITEM #2286__ITEM #2286', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2287, 'ITEM #2287__ITEM #2287', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2288, 'ITEM #2288__ITEM #2288', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2289, 'ITEM #2289__ITEM #2289', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2290, 'ITEM #2290__ITEM #2290', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2291, 'ITEM #2291__ITEM #2291', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2292, 'ITEM #2292__ITEM #2292', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2293, 'ITEM #2293__ITEM #2293', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2294, 'ITEM #2294__ITEM #2294', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2295, 'ITEM #2295__ITEM #2295', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2296, 'ITEM #2296__ITEM #2296', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2297, 'ITEM #2297__ITEM #2297', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2298, 'ITEM #2298__ITEM #2298', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2299, 'ITEM #2299__ITEM #2299', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2300, 'ITEM #2300__ITEM #2300', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2301, 'ITEM #2301__ITEM #2301', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2302, 'ITEM #2302__ITEM #2302', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2303, 'ITEM #2303__ITEM #2303', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2304, 'ITEM #2304__ITEM #2304', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2305, 'ITEM #2305__ITEM #2305', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2306, 'ITEM #2306__ITEM #2306', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2307, 'ITEM #2307__ITEM #2307', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2308, 'ITEM #2308__ITEM #2308', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2309, 'ITEM #2309__ITEM #2309', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2310, 'ITEM #2310__ITEM #2310', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2311, 'ITEM #2311__ITEM #2311', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2312, 'ITEM #2312__ITEM #2312', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2313, 'ITEM #2313__ITEM #2313', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2314, 'ITEM #2314__ITEM #2314', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2315, 'ITEM #2315__ITEM #2315', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2316, 'ITEM #2316__ITEM #2316', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2317, 'ITEM #2317__ITEM #2317', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2318, 'ITEM #2318__ITEM #2318', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2319, 'ITEM #2319__ITEM #2319', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2320, 'ITEM #2320__ITEM #2320', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2321, 'ITEM #2321__ITEM #2321', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2322, 'ITEM #2322__ITEM #2322', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2323, 'ITEM #2323__ITEM #2323', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2324, 'ITEM #2324__ITEM #2324', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2325, 'ITEM #2325__ITEM #2325', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2326, 'ITEM #2326__ITEM #2326', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2327, 'ITEM #2327__ITEM #2327', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2328, 'ITEM #2328__ITEM #2328', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2329, 'ITEM #2329__ITEM #2329', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2330, 'ITEM #2330__ITEM #2330', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2331, 'ITEM #2331__ITEM #2331', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2332, 'ITEM #2332__ITEM #2332', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2333, 'ITEM #2333__ITEM #2333', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2334, 'ITEM #2334__ITEM #2334', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2335, 'ITEM #2335__ITEM #2335', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2336, 'ITEM #2336__ITEM #2336', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2337, 'ITEM #2337__ITEM #2337', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2338, 'ITEM #2338__ITEM #2338', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2339, 'ITEM #2339__ITEM #2339', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2340, 'ITEM #2340__ITEM #2340', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2341, 'ITEM #2341__ITEM #2341', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2342, 'ITEM #2342__ITEM #2342', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2343, 'ITEM #2343__ITEM #2343', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2344, 'ITEM #2344__ITEM #2344', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2345, 'ITEM #2345__ITEM #2345', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2346, 'ITEM #2346__ITEM #2346', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2347, 'ITEM #2347__ITEM #2347', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2348, 'ITEM #2348__ITEM #2348', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2349, 'ITEM #2349__ITEM #2349', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2350, 'ITEM #2350__ITEM #2350', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2351, 'ITEM #2351__ITEM #2351', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2352, 'ITEM #2352__ITEM #2352', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2353, 'ITEM #2353__ITEM #2353', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2354, 'ITEM #2354__ITEM #2354', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2355, 'ITEM #2355__ITEM #2355', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2356, 'ITEM #2356__ITEM #2356', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2357, 'ITEM #2357__ITEM #2357', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2358, 'ITEM #2358__ITEM #2358', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2359, 'ITEM #2359__ITEM #2359', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2360, 'ITEM #2360__ITEM #2360', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2361, 'ITEM #2361__ITEM #2361', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2362, 'ITEM #2362__ITEM #2362', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2363, 'ITEM #2363__ITEM #2363', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2364, 'ITEM #2364__ITEM #2364', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2365, 'ITEM #2365__ITEM #2365', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2366, 'ITEM #2366__ITEM #2366', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2367, 'ITEM #2367__ITEM #2367', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2368, 'ITEM #2368__ITEM #2368', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2369, 'ITEM #2369__ITEM #2369', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2370, 'ITEM #2370__ITEM #2370', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2371, 'ITEM #2371__ITEM #2371', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2372, 'ITEM #2372__ITEM #2372', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2373, 'ITEM #2373__ITEM #2373', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2374, 'ITEM #2374__ITEM #2374', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2375, 'ITEM #2375__ITEM #2375', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2376, 'ITEM #2376__ITEM #2376', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2377, 'ITEM #2377__ITEM #2377', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2378, 'ITEM #2378__ITEM #2378', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2379, 'ITEM #2379__ITEM #2379', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2380, 'ITEM #2380__ITEM #2380', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2381, 'ITEM #2381__ITEM #2381', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2382, 'ITEM #2382__ITEM #2382', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2383, 'ITEM #2383__ITEM #2383', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2384, 'ITEM #2384__ITEM #2384', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2385, 'ITEM #2385__ITEM #2385', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2386, 'ITEM #2386__ITEM #2386', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2387, 'ITEM #2387__ITEM #2387', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2388, 'ITEM #2388__ITEM #2388', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2389, 'ITEM #2389__ITEM #2389', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2390, 'ITEM #2390__ITEM #2390', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2391, 'ITEM #2391__ITEM #2391', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2392, 'ITEM #2392__ITEM #2392', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2393, 'ITEM #2393__ITEM #2393', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2394, 'ITEM #2394__ITEM #2394', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2395, 'ITEM #2395__ITEM #2395', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2396, 'ITEM #2396__ITEM #2396', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2397, 'ITEM #2397__ITEM #2397', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2398, 'ITEM #2398__ITEM #2398', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2399, 'ITEM #2399__ITEM #2399', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2400, 'ITEM #2400__ITEM #2400', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2401, 'ITEM #2401__ITEM #2401', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2402, 'ITEM #2402__ITEM #2402', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2403, 'ITEM #2403__ITEM #2403', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2404, 'ITEM #2404__ITEM #2404', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2405, 'ITEM #2405__ITEM #2405', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2406, 'ITEM #2406__ITEM #2406', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2407, 'ITEM #2407__ITEM #2407', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2408, 'ITEM #2408__ITEM #2408', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2409, 'ITEM #2409__ITEM #2409', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2410, 'ITEM #2410__ITEM #2410', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2411, 'ITEM #2411__ITEM #2411', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2412, 'ITEM #2412__ITEM #2412', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2413, 'ITEM #2413__ITEM #2413', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2414, 'ITEM #2414__ITEM #2414', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2415, 'ITEM #2415__ITEM #2415', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2416, 'ITEM #2416__ITEM #2416', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2417, 'ITEM #2417__ITEM #2417', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2418, 'ITEM #2418__ITEM #2418', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2419, 'ITEM #2419__ITEM #2419', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2420, 'ITEM #2420__ITEM #2420', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2421, 'ITEM #2421__ITEM #2421', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2422, 'ITEM #2422__ITEM #2422', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2423, 'ITEM #2423__ITEM #2423', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2424, 'ITEM #2424__ITEM #2424', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2425, 'ITEM #2425__ITEM #2425', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2426, 'ITEM #2426__ITEM #2426', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2427, 'ITEM #2427__ITEM #2427', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2428, 'ITEM #2428__ITEM #2428', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2429, 'ITEM #2429__ITEM #2429', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2430, 'ITEM #2430__ITEM #2430', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2431, 'ITEM #2431__ITEM #2431', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2432, 'ITEM #2432__ITEM #2432', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2433, 'ITEM #2433__ITEM #2433', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2434, 'ITEM #2434__ITEM #2434', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2435, 'ITEM #2435__ITEM #2435', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2436, 'ITEM #2436__ITEM #2436', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2437, 'ITEM #2437__ITEM #2437', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2438, 'ITEM #2438__ITEM #2438', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2439, 'ITEM #2439__ITEM #2439', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2440, 'ITEM #2440__ITEM #2440', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2441, 'ITEM #2441__ITEM #2441', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2442, 'ITEM #2442__ITEM #2442', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2443, 'ITEM #2443__ITEM #2443', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2444, 'ITEM #2444__ITEM #2444', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2445, 'ITEM #2445__ITEM #2445', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2446, 'ITEM #2446__ITEM #2446', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2447, 'ITEM #2447__ITEM #2447', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2448, 'ITEM #2448__ITEM #2448', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2449, 'ITEM #2449__ITEM #2449', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2450, 'ITEM #2450__ITEM #2450', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2451, 'ITEM #2451__ITEM #2451', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2452, 'ITEM #2452__ITEM #2452', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2453, 'ITEM #2453__ITEM #2453', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2454, 'ITEM #2454__ITEM #2454', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2455, 'ITEM #2455__ITEM #2455', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2456, 'ITEM #2456__ITEM #2456', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2457, 'ITEM #2457__ITEM #2457', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2458, 'ITEM #2458__ITEM #2458', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2459, 'ITEM #2459__ITEM #2459', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2460, 'ITEM #2460__ITEM #2460', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2461, 'ITEM #2461__ITEM #2461', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2462, 'ITEM #2462__ITEM #2462', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2463, 'ITEM #2463__ITEM #2463', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2464, 'ITEM #2464__ITEM #2464', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2465, 'ITEM #2465__ITEM #2465', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2466, 'ITEM #2466__ITEM #2466', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2467, 'ITEM #2467__ITEM #2467', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2468, 'ITEM #2468__ITEM #2468', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2469, 'ITEM #2469__ITEM #2469', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2470, 'ITEM #2470__ITEM #2470', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2471, 'ITEM #2471__ITEM #2471', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2472, 'ITEM #2472__ITEM #2472', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2473, 'ITEM #2473__ITEM #2473', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2474, 'ITEM #2474__ITEM #2474', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2475, 'ITEM #2475__ITEM #2475', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2476, 'ITEM #2476__ITEM #2476', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2477, 'ITEM #2477__ITEM #2477', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2478, 'ITEM #2478__ITEM #2478', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2479, 'ITEM #2479__ITEM #2479', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2480, 'ITEM #2480__ITEM #2480', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2481, 'ITEM #2481__ITEM #2481', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2482, 'ITEM #2482__ITEM #2482', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2483, 'ITEM #2483__ITEM #2483', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2484, 'ITEM #2484__ITEM #2484', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2485, 'ITEM #2485__ITEM #2485', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2486, 'ITEM #2486__ITEM #2486', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2487, 'ITEM #2487__ITEM #2487', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2488, 'ITEM #2488__ITEM #2488', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2489, 'ITEM #2489__ITEM #2489', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2490, 'ITEM #2490__ITEM #2490', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2491, 'ITEM #2491__ITEM #2491', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2492, 'ITEM #2492__ITEM #2492', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2493, 'ITEM #2493__ITEM #2493', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2494, 'ITEM #2494__ITEM #2494', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2495, 'ITEM #2495__ITEM #2495', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2496, 'ITEM #2496__ITEM #2496', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2497, 'ITEM #2497__ITEM #2497', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2498, 'ITEM #2498__ITEM #2498', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2499, 'ITEM #2499__ITEM #2499', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2500, 'ITEM #2500__ITEM #2500', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2501, 'ITEM #2501__ITEM #2501', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2502, 'ITEM #2502__ITEM #2502', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2503, 'ITEM #2503__ITEM #2503', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2504, 'ITEM #2504__ITEM #2504', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2505, 'ITEM #2505__ITEM #2505', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2506, 'ITEM #2506__ITEM #2506', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2507, 'ITEM #2507__ITEM #2507', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2508, 'ITEM #2508__ITEM #2508', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2509, 'ITEM #2509__ITEM #2509', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2510, 'ITEM #2510__ITEM #2510', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2511, 'ITEM #2511__ITEM #2511', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2512, 'ITEM #2512__ITEM #2512', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2513, 'ITEM #2513__ITEM #2513', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2514, 'ITEM #2514__ITEM #2514', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2515, 'ITEM #2515__ITEM #2515', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2516, 'ITEM #2516__ITEM #2516', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2517, 'ITEM #2517__ITEM #2517', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2518, 'ITEM #2518__ITEM #2518', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2519, 'ITEM #2519__ITEM #2519', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2520, 'ITEM #2520__ITEM #2520', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2521, 'ITEM #2521__ITEM #2521', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2522, 'ITEM #2522__ITEM #2522', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2523, 'ITEM #2523__ITEM #2523', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2524, 'ITEM #2524__ITEM #2524', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2525, 'ITEM #2525__ITEM #2525', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2526, 'ITEM #2526__ITEM #2526', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2527, 'ITEM #2527__ITEM #2527', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2528, 'ITEM #2528__ITEM #2528', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2529, 'ITEM #2529__ITEM #2529', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2530, 'ITEM #2530__ITEM #2530', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2531, 'ITEM #2531__ITEM #2531', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2532, 'ITEM #2532__ITEM #2532', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2533, 'ITEM #2533__ITEM #2533', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2534, 'ITEM #2534__ITEM #2534', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2535, 'ITEM #2535__ITEM #2535', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2536, 'ITEM #2536__ITEM #2536', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2537, 'ITEM #2537__ITEM #2537', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2538, 'ITEM #2538__ITEM #2538', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2539, 'ITEM #2539__ITEM #2539', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2540, 'ITEM #2540__ITEM #2540', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2541, 'ITEM #2541__ITEM #2541', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2542, 'ITEM #2542__ITEM #2542', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2543, 'ITEM #2543__ITEM #2543', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2544, 'ITEM #2544__ITEM #2544', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2545, 'ITEM #2545__ITEM #2545', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2546, 'ITEM #2546__ITEM #2546', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2547, 'ITEM #2547__ITEM #2547', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2548, 'ITEM #2548__ITEM #2548', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2549, 'ITEM #2549__ITEM #2549', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2550, 'ITEM #2550__ITEM #2550', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2551, 'ITEM #2551__ITEM #2551', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2552, 'ITEM #2552__ITEM #2552', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2553, 'ITEM #2553__ITEM #2553', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2554, 'ITEM #2554__ITEM #2554', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2555, 'ITEM #2555__ITEM #2555', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2556, 'ITEM #2556__ITEM #2556', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2557, 'ITEM #2557__ITEM #2557', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2558, 'ITEM #2558__ITEM #2558', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2559, 'ITEM #2559__ITEM #2559', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2560, 'ITEM #2560__ITEM #2560', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2561, 'ITEM #2561__ITEM #2561', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2562, 'ITEM #2562__ITEM #2562', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2563, 'ITEM #2563__ITEM #2563', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2564, 'ITEM #2564__ITEM #2564', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2565, 'ITEM #2565__ITEM #2565', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2566, 'ITEM #2566__ITEM #2566', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2567, 'ITEM #2567__ITEM #2567', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2568, 'ITEM #2568__ITEM #2568', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2569, 'ITEM #2569__ITEM #2569', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2570, 'ITEM #2570__ITEM #2570', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2571, 'ITEM #2571__ITEM #2571', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2572, 'ITEM #2572__ITEM #2572', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2573, 'ITEM #2573__ITEM #2573', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2574, 'ITEM #2574__ITEM #2574', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2575, 'ITEM #2575__ITEM #2575', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2576, 'ITEM #2576__ITEM #2576', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2577, 'ITEM #2577__ITEM #2577', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2578, 'ITEM #2578__ITEM #2578', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2579, 'ITEM #2579__ITEM #2579', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2580, 'ITEM #2580__ITEM #2580', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2581, 'ITEM #2581__ITEM #2581', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2582, 'ITEM #2582__ITEM #2582', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2583, 'ITEM #2583__ITEM #2583', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2584, 'ITEM #2584__ITEM #2584', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2585, 'ITEM #2585__ITEM #2585', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2586, 'ITEM #2586__ITEM #2586', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2587, 'ITEM #2587__ITEM #2587', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2588, 'ITEM #2588__ITEM #2588', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2589, 'ITEM #2589__ITEM #2589', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2590, 'ITEM #2590__ITEM #2590', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2591, 'ITEM #2591__ITEM #2591', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2592, 'ITEM #2592__ITEM #2592', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2593, 'ITEM #2593__ITEM #2593', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2594, 'ITEM #2594__ITEM #2594', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2595, 'ITEM #2595__ITEM #2595', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2596, 'ITEM #2596__ITEM #2596', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2597, 'ITEM #2597__ITEM #2597', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2598, 'ITEM #2598__ITEM #2598', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2599, 'ITEM #2599__ITEM #2599', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2600, 'ITEM #2600__ITEM #2600', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2601, 'ITEM #2601__ITEM #2601', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2602, 'ITEM #2602__ITEM #2602', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2603, 'ITEM #2603__ITEM #2603', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2604, 'ITEM #2604__ITEM #2604', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2605, 'ITEM #2605__ITEM #2605', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2606, 'ITEM #2606__ITEM #2606', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2607, 'ITEM #2607__ITEM #2607', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2608, 'ITEM #2608__ITEM #2608', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2609, 'ITEM #2609__ITEM #2609', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2610, 'ITEM #2610__ITEM #2610', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2611, 'ITEM #2611__ITEM #2611', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2612, 'ITEM #2612__ITEM #2612', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2613, 'ITEM #2613__ITEM #2613', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2614, 'ITEM #2614__ITEM #2614', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2615, 'ITEM #2615__ITEM #2615', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2616, 'ITEM #2616__ITEM #2616', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2617, 'ITEM #2617__ITEM #2617', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2618, 'ITEM #2618__ITEM #2618', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2619, 'ITEM #2619__ITEM #2619', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2620, 'ITEM #2620__ITEM #2620', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2621, 'ITEM #2621__ITEM #2621', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2622, 'ITEM #2622__ITEM #2622', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2623, 'ITEM #2623__ITEM #2623', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2624, 'ITEM #2624__ITEM #2624', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2625, 'ITEM #2625__ITEM #2625', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2626, 'ITEM #2626__ITEM #2626', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2627, 'ITEM #2627__ITEM #2627', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2628, 'ITEM #2628__ITEM #2628', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2629, 'ITEM #2629__ITEM #2629', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2630, 'ITEM #2630__ITEM #2630', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2631, 'ITEM #2631__ITEM #2631', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2632, 'ITEM #2632__ITEM #2632', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2633, 'ITEM #2633__ITEM #2633', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2634, 'ITEM #2634__ITEM #2634', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2635, 'ITEM #2635__ITEM #2635', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2636, 'ITEM #2636__ITEM #2636', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2637, 'ITEM #2637__ITEM #2637', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2638, 'ITEM #2638__ITEM #2638', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2639, 'ITEM #2639__ITEM #2639', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2640, 'ITEM #2640__ITEM #2640', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2641, 'ITEM #2641__ITEM #2641', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2642, 'ITEM #2642__ITEM #2642', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2643, 'ITEM #2643__ITEM #2643', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2644, 'ITEM #2644__ITEM #2644', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2645, 'ITEM #2645__ITEM #2645', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2646, 'ITEM #2646__ITEM #2646', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2647, 'ITEM #2647__ITEM #2647', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2648, 'ITEM #2648__ITEM #2648', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2649, 'ITEM #2649__ITEM #2649', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2650, 'ITEM #2650__ITEM #2650', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2651, 'ITEM #2651__ITEM #2651', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2652, 'ITEM #2652__ITEM #2652', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2653, 'ITEM #2653__ITEM #2653', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2654, 'ITEM #2654__ITEM #2654', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2655, 'ITEM #2655__ITEM #2655', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2656, 'ITEM #2656__ITEM #2656', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2657, 'ITEM #2657__ITEM #2657', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2658, 'ITEM #2658__ITEM #2658', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2659, 'ITEM #2659__ITEM #2659', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2660, 'ITEM #2660__ITEM #2660', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2661, 'ITEM #2661__ITEM #2661', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2662, 'ITEM #2662__ITEM #2662', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2663, 'ITEM #2663__ITEM #2663', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2664, 'ITEM #2664__ITEM #2664', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2665, 'ITEM #2665__ITEM #2665', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2666, 'ITEM #2666__ITEM #2666', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2667, 'ITEM #2667__ITEM #2667', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2668, 'ITEM #2668__ITEM #2668', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2669, 'ITEM #2669__ITEM #2669', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2670, 'ITEM #2670__ITEM #2670', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2671, 'ITEM #2671__ITEM #2671', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2672, 'ITEM #2672__ITEM #2672', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2673, 'ITEM #2673__ITEM #2673', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2674, 'ITEM #2674__ITEM #2674', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2675, 'ITEM #2675__ITEM #2675', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2676, 'ITEM #2676__ITEM #2676', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2677, 'ITEM #2677__ITEM #2677', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2678, 'ITEM #2678__ITEM #2678', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2679, 'ITEM #2679__ITEM #2679', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2680, 'ITEM #2680__ITEM #2680', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2681, 'ITEM #2681__ITEM #2681', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2682, 'ITEM #2682__ITEM #2682', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2683, 'ITEM #2683__ITEM #2683', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2684, 'ITEM #2684__ITEM #2684', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2685, 'ITEM #2685__ITEM #2685', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2686, 'ITEM #2686__ITEM #2686', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2687, 'ITEM #2687__ITEM #2687', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2688, 'ITEM #2688__ITEM #2688', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2689, 'ITEM #2689__ITEM #2689', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2690, 'ITEM #2690__ITEM #2690', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2691, 'ITEM #2691__ITEM #2691', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2692, 'ITEM #2692__ITEM #2692', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2693, 'ITEM #2693__ITEM #2693', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2694, 'ITEM #2694__ITEM #2694', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2695, 'ITEM #2695__ITEM #2695', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2696, 'ITEM #2696__ITEM #2696', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2697, 'ITEM #2697__ITEM #2697', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2698, 'ITEM #2698__ITEM #2698', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2699, 'ITEM #2699__ITEM #2699', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2700, 'ITEM #2700__ITEM #2700', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2701, 'ITEM #2701__ITEM #2701', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2702, 'ITEM #2702__ITEM #2702', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2703, 'ITEM #2703__ITEM #2703', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2704, 'ITEM #2704__ITEM #2704', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2705, 'ITEM #2705__ITEM #2705', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2706, 'ITEM #2706__ITEM #2706', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2707, 'ITEM #2707__ITEM #2707', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2708, 'ITEM #2708__ITEM #2708', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2709, 'ITEM #2709__ITEM #2709', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2710, 'ITEM #2710__ITEM #2710', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2711, 'ITEM #2711__ITEM #2711', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2712, 'ITEM #2712__ITEM #2712', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2713, 'ITEM #2713__ITEM #2713', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2714, 'ITEM #2714__ITEM #2714', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2715, 'ITEM #2715__ITEM #2715', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2716, 'ITEM #2716__ITEM #2716', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2717, 'ITEM #2717__ITEM #2717', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2718, 'ITEM #2718__ITEM #2718', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2719, 'ITEM #2719__ITEM #2719', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2720, 'ITEM #2720__ITEM #2720', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2721, 'ITEM #2721__ITEM #2721', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2722, 'ITEM #2722__ITEM #2722', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2723, 'ITEM #2723__ITEM #2723', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2724, 'ITEM #2724__ITEM #2724', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2725, 'ITEM #2725__ITEM #2725', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2726, 'ITEM #2726__ITEM #2726', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2727, 'ITEM #2727__ITEM #2727', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2728, 'ITEM #2728__ITEM #2728', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2729, 'ITEM #2729__ITEM #2729', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2730, 'ITEM #2730__ITEM #2730', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2731, 'ITEM #2731__ITEM #2731', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2732, 'ITEM #2732__ITEM #2732', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2733, 'ITEM #2733__ITEM #2733', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2734, 'ITEM #2734__ITEM #2734', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2735, 'ITEM #2735__ITEM #2735', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2736, 'ITEM #2736__ITEM #2736', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2737, 'ITEM #2737__ITEM #2737', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2738, 'ITEM #2738__ITEM #2738', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2739, 'ITEM #2739__ITEM #2739', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2740, 'ITEM #2740__ITEM #2740', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2741, 'ITEM #2741__ITEM #2741', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2742, 'ITEM #2742__ITEM #2742', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2743, 'ITEM #2743__ITEM #2743', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2744, 'ITEM #2744__ITEM #2744', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2745, 'ITEM #2745__ITEM #2745', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2746, 'ITEM #2746__ITEM #2746', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2747, 'ITEM #2747__ITEM #2747', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2748, 'ITEM #2748__ITEM #2748', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2749, 'ITEM #2749__ITEM #2749', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2750, 'ITEM #2750__ITEM #2750', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2751, 'ITEM #2751__ITEM #2751', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2752, 'ITEM #2752__ITEM #2752', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2753, 'ITEM #2753__ITEM #2753', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2754, 'ITEM #2754__ITEM #2754', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2755, 'ITEM #2755__ITEM #2755', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2756, 'ITEM #2756__ITEM #2756', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2757, 'ITEM #2757__ITEM #2757', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2758, 'ITEM #2758__ITEM #2758', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2759, 'ITEM #2759__ITEM #2759', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2760, 'ITEM #2760__ITEM #2760', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2761, 'ITEM #2761__ITEM #2761', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2762, 'ITEM #2762__ITEM #2762', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2763, 'ITEM #2763__ITEM #2763', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2764, 'ITEM #2764__ITEM #2764', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2765, 'ITEM #2765__ITEM #2765', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2766, 'ITEM #2766__ITEM #2766', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2767, 'ITEM #2767__ITEM #2767', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2768, 'ITEM #2768__ITEM #2768', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2769, 'ITEM #2769__ITEM #2769', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2770, 'ITEM #2770__ITEM #2770', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2771, 'ITEM #2771__ITEM #2771', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2772, 'ITEM #2772__ITEM #2772', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2773, 'ITEM #2773__ITEM #2773', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2774, 'ITEM #2774__ITEM #2774', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2775, 'ITEM #2775__ITEM #2775', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2776, 'ITEM #2776__ITEM #2776', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2777, 'ITEM #2777__ITEM #2777', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2778, 'ITEM #2778__ITEM #2778', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2779, 'ITEM #2779__ITEM #2779', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2780, 'ITEM #2780__ITEM #2780', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2781, 'ITEM #2781__ITEM #2781', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2782, 'ITEM #2782__ITEM #2782', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2783, 'ITEM #2783__ITEM #2783', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2784, 'ITEM #2784__ITEM #2784', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2785, 'ITEM #2785__ITEM #2785', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2786, 'ITEM #2786__ITEM #2786', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2787, 'ITEM #2787__ITEM #2787', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2788, 'ITEM #2788__ITEM #2788', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2789, 'ITEM #2789__ITEM #2789', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2790, 'ITEM #2790__ITEM #2790', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2791, 'ITEM #2791__ITEM #2791', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2792, 'ITEM #2792__ITEM #2792', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2793, 'ITEM #2793__ITEM #2793', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2794, 'ITEM #2794__ITEM #2794', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2795, 'ITEM #2795__ITEM #2795', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2796, 'ITEM #2796__ITEM #2796', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2797, 'ITEM #2797__ITEM #2797', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2798, 'ITEM #2798__ITEM #2798', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2799, 'ITEM #2799__ITEM #2799', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2800, 'ITEM #2800__ITEM #2800', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2801, 'ITEM #2801__ITEM #2801', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2802, 'ITEM #2802__ITEM #2802', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2803, 'ITEM #2803__ITEM #2803', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2804, 'ITEM #2804__ITEM #2804', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2805, 'ITEM #2805__ITEM #2805', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2806, 'ITEM #2806__ITEM #2806', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2807, 'ITEM #2807__ITEM #2807', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2808, 'ITEM #2808__ITEM #2808', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2809, 'ITEM #2809__ITEM #2809', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2810, 'ITEM #2810__ITEM #2810', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2811, 'ITEM #2811__ITEM #2811', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2812, 'ITEM #2812__ITEM #2812', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2813, 'ITEM #2813__ITEM #2813', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2814, 'ITEM #2814__ITEM #2814', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2815, 'ITEM #2815__ITEM #2815', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2816, 'ITEM #2816__ITEM #2816', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2817, 'ITEM #2817__ITEM #2817', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2818, 'ITEM #2818__ITEM #2818', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2819, 'ITEM #2819__ITEM #2819', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2820, 'ITEM #2820__ITEM #2820', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2821, 'ITEM #2821__ITEM #2821', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2822, 'ITEM #2822__ITEM #2822', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2823, 'ITEM #2823__ITEM #2823', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2824, 'ITEM #2824__ITEM #2824', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2825, 'ITEM #2825__ITEM #2825', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2826, 'ITEM #2826__ITEM #2826', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2827, 'ITEM #2827__ITEM #2827', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2828, 'ITEM #2828__ITEM #2828', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2829, 'ITEM #2829__ITEM #2829', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2830, 'ITEM #2830__ITEM #2830', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2831, 'ITEM #2831__ITEM #2831', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2832, 'ITEM #2832__ITEM #2832', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2833, 'ITEM #2833__ITEM #2833', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2834, 'ITEM #2834__ITEM #2834', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2835, 'ITEM #2835__ITEM #2835', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2836, 'ITEM #2836__ITEM #2836', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2837, 'ITEM #2837__ITEM #2837', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2838, 'ITEM #2838__ITEM #2838', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2839, 'ITEM #2839__ITEM #2839', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2840, 'ITEM #2840__ITEM #2840', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2841, 'ITEM #2841__ITEM #2841', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2842, 'ITEM #2842__ITEM #2842', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2843, 'ITEM #2843__ITEM #2843', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2844, 'ITEM #2844__ITEM #2844', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2845, 'ITEM #2845__ITEM #2845', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2846, 'ITEM #2846__ITEM #2846', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2847, 'ITEM #2847__ITEM #2847', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2848, 'ITEM #2848__ITEM #2848', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2849, 'ITEM #2849__ITEM #2849', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2850, 'ITEM #2850__ITEM #2850', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2851, 'ITEM #2851__ITEM #2851', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2852, 'ITEM #2852__ITEM #2852', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2853, 'ITEM #2853__ITEM #2853', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2854, 'ITEM #2854__ITEM #2854', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2855, 'ITEM #2855__ITEM #2855', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2856, 'ITEM #2856__ITEM #2856', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2857, 'ITEM #2857__ITEM #2857', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2858, 'ITEM #2858__ITEM #2858', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2859, 'ITEM #2859__ITEM #2859', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2860, 'ITEM #2860__ITEM #2860', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2861, 'ITEM #2861__ITEM #2861', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2862, 'ITEM #2862__ITEM #2862', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2863, 'ITEM #2863__ITEM #2863', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2864, 'ITEM #2864__ITEM #2864', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2865, 'ITEM #2865__ITEM #2865', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2866, 'ITEM #2866__ITEM #2866', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2867, 'ITEM #2867__ITEM #2867', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2868, 'ITEM #2868__ITEM #2868', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2869, 'ITEM #2869__ITEM #2869', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2870, 'ITEM #2870__ITEM #2870', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2871, 'ITEM #2871__ITEM #2871', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2872, 'ITEM #2872__ITEM #2872', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2873, 'ITEM #2873__ITEM #2873', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2874, 'ITEM #2874__ITEM #2874', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2875, 'ITEM #2875__ITEM #2875', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2876, 'ITEM #2876__ITEM #2876', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2877, 'ITEM #2877__ITEM #2877', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2878, 'ITEM #2878__ITEM #2878', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2879, 'ITEM #2879__ITEM #2879', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2880, 'ITEM #2880__ITEM #2880', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2881, 'ITEM #2881__ITEM #2881', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2882, 'ITEM #2882__ITEM #2882', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2883, 'ITEM #2883__ITEM #2883', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2884, 'ITEM #2884__ITEM #2884', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2885, 'ITEM #2885__ITEM #2885', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2886, 'ITEM #2886__ITEM #2886', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2887, 'ITEM #2887__ITEM #2887', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2888, 'ITEM #2888__ITEM #2888', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2889, 'ITEM #2889__ITEM #2889', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2890, 'ITEM #2890__ITEM #2890', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2891, 'ITEM #2891__ITEM #2891', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2892, 'ITEM #2892__ITEM #2892', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2893, 'ITEM #2893__ITEM #2893', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2894, 'ITEM #2894__ITEM #2894', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2895, 'ITEM #2895__ITEM #2895', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2896, 'ITEM #2896__ITEM #2896', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2897, 'ITEM #2897__ITEM #2897', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2898, 'ITEM #2898__ITEM #2898', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2899, 'ITEM #2899__ITEM #2899', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2900, 'ITEM #2900__ITEM #2900', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2901, 'ITEM #2901__ITEM #2901', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2902, 'ITEM #2902__ITEM #2902', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2903, 'ITEM #2903__ITEM #2903', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2904, 'ITEM #2904__ITEM #2904', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2905, 'ITEM #2905__ITEM #2905', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2906, 'ITEM #2906__ITEM #2906', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2907, 'ITEM #2907__ITEM #2907', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2908, 'ITEM #2908__ITEM #2908', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2909, 'ITEM #2909__ITEM #2909', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2910, 'ITEM #2910__ITEM #2910', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2911, 'ITEM #2911__ITEM #2911', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2912, 'ITEM #2912__ITEM #2912', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2913, 'ITEM #2913__ITEM #2913', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2914, 'ITEM #2914__ITEM #2914', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2915, 'ITEM #2915__ITEM #2915', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2916, 'ITEM #2916__ITEM #2916', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2917, 'ITEM #2917__ITEM #2917', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2918, 'ITEM #2918__ITEM #2918', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2919, 'ITEM #2919__ITEM #2919', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2920, 'ITEM #2920__ITEM #2920', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2921, 'ITEM #2921__ITEM #2921', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2922, 'ITEM #2922__ITEM #2922', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2923, 'ITEM #2923__ITEM #2923', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2924, 'ITEM #2924__ITEM #2924', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2925, 'ITEM #2925__ITEM #2925', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2926, 'ITEM #2926__ITEM #2926', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2927, 'ITEM #2927__ITEM #2927', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2928, 'ITEM #2928__ITEM #2928', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2929, 'ITEM #2929__ITEM #2929', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2930, 'ITEM #2930__ITEM #2930', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2931, 'ITEM #2931__ITEM #2931', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2932, 'ITEM #2932__ITEM #2932', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2933, 'ITEM #2933__ITEM #2933', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2934, 'ITEM #2934__ITEM #2934', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2935, 'ITEM #2935__ITEM #2935', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2936, 'ITEM #2936__ITEM #2936', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2937, 'ITEM #2937__ITEM #2937', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2938, 'ITEM #2938__ITEM #2938', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2939, 'ITEM #2939__ITEM #2939', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2940, 'ITEM #2940__ITEM #2940', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2941, 'ITEM #2941__ITEM #2941', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2942, 'ITEM #2942__ITEM #2942', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2943, 'ITEM #2943__ITEM #2943', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2944, 'ITEM #2944__ITEM #2944', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2945, 'ITEM #2945__ITEM #2945', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2946, 'ITEM #2946__ITEM #2946', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2947, 'ITEM #2947__ITEM #2947', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2948, 'ITEM #2948__ITEM #2948', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2949, 'ITEM #2949__ITEM #2949', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2950, 'ITEM #2950__ITEM #2950', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2951, 'ITEM #2951__ITEM #2951', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2952, 'ITEM #2952__ITEM #2952', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2953, 'ITEM #2953__ITEM #2953', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2954, 'ITEM #2954__ITEM #2954', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2955, 'ITEM #2955__ITEM #2955', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2956, 'ITEM #2956__ITEM #2956', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2957, 'ITEM #2957__ITEM #2957', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2958, 'ITEM #2958__ITEM #2958', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2959, 'ITEM #2959__ITEM #2959', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2960, 'ITEM #2960__ITEM #2960', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2961, 'ITEM #2961__ITEM #2961', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2962, 'ITEM #2962__ITEM #2962', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2963, 'ITEM #2963__ITEM #2963', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2964, 'ITEM #2964__ITEM #2964', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2965, 'ITEM #2965__ITEM #2965', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2966, 'ITEM #2966__ITEM #2966', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2967, 'ITEM #2967__ITEM #2967', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2968, 'ITEM #2968__ITEM #2968', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2969, 'ITEM #2969__ITEM #2969', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2970, 'ITEM #2970__ITEM #2970', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2971, 'ITEM #2971__ITEM #2971', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2972, 'ITEM #2972__ITEM #2972', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2973, 'ITEM #2973__ITEM #2973', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2974, 'ITEM #2974__ITEM #2974', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2975, 'ITEM #2975__ITEM #2975', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2976, 'ITEM #2976__ITEM #2976', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2977, 'ITEM #2977__ITEM #2977', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2978, 'ITEM #2978__ITEM #2978', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2979, 'ITEM #2979__ITEM #2979', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2980, 'ITEM #2980__ITEM #2980', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2981, 'ITEM #2981__ITEM #2981', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2982, 'ITEM #2982__ITEM #2982', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2983, 'ITEM #2983__ITEM #2983', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2984, 'ITEM #2984__ITEM #2984', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2985, 'ITEM #2985__ITEM #2985', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2986, 'ITEM #2986__ITEM #2986', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2987, 'ITEM #2987__ITEM #2987', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2988, 'ITEM #2988__ITEM #2988', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2989, 'ITEM #2989__ITEM #2989', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2990, 'ITEM #2990__ITEM #2990', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2991, 'ITEM #2991__ITEM #2991', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2992, 'ITEM #2992__ITEM #2992', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2993, 'ITEM #2993__ITEM #2993', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2994, 'ITEM #2994__ITEM #2994', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2995, 'ITEM #2995__ITEM #2995', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2996, 'ITEM #2996__ITEM #2996', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2997, 'ITEM #2997__ITEM #2997', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2998, 'ITEM #2998__ITEM #2998', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (2999, 'ITEM #2999__ITEM #2999', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3000, 'ITEM #3000__ITEM #3000', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3001, 'ITEM #3001__ITEM #3001', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3002, 'ITEM #3002__ITEM #3002', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3003, 'ITEM #3003__ITEM #3003', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3004, 'ITEM #3004__ITEM #3004', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3005, 'ITEM #3005__ITEM #3005', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3006, 'ITEM #3006__ITEM #3006', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3007, 'ITEM #3007__ITEM #3007', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3008, 'ITEM #3008__ITEM #3008', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3009, 'ITEM #3009__ITEM #3009', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3010, 'ITEM #3010__ITEM #3010', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3011, 'ITEM #3011__ITEM #3011', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3012, 'ITEM #3012__ITEM #3012', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3013, 'ITEM #3013__ITEM #3013', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3014, 'ITEM #3014__ITEM #3014', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3015, 'ITEM #3015__ITEM #3015', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3016, 'ITEM #3016__ITEM #3016', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3017, 'ITEM #3017__ITEM #3017', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3018, 'ITEM #3018__ITEM #3018', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3019, 'ITEM #3019__ITEM #3019', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3020, 'ITEM #3020__ITEM #3020', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3021, 'ITEM #3021__ITEM #3021', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3022, 'ITEM #3022__ITEM #3022', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3023, 'ITEM #3023__ITEM #3023', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3024, 'ITEM #3024__ITEM #3024', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3025, 'ITEM #3025__ITEM #3025', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3026, 'ITEM #3026__ITEM #3026', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3027, 'ITEM #3027__ITEM #3027', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3028, 'ITEM #3028__ITEM #3028', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3029, 'ITEM #3029__ITEM #3029', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3030, 'ITEM #3030__ITEM #3030', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3031, 'ITEM #3031__ITEM #3031', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3032, 'ITEM #3032__ITEM #3032', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3033, 'ITEM #3033__ITEM #3033', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3034, 'ITEM #3034__ITEM #3034', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3035, 'ITEM #3035__ITEM #3035', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3036, 'ITEM #3036__ITEM #3036', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3037, 'ITEM #3037__ITEM #3037', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3038, 'ITEM #3038__ITEM #3038', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3039, 'ITEM #3039__ITEM #3039', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3040, 'ITEM #3040__ITEM #3040', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3041, 'ITEM #3041__ITEM #3041', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3042, 'ITEM #3042__ITEM #3042', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3043, 'ITEM #3043__ITEM #3043', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3044, 'ITEM #3044__ITEM #3044', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3045, 'ITEM #3045__ITEM #3045', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3046, 'ITEM #3046__ITEM #3046', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3047, 'ITEM #3047__ITEM #3047', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3048, 'ITEM #3048__ITEM #3048', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3049, 'ITEM #3049__ITEM #3049', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3050, 'ITEM #3050__ITEM #3050', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3051, 'ITEM #3051__ITEM #3051', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3052, 'ITEM #3052__ITEM #3052', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3053, 'ITEM #3053__ITEM #3053', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3054, 'ITEM #3054__ITEM #3054', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3055, 'ITEM #3055__ITEM #3055', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3056, 'ITEM #3056__ITEM #3056', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3057, 'ITEM #3057__ITEM #3057', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3058, 'ITEM #3058__ITEM #3058', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3059, 'ITEM #3059__ITEM #3059', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3060, 'ITEM #3060__ITEM #3060', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3061, 'ITEM #3061__ITEM #3061', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3062, 'ITEM #3062__ITEM #3062', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3063, 'ITEM #3063__ITEM #3063', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3064, 'ITEM #3064__ITEM #3064', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3065, 'ITEM #3065__ITEM #3065', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3066, 'ITEM #3066__ITEM #3066', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3067, 'ITEM #3067__ITEM #3067', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3068, 'ITEM #3068__ITEM #3068', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3069, 'ITEM #3069__ITEM #3069', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3070, 'ITEM #3070__ITEM #3070', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3071, 'ITEM #3071__ITEM #3071', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3072, 'ITEM #3072__ITEM #3072', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3073, 'ITEM #3073__ITEM #3073', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3074, 'ITEM #3074__ITEM #3074', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3075, 'ITEM #3075__ITEM #3075', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3076, 'ITEM #3076__ITEM #3076', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3077, 'ITEM #3077__ITEM #3077', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3078, 'ITEM #3078__ITEM #3078', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3079, 'ITEM #3079__ITEM #3079', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3080, 'ITEM #3080__ITEM #3080', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3081, 'ITEM #3081__ITEM #3081', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3082, 'ITEM #3082__ITEM #3082', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3083, 'ITEM #3083__ITEM #3083', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3084, 'ITEM #3084__ITEM #3084', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3085, 'ITEM #3085__ITEM #3085', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3086, 'ITEM #3086__ITEM #3086', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3087, 'ITEM #3087__ITEM #3087', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3088, 'ITEM #3088__ITEM #3088', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3089, 'ITEM #3089__ITEM #3089', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3090, 'ITEM #3090__ITEM #3090', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3091, 'ITEM #3091__ITEM #3091', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3092, 'ITEM #3092__ITEM #3092', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3093, 'ITEM #3093__ITEM #3093', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3094, 'ITEM #3094__ITEM #3094', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3095, 'ITEM #3095__ITEM #3095', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3096, 'ITEM #3096__ITEM #3096', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3097, 'ITEM #3097__ITEM #3097', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3098, 'ITEM #3098__ITEM #3098', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3099, 'ITEM #3099__ITEM #3099', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3100, 'ITEM #3100__ITEM #3100', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3101, 'ITEM #3101__ITEM #3101', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3102, 'ITEM #3102__ITEM #3102', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3103, 'ITEM #3103__ITEM #3103', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3104, 'ITEM #3104__ITEM #3104', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3105, 'ITEM #3105__ITEM #3105', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3106, 'ITEM #3106__ITEM #3106', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3107, 'ITEM #3107__ITEM #3107', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3108, 'ITEM #3108__ITEM #3108', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3109, 'ITEM #3109__ITEM #3109', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3110, 'ITEM #3110__ITEM #3110', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3111, 'ITEM #3111__ITEM #3111', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3112, 'ITEM #3112__ITEM #3112', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3113, 'ITEM #3113__ITEM #3113', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3114, 'ITEM #3114__ITEM #3114', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3115, 'ITEM #3115__ITEM #3115', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3116, 'ITEM #3116__ITEM #3116', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3117, 'ITEM #3117__ITEM #3117', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3118, 'ITEM #3118__ITEM #3118', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3119, 'ITEM #3119__ITEM #3119', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3120, 'ITEM #3120__ITEM #3120', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3121, 'ITEM #3121__ITEM #3121', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3122, 'ITEM #3122__ITEM #3122', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3123, 'ITEM #3123__ITEM #3123', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3124, 'ITEM #3124__ITEM #3124', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3125, 'ITEM #3125__ITEM #3125', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3126, 'ITEM #3126__ITEM #3126', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3127, 'ITEM #3127__ITEM #3127', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3128, 'ITEM #3128__ITEM #3128', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3129, 'ITEM #3129__ITEM #3129', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3130, 'ITEM #3130__ITEM #3130', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3131, 'ITEM #3131__ITEM #3131', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3132, 'ITEM #3132__ITEM #3132', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3133, 'ITEM #3133__ITEM #3133', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3134, 'ITEM #3134__ITEM #3134', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3135, 'ITEM #3135__ITEM #3135', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3136, 'ITEM #3136__ITEM #3136', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3137, 'ITEM #3137__ITEM #3137', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3138, 'ITEM #3138__ITEM #3138', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3139, 'ITEM #3139__ITEM #3139', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3140, 'ITEM #3140__ITEM #3140', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3141, 'ITEM #3141__ITEM #3141', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3142, 'ITEM #3142__ITEM #3142', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3143, 'ITEM #3143__ITEM #3143', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3144, 'ITEM #3144__ITEM #3144', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3145, 'ITEM #3145__ITEM #3145', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3146, 'ITEM #3146__ITEM #3146', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3147, 'ITEM #3147__ITEM #3147', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3148, 'ITEM #3148__ITEM #3148', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3149, 'ITEM #3149__ITEM #3149', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3150, 'ITEM #3150__ITEM #3150', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3151, 'ITEM #3151__ITEM #3151', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3152, 'ITEM #3152__ITEM #3152', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3153, 'ITEM #3153__ITEM #3153', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3154, 'ITEM #3154__ITEM #3154', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3155, 'ITEM #3155__ITEM #3155', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3156, 'ITEM #3156__ITEM #3156', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3157, 'ITEM #3157__ITEM #3157', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3158, 'ITEM #3158__ITEM #3158', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3159, 'ITEM #3159__ITEM #3159', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3160, 'ITEM #3160__ITEM #3160', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3161, 'ITEM #3161__ITEM #3161', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3162, 'ITEM #3162__ITEM #3162', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3163, 'ITEM #3163__ITEM #3163', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3164, 'ITEM #3164__ITEM #3164', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3165, 'ITEM #3165__ITEM #3165', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3166, 'ITEM #3166__ITEM #3166', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3167, 'ITEM #3167__ITEM #3167', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3168, 'ITEM #3168__ITEM #3168', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3169, 'ITEM #3169__ITEM #3169', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3170, 'ITEM #3170__ITEM #3170', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3171, 'ITEM #3171__ITEM #3171', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3172, 'ITEM #3172__ITEM #3172', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3173, 'ITEM #3173__ITEM #3173', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3174, 'ITEM #3174__ITEM #3174', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3175, 'ITEM #3175__ITEM #3175', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3176, 'ITEM #3176__ITEM #3176', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3177, 'ITEM #3177__ITEM #3177', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3178, 'ITEM #3178__ITEM #3178', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3179, 'ITEM #3179__ITEM #3179', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3180, 'ITEM #3180__ITEM #3180', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3181, 'ITEM #3181__ITEM #3181', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3182, 'ITEM #3182__ITEM #3182', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3183, 'ITEM #3183__ITEM #3183', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3184, 'ITEM #3184__ITEM #3184', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3185, 'ITEM #3185__ITEM #3185', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3186, 'ITEM #3186__ITEM #3186', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3187, 'ITEM #3187__ITEM #3187', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3188, 'ITEM #3188__ITEM #3188', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3189, 'ITEM #3189__ITEM #3189', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3190, 'ITEM #3190__ITEM #3190', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3191, 'ITEM #3191__ITEM #3191', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3192, 'ITEM #3192__ITEM #3192', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3193, 'ITEM #3193__ITEM #3193', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3194, 'ITEM #3194__ITEM #3194', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3195, 'ITEM #3195__ITEM #3195', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3196, 'ITEM #3196__ITEM #3196', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3197, 'ITEM #3197__ITEM #3197', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3198, 'ITEM #3198__ITEM #3198', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3199, 'ITEM #3199__ITEM #3199', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3200, 'ITEM #3200__ITEM #3200', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3201, 'ITEM #3201__ITEM #3201', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3202, 'ITEM #3202__ITEM #3202', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3203, 'ITEM #3203__ITEM #3203', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3204, 'ITEM #3204__ITEM #3204', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3205, 'ITEM #3205__ITEM #3205', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3206, 'ITEM #3206__ITEM #3206', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3207, 'ITEM #3207__ITEM #3207', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3208, 'ITEM #3208__ITEM #3208', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3209, 'ITEM #3209__ITEM #3209', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3210, 'ITEM #3210__ITEM #3210', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3211, 'ITEM #3211__ITEM #3211', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3212, 'ITEM #3212__ITEM #3212', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3213, 'ITEM #3213__ITEM #3213', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3214, 'ITEM #3214__ITEM #3214', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3215, 'ITEM #3215__ITEM #3215', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3216, 'ITEM #3216__ITEM #3216', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3217, 'ITEM #3217__ITEM #3217', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3218, 'ITEM #3218__ITEM #3218', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3219, 'ITEM #3219__ITEM #3219', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3220, 'ITEM #3220__ITEM #3220', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3221, 'ITEM #3221__ITEM #3221', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3222, 'ITEM #3222__ITEM #3222', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3223, 'ITEM #3223__ITEM #3223', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3224, 'ITEM #3224__ITEM #3224', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3225, 'ITEM #3225__ITEM #3225', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3226, 'ITEM #3226__ITEM #3226', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3227, 'ITEM #3227__ITEM #3227', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3228, 'ITEM #3228__ITEM #3228', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3229, 'ITEM #3229__ITEM #3229', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3230, 'ITEM #3230__ITEM #3230', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3231, 'ITEM #3231__ITEM #3231', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3232, 'ITEM #3232__ITEM #3232', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3233, 'ITEM #3233__ITEM #3233', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3234, 'ITEM #3234__ITEM #3234', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3235, 'ITEM #3235__ITEM #3235', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3236, 'ITEM #3236__ITEM #3236', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3237, 'ITEM #3237__ITEM #3237', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3238, 'ITEM #3238__ITEM #3238', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3239, 'ITEM #3239__ITEM #3239', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3240, 'ITEM #3240__ITEM #3240', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3241, 'ITEM #3241__ITEM #3241', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3242, 'ITEM #3242__ITEM #3242', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3243, 'ITEM #3243__ITEM #3243', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3244, 'ITEM #3244__ITEM #3244', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3245, 'ITEM #3245__ITEM #3245', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3246, 'ITEM #3246__ITEM #3246', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3247, 'ITEM #3247__ITEM #3247', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3248, 'ITEM #3248__ITEM #3248', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3249, 'ITEM #3249__ITEM #3249', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3250, 'ITEM #3250__ITEM #3250', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3251, 'ITEM #3251__ITEM #3251', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3252, 'ITEM #3252__ITEM #3252', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3253, 'ITEM #3253__ITEM #3253', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3254, 'ITEM #3254__ITEM #3254', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3255, 'ITEM #3255__ITEM #3255', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3256, 'ITEM #3256__ITEM #3256', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3257, 'ITEM #3257__ITEM #3257', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3258, 'ITEM #3258__ITEM #3258', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3259, 'ITEM #3259__ITEM #3259', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3260, 'ITEM #3260__ITEM #3260', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3261, 'ITEM #3261__ITEM #3261', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3262, 'ITEM #3262__ITEM #3262', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3263, 'ITEM #3263__ITEM #3263', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3264, 'ITEM #3264__ITEM #3264', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3265, 'ITEM #3265__ITEM #3265', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3266, 'ITEM #3266__ITEM #3266', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3267, 'ITEM #3267__ITEM #3267', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3268, 'ITEM #3268__ITEM #3268', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3269, 'ITEM #3269__ITEM #3269', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3270, 'ITEM #3270__ITEM #3270', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3271, 'ITEM #3271__ITEM #3271', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3272, 'ITEM #3272__ITEM #3272', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3273, 'ITEM #3273__ITEM #3273', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3274, 'ITEM #3274__ITEM #3274', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3275, 'ITEM #3275__ITEM #3275', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3276, 'ITEM #3276__ITEM #3276', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3277, 'ITEM #3277__ITEM #3277', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3278, 'ITEM #3278__ITEM #3278', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3279, 'ITEM #3279__ITEM #3279', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3280, 'ITEM #3280__ITEM #3280', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3281, 'ITEM #3281__ITEM #3281', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3282, 'ITEM #3282__ITEM #3282', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3283, 'ITEM #3283__ITEM #3283', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3284, 'ITEM #3284__ITEM #3284', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3285, 'ITEM #3285__ITEM #3285', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3286, 'ITEM #3286__ITEM #3286', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3287, 'ITEM #3287__ITEM #3287', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3288, 'ITEM #3288__ITEM #3288', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3289, 'ITEM #3289__ITEM #3289', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3290, 'ITEM #3290__ITEM #3290', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3291, 'ITEM #3291__ITEM #3291', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3292, 'ITEM #3292__ITEM #3292', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3293, 'ITEM #3293__ITEM #3293', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3294, 'ITEM #3294__ITEM #3294', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3295, 'ITEM #3295__ITEM #3295', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3296, 'ITEM #3296__ITEM #3296', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3297, 'ITEM #3297__ITEM #3297', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3298, 'ITEM #3298__ITEM #3298', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3299, 'ITEM #3299__ITEM #3299', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3300, 'ITEM #3300__ITEM #3300', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3301, 'ITEM #3301__ITEM #3301', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3302, 'ITEM #3302__ITEM #3302', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3303, 'ITEM #3303__ITEM #3303', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3304, 'ITEM #3304__ITEM #3304', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3305, 'ITEM #3305__ITEM #3305', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3306, 'ITEM #3306__ITEM #3306', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3307, 'ITEM #3307__ITEM #3307', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3308, 'ITEM #3308__ITEM #3308', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3309, 'ITEM #3309__ITEM #3309', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3310, 'ITEM #3310__ITEM #3310', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3311, 'ITEM #3311__ITEM #3311', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3312, 'ITEM #3312__ITEM #3312', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3313, 'ITEM #3313__ITEM #3313', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3314, 'ITEM #3314__ITEM #3314', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3315, 'ITEM #3315__ITEM #3315', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3316, 'ITEM #3316__ITEM #3316', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3317, 'ITEM #3317__ITEM #3317', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3318, 'ITEM #3318__ITEM #3318', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3319, 'ITEM #3319__ITEM #3319', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3320, 'ITEM #3320__ITEM #3320', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3321, 'ITEM #3321__ITEM #3321', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3322, 'ITEM #3322__ITEM #3322', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3323, 'ITEM #3323__ITEM #3323', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3324, 'ITEM #3324__ITEM #3324', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3325, 'ITEM #3325__ITEM #3325', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3326, 'ITEM #3326__ITEM #3326', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3327, 'ITEM #3327__ITEM #3327', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3328, 'ITEM #3328__ITEM #3328', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3329, 'ITEM #3329__ITEM #3329', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3330, 'ITEM #3330__ITEM #3330', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3331, 'ITEM #3331__ITEM #3331', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3332, 'ITEM #3332__ITEM #3332', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3333, 'ITEM #3333__ITEM #3333', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3334, 'ITEM #3334__ITEM #3334', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3335, 'ITEM #3335__ITEM #3335', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3336, 'ITEM #3336__ITEM #3336', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3337, 'ITEM #3337__ITEM #3337', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3338, 'ITEM #3338__ITEM #3338', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3339, 'ITEM #3339__ITEM #3339', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3340, 'ITEM #3340__ITEM #3340', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3341, 'ITEM #3341__ITEM #3341', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3342, 'ITEM #3342__ITEM #3342', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3343, 'ITEM #3343__ITEM #3343', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3344, 'ITEM #3344__ITEM #3344', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3345, 'ITEM #3345__ITEM #3345', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3346, 'ITEM #3346__ITEM #3346', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3347, 'ITEM #3347__ITEM #3347', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3348, 'ITEM #3348__ITEM #3348', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3349, 'ITEM #3349__ITEM #3349', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3350, 'ITEM #3350__ITEM #3350', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3351, 'ITEM #3351__ITEM #3351', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3352, 'ITEM #3352__ITEM #3352', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3353, 'ITEM #3353__ITEM #3353', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3354, 'ITEM #3354__ITEM #3354', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3355, 'ITEM #3355__ITEM #3355', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3356, 'ITEM #3356__ITEM #3356', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3357, 'ITEM #3357__ITEM #3357', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3358, 'ITEM #3358__ITEM #3358', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3359, 'ITEM #3359__ITEM #3359', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3360, 'ITEM #3360__ITEM #3360', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3361, 'ITEM #3361__ITEM #3361', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3362, 'ITEM #3362__ITEM #3362', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3363, 'ITEM #3363__ITEM #3363', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3364, 'ITEM #3364__ITEM #3364', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3365, 'ITEM #3365__ITEM #3365', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3366, 'ITEM #3366__ITEM #3366', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3367, 'ITEM #3367__ITEM #3367', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3368, 'ITEM #3368__ITEM #3368', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3369, 'ITEM #3369__ITEM #3369', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3370, 'ITEM #3370__ITEM #3370', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3371, 'ITEM #3371__ITEM #3371', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3372, 'ITEM #3372__ITEM #3372', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3373, 'ITEM #3373__ITEM #3373', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3374, 'ITEM #3374__ITEM #3374', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3375, 'ITEM #3375__ITEM #3375', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3376, 'ITEM #3376__ITEM #3376', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3377, 'ITEM #3377__ITEM #3377', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3378, 'ITEM #3378__ITEM #3378', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3379, 'ITEM #3379__ITEM #3379', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3380, 'ITEM #3380__ITEM #3380', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3381, 'ITEM #3381__ITEM #3381', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3382, 'ITEM #3382__ITEM #3382', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3383, 'ITEM #3383__ITEM #3383', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3384, 'ITEM #3384__ITEM #3384', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3385, 'ITEM #3385__ITEM #3385', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3386, 'ITEM #3386__ITEM #3386', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3387, 'ITEM #3387__ITEM #3387', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3388, 'ITEM #3388__ITEM #3388', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3389, 'ITEM #3389__ITEM #3389', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3390, 'ITEM #3390__ITEM #3390', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3391, 'ITEM #3391__ITEM #3391', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3392, 'ITEM #3392__ITEM #3392', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3393, 'ITEM #3393__ITEM #3393', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3394, 'ITEM #3394__ITEM #3394', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3395, 'ITEM #3395__ITEM #3395', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3396, 'ITEM #3396__ITEM #3396', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3397, 'ITEM #3397__ITEM #3397', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3398, 'ITEM #3398__ITEM #3398', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3399, 'ITEM #3399__ITEM #3399', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3400, 'ITEM #3400__ITEM #3400', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3401, 'ITEM #3401__ITEM #3401', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3402, 'ITEM #3402__ITEM #3402', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3403, 'ITEM #3403__ITEM #3403', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3404, 'ITEM #3404__ITEM #3404', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3405, 'ITEM #3405__ITEM #3405', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3406, 'ITEM #3406__ITEM #3406', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3407, 'ITEM #3407__ITEM #3407', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3408, 'ITEM #3408__ITEM #3408', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3409, 'ITEM #3409__ITEM #3409', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3410, 'ITEM #3410__ITEM #3410', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3411, 'ITEM #3411__ITEM #3411', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3412, 'ITEM #3412__ITEM #3412', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3413, 'ITEM #3413__ITEM #3413', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3414, 'ITEM #3414__ITEM #3414', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3415, 'ITEM #3415__ITEM #3415', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3416, 'ITEM #3416__ITEM #3416', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3417, 'ITEM #3417__ITEM #3417', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3418, 'ITEM #3418__ITEM #3418', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3419, 'ITEM #3419__ITEM #3419', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3420, 'ITEM #3420__ITEM #3420', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3421, 'ITEM #3421__ITEM #3421', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3422, 'ITEM #3422__ITEM #3422', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3423, 'ITEM #3423__ITEM #3423', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3424, 'ITEM #3424__ITEM #3424', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3425, 'ITEM #3425__ITEM #3425', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3426, 'ITEM #3426__ITEM #3426', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3427, 'ITEM #3427__ITEM #3427', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3428, 'ITEM #3428__ITEM #3428', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3429, 'ITEM #3429__ITEM #3429', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3430, 'ITEM #3430__ITEM #3430', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3431, 'ITEM #3431__ITEM #3431', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3432, 'ITEM #3432__ITEM #3432', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3433, 'ITEM #3433__ITEM #3433', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3434, 'ITEM #3434__ITEM #3434', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3435, 'ITEM #3435__ITEM #3435', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3436, 'ITEM #3436__ITEM #3436', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3437, 'ITEM #3437__ITEM #3437', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3438, 'ITEM #3438__ITEM #3438', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3439, 'ITEM #3439__ITEM #3439', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3440, 'ITEM #3440__ITEM #3440', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3441, 'ITEM #3441__ITEM #3441', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3442, 'ITEM #3442__ITEM #3442', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3443, 'ITEM #3443__ITEM #3443', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3444, 'ITEM #3444__ITEM #3444', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3445, 'ITEM #3445__ITEM #3445', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3446, 'ITEM #3446__ITEM #3446', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3447, 'ITEM #3447__ITEM #3447', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3448, 'ITEM #3448__ITEM #3448', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3449, 'ITEM #3449__ITEM #3449', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3450, 'ITEM #3450__ITEM #3450', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3451, 'ITEM #3451__ITEM #3451', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3452, 'ITEM #3452__ITEM #3452', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3453, 'ITEM #3453__ITEM #3453', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3454, 'ITEM #3454__ITEM #3454', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3455, 'ITEM #3455__ITEM #3455', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3456, 'ITEM #3456__ITEM #3456', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3457, 'ITEM #3457__ITEM #3457', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3458, 'ITEM #3458__ITEM #3458', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3459, 'ITEM #3459__ITEM #3459', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3460, 'ITEM #3460__ITEM #3460', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3461, 'ITEM #3461__ITEM #3461', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3462, 'ITEM #3462__ITEM #3462', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3463, 'ITEM #3463__ITEM #3463', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3464, 'ITEM #3464__ITEM #3464', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3465, 'ITEM #3465__ITEM #3465', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3466, 'ITEM #3466__ITEM #3466', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3467, 'ITEM #3467__ITEM #3467', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3468, 'ITEM #3468__ITEM #3468', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3469, 'ITEM #3469__ITEM #3469', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3470, 'ITEM #3470__ITEM #3470', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3471, 'ITEM #3471__ITEM #3471', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3472, 'ITEM #3472__ITEM #3472', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3473, 'ITEM #3473__ITEM #3473', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3474, 'ITEM #3474__ITEM #3474', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3475, 'ITEM #3475__ITEM #3475', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3476, 'ITEM #3476__ITEM #3476', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3477, 'ITEM #3477__ITEM #3477', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3478, 'ITEM #3478__ITEM #3478', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3479, 'ITEM #3479__ITEM #3479', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3480, 'ITEM #3480__ITEM #3480', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3481, 'ITEM #3481__ITEM #3481', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3482, 'ITEM #3482__ITEM #3482', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3483, 'ITEM #3483__ITEM #3483', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3484, 'ITEM #3484__ITEM #3484', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3485, 'ITEM #3485__ITEM #3485', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3486, 'ITEM #3486__ITEM #3486', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3487, 'ITEM #3487__ITEM #3487', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3488, 'ITEM #3488__ITEM #3488', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3489, 'ITEM #3489__ITEM #3489', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3490, 'ITEM #3490__ITEM #3490', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3491, 'ITEM #3491__ITEM #3491', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3492, 'ITEM #3492__ITEM #3492', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3493, 'ITEM #3493__ITEM #3493', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3494, 'ITEM #3494__ITEM #3494', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3495, 'ITEM #3495__ITEM #3495', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3496, 'ITEM #3496__ITEM #3496', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3497, 'ITEM #3497__ITEM #3497', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3498, 'ITEM #3498__ITEM #3498', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3499, 'ITEM #3499__ITEM #3499', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3500, 'ITEM #3500__ITEM #3500', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3501, 'ITEM #3501__ITEM #3501', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3502, 'ITEM #3502__ITEM #3502', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3503, 'ITEM #3503__ITEM #3503', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3504, 'ITEM #3504__ITEM #3504', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3505, 'ITEM #3505__ITEM #3505', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3506, 'ITEM #3506__ITEM #3506', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3507, 'ITEM #3507__ITEM #3507', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3508, 'ITEM #3508__ITEM #3508', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3509, 'ITEM #3509__ITEM #3509', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3510, 'ITEM #3510__ITEM #3510', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3511, 'ITEM #3511__ITEM #3511', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3512, 'ITEM #3512__ITEM #3512', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3513, 'ITEM #3513__ITEM #3513', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3514, 'ITEM #3514__ITEM #3514', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3515, 'ITEM #3515__ITEM #3515', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3516, 'ITEM #3516__ITEM #3516', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3517, 'ITEM #3517__ITEM #3517', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3518, 'ITEM #3518__ITEM #3518', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3519, 'ITEM #3519__ITEM #3519', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3520, 'ITEM #3520__ITEM #3520', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3521, 'ITEM #3521__ITEM #3521', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3522, 'ITEM #3522__ITEM #3522', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3523, 'ITEM #3523__ITEM #3523', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3524, 'ITEM #3524__ITEM #3524', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3525, 'ITEM #3525__ITEM #3525', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3526, 'ITEM #3526__ITEM #3526', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3527, 'ITEM #3527__ITEM #3527', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3528, 'ITEM #3528__ITEM #3528', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3529, 'ITEM #3529__ITEM #3529', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3530, 'ITEM #3530__ITEM #3530', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3531, 'ITEM #3531__ITEM #3531', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3532, 'ITEM #3532__ITEM #3532', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3533, 'ITEM #3533__ITEM #3533', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3534, 'ITEM #3534__ITEM #3534', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3535, 'ITEM #3535__ITEM #3535', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3536, 'ITEM #3536__ITEM #3536', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3537, 'ITEM #3537__ITEM #3537', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3538, 'ITEM #3538__ITEM #3538', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3539, 'ITEM #3539__ITEM #3539', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3540, 'ITEM #3540__ITEM #3540', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3541, 'ITEM #3541__ITEM #3541', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3542, 'ITEM #3542__ITEM #3542', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3543, 'ITEM #3543__ITEM #3543', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3544, 'ITEM #3544__ITEM #3544', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3545, 'ITEM #3545__ITEM #3545', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3546, 'ITEM #3546__ITEM #3546', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3547, 'ITEM #3547__ITEM #3547', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3548, 'ITEM #3548__ITEM #3548', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3549, 'ITEM #3549__ITEM #3549', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3550, 'ITEM #3550__ITEM #3550', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3551, 'ITEM #3551__ITEM #3551', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3552, 'ITEM #3552__ITEM #3552', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3553, 'ITEM #3553__ITEM #3553', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3554, 'ITEM #3554__ITEM #3554', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3555, 'ITEM #3555__ITEM #3555', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3556, 'ITEM #3556__ITEM #3556', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3557, 'ITEM #3557__ITEM #3557', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3558, 'ITEM #3558__ITEM #3558', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3559, 'ITEM #3559__ITEM #3559', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3560, 'ITEM #3560__ITEM #3560', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3561, 'ITEM #3561__ITEM #3561', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3562, 'ITEM #3562__ITEM #3562', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3563, 'ITEM #3563__ITEM #3563', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3564, 'ITEM #3564__ITEM #3564', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3565, 'ITEM #3565__ITEM #3565', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3566, 'ITEM #3566__ITEM #3566', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3567, 'ITEM #3567__ITEM #3567', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3568, 'ITEM #3568__ITEM #3568', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3569, 'ITEM #3569__ITEM #3569', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3570, 'ITEM #3570__ITEM #3570', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3571, 'ITEM #3571__ITEM #3571', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3572, 'ITEM #3572__ITEM #3572', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3573, 'ITEM #3573__ITEM #3573', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3574, 'ITEM #3574__ITEM #3574', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3575, 'ITEM #3575__ITEM #3575', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3576, 'ITEM #3576__ITEM #3576', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3577, 'ITEM #3577__ITEM #3577', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3578, 'ITEM #3578__ITEM #3578', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3579, 'ITEM #3579__ITEM #3579', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3580, 'ITEM #3580__ITEM #3580', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3581, 'ITEM #3581__ITEM #3581', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3582, 'ITEM #3582__ITEM #3582', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3583, 'ITEM #3583__ITEM #3583', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3584, 'ITEM #3584__ITEM #3584', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3585, 'ITEM #3585__ITEM #3585', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3586, 'ITEM #3586__ITEM #3586', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3587, 'ITEM #3587__ITEM #3587', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3588, 'ITEM #3588__ITEM #3588', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3589, 'ITEM #3589__ITEM #3589', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3590, 'ITEM #3590__ITEM #3590', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3591, 'ITEM #3591__ITEM #3591', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3592, 'ITEM #3592__ITEM #3592', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3593, 'ITEM #3593__ITEM #3593', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3594, 'ITEM #3594__ITEM #3594', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3595, 'ITEM #3595__ITEM #3595', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3596, 'ITEM #3596__ITEM #3596', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3597, 'ITEM #3597__ITEM #3597', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3598, 'ITEM #3598__ITEM #3598', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3599, 'ITEM #3599__ITEM #3599', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3600, 'ITEM #3600__ITEM #3600', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3601, 'ITEM #3601__ITEM #3601', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3602, 'ITEM #3602__ITEM #3602', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3603, 'ITEM #3603__ITEM #3603', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3604, 'ITEM #3604__ITEM #3604', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3605, 'ITEM #3605__ITEM #3605', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3606, 'ITEM #3606__ITEM #3606', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3607, 'ITEM #3607__ITEM #3607', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3608, 'ITEM #3608__ITEM #3608', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3609, 'ITEM #3609__ITEM #3609', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3610, 'ITEM #3610__ITEM #3610', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3611, 'ITEM #3611__ITEM #3611', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3612, 'ITEM #3612__ITEM #3612', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3613, 'ITEM #3613__ITEM #3613', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3614, 'ITEM #3614__ITEM #3614', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3615, 'ITEM #3615__ITEM #3615', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3616, 'ITEM #3616__ITEM #3616', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3617, 'ITEM #3617__ITEM #3617', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3618, 'ITEM #3618__ITEM #3618', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3619, 'ITEM #3619__ITEM #3619', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3620, 'ITEM #3620__ITEM #3620', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3621, 'ITEM #3621__ITEM #3621', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3622, 'ITEM #3622__ITEM #3622', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3623, 'ITEM #3623__ITEM #3623', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3624, 'ITEM #3624__ITEM #3624', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3625, 'ITEM #3625__ITEM #3625', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3626, 'ITEM #3626__ITEM #3626', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3627, 'ITEM #3627__ITEM #3627', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3628, 'ITEM #3628__ITEM #3628', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3629, 'ITEM #3629__ITEM #3629', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3630, 'ITEM #3630__ITEM #3630', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3631, 'ITEM #3631__ITEM #3631', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3632, 'ITEM #3632__ITEM #3632', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3633, 'ITEM #3633__ITEM #3633', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3634, 'ITEM #3634__ITEM #3634', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3635, 'ITEM #3635__ITEM #3635', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3636, 'ITEM #3636__ITEM #3636', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3637, 'ITEM #3637__ITEM #3637', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3638, 'ITEM #3638__ITEM #3638', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3639, 'ITEM #3639__ITEM #3639', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3640, 'ITEM #3640__ITEM #3640', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3641, 'ITEM #3641__ITEM #3641', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3642, 'ITEM #3642__ITEM #3642', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3643, 'ITEM #3643__ITEM #3643', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3644, 'ITEM #3644__ITEM #3644', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3645, 'ITEM #3645__ITEM #3645', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3646, 'ITEM #3646__ITEM #3646', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3647, 'ITEM #3647__ITEM #3647', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3648, 'ITEM #3648__ITEM #3648', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3649, 'ITEM #3649__ITEM #3649', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3650, 'ITEM #3650__ITEM #3650', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3651, 'ITEM #3651__ITEM #3651', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3652, 'ITEM #3652__ITEM #3652', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3653, 'ITEM #3653__ITEM #3653', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3654, 'ITEM #3654__ITEM #3654', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3655, 'ITEM #3655__ITEM #3655', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3656, 'ITEM #3656__ITEM #3656', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3657, 'ITEM #3657__ITEM #3657', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3658, 'ITEM #3658__ITEM #3658', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3659, 'ITEM #3659__ITEM #3659', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3660, 'ITEM #3660__ITEM #3660', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3661, 'ITEM #3661__ITEM #3661', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3662, 'ITEM #3662__ITEM #3662', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3663, 'ITEM #3663__ITEM #3663', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3664, 'ITEM #3664__ITEM #3664', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3665, 'ITEM #3665__ITEM #3665', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3666, 'ITEM #3666__ITEM #3666', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3667, 'ITEM #3667__ITEM #3667', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3668, 'ITEM #3668__ITEM #3668', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3669, 'ITEM #3669__ITEM #3669', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3670, 'ITEM #3670__ITEM #3670', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3671, 'ITEM #3671__ITEM #3671', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3672, 'ITEM #3672__ITEM #3672', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3673, 'ITEM #3673__ITEM #3673', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3674, 'ITEM #3674__ITEM #3674', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3675, 'ITEM #3675__ITEM #3675', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3676, 'ITEM #3676__ITEM #3676', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3677, 'ITEM #3677__ITEM #3677', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3678, 'ITEM #3678__ITEM #3678', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3679, 'ITEM #3679__ITEM #3679', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3680, 'ITEM #3680__ITEM #3680', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3681, 'ITEM #3681__ITEM #3681', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3682, 'ITEM #3682__ITEM #3682', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3683, 'ITEM #3683__ITEM #3683', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3684, 'ITEM #3684__ITEM #3684', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3685, 'ITEM #3685__ITEM #3685', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3686, 'ITEM #3686__ITEM #3686', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3687, 'ITEM #3687__ITEM #3687', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3688, 'ITEM #3688__ITEM #3688', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3689, 'ITEM #3689__ITEM #3689', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3690, 'ITEM #3690__ITEM #3690', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3691, 'ITEM #3691__ITEM #3691', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3692, 'ITEM #3692__ITEM #3692', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3693, 'ITEM #3693__ITEM #3693', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3694, 'ITEM #3694__ITEM #3694', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3695, 'ITEM #3695__ITEM #3695', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3696, 'ITEM #3696__ITEM #3696', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3697, 'ITEM #3697__ITEM #3697', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3698, 'ITEM #3698__ITEM #3698', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3699, 'ITEM #3699__ITEM #3699', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3700, 'ITEM #3700__ITEM #3700', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3701, 'ITEM #3701__ITEM #3701', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3702, 'ITEM #3702__ITEM #3702', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3703, 'ITEM #3703__ITEM #3703', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3704, 'ITEM #3704__ITEM #3704', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3705, 'ITEM #3705__ITEM #3705', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3706, 'ITEM #3706__ITEM #3706', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3707, 'ITEM #3707__ITEM #3707', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3708, 'ITEM #3708__ITEM #3708', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3709, 'ITEM #3709__ITEM #3709', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3710, 'ITEM #3710__ITEM #3710', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3711, 'ITEM #3711__ITEM #3711', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3712, 'ITEM #3712__ITEM #3712', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3713, 'ITEM #3713__ITEM #3713', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3714, 'ITEM #3714__ITEM #3714', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3715, 'ITEM #3715__ITEM #3715', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3716, 'ITEM #3716__ITEM #3716', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3717, 'ITEM #3717__ITEM #3717', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3718, 'ITEM #3718__ITEM #3718', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3719, 'ITEM #3719__ITEM #3719', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3720, 'ITEM #3720__ITEM #3720', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3721, 'ITEM #3721__ITEM #3721', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3722, 'ITEM #3722__ITEM #3722', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3723, 'ITEM #3723__ITEM #3723', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3724, 'ITEM #3724__ITEM #3724', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3725, 'ITEM #3725__ITEM #3725', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3726, 'ITEM #3726__ITEM #3726', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3727, 'ITEM #3727__ITEM #3727', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3728, 'ITEM #3728__ITEM #3728', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3729, 'ITEM #3729__ITEM #3729', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3730, 'ITEM #3730__ITEM #3730', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3731, 'ITEM #3731__ITEM #3731', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3732, 'ITEM #3732__ITEM #3732', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3733, 'ITEM #3733__ITEM #3733', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3734, 'ITEM #3734__ITEM #3734', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3735, 'ITEM #3735__ITEM #3735', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3736, 'ITEM #3736__ITEM #3736', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3737, 'ITEM #3737__ITEM #3737', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3738, 'ITEM #3738__ITEM #3738', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3739, 'ITEM #3739__ITEM #3739', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3740, 'ITEM #3740__ITEM #3740', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3741, 'ITEM #3741__ITEM #3741', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3742, 'ITEM #3742__ITEM #3742', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3743, 'ITEM #3743__ITEM #3743', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3744, 'ITEM #3744__ITEM #3744', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3745, 'ITEM #3745__ITEM #3745', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3746, 'ITEM #3746__ITEM #3746', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3747, 'ITEM #3747__ITEM #3747', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3748, 'ITEM #3748__ITEM #3748', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3749, 'ITEM #3749__ITEM #3749', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3750, 'ITEM #3750__ITEM #3750', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3751, 'ITEM #3751__ITEM #3751', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3752, 'ITEM #3752__ITEM #3752', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3753, 'ITEM #3753__ITEM #3753', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3754, 'ITEM #3754__ITEM #3754', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3755, 'ITEM #3755__ITEM #3755', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3756, 'ITEM #3756__ITEM #3756', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3757, 'ITEM #3757__ITEM #3757', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3758, 'ITEM #3758__ITEM #3758', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3759, 'ITEM #3759__ITEM #3759', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3760, 'ITEM #3760__ITEM #3760', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3761, 'ITEM #3761__ITEM #3761', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3762, 'ITEM #3762__ITEM #3762', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3763, 'ITEM #3763__ITEM #3763', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3764, 'ITEM #3764__ITEM #3764', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3765, 'ITEM #3765__ITEM #3765', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3766, 'ITEM #3766__ITEM #3766', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3767, 'ITEM #3767__ITEM #3767', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3768, 'ITEM #3768__ITEM #3768', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3769, 'ITEM #3769__ITEM #3769', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3770, 'ITEM #3770__ITEM #3770', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3771, 'ITEM #3771__ITEM #3771', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3772, 'ITEM #3772__ITEM #3772', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3773, 'ITEM #3773__ITEM #3773', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3774, 'ITEM #3774__ITEM #3774', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3775, 'ITEM #3775__ITEM #3775', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3776, 'ITEM #3776__ITEM #3776', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3777, 'ITEM #3777__ITEM #3777', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3778, 'ITEM #3778__ITEM #3778', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3779, 'ITEM #3779__ITEM #3779', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3780, 'ITEM #3780__ITEM #3780', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3781, 'ITEM #3781__ITEM #3781', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3782, 'ITEM #3782__ITEM #3782', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3783, 'ITEM #3783__ITEM #3783', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3784, 'ITEM #3784__ITEM #3784', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3785, 'ITEM #3785__ITEM #3785', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3786, 'ITEM #3786__ITEM #3786', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3787, 'ITEM #3787__ITEM #3787', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3788, 'ITEM #3788__ITEM #3788', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3789, 'ITEM #3789__ITEM #3789', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3790, 'ITEM #3790__ITEM #3790', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3791, 'ITEM #3791__ITEM #3791', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3792, 'ITEM #3792__ITEM #3792', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3793, 'ITEM #3793__ITEM #3793', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3794, 'ITEM #3794__ITEM #3794', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3795, 'ITEM #3795__ITEM #3795', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3796, 'ITEM #3796__ITEM #3796', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3797, 'ITEM #3797__ITEM #3797', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3798, 'ITEM #3798__ITEM #3798', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3799, 'ITEM #3799__ITEM #3799', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3800, 'ITEM #3800__ITEM #3800', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3801, 'ITEM #3801__ITEM #3801', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3802, 'ITEM #3802__ITEM #3802', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3803, 'ITEM #3803__ITEM #3803', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3804, 'ITEM #3804__ITEM #3804', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3805, 'ITEM #3805__ITEM #3805', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3806, 'ITEM #3806__ITEM #3806', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3807, 'ITEM #3807__ITEM #3807', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3808, 'ITEM #3808__ITEM #3808', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3809, 'ITEM #3809__ITEM #3809', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3810, 'ITEM #3810__ITEM #3810', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3811, 'ITEM #3811__ITEM #3811', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3812, 'ITEM #3812__ITEM #3812', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3813, 'ITEM #3813__ITEM #3813', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3814, 'ITEM #3814__ITEM #3814', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3815, 'ITEM #3815__ITEM #3815', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3816, 'ITEM #3816__ITEM #3816', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3817, 'ITEM #3817__ITEM #3817', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3818, 'ITEM #3818__ITEM #3818', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3819, 'ITEM #3819__ITEM #3819', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3820, 'ITEM #3820__ITEM #3820', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3821, 'ITEM #3821__ITEM #3821', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3822, 'ITEM #3822__ITEM #3822', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3823, 'ITEM #3823__ITEM #3823', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3824, 'ITEM #3824__ITEM #3824', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3825, 'ITEM #3825__ITEM #3825', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3826, 'ITEM #3826__ITEM #3826', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3827, 'ITEM #3827__ITEM #3827', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3828, 'ITEM #3828__ITEM #3828', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3829, 'ITEM #3829__ITEM #3829', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3830, 'ITEM #3830__ITEM #3830', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3831, 'ITEM #3831__ITEM #3831', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3832, 'ITEM #3832__ITEM #3832', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3833, 'ITEM #3833__ITEM #3833', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3834, 'ITEM #3834__ITEM #3834', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3835, 'ITEM #3835__ITEM #3835', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3836, 'ITEM #3836__ITEM #3836', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3837, 'ITEM #3837__ITEM #3837', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3838, 'ITEM #3838__ITEM #3838', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3839, 'ITEM #3839__ITEM #3839', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3840, 'ITEM #3840__ITEM #3840', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3841, 'ITEM #3841__ITEM #3841', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3842, 'ITEM #3842__ITEM #3842', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3843, 'ITEM #3843__ITEM #3843', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3844, 'ITEM #3844__ITEM #3844', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3845, 'ITEM #3845__ITEM #3845', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3846, 'ITEM #3846__ITEM #3846', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3847, 'ITEM #3847__ITEM #3847', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3848, 'ITEM #3848__ITEM #3848', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3849, 'ITEM #3849__ITEM #3849', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3850, 'ITEM #3850__ITEM #3850', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3851, 'ITEM #3851__ITEM #3851', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3852, 'ITEM #3852__ITEM #3852', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3853, 'ITEM #3853__ITEM #3853', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3854, 'ITEM #3854__ITEM #3854', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3855, 'ITEM #3855__ITEM #3855', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3856, 'ITEM #3856__ITEM #3856', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3857, 'ITEM #3857__ITEM #3857', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3858, 'ITEM #3858__ITEM #3858', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3859, 'ITEM #3859__ITEM #3859', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3860, 'ITEM #3860__ITEM #3860', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3861, 'ITEM #3861__ITEM #3861', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3862, 'ITEM #3862__ITEM #3862', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3863, 'ITEM #3863__ITEM #3863', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3864, 'ITEM #3864__ITEM #3864', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3865, 'ITEM #3865__ITEM #3865', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3866, 'ITEM #3866__ITEM #3866', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3867, 'ITEM #3867__ITEM #3867', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3868, 'ITEM #3868__ITEM #3868', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3869, 'ITEM #3869__ITEM #3869', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3870, 'ITEM #3870__ITEM #3870', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3871, 'ITEM #3871__ITEM #3871', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3872, 'ITEM #3872__ITEM #3872', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3873, 'ITEM #3873__ITEM #3873', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3874, 'ITEM #3874__ITEM #3874', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3875, 'ITEM #3875__ITEM #3875', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3876, 'ITEM #3876__ITEM #3876', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3877, 'ITEM #3877__ITEM #3877', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3878, 'ITEM #3878__ITEM #3878', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3879, 'ITEM #3879__ITEM #3879', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3880, 'ITEM #3880__ITEM #3880', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3881, 'ITEM #3881__ITEM #3881', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3882, 'ITEM #3882__ITEM #3882', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3883, 'ITEM #3883__ITEM #3883', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3884, 'ITEM #3884__ITEM #3884', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3885, 'ITEM #3885__ITEM #3885', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3886, 'ITEM #3886__ITEM #3886', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3887, 'ITEM #3887__ITEM #3887', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3888, 'ITEM #3888__ITEM #3888', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3889, 'ITEM #3889__ITEM #3889', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3890, 'ITEM #3890__ITEM #3890', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3891, 'ITEM #3891__ITEM #3891', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3892, 'ITEM #3892__ITEM #3892', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3893, 'ITEM #3893__ITEM #3893', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3894, 'ITEM #3894__ITEM #3894', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3895, 'ITEM #3895__ITEM #3895', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3896, 'ITEM #3896__ITEM #3896', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3897, 'ITEM #3897__ITEM #3897', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3898, 'ITEM #3898__ITEM #3898', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3899, 'ITEM #3899__ITEM #3899', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3900, 'ITEM #3900__ITEM #3900', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3901, 'ITEM #3901__ITEM #3901', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3902, 'ITEM #3902__ITEM #3902', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3903, 'ITEM #3903__ITEM #3903', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3904, 'ITEM #3904__ITEM #3904', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3905, 'ITEM #3905__ITEM #3905', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3906, 'ITEM #3906__ITEM #3906', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3907, 'ITEM #3907__ITEM #3907', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3908, 'ITEM #3908__ITEM #3908', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3909, 'ITEM #3909__ITEM #3909', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3910, 'ITEM #3910__ITEM #3910', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3911, 'ITEM #3911__ITEM #3911', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3912, 'ITEM #3912__ITEM #3912', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3913, 'ITEM #3913__ITEM #3913', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3914, 'ITEM #3914__ITEM #3914', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3915, 'ITEM #3915__ITEM #3915', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3916, 'ITEM #3916__ITEM #3916', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3917, 'ITEM #3917__ITEM #3917', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3918, 'ITEM #3918__ITEM #3918', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3919, 'ITEM #3919__ITEM #3919', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3920, 'ITEM #3920__ITEM #3920', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3921, 'ITEM #3921__ITEM #3921', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3922, 'ITEM #3922__ITEM #3922', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3923, 'ITEM #3923__ITEM #3923', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3924, 'ITEM #3924__ITEM #3924', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3925, 'ITEM #3925__ITEM #3925', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3926, 'ITEM #3926__ITEM #3926', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3927, 'ITEM #3927__ITEM #3927', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3928, 'ITEM #3928__ITEM #3928', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3929, 'ITEM #3929__ITEM #3929', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3930, 'ITEM #3930__ITEM #3930', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3931, 'ITEM #3931__ITEM #3931', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3932, 'ITEM #3932__ITEM #3932', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3933, 'ITEM #3933__ITEM #3933', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3934, 'ITEM #3934__ITEM #3934', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3935, 'ITEM #3935__ITEM #3935', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3936, 'ITEM #3936__ITEM #3936', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3937, 'ITEM #3937__ITEM #3937', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3938, 'ITEM #3938__ITEM #3938', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3939, 'ITEM #3939__ITEM #3939', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3940, 'ITEM #3940__ITEM #3940', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3941, 'ITEM #3941__ITEM #3941', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3942, 'ITEM #3942__ITEM #3942', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3943, 'ITEM #3943__ITEM #3943', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3944, 'ITEM #3944__ITEM #3944', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3945, 'ITEM #3945__ITEM #3945', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3946, 'ITEM #3946__ITEM #3946', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3947, 'ITEM #3947__ITEM #3947', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3948, 'ITEM #3948__ITEM #3948', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3949, 'ITEM #3949__ITEM #3949', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3950, 'ITEM #3950__ITEM #3950', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3951, 'ITEM #3951__ITEM #3951', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3952, 'ITEM #3952__ITEM #3952', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3953, 'ITEM #3953__ITEM #3953', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3954, 'ITEM #3954__ITEM #3954', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3955, 'ITEM #3955__ITEM #3955', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3956, 'ITEM #3956__ITEM #3956', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3957, 'ITEM #3957__ITEM #3957', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3958, 'ITEM #3958__ITEM #3958', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3959, 'ITEM #3959__ITEM #3959', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3960, 'ITEM #3960__ITEM #3960', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3961, 'ITEM #3961__ITEM #3961', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3962, 'ITEM #3962__ITEM #3962', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3963, 'ITEM #3963__ITEM #3963', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3964, 'ITEM #3964__ITEM #3964', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3965, 'ITEM #3965__ITEM #3965', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3966, 'ITEM #3966__ITEM #3966', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3967, 'ITEM #3967__ITEM #3967', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3968, 'ITEM #3968__ITEM #3968', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3969, 'ITEM #3969__ITEM #3969', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3970, 'ITEM #3970__ITEM #3970', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3971, 'ITEM #3971__ITEM #3971', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3972, 'ITEM #3972__ITEM #3972', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3973, 'ITEM #3973__ITEM #3973', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3974, 'ITEM #3974__ITEM #3974', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3975, 'ITEM #3975__ITEM #3975', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3976, 'ITEM #3976__ITEM #3976', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3977, 'ITEM #3977__ITEM #3977', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3978, 'ITEM #3978__ITEM #3978', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3979, 'ITEM #3979__ITEM #3979', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3980, 'ITEM #3980__ITEM #3980', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3981, 'ITEM #3981__ITEM #3981', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3982, 'ITEM #3982__ITEM #3982', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3983, 'ITEM #3983__ITEM #3983', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3984, 'ITEM #3984__ITEM #3984', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3985, 'ITEM #3985__ITEM #3985', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3986, 'ITEM #3986__ITEM #3986', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3987, 'ITEM #3987__ITEM #3987', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3988, 'ITEM #3988__ITEM #3988', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3989, 'ITEM #3989__ITEM #3989', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3990, 'ITEM #3990__ITEM #3990', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3991, 'ITEM #3991__ITEM #3991', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3992, 'ITEM #3992__ITEM #3992', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3993, 'ITEM #3993__ITEM #3993', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3994, 'ITEM #3994__ITEM #3994', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3995, 'ITEM #3995__ITEM #3995', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3996, 'ITEM #3996__ITEM #3996', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3997, 'ITEM #3997__ITEM #3997', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3998, 'ITEM #3998__ITEM #3998', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (3999, 'ITEM #3999__ITEM #3999', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4000, 'ITEM #4000__ITEM #4000', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4001, 'ITEM #4001__ITEM #4001', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4002, 'ITEM #4002__ITEM #4002', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4003, 'ITEM #4003__ITEM #4003', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4004, 'ITEM #4004__ITEM #4004', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4005, 'ITEM #4005__ITEM #4005', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4006, 'ITEM #4006__ITEM #4006', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4007, 'ITEM #4007__ITEM #4007', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4008, 'ITEM #4008__ITEM #4008', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4009, 'ITEM #4009__ITEM #4009', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4010, 'ITEM #4010__ITEM #4010', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4011, 'ITEM #4011__ITEM #4011', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4012, 'ITEM #4012__ITEM #4012', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4013, 'ITEM #4013__ITEM #4013', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4014, 'ITEM #4014__ITEM #4014', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4015, 'ITEM #4015__ITEM #4015', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4016, 'ITEM #4016__ITEM #4016', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4017, 'ITEM #4017__ITEM #4017', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4018, 'ITEM #4018__ITEM #4018', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4019, 'ITEM #4019__ITEM #4019', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4020, 'ITEM #4020__ITEM #4020', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4021, 'ITEM #4021__ITEM #4021', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4022, 'ITEM #4022__ITEM #4022', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4023, 'ITEM #4023__ITEM #4023', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4024, 'ITEM #4024__ITEM #4024', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4025, 'ITEM #4025__ITEM #4025', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4026, 'ITEM #4026__ITEM #4026', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4027, 'ITEM #4027__ITEM #4027', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4028, 'ITEM #4028__ITEM #4028', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4029, 'ITEM #4029__ITEM #4029', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4030, 'ITEM #4030__ITEM #4030', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4031, 'ITEM #4031__ITEM #4031', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4032, 'ITEM #4032__ITEM #4032', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4033, 'ITEM #4033__ITEM #4033', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4034, 'ITEM #4034__ITEM #4034', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4035, 'ITEM #4035__ITEM #4035', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4036, 'ITEM #4036__ITEM #4036', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4037, 'ITEM #4037__ITEM #4037', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4038, 'ITEM #4038__ITEM #4038', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4039, 'ITEM #4039__ITEM #4039', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4040, 'ITEM #4040__ITEM #4040', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4041, 'ITEM #4041__ITEM #4041', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4042, 'ITEM #4042__ITEM #4042', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4043, 'ITEM #4043__ITEM #4043', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4044, 'ITEM #4044__ITEM #4044', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4045, 'ITEM #4045__ITEM #4045', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4046, 'ITEM #4046__ITEM #4046', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4047, 'ITEM #4047__ITEM #4047', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4048, 'ITEM #4048__ITEM #4048', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4049, 'ITEM #4049__ITEM #4049', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4050, 'ITEM #4050__ITEM #4050', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4051, 'ITEM #4051__ITEM #4051', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4052, 'ITEM #4052__ITEM #4052', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4053, 'ITEM #4053__ITEM #4053', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4054, 'ITEM #4054__ITEM #4054', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4055, 'ITEM #4055__ITEM #4055', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4056, 'ITEM #4056__ITEM #4056', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4057, 'ITEM #4057__ITEM #4057', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4058, 'ITEM #4058__ITEM #4058', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4059, 'ITEM #4059__ITEM #4059', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4060, 'ITEM #4060__ITEM #4060', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4061, 'ITEM #4061__ITEM #4061', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4062, 'ITEM #4062__ITEM #4062', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4063, 'ITEM #4063__ITEM #4063', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4064, 'ITEM #4064__ITEM #4064', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4065, 'ITEM #4065__ITEM #4065', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4066, 'ITEM #4066__ITEM #4066', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4067, 'ITEM #4067__ITEM #4067', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4068, 'ITEM #4068__ITEM #4068', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4069, 'ITEM #4069__ITEM #4069', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4070, 'ITEM #4070__ITEM #4070', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4071, 'ITEM #4071__ITEM #4071', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4072, 'ITEM #4072__ITEM #4072', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4073, 'ITEM #4073__ITEM #4073', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4074, 'ITEM #4074__ITEM #4074', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4075, 'ITEM #4075__ITEM #4075', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4076, 'ITEM #4076__ITEM #4076', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4077, 'ITEM #4077__ITEM #4077', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4078, 'ITEM #4078__ITEM #4078', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4079, 'ITEM #4079__ITEM #4079', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4080, 'ITEM #4080__ITEM #4080', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4081, 'ITEM #4081__ITEM #4081', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4082, 'ITEM #4082__ITEM #4082', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4083, 'ITEM #4083__ITEM #4083', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4084, 'ITEM #4084__ITEM #4084', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4085, 'ITEM #4085__ITEM #4085', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4086, 'ITEM #4086__ITEM #4086', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4087, 'ITEM #4087__ITEM #4087', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4088, 'ITEM #4088__ITEM #4088', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4089, 'ITEM #4089__ITEM #4089', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4090, 'ITEM #4090__ITEM #4090', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4091, 'ITEM #4091__ITEM #4091', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4092, 'ITEM #4092__ITEM #4092', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4093, 'ITEM #4093__ITEM #4093', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4094, 'ITEM #4094__ITEM #4094', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4095, 'ITEM #4095__ITEM #4095', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4096, 'ITEM #4096__ITEM #4096', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4097, 'ITEM #4097__ITEM #4097', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4098, 'ITEM #4098__ITEM #4098', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4099, 'ITEM #4099__ITEM #4099', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4100, 'ITEM #4100__ITEM #4100', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4101, 'ITEM #4101__ITEM #4101', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4102, 'ITEM #4102__ITEM #4102', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4103, 'ITEM #4103__ITEM #4103', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4104, 'ITEM #4104__ITEM #4104', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4105, 'ITEM #4105__ITEM #4105', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4106, 'ITEM #4106__ITEM #4106', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4107, 'ITEM #4107__ITEM #4107', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4108, 'ITEM #4108__ITEM #4108', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4109, 'ITEM #4109__ITEM #4109', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4110, 'ITEM #4110__ITEM #4110', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4111, 'ITEM #4111__ITEM #4111', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4112, 'ITEM #4112__ITEM #4112', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4113, 'ITEM #4113__ITEM #4113', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4114, 'ITEM #4114__ITEM #4114', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4115, 'ITEM #4115__ITEM #4115', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4116, 'ITEM #4116__ITEM #4116', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4117, 'ITEM #4117__ITEM #4117', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4118, 'ITEM #4118__ITEM #4118', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4119, 'ITEM #4119__ITEM #4119', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4120, 'ITEM #4120__ITEM #4120', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4121, 'ITEM #4121__ITEM #4121', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4122, 'ITEM #4122__ITEM #4122', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4123, 'ITEM #4123__ITEM #4123', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4124, 'ITEM #4124__ITEM #4124', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4125, 'ITEM #4125__ITEM #4125', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4126, 'ITEM #4126__ITEM #4126', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4127, 'ITEM #4127__ITEM #4127', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4128, 'ITEM #4128__ITEM #4128', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4129, 'ITEM #4129__ITEM #4129', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4130, 'ITEM #4130__ITEM #4130', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4131, 'ITEM #4131__ITEM #4131', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4132, 'ITEM #4132__ITEM #4132', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4133, 'ITEM #4133__ITEM #4133', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4134, 'ITEM #4134__ITEM #4134', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4135, 'ITEM #4135__ITEM #4135', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4136, 'ITEM #4136__ITEM #4136', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4137, 'ITEM #4137__ITEM #4137', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4138, 'ITEM #4138__ITEM #4138', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4139, 'ITEM #4139__ITEM #4139', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4140, 'ITEM #4140__ITEM #4140', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4141, 'ITEM #4141__ITEM #4141', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4142, 'ITEM #4142__ITEM #4142', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4143, 'ITEM #4143__ITEM #4143', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4144, 'ITEM #4144__ITEM #4144', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4145, 'ITEM #4145__ITEM #4145', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4146, 'ITEM #4146__ITEM #4146', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4147, 'ITEM #4147__ITEM #4147', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4148, 'ITEM #4148__ITEM #4148', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4149, 'ITEM #4149__ITEM #4149', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4150, 'ITEM #4150__ITEM #4150', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4151, 'ITEM #4151__ITEM #4151', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4152, 'ITEM #4152__ITEM #4152', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4153, 'ITEM #4153__ITEM #4153', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4154, 'ITEM #4154__ITEM #4154', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4155, 'ITEM #4155__ITEM #4155', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4156, 'ITEM #4156__ITEM #4156', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4157, 'ITEM #4157__ITEM #4157', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4158, 'ITEM #4158__ITEM #4158', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4159, 'ITEM #4159__ITEM #4159', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4160, 'ITEM #4160__ITEM #4160', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4161, 'ITEM #4161__ITEM #4161', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4162, 'ITEM #4162__ITEM #4162', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4163, 'ITEM #4163__ITEM #4163', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4164, 'ITEM #4164__ITEM #4164', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4165, 'ITEM #4165__ITEM #4165', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4166, 'ITEM #4166__ITEM #4166', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4167, 'ITEM #4167__ITEM #4167', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4168, 'ITEM #4168__ITEM #4168', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4169, 'ITEM #4169__ITEM #4169', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4170, 'ITEM #4170__ITEM #4170', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4171, 'ITEM #4171__ITEM #4171', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4172, 'ITEM #4172__ITEM #4172', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4173, 'ITEM #4173__ITEM #4173', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4174, 'ITEM #4174__ITEM #4174', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4175, 'ITEM #4175__ITEM #4175', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4176, 'ITEM #4176__ITEM #4176', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4177, 'ITEM #4177__ITEM #4177', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4178, 'ITEM #4178__ITEM #4178', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4179, 'ITEM #4179__ITEM #4179', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4180, 'ITEM #4180__ITEM #4180', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4181, 'ITEM #4181__ITEM #4181', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4182, 'ITEM #4182__ITEM #4182', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4183, 'ITEM #4183__ITEM #4183', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4184, 'ITEM #4184__ITEM #4184', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4185, 'ITEM #4185__ITEM #4185', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4186, 'ITEM #4186__ITEM #4186', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4187, 'ITEM #4187__ITEM #4187', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4188, 'ITEM #4188__ITEM #4188', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4189, 'ITEM #4189__ITEM #4189', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4190, 'ITEM #4190__ITEM #4190', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4191, 'ITEM #4191__ITEM #4191', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4192, 'ITEM #4192__ITEM #4192', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4193, 'ITEM #4193__ITEM #4193', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4194, 'ITEM #4194__ITEM #4194', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4195, 'ITEM #4195__ITEM #4195', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4196, 'ITEM #4196__ITEM #4196', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4197, 'ITEM #4197__ITEM #4197', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4198, 'ITEM #4198__ITEM #4198', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4199, 'ITEM #4199__ITEM #4199', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4200, 'ITEM #4200__ITEM #4200', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4201, 'ITEM #4201__ITEM #4201', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4202, 'ITEM #4202__ITEM #4202', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4203, 'ITEM #4203__ITEM #4203', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4204, 'ITEM #4204__ITEM #4204', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4205, 'ITEM #4205__ITEM #4205', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4206, 'ITEM #4206__ITEM #4206', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4207, 'ITEM #4207__ITEM #4207', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4208, 'ITEM #4208__ITEM #4208', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4209, 'ITEM #4209__ITEM #4209', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4210, 'ITEM #4210__ITEM #4210', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4211, 'ITEM #4211__ITEM #4211', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4212, 'ITEM #4212__ITEM #4212', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4213, 'ITEM #4213__ITEM #4213', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4214, 'ITEM #4214__ITEM #4214', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4215, 'ITEM #4215__ITEM #4215', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4216, 'ITEM #4216__ITEM #4216', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4217, 'ITEM #4217__ITEM #4217', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4218, 'ITEM #4218__ITEM #4218', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4219, 'ITEM #4219__ITEM #4219', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4220, 'ITEM #4220__ITEM #4220', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4221, 'ITEM #4221__ITEM #4221', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4222, 'ITEM #4222__ITEM #4222', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4223, 'ITEM #4223__ITEM #4223', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4224, 'ITEM #4224__ITEM #4224', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4225, 'ITEM #4225__ITEM #4225', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4226, 'ITEM #4226__ITEM #4226', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4227, 'ITEM #4227__ITEM #4227', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4228, 'ITEM #4228__ITEM #4228', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4229, 'ITEM #4229__ITEM #4229', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4230, 'ITEM #4230__ITEM #4230', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4231, 'ITEM #4231__ITEM #4231', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4232, 'ITEM #4232__ITEM #4232', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4233, 'ITEM #4233__ITEM #4233', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4234, 'ITEM #4234__ITEM #4234', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4235, 'ITEM #4235__ITEM #4235', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4236, 'ITEM #4236__ITEM #4236', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4237, 'ITEM #4237__ITEM #4237', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4238, 'ITEM #4238__ITEM #4238', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4239, 'ITEM #4239__ITEM #4239', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4240, 'ITEM #4240__ITEM #4240', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4241, 'ITEM #4241__ITEM #4241', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4242, 'ITEM #4242__ITEM #4242', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4243, 'ITEM #4243__ITEM #4243', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4244, 'ITEM #4244__ITEM #4244', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4245, 'ITEM #4245__ITEM #4245', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4246, 'ITEM #4246__ITEM #4246', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4247, 'ITEM #4247__ITEM #4247', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4248, 'ITEM #4248__ITEM #4248', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4249, 'ITEM #4249__ITEM #4249', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4250, 'ITEM #4250__ITEM #4250', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4251, 'ITEM #4251__ITEM #4251', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4252, 'ITEM #4252__ITEM #4252', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4253, 'ITEM #4253__ITEM #4253', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4254, 'ITEM #4254__ITEM #4254', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4255, 'ITEM #4255__ITEM #4255', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4256, 'ITEM #4256__ITEM #4256', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4257, 'ITEM #4257__ITEM #4257', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4258, 'ITEM #4258__ITEM #4258', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4259, 'ITEM #4259__ITEM #4259', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4260, 'ITEM #4260__ITEM #4260', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4261, 'ITEM #4261__ITEM #4261', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4262, 'ITEM #4262__ITEM #4262', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4263, 'ITEM #4263__ITEM #4263', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4264, 'ITEM #4264__ITEM #4264', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4265, 'ITEM #4265__ITEM #4265', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4266, 'ITEM #4266__ITEM #4266', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4267, 'ITEM #4267__ITEM #4267', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4268, 'ITEM #4268__ITEM #4268', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4269, 'ITEM #4269__ITEM #4269', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4270, 'ITEM #4270__ITEM #4270', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4271, 'ITEM #4271__ITEM #4271', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4272, 'ITEM #4272__ITEM #4272', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4273, 'ITEM #4273__ITEM #4273', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4274, 'ITEM #4274__ITEM #4274', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4275, 'ITEM #4275__ITEM #4275', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4276, 'ITEM #4276__ITEM #4276', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4277, 'ITEM #4277__ITEM #4277', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4278, 'ITEM #4278__ITEM #4278', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4279, 'ITEM #4279__ITEM #4279', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4280, 'ITEM #4280__ITEM #4280', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4281, 'ITEM #4281__ITEM #4281', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4282, 'ITEM #4282__ITEM #4282', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4283, 'ITEM #4283__ITEM #4283', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4284, 'ITEM #4284__ITEM #4284', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4285, 'ITEM #4285__ITEM #4285', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4286, 'ITEM #4286__ITEM #4286', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4287, 'ITEM #4287__ITEM #4287', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4288, 'ITEM #4288__ITEM #4288', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4289, 'ITEM #4289__ITEM #4289', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4290, 'ITEM #4290__ITEM #4290', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4291, 'ITEM #4291__ITEM #4291', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4292, 'ITEM #4292__ITEM #4292', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4293, 'ITEM #4293__ITEM #4293', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4294, 'ITEM #4294__ITEM #4294', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4295, 'ITEM #4295__ITEM #4295', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4296, 'ITEM #4296__ITEM #4296', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4297, 'ITEM #4297__ITEM #4297', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4298, 'ITEM #4298__ITEM #4298', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4299, 'ITEM #4299__ITEM #4299', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4300, 'ITEM #4300__ITEM #4300', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4301, 'ITEM #4301__ITEM #4301', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4302, 'ITEM #4302__ITEM #4302', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4303, 'ITEM #4303__ITEM #4303', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4304, 'ITEM #4304__ITEM #4304', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4305, 'ITEM #4305__ITEM #4305', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4306, 'ITEM #4306__ITEM #4306', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4307, 'ITEM #4307__ITEM #4307', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4308, 'ITEM #4308__ITEM #4308', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4309, 'ITEM #4309__ITEM #4309', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4310, 'ITEM #4310__ITEM #4310', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4311, 'ITEM #4311__ITEM #4311', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4312, 'ITEM #4312__ITEM #4312', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4313, 'ITEM #4313__ITEM #4313', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4314, 'ITEM #4314__ITEM #4314', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4315, 'ITEM #4315__ITEM #4315', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4316, 'ITEM #4316__ITEM #4316', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4317, 'ITEM #4317__ITEM #4317', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4318, 'ITEM #4318__ITEM #4318', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4319, 'ITEM #4319__ITEM #4319', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4320, 'ITEM #4320__ITEM #4320', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4321, 'ITEM #4321__ITEM #4321', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4322, 'ITEM #4322__ITEM #4322', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4323, 'ITEM #4323__ITEM #4323', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4324, 'ITEM #4324__ITEM #4324', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4325, 'ITEM #4325__ITEM #4325', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4326, 'ITEM #4326__ITEM #4326', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4327, 'ITEM #4327__ITEM #4327', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4328, 'ITEM #4328__ITEM #4328', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4329, 'ITEM #4329__ITEM #4329', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4330, 'ITEM #4330__ITEM #4330', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4331, 'ITEM #4331__ITEM #4331', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4332, 'ITEM #4332__ITEM #4332', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4333, 'ITEM #4333__ITEM #4333', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4334, 'ITEM #4334__ITEM #4334', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4335, 'ITEM #4335__ITEM #4335', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4336, 'ITEM #4336__ITEM #4336', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4337, 'ITEM #4337__ITEM #4337', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4338, 'ITEM #4338__ITEM #4338', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4339, 'ITEM #4339__ITEM #4339', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4340, 'ITEM #4340__ITEM #4340', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4341, 'ITEM #4341__ITEM #4341', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4342, 'ITEM #4342__ITEM #4342', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4343, 'ITEM #4343__ITEM #4343', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4344, 'ITEM #4344__ITEM #4344', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4345, 'ITEM #4345__ITEM #4345', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4346, 'ITEM #4346__ITEM #4346', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4347, 'ITEM #4347__ITEM #4347', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4348, 'ITEM #4348__ITEM #4348', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4349, 'ITEM #4349__ITEM #4349', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4350, 'ITEM #4350__ITEM #4350', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4351, 'ITEM #4351__ITEM #4351', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4352, 'ITEM #4352__ITEM #4352', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4353, 'ITEM #4353__ITEM #4353', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4354, 'ITEM #4354__ITEM #4354', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4355, 'ITEM #4355__ITEM #4355', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4356, 'ITEM #4356__ITEM #4356', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4357, 'ITEM #4357__ITEM #4357', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4358, 'ITEM #4358__ITEM #4358', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4359, 'ITEM #4359__ITEM #4359', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4360, 'ITEM #4360__ITEM #4360', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4361, 'ITEM #4361__ITEM #4361', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4362, 'ITEM #4362__ITEM #4362', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4363, 'ITEM #4363__ITEM #4363', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4364, 'ITEM #4364__ITEM #4364', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4365, 'ITEM #4365__ITEM #4365', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4366, 'ITEM #4366__ITEM #4366', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4367, 'ITEM #4367__ITEM #4367', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4368, 'ITEM #4368__ITEM #4368', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4369, 'ITEM #4369__ITEM #4369', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4370, 'ITEM #4370__ITEM #4370', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4371, 'ITEM #4371__ITEM #4371', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4372, 'ITEM #4372__ITEM #4372', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4373, 'ITEM #4373__ITEM #4373', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4374, 'ITEM #4374__ITEM #4374', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4375, 'ITEM #4375__ITEM #4375', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4376, 'ITEM #4376__ITEM #4376', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4377, 'ITEM #4377__ITEM #4377', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4378, 'ITEM #4378__ITEM #4378', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4379, 'ITEM #4379__ITEM #4379', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4380, 'ITEM #4380__ITEM #4380', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4381, 'ITEM #4381__ITEM #4381', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4382, 'ITEM #4382__ITEM #4382', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4383, 'ITEM #4383__ITEM #4383', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4384, 'ITEM #4384__ITEM #4384', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4385, 'ITEM #4385__ITEM #4385', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4386, 'ITEM #4386__ITEM #4386', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4387, 'ITEM #4387__ITEM #4387', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4388, 'ITEM #4388__ITEM #4388', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4389, 'ITEM #4389__ITEM #4389', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4390, 'ITEM #4390__ITEM #4390', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4391, 'ITEM #4391__ITEM #4391', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4392, 'ITEM #4392__ITEM #4392', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4393, 'ITEM #4393__ITEM #4393', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4394, 'ITEM #4394__ITEM #4394', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4395, 'ITEM #4395__ITEM #4395', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4396, 'ITEM #4396__ITEM #4396', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4397, 'ITEM #4397__ITEM #4397', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4398, 'ITEM #4398__ITEM #4398', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4399, 'ITEM #4399__ITEM #4399', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4400, 'ITEM #4400__ITEM #4400', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4401, 'ITEM #4401__ITEM #4401', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4402, 'ITEM #4402__ITEM #4402', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4403, 'ITEM #4403__ITEM #4403', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4404, 'ITEM #4404__ITEM #4404', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4405, 'ITEM #4405__ITEM #4405', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4406, 'ITEM #4406__ITEM #4406', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4407, 'ITEM #4407__ITEM #4407', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4408, 'ITEM #4408__ITEM #4408', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4409, 'ITEM #4409__ITEM #4409', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4410, 'ITEM #4410__ITEM #4410', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4411, 'ITEM #4411__ITEM #4411', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4412, 'ITEM #4412__ITEM #4412', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4413, 'ITEM #4413__ITEM #4413', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4414, 'ITEM #4414__ITEM #4414', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4415, 'ITEM #4415__ITEM #4415', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4416, 'ITEM #4416__ITEM #4416', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4417, 'ITEM #4417__ITEM #4417', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4418, 'ITEM #4418__ITEM #4418', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4419, 'ITEM #4419__ITEM #4419', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4420, 'ITEM #4420__ITEM #4420', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4421, 'ITEM #4421__ITEM #4421', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4422, 'ITEM #4422__ITEM #4422', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4423, 'ITEM #4423__ITEM #4423', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4424, 'ITEM #4424__ITEM #4424', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4425, 'ITEM #4425__ITEM #4425', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4426, 'ITEM #4426__ITEM #4426', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4427, 'ITEM #4427__ITEM #4427', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4428, 'ITEM #4428__ITEM #4428', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4429, 'ITEM #4429__ITEM #4429', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4430, 'ITEM #4430__ITEM #4430', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4431, 'ITEM #4431__ITEM #4431', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4432, 'ITEM #4432__ITEM #4432', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4433, 'ITEM #4433__ITEM #4433', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4434, 'ITEM #4434__ITEM #4434', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4435, 'ITEM #4435__ITEM #4435', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4436, 'ITEM #4436__ITEM #4436', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4437, 'ITEM #4437__ITEM #4437', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4438, 'ITEM #4438__ITEM #4438', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4439, 'ITEM #4439__ITEM #4439', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4440, 'ITEM #4440__ITEM #4440', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4441, 'ITEM #4441__ITEM #4441', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4442, 'ITEM #4442__ITEM #4442', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4443, 'ITEM #4443__ITEM #4443', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4444, 'ITEM #4444__ITEM #4444', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4445, 'ITEM #4445__ITEM #4445', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4446, 'ITEM #4446__ITEM #4446', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4447, 'ITEM #4447__ITEM #4447', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4448, 'ITEM #4448__ITEM #4448', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4449, 'ITEM #4449__ITEM #4449', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4450, 'ITEM #4450__ITEM #4450', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4451, 'ITEM #4451__ITEM #4451', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4452, 'ITEM #4452__ITEM #4452', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4453, 'ITEM #4453__ITEM #4453', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4454, 'ITEM #4454__ITEM #4454', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4455, 'ITEM #4455__ITEM #4455', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4456, 'ITEM #4456__ITEM #4456', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4457, 'ITEM #4457__ITEM #4457', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4458, 'ITEM #4458__ITEM #4458', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4459, 'ITEM #4459__ITEM #4459', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4460, 'ITEM #4460__ITEM #4460', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4461, 'ITEM #4461__ITEM #4461', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4462, 'ITEM #4462__ITEM #4462', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4463, 'ITEM #4463__ITEM #4463', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4464, 'ITEM #4464__ITEM #4464', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4465, 'ITEM #4465__ITEM #4465', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4466, 'ITEM #4466__ITEM #4466', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4467, 'ITEM #4467__ITEM #4467', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4468, 'ITEM #4468__ITEM #4468', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4469, 'ITEM #4469__ITEM #4469', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4470, 'ITEM #4470__ITEM #4470', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4471, 'ITEM #4471__ITEM #4471', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4472, 'ITEM #4472__ITEM #4472', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4473, 'ITEM #4473__ITEM #4473', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4474, 'ITEM #4474__ITEM #4474', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4475, 'ITEM #4475__ITEM #4475', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4476, 'ITEM #4476__ITEM #4476', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4477, 'ITEM #4477__ITEM #4477', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4478, 'ITEM #4478__ITEM #4478', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4479, 'ITEM #4479__ITEM #4479', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4480, 'ITEM #4480__ITEM #4480', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4481, 'ITEM #4481__ITEM #4481', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4482, 'ITEM #4482__ITEM #4482', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4483, 'ITEM #4483__ITEM #4483', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4484, 'ITEM #4484__ITEM #4484', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4485, 'ITEM #4485__ITEM #4485', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4486, 'ITEM #4486__ITEM #4486', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4487, 'ITEM #4487__ITEM #4487', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4488, 'ITEM #4488__ITEM #4488', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4489, 'ITEM #4489__ITEM #4489', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4490, 'ITEM #4490__ITEM #4490', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4491, 'ITEM #4491__ITEM #4491', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4492, 'ITEM #4492__ITEM #4492', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4493, 'ITEM #4493__ITEM #4493', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4494, 'ITEM #4494__ITEM #4494', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4495, 'ITEM #4495__ITEM #4495', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4496, 'ITEM #4496__ITEM #4496', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4497, 'ITEM #4497__ITEM #4497', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4498, 'ITEM #4498__ITEM #4498', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4499, 'ITEM #4499__ITEM #4499', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4500, 'ITEM #4500__ITEM #4500', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4501, 'ITEM #4501__ITEM #4501', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4502, 'ITEM #4502__ITEM #4502', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4503, 'ITEM #4503__ITEM #4503', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4504, 'ITEM #4504__ITEM #4504', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4505, 'ITEM #4505__ITEM #4505', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4506, 'ITEM #4506__ITEM #4506', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4507, 'ITEM #4507__ITEM #4507', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4508, 'ITEM #4508__ITEM #4508', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4509, 'ITEM #4509__ITEM #4509', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4510, 'ITEM #4510__ITEM #4510', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4511, 'ITEM #4511__ITEM #4511', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4512, 'ITEM #4512__ITEM #4512', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4513, 'ITEM #4513__ITEM #4513', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4514, 'ITEM #4514__ITEM #4514', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4515, 'ITEM #4515__ITEM #4515', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4516, 'ITEM #4516__ITEM #4516', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4517, 'ITEM #4517__ITEM #4517', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4518, 'ITEM #4518__ITEM #4518', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4519, 'ITEM #4519__ITEM #4519', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4520, 'ITEM #4520__ITEM #4520', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4521, 'ITEM #4521__ITEM #4521', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4522, 'ITEM #4522__ITEM #4522', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4523, 'ITEM #4523__ITEM #4523', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4524, 'ITEM #4524__ITEM #4524', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4525, 'ITEM #4525__ITEM #4525', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4526, 'ITEM #4526__ITEM #4526', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4527, 'ITEM #4527__ITEM #4527', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4528, 'ITEM #4528__ITEM #4528', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4529, 'ITEM #4529__ITEM #4529', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4530, 'ITEM #4530__ITEM #4530', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4531, 'ITEM #4531__ITEM #4531', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4532, 'ITEM #4532__ITEM #4532', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4533, 'ITEM #4533__ITEM #4533', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4534, 'ITEM #4534__ITEM #4534', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4535, 'ITEM #4535__ITEM #4535', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4536, 'ITEM #4536__ITEM #4536', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4537, 'ITEM #4537__ITEM #4537', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4538, 'ITEM #4538__ITEM #4538', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4539, 'ITEM #4539__ITEM #4539', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4540, 'ITEM #4540__ITEM #4540', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4541, 'ITEM #4541__ITEM #4541', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4542, 'ITEM #4542__ITEM #4542', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4543, 'ITEM #4543__ITEM #4543', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4544, 'ITEM #4544__ITEM #4544', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4545, 'ITEM #4545__ITEM #4545', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4546, 'ITEM #4546__ITEM #4546', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4547, 'ITEM #4547__ITEM #4547', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4548, 'ITEM #4548__ITEM #4548', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4549, 'ITEM #4549__ITEM #4549', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4550, 'ITEM #4550__ITEM #4550', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4551, 'ITEM #4551__ITEM #4551', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4552, 'ITEM #4552__ITEM #4552', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4553, 'ITEM #4553__ITEM #4553', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4554, 'ITEM #4554__ITEM #4554', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4555, 'ITEM #4555__ITEM #4555', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4556, 'ITEM #4556__ITEM #4556', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4557, 'ITEM #4557__ITEM #4557', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4558, 'ITEM #4558__ITEM #4558', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4559, 'ITEM #4559__ITEM #4559', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4560, 'ITEM #4560__ITEM #4560', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4561, 'ITEM #4561__ITEM #4561', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4562, 'ITEM #4562__ITEM #4562', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4563, 'ITEM #4563__ITEM #4563', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4564, 'ITEM #4564__ITEM #4564', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4565, 'ITEM #4565__ITEM #4565', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4566, 'ITEM #4566__ITEM #4566', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4567, 'ITEM #4567__ITEM #4567', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4568, 'ITEM #4568__ITEM #4568', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4569, 'ITEM #4569__ITEM #4569', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4570, 'ITEM #4570__ITEM #4570', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4571, 'ITEM #4571__ITEM #4571', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4572, 'ITEM #4572__ITEM #4572', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4573, 'ITEM #4573__ITEM #4573', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4574, 'ITEM #4574__ITEM #4574', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4575, 'ITEM #4575__ITEM #4575', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4576, 'ITEM #4576__ITEM #4576', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4577, 'ITEM #4577__ITEM #4577', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4578, 'ITEM #4578__ITEM #4578', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4579, 'ITEM #4579__ITEM #4579', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4580, 'ITEM #4580__ITEM #4580', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4581, 'ITEM #4581__ITEM #4581', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4582, 'ITEM #4582__ITEM #4582', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4583, 'ITEM #4583__ITEM #4583', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4584, 'ITEM #4584__ITEM #4584', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4585, 'ITEM #4585__ITEM #4585', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4586, 'ITEM #4586__ITEM #4586', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4587, 'ITEM #4587__ITEM #4587', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4588, 'ITEM #4588__ITEM #4588', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4589, 'ITEM #4589__ITEM #4589', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4590, 'ITEM #4590__ITEM #4590', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4591, 'ITEM #4591__ITEM #4591', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4592, 'ITEM #4592__ITEM #4592', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4593, 'ITEM #4593__ITEM #4593', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4594, 'ITEM #4594__ITEM #4594', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4595, 'ITEM #4595__ITEM #4595', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4596, 'ITEM #4596__ITEM #4596', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4597, 'ITEM #4597__ITEM #4597', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4598, 'ITEM #4598__ITEM #4598', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4599, 'ITEM #4599__ITEM #4599', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4600, 'ITEM #4600__ITEM #4600', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4601, 'ITEM #4601__ITEM #4601', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4602, 'ITEM #4602__ITEM #4602', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4603, 'ITEM #4603__ITEM #4603', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4604, 'ITEM #4604__ITEM #4604', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4605, 'ITEM #4605__ITEM #4605', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4606, 'ITEM #4606__ITEM #4606', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4607, 'ITEM #4607__ITEM #4607', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4608, 'ITEM #4608__ITEM #4608', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4609, 'ITEM #4609__ITEM #4609', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4610, 'ITEM #4610__ITEM #4610', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4611, 'ITEM #4611__ITEM #4611', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4612, 'ITEM #4612__ITEM #4612', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4613, 'ITEM #4613__ITEM #4613', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4614, 'ITEM #4614__ITEM #4614', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4615, 'ITEM #4615__ITEM #4615', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4616, 'ITEM #4616__ITEM #4616', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4617, 'ITEM #4617__ITEM #4617', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4618, 'ITEM #4618__ITEM #4618', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4619, 'ITEM #4619__ITEM #4619', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4620, 'ITEM #4620__ITEM #4620', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4621, 'ITEM #4621__ITEM #4621', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4622, 'ITEM #4622__ITEM #4622', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4623, 'ITEM #4623__ITEM #4623', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4624, 'ITEM #4624__ITEM #4624', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4625, 'ITEM #4625__ITEM #4625', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4626, 'ITEM #4626__ITEM #4626', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4627, 'ITEM #4627__ITEM #4627', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4628, 'ITEM #4628__ITEM #4628', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4629, 'ITEM #4629__ITEM #4629', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4630, 'ITEM #4630__ITEM #4630', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4631, 'ITEM #4631__ITEM #4631', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4632, 'ITEM #4632__ITEM #4632', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4633, 'ITEM #4633__ITEM #4633', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4634, 'ITEM #4634__ITEM #4634', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4635, 'ITEM #4635__ITEM #4635', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4636, 'ITEM #4636__ITEM #4636', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4637, 'ITEM #4637__ITEM #4637', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4638, 'ITEM #4638__ITEM #4638', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4639, 'ITEM #4639__ITEM #4639', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4640, 'ITEM #4640__ITEM #4640', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4641, 'ITEM #4641__ITEM #4641', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4642, 'ITEM #4642__ITEM #4642', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4643, 'ITEM #4643__ITEM #4643', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4644, 'ITEM #4644__ITEM #4644', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4645, 'ITEM #4645__ITEM #4645', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4646, 'ITEM #4646__ITEM #4646', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4647, 'ITEM #4647__ITEM #4647', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4648, 'ITEM #4648__ITEM #4648', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4649, 'ITEM #4649__ITEM #4649', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4650, 'ITEM #4650__ITEM #4650', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4651, 'ITEM #4651__ITEM #4651', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4652, 'ITEM #4652__ITEM #4652', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4653, 'ITEM #4653__ITEM #4653', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4654, 'ITEM #4654__ITEM #4654', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4655, 'ITEM #4655__ITEM #4655', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4656, 'ITEM #4656__ITEM #4656', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4657, 'ITEM #4657__ITEM #4657', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4658, 'ITEM #4658__ITEM #4658', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4659, 'ITEM #4659__ITEM #4659', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4660, 'ITEM #4660__ITEM #4660', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4661, 'ITEM #4661__ITEM #4661', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4662, 'ITEM #4662__ITEM #4662', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4663, 'ITEM #4663__ITEM #4663', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4664, 'ITEM #4664__ITEM #4664', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4665, 'ITEM #4665__ITEM #4665', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4666, 'ITEM #4666__ITEM #4666', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4667, 'ITEM #4667__ITEM #4667', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4668, 'ITEM #4668__ITEM #4668', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4669, 'ITEM #4669__ITEM #4669', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4670, 'ITEM #4670__ITEM #4670', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4671, 'ITEM #4671__ITEM #4671', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4672, 'ITEM #4672__ITEM #4672', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4673, 'ITEM #4673__ITEM #4673', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4674, 'ITEM #4674__ITEM #4674', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4675, 'ITEM #4675__ITEM #4675', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4676, 'ITEM #4676__ITEM #4676', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4677, 'ITEM #4677__ITEM #4677', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4678, 'ITEM #4678__ITEM #4678', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4679, 'ITEM #4679__ITEM #4679', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4680, 'ITEM #4680__ITEM #4680', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4681, 'ITEM #4681__ITEM #4681', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4682, 'ITEM #4682__ITEM #4682', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4683, 'ITEM #4683__ITEM #4683', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4684, 'ITEM #4684__ITEM #4684', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4685, 'ITEM #4685__ITEM #4685', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4686, 'ITEM #4686__ITEM #4686', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4687, 'ITEM #4687__ITEM #4687', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4688, 'ITEM #4688__ITEM #4688', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4689, 'ITEM #4689__ITEM #4689', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4690, 'ITEM #4690__ITEM #4690', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4691, 'ITEM #4691__ITEM #4691', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4692, 'ITEM #4692__ITEM #4692', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4693, 'ITEM #4693__ITEM #4693', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4694, 'ITEM #4694__ITEM #4694', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4695, 'ITEM #4695__ITEM #4695', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4696, 'ITEM #4696__ITEM #4696', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4697, 'ITEM #4697__ITEM #4697', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4698, 'ITEM #4698__ITEM #4698', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4699, 'ITEM #4699__ITEM #4699', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4700, 'ITEM #4700__ITEM #4700', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4701, 'ITEM #4701__ITEM #4701', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4702, 'ITEM #4702__ITEM #4702', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4703, 'ITEM #4703__ITEM #4703', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4704, 'ITEM #4704__ITEM #4704', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4705, 'ITEM #4705__ITEM #4705', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4706, 'ITEM #4706__ITEM #4706', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4707, 'ITEM #4707__ITEM #4707', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4708, 'ITEM #4708__ITEM #4708', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4709, 'ITEM #4709__ITEM #4709', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4710, 'ITEM #4710__ITEM #4710', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4711, 'ITEM #4711__ITEM #4711', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4712, 'ITEM #4712__ITEM #4712', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4713, 'ITEM #4713__ITEM #4713', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4714, 'ITEM #4714__ITEM #4714', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4715, 'ITEM #4715__ITEM #4715', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4716, 'ITEM #4716__ITEM #4716', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4717, 'ITEM #4717__ITEM #4717', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4718, 'ITEM #4718__ITEM #4718', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4719, 'ITEM #4719__ITEM #4719', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4720, 'ITEM #4720__ITEM #4720', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4721, 'ITEM #4721__ITEM #4721', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4722, 'ITEM #4722__ITEM #4722', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4723, 'ITEM #4723__ITEM #4723', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4724, 'ITEM #4724__ITEM #4724', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4725, 'ITEM #4725__ITEM #4725', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4726, 'ITEM #4726__ITEM #4726', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4727, 'ITEM #4727__ITEM #4727', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4728, 'ITEM #4728__ITEM #4728', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4729, 'ITEM #4729__ITEM #4729', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4730, 'ITEM #4730__ITEM #4730', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4731, 'ITEM #4731__ITEM #4731', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4732, 'ITEM #4732__ITEM #4732', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4733, 'ITEM #4733__ITEM #4733', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4734, 'ITEM #4734__ITEM #4734', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4735, 'ITEM #4735__ITEM #4735', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4736, 'ITEM #4736__ITEM #4736', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4737, 'ITEM #4737__ITEM #4737', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4738, 'ITEM #4738__ITEM #4738', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4739, 'ITEM #4739__ITEM #4739', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4740, 'ITEM #4740__ITEM #4740', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4741, 'ITEM #4741__ITEM #4741', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4742, 'ITEM #4742__ITEM #4742', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4743, 'ITEM #4743__ITEM #4743', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4744, 'ITEM #4744__ITEM #4744', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4745, 'ITEM #4745__ITEM #4745', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4746, 'ITEM #4746__ITEM #4746', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4747, 'ITEM #4747__ITEM #4747', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4748, 'ITEM #4748__ITEM #4748', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4749, 'ITEM #4749__ITEM #4749', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4750, 'ITEM #4750__ITEM #4750', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4751, 'ITEM #4751__ITEM #4751', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4752, 'ITEM #4752__ITEM #4752', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4753, 'ITEM #4753__ITEM #4753', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4754, 'ITEM #4754__ITEM #4754', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4755, 'ITEM #4755__ITEM #4755', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4756, 'ITEM #4756__ITEM #4756', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4757, 'ITEM #4757__ITEM #4757', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4758, 'ITEM #4758__ITEM #4758', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4759, 'ITEM #4759__ITEM #4759', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4760, 'ITEM #4760__ITEM #4760', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4761, 'ITEM #4761__ITEM #4761', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4762, 'ITEM #4762__ITEM #4762', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4763, 'ITEM #4763__ITEM #4763', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4764, 'ITEM #4764__ITEM #4764', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4765, 'ITEM #4765__ITEM #4765', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4766, 'ITEM #4766__ITEM #4766', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4767, 'ITEM #4767__ITEM #4767', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4768, 'ITEM #4768__ITEM #4768', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4769, 'ITEM #4769__ITEM #4769', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4770, 'ITEM #4770__ITEM #4770', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4771, 'ITEM #4771__ITEM #4771', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4772, 'ITEM #4772__ITEM #4772', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4773, 'ITEM #4773__ITEM #4773', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4774, 'ITEM #4774__ITEM #4774', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4775, 'ITEM #4775__ITEM #4775', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4776, 'ITEM #4776__ITEM #4776', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4777, 'ITEM #4777__ITEM #4777', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4778, 'ITEM #4778__ITEM #4778', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4779, 'ITEM #4779__ITEM #4779', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4780, 'ITEM #4780__ITEM #4780', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4781, 'ITEM #4781__ITEM #4781', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4782, 'ITEM #4782__ITEM #4782', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4783, 'ITEM #4783__ITEM #4783', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4784, 'ITEM #4784__ITEM #4784', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4785, 'ITEM #4785__ITEM #4785', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4786, 'ITEM #4786__ITEM #4786', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4787, 'ITEM #4787__ITEM #4787', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4788, 'ITEM #4788__ITEM #4788', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4789, 'ITEM #4789__ITEM #4789', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4790, 'ITEM #4790__ITEM #4790', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4791, 'ITEM #4791__ITEM #4791', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4792, 'ITEM #4792__ITEM #4792', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4793, 'ITEM #4793__ITEM #4793', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4794, 'ITEM #4794__ITEM #4794', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4795, 'ITEM #4795__ITEM #4795', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4796, 'ITEM #4796__ITEM #4796', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4797, 'ITEM #4797__ITEM #4797', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4798, 'ITEM #4798__ITEM #4798', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4799, 'ITEM #4799__ITEM #4799', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4800, 'ITEM #4800__ITEM #4800', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4801, 'ITEM #4801__ITEM #4801', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4802, 'ITEM #4802__ITEM #4802', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4803, 'ITEM #4803__ITEM #4803', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4804, 'ITEM #4804__ITEM #4804', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4805, 'ITEM #4805__ITEM #4805', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4806, 'ITEM #4806__ITEM #4806', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4807, 'ITEM #4807__ITEM #4807', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4808, 'ITEM #4808__ITEM #4808', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4809, 'ITEM #4809__ITEM #4809', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4810, 'ITEM #4810__ITEM #4810', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4811, 'ITEM #4811__ITEM #4811', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4812, 'ITEM #4812__ITEM #4812', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4813, 'ITEM #4813__ITEM #4813', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4814, 'ITEM #4814__ITEM #4814', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4815, 'ITEM #4815__ITEM #4815', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4816, 'ITEM #4816__ITEM #4816', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4817, 'ITEM #4817__ITEM #4817', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4818, 'ITEM #4818__ITEM #4818', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4819, 'ITEM #4819__ITEM #4819', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4820, 'ITEM #4820__ITEM #4820', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4821, 'ITEM #4821__ITEM #4821', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4822, 'ITEM #4822__ITEM #4822', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4823, 'ITEM #4823__ITEM #4823', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4824, 'ITEM #4824__ITEM #4824', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4825, 'ITEM #4825__ITEM #4825', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4826, 'ITEM #4826__ITEM #4826', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4827, 'ITEM #4827__ITEM #4827', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4828, 'ITEM #4828__ITEM #4828', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4829, 'ITEM #4829__ITEM #4829', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4830, 'ITEM #4830__ITEM #4830', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4831, 'ITEM #4831__ITEM #4831', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4832, 'ITEM #4832__ITEM #4832', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4833, 'ITEM #4833__ITEM #4833', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4834, 'ITEM #4834__ITEM #4834', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4835, 'ITEM #4835__ITEM #4835', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4836, 'ITEM #4836__ITEM #4836', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4837, 'ITEM #4837__ITEM #4837', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4838, 'ITEM #4838__ITEM #4838', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4839, 'ITEM #4839__ITEM #4839', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4840, 'ITEM #4840__ITEM #4840', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4841, 'ITEM #4841__ITEM #4841', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4842, 'ITEM #4842__ITEM #4842', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4843, 'ITEM #4843__ITEM #4843', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4844, 'ITEM #4844__ITEM #4844', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4845, 'ITEM #4845__ITEM #4845', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4846, 'ITEM #4846__ITEM #4846', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4847, 'ITEM #4847__ITEM #4847', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4848, 'ITEM #4848__ITEM #4848', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4849, 'ITEM #4849__ITEM #4849', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4850, 'ITEM #4850__ITEM #4850', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4851, 'ITEM #4851__ITEM #4851', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4852, 'ITEM #4852__ITEM #4852', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4853, 'ITEM #4853__ITEM #4853', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4854, 'ITEM #4854__ITEM #4854', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4855, 'ITEM #4855__ITEM #4855', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4856, 'ITEM #4856__ITEM #4856', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4857, 'ITEM #4857__ITEM #4857', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4858, 'ITEM #4858__ITEM #4858', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4859, 'ITEM #4859__ITEM #4859', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4860, 'ITEM #4860__ITEM #4860', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4861, 'ITEM #4861__ITEM #4861', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4862, 'ITEM #4862__ITEM #4862', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4863, 'ITEM #4863__ITEM #4863', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4864, 'ITEM #4864__ITEM #4864', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4865, 'ITEM #4865__ITEM #4865', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4866, 'ITEM #4866__ITEM #4866', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4867, 'ITEM #4867__ITEM #4867', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4868, 'ITEM #4868__ITEM #4868', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4869, 'ITEM #4869__ITEM #4869', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4870, 'ITEM #4870__ITEM #4870', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4871, 'ITEM #4871__ITEM #4871', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4872, 'ITEM #4872__ITEM #4872', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4873, 'ITEM #4873__ITEM #4873', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4874, 'ITEM #4874__ITEM #4874', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4875, 'ITEM #4875__ITEM #4875', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4876, 'ITEM #4876__ITEM #4876', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4877, 'ITEM #4877__ITEM #4877', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4878, 'ITEM #4878__ITEM #4878', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4879, 'ITEM #4879__ITEM #4879', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4880, 'ITEM #4880__ITEM #4880', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4881, 'ITEM #4881__ITEM #4881', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4882, 'ITEM #4882__ITEM #4882', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4883, 'ITEM #4883__ITEM #4883', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4884, 'ITEM #4884__ITEM #4884', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4885, 'ITEM #4885__ITEM #4885', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4886, 'ITEM #4886__ITEM #4886', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4887, 'ITEM #4887__ITEM #4887', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4888, 'ITEM #4888__ITEM #4888', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4889, 'ITEM #4889__ITEM #4889', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4890, 'ITEM #4890__ITEM #4890', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4891, 'ITEM #4891__ITEM #4891', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4892, 'ITEM #4892__ITEM #4892', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4893, 'ITEM #4893__ITEM #4893', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4894, 'ITEM #4894__ITEM #4894', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4895, 'ITEM #4895__ITEM #4895', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4896, 'ITEM #4896__ITEM #4896', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4897, 'ITEM #4897__ITEM #4897', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4898, 'ITEM #4898__ITEM #4898', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4899, 'ITEM #4899__ITEM #4899', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4900, 'ITEM #4900__ITEM #4900', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4901, 'ITEM #4901__ITEM #4901', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4902, 'ITEM #4902__ITEM #4902', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4903, 'ITEM #4903__ITEM #4903', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4904, 'ITEM #4904__ITEM #4904', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4905, 'ITEM #4905__ITEM #4905', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4906, 'ITEM #4906__ITEM #4906', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4907, 'ITEM #4907__ITEM #4907', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4908, 'ITEM #4908__ITEM #4908', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4909, 'ITEM #4909__ITEM #4909', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4910, 'ITEM #4910__ITEM #4910', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4911, 'ITEM #4911__ITEM #4911', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4912, 'ITEM #4912__ITEM #4912', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4913, 'ITEM #4913__ITEM #4913', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4914, 'ITEM #4914__ITEM #4914', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4915, 'ITEM #4915__ITEM #4915', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4916, 'ITEM #4916__ITEM #4916', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4917, 'ITEM #4917__ITEM #4917', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4918, 'ITEM #4918__ITEM #4918', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4919, 'ITEM #4919__ITEM #4919', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4920, 'ITEM #4920__ITEM #4920', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4921, 'ITEM #4921__ITEM #4921', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4922, 'ITEM #4922__ITEM #4922', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4923, 'ITEM #4923__ITEM #4923', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4924, 'ITEM #4924__ITEM #4924', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4925, 'ITEM #4925__ITEM #4925', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4926, 'ITEM #4926__ITEM #4926', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4927, 'ITEM #4927__ITEM #4927', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4928, 'ITEM #4928__ITEM #4928', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4929, 'ITEM #4929__ITEM #4929', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4930, 'ITEM #4930__ITEM #4930', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4931, 'ITEM #4931__ITEM #4931', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4932, 'ITEM #4932__ITEM #4932', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4933, 'ITEM #4933__ITEM #4933', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4934, 'ITEM #4934__ITEM #4934', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4935, 'ITEM #4935__ITEM #4935', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4936, 'ITEM #4936__ITEM #4936', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4937, 'ITEM #4937__ITEM #4937', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4938, 'ITEM #4938__ITEM #4938', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4939, 'ITEM #4939__ITEM #4939', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4940, 'ITEM #4940__ITEM #4940', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4941, 'ITEM #4941__ITEM #4941', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4942, 'ITEM #4942__ITEM #4942', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4943, 'ITEM #4943__ITEM #4943', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4944, 'ITEM #4944__ITEM #4944', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4945, 'ITEM #4945__ITEM #4945', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4946, 'ITEM #4946__ITEM #4946', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4947, 'ITEM #4947__ITEM #4947', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4948, 'ITEM #4948__ITEM #4948', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4949, 'ITEM #4949__ITEM #4949', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4950, 'ITEM #4950__ITEM #4950', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4951, 'ITEM #4951__ITEM #4951', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4952, 'ITEM #4952__ITEM #4952', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4953, 'ITEM #4953__ITEM #4953', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4954, 'ITEM #4954__ITEM #4954', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4955, 'ITEM #4955__ITEM #4955', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4956, 'ITEM #4956__ITEM #4956', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4957, 'ITEM #4957__ITEM #4957', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4958, 'ITEM #4958__ITEM #4958', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4959, 'ITEM #4959__ITEM #4959', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4960, 'ITEM #4960__ITEM #4960', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4961, 'ITEM #4961__ITEM #4961', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4962, 'ITEM #4962__ITEM #4962', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4963, 'ITEM #4963__ITEM #4963', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4964, 'ITEM #4964__ITEM #4964', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4965, 'ITEM #4965__ITEM #4965', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4966, 'ITEM #4966__ITEM #4966', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4967, 'ITEM #4967__ITEM #4967', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4968, 'ITEM #4968__ITEM #4968', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4969, 'ITEM #4969__ITEM #4969', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4970, 'ITEM #4970__ITEM #4970', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4971, 'ITEM #4971__ITEM #4971', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4972, 'ITEM #4972__ITEM #4972', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4973, 'ITEM #4973__ITEM #4973', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4974, 'ITEM #4974__ITEM #4974', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4975, 'ITEM #4975__ITEM #4975', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4976, 'ITEM #4976__ITEM #4976', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4977, 'ITEM #4977__ITEM #4977', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4978, 'ITEM #4978__ITEM #4978', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4979, 'ITEM #4979__ITEM #4979', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4980, 'ITEM #4980__ITEM #4980', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4981, 'ITEM #4981__ITEM #4981', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4982, 'ITEM #4982__ITEM #4982', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4983, 'ITEM #4983__ITEM #4983', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4984, 'ITEM #4984__ITEM #4984', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4985, 'ITEM #4985__ITEM #4985', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4986, 'ITEM #4986__ITEM #4986', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4987, 'ITEM #4987__ITEM #4987', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4988, 'ITEM #4988__ITEM #4988', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4989, 'ITEM #4989__ITEM #4989', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4990, 'ITEM #4990__ITEM #4990', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4991, 'ITEM #4991__ITEM #4991', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4992, 'ITEM #4992__ITEM #4992', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4993, 'ITEM #4993__ITEM #4993', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4994, 'ITEM #4994__ITEM #4994', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4995, 'ITEM #4995__ITEM #4995', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4996, 'ITEM #4996__ITEM #4996', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4997, 'ITEM #4997__ITEM #4997', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4998, 'ITEM #4998__ITEM #4998', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (4999, 'ITEM #4999__ITEM #4999', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5000, 'ITEM #5000__ITEM #5000', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5001, 'ITEM #5001__ITEM #5001', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5002, 'ITEM #5002__ITEM #5002', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5003, 'ITEM #5003__ITEM #5003', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5004, 'ITEM #5004__ITEM #5004', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5005, 'ITEM #5005__ITEM #5005', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5006, 'ITEM #5006__ITEM #5006', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5007, 'ITEM #5007__ITEM #5007', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5008, 'ITEM #5008__ITEM #5008', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5009, 'ITEM #5009__ITEM #5009', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5010, 'ITEM #5010__ITEM #5010', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5011, 'ITEM #5011__ITEM #5011', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5012, 'ITEM #5012__ITEM #5012', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5013, 'ITEM #5013__ITEM #5013', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5014, 'ITEM #5014__ITEM #5014', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5015, 'ITEM #5015__ITEM #5015', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5016, 'ITEM #5016__ITEM #5016', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5017, 'ITEM #5017__ITEM #5017', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5018, 'ITEM #5018__ITEM #5018', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5019, 'ITEM #5019__ITEM #5019', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5020, 'ITEM #5020__ITEM #5020', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5021, 'ITEM #5021__ITEM #5021', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5022, 'ITEM #5022__ITEM #5022', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5023, 'ITEM #5023__ITEM #5023', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5024, 'ITEM #5024__ITEM #5024', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5025, 'ITEM #5025__ITEM #5025', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5026, 'ITEM #5026__ITEM #5026', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5027, 'ITEM #5027__ITEM #5027', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5028, 'ITEM #5028__ITEM #5028', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5029, 'ITEM #5029__ITEM #5029', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5030, 'ITEM #5030__ITEM #5030', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5031, 'ITEM #5031__ITEM #5031', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5032, 'ITEM #5032__ITEM #5032', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5033, 'ITEM #5033__ITEM #5033', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5034, 'ITEM #5034__ITEM #5034', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5035, 'ITEM #5035__ITEM #5035', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5036, 'ITEM #5036__ITEM #5036', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5037, 'ITEM #5037__ITEM #5037', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5038, 'ITEM #5038__ITEM #5038', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5039, 'ITEM #5039__ITEM #5039', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5040, 'ITEM #5040__ITEM #5040', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5041, 'ITEM #5041__ITEM #5041', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5042, 'ITEM #5042__ITEM #5042', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5043, 'ITEM #5043__ITEM #5043', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5044, 'ITEM #5044__ITEM #5044', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5045, 'ITEM #5045__ITEM #5045', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5046, 'ITEM #5046__ITEM #5046', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5047, 'ITEM #5047__ITEM #5047', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5048, 'ITEM #5048__ITEM #5048', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5049, 'ITEM #5049__ITEM #5049', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5050, 'ITEM #5050__ITEM #5050', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5051, 'ITEM #5051__ITEM #5051', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5052, 'ITEM #5052__ITEM #5052', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5053, 'ITEM #5053__ITEM #5053', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5054, 'ITEM #5054__ITEM #5054', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5055, 'ITEM #5055__ITEM #5055', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5056, 'ITEM #5056__ITEM #5056', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5057, 'ITEM #5057__ITEM #5057', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5058, 'ITEM #5058__ITEM #5058', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5059, 'ITEM #5059__ITEM #5059', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5060, 'ITEM #5060__ITEM #5060', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5061, 'ITEM #5061__ITEM #5061', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5062, 'ITEM #5062__ITEM #5062', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5063, 'ITEM #5063__ITEM #5063', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5064, 'ITEM #5064__ITEM #5064', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5065, 'ITEM #5065__ITEM #5065', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5066, 'ITEM #5066__ITEM #5066', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5067, 'ITEM #5067__ITEM #5067', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5068, 'ITEM #5068__ITEM #5068', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5069, 'ITEM #5069__ITEM #5069', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5070, 'ITEM #5070__ITEM #5070', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5071, 'ITEM #5071__ITEM #5071', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5072, 'ITEM #5072__ITEM #5072', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5073, 'ITEM #5073__ITEM #5073', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5074, 'ITEM #5074__ITEM #5074', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5075, 'ITEM #5075__ITEM #5075', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5076, 'ITEM #5076__ITEM #5076', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5077, 'ITEM #5077__ITEM #5077', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5078, 'ITEM #5078__ITEM #5078', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5079, 'ITEM #5079__ITEM #5079', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5080, 'ITEM #5080__ITEM #5080', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5081, 'ITEM #5081__ITEM #5081', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5082, 'ITEM #5082__ITEM #5082', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5083, 'ITEM #5083__ITEM #5083', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5084, 'ITEM #5084__ITEM #5084', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5085, 'ITEM #5085__ITEM #5085', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5086, 'ITEM #5086__ITEM #5086', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5087, 'ITEM #5087__ITEM #5087', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5088, 'ITEM #5088__ITEM #5088', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5089, 'ITEM #5089__ITEM #5089', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5090, 'ITEM #5090__ITEM #5090', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5091, 'ITEM #5091__ITEM #5091', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5092, 'ITEM #5092__ITEM #5092', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5093, 'ITEM #5093__ITEM #5093', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5094, 'ITEM #5094__ITEM #5094', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5095, 'ITEM #5095__ITEM #5095', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5096, 'ITEM #5096__ITEM #5096', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5097, 'ITEM #5097__ITEM #5097', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5098, 'ITEM #5098__ITEM #5098', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5099, 'ITEM #5099__ITEM #5099', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5100, 'ITEM #5100__ITEM #5100', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5101, 'ITEM #5101__ITEM #5101', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5102, 'ITEM #5102__ITEM #5102', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5103, 'ITEM #5103__ITEM #5103', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5104, 'ITEM #5104__ITEM #5104', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5105, 'ITEM #5105__ITEM #5105', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5106, 'ITEM #5106__ITEM #5106', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5107, 'ITEM #5107__ITEM #5107', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5108, 'ITEM #5108__ITEM #5108', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5109, 'ITEM #5109__ITEM #5109', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5110, 'ITEM #5110__ITEM #5110', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5111, 'ITEM #5111__ITEM #5111', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5112, 'ITEM #5112__ITEM #5112', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5113, 'ITEM #5113__ITEM #5113', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5114, 'ITEM #5114__ITEM #5114', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5115, 'ITEM #5115__ITEM #5115', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5116, 'ITEM #5116__ITEM #5116', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5117, 'ITEM #5117__ITEM #5117', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5118, 'ITEM #5118__ITEM #5118', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5119, 'ITEM #5119__ITEM #5119', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5120, 'ITEM #5120__ITEM #5120', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5121, 'ITEM #5121__ITEM #5121', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5122, 'ITEM #5122__ITEM #5122', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5123, 'ITEM #5123__ITEM #5123', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5124, 'ITEM #5124__ITEM #5124', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5125, 'ITEM #5125__ITEM #5125', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5126, 'ITEM #5126__ITEM #5126', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5127, 'ITEM #5127__ITEM #5127', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5128, 'ITEM #5128__ITEM #5128', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5129, 'ITEM #5129__ITEM #5129', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5130, 'ITEM #5130__ITEM #5130', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5131, 'ITEM #5131__ITEM #5131', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5132, 'ITEM #5132__ITEM #5132', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5133, 'ITEM #5133__ITEM #5133', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5134, 'ITEM #5134__ITEM #5134', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5135, 'ITEM #5135__ITEM #5135', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5136, 'ITEM #5136__ITEM #5136', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5137, 'ITEM #5137__ITEM #5137', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5138, 'ITEM #5138__ITEM #5138', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5139, 'ITEM #5139__ITEM #5139', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5140, 'ITEM #5140__ITEM #5140', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5141, 'ITEM #5141__ITEM #5141', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5142, 'ITEM #5142__ITEM #5142', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5143, 'ITEM #5143__ITEM #5143', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5144, 'ITEM #5144__ITEM #5144', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5145, 'ITEM #5145__ITEM #5145', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5146, 'ITEM #5146__ITEM #5146', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5147, 'ITEM #5147__ITEM #5147', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5148, 'ITEM #5148__ITEM #5148', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5149, 'ITEM #5149__ITEM #5149', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5150, 'ITEM #5150__ITEM #5150', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5151, 'ITEM #5151__ITEM #5151', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5152, 'ITEM #5152__ITEM #5152', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5153, 'ITEM #5153__ITEM #5153', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5154, 'ITEM #5154__ITEM #5154', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5155, 'ITEM #5155__ITEM #5155', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5156, 'ITEM #5156__ITEM #5156', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5157, 'ITEM #5157__ITEM #5157', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5158, 'ITEM #5158__ITEM #5158', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5159, 'ITEM #5159__ITEM #5159', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5160, 'ITEM #5160__ITEM #5160', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5161, 'ITEM #5161__ITEM #5161', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5162, 'ITEM #5162__ITEM #5162', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5163, 'ITEM #5163__ITEM #5163', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5164, 'ITEM #5164__ITEM #5164', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5165, 'ITEM #5165__ITEM #5165', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5166, 'ITEM #5166__ITEM #5166', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5167, 'ITEM #5167__ITEM #5167', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5168, 'ITEM #5168__ITEM #5168', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5169, 'ITEM #5169__ITEM #5169', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5170, 'ITEM #5170__ITEM #5170', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5171, 'ITEM #5171__ITEM #5171', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5172, 'ITEM #5172__ITEM #5172', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5173, 'ITEM #5173__ITEM #5173', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5174, 'ITEM #5174__ITEM #5174', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5175, 'ITEM #5175__ITEM #5175', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5176, 'ITEM #5176__ITEM #5176', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5177, 'ITEM #5177__ITEM #5177', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5178, 'ITEM #5178__ITEM #5178', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5179, 'ITEM #5179__ITEM #5179', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5180, 'ITEM #5180__ITEM #5180', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5181, 'ITEM #5181__ITEM #5181', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5182, 'ITEM #5182__ITEM #5182', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5183, 'ITEM #5183__ITEM #5183', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5184, 'ITEM #5184__ITEM #5184', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5185, 'ITEM #5185__ITEM #5185', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5186, 'ITEM #5186__ITEM #5186', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5187, 'ITEM #5187__ITEM #5187', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5188, 'ITEM #5188__ITEM #5188', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5189, 'ITEM #5189__ITEM #5189', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5190, 'ITEM #5190__ITEM #5190', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5191, 'ITEM #5191__ITEM #5191', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5192, 'ITEM #5192__ITEM #5192', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5193, 'ITEM #5193__ITEM #5193', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5194, 'ITEM #5194__ITEM #5194', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5195, 'ITEM #5195__ITEM #5195', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5196, 'ITEM #5196__ITEM #5196', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5197, 'ITEM #5197__ITEM #5197', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5198, 'ITEM #5198__ITEM #5198', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5199, 'ITEM #5199__ITEM #5199', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5200, 'ITEM #5200__ITEM #5200', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5201, 'ITEM #5201__ITEM #5201', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5202, 'ITEM #5202__ITEM #5202', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5203, 'ITEM #5203__ITEM #5203', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5204, 'ITEM #5204__ITEM #5204', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5205, 'ITEM #5205__ITEM #5205', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5206, 'ITEM #5206__ITEM #5206', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5207, 'ITEM #5207__ITEM #5207', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5208, 'ITEM #5208__ITEM #5208', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5209, 'ITEM #5209__ITEM #5209', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5210, 'ITEM #5210__ITEM #5210', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5211, 'ITEM #5211__ITEM #5211', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5212, 'ITEM #5212__ITEM #5212', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5213, 'ITEM #5213__ITEM #5213', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5214, 'ITEM #5214__ITEM #5214', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5215, 'ITEM #5215__ITEM #5215', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5216, 'ITEM #5216__ITEM #5216', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5217, 'ITEM #5217__ITEM #5217', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5218, 'ITEM #5218__ITEM #5218', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5219, 'ITEM #5219__ITEM #5219', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5220, 'ITEM #5220__ITEM #5220', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5221, 'ITEM #5221__ITEM #5221', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5222, 'ITEM #5222__ITEM #5222', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5223, 'ITEM #5223__ITEM #5223', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5224, 'ITEM #5224__ITEM #5224', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5225, 'ITEM #5225__ITEM #5225', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5226, 'ITEM #5226__ITEM #5226', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5227, 'ITEM #5227__ITEM #5227', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5228, 'ITEM #5228__ITEM #5228', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5229, 'ITEM #5229__ITEM #5229', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5230, 'ITEM #5230__ITEM #5230', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5231, 'ITEM #5231__ITEM #5231', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5232, 'ITEM #5232__ITEM #5232', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5233, 'ITEM #5233__ITEM #5233', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5234, 'ITEM #5234__ITEM #5234', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5235, 'ITEM #5235__ITEM #5235', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5236, 'ITEM #5236__ITEM #5236', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5237, 'ITEM #5237__ITEM #5237', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5238, 'ITEM #5238__ITEM #5238', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5239, 'ITEM #5239__ITEM #5239', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5240, 'ITEM #5240__ITEM #5240', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5241, 'ITEM #5241__ITEM #5241', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5242, 'ITEM #5242__ITEM #5242', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5243, 'ITEM #5243__ITEM #5243', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5244, 'ITEM #5244__ITEM #5244', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5245, 'ITEM #5245__ITEM #5245', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5246, 'ITEM #5246__ITEM #5246', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5247, 'ITEM #5247__ITEM #5247', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5248, 'ITEM #5248__ITEM #5248', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5249, 'ITEM #5249__ITEM #5249', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5250, 'ITEM #5250__ITEM #5250', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5251, 'ITEM #5251__ITEM #5251', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5252, 'ITEM #5252__ITEM #5252', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5253, 'ITEM #5253__ITEM #5253', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5254, 'ITEM #5254__ITEM #5254', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5255, 'ITEM #5255__ITEM #5255', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5256, 'ITEM #5256__ITEM #5256', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5257, 'ITEM #5257__ITEM #5257', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5258, 'ITEM #5258__ITEM #5258', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5259, 'ITEM #5259__ITEM #5259', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5260, 'ITEM #5260__ITEM #5260', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5261, 'ITEM #5261__ITEM #5261', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5262, 'ITEM #5262__ITEM #5262', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5263, 'ITEM #5263__ITEM #5263', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5264, 'ITEM #5264__ITEM #5264', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5265, 'ITEM #5265__ITEM #5265', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5266, 'ITEM #5266__ITEM #5266', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5267, 'ITEM #5267__ITEM #5267', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5268, 'ITEM #5268__ITEM #5268', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5269, 'ITEM #5269__ITEM #5269', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5270, 'ITEM #5270__ITEM #5270', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5271, 'ITEM #5271__ITEM #5271', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5272, 'ITEM #5272__ITEM #5272', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5273, 'ITEM #5273__ITEM #5273', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5274, 'ITEM #5274__ITEM #5274', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5275, 'ITEM #5275__ITEM #5275', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5276, 'ITEM #5276__ITEM #5276', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5277, 'ITEM #5277__ITEM #5277', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5278, 'ITEM #5278__ITEM #5278', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5279, 'ITEM #5279__ITEM #5279', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5280, 'ITEM #5280__ITEM #5280', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5281, 'ITEM #5281__ITEM #5281', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5282, 'ITEM #5282__ITEM #5282', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5283, 'ITEM #5283__ITEM #5283', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5284, 'ITEM #5284__ITEM #5284', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5285, 'ITEM #5285__ITEM #5285', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5286, 'ITEM #5286__ITEM #5286', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5287, 'ITEM #5287__ITEM #5287', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5288, 'ITEM #5288__ITEM #5288', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5289, 'ITEM #5289__ITEM #5289', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5290, 'ITEM #5290__ITEM #5290', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5291, 'ITEM #5291__ITEM #5291', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5292, 'ITEM #5292__ITEM #5292', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5293, 'ITEM #5293__ITEM #5293', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5294, 'ITEM #5294__ITEM #5294', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5295, 'ITEM #5295__ITEM #5295', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5296, 'ITEM #5296__ITEM #5296', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5297, 'ITEM #5297__ITEM #5297', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5298, 'ITEM #5298__ITEM #5298', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5299, 'ITEM #5299__ITEM #5299', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5300, 'ITEM #5300__ITEM #5300', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5301, 'ITEM #5301__ITEM #5301', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5302, 'ITEM #5302__ITEM #5302', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5303, 'ITEM #5303__ITEM #5303', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5304, 'ITEM #5304__ITEM #5304', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5305, 'ITEM #5305__ITEM #5305', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5306, 'ITEM #5306__ITEM #5306', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5307, 'ITEM #5307__ITEM #5307', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5308, 'ITEM #5308__ITEM #5308', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5309, 'ITEM #5309__ITEM #5309', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5310, 'ITEM #5310__ITEM #5310', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5311, 'ITEM #5311__ITEM #5311', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5312, 'ITEM #5312__ITEM #5312', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5313, 'ITEM #5313__ITEM #5313', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5314, 'ITEM #5314__ITEM #5314', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5315, 'ITEM #5315__ITEM #5315', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5316, 'ITEM #5316__ITEM #5316', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5317, 'ITEM #5317__ITEM #5317', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5318, 'ITEM #5318__ITEM #5318', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5319, 'ITEM #5319__ITEM #5319', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5320, 'ITEM #5320__ITEM #5320', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5321, 'ITEM #5321__ITEM #5321', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5322, 'ITEM #5322__ITEM #5322', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5323, 'ITEM #5323__ITEM #5323', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5324, 'ITEM #5324__ITEM #5324', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5325, 'ITEM #5325__ITEM #5325', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5326, 'ITEM #5326__ITEM #5326', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5327, 'ITEM #5327__ITEM #5327', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5328, 'ITEM #5328__ITEM #5328', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5329, 'ITEM #5329__ITEM #5329', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5330, 'ITEM #5330__ITEM #5330', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5331, 'ITEM #5331__ITEM #5331', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5332, 'ITEM #5332__ITEM #5332', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5333, 'ITEM #5333__ITEM #5333', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5334, 'ITEM #5334__ITEM #5334', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5335, 'ITEM #5335__ITEM #5335', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5336, 'ITEM #5336__ITEM #5336', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5337, 'ITEM #5337__ITEM #5337', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5338, 'ITEM #5338__ITEM #5338', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5339, 'ITEM #5339__ITEM #5339', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5340, 'ITEM #5340__ITEM #5340', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5341, 'ITEM #5341__ITEM #5341', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5342, 'ITEM #5342__ITEM #5342', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5343, 'ITEM #5343__ITEM #5343', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5344, 'ITEM #5344__ITEM #5344', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5345, 'ITEM #5345__ITEM #5345', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5346, 'ITEM #5346__ITEM #5346', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5347, 'ITEM #5347__ITEM #5347', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5348, 'ITEM #5348__ITEM #5348', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5349, 'ITEM #5349__ITEM #5349', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5350, 'ITEM #5350__ITEM #5350', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5351, 'ITEM #5351__ITEM #5351', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5352, 'ITEM #5352__ITEM #5352', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5353, 'ITEM #5353__ITEM #5353', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5354, 'ITEM #5354__ITEM #5354', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5355, 'ITEM #5355__ITEM #5355', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5356, 'ITEM #5356__ITEM #5356', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5357, 'ITEM #5357__ITEM #5357', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5358, 'ITEM #5358__ITEM #5358', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5359, 'ITEM #5359__ITEM #5359', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5360, 'ITEM #5360__ITEM #5360', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5361, 'ITEM #5361__ITEM #5361', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5362, 'ITEM #5362__ITEM #5362', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5363, 'ITEM #5363__ITEM #5363', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5364, 'ITEM #5364__ITEM #5364', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5365, 'ITEM #5365__ITEM #5365', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5366, 'ITEM #5366__ITEM #5366', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5367, 'ITEM #5367__ITEM #5367', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5368, 'ITEM #5368__ITEM #5368', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5369, 'ITEM #5369__ITEM #5369', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5370, 'ITEM #5370__ITEM #5370', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5371, 'ITEM #5371__ITEM #5371', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5372, 'ITEM #5372__ITEM #5372', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5373, 'ITEM #5373__ITEM #5373', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5374, 'ITEM #5374__ITEM #5374', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5375, 'ITEM #5375__ITEM #5375', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5376, 'ITEM #5376__ITEM #5376', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5377, 'ITEM #5377__ITEM #5377', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5378, 'ITEM #5378__ITEM #5378', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5379, 'ITEM #5379__ITEM #5379', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5380, 'ITEM #5380__ITEM #5380', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5381, 'ITEM #5381__ITEM #5381', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5382, 'ITEM #5382__ITEM #5382', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5383, 'ITEM #5383__ITEM #5383', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5384, 'ITEM #5384__ITEM #5384', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5385, 'ITEM #5385__ITEM #5385', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5386, 'ITEM #5386__ITEM #5386', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5387, 'ITEM #5387__ITEM #5387', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5388, 'ITEM #5388__ITEM #5388', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5389, 'ITEM #5389__ITEM #5389', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5390, 'ITEM #5390__ITEM #5390', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5391, 'ITEM #5391__ITEM #5391', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5392, 'ITEM #5392__ITEM #5392', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5393, 'ITEM #5393__ITEM #5393', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5394, 'ITEM #5394__ITEM #5394', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5395, 'ITEM #5395__ITEM #5395', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5396, 'ITEM #5396__ITEM #5396', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5397, 'ITEM #5397__ITEM #5397', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5398, 'ITEM #5398__ITEM #5398', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5399, 'ITEM #5399__ITEM #5399', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5400, 'ITEM #5400__ITEM #5400', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5401, 'ITEM #5401__ITEM #5401', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5402, 'ITEM #5402__ITEM #5402', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5403, 'ITEM #5403__ITEM #5403', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5404, 'ITEM #5404__ITEM #5404', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5405, 'ITEM #5405__ITEM #5405', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5406, 'ITEM #5406__ITEM #5406', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5407, 'ITEM #5407__ITEM #5407', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5408, 'ITEM #5408__ITEM #5408', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5409, 'ITEM #5409__ITEM #5409', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5410, 'ITEM #5410__ITEM #5410', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5411, 'ITEM #5411__ITEM #5411', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5412, 'ITEM #5412__ITEM #5412', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5413, 'ITEM #5413__ITEM #5413', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5414, 'ITEM #5414__ITEM #5414', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5415, 'ITEM #5415__ITEM #5415', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5416, 'ITEM #5416__ITEM #5416', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5417, 'ITEM #5417__ITEM #5417', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5418, 'ITEM #5418__ITEM #5418', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5419, 'ITEM #5419__ITEM #5419', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5420, 'ITEM #5420__ITEM #5420', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5421, 'ITEM #5421__ITEM #5421', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5422, 'ITEM #5422__ITEM #5422', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5423, 'ITEM #5423__ITEM #5423', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5424, 'ITEM #5424__ITEM #5424', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5425, 'ITEM #5425__ITEM #5425', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5426, 'ITEM #5426__ITEM #5426', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5427, 'ITEM #5427__ITEM #5427', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5428, 'ITEM #5428__ITEM #5428', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5429, 'ITEM #5429__ITEM #5429', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5430, 'ITEM #5430__ITEM #5430', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5431, 'ITEM #5431__ITEM #5431', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5432, 'ITEM #5432__ITEM #5432', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5433, 'ITEM #5433__ITEM #5433', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5434, 'ITEM #5434__ITEM #5434', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5435, 'ITEM #5435__ITEM #5435', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5436, 'ITEM #5436__ITEM #5436', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5437, 'ITEM #5437__ITEM #5437', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5438, 'ITEM #5438__ITEM #5438', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5439, 'ITEM #5439__ITEM #5439', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5440, 'ITEM #5440__ITEM #5440', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5441, 'ITEM #5441__ITEM #5441', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5442, 'ITEM #5442__ITEM #5442', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5443, 'ITEM #5443__ITEM #5443', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5444, 'ITEM #5444__ITEM #5444', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5445, 'ITEM #5445__ITEM #5445', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5446, 'ITEM #5446__ITEM #5446', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5447, 'ITEM #5447__ITEM #5447', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5448, 'ITEM #5448__ITEM #5448', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5449, 'ITEM #5449__ITEM #5449', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5450, 'ITEM #5450__ITEM #5450', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5451, 'ITEM #5451__ITEM #5451', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5452, 'ITEM #5452__ITEM #5452', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5453, 'ITEM #5453__ITEM #5453', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5454, 'ITEM #5454__ITEM #5454', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5455, 'ITEM #5455__ITEM #5455', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5456, 'ITEM #5456__ITEM #5456', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5457, 'ITEM #5457__ITEM #5457', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5458, 'ITEM #5458__ITEM #5458', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5459, 'ITEM #5459__ITEM #5459', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5460, 'ITEM #5460__ITEM #5460', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5461, 'ITEM #5461__ITEM #5461', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5462, 'ITEM #5462__ITEM #5462', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5463, 'ITEM #5463__ITEM #5463', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5464, 'ITEM #5464__ITEM #5464', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5465, 'ITEM #5465__ITEM #5465', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5466, 'ITEM #5466__ITEM #5466', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5467, 'ITEM #5467__ITEM #5467', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5468, 'ITEM #5468__ITEM #5468', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5469, 'ITEM #5469__ITEM #5469', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5470, 'ITEM #5470__ITEM #5470', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5471, 'ITEM #5471__ITEM #5471', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5472, 'ITEM #5472__ITEM #5472', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5473, 'ITEM #5473__ITEM #5473', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5474, 'ITEM #5474__ITEM #5474', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5475, 'ITEM #5475__ITEM #5475', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5476, 'ITEM #5476__ITEM #5476', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5477, 'ITEM #5477__ITEM #5477', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5478, 'ITEM #5478__ITEM #5478', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5479, 'ITEM #5479__ITEM #5479', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5480, 'ITEM #5480__ITEM #5480', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5481, 'ITEM #5481__ITEM #5481', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5482, 'ITEM #5482__ITEM #5482', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5483, 'ITEM #5483__ITEM #5483', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5484, 'ITEM #5484__ITEM #5484', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5485, 'ITEM #5485__ITEM #5485', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5486, 'ITEM #5486__ITEM #5486', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5487, 'ITEM #5487__ITEM #5487', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5488, 'ITEM #5488__ITEM #5488', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5489, 'ITEM #5489__ITEM #5489', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5490, 'ITEM #5490__ITEM #5490', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5491, 'ITEM #5491__ITEM #5491', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5492, 'ITEM #5492__ITEM #5492', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5493, 'ITEM #5493__ITEM #5493', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5494, 'ITEM #5494__ITEM #5494', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5495, 'ITEM #5495__ITEM #5495', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5496, 'ITEM #5496__ITEM #5496', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5497, 'ITEM #5497__ITEM #5497', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5498, 'ITEM #5498__ITEM #5498', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5499, 'ITEM #5499__ITEM #5499', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5500, 'ITEM #5500__ITEM #5500', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5501, 'ITEM #5501__ITEM #5501', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5502, 'ITEM #5502__ITEM #5502', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5503, 'ITEM #5503__ITEM #5503', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5504, 'ITEM #5504__ITEM #5504', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5505, 'ITEM #5505__ITEM #5505', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5506, 'ITEM #5506__ITEM #5506', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5507, 'ITEM #5507__ITEM #5507', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5508, 'ITEM #5508__ITEM #5508', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5509, 'ITEM #5509__ITEM #5509', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5510, 'ITEM #5510__ITEM #5510', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5511, 'ITEM #5511__ITEM #5511', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5512, 'ITEM #5512__ITEM #5512', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5513, 'ITEM #5513__ITEM #5513', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5514, 'ITEM #5514__ITEM #5514', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5515, 'ITEM #5515__ITEM #5515', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5516, 'ITEM #5516__ITEM #5516', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5517, 'ITEM #5517__ITEM #5517', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5518, 'ITEM #5518__ITEM #5518', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5519, 'ITEM #5519__ITEM #5519', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5520, 'ITEM #5520__ITEM #5520', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5521, 'ITEM #5521__ITEM #5521', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5522, 'ITEM #5522__ITEM #5522', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5523, 'ITEM #5523__ITEM #5523', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5524, 'ITEM #5524__ITEM #5524', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5525, 'ITEM #5525__ITEM #5525', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5526, 'ITEM #5526__ITEM #5526', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5527, 'ITEM #5527__ITEM #5527', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5528, 'ITEM #5528__ITEM #5528', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5529, 'ITEM #5529__ITEM #5529', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5530, 'ITEM #5530__ITEM #5530', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5531, 'ITEM #5531__ITEM #5531', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5532, 'ITEM #5532__ITEM #5532', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5533, 'ITEM #5533__ITEM #5533', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5534, 'ITEM #5534__ITEM #5534', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5535, 'ITEM #5535__ITEM #5535', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5536, 'ITEM #5536__ITEM #5536', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5537, 'ITEM #5537__ITEM #5537', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5538, 'ITEM #5538__ITEM #5538', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5539, 'ITEM #5539__ITEM #5539', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5540, 'ITEM #5540__ITEM #5540', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5541, 'ITEM #5541__ITEM #5541', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5542, 'ITEM #5542__ITEM #5542', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5543, 'ITEM #5543__ITEM #5543', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5544, 'ITEM #5544__ITEM #5544', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5545, 'ITEM #5545__ITEM #5545', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5546, 'ITEM #5546__ITEM #5546', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5547, 'ITEM #5547__ITEM #5547', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5548, 'ITEM #5548__ITEM #5548', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5549, 'ITEM #5549__ITEM #5549', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5550, 'ITEM #5550__ITEM #5550', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5551, 'ITEM #5551__ITEM #5551', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5552, 'ITEM #5552__ITEM #5552', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5553, 'ITEM #5553__ITEM #5553', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5554, 'ITEM #5554__ITEM #5554', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5555, 'ITEM #5555__ITEM #5555', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5556, 'ITEM #5556__ITEM #5556', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5557, 'ITEM #5557__ITEM #5557', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5558, 'ITEM #5558__ITEM #5558', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5559, 'ITEM #5559__ITEM #5559', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5560, 'ITEM #5560__ITEM #5560', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5561, 'ITEM #5561__ITEM #5561', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5562, 'ITEM #5562__ITEM #5562', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5563, 'ITEM #5563__ITEM #5563', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5564, 'ITEM #5564__ITEM #5564', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5565, 'ITEM #5565__ITEM #5565', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5566, 'ITEM #5566__ITEM #5566', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5567, 'ITEM #5567__ITEM #5567', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5568, 'ITEM #5568__ITEM #5568', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5569, 'ITEM #5569__ITEM #5569', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5570, 'ITEM #5570__ITEM #5570', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5571, 'ITEM #5571__ITEM #5571', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5572, 'ITEM #5572__ITEM #5572', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5573, 'ITEM #5573__ITEM #5573', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5574, 'ITEM #5574__ITEM #5574', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5575, 'ITEM #5575__ITEM #5575', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5576, 'ITEM #5576__ITEM #5576', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5577, 'ITEM #5577__ITEM #5577', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5578, 'ITEM #5578__ITEM #5578', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5579, 'ITEM #5579__ITEM #5579', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5580, 'ITEM #5580__ITEM #5580', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5581, 'ITEM #5581__ITEM #5581', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5582, 'ITEM #5582__ITEM #5582', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5583, 'ITEM #5583__ITEM #5583', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5584, 'ITEM #5584__ITEM #5584', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5585, 'ITEM #5585__ITEM #5585', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5586, 'ITEM #5586__ITEM #5586', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5587, 'ITEM #5587__ITEM #5587', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5588, 'ITEM #5588__ITEM #5588', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5589, 'ITEM #5589__ITEM #5589', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5590, 'ITEM #5590__ITEM #5590', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5591, 'ITEM #5591__ITEM #5591', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5592, 'ITEM #5592__ITEM #5592', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5593, 'ITEM #5593__ITEM #5593', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5594, 'ITEM #5594__ITEM #5594', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5595, 'ITEM #5595__ITEM #5595', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5596, 'ITEM #5596__ITEM #5596', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5597, 'ITEM #5597__ITEM #5597', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5598, 'ITEM #5598__ITEM #5598', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5599, 'ITEM #5599__ITEM #5599', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5600, 'ITEM #5600__ITEM #5600', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5601, 'ITEM #5601__ITEM #5601', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5602, 'ITEM #5602__ITEM #5602', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5603, 'ITEM #5603__ITEM #5603', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5604, 'ITEM #5604__ITEM #5604', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5605, 'ITEM #5605__ITEM #5605', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5606, 'ITEM #5606__ITEM #5606', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5607, 'ITEM #5607__ITEM #5607', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5608, 'ITEM #5608__ITEM #5608', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5609, 'ITEM #5609__ITEM #5609', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5610, 'ITEM #5610__ITEM #5610', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5611, 'ITEM #5611__ITEM #5611', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5612, 'ITEM #5612__ITEM #5612', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5613, 'ITEM #5613__ITEM #5613', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5614, 'ITEM #5614__ITEM #5614', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5615, 'ITEM #5615__ITEM #5615', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5616, 'ITEM #5616__ITEM #5616', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5617, 'ITEM #5617__ITEM #5617', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5618, 'ITEM #5618__ITEM #5618', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5619, 'ITEM #5619__ITEM #5619', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5620, 'ITEM #5620__ITEM #5620', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5621, 'ITEM #5621__ITEM #5621', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5622, 'ITEM #5622__ITEM #5622', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5623, 'ITEM #5623__ITEM #5623', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5624, 'ITEM #5624__ITEM #5624', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5625, 'ITEM #5625__ITEM #5625', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5626, 'ITEM #5626__ITEM #5626', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5627, 'ITEM #5627__ITEM #5627', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5628, 'ITEM #5628__ITEM #5628', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5629, 'ITEM #5629__ITEM #5629', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5630, 'ITEM #5630__ITEM #5630', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5631, 'ITEM #5631__ITEM #5631', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5632, 'ITEM #5632__ITEM #5632', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5633, 'ITEM #5633__ITEM #5633', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5634, 'ITEM #5634__ITEM #5634', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5635, 'ITEM #5635__ITEM #5635', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5636, 'ITEM #5636__ITEM #5636', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5637, 'ITEM #5637__ITEM #5637', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5638, 'ITEM #5638__ITEM #5638', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5639, 'ITEM #5639__ITEM #5639', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5640, 'ITEM #5640__ITEM #5640', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5641, 'ITEM #5641__ITEM #5641', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5642, 'ITEM #5642__ITEM #5642', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5643, 'ITEM #5643__ITEM #5643', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5644, 'ITEM #5644__ITEM #5644', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5645, 'ITEM #5645__ITEM #5645', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5646, 'ITEM #5646__ITEM #5646', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5647, 'ITEM #5647__ITEM #5647', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5648, 'ITEM #5648__ITEM #5648', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5649, 'ITEM #5649__ITEM #5649', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5650, 'ITEM #5650__ITEM #5650', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5651, 'ITEM #5651__ITEM #5651', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5652, 'ITEM #5652__ITEM #5652', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5653, 'ITEM #5653__ITEM #5653', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5654, 'ITEM #5654__ITEM #5654', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5655, 'ITEM #5655__ITEM #5655', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5656, 'ITEM #5656__ITEM #5656', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5657, 'ITEM #5657__ITEM #5657', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5658, 'ITEM #5658__ITEM #5658', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5659, 'ITEM #5659__ITEM #5659', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5660, 'ITEM #5660__ITEM #5660', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5661, 'ITEM #5661__ITEM #5661', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5662, 'ITEM #5662__ITEM #5662', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5663, 'ITEM #5663__ITEM #5663', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5664, 'ITEM #5664__ITEM #5664', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5665, 'ITEM #5665__ITEM #5665', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5666, 'ITEM #5666__ITEM #5666', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5667, 'ITEM #5667__ITEM #5667', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5668, 'ITEM #5668__ITEM #5668', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5669, 'ITEM #5669__ITEM #5669', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5670, 'ITEM #5670__ITEM #5670', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5671, 'ITEM #5671__ITEM #5671', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5672, 'ITEM #5672__ITEM #5672', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5673, 'ITEM #5673__ITEM #5673', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5674, 'ITEM #5674__ITEM #5674', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5675, 'ITEM #5675__ITEM #5675', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5676, 'ITEM #5676__ITEM #5676', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5677, 'ITEM #5677__ITEM #5677', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5678, 'ITEM #5678__ITEM #5678', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5679, 'ITEM #5679__ITEM #5679', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5680, 'ITEM #5680__ITEM #5680', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5681, 'ITEM #5681__ITEM #5681', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5682, 'ITEM #5682__ITEM #5682', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5683, 'ITEM #5683__ITEM #5683', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5684, 'ITEM #5684__ITEM #5684', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5685, 'ITEM #5685__ITEM #5685', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5686, 'ITEM #5686__ITEM #5686', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5687, 'ITEM #5687__ITEM #5687', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5688, 'ITEM #5688__ITEM #5688', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5689, 'ITEM #5689__ITEM #5689', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5690, 'ITEM #5690__ITEM #5690', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5691, 'ITEM #5691__ITEM #5691', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5692, 'ITEM #5692__ITEM #5692', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5693, 'ITEM #5693__ITEM #5693', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5694, 'ITEM #5694__ITEM #5694', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5695, 'ITEM #5695__ITEM #5695', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5696, 'ITEM #5696__ITEM #5696', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5697, 'ITEM #5697__ITEM #5697', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5698, 'ITEM #5698__ITEM #5698', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5699, 'ITEM #5699__ITEM #5699', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5700, 'ITEM #5700__ITEM #5700', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5701, 'ITEM #5701__ITEM #5701', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5702, 'ITEM #5702__ITEM #5702', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5703, 'ITEM #5703__ITEM #5703', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5704, 'ITEM #5704__ITEM #5704', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5705, 'ITEM #5705__ITEM #5705', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5706, 'ITEM #5706__ITEM #5706', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5707, 'ITEM #5707__ITEM #5707', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5708, 'ITEM #5708__ITEM #5708', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5709, 'ITEM #5709__ITEM #5709', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5710, 'ITEM #5710__ITEM #5710', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5711, 'ITEM #5711__ITEM #5711', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5712, 'ITEM #5712__ITEM #5712', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5713, 'ITEM #5713__ITEM #5713', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5714, 'ITEM #5714__ITEM #5714', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5715, 'ITEM #5715__ITEM #5715', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5716, 'ITEM #5716__ITEM #5716', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5717, 'ITEM #5717__ITEM #5717', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5718, 'ITEM #5718__ITEM #5718', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5719, 'ITEM #5719__ITEM #5719', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5720, 'ITEM #5720__ITEM #5720', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5721, 'ITEM #5721__ITEM #5721', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5722, 'ITEM #5722__ITEM #5722', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5723, 'ITEM #5723__ITEM #5723', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5724, 'ITEM #5724__ITEM #5724', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5725, 'ITEM #5725__ITEM #5725', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5726, 'ITEM #5726__ITEM #5726', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5727, 'ITEM #5727__ITEM #5727', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5728, 'ITEM #5728__ITEM #5728', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5729, 'ITEM #5729__ITEM #5729', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5730, 'ITEM #5730__ITEM #5730', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5731, 'ITEM #5731__ITEM #5731', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5732, 'ITEM #5732__ITEM #5732', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5733, 'ITEM #5733__ITEM #5733', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5734, 'ITEM #5734__ITEM #5734', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5735, 'ITEM #5735__ITEM #5735', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5736, 'ITEM #5736__ITEM #5736', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5737, 'ITEM #5737__ITEM #5737', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5738, 'ITEM #5738__ITEM #5738', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5739, 'ITEM #5739__ITEM #5739', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5740, 'ITEM #5740__ITEM #5740', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5741, 'ITEM #5741__ITEM #5741', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5742, 'ITEM #5742__ITEM #5742', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5743, 'ITEM #5743__ITEM #5743', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5744, 'ITEM #5744__ITEM #5744', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5745, 'ITEM #5745__ITEM #5745', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5746, 'ITEM #5746__ITEM #5746', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5747, 'ITEM #5747__ITEM #5747', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5748, 'ITEM #5748__ITEM #5748', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5749, 'ITEM #5749__ITEM #5749', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5750, 'ITEM #5750__ITEM #5750', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5751, 'ITEM #5751__ITEM #5751', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5752, 'ITEM #5752__ITEM #5752', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5753, 'ITEM #5753__ITEM #5753', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5754, 'ITEM #5754__ITEM #5754', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5755, 'ITEM #5755__ITEM #5755', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5756, 'ITEM #5756__ITEM #5756', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5757, 'ITEM #5757__ITEM #5757', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5758, 'ITEM #5758__ITEM #5758', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5759, 'ITEM #5759__ITEM #5759', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5760, 'ITEM #5760__ITEM #5760', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5761, 'ITEM #5761__ITEM #5761', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5762, 'ITEM #5762__ITEM #5762', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5763, 'ITEM #5763__ITEM #5763', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5764, 'ITEM #5764__ITEM #5764', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5765, 'ITEM #5765__ITEM #5765', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5766, 'ITEM #5766__ITEM #5766', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5767, 'ITEM #5767__ITEM #5767', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5768, 'ITEM #5768__ITEM #5768', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5769, 'ITEM #5769__ITEM #5769', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5770, 'ITEM #5770__ITEM #5770', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5771, 'ITEM #5771__ITEM #5771', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5772, 'ITEM #5772__ITEM #5772', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5773, 'ITEM #5773__ITEM #5773', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5774, 'ITEM #5774__ITEM #5774', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5775, 'ITEM #5775__ITEM #5775', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5776, 'ITEM #5776__ITEM #5776', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5777, 'ITEM #5777__ITEM #5777', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5778, 'ITEM #5778__ITEM #5778', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5779, 'ITEM #5779__ITEM #5779', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5780, 'ITEM #5780__ITEM #5780', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5781, 'ITEM #5781__ITEM #5781', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5782, 'ITEM #5782__ITEM #5782', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5783, 'ITEM #5783__ITEM #5783', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5784, 'ITEM #5784__ITEM #5784', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5785, 'ITEM #5785__ITEM #5785', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5786, 'ITEM #5786__ITEM #5786', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5787, 'ITEM #5787__ITEM #5787', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5788, 'ITEM #5788__ITEM #5788', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5789, 'ITEM #5789__ITEM #5789', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5790, 'ITEM #5790__ITEM #5790', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5791, 'ITEM #5791__ITEM #5791', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5792, 'ITEM #5792__ITEM #5792', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5793, 'ITEM #5793__ITEM #5793', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5794, 'ITEM #5794__ITEM #5794', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5795, 'ITEM #5795__ITEM #5795', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5796, 'ITEM #5796__ITEM #5796', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5797, 'ITEM #5797__ITEM #5797', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5798, 'ITEM #5798__ITEM #5798', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5799, 'ITEM #5799__ITEM #5799', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5800, 'ITEM #5800__ITEM #5800', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5801, 'ITEM #5801__ITEM #5801', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5802, 'ITEM #5802__ITEM #5802', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5803, 'ITEM #5803__ITEM #5803', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5804, 'ITEM #5804__ITEM #5804', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5805, 'ITEM #5805__ITEM #5805', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5806, 'ITEM #5806__ITEM #5806', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5807, 'ITEM #5807__ITEM #5807', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5808, 'ITEM #5808__ITEM #5808', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5809, 'ITEM #5809__ITEM #5809', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5810, 'ITEM #5810__ITEM #5810', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5811, 'ITEM #5811__ITEM #5811', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5812, 'ITEM #5812__ITEM #5812', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5813, 'ITEM #5813__ITEM #5813', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5814, 'ITEM #5814__ITEM #5814', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5815, 'ITEM #5815__ITEM #5815', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5816, 'ITEM #5816__ITEM #5816', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5817, 'ITEM #5817__ITEM #5817', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5818, 'ITEM #5818__ITEM #5818', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5819, 'ITEM #5819__ITEM #5819', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5820, 'ITEM #5820__ITEM #5820', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5821, 'ITEM #5821__ITEM #5821', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5822, 'ITEM #5822__ITEM #5822', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5823, 'ITEM #5823__ITEM #5823', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5824, 'ITEM #5824__ITEM #5824', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5825, 'ITEM #5825__ITEM #5825', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5826, 'ITEM #5826__ITEM #5826', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5827, 'ITEM #5827__ITEM #5827', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5828, 'ITEM #5828__ITEM #5828', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5829, 'ITEM #5829__ITEM #5829', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5830, 'ITEM #5830__ITEM #5830', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5831, 'ITEM #5831__ITEM #5831', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5832, 'ITEM #5832__ITEM #5832', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5833, 'ITEM #5833__ITEM #5833', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5834, 'ITEM #5834__ITEM #5834', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5835, 'ITEM #5835__ITEM #5835', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5836, 'ITEM #5836__ITEM #5836', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5837, 'ITEM #5837__ITEM #5837', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5838, 'ITEM #5838__ITEM #5838', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5839, 'ITEM #5839__ITEM #5839', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5840, 'ITEM #5840__ITEM #5840', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5841, 'ITEM #5841__ITEM #5841', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5842, 'ITEM #5842__ITEM #5842', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5843, 'ITEM #5843__ITEM #5843', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5844, 'ITEM #5844__ITEM #5844', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5845, 'ITEM #5845__ITEM #5845', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5846, 'ITEM #5846__ITEM #5846', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5847, 'ITEM #5847__ITEM #5847', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5848, 'ITEM #5848__ITEM #5848', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5849, 'ITEM #5849__ITEM #5849', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5850, 'ITEM #5850__ITEM #5850', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5851, 'ITEM #5851__ITEM #5851', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5852, 'ITEM #5852__ITEM #5852', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5853, 'ITEM #5853__ITEM #5853', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5854, 'ITEM #5854__ITEM #5854', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5855, 'ITEM #5855__ITEM #5855', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5856, 'ITEM #5856__ITEM #5856', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5857, 'ITEM #5857__ITEM #5857', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5858, 'ITEM #5858__ITEM #5858', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5859, 'ITEM #5859__ITEM #5859', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5860, 'ITEM #5860__ITEM #5860', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5861, 'ITEM #5861__ITEM #5861', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5862, 'ITEM #5862__ITEM #5862', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5863, 'ITEM #5863__ITEM #5863', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5864, 'ITEM #5864__ITEM #5864', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5865, 'ITEM #5865__ITEM #5865', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5866, 'ITEM #5866__ITEM #5866', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5867, 'ITEM #5867__ITEM #5867', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5868, 'ITEM #5868__ITEM #5868', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5869, 'ITEM #5869__ITEM #5869', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5870, 'ITEM #5870__ITEM #5870', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5871, 'ITEM #5871__ITEM #5871', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5872, 'ITEM #5872__ITEM #5872', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5873, 'ITEM #5873__ITEM #5873', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5874, 'ITEM #5874__ITEM #5874', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5875, 'ITEM #5875__ITEM #5875', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5876, 'ITEM #5876__ITEM #5876', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5877, 'ITEM #5877__ITEM #5877', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5878, 'ITEM #5878__ITEM #5878', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5879, 'ITEM #5879__ITEM #5879', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5880, 'ITEM #5880__ITEM #5880', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5881, 'ITEM #5881__ITEM #5881', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5882, 'ITEM #5882__ITEM #5882', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5883, 'ITEM #5883__ITEM #5883', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5884, 'ITEM #5884__ITEM #5884', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5885, 'ITEM #5885__ITEM #5885', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5886, 'ITEM #5886__ITEM #5886', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5887, 'ITEM #5887__ITEM #5887', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5888, 'ITEM #5888__ITEM #5888', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5889, 'ITEM #5889__ITEM #5889', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5890, 'ITEM #5890__ITEM #5890', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5891, 'ITEM #5891__ITEM #5891', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5892, 'ITEM #5892__ITEM #5892', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5893, 'ITEM #5893__ITEM #5893', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5894, 'ITEM #5894__ITEM #5894', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5895, 'ITEM #5895__ITEM #5895', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5896, 'ITEM #5896__ITEM #5896', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5897, 'ITEM #5897__ITEM #5897', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5898, 'ITEM #5898__ITEM #5898', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5899, 'ITEM #5899__ITEM #5899', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5900, 'ITEM #5900__ITEM #5900', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5901, 'ITEM #5901__ITEM #5901', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5902, 'ITEM #5902__ITEM #5902', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5903, 'ITEM #5903__ITEM #5903', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5904, 'ITEM #5904__ITEM #5904', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5905, 'ITEM #5905__ITEM #5905', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5906, 'ITEM #5906__ITEM #5906', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5907, 'ITEM #5907__ITEM #5907', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5908, 'ITEM #5908__ITEM #5908', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5909, 'ITEM #5909__ITEM #5909', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5910, 'ITEM #5910__ITEM #5910', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5911, 'ITEM #5911__ITEM #5911', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5912, 'ITEM #5912__ITEM #5912', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5913, 'ITEM #5913__ITEM #5913', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5914, 'ITEM #5914__ITEM #5914', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5915, 'ITEM #5915__ITEM #5915', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5916, 'ITEM #5916__ITEM #5916', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5917, 'ITEM #5917__ITEM #5917', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5918, 'ITEM #5918__ITEM #5918', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5919, 'ITEM #5919__ITEM #5919', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5920, 'ITEM #5920__ITEM #5920', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5921, 'ITEM #5921__ITEM #5921', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5922, 'ITEM #5922__ITEM #5922', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5923, 'ITEM #5923__ITEM #5923', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5924, 'ITEM #5924__ITEM #5924', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5925, 'ITEM #5925__ITEM #5925', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5926, 'ITEM #5926__ITEM #5926', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5927, 'ITEM #5927__ITEM #5927', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5928, 'ITEM #5928__ITEM #5928', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5929, 'ITEM #5929__ITEM #5929', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5930, 'ITEM #5930__ITEM #5930', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5931, 'ITEM #5931__ITEM #5931', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5932, 'ITEM #5932__ITEM #5932', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5933, 'ITEM #5933__ITEM #5933', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5934, 'ITEM #5934__ITEM #5934', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5935, 'ITEM #5935__ITEM #5935', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5936, 'ITEM #5936__ITEM #5936', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5937, 'ITEM #5937__ITEM #5937', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5938, 'ITEM #5938__ITEM #5938', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5939, 'ITEM #5939__ITEM #5939', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5940, 'ITEM #5940__ITEM #5940', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5941, 'ITEM #5941__ITEM #5941', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5942, 'ITEM #5942__ITEM #5942', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5943, 'ITEM #5943__ITEM #5943', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5944, 'ITEM #5944__ITEM #5944', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5945, 'ITEM #5945__ITEM #5945', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5946, 'ITEM #5946__ITEM #5946', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5947, 'ITEM #5947__ITEM #5947', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5948, 'ITEM #5948__ITEM #5948', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5949, 'ITEM #5949__ITEM #5949', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5950, 'ITEM #5950__ITEM #5950', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5951, 'ITEM #5951__ITEM #5951', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5952, 'ITEM #5952__ITEM #5952', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5953, 'ITEM #5953__ITEM #5953', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5954, 'ITEM #5954__ITEM #5954', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5955, 'ITEM #5955__ITEM #5955', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5956, 'ITEM #5956__ITEM #5956', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5957, 'ITEM #5957__ITEM #5957', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5958, 'ITEM #5958__ITEM #5958', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5959, 'ITEM #5959__ITEM #5959', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5960, 'ITEM #5960__ITEM #5960', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5961, 'ITEM #5961__ITEM #5961', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5962, 'ITEM #5962__ITEM #5962', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5963, 'ITEM #5963__ITEM #5963', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5964, 'ITEM #5964__ITEM #5964', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5965, 'ITEM #5965__ITEM #5965', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5966, 'ITEM #5966__ITEM #5966', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5967, 'ITEM #5967__ITEM #5967', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5968, 'ITEM #5968__ITEM #5968', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5969, 'ITEM #5969__ITEM #5969', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5970, 'ITEM #5970__ITEM #5970', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5971, 'ITEM #5971__ITEM #5971', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5972, 'ITEM #5972__ITEM #5972', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5973, 'ITEM #5973__ITEM #5973', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5974, 'ITEM #5974__ITEM #5974', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5975, 'ITEM #5975__ITEM #5975', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5976, 'ITEM #5976__ITEM #5976', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5977, 'ITEM #5977__ITEM #5977', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5978, 'ITEM #5978__ITEM #5978', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5979, 'ITEM #5979__ITEM #5979', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5980, 'ITEM #5980__ITEM #5980', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5981, 'ITEM #5981__ITEM #5981', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5982, 'ITEM #5982__ITEM #5982', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5983, 'ITEM #5983__ITEM #5983', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5984, 'ITEM #5984__ITEM #5984', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5985, 'ITEM #5985__ITEM #5985', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5986, 'ITEM #5986__ITEM #5986', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5987, 'ITEM #5987__ITEM #5987', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5988, 'ITEM #5988__ITEM #5988', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5989, 'ITEM #5989__ITEM #5989', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5990, 'ITEM #5990__ITEM #5990', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5991, 'ITEM #5991__ITEM #5991', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5992, 'ITEM #5992__ITEM #5992', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5993, 'ITEM #5993__ITEM #5993', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5994, 'ITEM #5994__ITEM #5994', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5995, 'ITEM #5995__ITEM #5995', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5996, 'ITEM #5996__ITEM #5996', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5997, 'ITEM #5997__ITEM #5997', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5998, 'ITEM #5998__ITEM #5998', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (5999, 'ITEM #5999__ITEM #5999', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6000, 'ITEM #6000__ITEM #6000', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6001, 'ITEM #6001__ITEM #6001', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6002, 'ITEM #6002__ITEM #6002', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6003, 'ITEM #6003__ITEM #6003', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6004, 'ITEM #6004__ITEM #6004', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6005, 'ITEM #6005__ITEM #6005', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6006, 'ITEM #6006__ITEM #6006', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6007, 'ITEM #6007__ITEM #6007', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6008, 'ITEM #6008__ITEM #6008', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6009, 'ITEM #6009__ITEM #6009', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6010, 'ITEM #6010__ITEM #6010', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6011, 'ITEM #6011__ITEM #6011', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6012, 'ITEM #6012__ITEM #6012', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6013, 'ITEM #6013__ITEM #6013', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6014, 'ITEM #6014__ITEM #6014', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6015, 'ITEM #6015__ITEM #6015', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6016, 'ITEM #6016__ITEM #6016', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6017, 'ITEM #6017__ITEM #6017', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6018, 'ITEM #6018__ITEM #6018', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6019, 'ITEM #6019__ITEM #6019', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6020, 'ITEM #6020__ITEM #6020', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6021, 'ITEM #6021__ITEM #6021', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6022, 'ITEM #6022__ITEM #6022', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6023, 'ITEM #6023__ITEM #6023', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6024, 'ITEM #6024__ITEM #6024', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6025, 'ITEM #6025__ITEM #6025', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6026, 'ITEM #6026__ITEM #6026', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6027, 'ITEM #6027__ITEM #6027', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6028, 'ITEM #6028__ITEM #6028', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6029, 'ITEM #6029__ITEM #6029', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6030, 'ITEM #6030__ITEM #6030', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6031, 'ITEM #6031__ITEM #6031', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6032, 'ITEM #6032__ITEM #6032', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6033, 'ITEM #6033__ITEM #6033', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6034, 'ITEM #6034__ITEM #6034', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6035, 'ITEM #6035__ITEM #6035', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6036, 'ITEM #6036__ITEM #6036', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6037, 'ITEM #6037__ITEM #6037', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6038, 'ITEM #6038__ITEM #6038', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6039, 'ITEM #6039__ITEM #6039', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6040, 'ITEM #6040__ITEM #6040', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6041, 'ITEM #6041__ITEM #6041', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6042, 'ITEM #6042__ITEM #6042', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6043, 'ITEM #6043__ITEM #6043', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6044, 'ITEM #6044__ITEM #6044', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6045, 'ITEM #6045__ITEM #6045', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6046, 'ITEM #6046__ITEM #6046', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6047, 'ITEM #6047__ITEM #6047', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6048, 'ITEM #6048__ITEM #6048', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6049, 'ITEM #6049__ITEM #6049', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6050, 'ITEM #6050__ITEM #6050', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6051, 'ITEM #6051__ITEM #6051', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6052, 'ITEM #6052__ITEM #6052', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6053, 'ITEM #6053__ITEM #6053', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6054, 'ITEM #6054__ITEM #6054', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6055, 'ITEM #6055__ITEM #6055', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6056, 'ITEM #6056__ITEM #6056', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6057, 'ITEM #6057__ITEM #6057', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6058, 'ITEM #6058__ITEM #6058', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6059, 'ITEM #6059__ITEM #6059', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6060, 'ITEM #6060__ITEM #6060', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6061, 'ITEM #6061__ITEM #6061', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6062, 'ITEM #6062__ITEM #6062', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6063, 'ITEM #6063__ITEM #6063', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6064, 'ITEM #6064__ITEM #6064', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6065, 'ITEM #6065__ITEM #6065', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6066, 'ITEM #6066__ITEM #6066', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6067, 'ITEM #6067__ITEM #6067', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6068, 'ITEM #6068__ITEM #6068', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6069, 'ITEM #6069__ITEM #6069', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6070, 'ITEM #6070__ITEM #6070', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6071, 'ITEM #6071__ITEM #6071', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6072, 'ITEM #6072__ITEM #6072', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6073, 'ITEM #6073__ITEM #6073', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6074, 'ITEM #6074__ITEM #6074', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6075, 'ITEM #6075__ITEM #6075', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6076, 'ITEM #6076__ITEM #6076', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6077, 'ITEM #6077__ITEM #6077', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6078, 'ITEM #6078__ITEM #6078', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6079, 'ITEM #6079__ITEM #6079', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6080, 'ITEM #6080__ITEM #6080', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6081, 'ITEM #6081__ITEM #6081', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6082, 'ITEM #6082__ITEM #6082', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6083, 'ITEM #6083__ITEM #6083', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6084, 'ITEM #6084__ITEM #6084', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6085, 'ITEM #6085__ITEM #6085', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6086, 'ITEM #6086__ITEM #6086', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6087, 'ITEM #6087__ITEM #6087', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6088, 'ITEM #6088__ITEM #6088', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6089, 'ITEM #6089__ITEM #6089', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6090, 'ITEM #6090__ITEM #6090', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6091, 'ITEM #6091__ITEM #6091', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6092, 'ITEM #6092__ITEM #6092', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6093, 'ITEM #6093__ITEM #6093', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6094, 'ITEM #6094__ITEM #6094', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6095, 'ITEM #6095__ITEM #6095', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6096, 'ITEM #6096__ITEM #6096', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6097, 'ITEM #6097__ITEM #6097', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6098, 'ITEM #6098__ITEM #6098', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6099, 'ITEM #6099__ITEM #6099', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6100, 'ITEM #6100__ITEM #6100', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6101, 'ITEM #6101__ITEM #6101', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6102, 'ITEM #6102__ITEM #6102', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6103, 'ITEM #6103__ITEM #6103', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6104, 'ITEM #6104__ITEM #6104', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6105, 'ITEM #6105__ITEM #6105', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6106, 'ITEM #6106__ITEM #6106', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6107, 'ITEM #6107__ITEM #6107', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6108, 'ITEM #6108__ITEM #6108', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6109, 'ITEM #6109__ITEM #6109', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6110, 'ITEM #6110__ITEM #6110', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6111, 'ITEM #6111__ITEM #6111', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6112, 'ITEM #6112__ITEM #6112', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6113, 'ITEM #6113__ITEM #6113', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6114, 'ITEM #6114__ITEM #6114', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6115, 'ITEM #6115__ITEM #6115', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6116, 'ITEM #6116__ITEM #6116', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6117, 'ITEM #6117__ITEM #6117', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6118, 'ITEM #6118__ITEM #6118', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6119, 'ITEM #6119__ITEM #6119', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6120, 'ITEM #6120__ITEM #6120', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6121, 'ITEM #6121__ITEM #6121', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6122, 'ITEM #6122__ITEM #6122', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6123, 'ITEM #6123__ITEM #6123', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6124, 'ITEM #6124__ITEM #6124', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6125, 'ITEM #6125__ITEM #6125', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6126, 'ITEM #6126__ITEM #6126', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6127, 'ITEM #6127__ITEM #6127', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6128, 'ITEM #6128__ITEM #6128', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6129, 'ITEM #6129__ITEM #6129', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6130, 'ITEM #6130__ITEM #6130', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6131, 'ITEM #6131__ITEM #6131', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6132, 'ITEM #6132__ITEM #6132', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6133, 'ITEM #6133__ITEM #6133', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6134, 'ITEM #6134__ITEM #6134', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6135, 'ITEM #6135__ITEM #6135', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6136, 'ITEM #6136__ITEM #6136', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6137, 'ITEM #6137__ITEM #6137', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6138, 'ITEM #6138__ITEM #6138', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6139, 'ITEM #6139__ITEM #6139', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6140, 'ITEM #6140__ITEM #6140', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6141, 'ITEM #6141__ITEM #6141', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6142, 'ITEM #6142__ITEM #6142', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6143, 'ITEM #6143__ITEM #6143', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6144, 'ITEM #6144__ITEM #6144', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6145, 'ITEM #6145__ITEM #6145', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6146, 'ITEM #6146__ITEM #6146', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6147, 'ITEM #6147__ITEM #6147', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6148, 'ITEM #6148__ITEM #6148', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6149, 'ITEM #6149__ITEM #6149', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6150, 'ITEM #6150__ITEM #6150', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6151, 'ITEM #6151__ITEM #6151', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6152, 'ITEM #6152__ITEM #6152', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6153, 'ITEM #6153__ITEM #6153', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6154, 'ITEM #6154__ITEM #6154', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6155, 'ITEM #6155__ITEM #6155', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6156, 'ITEM #6156__ITEM #6156', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6157, 'ITEM #6157__ITEM #6157', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6158, 'ITEM #6158__ITEM #6158', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6159, 'ITEM #6159__ITEM #6159', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6160, 'ITEM #6160__ITEM #6160', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6161, 'ITEM #6161__ITEM #6161', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6162, 'ITEM #6162__ITEM #6162', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6163, 'ITEM #6163__ITEM #6163', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6164, 'ITEM #6164__ITEM #6164', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6165, 'ITEM #6165__ITEM #6165', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6166, 'ITEM #6166__ITEM #6166', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6167, 'ITEM #6167__ITEM #6167', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6168, 'ITEM #6168__ITEM #6168', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6169, 'ITEM #6169__ITEM #6169', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6170, 'ITEM #6170__ITEM #6170', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6171, 'ITEM #6171__ITEM #6171', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6172, 'ITEM #6172__ITEM #6172', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6173, 'ITEM #6173__ITEM #6173', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6174, 'ITEM #6174__ITEM #6174', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6175, 'ITEM #6175__ITEM #6175', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6176, 'ITEM #6176__ITEM #6176', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6177, 'ITEM #6177__ITEM #6177', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6178, 'ITEM #6178__ITEM #6178', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6179, 'ITEM #6179__ITEM #6179', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6180, 'ITEM #6180__ITEM #6180', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6181, 'ITEM #6181__ITEM #6181', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6182, 'ITEM #6182__ITEM #6182', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6183, 'ITEM #6183__ITEM #6183', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6184, 'ITEM #6184__ITEM #6184', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6185, 'ITEM #6185__ITEM #6185', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6186, 'ITEM #6186__ITEM #6186', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6187, 'ITEM #6187__ITEM #6187', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6188, 'ITEM #6188__ITEM #6188', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6189, 'ITEM #6189__ITEM #6189', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6190, 'ITEM #6190__ITEM #6190', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6191, 'ITEM #6191__ITEM #6191', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6192, 'ITEM #6192__ITEM #6192', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6193, 'ITEM #6193__ITEM #6193', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6194, 'ITEM #6194__ITEM #6194', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6195, 'ITEM #6195__ITEM #6195', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6196, 'ITEM #6196__ITEM #6196', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6197, 'ITEM #6197__ITEM #6197', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6198, 'ITEM #6198__ITEM #6198', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6199, 'ITEM #6199__ITEM #6199', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6200, 'ITEM #6200__ITEM #6200', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6201, 'ITEM #6201__ITEM #6201', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6202, 'ITEM #6202__ITEM #6202', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6203, 'ITEM #6203__ITEM #6203', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6204, 'ITEM #6204__ITEM #6204', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6205, 'ITEM #6205__ITEM #6205', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6206, 'ITEM #6206__ITEM #6206', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6207, 'ITEM #6207__ITEM #6207', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6208, 'ITEM #6208__ITEM #6208', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6209, 'ITEM #6209__ITEM #6209', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6210, 'ITEM #6210__ITEM #6210', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6211, 'ITEM #6211__ITEM #6211', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6212, 'ITEM #6212__ITEM #6212', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6213, 'ITEM #6213__ITEM #6213', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6214, 'ITEM #6214__ITEM #6214', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6215, 'ITEM #6215__ITEM #6215', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6216, 'ITEM #6216__ITEM #6216', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6217, 'ITEM #6217__ITEM #6217', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6218, 'ITEM #6218__ITEM #6218', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6219, 'ITEM #6219__ITEM #6219', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6220, 'ITEM #6220__ITEM #6220', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6221, 'ITEM #6221__ITEM #6221', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6222, 'ITEM #6222__ITEM #6222', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6223, 'ITEM #6223__ITEM #6223', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6224, 'ITEM #6224__ITEM #6224', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6225, 'ITEM #6225__ITEM #6225', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6226, 'ITEM #6226__ITEM #6226', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6227, 'ITEM #6227__ITEM #6227', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6228, 'ITEM #6228__ITEM #6228', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6229, 'ITEM #6229__ITEM #6229', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6230, 'ITEM #6230__ITEM #6230', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6231, 'ITEM #6231__ITEM #6231', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6232, 'ITEM #6232__ITEM #6232', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6233, 'ITEM #6233__ITEM #6233', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6234, 'ITEM #6234__ITEM #6234', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6235, 'ITEM #6235__ITEM #6235', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6236, 'ITEM #6236__ITEM #6236', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6237, 'ITEM #6237__ITEM #6237', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6238, 'ITEM #6238__ITEM #6238', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6239, 'ITEM #6239__ITEM #6239', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6240, 'ITEM #6240__ITEM #6240', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6241, 'ITEM #6241__ITEM #6241', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6242, 'ITEM #6242__ITEM #6242', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6243, 'ITEM #6243__ITEM #6243', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6244, 'ITEM #6244__ITEM #6244', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6245, 'ITEM #6245__ITEM #6245', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6246, 'ITEM #6246__ITEM #6246', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6247, 'ITEM #6247__ITEM #6247', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6248, 'ITEM #6248__ITEM #6248', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6249, 'ITEM #6249__ITEM #6249', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6250, 'ITEM #6250__ITEM #6250', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6251, 'ITEM #6251__ITEM #6251', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6252, 'ITEM #6252__ITEM #6252', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6253, 'ITEM #6253__ITEM #6253', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6254, 'ITEM #6254__ITEM #6254', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6255, 'ITEM #6255__ITEM #6255', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6256, 'ITEM #6256__ITEM #6256', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6257, 'ITEM #6257__ITEM #6257', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6258, 'ITEM #6258__ITEM #6258', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6259, 'ITEM #6259__ITEM #6259', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6260, 'ITEM #6260__ITEM #6260', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6261, 'ITEM #6261__ITEM #6261', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6262, 'ITEM #6262__ITEM #6262', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6263, 'ITEM #6263__ITEM #6263', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6264, 'ITEM #6264__ITEM #6264', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6265, 'ITEM #6265__ITEM #6265', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6266, 'ITEM #6266__ITEM #6266', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6267, 'ITEM #6267__ITEM #6267', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6268, 'ITEM #6268__ITEM #6268', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6269, 'ITEM #6269__ITEM #6269', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6270, 'ITEM #6270__ITEM #6270', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6271, 'ITEM #6271__ITEM #6271', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6272, 'ITEM #6272__ITEM #6272', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6273, 'ITEM #6273__ITEM #6273', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6274, 'ITEM #6274__ITEM #6274', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6275, 'ITEM #6275__ITEM #6275', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6276, 'ITEM #6276__ITEM #6276', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6277, 'ITEM #6277__ITEM #6277', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6278, 'ITEM #6278__ITEM #6278', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6279, 'ITEM #6279__ITEM #6279', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6280, 'ITEM #6280__ITEM #6280', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6281, 'ITEM #6281__ITEM #6281', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6282, 'ITEM #6282__ITEM #6282', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6283, 'ITEM #6283__ITEM #6283', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6284, 'ITEM #6284__ITEM #6284', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6285, 'ITEM #6285__ITEM #6285', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6286, 'ITEM #6286__ITEM #6286', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6287, 'ITEM #6287__ITEM #6287', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6288, 'ITEM #6288__ITEM #6288', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6289, 'ITEM #6289__ITEM #6289', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6290, 'ITEM #6290__ITEM #6290', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6291, 'ITEM #6291__ITEM #6291', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6292, 'ITEM #6292__ITEM #6292', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6293, 'ITEM #6293__ITEM #6293', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6294, 'ITEM #6294__ITEM #6294', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6295, 'ITEM #6295__ITEM #6295', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6296, 'ITEM #6296__ITEM #6296', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6297, 'ITEM #6297__ITEM #6297', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6298, 'ITEM #6298__ITEM #6298', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6299, 'ITEM #6299__ITEM #6299', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6300, 'ITEM #6300__ITEM #6300', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6301, 'ITEM #6301__ITEM #6301', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6302, 'ITEM #6302__ITEM #6302', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6303, 'ITEM #6303__ITEM #6303', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6304, 'ITEM #6304__ITEM #6304', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6305, 'ITEM #6305__ITEM #6305', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6306, 'ITEM #6306__ITEM #6306', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6307, 'ITEM #6307__ITEM #6307', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6308, 'ITEM #6308__ITEM #6308', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6309, 'ITEM #6309__ITEM #6309', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6310, 'ITEM #6310__ITEM #6310', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6311, 'ITEM #6311__ITEM #6311', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6312, 'ITEM #6312__ITEM #6312', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6313, 'ITEM #6313__ITEM #6313', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6314, 'ITEM #6314__ITEM #6314', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6315, 'ITEM #6315__ITEM #6315', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6316, 'ITEM #6316__ITEM #6316', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6317, 'ITEM #6317__ITEM #6317', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6318, 'ITEM #6318__ITEM #6318', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6319, 'ITEM #6319__ITEM #6319', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6320, 'ITEM #6320__ITEM #6320', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6321, 'ITEM #6321__ITEM #6321', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6322, 'ITEM #6322__ITEM #6322', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6323, 'ITEM #6323__ITEM #6323', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6324, 'ITEM #6324__ITEM #6324', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6325, 'ITEM #6325__ITEM #6325', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6326, 'ITEM #6326__ITEM #6326', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6327, 'ITEM #6327__ITEM #6327', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6328, 'ITEM #6328__ITEM #6328', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6329, 'ITEM #6329__ITEM #6329', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6330, 'ITEM #6330__ITEM #6330', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6331, 'ITEM #6331__ITEM #6331', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6332, 'ITEM #6332__ITEM #6332', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6333, 'ITEM #6333__ITEM #6333', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6334, 'ITEM #6334__ITEM #6334', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6335, 'ITEM #6335__ITEM #6335', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6336, 'ITEM #6336__ITEM #6336', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6337, 'ITEM #6337__ITEM #6337', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6338, 'ITEM #6338__ITEM #6338', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6339, 'ITEM #6339__ITEM #6339', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6340, 'ITEM #6340__ITEM #6340', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6341, 'ITEM #6341__ITEM #6341', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6342, 'ITEM #6342__ITEM #6342', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6343, 'ITEM #6343__ITEM #6343', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6344, 'ITEM #6344__ITEM #6344', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6345, 'ITEM #6345__ITEM #6345', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6346, 'ITEM #6346__ITEM #6346', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6347, 'ITEM #6347__ITEM #6347', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6348, 'ITEM #6348__ITEM #6348', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6349, 'ITEM #6349__ITEM #6349', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6350, 'ITEM #6350__ITEM #6350', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6351, 'ITEM #6351__ITEM #6351', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6352, 'ITEM #6352__ITEM #6352', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6353, 'ITEM #6353__ITEM #6353', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6354, 'ITEM #6354__ITEM #6354', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6355, 'ITEM #6355__ITEM #6355', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6356, 'ITEM #6356__ITEM #6356', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6357, 'ITEM #6357__ITEM #6357', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6358, 'ITEM #6358__ITEM #6358', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6359, 'ITEM #6359__ITEM #6359', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6360, 'ITEM #6360__ITEM #6360', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6361, 'ITEM #6361__ITEM #6361', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6362, 'ITEM #6362__ITEM #6362', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6363, 'ITEM #6363__ITEM #6363', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6364, 'ITEM #6364__ITEM #6364', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6365, 'ITEM #6365__ITEM #6365', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6366, 'ITEM #6366__ITEM #6366', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6367, 'ITEM #6367__ITEM #6367', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6368, 'ITEM #6368__ITEM #6368', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6369, 'ITEM #6369__ITEM #6369', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6370, 'ITEM #6370__ITEM #6370', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6371, 'ITEM #6371__ITEM #6371', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6372, 'ITEM #6372__ITEM #6372', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6373, 'ITEM #6373__ITEM #6373', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6374, 'ITEM #6374__ITEM #6374', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6375, 'ITEM #6375__ITEM #6375', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6376, 'ITEM #6376__ITEM #6376', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6377, 'ITEM #6377__ITEM #6377', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6378, 'ITEM #6378__ITEM #6378', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6379, 'ITEM #6379__ITEM #6379', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6380, 'ITEM #6380__ITEM #6380', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6381, 'ITEM #6381__ITEM #6381', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6382, 'ITEM #6382__ITEM #6382', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6383, 'ITEM #6383__ITEM #6383', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6384, 'ITEM #6384__ITEM #6384', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6385, 'ITEM #6385__ITEM #6385', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6386, 'ITEM #6386__ITEM #6386', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6387, 'ITEM #6387__ITEM #6387', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6388, 'ITEM #6388__ITEM #6388', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6389, 'ITEM #6389__ITEM #6389', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6390, 'ITEM #6390__ITEM #6390', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6391, 'ITEM #6391__ITEM #6391', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6392, 'ITEM #6392__ITEM #6392', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6393, 'ITEM #6393__ITEM #6393', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6394, 'ITEM #6394__ITEM #6394', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6395, 'ITEM #6395__ITEM #6395', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6396, 'ITEM #6396__ITEM #6396', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6397, 'ITEM #6397__ITEM #6397', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6398, 'ITEM #6398__ITEM #6398', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6399, 'ITEM #6399__ITEM #6399', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6400, 'ITEM #6400__ITEM #6400', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6401, 'ITEM #6401__ITEM #6401', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6402, 'ITEM #6402__ITEM #6402', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6403, 'ITEM #6403__ITEM #6403', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6404, 'ITEM #6404__ITEM #6404', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6405, 'ITEM #6405__ITEM #6405', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6406, 'ITEM #6406__ITEM #6406', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6407, 'ITEM #6407__ITEM #6407', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6408, 'ITEM #6408__ITEM #6408', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6409, 'ITEM #6409__ITEM #6409', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6410, 'ITEM #6410__ITEM #6410', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6411, 'ITEM #6411__ITEM #6411', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6412, 'ITEM #6412__ITEM #6412', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6413, 'ITEM #6413__ITEM #6413', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6414, 'ITEM #6414__ITEM #6414', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6415, 'ITEM #6415__ITEM #6415', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6416, 'ITEM #6416__ITEM #6416', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6417, 'ITEM #6417__ITEM #6417', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6418, 'ITEM #6418__ITEM #6418', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6419, 'ITEM #6419__ITEM #6419', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6420, 'ITEM #6420__ITEM #6420', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6421, 'ITEM #6421__ITEM #6421', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6422, 'ITEM #6422__ITEM #6422', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6423, 'ITEM #6423__ITEM #6423', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6424, 'ITEM #6424__ITEM #6424', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6425, 'ITEM #6425__ITEM #6425', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6426, 'ITEM #6426__ITEM #6426', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6427, 'ITEM #6427__ITEM #6427', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6428, 'ITEM #6428__ITEM #6428', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6429, 'ITEM #6429__ITEM #6429', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6430, 'ITEM #6430__ITEM #6430', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6431, 'ITEM #6431__ITEM #6431', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6432, 'ITEM #6432__ITEM #6432', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6433, 'ITEM #6433__ITEM #6433', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6434, 'ITEM #6434__ITEM #6434', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6435, 'ITEM #6435__ITEM #6435', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6436, 'ITEM #6436__ITEM #6436', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6437, 'ITEM #6437__ITEM #6437', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6438, 'ITEM #6438__ITEM #6438', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6439, 'ITEM #6439__ITEM #6439', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6440, 'ITEM #6440__ITEM #6440', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6441, 'ITEM #6441__ITEM #6441', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6442, 'ITEM #6442__ITEM #6442', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6443, 'ITEM #6443__ITEM #6443', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6444, 'ITEM #6444__ITEM #6444', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6445, 'ITEM #6445__ITEM #6445', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6446, 'ITEM #6446__ITEM #6446', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6447, 'ITEM #6447__ITEM #6447', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6448, 'ITEM #6448__ITEM #6448', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6449, 'ITEM #6449__ITEM #6449', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6450, 'ITEM #6450__ITEM #6450', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6451, 'ITEM #6451__ITEM #6451', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6452, 'ITEM #6452__ITEM #6452', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6453, 'ITEM #6453__ITEM #6453', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6454, 'ITEM #6454__ITEM #6454', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6455, 'ITEM #6455__ITEM #6455', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6456, 'ITEM #6456__ITEM #6456', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6457, 'ITEM #6457__ITEM #6457', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6458, 'ITEM #6458__ITEM #6458', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6459, 'ITEM #6459__ITEM #6459', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6460, 'ITEM #6460__ITEM #6460', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6461, 'ITEM #6461__ITEM #6461', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6462, 'ITEM #6462__ITEM #6462', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6463, 'ITEM #6463__ITEM #6463', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6464, 'ITEM #6464__ITEM #6464', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6465, 'ITEM #6465__ITEM #6465', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6466, 'ITEM #6466__ITEM #6466', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6467, 'ITEM #6467__ITEM #6467', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6468, 'ITEM #6468__ITEM #6468', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6469, 'ITEM #6469__ITEM #6469', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6470, 'ITEM #6470__ITEM #6470', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6471, 'ITEM #6471__ITEM #6471', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6472, 'ITEM #6472__ITEM #6472', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6473, 'ITEM #6473__ITEM #6473', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6474, 'ITEM #6474__ITEM #6474', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6475, 'ITEM #6475__ITEM #6475', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6476, 'ITEM #6476__ITEM #6476', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6477, 'ITEM #6477__ITEM #6477', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6478, 'ITEM #6478__ITEM #6478', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6479, 'ITEM #6479__ITEM #6479', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6480, 'ITEM #6480__ITEM #6480', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6481, 'ITEM #6481__ITEM #6481', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6482, 'ITEM #6482__ITEM #6482', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6483, 'ITEM #6483__ITEM #6483', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6484, 'ITEM #6484__ITEM #6484', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6485, 'ITEM #6485__ITEM #6485', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6486, 'ITEM #6486__ITEM #6486', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6487, 'ITEM #6487__ITEM #6487', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6488, 'ITEM #6488__ITEM #6488', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6489, 'ITEM #6489__ITEM #6489', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6490, 'ITEM #6490__ITEM #6490', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6491, 'ITEM #6491__ITEM #6491', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6492, 'ITEM #6492__ITEM #6492', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6493, 'ITEM #6493__ITEM #6493', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6494, 'ITEM #6494__ITEM #6494', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6495, 'ITEM #6495__ITEM #6495', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6496, 'ITEM #6496__ITEM #6496', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6497, 'ITEM #6497__ITEM #6497', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6498, 'ITEM #6498__ITEM #6498', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6499, 'ITEM #6499__ITEM #6499', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6500, 'ITEM #6500__ITEM #6500', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6501, 'ITEM #6501__ITEM #6501', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6502, 'ITEM #6502__ITEM #6502', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6503, 'ITEM #6503__ITEM #6503', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6504, 'ITEM #6504__ITEM #6504', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6505, 'ITEM #6505__ITEM #6505', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6506, 'ITEM #6506__ITEM #6506', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6507, 'ITEM #6507__ITEM #6507', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6508, 'ITEM #6508__ITEM #6508', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6509, 'ITEM #6509__ITEM #6509', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6510, 'ITEM #6510__ITEM #6510', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6511, 'ITEM #6511__ITEM #6511', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6512, 'ITEM #6512__ITEM #6512', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6513, 'ITEM #6513__ITEM #6513', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6514, 'ITEM #6514__ITEM #6514', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6515, 'ITEM #6515__ITEM #6515', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6516, 'ITEM #6516__ITEM #6516', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6517, 'ITEM #6517__ITEM #6517', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6518, 'ITEM #6518__ITEM #6518', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6519, 'ITEM #6519__ITEM #6519', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6520, 'ITEM #6520__ITEM #6520', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6521, 'ITEM #6521__ITEM #6521', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6522, 'ITEM #6522__ITEM #6522', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6523, 'ITEM #6523__ITEM #6523', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6524, 'ITEM #6524__ITEM #6524', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6525, 'ITEM #6525__ITEM #6525', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6526, 'ITEM #6526__ITEM #6526', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6527, 'ITEM #6527__ITEM #6527', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6528, 'ITEM #6528__ITEM #6528', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6529, 'ITEM #6529__ITEM #6529', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6530, 'ITEM #6530__ITEM #6530', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6531, 'ITEM #6531__ITEM #6531', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6532, 'ITEM #6532__ITEM #6532', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6533, 'ITEM #6533__ITEM #6533', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6534, 'ITEM #6534__ITEM #6534', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6535, 'ITEM #6535__ITEM #6535', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6536, 'ITEM #6536__ITEM #6536', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6537, 'ITEM #6537__ITEM #6537', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6538, 'ITEM #6538__ITEM #6538', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6539, 'ITEM #6539__ITEM #6539', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6540, 'ITEM #6540__ITEM #6540', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6541, 'ITEM #6541__ITEM #6541', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6542, 'ITEM #6542__ITEM #6542', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6543, 'ITEM #6543__ITEM #6543', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6544, 'ITEM #6544__ITEM #6544', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6545, 'ITEM #6545__ITEM #6545', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6546, 'ITEM #6546__ITEM #6546', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6547, 'ITEM #6547__ITEM #6547', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6548, 'ITEM #6548__ITEM #6548', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6549, 'ITEM #6549__ITEM #6549', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6550, 'ITEM #6550__ITEM #6550', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6551, 'ITEM #6551__ITEM #6551', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6552, 'ITEM #6552__ITEM #6552', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6553, 'ITEM #6553__ITEM #6553', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6554, 'ITEM #6554__ITEM #6554', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6555, 'ITEM #6555__ITEM #6555', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6556, 'ITEM #6556__ITEM #6556', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6557, 'ITEM #6557__ITEM #6557', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6558, 'ITEM #6558__ITEM #6558', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6559, 'ITEM #6559__ITEM #6559', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6560, 'ITEM #6560__ITEM #6560', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6561, 'ITEM #6561__ITEM #6561', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6562, 'ITEM #6562__ITEM #6562', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6563, 'ITEM #6563__ITEM #6563', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6564, 'ITEM #6564__ITEM #6564', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6565, 'ITEM #6565__ITEM #6565', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6566, 'ITEM #6566__ITEM #6566', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6567, 'ITEM #6567__ITEM #6567', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6568, 'ITEM #6568__ITEM #6568', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6569, 'ITEM #6569__ITEM #6569', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6570, 'ITEM #6570__ITEM #6570', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6571, 'ITEM #6571__ITEM #6571', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6572, 'ITEM #6572__ITEM #6572', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6573, 'ITEM #6573__ITEM #6573', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6574, 'ITEM #6574__ITEM #6574', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6575, 'ITEM #6575__ITEM #6575', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6576, 'ITEM #6576__ITEM #6576', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6577, 'ITEM #6577__ITEM #6577', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6578, 'ITEM #6578__ITEM #6578', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6579, 'ITEM #6579__ITEM #6579', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6580, 'ITEM #6580__ITEM #6580', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6581, 'ITEM #6581__ITEM #6581', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6582, 'ITEM #6582__ITEM #6582', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6583, 'ITEM #6583__ITEM #6583', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6584, 'ITEM #6584__ITEM #6584', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6585, 'ITEM #6585__ITEM #6585', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6586, 'ITEM #6586__ITEM #6586', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6587, 'ITEM #6587__ITEM #6587', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6588, 'ITEM #6588__ITEM #6588', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6589, 'ITEM #6589__ITEM #6589', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6590, 'ITEM #6590__ITEM #6590', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6591, 'ITEM #6591__ITEM #6591', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6592, 'ITEM #6592__ITEM #6592', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6593, 'ITEM #6593__ITEM #6593', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6594, 'ITEM #6594__ITEM #6594', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6595, 'ITEM #6595__ITEM #6595', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6596, 'ITEM #6596__ITEM #6596', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6597, 'ITEM #6597__ITEM #6597', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6598, 'ITEM #6598__ITEM #6598', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6599, 'ITEM #6599__ITEM #6599', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6600, 'ITEM #6600__ITEM #6600', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6601, 'ITEM #6601__ITEM #6601', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6602, 'ITEM #6602__ITEM #6602', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6603, 'ITEM #6603__ITEM #6603', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6604, 'ITEM #6604__ITEM #6604', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6605, 'ITEM #6605__ITEM #6605', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6606, 'ITEM #6606__ITEM #6606', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6607, 'ITEM #6607__ITEM #6607', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6608, 'ITEM #6608__ITEM #6608', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6609, 'ITEM #6609__ITEM #6609', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6610, 'ITEM #6610__ITEM #6610', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6611, 'ITEM #6611__ITEM #6611', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6612, 'ITEM #6612__ITEM #6612', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6613, 'ITEM #6613__ITEM #6613', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6614, 'ITEM #6614__ITEM #6614', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6615, 'ITEM #6615__ITEM #6615', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6616, 'ITEM #6616__ITEM #6616', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6617, 'ITEM #6617__ITEM #6617', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6618, 'ITEM #6618__ITEM #6618', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6619, 'ITEM #6619__ITEM #6619', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6620, 'ITEM #6620__ITEM #6620', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6621, 'ITEM #6621__ITEM #6621', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6622, 'ITEM #6622__ITEM #6622', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6623, 'ITEM #6623__ITEM #6623', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6624, 'ITEM #6624__ITEM #6624', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6625, 'ITEM #6625__ITEM #6625', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6626, 'ITEM #6626__ITEM #6626', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6627, 'ITEM #6627__ITEM #6627', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6628, 'ITEM #6628__ITEM #6628', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6629, 'ITEM #6629__ITEM #6629', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6630, 'ITEM #6630__ITEM #6630', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6631, 'ITEM #6631__ITEM #6631', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6632, 'ITEM #6632__ITEM #6632', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6633, 'ITEM #6633__ITEM #6633', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6634, 'ITEM #6634__ITEM #6634', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6635, 'ITEM #6635__ITEM #6635', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6636, 'ITEM #6636__ITEM #6636', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6637, 'ITEM #6637__ITEM #6637', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6638, 'ITEM #6638__ITEM #6638', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6639, 'ITEM #6639__ITEM #6639', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6640, 'ITEM #6640__ITEM #6640', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6641, 'ITEM #6641__ITEM #6641', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6642, 'ITEM #6642__ITEM #6642', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6643, 'ITEM #6643__ITEM #6643', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6644, 'ITEM #6644__ITEM #6644', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6645, 'ITEM #6645__ITEM #6645', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6646, 'ITEM #6646__ITEM #6646', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6647, 'ITEM #6647__ITEM #6647', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6648, 'ITEM #6648__ITEM #6648', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6649, 'ITEM #6649__ITEM #6649', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6650, 'ITEM #6650__ITEM #6650', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6651, 'ITEM #6651__ITEM #6651', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6652, 'ITEM #6652__ITEM #6652', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6653, 'ITEM #6653__ITEM #6653', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6654, 'ITEM #6654__ITEM #6654', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6655, 'ITEM #6655__ITEM #6655', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6656, 'ITEM #6656__ITEM #6656', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6657, 'ITEM #6657__ITEM #6657', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6658, 'ITEM #6658__ITEM #6658', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6659, 'ITEM #6659__ITEM #6659', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6660, 'ITEM #6660__ITEM #6660', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6661, 'ITEM #6661__ITEM #6661', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6662, 'ITEM #6662__ITEM #6662', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6663, 'ITEM #6663__ITEM #6663', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6664, 'ITEM #6664__ITEM #6664', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6665, 'ITEM #6665__ITEM #6665', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6666, 'ITEM #6666__ITEM #6666', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6667, 'ITEM #6667__ITEM #6667', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6668, 'ITEM #6668__ITEM #6668', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6669, 'ITEM #6669__ITEM #6669', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6670, 'ITEM #6670__ITEM #6670', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6671, 'ITEM #6671__ITEM #6671', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6672, 'ITEM #6672__ITEM #6672', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6673, 'ITEM #6673__ITEM #6673', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6674, 'ITEM #6674__ITEM #6674', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6675, 'ITEM #6675__ITEM #6675', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6676, 'ITEM #6676__ITEM #6676', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6677, 'ITEM #6677__ITEM #6677', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6678, 'ITEM #6678__ITEM #6678', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6679, 'ITEM #6679__ITEM #6679', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6680, 'ITEM #6680__ITEM #6680', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6681, 'ITEM #6681__ITEM #6681', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6682, 'ITEM #6682__ITEM #6682', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6683, 'ITEM #6683__ITEM #6683', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6684, 'ITEM #6684__ITEM #6684', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6685, 'ITEM #6685__ITEM #6685', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6686, 'ITEM #6686__ITEM #6686', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6687, 'ITEM #6687__ITEM #6687', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6688, 'ITEM #6688__ITEM #6688', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6689, 'ITEM #6689__ITEM #6689', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6690, 'ITEM #6690__ITEM #6690', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6691, 'ITEM #6691__ITEM #6691', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6692, 'ITEM #6692__ITEM #6692', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6693, 'ITEM #6693__ITEM #6693', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6694, 'ITEM #6694__ITEM #6694', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6695, 'ITEM #6695__ITEM #6695', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6696, 'ITEM #6696__ITEM #6696', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6697, 'ITEM #6697__ITEM #6697', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6698, 'ITEM #6698__ITEM #6698', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6699, 'ITEM #6699__ITEM #6699', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6700, 'ITEM #6700__ITEM #6700', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6701, 'ITEM #6701__ITEM #6701', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6702, 'ITEM #6702__ITEM #6702', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6703, 'ITEM #6703__ITEM #6703', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6704, 'ITEM #6704__ITEM #6704', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6705, 'ITEM #6705__ITEM #6705', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6706, 'ITEM #6706__ITEM #6706', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6707, 'ITEM #6707__ITEM #6707', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6708, 'ITEM #6708__ITEM #6708', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6709, 'ITEM #6709__ITEM #6709', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6710, 'ITEM #6710__ITEM #6710', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6711, 'ITEM #6711__ITEM #6711', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6712, 'ITEM #6712__ITEM #6712', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6713, 'ITEM #6713__ITEM #6713', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6714, 'ITEM #6714__ITEM #6714', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6715, 'ITEM #6715__ITEM #6715', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6716, 'ITEM #6716__ITEM #6716', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6717, 'ITEM #6717__ITEM #6717', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6718, 'ITEM #6718__ITEM #6718', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6719, 'ITEM #6719__ITEM #6719', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6720, 'ITEM #6720__ITEM #6720', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6721, 'ITEM #6721__ITEM #6721', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6722, 'ITEM #6722__ITEM #6722', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6723, 'ITEM #6723__ITEM #6723', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6724, 'ITEM #6724__ITEM #6724', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6725, 'ITEM #6725__ITEM #6725', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6726, 'ITEM #6726__ITEM #6726', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6727, 'ITEM #6727__ITEM #6727', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6728, 'ITEM #6728__ITEM #6728', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6729, 'ITEM #6729__ITEM #6729', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6730, 'ITEM #6730__ITEM #6730', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6731, 'ITEM #6731__ITEM #6731', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6732, 'ITEM #6732__ITEM #6732', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6733, 'ITEM #6733__ITEM #6733', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6734, 'ITEM #6734__ITEM #6734', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6735, 'ITEM #6735__ITEM #6735', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6736, 'ITEM #6736__ITEM #6736', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6737, 'ITEM #6737__ITEM #6737', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6738, 'ITEM #6738__ITEM #6738', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6739, 'ITEM #6739__ITEM #6739', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6740, 'ITEM #6740__ITEM #6740', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6741, 'ITEM #6741__ITEM #6741', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6742, 'ITEM #6742__ITEM #6742', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6743, 'ITEM #6743__ITEM #6743', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6744, 'ITEM #6744__ITEM #6744', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6745, 'ITEM #6745__ITEM #6745', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6746, 'ITEM #6746__ITEM #6746', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6747, 'ITEM #6747__ITEM #6747', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6748, 'ITEM #6748__ITEM #6748', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6749, 'ITEM #6749__ITEM #6749', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6750, 'ITEM #6750__ITEM #6750', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6751, 'ITEM #6751__ITEM #6751', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6752, 'ITEM #6752__ITEM #6752', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6753, 'ITEM #6753__ITEM #6753', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6754, 'ITEM #6754__ITEM #6754', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6755, 'ITEM #6755__ITEM #6755', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6756, 'ITEM #6756__ITEM #6756', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6757, 'ITEM #6757__ITEM #6757', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6758, 'ITEM #6758__ITEM #6758', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6759, 'ITEM #6759__ITEM #6759', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6760, 'ITEM #6760__ITEM #6760', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6761, 'ITEM #6761__ITEM #6761', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6762, 'ITEM #6762__ITEM #6762', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6763, 'ITEM #6763__ITEM #6763', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6764, 'ITEM #6764__ITEM #6764', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6765, 'ITEM #6765__ITEM #6765', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6766, 'ITEM #6766__ITEM #6766', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6767, 'ITEM #6767__ITEM #6767', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6768, 'ITEM #6768__ITEM #6768', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6769, 'ITEM #6769__ITEM #6769', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6770, 'ITEM #6770__ITEM #6770', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6771, 'ITEM #6771__ITEM #6771', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6772, 'ITEM #6772__ITEM #6772', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6773, 'ITEM #6773__ITEM #6773', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6774, 'ITEM #6774__ITEM #6774', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6775, 'ITEM #6775__ITEM #6775', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6776, 'ITEM #6776__ITEM #6776', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6777, 'ITEM #6777__ITEM #6777', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6778, 'ITEM #6778__ITEM #6778', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6779, 'ITEM #6779__ITEM #6779', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6780, 'ITEM #6780__ITEM #6780', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6781, 'ITEM #6781__ITEM #6781', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6782, 'ITEM #6782__ITEM #6782', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6783, 'ITEM #6783__ITEM #6783', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6784, 'ITEM #6784__ITEM #6784', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6785, 'ITEM #6785__ITEM #6785', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6786, 'ITEM #6786__ITEM #6786', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6787, 'ITEM #6787__ITEM #6787', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6788, 'ITEM #6788__ITEM #6788', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6789, 'ITEM #6789__ITEM #6789', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6790, 'ITEM #6790__ITEM #6790', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6791, 'ITEM #6791__ITEM #6791', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6792, 'ITEM #6792__ITEM #6792', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6793, 'ITEM #6793__ITEM #6793', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6794, 'ITEM #6794__ITEM #6794', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6795, 'ITEM #6795__ITEM #6795', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6796, 'ITEM #6796__ITEM #6796', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6797, 'ITEM #6797__ITEM #6797', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6798, 'ITEM #6798__ITEM #6798', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6799, 'ITEM #6799__ITEM #6799', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6800, 'ITEM #6800__ITEM #6800', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6801, 'ITEM #6801__ITEM #6801', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6802, 'ITEM #6802__ITEM #6802', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6803, 'ITEM #6803__ITEM #6803', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6804, 'ITEM #6804__ITEM #6804', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6805, 'ITEM #6805__ITEM #6805', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6806, 'ITEM #6806__ITEM #6806', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6807, 'ITEM #6807__ITEM #6807', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6808, 'ITEM #6808__ITEM #6808', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6809, 'ITEM #6809__ITEM #6809', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6810, 'ITEM #6810__ITEM #6810', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6811, 'ITEM #6811__ITEM #6811', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6812, 'ITEM #6812__ITEM #6812', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6813, 'ITEM #6813__ITEM #6813', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6814, 'ITEM #6814__ITEM #6814', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6815, 'ITEM #6815__ITEM #6815', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6816, 'ITEM #6816__ITEM #6816', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6817, 'ITEM #6817__ITEM #6817', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6818, 'ITEM #6818__ITEM #6818', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6819, 'ITEM #6819__ITEM #6819', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6820, 'ITEM #6820__ITEM #6820', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6821, 'ITEM #6821__ITEM #6821', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6822, 'ITEM #6822__ITEM #6822', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6823, 'ITEM #6823__ITEM #6823', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6824, 'ITEM #6824__ITEM #6824', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6825, 'ITEM #6825__ITEM #6825', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6826, 'ITEM #6826__ITEM #6826', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6827, 'ITEM #6827__ITEM #6827', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6828, 'ITEM #6828__ITEM #6828', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6829, 'ITEM #6829__ITEM #6829', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6830, 'ITEM #6830__ITEM #6830', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6831, 'ITEM #6831__ITEM #6831', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6832, 'ITEM #6832__ITEM #6832', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6833, 'ITEM #6833__ITEM #6833', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6834, 'ITEM #6834__ITEM #6834', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6835, 'ITEM #6835__ITEM #6835', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6836, 'ITEM #6836__ITEM #6836', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6837, 'ITEM #6837__ITEM #6837', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6838, 'ITEM #6838__ITEM #6838', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6839, 'ITEM #6839__ITEM #6839', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6840, 'ITEM #6840__ITEM #6840', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6841, 'ITEM #6841__ITEM #6841', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6842, 'ITEM #6842__ITEM #6842', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6843, 'ITEM #6843__ITEM #6843', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6844, 'ITEM #6844__ITEM #6844', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6845, 'ITEM #6845__ITEM #6845', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6846, 'ITEM #6846__ITEM #6846', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6847, 'ITEM #6847__ITEM #6847', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6848, 'ITEM #6848__ITEM #6848', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6849, 'ITEM #6849__ITEM #6849', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6850, 'ITEM #6850__ITEM #6850', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6851, 'ITEM #6851__ITEM #6851', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6852, 'ITEM #6852__ITEM #6852', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6853, 'ITEM #6853__ITEM #6853', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6854, 'ITEM #6854__ITEM #6854', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6855, 'ITEM #6855__ITEM #6855', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6856, 'ITEM #6856__ITEM #6856', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6857, 'ITEM #6857__ITEM #6857', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6858, 'ITEM #6858__ITEM #6858', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6859, 'ITEM #6859__ITEM #6859', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6860, 'ITEM #6860__ITEM #6860', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6861, 'ITEM #6861__ITEM #6861', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6862, 'ITEM #6862__ITEM #6862', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6863, 'ITEM #6863__ITEM #6863', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6864, 'ITEM #6864__ITEM #6864', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6865, 'ITEM #6865__ITEM #6865', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6866, 'ITEM #6866__ITEM #6866', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6867, 'ITEM #6867__ITEM #6867', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6868, 'ITEM #6868__ITEM #6868', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6869, 'ITEM #6869__ITEM #6869', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6870, 'ITEM #6870__ITEM #6870', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6871, 'ITEM #6871__ITEM #6871', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6872, 'ITEM #6872__ITEM #6872', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6873, 'ITEM #6873__ITEM #6873', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6874, 'ITEM #6874__ITEM #6874', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6875, 'ITEM #6875__ITEM #6875', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6876, 'ITEM #6876__ITEM #6876', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6877, 'ITEM #6877__ITEM #6877', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6878, 'ITEM #6878__ITEM #6878', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6879, 'ITEM #6879__ITEM #6879', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6880, 'ITEM #6880__ITEM #6880', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6881, 'ITEM #6881__ITEM #6881', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6882, 'ITEM #6882__ITEM #6882', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6883, 'ITEM #6883__ITEM #6883', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6884, 'ITEM #6884__ITEM #6884', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6885, 'ITEM #6885__ITEM #6885', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6886, 'ITEM #6886__ITEM #6886', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6887, 'ITEM #6887__ITEM #6887', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6888, 'ITEM #6888__ITEM #6888', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6889, 'ITEM #6889__ITEM #6889', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6890, 'ITEM #6890__ITEM #6890', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6891, 'ITEM #6891__ITEM #6891', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6892, 'ITEM #6892__ITEM #6892', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6893, 'ITEM #6893__ITEM #6893', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6894, 'ITEM #6894__ITEM #6894', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6895, 'ITEM #6895__ITEM #6895', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6896, 'ITEM #6896__ITEM #6896', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6897, 'ITEM #6897__ITEM #6897', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6898, 'ITEM #6898__ITEM #6898', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6899, 'ITEM #6899__ITEM #6899', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6900, 'ITEM #6900__ITEM #6900', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6901, 'ITEM #6901__ITEM #6901', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6902, 'ITEM #6902__ITEM #6902', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6903, 'ITEM #6903__ITEM #6903', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6904, 'ITEM #6904__ITEM #6904', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6905, 'ITEM #6905__ITEM #6905', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6906, 'ITEM #6906__ITEM #6906', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6907, 'ITEM #6907__ITEM #6907', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6908, 'ITEM #6908__ITEM #6908', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6909, 'ITEM #6909__ITEM #6909', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6910, 'ITEM #6910__ITEM #6910', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6911, 'ITEM #6911__ITEM #6911', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6912, 'ITEM #6912__ITEM #6912', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6913, 'ITEM #6913__ITEM #6913', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6914, 'ITEM #6914__ITEM #6914', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6915, 'ITEM #6915__ITEM #6915', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6916, 'ITEM #6916__ITEM #6916', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6917, 'ITEM #6917__ITEM #6917', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6918, 'ITEM #6918__ITEM #6918', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6919, 'ITEM #6919__ITEM #6919', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6920, 'ITEM #6920__ITEM #6920', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6921, 'ITEM #6921__ITEM #6921', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6922, 'ITEM #6922__ITEM #6922', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6923, 'ITEM #6923__ITEM #6923', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6924, 'ITEM #6924__ITEM #6924', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6925, 'ITEM #6925__ITEM #6925', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6926, 'ITEM #6926__ITEM #6926', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6927, 'ITEM #6927__ITEM #6927', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6928, 'ITEM #6928__ITEM #6928', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6929, 'ITEM #6929__ITEM #6929', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6930, 'ITEM #6930__ITEM #6930', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6931, 'ITEM #6931__ITEM #6931', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6932, 'ITEM #6932__ITEM #6932', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6933, 'ITEM #6933__ITEM #6933', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6934, 'ITEM #6934__ITEM #6934', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6935, 'ITEM #6935__ITEM #6935', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6936, 'ITEM #6936__ITEM #6936', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6937, 'ITEM #6937__ITEM #6937', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6938, 'ITEM #6938__ITEM #6938', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6939, 'ITEM #6939__ITEM #6939', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6940, 'ITEM #6940__ITEM #6940', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6941, 'ITEM #6941__ITEM #6941', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6942, 'ITEM #6942__ITEM #6942', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6943, 'ITEM #6943__ITEM #6943', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6944, 'ITEM #6944__ITEM #6944', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6945, 'ITEM #6945__ITEM #6945', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6946, 'ITEM #6946__ITEM #6946', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6947, 'ITEM #6947__ITEM #6947', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6948, 'ITEM #6948__ITEM #6948', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6949, 'ITEM #6949__ITEM #6949', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6950, 'ITEM #6950__ITEM #6950', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6951, 'ITEM #6951__ITEM #6951', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6952, 'ITEM #6952__ITEM #6952', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6953, 'ITEM #6953__ITEM #6953', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6954, 'ITEM #6954__ITEM #6954', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6955, 'ITEM #6955__ITEM #6955', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6956, 'ITEM #6956__ITEM #6956', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6957, 'ITEM #6957__ITEM #6957', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6958, 'ITEM #6958__ITEM #6958', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6959, 'ITEM #6959__ITEM #6959', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6960, 'ITEM #6960__ITEM #6960', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6961, 'ITEM #6961__ITEM #6961', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6962, 'ITEM #6962__ITEM #6962', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6963, 'ITEM #6963__ITEM #6963', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6964, 'ITEM #6964__ITEM #6964', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6965, 'ITEM #6965__ITEM #6965', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6966, 'ITEM #6966__ITEM #6966', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6967, 'ITEM #6967__ITEM #6967', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6968, 'ITEM #6968__ITEM #6968', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6969, 'ITEM #6969__ITEM #6969', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6970, 'ITEM #6970__ITEM #6970', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6971, 'ITEM #6971__ITEM #6971', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6972, 'ITEM #6972__ITEM #6972', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6973, 'ITEM #6973__ITEM #6973', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6974, 'ITEM #6974__ITEM #6974', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6975, 'ITEM #6975__ITEM #6975', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6976, 'ITEM #6976__ITEM #6976', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6977, 'ITEM #6977__ITEM #6977', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6978, 'ITEM #6978__ITEM #6978', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6979, 'ITEM #6979__ITEM #6979', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6980, 'ITEM #6980__ITEM #6980', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6981, 'ITEM #6981__ITEM #6981', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6982, 'ITEM #6982__ITEM #6982', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6983, 'ITEM #6983__ITEM #6983', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6984, 'ITEM #6984__ITEM #6984', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6985, 'ITEM #6985__ITEM #6985', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6986, 'ITEM #6986__ITEM #6986', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6987, 'ITEM #6987__ITEM #6987', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6988, 'ITEM #6988__ITEM #6988', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6989, 'ITEM #6989__ITEM #6989', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6990, 'ITEM #6990__ITEM #6990', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6991, 'ITEM #6991__ITEM #6991', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6992, 'ITEM #6992__ITEM #6992', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6993, 'ITEM #6993__ITEM #6993', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6994, 'ITEM #6994__ITEM #6994', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6995, 'ITEM #6995__ITEM #6995', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6996, 'ITEM #6996__ITEM #6996', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6997, 'ITEM #6997__ITEM #6997', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6998, 'ITEM #6998__ITEM #6998', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (6999, 'ITEM #6999__ITEM #6999', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7000, 'ITEM #7000__ITEM #7000', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7001, 'ITEM #7001__ITEM #7001', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7002, 'ITEM #7002__ITEM #7002', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7003, 'ITEM #7003__ITEM #7003', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7004, 'ITEM #7004__ITEM #7004', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7005, 'ITEM #7005__ITEM #7005', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7006, 'ITEM #7006__ITEM #7006', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7007, 'ITEM #7007__ITEM #7007', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7008, 'ITEM #7008__ITEM #7008', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7009, 'ITEM #7009__ITEM #7009', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7010, 'ITEM #7010__ITEM #7010', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7011, 'ITEM #7011__ITEM #7011', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7012, 'ITEM #7012__ITEM #7012', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7013, 'ITEM #7013__ITEM #7013', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7014, 'ITEM #7014__ITEM #7014', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7015, 'ITEM #7015__ITEM #7015', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7016, 'ITEM #7016__ITEM #7016', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7017, 'ITEM #7017__ITEM #7017', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7018, 'ITEM #7018__ITEM #7018', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7019, 'ITEM #7019__ITEM #7019', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7020, 'ITEM #7020__ITEM #7020', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7021, 'ITEM #7021__ITEM #7021', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7022, 'ITEM #7022__ITEM #7022', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7023, 'ITEM #7023__ITEM #7023', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7024, 'ITEM #7024__ITEM #7024', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7025, 'ITEM #7025__ITEM #7025', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7026, 'ITEM #7026__ITEM #7026', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7027, 'ITEM #7027__ITEM #7027', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7028, 'ITEM #7028__ITEM #7028', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7029, 'ITEM #7029__ITEM #7029', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7030, 'ITEM #7030__ITEM #7030', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7031, 'ITEM #7031__ITEM #7031', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7032, 'ITEM #7032__ITEM #7032', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7033, 'ITEM #7033__ITEM #7033', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7034, 'ITEM #7034__ITEM #7034', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7035, 'ITEM #7035__ITEM #7035', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7036, 'ITEM #7036__ITEM #7036', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7037, 'ITEM #7037__ITEM #7037', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7038, 'ITEM #7038__ITEM #7038', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7039, 'ITEM #7039__ITEM #7039', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7040, 'ITEM #7040__ITEM #7040', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7041, 'ITEM #7041__ITEM #7041', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7042, 'ITEM #7042__ITEM #7042', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7043, 'ITEM #7043__ITEM #7043', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7044, 'ITEM #7044__ITEM #7044', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7045, 'ITEM #7045__ITEM #7045', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7046, 'ITEM #7046__ITEM #7046', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7047, 'ITEM #7047__ITEM #7047', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7048, 'ITEM #7048__ITEM #7048', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7049, 'ITEM #7049__ITEM #7049', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7050, 'ITEM #7050__ITEM #7050', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7051, 'ITEM #7051__ITEM #7051', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7052, 'ITEM #7052__ITEM #7052', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7053, 'ITEM #7053__ITEM #7053', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7054, 'ITEM #7054__ITEM #7054', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7055, 'ITEM #7055__ITEM #7055', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7056, 'ITEM #7056__ITEM #7056', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7057, 'ITEM #7057__ITEM #7057', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7058, 'ITEM #7058__ITEM #7058', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7059, 'ITEM #7059__ITEM #7059', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7060, 'ITEM #7060__ITEM #7060', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7061, 'ITEM #7061__ITEM #7061', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7062, 'ITEM #7062__ITEM #7062', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7063, 'ITEM #7063__ITEM #7063', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7064, 'ITEM #7064__ITEM #7064', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7065, 'ITEM #7065__ITEM #7065', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7066, 'ITEM #7066__ITEM #7066', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7067, 'ITEM #7067__ITEM #7067', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7068, 'ITEM #7068__ITEM #7068', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7069, 'ITEM #7069__ITEM #7069', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7070, 'ITEM #7070__ITEM #7070', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7071, 'ITEM #7071__ITEM #7071', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7072, 'ITEM #7072__ITEM #7072', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7073, 'ITEM #7073__ITEM #7073', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7074, 'ITEM #7074__ITEM #7074', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7075, 'ITEM #7075__ITEM #7075', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7076, 'ITEM #7076__ITEM #7076', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7077, 'ITEM #7077__ITEM #7077', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7078, 'ITEM #7078__ITEM #7078', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7079, 'ITEM #7079__ITEM #7079', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7080, 'ITEM #7080__ITEM #7080', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7081, 'ITEM #7081__ITEM #7081', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7082, 'ITEM #7082__ITEM #7082', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7083, 'ITEM #7083__ITEM #7083', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7084, 'ITEM #7084__ITEM #7084', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7085, 'ITEM #7085__ITEM #7085', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7086, 'ITEM #7086__ITEM #7086', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7087, 'ITEM #7087__ITEM #7087', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7088, 'ITEM #7088__ITEM #7088', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7089, 'ITEM #7089__ITEM #7089', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7090, 'ITEM #7090__ITEM #7090', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7091, 'ITEM #7091__ITEM #7091', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7092, 'ITEM #7092__ITEM #7092', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7093, 'ITEM #7093__ITEM #7093', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7094, 'ITEM #7094__ITEM #7094', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7095, 'ITEM #7095__ITEM #7095', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7096, 'ITEM #7096__ITEM #7096', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7097, 'ITEM #7097__ITEM #7097', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7098, 'ITEM #7098__ITEM #7098', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7099, 'ITEM #7099__ITEM #7099', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7100, 'ITEM #7100__ITEM #7100', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7101, 'ITEM #7101__ITEM #7101', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7102, 'ITEM #7102__ITEM #7102', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7103, 'ITEM #7103__ITEM #7103', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7104, 'ITEM #7104__ITEM #7104', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7105, 'ITEM #7105__ITEM #7105', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7106, 'ITEM #7106__ITEM #7106', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7107, 'ITEM #7107__ITEM #7107', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7108, 'ITEM #7108__ITEM #7108', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7109, 'ITEM #7109__ITEM #7109', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7110, 'ITEM #7110__ITEM #7110', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7111, 'ITEM #7111__ITEM #7111', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7112, 'ITEM #7112__ITEM #7112', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7113, 'ITEM #7113__ITEM #7113', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7114, 'ITEM #7114__ITEM #7114', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7115, 'ITEM #7115__ITEM #7115', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7116, 'ITEM #7116__ITEM #7116', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7117, 'ITEM #7117__ITEM #7117', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7118, 'ITEM #7118__ITEM #7118', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7119, 'ITEM #7119__ITEM #7119', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7120, 'ITEM #7120__ITEM #7120', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7121, 'ITEM #7121__ITEM #7121', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7122, 'ITEM #7122__ITEM #7122', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7123, 'ITEM #7123__ITEM #7123', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7124, 'ITEM #7124__ITEM #7124', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7125, 'ITEM #7125__ITEM #7125', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7126, 'ITEM #7126__ITEM #7126', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7127, 'ITEM #7127__ITEM #7127', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7128, 'ITEM #7128__ITEM #7128', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7129, 'ITEM #7129__ITEM #7129', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7130, 'ITEM #7130__ITEM #7130', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7131, 'ITEM #7131__ITEM #7131', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7132, 'ITEM #7132__ITEM #7132', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7133, 'ITEM #7133__ITEM #7133', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7134, 'ITEM #7134__ITEM #7134', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7135, 'ITEM #7135__ITEM #7135', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7136, 'ITEM #7136__ITEM #7136', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7137, 'ITEM #7137__ITEM #7137', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7138, 'ITEM #7138__ITEM #7138', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7139, 'ITEM #7139__ITEM #7139', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7140, 'ITEM #7140__ITEM #7140', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7141, 'ITEM #7141__ITEM #7141', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7142, 'ITEM #7142__ITEM #7142', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7143, 'ITEM #7143__ITEM #7143', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7144, 'ITEM #7144__ITEM #7144', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7145, 'ITEM #7145__ITEM #7145', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7146, 'ITEM #7146__ITEM #7146', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7147, 'ITEM #7147__ITEM #7147', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7148, 'ITEM #7148__ITEM #7148', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7149, 'ITEM #7149__ITEM #7149', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7150, 'ITEM #7150__ITEM #7150', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7151, 'ITEM #7151__ITEM #7151', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7152, 'ITEM #7152__ITEM #7152', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7153, 'ITEM #7153__ITEM #7153', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7154, 'ITEM #7154__ITEM #7154', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7155, 'ITEM #7155__ITEM #7155', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7156, 'ITEM #7156__ITEM #7156', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7157, 'ITEM #7157__ITEM #7157', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7158, 'ITEM #7158__ITEM #7158', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7159, 'ITEM #7159__ITEM #7159', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7160, 'ITEM #7160__ITEM #7160', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7161, 'ITEM #7161__ITEM #7161', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7162, 'ITEM #7162__ITEM #7162', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7163, 'ITEM #7163__ITEM #7163', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7164, 'ITEM #7164__ITEM #7164', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7165, 'ITEM #7165__ITEM #7165', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7166, 'ITEM #7166__ITEM #7166', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7167, 'ITEM #7167__ITEM #7167', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7168, 'ITEM #7168__ITEM #7168', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7169, 'ITEM #7169__ITEM #7169', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7170, 'ITEM #7170__ITEM #7170', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7171, 'ITEM #7171__ITEM #7171', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7172, 'ITEM #7172__ITEM #7172', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7173, 'ITEM #7173__ITEM #7173', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7174, 'ITEM #7174__ITEM #7174', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7175, 'ITEM #7175__ITEM #7175', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7176, 'ITEM #7176__ITEM #7176', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7177, 'ITEM #7177__ITEM #7177', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7178, 'ITEM #7178__ITEM #7178', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7179, 'ITEM #7179__ITEM #7179', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7180, 'ITEM #7180__ITEM #7180', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7181, 'ITEM #7181__ITEM #7181', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7182, 'ITEM #7182__ITEM #7182', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7183, 'ITEM #7183__ITEM #7183', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7184, 'ITEM #7184__ITEM #7184', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7185, 'ITEM #7185__ITEM #7185', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7186, 'ITEM #7186__ITEM #7186', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7187, 'ITEM #7187__ITEM #7187', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7188, 'ITEM #7188__ITEM #7188', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7189, 'ITEM #7189__ITEM #7189', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7190, 'ITEM #7190__ITEM #7190', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7191, 'ITEM #7191__ITEM #7191', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7192, 'ITEM #7192__ITEM #7192', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7193, 'ITEM #7193__ITEM #7193', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7194, 'ITEM #7194__ITEM #7194', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7195, 'ITEM #7195__ITEM #7195', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7196, 'ITEM #7196__ITEM #7196', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7197, 'ITEM #7197__ITEM #7197', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7198, 'ITEM #7198__ITEM #7198', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7199, 'ITEM #7199__ITEM #7199', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7200, 'ITEM #7200__ITEM #7200', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7201, 'ITEM #7201__ITEM #7201', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7202, 'ITEM #7202__ITEM #7202', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7203, 'ITEM #7203__ITEM #7203', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7204, 'ITEM #7204__ITEM #7204', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7205, 'ITEM #7205__ITEM #7205', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7206, 'ITEM #7206__ITEM #7206', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7207, 'ITEM #7207__ITEM #7207', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7208, 'ITEM #7208__ITEM #7208', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7209, 'ITEM #7209__ITEM #7209', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7210, 'ITEM #7210__ITEM #7210', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7211, 'ITEM #7211__ITEM #7211', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7212, 'ITEM #7212__ITEM #7212', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7213, 'ITEM #7213__ITEM #7213', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7214, 'ITEM #7214__ITEM #7214', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7215, 'ITEM #7215__ITEM #7215', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7216, 'ITEM #7216__ITEM #7216', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7217, 'ITEM #7217__ITEM #7217', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7218, 'ITEM #7218__ITEM #7218', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7219, 'ITEM #7219__ITEM #7219', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7220, 'ITEM #7220__ITEM #7220', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7221, 'ITEM #7221__ITEM #7221', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7222, 'ITEM #7222__ITEM #7222', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7223, 'ITEM #7223__ITEM #7223', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7224, 'ITEM #7224__ITEM #7224', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7225, 'ITEM #7225__ITEM #7225', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7226, 'ITEM #7226__ITEM #7226', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7227, 'ITEM #7227__ITEM #7227', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7228, 'ITEM #7228__ITEM #7228', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7229, 'ITEM #7229__ITEM #7229', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7230, 'ITEM #7230__ITEM #7230', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7231, 'ITEM #7231__ITEM #7231', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7232, 'ITEM #7232__ITEM #7232', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7233, 'ITEM #7233__ITEM #7233', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7234, 'ITEM #7234__ITEM #7234', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7235, 'ITEM #7235__ITEM #7235', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7236, 'ITEM #7236__ITEM #7236', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7237, 'ITEM #7237__ITEM #7237', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7238, 'ITEM #7238__ITEM #7238', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7239, 'ITEM #7239__ITEM #7239', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7240, 'ITEM #7240__ITEM #7240', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7241, 'ITEM #7241__ITEM #7241', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7242, 'ITEM #7242__ITEM #7242', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7243, 'ITEM #7243__ITEM #7243', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7244, 'ITEM #7244__ITEM #7244', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7245, 'ITEM #7245__ITEM #7245', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7246, 'ITEM #7246__ITEM #7246', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7247, 'ITEM #7247__ITEM #7247', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7248, 'ITEM #7248__ITEM #7248', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7249, 'ITEM #7249__ITEM #7249', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7250, 'ITEM #7250__ITEM #7250', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7251, 'ITEM #7251__ITEM #7251', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7252, 'ITEM #7252__ITEM #7252', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7253, 'ITEM #7253__ITEM #7253', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7254, 'ITEM #7254__ITEM #7254', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7255, 'ITEM #7255__ITEM #7255', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7256, 'ITEM #7256__ITEM #7256', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7257, 'ITEM #7257__ITEM #7257', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7258, 'ITEM #7258__ITEM #7258', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7259, 'ITEM #7259__ITEM #7259', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7260, 'ITEM #7260__ITEM #7260', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7261, 'ITEM #7261__ITEM #7261', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7262, 'ITEM #7262__ITEM #7262', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7263, 'ITEM #7263__ITEM #7263', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7264, 'ITEM #7264__ITEM #7264', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7265, 'ITEM #7265__ITEM #7265', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7266, 'ITEM #7266__ITEM #7266', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7267, 'ITEM #7267__ITEM #7267', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7268, 'ITEM #7268__ITEM #7268', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7269, 'ITEM #7269__ITEM #7269', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7270, 'ITEM #7270__ITEM #7270', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7271, 'ITEM #7271__ITEM #7271', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7272, 'ITEM #7272__ITEM #7272', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7273, 'ITEM #7273__ITEM #7273', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7274, 'ITEM #7274__ITEM #7274', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7275, 'ITEM #7275__ITEM #7275', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7276, 'ITEM #7276__ITEM #7276', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7277, 'ITEM #7277__ITEM #7277', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7278, 'ITEM #7278__ITEM #7278', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7279, 'ITEM #7279__ITEM #7279', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7280, 'ITEM #7280__ITEM #7280', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7281, 'ITEM #7281__ITEM #7281', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7282, 'ITEM #7282__ITEM #7282', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7283, 'ITEM #7283__ITEM #7283', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7284, 'ITEM #7284__ITEM #7284', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7285, 'ITEM #7285__ITEM #7285', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7286, 'ITEM #7286__ITEM #7286', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7287, 'ITEM #7287__ITEM #7287', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7288, 'ITEM #7288__ITEM #7288', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7289, 'ITEM #7289__ITEM #7289', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7290, 'ITEM #7290__ITEM #7290', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7291, 'ITEM #7291__ITEM #7291', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7292, 'ITEM #7292__ITEM #7292', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7293, 'ITEM #7293__ITEM #7293', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7294, 'ITEM #7294__ITEM #7294', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7295, 'ITEM #7295__ITEM #7295', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7296, 'ITEM #7296__ITEM #7296', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7297, 'ITEM #7297__ITEM #7297', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7298, 'ITEM #7298__ITEM #7298', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7299, 'ITEM #7299__ITEM #7299', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7300, 'ITEM #7300__ITEM #7300', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7301, 'ITEM #7301__ITEM #7301', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7302, 'ITEM #7302__ITEM #7302', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7303, 'ITEM #7303__ITEM #7303', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7304, 'ITEM #7304__ITEM #7304', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7305, 'ITEM #7305__ITEM #7305', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7306, 'ITEM #7306__ITEM #7306', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7307, 'ITEM #7307__ITEM #7307', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7308, 'ITEM #7308__ITEM #7308', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7309, 'ITEM #7309__ITEM #7309', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7310, 'ITEM #7310__ITEM #7310', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7311, 'ITEM #7311__ITEM #7311', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7312, 'ITEM #7312__ITEM #7312', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7313, 'ITEM #7313__ITEM #7313', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7314, 'ITEM #7314__ITEM #7314', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7315, 'ITEM #7315__ITEM #7315', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7316, 'ITEM #7316__ITEM #7316', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7317, 'ITEM #7317__ITEM #7317', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7318, 'ITEM #7318__ITEM #7318', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7319, 'ITEM #7319__ITEM #7319', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7320, 'ITEM #7320__ITEM #7320', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7321, 'ITEM #7321__ITEM #7321', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7322, 'ITEM #7322__ITEM #7322', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7323, 'ITEM #7323__ITEM #7323', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7324, 'ITEM #7324__ITEM #7324', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7325, 'ITEM #7325__ITEM #7325', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7326, 'ITEM #7326__ITEM #7326', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7327, 'ITEM #7327__ITEM #7327', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7328, 'ITEM #7328__ITEM #7328', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7329, 'ITEM #7329__ITEM #7329', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7330, 'ITEM #7330__ITEM #7330', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7331, 'ITEM #7331__ITEM #7331', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7332, 'ITEM #7332__ITEM #7332', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7333, 'ITEM #7333__ITEM #7333', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7334, 'ITEM #7334__ITEM #7334', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7335, 'ITEM #7335__ITEM #7335', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7336, 'ITEM #7336__ITEM #7336', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7337, 'ITEM #7337__ITEM #7337', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7338, 'ITEM #7338__ITEM #7338', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7339, 'ITEM #7339__ITEM #7339', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7340, 'ITEM #7340__ITEM #7340', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7341, 'ITEM #7341__ITEM #7341', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7342, 'ITEM #7342__ITEM #7342', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7343, 'ITEM #7343__ITEM #7343', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7344, 'ITEM #7344__ITEM #7344', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7345, 'ITEM #7345__ITEM #7345', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7346, 'ITEM #7346__ITEM #7346', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7347, 'ITEM #7347__ITEM #7347', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7348, 'ITEM #7348__ITEM #7348', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7349, 'ITEM #7349__ITEM #7349', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7350, 'ITEM #7350__ITEM #7350', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7351, 'ITEM #7351__ITEM #7351', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7352, 'ITEM #7352__ITEM #7352', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7353, 'ITEM #7353__ITEM #7353', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7354, 'ITEM #7354__ITEM #7354', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7355, 'ITEM #7355__ITEM #7355', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7356, 'ITEM #7356__ITEM #7356', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7357, 'ITEM #7357__ITEM #7357', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7358, 'ITEM #7358__ITEM #7358', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7359, 'ITEM #7359__ITEM #7359', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7360, 'ITEM #7360__ITEM #7360', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7361, 'ITEM #7361__ITEM #7361', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7362, 'ITEM #7362__ITEM #7362', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7363, 'ITEM #7363__ITEM #7363', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7364, 'ITEM #7364__ITEM #7364', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7365, 'ITEM #7365__ITEM #7365', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7366, 'ITEM #7366__ITEM #7366', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7367, 'ITEM #7367__ITEM #7367', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7368, 'ITEM #7368__ITEM #7368', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7369, 'ITEM #7369__ITEM #7369', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7370, 'ITEM #7370__ITEM #7370', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7371, 'ITEM #7371__ITEM #7371', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7372, 'ITEM #7372__ITEM #7372', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7373, 'ITEM #7373__ITEM #7373', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7374, 'ITEM #7374__ITEM #7374', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7375, 'ITEM #7375__ITEM #7375', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7376, 'ITEM #7376__ITEM #7376', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7377, 'ITEM #7377__ITEM #7377', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7378, 'ITEM #7378__ITEM #7378', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7379, 'ITEM #7379__ITEM #7379', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7380, 'ITEM #7380__ITEM #7380', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7381, 'ITEM #7381__ITEM #7381', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7382, 'ITEM #7382__ITEM #7382', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7383, 'ITEM #7383__ITEM #7383', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7384, 'ITEM #7384__ITEM #7384', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7385, 'ITEM #7385__ITEM #7385', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7386, 'ITEM #7386__ITEM #7386', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7387, 'ITEM #7387__ITEM #7387', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7388, 'ITEM #7388__ITEM #7388', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7389, 'ITEM #7389__ITEM #7389', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7390, 'ITEM #7390__ITEM #7390', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7391, 'ITEM #7391__ITEM #7391', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7392, 'ITEM #7392__ITEM #7392', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7393, 'ITEM #7393__ITEM #7393', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7394, 'ITEM #7394__ITEM #7394', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7395, 'ITEM #7395__ITEM #7395', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7396, 'ITEM #7396__ITEM #7396', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7397, 'ITEM #7397__ITEM #7397', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7398, 'ITEM #7398__ITEM #7398', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7399, 'ITEM #7399__ITEM #7399', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7400, 'ITEM #7400__ITEM #7400', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7401, 'ITEM #7401__ITEM #7401', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7402, 'ITEM #7402__ITEM #7402', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7403, 'ITEM #7403__ITEM #7403', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7404, 'ITEM #7404__ITEM #7404', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7405, 'ITEM #7405__ITEM #7405', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7406, 'ITEM #7406__ITEM #7406', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7407, 'ITEM #7407__ITEM #7407', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7408, 'ITEM #7408__ITEM #7408', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7409, 'ITEM #7409__ITEM #7409', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7410, 'ITEM #7410__ITEM #7410', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7411, 'ITEM #7411__ITEM #7411', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7412, 'ITEM #7412__ITEM #7412', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7413, 'ITEM #7413__ITEM #7413', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7414, 'ITEM #7414__ITEM #7414', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7415, 'ITEM #7415__ITEM #7415', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7416, 'ITEM #7416__ITEM #7416', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7417, 'ITEM #7417__ITEM #7417', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7418, 'ITEM #7418__ITEM #7418', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7419, 'ITEM #7419__ITEM #7419', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7420, 'ITEM #7420__ITEM #7420', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7421, 'ITEM #7421__ITEM #7421', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7422, 'ITEM #7422__ITEM #7422', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7423, 'ITEM #7423__ITEM #7423', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7424, 'ITEM #7424__ITEM #7424', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7425, 'ITEM #7425__ITEM #7425', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7426, 'ITEM #7426__ITEM #7426', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7427, 'ITEM #7427__ITEM #7427', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7428, 'ITEM #7428__ITEM #7428', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7429, 'ITEM #7429__ITEM #7429', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7430, 'ITEM #7430__ITEM #7430', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7431, 'ITEM #7431__ITEM #7431', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7432, 'ITEM #7432__ITEM #7432', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7433, 'ITEM #7433__ITEM #7433', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7434, 'ITEM #7434__ITEM #7434', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7435, 'ITEM #7435__ITEM #7435', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7436, 'ITEM #7436__ITEM #7436', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7437, 'ITEM #7437__ITEM #7437', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7438, 'ITEM #7438__ITEM #7438', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7439, 'ITEM #7439__ITEM #7439', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7440, 'ITEM #7440__ITEM #7440', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7441, 'ITEM #7441__ITEM #7441', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7442, 'ITEM #7442__ITEM #7442', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7443, 'ITEM #7443__ITEM #7443', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7444, 'ITEM #7444__ITEM #7444', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7445, 'ITEM #7445__ITEM #7445', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7446, 'ITEM #7446__ITEM #7446', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7447, 'ITEM #7447__ITEM #7447', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7448, 'ITEM #7448__ITEM #7448', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7449, 'ITEM #7449__ITEM #7449', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7450, 'ITEM #7450__ITEM #7450', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7451, 'ITEM #7451__ITEM #7451', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7452, 'ITEM #7452__ITEM #7452', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7453, 'ITEM #7453__ITEM #7453', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7454, 'ITEM #7454__ITEM #7454', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7455, 'ITEM #7455__ITEM #7455', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7456, 'ITEM #7456__ITEM #7456', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7457, 'ITEM #7457__ITEM #7457', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7458, 'ITEM #7458__ITEM #7458', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7459, 'ITEM #7459__ITEM #7459', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7460, 'ITEM #7460__ITEM #7460', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7461, 'ITEM #7461__ITEM #7461', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7462, 'ITEM #7462__ITEM #7462', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7463, 'ITEM #7463__ITEM #7463', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7464, 'ITEM #7464__ITEM #7464', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7465, 'ITEM #7465__ITEM #7465', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7466, 'ITEM #7466__ITEM #7466', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7467, 'ITEM #7467__ITEM #7467', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7468, 'ITEM #7468__ITEM #7468', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7469, 'ITEM #7469__ITEM #7469', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7470, 'ITEM #7470__ITEM #7470', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7471, 'ITEM #7471__ITEM #7471', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7472, 'ITEM #7472__ITEM #7472', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7473, 'ITEM #7473__ITEM #7473', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7474, 'ITEM #7474__ITEM #7474', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7475, 'ITEM #7475__ITEM #7475', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7476, 'ITEM #7476__ITEM #7476', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7477, 'ITEM #7477__ITEM #7477', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7478, 'ITEM #7478__ITEM #7478', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7479, 'ITEM #7479__ITEM #7479', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7480, 'ITEM #7480__ITEM #7480', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7481, 'ITEM #7481__ITEM #7481', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7482, 'ITEM #7482__ITEM #7482', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7483, 'ITEM #7483__ITEM #7483', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7484, 'ITEM #7484__ITEM #7484', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7485, 'ITEM #7485__ITEM #7485', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7486, 'ITEM #7486__ITEM #7486', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7487, 'ITEM #7487__ITEM #7487', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7488, 'ITEM #7488__ITEM #7488', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7489, 'ITEM #7489__ITEM #7489', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7490, 'ITEM #7490__ITEM #7490', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7491, 'ITEM #7491__ITEM #7491', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7492, 'ITEM #7492__ITEM #7492', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7493, 'ITEM #7493__ITEM #7493', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7494, 'ITEM #7494__ITEM #7494', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7495, 'ITEM #7495__ITEM #7495', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7496, 'ITEM #7496__ITEM #7496', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7497, 'ITEM #7497__ITEM #7497', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7498, 'ITEM #7498__ITEM #7498', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7499, 'ITEM #7499__ITEM #7499', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7500, 'ITEM #7500__ITEM #7500', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7501, 'ITEM #7501__ITEM #7501', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7502, 'ITEM #7502__ITEM #7502', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7503, 'ITEM #7503__ITEM #7503', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7504, 'ITEM #7504__ITEM #7504', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7505, 'ITEM #7505__ITEM #7505', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7506, 'ITEM #7506__ITEM #7506', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7507, 'ITEM #7507__ITEM #7507', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7508, 'ITEM #7508__ITEM #7508', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7509, 'ITEM #7509__ITEM #7509', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7510, 'ITEM #7510__ITEM #7510', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7511, 'ITEM #7511__ITEM #7511', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7512, 'ITEM #7512__ITEM #7512', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7513, 'ITEM #7513__ITEM #7513', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7514, 'ITEM #7514__ITEM #7514', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7515, 'ITEM #7515__ITEM #7515', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7516, 'ITEM #7516__ITEM #7516', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7517, 'ITEM #7517__ITEM #7517', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7518, 'ITEM #7518__ITEM #7518', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7519, 'ITEM #7519__ITEM #7519', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7520, 'ITEM #7520__ITEM #7520', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7521, 'ITEM #7521__ITEM #7521', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7522, 'ITEM #7522__ITEM #7522', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7523, 'ITEM #7523__ITEM #7523', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7524, 'ITEM #7524__ITEM #7524', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7525, 'ITEM #7525__ITEM #7525', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7526, 'ITEM #7526__ITEM #7526', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7527, 'ITEM #7527__ITEM #7527', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7528, 'ITEM #7528__ITEM #7528', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7529, 'ITEM #7529__ITEM #7529', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7530, 'ITEM #7530__ITEM #7530', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7531, 'ITEM #7531__ITEM #7531', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7532, 'ITEM #7532__ITEM #7532', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7533, 'ITEM #7533__ITEM #7533', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7534, 'ITEM #7534__ITEM #7534', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7535, 'ITEM #7535__ITEM #7535', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7536, 'ITEM #7536__ITEM #7536', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7537, 'ITEM #7537__ITEM #7537', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7538, 'ITEM #7538__ITEM #7538', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7539, 'ITEM #7539__ITEM #7539', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7540, 'ITEM #7540__ITEM #7540', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7541, 'ITEM #7541__ITEM #7541', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7542, 'ITEM #7542__ITEM #7542', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7543, 'ITEM #7543__ITEM #7543', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7544, 'ITEM #7544__ITEM #7544', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7545, 'ITEM #7545__ITEM #7545', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7546, 'ITEM #7546__ITEM #7546', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7547, 'ITEM #7547__ITEM #7547', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7548, 'ITEM #7548__ITEM #7548', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7549, 'ITEM #7549__ITEM #7549', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7550, 'ITEM #7550__ITEM #7550', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7551, 'ITEM #7551__ITEM #7551', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7552, 'ITEM #7552__ITEM #7552', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7553, 'ITEM #7553__ITEM #7553', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7554, 'ITEM #7554__ITEM #7554', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7555, 'ITEM #7555__ITEM #7555', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7556, 'ITEM #7556__ITEM #7556', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7557, 'ITEM #7557__ITEM #7557', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7558, 'ITEM #7558__ITEM #7558', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7559, 'ITEM #7559__ITEM #7559', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7560, 'ITEM #7560__ITEM #7560', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7561, 'ITEM #7561__ITEM #7561', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7562, 'ITEM #7562__ITEM #7562', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7563, 'ITEM #7563__ITEM #7563', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7564, 'ITEM #7564__ITEM #7564', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7565, 'ITEM #7565__ITEM #7565', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7566, 'ITEM #7566__ITEM #7566', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7567, 'ITEM #7567__ITEM #7567', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7568, 'ITEM #7568__ITEM #7568', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7569, 'ITEM #7569__ITEM #7569', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7570, 'ITEM #7570__ITEM #7570', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7571, 'ITEM #7571__ITEM #7571', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7572, 'ITEM #7572__ITEM #7572', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7573, 'ITEM #7573__ITEM #7573', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7574, 'ITEM #7574__ITEM #7574', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7575, 'ITEM #7575__ITEM #7575', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7576, 'ITEM #7576__ITEM #7576', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7577, 'ITEM #7577__ITEM #7577', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7578, 'ITEM #7578__ITEM #7578', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7579, 'ITEM #7579__ITEM #7579', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7580, 'ITEM #7580__ITEM #7580', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7581, 'ITEM #7581__ITEM #7581', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7582, 'ITEM #7582__ITEM #7582', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7583, 'ITEM #7583__ITEM #7583', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7584, 'ITEM #7584__ITEM #7584', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7585, 'ITEM #7585__ITEM #7585', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7586, 'ITEM #7586__ITEM #7586', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7587, 'ITEM #7587__ITEM #7587', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7588, 'ITEM #7588__ITEM #7588', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7589, 'ITEM #7589__ITEM #7589', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7590, 'ITEM #7590__ITEM #7590', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7591, 'ITEM #7591__ITEM #7591', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7592, 'ITEM #7592__ITEM #7592', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7593, 'ITEM #7593__ITEM #7593', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7594, 'ITEM #7594__ITEM #7594', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7595, 'ITEM #7595__ITEM #7595', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7596, 'ITEM #7596__ITEM #7596', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7597, 'ITEM #7597__ITEM #7597', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7598, 'ITEM #7598__ITEM #7598', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7599, 'ITEM #7599__ITEM #7599', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7600, 'ITEM #7600__ITEM #7600', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7601, 'ITEM #7601__ITEM #7601', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7602, 'ITEM #7602__ITEM #7602', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7603, 'ITEM #7603__ITEM #7603', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7604, 'ITEM #7604__ITEM #7604', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7605, 'ITEM #7605__ITEM #7605', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7606, 'ITEM #7606__ITEM #7606', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7607, 'ITEM #7607__ITEM #7607', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7608, 'ITEM #7608__ITEM #7608', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7609, 'ITEM #7609__ITEM #7609', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7610, 'ITEM #7610__ITEM #7610', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7611, 'ITEM #7611__ITEM #7611', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7612, 'ITEM #7612__ITEM #7612', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7613, 'ITEM #7613__ITEM #7613', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7614, 'ITEM #7614__ITEM #7614', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7615, 'ITEM #7615__ITEM #7615', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7616, 'ITEM #7616__ITEM #7616', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7617, 'ITEM #7617__ITEM #7617', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7618, 'ITEM #7618__ITEM #7618', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7619, 'ITEM #7619__ITEM #7619', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7620, 'ITEM #7620__ITEM #7620', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7621, 'ITEM #7621__ITEM #7621', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7622, 'ITEM #7622__ITEM #7622', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7623, 'ITEM #7623__ITEM #7623', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7624, 'ITEM #7624__ITEM #7624', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7625, 'ITEM #7625__ITEM #7625', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7626, 'ITEM #7626__ITEM #7626', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7627, 'ITEM #7627__ITEM #7627', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7628, 'ITEM #7628__ITEM #7628', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7629, 'ITEM #7629__ITEM #7629', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7630, 'ITEM #7630__ITEM #7630', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7631, 'ITEM #7631__ITEM #7631', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7632, 'ITEM #7632__ITEM #7632', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7633, 'ITEM #7633__ITEM #7633', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7634, 'ITEM #7634__ITEM #7634', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7635, 'ITEM #7635__ITEM #7635', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7636, 'ITEM #7636__ITEM #7636', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7637, 'ITEM #7637__ITEM #7637', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7638, 'ITEM #7638__ITEM #7638', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7639, 'ITEM #7639__ITEM #7639', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7640, 'ITEM #7640__ITEM #7640', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7641, 'ITEM #7641__ITEM #7641', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7642, 'ITEM #7642__ITEM #7642', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7643, 'ITEM #7643__ITEM #7643', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7644, 'ITEM #7644__ITEM #7644', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7645, 'ITEM #7645__ITEM #7645', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7646, 'ITEM #7646__ITEM #7646', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7647, 'ITEM #7647__ITEM #7647', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7648, 'ITEM #7648__ITEM #7648', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7649, 'ITEM #7649__ITEM #7649', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7650, 'ITEM #7650__ITEM #7650', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7651, 'ITEM #7651__ITEM #7651', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7652, 'ITEM #7652__ITEM #7652', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7653, 'ITEM #7653__ITEM #7653', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7654, 'ITEM #7654__ITEM #7654', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7655, 'ITEM #7655__ITEM #7655', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7656, 'ITEM #7656__ITEM #7656', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7657, 'ITEM #7657__ITEM #7657', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7658, 'ITEM #7658__ITEM #7658', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7659, 'ITEM #7659__ITEM #7659', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7660, 'ITEM #7660__ITEM #7660', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7661, 'ITEM #7661__ITEM #7661', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7662, 'ITEM #7662__ITEM #7662', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7663, 'ITEM #7663__ITEM #7663', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7664, 'ITEM #7664__ITEM #7664', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7665, 'ITEM #7665__ITEM #7665', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7666, 'ITEM #7666__ITEM #7666', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7667, 'ITEM #7667__ITEM #7667', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7668, 'ITEM #7668__ITEM #7668', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7669, 'ITEM #7669__ITEM #7669', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7670, 'ITEM #7670__ITEM #7670', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7671, 'ITEM #7671__ITEM #7671', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7672, 'ITEM #7672__ITEM #7672', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7673, 'ITEM #7673__ITEM #7673', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7674, 'ITEM #7674__ITEM #7674', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7675, 'ITEM #7675__ITEM #7675', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7676, 'ITEM #7676__ITEM #7676', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7677, 'ITEM #7677__ITEM #7677', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7678, 'ITEM #7678__ITEM #7678', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7679, 'ITEM #7679__ITEM #7679', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7680, 'ITEM #7680__ITEM #7680', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7681, 'ITEM #7681__ITEM #7681', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7682, 'ITEM #7682__ITEM #7682', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7683, 'ITEM #7683__ITEM #7683', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7684, 'ITEM #7684__ITEM #7684', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7685, 'ITEM #7685__ITEM #7685', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7686, 'ITEM #7686__ITEM #7686', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7687, 'ITEM #7687__ITEM #7687', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7688, 'ITEM #7688__ITEM #7688', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7689, 'ITEM #7689__ITEM #7689', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7690, 'ITEM #7690__ITEM #7690', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7691, 'ITEM #7691__ITEM #7691', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7692, 'ITEM #7692__ITEM #7692', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7693, 'ITEM #7693__ITEM #7693', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7694, 'ITEM #7694__ITEM #7694', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7695, 'ITEM #7695__ITEM #7695', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7696, 'ITEM #7696__ITEM #7696', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7697, 'ITEM #7697__ITEM #7697', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7698, 'ITEM #7698__ITEM #7698', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7699, 'ITEM #7699__ITEM #7699', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7700, 'ITEM #7700__ITEM #7700', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7701, 'ITEM #7701__ITEM #7701', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7702, 'ITEM #7702__ITEM #7702', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7703, 'ITEM #7703__ITEM #7703', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7704, 'ITEM #7704__ITEM #7704', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7705, 'ITEM #7705__ITEM #7705', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7706, 'ITEM #7706__ITEM #7706', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7707, 'ITEM #7707__ITEM #7707', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7708, 'ITEM #7708__ITEM #7708', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7709, 'ITEM #7709__ITEM #7709', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7710, 'ITEM #7710__ITEM #7710', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7711, 'ITEM #7711__ITEM #7711', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7712, 'ITEM #7712__ITEM #7712', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7713, 'ITEM #7713__ITEM #7713', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7714, 'ITEM #7714__ITEM #7714', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7715, 'ITEM #7715__ITEM #7715', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7716, 'ITEM #7716__ITEM #7716', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7717, 'ITEM #7717__ITEM #7717', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7718, 'ITEM #7718__ITEM #7718', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7719, 'ITEM #7719__ITEM #7719', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7720, 'ITEM #7720__ITEM #7720', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7721, 'ITEM #7721__ITEM #7721', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7722, 'ITEM #7722__ITEM #7722', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7723, 'ITEM #7723__ITEM #7723', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7724, 'ITEM #7724__ITEM #7724', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7725, 'ITEM #7725__ITEM #7725', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7726, 'ITEM #7726__ITEM #7726', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7727, 'ITEM #7727__ITEM #7727', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7728, 'ITEM #7728__ITEM #7728', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7729, 'ITEM #7729__ITEM #7729', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7730, 'ITEM #7730__ITEM #7730', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7731, 'ITEM #7731__ITEM #7731', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7732, 'ITEM #7732__ITEM #7732', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7733, 'ITEM #7733__ITEM #7733', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7734, 'ITEM #7734__ITEM #7734', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7735, 'ITEM #7735__ITEM #7735', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7736, 'ITEM #7736__ITEM #7736', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7737, 'ITEM #7737__ITEM #7737', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7738, 'ITEM #7738__ITEM #7738', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7739, 'ITEM #7739__ITEM #7739', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7740, 'ITEM #7740__ITEM #7740', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7741, 'ITEM #7741__ITEM #7741', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7742, 'ITEM #7742__ITEM #7742', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7743, 'ITEM #7743__ITEM #7743', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7744, 'ITEM #7744__ITEM #7744', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7745, 'ITEM #7745__ITEM #7745', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7746, 'ITEM #7746__ITEM #7746', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7747, 'ITEM #7747__ITEM #7747', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7748, 'ITEM #7748__ITEM #7748', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7749, 'ITEM #7749__ITEM #7749', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7750, 'ITEM #7750__ITEM #7750', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7751, 'ITEM #7751__ITEM #7751', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7752, 'ITEM #7752__ITEM #7752', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7753, 'ITEM #7753__ITEM #7753', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7754, 'ITEM #7754__ITEM #7754', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7755, 'ITEM #7755__ITEM #7755', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7756, 'ITEM #7756__ITEM #7756', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7757, 'ITEM #7757__ITEM #7757', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7758, 'ITEM #7758__ITEM #7758', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7759, 'ITEM #7759__ITEM #7759', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7760, 'ITEM #7760__ITEM #7760', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7761, 'ITEM #7761__ITEM #7761', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7762, 'ITEM #7762__ITEM #7762', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7763, 'ITEM #7763__ITEM #7763', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7764, 'ITEM #7764__ITEM #7764', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7765, 'ITEM #7765__ITEM #7765', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7766, 'ITEM #7766__ITEM #7766', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7767, 'ITEM #7767__ITEM #7767', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7768, 'ITEM #7768__ITEM #7768', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7769, 'ITEM #7769__ITEM #7769', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7770, 'ITEM #7770__ITEM #7770', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7771, 'ITEM #7771__ITEM #7771', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7772, 'ITEM #7772__ITEM #7772', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7773, 'ITEM #7773__ITEM #7773', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7774, 'ITEM #7774__ITEM #7774', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7775, 'ITEM #7775__ITEM #7775', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7776, 'ITEM #7776__ITEM #7776', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7777, 'ITEM #7777__ITEM #7777', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7778, 'ITEM #7778__ITEM #7778', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7779, 'ITEM #7779__ITEM #7779', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7780, 'ITEM #7780__ITEM #7780', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7781, 'ITEM #7781__ITEM #7781', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7782, 'ITEM #7782__ITEM #7782', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7783, 'ITEM #7783__ITEM #7783', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7784, 'ITEM #7784__ITEM #7784', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7785, 'ITEM #7785__ITEM #7785', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7786, 'ITEM #7786__ITEM #7786', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7787, 'ITEM #7787__ITEM #7787', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7788, 'ITEM #7788__ITEM #7788', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7789, 'ITEM #7789__ITEM #7789', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7790, 'ITEM #7790__ITEM #7790', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7791, 'ITEM #7791__ITEM #7791', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7792, 'ITEM #7792__ITEM #7792', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7793, 'ITEM #7793__ITEM #7793', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7794, 'ITEM #7794__ITEM #7794', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7795, 'ITEM #7795__ITEM #7795', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7796, 'ITEM #7796__ITEM #7796', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7797, 'ITEM #7797__ITEM #7797', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7798, 'ITEM #7798__ITEM #7798', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7799, 'ITEM #7799__ITEM #7799', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7800, 'ITEM #7800__ITEM #7800', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7801, 'ITEM #7801__ITEM #7801', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7802, 'ITEM #7802__ITEM #7802', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7803, 'ITEM #7803__ITEM #7803', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7804, 'ITEM #7804__ITEM #7804', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7805, 'ITEM #7805__ITEM #7805', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7806, 'ITEM #7806__ITEM #7806', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7807, 'ITEM #7807__ITEM #7807', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7808, 'ITEM #7808__ITEM #7808', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7809, 'ITEM #7809__ITEM #7809', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7810, 'ITEM #7810__ITEM #7810', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7811, 'ITEM #7811__ITEM #7811', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7812, 'ITEM #7812__ITEM #7812', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7813, 'ITEM #7813__ITEM #7813', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7814, 'ITEM #7814__ITEM #7814', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7815, 'ITEM #7815__ITEM #7815', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7816, 'ITEM #7816__ITEM #7816', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7817, 'ITEM #7817__ITEM #7817', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7818, 'ITEM #7818__ITEM #7818', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7819, 'ITEM #7819__ITEM #7819', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7820, 'ITEM #7820__ITEM #7820', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7821, 'ITEM #7821__ITEM #7821', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7822, 'ITEM #7822__ITEM #7822', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7823, 'ITEM #7823__ITEM #7823', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7824, 'ITEM #7824__ITEM #7824', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7825, 'ITEM #7825__ITEM #7825', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7826, 'ITEM #7826__ITEM #7826', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7827, 'ITEM #7827__ITEM #7827', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7828, 'ITEM #7828__ITEM #7828', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7829, 'ITEM #7829__ITEM #7829', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7830, 'ITEM #7830__ITEM #7830', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7831, 'ITEM #7831__ITEM #7831', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7832, 'ITEM #7832__ITEM #7832', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7833, 'ITEM #7833__ITEM #7833', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7834, 'ITEM #7834__ITEM #7834', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7835, 'ITEM #7835__ITEM #7835', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7836, 'ITEM #7836__ITEM #7836', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7837, 'ITEM #7837__ITEM #7837', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7838, 'ITEM #7838__ITEM #7838', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7839, 'ITEM #7839__ITEM #7839', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7840, 'ITEM #7840__ITEM #7840', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7841, 'ITEM #7841__ITEM #7841', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7842, 'ITEM #7842__ITEM #7842', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7843, 'ITEM #7843__ITEM #7843', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7844, 'ITEM #7844__ITEM #7844', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7845, 'ITEM #7845__ITEM #7845', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7846, 'ITEM #7846__ITEM #7846', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7847, 'ITEM #7847__ITEM #7847', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7848, 'ITEM #7848__ITEM #7848', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7849, 'ITEM #7849__ITEM #7849', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7850, 'ITEM #7850__ITEM #7850', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7851, 'ITEM #7851__ITEM #7851', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7852, 'ITEM #7852__ITEM #7852', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7853, 'ITEM #7853__ITEM #7853', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7854, 'ITEM #7854__ITEM #7854', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7855, 'ITEM #7855__ITEM #7855', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7856, 'ITEM #7856__ITEM #7856', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7857, 'ITEM #7857__ITEM #7857', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7858, 'ITEM #7858__ITEM #7858', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7859, 'ITEM #7859__ITEM #7859', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7860, 'ITEM #7860__ITEM #7860', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7861, 'ITEM #7861__ITEM #7861', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7862, 'ITEM #7862__ITEM #7862', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7863, 'ITEM #7863__ITEM #7863', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7864, 'ITEM #7864__ITEM #7864', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7865, 'ITEM #7865__ITEM #7865', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7866, 'ITEM #7866__ITEM #7866', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7867, 'ITEM #7867__ITEM #7867', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7868, 'ITEM #7868__ITEM #7868', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7869, 'ITEM #7869__ITEM #7869', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7870, 'ITEM #7870__ITEM #7870', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7871, 'ITEM #7871__ITEM #7871', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7872, 'ITEM #7872__ITEM #7872', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7873, 'ITEM #7873__ITEM #7873', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7874, 'ITEM #7874__ITEM #7874', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7875, 'ITEM #7875__ITEM #7875', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7876, 'ITEM #7876__ITEM #7876', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7877, 'ITEM #7877__ITEM #7877', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7878, 'ITEM #7878__ITEM #7878', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7879, 'ITEM #7879__ITEM #7879', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7880, 'ITEM #7880__ITEM #7880', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7881, 'ITEM #7881__ITEM #7881', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7882, 'ITEM #7882__ITEM #7882', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7883, 'ITEM #7883__ITEM #7883', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7884, 'ITEM #7884__ITEM #7884', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7885, 'ITEM #7885__ITEM #7885', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7886, 'ITEM #7886__ITEM #7886', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7887, 'ITEM #7887__ITEM #7887', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7888, 'ITEM #7888__ITEM #7888', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7889, 'ITEM #7889__ITEM #7889', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7890, 'ITEM #7890__ITEM #7890', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7891, 'ITEM #7891__ITEM #7891', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7892, 'ITEM #7892__ITEM #7892', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7893, 'ITEM #7893__ITEM #7893', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7894, 'ITEM #7894__ITEM #7894', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7895, 'ITEM #7895__ITEM #7895', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7896, 'ITEM #7896__ITEM #7896', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7897, 'ITEM #7897__ITEM #7897', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7898, 'ITEM #7898__ITEM #7898', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7899, 'ITEM #7899__ITEM #7899', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7900, 'ITEM #7900__ITEM #7900', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7901, 'ITEM #7901__ITEM #7901', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7902, 'ITEM #7902__ITEM #7902', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7903, 'ITEM #7903__ITEM #7903', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7904, 'ITEM #7904__ITEM #7904', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7905, 'ITEM #7905__ITEM #7905', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7906, 'ITEM #7906__ITEM #7906', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7907, 'ITEM #7907__ITEM #7907', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7908, 'ITEM #7908__ITEM #7908', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7909, 'ITEM #7909__ITEM #7909', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7910, 'ITEM #7910__ITEM #7910', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7911, 'ITEM #7911__ITEM #7911', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7912, 'ITEM #7912__ITEM #7912', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7913, 'ITEM #7913__ITEM #7913', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7914, 'ITEM #7914__ITEM #7914', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7915, 'ITEM #7915__ITEM #7915', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7916, 'ITEM #7916__ITEM #7916', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7917, 'ITEM #7917__ITEM #7917', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7918, 'ITEM #7918__ITEM #7918', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7919, 'ITEM #7919__ITEM #7919', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7920, 'ITEM #7920__ITEM #7920', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7921, 'ITEM #7921__ITEM #7921', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7922, 'ITEM #7922__ITEM #7922', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7923, 'ITEM #7923__ITEM #7923', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7924, 'ITEM #7924__ITEM #7924', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7925, 'ITEM #7925__ITEM #7925', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7926, 'ITEM #7926__ITEM #7926', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7927, 'ITEM #7927__ITEM #7927', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7928, 'ITEM #7928__ITEM #7928', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7929, 'ITEM #7929__ITEM #7929', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7930, 'ITEM #7930__ITEM #7930', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7931, 'ITEM #7931__ITEM #7931', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7932, 'ITEM #7932__ITEM #7932', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7933, 'ITEM #7933__ITEM #7933', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7934, 'ITEM #7934__ITEM #7934', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7935, 'ITEM #7935__ITEM #7935', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7936, 'ITEM #7936__ITEM #7936', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7937, 'ITEM #7937__ITEM #7937', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7938, 'ITEM #7938__ITEM #7938', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7939, 'ITEM #7939__ITEM #7939', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7940, 'ITEM #7940__ITEM #7940', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7941, 'ITEM #7941__ITEM #7941', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7942, 'ITEM #7942__ITEM #7942', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7943, 'ITEM #7943__ITEM #7943', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7944, 'ITEM #7944__ITEM #7944', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7945, 'ITEM #7945__ITEM #7945', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7946, 'ITEM #7946__ITEM #7946', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7947, 'ITEM #7947__ITEM #7947', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7948, 'ITEM #7948__ITEM #7948', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7949, 'ITEM #7949__ITEM #7949', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7950, 'ITEM #7950__ITEM #7950', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7951, 'ITEM #7951__ITEM #7951', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7952, 'ITEM #7952__ITEM #7952', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7953, 'ITEM #7953__ITEM #7953', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7954, 'ITEM #7954__ITEM #7954', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7955, 'ITEM #7955__ITEM #7955', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7956, 'ITEM #7956__ITEM #7956', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7957, 'ITEM #7957__ITEM #7957', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7958, 'ITEM #7958__ITEM #7958', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7959, 'ITEM #7959__ITEM #7959', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7960, 'ITEM #7960__ITEM #7960', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7961, 'ITEM #7961__ITEM #7961', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7962, 'ITEM #7962__ITEM #7962', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7963, 'ITEM #7963__ITEM #7963', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7964, 'ITEM #7964__ITEM #7964', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7965, 'ITEM #7965__ITEM #7965', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7966, 'ITEM #7966__ITEM #7966', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7967, 'ITEM #7967__ITEM #7967', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7968, 'ITEM #7968__ITEM #7968', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7969, 'ITEM #7969__ITEM #7969', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7970, 'ITEM #7970__ITEM #7970', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7971, 'ITEM #7971__ITEM #7971', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7972, 'ITEM #7972__ITEM #7972', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7973, 'ITEM #7973__ITEM #7973', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7974, 'ITEM #7974__ITEM #7974', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7975, 'ITEM #7975__ITEM #7975', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7976, 'ITEM #7976__ITEM #7976', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7977, 'ITEM #7977__ITEM #7977', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7978, 'ITEM #7978__ITEM #7978', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7979, 'ITEM #7979__ITEM #7979', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7980, 'ITEM #7980__ITEM #7980', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7981, 'ITEM #7981__ITEM #7981', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7982, 'ITEM #7982__ITEM #7982', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7983, 'ITEM #7983__ITEM #7983', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7984, 'ITEM #7984__ITEM #7984', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7985, 'ITEM #7985__ITEM #7985', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7986, 'ITEM #7986__ITEM #7986', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7987, 'ITEM #7987__ITEM #7987', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7988, 'ITEM #7988__ITEM #7988', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7989, 'ITEM #7989__ITEM #7989', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7990, 'ITEM #7990__ITEM #7990', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7991, 'ITEM #7991__ITEM #7991', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7992, 'ITEM #7992__ITEM #7992', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7993, 'ITEM #7993__ITEM #7993', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7994, 'ITEM #7994__ITEM #7994', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7995, 'ITEM #7995__ITEM #7995', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7996, 'ITEM #7996__ITEM #7996', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7997, 'ITEM #7997__ITEM #7997', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7998, 'ITEM #7998__ITEM #7998', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (7999, 'ITEM #7999__ITEM #7999', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8000, 'ITEM #8000__ITEM #8000', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8001, 'ITEM #8001__ITEM #8001', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8002, 'ITEM #8002__ITEM #8002', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8003, 'ITEM #8003__ITEM #8003', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8004, 'ITEM #8004__ITEM #8004', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8005, 'ITEM #8005__ITEM #8005', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8006, 'ITEM #8006__ITEM #8006', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8007, 'ITEM #8007__ITEM #8007', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8008, 'ITEM #8008__ITEM #8008', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8009, 'ITEM #8009__ITEM #8009', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8010, 'ITEM #8010__ITEM #8010', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8011, 'ITEM #8011__ITEM #8011', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8012, 'ITEM #8012__ITEM #8012', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8013, 'ITEM #8013__ITEM #8013', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8014, 'ITEM #8014__ITEM #8014', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8015, 'ITEM #8015__ITEM #8015', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8016, 'ITEM #8016__ITEM #8016', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8017, 'ITEM #8017__ITEM #8017', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8018, 'ITEM #8018__ITEM #8018', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8019, 'ITEM #8019__ITEM #8019', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8020, 'ITEM #8020__ITEM #8020', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8021, 'ITEM #8021__ITEM #8021', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8022, 'ITEM #8022__ITEM #8022', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8023, 'ITEM #8023__ITEM #8023', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8024, 'ITEM #8024__ITEM #8024', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8025, 'ITEM #8025__ITEM #8025', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8026, 'ITEM #8026__ITEM #8026', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8027, 'ITEM #8027__ITEM #8027', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8028, 'ITEM #8028__ITEM #8028', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8029, 'ITEM #8029__ITEM #8029', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8030, 'ITEM #8030__ITEM #8030', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8031, 'ITEM #8031__ITEM #8031', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8032, 'ITEM #8032__ITEM #8032', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8033, 'ITEM #8033__ITEM #8033', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8034, 'ITEM #8034__ITEM #8034', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8035, 'ITEM #8035__ITEM #8035', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8036, 'ITEM #8036__ITEM #8036', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8037, 'ITEM #8037__ITEM #8037', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8038, 'ITEM #8038__ITEM #8038', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8039, 'ITEM #8039__ITEM #8039', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8040, 'ITEM #8040__ITEM #8040', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8041, 'ITEM #8041__ITEM #8041', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8042, 'ITEM #8042__ITEM #8042', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8043, 'ITEM #8043__ITEM #8043', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8044, 'ITEM #8044__ITEM #8044', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8045, 'ITEM #8045__ITEM #8045', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8046, 'ITEM #8046__ITEM #8046', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8047, 'ITEM #8047__ITEM #8047', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8048, 'ITEM #8048__ITEM #8048', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8049, 'ITEM #8049__ITEM #8049', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8050, 'ITEM #8050__ITEM #8050', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8051, 'ITEM #8051__ITEM #8051', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8052, 'ITEM #8052__ITEM #8052', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8053, 'ITEM #8053__ITEM #8053', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8054, 'ITEM #8054__ITEM #8054', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8055, 'ITEM #8055__ITEM #8055', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8056, 'ITEM #8056__ITEM #8056', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8057, 'ITEM #8057__ITEM #8057', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8058, 'ITEM #8058__ITEM #8058', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8059, 'ITEM #8059__ITEM #8059', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8060, 'ITEM #8060__ITEM #8060', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8061, 'ITEM #8061__ITEM #8061', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8062, 'ITEM #8062__ITEM #8062', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8063, 'ITEM #8063__ITEM #8063', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8064, 'ITEM #8064__ITEM #8064', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8065, 'ITEM #8065__ITEM #8065', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8066, 'ITEM #8066__ITEM #8066', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8067, 'ITEM #8067__ITEM #8067', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8068, 'ITEM #8068__ITEM #8068', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8069, 'ITEM #8069__ITEM #8069', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8070, 'ITEM #8070__ITEM #8070', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8071, 'ITEM #8071__ITEM #8071', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8072, 'ITEM #8072__ITEM #8072', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8073, 'ITEM #8073__ITEM #8073', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8074, 'ITEM #8074__ITEM #8074', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8075, 'ITEM #8075__ITEM #8075', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8076, 'ITEM #8076__ITEM #8076', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8077, 'ITEM #8077__ITEM #8077', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8078, 'ITEM #8078__ITEM #8078', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8079, 'ITEM #8079__ITEM #8079', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8080, 'ITEM #8080__ITEM #8080', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8081, 'ITEM #8081__ITEM #8081', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8082, 'ITEM #8082__ITEM #8082', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8083, 'ITEM #8083__ITEM #8083', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8084, 'ITEM #8084__ITEM #8084', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8085, 'ITEM #8085__ITEM #8085', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8086, 'ITEM #8086__ITEM #8086', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8087, 'ITEM #8087__ITEM #8087', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8088, 'ITEM #8088__ITEM #8088', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8089, 'ITEM #8089__ITEM #8089', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8090, 'ITEM #8090__ITEM #8090', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8091, 'ITEM #8091__ITEM #8091', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8092, 'ITEM #8092__ITEM #8092', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8093, 'ITEM #8093__ITEM #8093', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8094, 'ITEM #8094__ITEM #8094', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8095, 'ITEM #8095__ITEM #8095', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8096, 'ITEM #8096__ITEM #8096', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8097, 'ITEM #8097__ITEM #8097', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8098, 'ITEM #8098__ITEM #8098', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8099, 'ITEM #8099__ITEM #8099', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8100, 'ITEM #8100__ITEM #8100', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8101, 'ITEM #8101__ITEM #8101', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8102, 'ITEM #8102__ITEM #8102', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8103, 'ITEM #8103__ITEM #8103', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8104, 'ITEM #8104__ITEM #8104', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8105, 'ITEM #8105__ITEM #8105', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8106, 'ITEM #8106__ITEM #8106', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8107, 'ITEM #8107__ITEM #8107', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8108, 'ITEM #8108__ITEM #8108', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8109, 'ITEM #8109__ITEM #8109', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8110, 'ITEM #8110__ITEM #8110', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8111, 'ITEM #8111__ITEM #8111', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8112, 'ITEM #8112__ITEM #8112', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8113, 'ITEM #8113__ITEM #8113', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8114, 'ITEM #8114__ITEM #8114', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8115, 'ITEM #8115__ITEM #8115', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8116, 'ITEM #8116__ITEM #8116', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8117, 'ITEM #8117__ITEM #8117', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8118, 'ITEM #8118__ITEM #8118', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8119, 'ITEM #8119__ITEM #8119', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8120, 'ITEM #8120__ITEM #8120', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8121, 'ITEM #8121__ITEM #8121', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8122, 'ITEM #8122__ITEM #8122', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8123, 'ITEM #8123__ITEM #8123', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8124, 'ITEM #8124__ITEM #8124', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8125, 'ITEM #8125__ITEM #8125', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8126, 'ITEM #8126__ITEM #8126', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8127, 'ITEM #8127__ITEM #8127', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8128, 'ITEM #8128__ITEM #8128', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8129, 'ITEM #8129__ITEM #8129', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8130, 'ITEM #8130__ITEM #8130', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8131, 'ITEM #8131__ITEM #8131', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8132, 'ITEM #8132__ITEM #8132', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8133, 'ITEM #8133__ITEM #8133', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8134, 'ITEM #8134__ITEM #8134', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8135, 'ITEM #8135__ITEM #8135', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8136, 'ITEM #8136__ITEM #8136', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8137, 'ITEM #8137__ITEM #8137', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8138, 'ITEM #8138__ITEM #8138', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8139, 'ITEM #8139__ITEM #8139', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8140, 'ITEM #8140__ITEM #8140', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8141, 'ITEM #8141__ITEM #8141', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8142, 'ITEM #8142__ITEM #8142', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8143, 'ITEM #8143__ITEM #8143', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8144, 'ITEM #8144__ITEM #8144', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8145, 'ITEM #8145__ITEM #8145', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8146, 'ITEM #8146__ITEM #8146', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8147, 'ITEM #8147__ITEM #8147', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8148, 'ITEM #8148__ITEM #8148', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8149, 'ITEM #8149__ITEM #8149', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8150, 'ITEM #8150__ITEM #8150', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8151, 'ITEM #8151__ITEM #8151', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8152, 'ITEM #8152__ITEM #8152', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8153, 'ITEM #8153__ITEM #8153', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8154, 'ITEM #8154__ITEM #8154', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8155, 'ITEM #8155__ITEM #8155', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8156, 'ITEM #8156__ITEM #8156', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8157, 'ITEM #8157__ITEM #8157', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8158, 'ITEM #8158__ITEM #8158', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8159, 'ITEM #8159__ITEM #8159', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8160, 'ITEM #8160__ITEM #8160', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8161, 'ITEM #8161__ITEM #8161', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8162, 'ITEM #8162__ITEM #8162', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8163, 'ITEM #8163__ITEM #8163', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8164, 'ITEM #8164__ITEM #8164', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8165, 'ITEM #8165__ITEM #8165', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8166, 'ITEM #8166__ITEM #8166', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8167, 'ITEM #8167__ITEM #8167', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8168, 'ITEM #8168__ITEM #8168', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8169, 'ITEM #8169__ITEM #8169', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8170, 'ITEM #8170__ITEM #8170', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8171, 'ITEM #8171__ITEM #8171', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8172, 'ITEM #8172__ITEM #8172', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8173, 'ITEM #8173__ITEM #8173', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8174, 'ITEM #8174__ITEM #8174', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8175, 'ITEM #8175__ITEM #8175', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8176, 'ITEM #8176__ITEM #8176', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8177, 'ITEM #8177__ITEM #8177', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8178, 'ITEM #8178__ITEM #8178', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8179, 'ITEM #8179__ITEM #8179', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8180, 'ITEM #8180__ITEM #8180', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8181, 'ITEM #8181__ITEM #8181', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8182, 'ITEM #8182__ITEM #8182', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8183, 'ITEM #8183__ITEM #8183', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8184, 'ITEM #8184__ITEM #8184', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8185, 'ITEM #8185__ITEM #8185', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8186, 'ITEM #8186__ITEM #8186', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8187, 'ITEM #8187__ITEM #8187', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8188, 'ITEM #8188__ITEM #8188', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8189, 'ITEM #8189__ITEM #8189', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8190, 'ITEM #8190__ITEM #8190', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8191, 'ITEM #8191__ITEM #8191', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8192, 'ITEM #8192__ITEM #8192', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8193, 'ITEM #8193__ITEM #8193', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8194, 'ITEM #8194__ITEM #8194', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8195, 'ITEM #8195__ITEM #8195', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8196, 'ITEM #8196__ITEM #8196', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8197, 'ITEM #8197__ITEM #8197', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8198, 'ITEM #8198__ITEM #8198', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8199, 'ITEM #8199__ITEM #8199', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8200, 'ITEM #8200__ITEM #8200', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8201, 'ITEM #8201__ITEM #8201', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8202, 'ITEM #8202__ITEM #8202', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8203, 'ITEM #8203__ITEM #8203', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8204, 'ITEM #8204__ITEM #8204', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8205, 'ITEM #8205__ITEM #8205', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8206, 'ITEM #8206__ITEM #8206', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8207, 'ITEM #8207__ITEM #8207', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8208, 'ITEM #8208__ITEM #8208', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8209, 'ITEM #8209__ITEM #8209', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8210, 'ITEM #8210__ITEM #8210', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8211, 'ITEM #8211__ITEM #8211', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8212, 'ITEM #8212__ITEM #8212', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8213, 'ITEM #8213__ITEM #8213', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8214, 'ITEM #8214__ITEM #8214', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8215, 'ITEM #8215__ITEM #8215', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8216, 'ITEM #8216__ITEM #8216', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8217, 'ITEM #8217__ITEM #8217', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8218, 'ITEM #8218__ITEM #8218', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8219, 'ITEM #8219__ITEM #8219', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8220, 'ITEM #8220__ITEM #8220', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8221, 'ITEM #8221__ITEM #8221', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8222, 'ITEM #8222__ITEM #8222', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8223, 'ITEM #8223__ITEM #8223', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8224, 'ITEM #8224__ITEM #8224', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8225, 'ITEM #8225__ITEM #8225', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8226, 'ITEM #8226__ITEM #8226', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8227, 'ITEM #8227__ITEM #8227', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8228, 'ITEM #8228__ITEM #8228', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8229, 'ITEM #8229__ITEM #8229', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8230, 'ITEM #8230__ITEM #8230', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8231, 'ITEM #8231__ITEM #8231', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8232, 'ITEM #8232__ITEM #8232', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8233, 'ITEM #8233__ITEM #8233', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8234, 'ITEM #8234__ITEM #8234', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8235, 'ITEM #8235__ITEM #8235', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8236, 'ITEM #8236__ITEM #8236', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8237, 'ITEM #8237__ITEM #8237', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8238, 'ITEM #8238__ITEM #8238', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8239, 'ITEM #8239__ITEM #8239', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8240, 'ITEM #8240__ITEM #8240', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8241, 'ITEM #8241__ITEM #8241', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8242, 'ITEM #8242__ITEM #8242', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8243, 'ITEM #8243__ITEM #8243', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8244, 'ITEM #8244__ITEM #8244', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8245, 'ITEM #8245__ITEM #8245', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8246, 'ITEM #8246__ITEM #8246', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8247, 'ITEM #8247__ITEM #8247', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8248, 'ITEM #8248__ITEM #8248', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8249, 'ITEM #8249__ITEM #8249', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8250, 'ITEM #8250__ITEM #8250', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8251, 'ITEM #8251__ITEM #8251', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8252, 'ITEM #8252__ITEM #8252', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8253, 'ITEM #8253__ITEM #8253', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8254, 'ITEM #8254__ITEM #8254', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8255, 'ITEM #8255__ITEM #8255', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8256, 'ITEM #8256__ITEM #8256', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8257, 'ITEM #8257__ITEM #8257', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8258, 'ITEM #8258__ITEM #8258', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8259, 'ITEM #8259__ITEM #8259', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8260, 'ITEM #8260__ITEM #8260', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8261, 'ITEM #8261__ITEM #8261', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8262, 'ITEM #8262__ITEM #8262', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8263, 'ITEM #8263__ITEM #8263', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8264, 'ITEM #8264__ITEM #8264', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8265, 'ITEM #8265__ITEM #8265', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8266, 'ITEM #8266__ITEM #8266', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8267, 'ITEM #8267__ITEM #8267', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8268, 'ITEM #8268__ITEM #8268', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8269, 'ITEM #8269__ITEM #8269', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8270, 'ITEM #8270__ITEM #8270', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8271, 'ITEM #8271__ITEM #8271', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8272, 'ITEM #8272__ITEM #8272', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8273, 'ITEM #8273__ITEM #8273', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8274, 'ITEM #8274__ITEM #8274', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8275, 'ITEM #8275__ITEM #8275', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8276, 'ITEM #8276__ITEM #8276', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8277, 'ITEM #8277__ITEM #8277', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8278, 'ITEM #8278__ITEM #8278', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8279, 'ITEM #8279__ITEM #8279', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8280, 'ITEM #8280__ITEM #8280', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8281, 'ITEM #8281__ITEM #8281', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8282, 'ITEM #8282__ITEM #8282', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8283, 'ITEM #8283__ITEM #8283', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8284, 'ITEM #8284__ITEM #8284', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8285, 'ITEM #8285__ITEM #8285', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8286, 'ITEM #8286__ITEM #8286', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8287, 'ITEM #8287__ITEM #8287', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8288, 'ITEM #8288__ITEM #8288', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8289, 'ITEM #8289__ITEM #8289', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8290, 'ITEM #8290__ITEM #8290', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8291, 'ITEM #8291__ITEM #8291', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8292, 'ITEM #8292__ITEM #8292', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8293, 'ITEM #8293__ITEM #8293', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8294, 'ITEM #8294__ITEM #8294', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8295, 'ITEM #8295__ITEM #8295', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8296, 'ITEM #8296__ITEM #8296', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8297, 'ITEM #8297__ITEM #8297', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8298, 'ITEM #8298__ITEM #8298', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8299, 'ITEM #8299__ITEM #8299', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8300, 'ITEM #8300__ITEM #8300', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8301, 'ITEM #8301__ITEM #8301', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8302, 'ITEM #8302__ITEM #8302', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8303, 'ITEM #8303__ITEM #8303', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8304, 'ITEM #8304__ITEM #8304', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8305, 'ITEM #8305__ITEM #8305', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8306, 'ITEM #8306__ITEM #8306', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8307, 'ITEM #8307__ITEM #8307', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8308, 'ITEM #8308__ITEM #8308', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8309, 'ITEM #8309__ITEM #8309', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8310, 'ITEM #8310__ITEM #8310', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8311, 'ITEM #8311__ITEM #8311', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8312, 'ITEM #8312__ITEM #8312', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8313, 'ITEM #8313__ITEM #8313', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8314, 'ITEM #8314__ITEM #8314', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8315, 'ITEM #8315__ITEM #8315', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8316, 'ITEM #8316__ITEM #8316', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8317, 'ITEM #8317__ITEM #8317', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8318, 'ITEM #8318__ITEM #8318', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8319, 'ITEM #8319__ITEM #8319', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8320, 'ITEM #8320__ITEM #8320', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8321, 'ITEM #8321__ITEM #8321', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8322, 'ITEM #8322__ITEM #8322', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8323, 'ITEM #8323__ITEM #8323', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8324, 'ITEM #8324__ITEM #8324', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8325, 'ITEM #8325__ITEM #8325', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8326, 'ITEM #8326__ITEM #8326', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8327, 'ITEM #8327__ITEM #8327', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8328, 'ITEM #8328__ITEM #8328', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8329, 'ITEM #8329__ITEM #8329', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8330, 'ITEM #8330__ITEM #8330', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8331, 'ITEM #8331__ITEM #8331', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8332, 'ITEM #8332__ITEM #8332', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8333, 'ITEM #8333__ITEM #8333', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8334, 'ITEM #8334__ITEM #8334', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8335, 'ITEM #8335__ITEM #8335', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8336, 'ITEM #8336__ITEM #8336', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8337, 'ITEM #8337__ITEM #8337', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8338, 'ITEM #8338__ITEM #8338', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8339, 'ITEM #8339__ITEM #8339', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8340, 'ITEM #8340__ITEM #8340', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8341, 'ITEM #8341__ITEM #8341', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8342, 'ITEM #8342__ITEM #8342', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8343, 'ITEM #8343__ITEM #8343', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8344, 'ITEM #8344__ITEM #8344', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8345, 'ITEM #8345__ITEM #8345', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8346, 'ITEM #8346__ITEM #8346', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8347, 'ITEM #8347__ITEM #8347', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8348, 'ITEM #8348__ITEM #8348', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8349, 'ITEM #8349__ITEM #8349', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8350, 'ITEM #8350__ITEM #8350', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8351, 'ITEM #8351__ITEM #8351', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8352, 'ITEM #8352__ITEM #8352', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8353, 'ITEM #8353__ITEM #8353', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8354, 'ITEM #8354__ITEM #8354', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8355, 'ITEM #8355__ITEM #8355', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8356, 'ITEM #8356__ITEM #8356', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8357, 'ITEM #8357__ITEM #8357', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8358, 'ITEM #8358__ITEM #8358', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8359, 'ITEM #8359__ITEM #8359', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8360, 'ITEM #8360__ITEM #8360', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8361, 'ITEM #8361__ITEM #8361', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8362, 'ITEM #8362__ITEM #8362', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8363, 'ITEM #8363__ITEM #8363', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8364, 'ITEM #8364__ITEM #8364', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8365, 'ITEM #8365__ITEM #8365', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8366, 'ITEM #8366__ITEM #8366', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8367, 'ITEM #8367__ITEM #8367', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8368, 'ITEM #8368__ITEM #8368', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8369, 'ITEM #8369__ITEM #8369', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8370, 'ITEM #8370__ITEM #8370', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8371, 'ITEM #8371__ITEM #8371', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8372, 'ITEM #8372__ITEM #8372', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8373, 'ITEM #8373__ITEM #8373', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8374, 'ITEM #8374__ITEM #8374', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8375, 'ITEM #8375__ITEM #8375', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8376, 'ITEM #8376__ITEM #8376', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8377, 'ITEM #8377__ITEM #8377', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8378, 'ITEM #8378__ITEM #8378', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8379, 'ITEM #8379__ITEM #8379', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8380, 'ITEM #8380__ITEM #8380', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8381, 'ITEM #8381__ITEM #8381', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8382, 'ITEM #8382__ITEM #8382', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8383, 'ITEM #8383__ITEM #8383', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8384, 'ITEM #8384__ITEM #8384', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8385, 'ITEM #8385__ITEM #8385', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8386, 'ITEM #8386__ITEM #8386', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8387, 'ITEM #8387__ITEM #8387', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8388, 'ITEM #8388__ITEM #8388', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8389, 'ITEM #8389__ITEM #8389', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8390, 'ITEM #8390__ITEM #8390', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8391, 'ITEM #8391__ITEM #8391', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8392, 'ITEM #8392__ITEM #8392', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8393, 'ITEM #8393__ITEM #8393', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8394, 'ITEM #8394__ITEM #8394', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8395, 'ITEM #8395__ITEM #8395', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8396, 'ITEM #8396__ITEM #8396', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8397, 'ITEM #8397__ITEM #8397', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8398, 'ITEM #8398__ITEM #8398', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8399, 'ITEM #8399__ITEM #8399', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8400, 'ITEM #8400__ITEM #8400', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8401, 'ITEM #8401__ITEM #8401', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8402, 'ITEM #8402__ITEM #8402', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8403, 'ITEM #8403__ITEM #8403', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8404, 'ITEM #8404__ITEM #8404', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8405, 'ITEM #8405__ITEM #8405', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8406, 'ITEM #8406__ITEM #8406', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8407, 'ITEM #8407__ITEM #8407', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8408, 'ITEM #8408__ITEM #8408', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8409, 'ITEM #8409__ITEM #8409', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8410, 'ITEM #8410__ITEM #8410', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8411, 'ITEM #8411__ITEM #8411', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8412, 'ITEM #8412__ITEM #8412', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8413, 'ITEM #8413__ITEM #8413', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8414, 'ITEM #8414__ITEM #8414', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8415, 'ITEM #8415__ITEM #8415', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8416, 'ITEM #8416__ITEM #8416', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8417, 'ITEM #8417__ITEM #8417', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8418, 'ITEM #8418__ITEM #8418', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8419, 'ITEM #8419__ITEM #8419', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8420, 'ITEM #8420__ITEM #8420', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8421, 'ITEM #8421__ITEM #8421', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8422, 'ITEM #8422__ITEM #8422', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8423, 'ITEM #8423__ITEM #8423', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8424, 'ITEM #8424__ITEM #8424', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8425, 'ITEM #8425__ITEM #8425', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8426, 'ITEM #8426__ITEM #8426', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8427, 'ITEM #8427__ITEM #8427', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8428, 'ITEM #8428__ITEM #8428', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8429, 'ITEM #8429__ITEM #8429', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8430, 'ITEM #8430__ITEM #8430', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8431, 'ITEM #8431__ITEM #8431', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8432, 'ITEM #8432__ITEM #8432', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8433, 'ITEM #8433__ITEM #8433', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8434, 'ITEM #8434__ITEM #8434', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8435, 'ITEM #8435__ITEM #8435', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8436, 'ITEM #8436__ITEM #8436', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8437, 'ITEM #8437__ITEM #8437', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8438, 'ITEM #8438__ITEM #8438', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8439, 'ITEM #8439__ITEM #8439', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8440, 'ITEM #8440__ITEM #8440', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8441, 'ITEM #8441__ITEM #8441', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8442, 'ITEM #8442__ITEM #8442', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8443, 'ITEM #8443__ITEM #8443', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8444, 'ITEM #8444__ITEM #8444', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8445, 'ITEM #8445__ITEM #8445', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8446, 'ITEM #8446__ITEM #8446', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8447, 'ITEM #8447__ITEM #8447', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8448, 'ITEM #8448__ITEM #8448', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8449, 'ITEM #8449__ITEM #8449', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8450, 'ITEM #8450__ITEM #8450', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8451, 'ITEM #8451__ITEM #8451', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8452, 'ITEM #8452__ITEM #8452', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8453, 'ITEM #8453__ITEM #8453', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8454, 'ITEM #8454__ITEM #8454', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8455, 'ITEM #8455__ITEM #8455', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8456, 'ITEM #8456__ITEM #8456', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8457, 'ITEM #8457__ITEM #8457', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8458, 'ITEM #8458__ITEM #8458', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8459, 'ITEM #8459__ITEM #8459', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8460, 'ITEM #8460__ITEM #8460', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8461, 'ITEM #8461__ITEM #8461', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8462, 'ITEM #8462__ITEM #8462', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8463, 'ITEM #8463__ITEM #8463', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8464, 'ITEM #8464__ITEM #8464', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8465, 'ITEM #8465__ITEM #8465', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8466, 'ITEM #8466__ITEM #8466', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8467, 'ITEM #8467__ITEM #8467', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8468, 'ITEM #8468__ITEM #8468', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8469, 'ITEM #8469__ITEM #8469', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8470, 'ITEM #8470__ITEM #8470', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8471, 'ITEM #8471__ITEM #8471', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8472, 'ITEM #8472__ITEM #8472', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8473, 'ITEM #8473__ITEM #8473', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8474, 'ITEM #8474__ITEM #8474', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8475, 'ITEM #8475__ITEM #8475', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8476, 'ITEM #8476__ITEM #8476', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8477, 'ITEM #8477__ITEM #8477', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8478, 'ITEM #8478__ITEM #8478', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8479, 'ITEM #8479__ITEM #8479', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8480, 'ITEM #8480__ITEM #8480', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8481, 'ITEM #8481__ITEM #8481', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8482, 'ITEM #8482__ITEM #8482', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8483, 'ITEM #8483__ITEM #8483', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8484, 'ITEM #8484__ITEM #8484', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8485, 'ITEM #8485__ITEM #8485', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8486, 'ITEM #8486__ITEM #8486', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8487, 'ITEM #8487__ITEM #8487', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8488, 'ITEM #8488__ITEM #8488', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8489, 'ITEM #8489__ITEM #8489', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8490, 'ITEM #8490__ITEM #8490', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8491, 'ITEM #8491__ITEM #8491', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8492, 'ITEM #8492__ITEM #8492', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8493, 'ITEM #8493__ITEM #8493', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8494, 'ITEM #8494__ITEM #8494', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8495, 'ITEM #8495__ITEM #8495', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8496, 'ITEM #8496__ITEM #8496', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8497, 'ITEM #8497__ITEM #8497', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8498, 'ITEM #8498__ITEM #8498', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8499, 'ITEM #8499__ITEM #8499', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8500, 'ITEM #8500__ITEM #8500', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8501, 'ITEM #8501__ITEM #8501', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8502, 'ITEM #8502__ITEM #8502', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8503, 'ITEM #8503__ITEM #8503', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8504, 'ITEM #8504__ITEM #8504', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8505, 'ITEM #8505__ITEM #8505', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8506, 'ITEM #8506__ITEM #8506', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8507, 'ITEM #8507__ITEM #8507', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8508, 'ITEM #8508__ITEM #8508', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8509, 'ITEM #8509__ITEM #8509', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8510, 'ITEM #8510__ITEM #8510', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8511, 'ITEM #8511__ITEM #8511', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8512, 'ITEM #8512__ITEM #8512', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8513, 'ITEM #8513__ITEM #8513', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8514, 'ITEM #8514__ITEM #8514', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8515, 'ITEM #8515__ITEM #8515', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8516, 'ITEM #8516__ITEM #8516', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8517, 'ITEM #8517__ITEM #8517', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8518, 'ITEM #8518__ITEM #8518', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8519, 'ITEM #8519__ITEM #8519', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8520, 'ITEM #8520__ITEM #8520', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8521, 'ITEM #8521__ITEM #8521', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8522, 'ITEM #8522__ITEM #8522', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8523, 'ITEM #8523__ITEM #8523', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8524, 'ITEM #8524__ITEM #8524', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8525, 'ITEM #8525__ITEM #8525', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8526, 'ITEM #8526__ITEM #8526', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8527, 'ITEM #8527__ITEM #8527', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8528, 'ITEM #8528__ITEM #8528', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8529, 'ITEM #8529__ITEM #8529', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8530, 'ITEM #8530__ITEM #8530', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8531, 'ITEM #8531__ITEM #8531', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8532, 'ITEM #8532__ITEM #8532', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8533, 'ITEM #8533__ITEM #8533', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8534, 'ITEM #8534__ITEM #8534', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8535, 'ITEM #8535__ITEM #8535', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8536, 'ITEM #8536__ITEM #8536', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8537, 'ITEM #8537__ITEM #8537', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8538, 'ITEM #8538__ITEM #8538', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8539, 'ITEM #8539__ITEM #8539', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8540, 'ITEM #8540__ITEM #8540', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8541, 'ITEM #8541__ITEM #8541', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8542, 'ITEM #8542__ITEM #8542', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8543, 'ITEM #8543__ITEM #8543', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8544, 'ITEM #8544__ITEM #8544', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8545, 'ITEM #8545__ITEM #8545', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8546, 'ITEM #8546__ITEM #8546', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8547, 'ITEM #8547__ITEM #8547', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8548, 'ITEM #8548__ITEM #8548', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8549, 'ITEM #8549__ITEM #8549', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8550, 'ITEM #8550__ITEM #8550', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8551, 'ITEM #8551__ITEM #8551', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8552, 'ITEM #8552__ITEM #8552', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8553, 'ITEM #8553__ITEM #8553', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8554, 'ITEM #8554__ITEM #8554', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8555, 'ITEM #8555__ITEM #8555', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8556, 'ITEM #8556__ITEM #8556', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8557, 'ITEM #8557__ITEM #8557', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8558, 'ITEM #8558__ITEM #8558', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8559, 'ITEM #8559__ITEM #8559', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8560, 'ITEM #8560__ITEM #8560', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8561, 'ITEM #8561__ITEM #8561', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8562, 'ITEM #8562__ITEM #8562', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8563, 'ITEM #8563__ITEM #8563', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8564, 'ITEM #8564__ITEM #8564', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8565, 'ITEM #8565__ITEM #8565', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8566, 'ITEM #8566__ITEM #8566', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8567, 'ITEM #8567__ITEM #8567', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8568, 'ITEM #8568__ITEM #8568', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8569, 'ITEM #8569__ITEM #8569', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8570, 'ITEM #8570__ITEM #8570', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8571, 'ITEM #8571__ITEM #8571', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8572, 'ITEM #8572__ITEM #8572', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8573, 'ITEM #8573__ITEM #8573', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8574, 'ITEM #8574__ITEM #8574', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8575, 'ITEM #8575__ITEM #8575', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8576, 'ITEM #8576__ITEM #8576', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8577, 'ITEM #8577__ITEM #8577', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8578, 'ITEM #8578__ITEM #8578', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8579, 'ITEM #8579__ITEM #8579', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8580, 'ITEM #8580__ITEM #8580', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8581, 'ITEM #8581__ITEM #8581', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8582, 'ITEM #8582__ITEM #8582', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8583, 'ITEM #8583__ITEM #8583', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8584, 'ITEM #8584__ITEM #8584', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8585, 'ITEM #8585__ITEM #8585', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8586, 'ITEM #8586__ITEM #8586', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8587, 'ITEM #8587__ITEM #8587', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8588, 'ITEM #8588__ITEM #8588', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8589, 'ITEM #8589__ITEM #8589', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8590, 'ITEM #8590__ITEM #8590', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8591, 'ITEM #8591__ITEM #8591', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8592, 'ITEM #8592__ITEM #8592', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8593, 'ITEM #8593__ITEM #8593', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8594, 'ITEM #8594__ITEM #8594', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8595, 'ITEM #8595__ITEM #8595', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8596, 'ITEM #8596__ITEM #8596', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8597, 'ITEM #8597__ITEM #8597', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8598, 'ITEM #8598__ITEM #8598', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8599, 'ITEM #8599__ITEM #8599', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8600, 'ITEM #8600__ITEM #8600', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8601, 'ITEM #8601__ITEM #8601', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8602, 'ITEM #8602__ITEM #8602', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8603, 'ITEM #8603__ITEM #8603', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8604, 'ITEM #8604__ITEM #8604', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8605, 'ITEM #8605__ITEM #8605', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8606, 'ITEM #8606__ITEM #8606', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8607, 'ITEM #8607__ITEM #8607', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8608, 'ITEM #8608__ITEM #8608', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8609, 'ITEM #8609__ITEM #8609', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8610, 'ITEM #8610__ITEM #8610', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8611, 'ITEM #8611__ITEM #8611', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8612, 'ITEM #8612__ITEM #8612', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8613, 'ITEM #8613__ITEM #8613', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8614, 'ITEM #8614__ITEM #8614', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8615, 'ITEM #8615__ITEM #8615', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8616, 'ITEM #8616__ITEM #8616', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8617, 'ITEM #8617__ITEM #8617', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8618, 'ITEM #8618__ITEM #8618', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8619, 'ITEM #8619__ITEM #8619', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8620, 'ITEM #8620__ITEM #8620', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8621, 'ITEM #8621__ITEM #8621', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8622, 'ITEM #8622__ITEM #8622', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8623, 'ITEM #8623__ITEM #8623', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8624, 'ITEM #8624__ITEM #8624', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8625, 'ITEM #8625__ITEM #8625', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8626, 'ITEM #8626__ITEM #8626', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8627, 'ITEM #8627__ITEM #8627', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8628, 'ITEM #8628__ITEM #8628', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8629, 'ITEM #8629__ITEM #8629', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8630, 'ITEM #8630__ITEM #8630', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8631, 'ITEM #8631__ITEM #8631', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8632, 'ITEM #8632__ITEM #8632', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8633, 'ITEM #8633__ITEM #8633', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8634, 'ITEM #8634__ITEM #8634', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8635, 'ITEM #8635__ITEM #8635', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8636, 'ITEM #8636__ITEM #8636', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8637, 'ITEM #8637__ITEM #8637', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8638, 'ITEM #8638__ITEM #8638', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8639, 'ITEM #8639__ITEM #8639', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8640, 'ITEM #8640__ITEM #8640', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8641, 'ITEM #8641__ITEM #8641', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8642, 'ITEM #8642__ITEM #8642', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8643, 'ITEM #8643__ITEM #8643', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8644, 'ITEM #8644__ITEM #8644', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8645, 'ITEM #8645__ITEM #8645', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8646, 'ITEM #8646__ITEM #8646', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8647, 'ITEM #8647__ITEM #8647', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8648, 'ITEM #8648__ITEM #8648', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8649, 'ITEM #8649__ITEM #8649', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8650, 'ITEM #8650__ITEM #8650', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8651, 'ITEM #8651__ITEM #8651', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8652, 'ITEM #8652__ITEM #8652', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8653, 'ITEM #8653__ITEM #8653', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8654, 'ITEM #8654__ITEM #8654', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8655, 'ITEM #8655__ITEM #8655', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8656, 'ITEM #8656__ITEM #8656', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8657, 'ITEM #8657__ITEM #8657', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8658, 'ITEM #8658__ITEM #8658', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8659, 'ITEM #8659__ITEM #8659', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8660, 'ITEM #8660__ITEM #8660', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8661, 'ITEM #8661__ITEM #8661', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8662, 'ITEM #8662__ITEM #8662', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8663, 'ITEM #8663__ITEM #8663', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8664, 'ITEM #8664__ITEM #8664', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8665, 'ITEM #8665__ITEM #8665', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8666, 'ITEM #8666__ITEM #8666', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8667, 'ITEM #8667__ITEM #8667', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8668, 'ITEM #8668__ITEM #8668', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8669, 'ITEM #8669__ITEM #8669', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8670, 'ITEM #8670__ITEM #8670', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8671, 'ITEM #8671__ITEM #8671', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8672, 'ITEM #8672__ITEM #8672', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8673, 'ITEM #8673__ITEM #8673', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8674, 'ITEM #8674__ITEM #8674', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8675, 'ITEM #8675__ITEM #8675', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8676, 'ITEM #8676__ITEM #8676', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8677, 'ITEM #8677__ITEM #8677', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8678, 'ITEM #8678__ITEM #8678', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8679, 'ITEM #8679__ITEM #8679', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8680, 'ITEM #8680__ITEM #8680', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8681, 'ITEM #8681__ITEM #8681', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8682, 'ITEM #8682__ITEM #8682', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8683, 'ITEM #8683__ITEM #8683', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8684, 'ITEM #8684__ITEM #8684', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8685, 'ITEM #8685__ITEM #8685', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8686, 'ITEM #8686__ITEM #8686', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8687, 'ITEM #8687__ITEM #8687', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8688, 'ITEM #8688__ITEM #8688', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8689, 'ITEM #8689__ITEM #8689', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8690, 'ITEM #8690__ITEM #8690', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8691, 'ITEM #8691__ITEM #8691', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8692, 'ITEM #8692__ITEM #8692', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8693, 'ITEM #8693__ITEM #8693', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8694, 'ITEM #8694__ITEM #8694', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8695, 'ITEM #8695__ITEM #8695', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8696, 'ITEM #8696__ITEM #8696', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8697, 'ITEM #8697__ITEM #8697', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8698, 'ITEM #8698__ITEM #8698', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8699, 'ITEM #8699__ITEM #8699', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8700, 'ITEM #8700__ITEM #8700', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8701, 'ITEM #8701__ITEM #8701', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8702, 'ITEM #8702__ITEM #8702', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8703, 'ITEM #8703__ITEM #8703', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8704, 'ITEM #8704__ITEM #8704', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8705, 'ITEM #8705__ITEM #8705', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8706, 'ITEM #8706__ITEM #8706', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8707, 'ITEM #8707__ITEM #8707', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8708, 'ITEM #8708__ITEM #8708', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8709, 'ITEM #8709__ITEM #8709', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8710, 'ITEM #8710__ITEM #8710', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8711, 'ITEM #8711__ITEM #8711', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8712, 'ITEM #8712__ITEM #8712', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8713, 'ITEM #8713__ITEM #8713', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8714, 'ITEM #8714__ITEM #8714', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8715, 'ITEM #8715__ITEM #8715', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8716, 'ITEM #8716__ITEM #8716', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8717, 'ITEM #8717__ITEM #8717', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8718, 'ITEM #8718__ITEM #8718', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8719, 'ITEM #8719__ITEM #8719', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8720, 'ITEM #8720__ITEM #8720', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8721, 'ITEM #8721__ITEM #8721', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8722, 'ITEM #8722__ITEM #8722', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8723, 'ITEM #8723__ITEM #8723', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8724, 'ITEM #8724__ITEM #8724', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8725, 'ITEM #8725__ITEM #8725', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8726, 'ITEM #8726__ITEM #8726', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8727, 'ITEM #8727__ITEM #8727', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8728, 'ITEM #8728__ITEM #8728', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8729, 'ITEM #8729__ITEM #8729', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8730, 'ITEM #8730__ITEM #8730', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8731, 'ITEM #8731__ITEM #8731', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8732, 'ITEM #8732__ITEM #8732', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8733, 'ITEM #8733__ITEM #8733', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8734, 'ITEM #8734__ITEM #8734', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8735, 'ITEM #8735__ITEM #8735', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8736, 'ITEM #8736__ITEM #8736', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8737, 'ITEM #8737__ITEM #8737', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8738, 'ITEM #8738__ITEM #8738', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8739, 'ITEM #8739__ITEM #8739', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8740, 'ITEM #8740__ITEM #8740', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8741, 'ITEM #8741__ITEM #8741', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8742, 'ITEM #8742__ITEM #8742', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8743, 'ITEM #8743__ITEM #8743', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8744, 'ITEM #8744__ITEM #8744', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8745, 'ITEM #8745__ITEM #8745', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8746, 'ITEM #8746__ITEM #8746', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8747, 'ITEM #8747__ITEM #8747', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8748, 'ITEM #8748__ITEM #8748', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8749, 'ITEM #8749__ITEM #8749', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8750, 'ITEM #8750__ITEM #8750', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8751, 'ITEM #8751__ITEM #8751', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8752, 'ITEM #8752__ITEM #8752', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8753, 'ITEM #8753__ITEM #8753', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8754, 'ITEM #8754__ITEM #8754', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8755, 'ITEM #8755__ITEM #8755', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8756, 'ITEM #8756__ITEM #8756', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8757, 'ITEM #8757__ITEM #8757', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8758, 'ITEM #8758__ITEM #8758', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8759, 'ITEM #8759__ITEM #8759', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8760, 'ITEM #8760__ITEM #8760', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8761, 'ITEM #8761__ITEM #8761', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8762, 'ITEM #8762__ITEM #8762', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8763, 'ITEM #8763__ITEM #8763', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8764, 'ITEM #8764__ITEM #8764', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8765, 'ITEM #8765__ITEM #8765', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8766, 'ITEM #8766__ITEM #8766', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8767, 'ITEM #8767__ITEM #8767', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8768, 'ITEM #8768__ITEM #8768', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8769, 'ITEM #8769__ITEM #8769', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8770, 'ITEM #8770__ITEM #8770', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8771, 'ITEM #8771__ITEM #8771', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8772, 'ITEM #8772__ITEM #8772', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8773, 'ITEM #8773__ITEM #8773', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8774, 'ITEM #8774__ITEM #8774', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8775, 'ITEM #8775__ITEM #8775', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8776, 'ITEM #8776__ITEM #8776', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8777, 'ITEM #8777__ITEM #8777', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8778, 'ITEM #8778__ITEM #8778', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8779, 'ITEM #8779__ITEM #8779', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8780, 'ITEM #8780__ITEM #8780', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8781, 'ITEM #8781__ITEM #8781', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8782, 'ITEM #8782__ITEM #8782', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8783, 'ITEM #8783__ITEM #8783', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8784, 'ITEM #8784__ITEM #8784', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8785, 'ITEM #8785__ITEM #8785', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8786, 'ITEM #8786__ITEM #8786', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8787, 'ITEM #8787__ITEM #8787', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8788, 'ITEM #8788__ITEM #8788', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8789, 'ITEM #8789__ITEM #8789', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8790, 'ITEM #8790__ITEM #8790', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8791, 'ITEM #8791__ITEM #8791', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8792, 'ITEM #8792__ITEM #8792', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8793, 'ITEM #8793__ITEM #8793', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8794, 'ITEM #8794__ITEM #8794', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8795, 'ITEM #8795__ITEM #8795', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8796, 'ITEM #8796__ITEM #8796', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8797, 'ITEM #8797__ITEM #8797', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8798, 'ITEM #8798__ITEM #8798', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8799, 'ITEM #8799__ITEM #8799', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8800, 'ITEM #8800__ITEM #8800', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8801, 'ITEM #8801__ITEM #8801', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8802, 'ITEM #8802__ITEM #8802', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8803, 'ITEM #8803__ITEM #8803', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8804, 'ITEM #8804__ITEM #8804', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8805, 'ITEM #8805__ITEM #8805', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8806, 'ITEM #8806__ITEM #8806', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8807, 'ITEM #8807__ITEM #8807', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8808, 'ITEM #8808__ITEM #8808', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8809, 'ITEM #8809__ITEM #8809', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8810, 'ITEM #8810__ITEM #8810', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8811, 'ITEM #8811__ITEM #8811', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8812, 'ITEM #8812__ITEM #8812', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8813, 'ITEM #8813__ITEM #8813', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8814, 'ITEM #8814__ITEM #8814', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8815, 'ITEM #8815__ITEM #8815', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8816, 'ITEM #8816__ITEM #8816', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8817, 'ITEM #8817__ITEM #8817', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8818, 'ITEM #8818__ITEM #8818', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8819, 'ITEM #8819__ITEM #8819', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8820, 'ITEM #8820__ITEM #8820', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8821, 'ITEM #8821__ITEM #8821', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8822, 'ITEM #8822__ITEM #8822', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8823, 'ITEM #8823__ITEM #8823', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8824, 'ITEM #8824__ITEM #8824', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8825, 'ITEM #8825__ITEM #8825', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8826, 'ITEM #8826__ITEM #8826', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8827, 'ITEM #8827__ITEM #8827', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8828, 'ITEM #8828__ITEM #8828', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8829, 'ITEM #8829__ITEM #8829', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8830, 'ITEM #8830__ITEM #8830', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8831, 'ITEM #8831__ITEM #8831', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8832, 'ITEM #8832__ITEM #8832', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8833, 'ITEM #8833__ITEM #8833', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8834, 'ITEM #8834__ITEM #8834', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8835, 'ITEM #8835__ITEM #8835', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8836, 'ITEM #8836__ITEM #8836', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8837, 'ITEM #8837__ITEM #8837', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8838, 'ITEM #8838__ITEM #8838', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8839, 'ITEM #8839__ITEM #8839', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8840, 'ITEM #8840__ITEM #8840', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8841, 'ITEM #8841__ITEM #8841', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8842, 'ITEM #8842__ITEM #8842', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8843, 'ITEM #8843__ITEM #8843', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8844, 'ITEM #8844__ITEM #8844', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8845, 'ITEM #8845__ITEM #8845', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8846, 'ITEM #8846__ITEM #8846', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8847, 'ITEM #8847__ITEM #8847', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8848, 'ITEM #8848__ITEM #8848', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8849, 'ITEM #8849__ITEM #8849', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8850, 'ITEM #8850__ITEM #8850', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8851, 'ITEM #8851__ITEM #8851', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8852, 'ITEM #8852__ITEM #8852', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8853, 'ITEM #8853__ITEM #8853', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8854, 'ITEM #8854__ITEM #8854', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8855, 'ITEM #8855__ITEM #8855', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8856, 'ITEM #8856__ITEM #8856', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8857, 'ITEM #8857__ITEM #8857', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8858, 'ITEM #8858__ITEM #8858', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8859, 'ITEM #8859__ITEM #8859', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8860, 'ITEM #8860__ITEM #8860', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8861, 'ITEM #8861__ITEM #8861', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8862, 'ITEM #8862__ITEM #8862', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8863, 'ITEM #8863__ITEM #8863', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8864, 'ITEM #8864__ITEM #8864', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8865, 'ITEM #8865__ITEM #8865', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8866, 'ITEM #8866__ITEM #8866', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8867, 'ITEM #8867__ITEM #8867', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8868, 'ITEM #8868__ITEM #8868', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8869, 'ITEM #8869__ITEM #8869', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8870, 'ITEM #8870__ITEM #8870', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8871, 'ITEM #8871__ITEM #8871', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8872, 'ITEM #8872__ITEM #8872', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8873, 'ITEM #8873__ITEM #8873', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8874, 'ITEM #8874__ITEM #8874', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8875, 'ITEM #8875__ITEM #8875', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8876, 'ITEM #8876__ITEM #8876', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8877, 'ITEM #8877__ITEM #8877', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8878, 'ITEM #8878__ITEM #8878', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8879, 'ITEM #8879__ITEM #8879', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8880, 'ITEM #8880__ITEM #8880', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8881, 'ITEM #8881__ITEM #8881', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8882, 'ITEM #8882__ITEM #8882', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8883, 'ITEM #8883__ITEM #8883', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8884, 'ITEM #8884__ITEM #8884', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8885, 'ITEM #8885__ITEM #8885', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8886, 'ITEM #8886__ITEM #8886', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8887, 'ITEM #8887__ITEM #8887', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8888, 'ITEM #8888__ITEM #8888', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8889, 'ITEM #8889__ITEM #8889', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8890, 'ITEM #8890__ITEM #8890', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8891, 'ITEM #8891__ITEM #8891', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8892, 'ITEM #8892__ITEM #8892', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8893, 'ITEM #8893__ITEM #8893', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8894, 'ITEM #8894__ITEM #8894', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8895, 'ITEM #8895__ITEM #8895', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8896, 'ITEM #8896__ITEM #8896', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8897, 'ITEM #8897__ITEM #8897', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8898, 'ITEM #8898__ITEM #8898', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8899, 'ITEM #8899__ITEM #8899', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8900, 'ITEM #8900__ITEM #8900', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8901, 'ITEM #8901__ITEM #8901', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8902, 'ITEM #8902__ITEM #8902', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8903, 'ITEM #8903__ITEM #8903', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8904, 'ITEM #8904__ITEM #8904', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8905, 'ITEM #8905__ITEM #8905', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8906, 'ITEM #8906__ITEM #8906', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8907, 'ITEM #8907__ITEM #8907', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8908, 'ITEM #8908__ITEM #8908', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8909, 'ITEM #8909__ITEM #8909', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8910, 'ITEM #8910__ITEM #8910', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8911, 'ITEM #8911__ITEM #8911', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8912, 'ITEM #8912__ITEM #8912', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8913, 'ITEM #8913__ITEM #8913', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8914, 'ITEM #8914__ITEM #8914', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8915, 'ITEM #8915__ITEM #8915', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8916, 'ITEM #8916__ITEM #8916', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8917, 'ITEM #8917__ITEM #8917', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8918, 'ITEM #8918__ITEM #8918', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8919, 'ITEM #8919__ITEM #8919', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8920, 'ITEM #8920__ITEM #8920', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8921, 'ITEM #8921__ITEM #8921', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8922, 'ITEM #8922__ITEM #8922', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8923, 'ITEM #8923__ITEM #8923', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8924, 'ITEM #8924__ITEM #8924', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8925, 'ITEM #8925__ITEM #8925', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8926, 'ITEM #8926__ITEM #8926', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8927, 'ITEM #8927__ITEM #8927', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8928, 'ITEM #8928__ITEM #8928', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8929, 'ITEM #8929__ITEM #8929', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8930, 'ITEM #8930__ITEM #8930', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8931, 'ITEM #8931__ITEM #8931', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8932, 'ITEM #8932__ITEM #8932', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8933, 'ITEM #8933__ITEM #8933', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8934, 'ITEM #8934__ITEM #8934', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8935, 'ITEM #8935__ITEM #8935', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8936, 'ITEM #8936__ITEM #8936', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8937, 'ITEM #8937__ITEM #8937', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8938, 'ITEM #8938__ITEM #8938', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8939, 'ITEM #8939__ITEM #8939', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8940, 'ITEM #8940__ITEM #8940', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8941, 'ITEM #8941__ITEM #8941', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8942, 'ITEM #8942__ITEM #8942', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8943, 'ITEM #8943__ITEM #8943', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8944, 'ITEM #8944__ITEM #8944', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8945, 'ITEM #8945__ITEM #8945', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8946, 'ITEM #8946__ITEM #8946', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8947, 'ITEM #8947__ITEM #8947', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8948, 'ITEM #8948__ITEM #8948', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8949, 'ITEM #8949__ITEM #8949', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8950, 'ITEM #8950__ITEM #8950', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8951, 'ITEM #8951__ITEM #8951', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8952, 'ITEM #8952__ITEM #8952', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8953, 'ITEM #8953__ITEM #8953', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8954, 'ITEM #8954__ITEM #8954', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8955, 'ITEM #8955__ITEM #8955', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8956, 'ITEM #8956__ITEM #8956', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8957, 'ITEM #8957__ITEM #8957', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8958, 'ITEM #8958__ITEM #8958', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8959, 'ITEM #8959__ITEM #8959', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8960, 'ITEM #8960__ITEM #8960', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8961, 'ITEM #8961__ITEM #8961', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8962, 'ITEM #8962__ITEM #8962', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8963, 'ITEM #8963__ITEM #8963', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8964, 'ITEM #8964__ITEM #8964', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8965, 'ITEM #8965__ITEM #8965', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8966, 'ITEM #8966__ITEM #8966', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8967, 'ITEM #8967__ITEM #8967', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8968, 'ITEM #8968__ITEM #8968', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8969, 'ITEM #8969__ITEM #8969', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8970, 'ITEM #8970__ITEM #8970', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8971, 'ITEM #8971__ITEM #8971', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8972, 'ITEM #8972__ITEM #8972', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8973, 'ITEM #8973__ITEM #8973', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8974, 'ITEM #8974__ITEM #8974', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8975, 'ITEM #8975__ITEM #8975', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8976, 'ITEM #8976__ITEM #8976', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8977, 'ITEM #8977__ITEM #8977', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8978, 'ITEM #8978__ITEM #8978', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8979, 'ITEM #8979__ITEM #8979', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8980, 'ITEM #8980__ITEM #8980', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8981, 'ITEM #8981__ITEM #8981', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8982, 'ITEM #8982__ITEM #8982', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8983, 'ITEM #8983__ITEM #8983', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8984, 'ITEM #8984__ITEM #8984', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8985, 'ITEM #8985__ITEM #8985', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8986, 'ITEM #8986__ITEM #8986', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8987, 'ITEM #8987__ITEM #8987', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8988, 'ITEM #8988__ITEM #8988', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8989, 'ITEM #8989__ITEM #8989', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8990, 'ITEM #8990__ITEM #8990', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8991, 'ITEM #8991__ITEM #8991', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8992, 'ITEM #8992__ITEM #8992', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8993, 'ITEM #8993__ITEM #8993', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8994, 'ITEM #8994__ITEM #8994', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8995, 'ITEM #8995__ITEM #8995', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8996, 'ITEM #8996__ITEM #8996', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8997, 'ITEM #8997__ITEM #8997', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8998, 'ITEM #8998__ITEM #8998', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (8999, 'ITEM #8999__ITEM #8999', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9000, 'ITEM #9000__ITEM #9000', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9001, 'ITEM #9001__ITEM #9001', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9002, 'ITEM #9002__ITEM #9002', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9003, 'ITEM #9003__ITEM #9003', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9004, 'ITEM #9004__ITEM #9004', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9005, 'ITEM #9005__ITEM #9005', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9006, 'ITEM #9006__ITEM #9006', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9007, 'ITEM #9007__ITEM #9007', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9008, 'ITEM #9008__ITEM #9008', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9009, 'ITEM #9009__ITEM #9009', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9010, 'ITEM #9010__ITEM #9010', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9011, 'ITEM #9011__ITEM #9011', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9012, 'ITEM #9012__ITEM #9012', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9013, 'ITEM #9013__ITEM #9013', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9014, 'ITEM #9014__ITEM #9014', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9015, 'ITEM #9015__ITEM #9015', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9016, 'ITEM #9016__ITEM #9016', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9017, 'ITEM #9017__ITEM #9017', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9018, 'ITEM #9018__ITEM #9018', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9019, 'ITEM #9019__ITEM #9019', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9020, 'ITEM #9020__ITEM #9020', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9021, 'ITEM #9021__ITEM #9021', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9022, 'ITEM #9022__ITEM #9022', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9023, 'ITEM #9023__ITEM #9023', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9024, 'ITEM #9024__ITEM #9024', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9025, 'ITEM #9025__ITEM #9025', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9026, 'ITEM #9026__ITEM #9026', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9027, 'ITEM #9027__ITEM #9027', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9028, 'ITEM #9028__ITEM #9028', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9029, 'ITEM #9029__ITEM #9029', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9030, 'ITEM #9030__ITEM #9030', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9031, 'ITEM #9031__ITEM #9031', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9032, 'ITEM #9032__ITEM #9032', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9033, 'ITEM #9033__ITEM #9033', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9034, 'ITEM #9034__ITEM #9034', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9035, 'ITEM #9035__ITEM #9035', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9036, 'ITEM #9036__ITEM #9036', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9037, 'ITEM #9037__ITEM #9037', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9038, 'ITEM #9038__ITEM #9038', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9039, 'ITEM #9039__ITEM #9039', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9040, 'ITEM #9040__ITEM #9040', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9041, 'ITEM #9041__ITEM #9041', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9042, 'ITEM #9042__ITEM #9042', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9043, 'ITEM #9043__ITEM #9043', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9044, 'ITEM #9044__ITEM #9044', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9045, 'ITEM #9045__ITEM #9045', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9046, 'ITEM #9046__ITEM #9046', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9047, 'ITEM #9047__ITEM #9047', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9048, 'ITEM #9048__ITEM #9048', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9049, 'ITEM #9049__ITEM #9049', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9050, 'ITEM #9050__ITEM #9050', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9051, 'ITEM #9051__ITEM #9051', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9052, 'ITEM #9052__ITEM #9052', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9053, 'ITEM #9053__ITEM #9053', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9054, 'ITEM #9054__ITEM #9054', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9055, 'ITEM #9055__ITEM #9055', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9056, 'ITEM #9056__ITEM #9056', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9057, 'ITEM #9057__ITEM #9057', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9058, 'ITEM #9058__ITEM #9058', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9059, 'ITEM #9059__ITEM #9059', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9060, 'ITEM #9060__ITEM #9060', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9061, 'ITEM #9061__ITEM #9061', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9062, 'ITEM #9062__ITEM #9062', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9063, 'ITEM #9063__ITEM #9063', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9064, 'ITEM #9064__ITEM #9064', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9065, 'ITEM #9065__ITEM #9065', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9066, 'ITEM #9066__ITEM #9066', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9067, 'ITEM #9067__ITEM #9067', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9068, 'ITEM #9068__ITEM #9068', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9069, 'ITEM #9069__ITEM #9069', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9070, 'ITEM #9070__ITEM #9070', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9071, 'ITEM #9071__ITEM #9071', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9072, 'ITEM #9072__ITEM #9072', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9073, 'ITEM #9073__ITEM #9073', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9074, 'ITEM #9074__ITEM #9074', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9075, 'ITEM #9075__ITEM #9075', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9076, 'ITEM #9076__ITEM #9076', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9077, 'ITEM #9077__ITEM #9077', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9078, 'ITEM #9078__ITEM #9078', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9079, 'ITEM #9079__ITEM #9079', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9080, 'ITEM #9080__ITEM #9080', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9081, 'ITEM #9081__ITEM #9081', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9082, 'ITEM #9082__ITEM #9082', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9083, 'ITEM #9083__ITEM #9083', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9084, 'ITEM #9084__ITEM #9084', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9085, 'ITEM #9085__ITEM #9085', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9086, 'ITEM #9086__ITEM #9086', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9087, 'ITEM #9087__ITEM #9087', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9088, 'ITEM #9088__ITEM #9088', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9089, 'ITEM #9089__ITEM #9089', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9090, 'ITEM #9090__ITEM #9090', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9091, 'ITEM #9091__ITEM #9091', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9092, 'ITEM #9092__ITEM #9092', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9093, 'ITEM #9093__ITEM #9093', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9094, 'ITEM #9094__ITEM #9094', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9095, 'ITEM #9095__ITEM #9095', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9096, 'ITEM #9096__ITEM #9096', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9097, 'ITEM #9097__ITEM #9097', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9098, 'ITEM #9098__ITEM #9098', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9099, 'ITEM #9099__ITEM #9099', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9100, 'ITEM #9100__ITEM #9100', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9101, 'ITEM #9101__ITEM #9101', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9102, 'ITEM #9102__ITEM #9102', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9103, 'ITEM #9103__ITEM #9103', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9104, 'ITEM #9104__ITEM #9104', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9105, 'ITEM #9105__ITEM #9105', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9106, 'ITEM #9106__ITEM #9106', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9107, 'ITEM #9107__ITEM #9107', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9108, 'ITEM #9108__ITEM #9108', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9109, 'ITEM #9109__ITEM #9109', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9110, 'ITEM #9110__ITEM #9110', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9111, 'ITEM #9111__ITEM #9111', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9112, 'ITEM #9112__ITEM #9112', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9113, 'ITEM #9113__ITEM #9113', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9114, 'ITEM #9114__ITEM #9114', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9115, 'ITEM #9115__ITEM #9115', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9116, 'ITEM #9116__ITEM #9116', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9117, 'ITEM #9117__ITEM #9117', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9118, 'ITEM #9118__ITEM #9118', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9119, 'ITEM #9119__ITEM #9119', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9120, 'ITEM #9120__ITEM #9120', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9121, 'ITEM #9121__ITEM #9121', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9122, 'ITEM #9122__ITEM #9122', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9123, 'ITEM #9123__ITEM #9123', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9124, 'ITEM #9124__ITEM #9124', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9125, 'ITEM #9125__ITEM #9125', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9126, 'ITEM #9126__ITEM #9126', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9127, 'ITEM #9127__ITEM #9127', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9128, 'ITEM #9128__ITEM #9128', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9129, 'ITEM #9129__ITEM #9129', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9130, 'ITEM #9130__ITEM #9130', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9131, 'ITEM #9131__ITEM #9131', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9132, 'ITEM #9132__ITEM #9132', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9133, 'ITEM #9133__ITEM #9133', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9134, 'ITEM #9134__ITEM #9134', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9135, 'ITEM #9135__ITEM #9135', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9136, 'ITEM #9136__ITEM #9136', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9137, 'ITEM #9137__ITEM #9137', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9138, 'ITEM #9138__ITEM #9138', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9139, 'ITEM #9139__ITEM #9139', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9140, 'ITEM #9140__ITEM #9140', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9141, 'ITEM #9141__ITEM #9141', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9142, 'ITEM #9142__ITEM #9142', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9143, 'ITEM #9143__ITEM #9143', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9144, 'ITEM #9144__ITEM #9144', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9145, 'ITEM #9145__ITEM #9145', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9146, 'ITEM #9146__ITEM #9146', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9147, 'ITEM #9147__ITEM #9147', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9148, 'ITEM #9148__ITEM #9148', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9149, 'ITEM #9149__ITEM #9149', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9150, 'ITEM #9150__ITEM #9150', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9151, 'ITEM #9151__ITEM #9151', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9152, 'ITEM #9152__ITEM #9152', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9153, 'ITEM #9153__ITEM #9153', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9154, 'ITEM #9154__ITEM #9154', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9155, 'ITEM #9155__ITEM #9155', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9156, 'ITEM #9156__ITEM #9156', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9157, 'ITEM #9157__ITEM #9157', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9158, 'ITEM #9158__ITEM #9158', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9159, 'ITEM #9159__ITEM #9159', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9160, 'ITEM #9160__ITEM #9160', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9161, 'ITEM #9161__ITEM #9161', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9162, 'ITEM #9162__ITEM #9162', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9163, 'ITEM #9163__ITEM #9163', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9164, 'ITEM #9164__ITEM #9164', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9165, 'ITEM #9165__ITEM #9165', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9166, 'ITEM #9166__ITEM #9166', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9167, 'ITEM #9167__ITEM #9167', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9168, 'ITEM #9168__ITEM #9168', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9169, 'ITEM #9169__ITEM #9169', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9170, 'ITEM #9170__ITEM #9170', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9171, 'ITEM #9171__ITEM #9171', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9172, 'ITEM #9172__ITEM #9172', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9173, 'ITEM #9173__ITEM #9173', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9174, 'ITEM #9174__ITEM #9174', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9175, 'ITEM #9175__ITEM #9175', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9176, 'ITEM #9176__ITEM #9176', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9177, 'ITEM #9177__ITEM #9177', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9178, 'ITEM #9178__ITEM #9178', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9179, 'ITEM #9179__ITEM #9179', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9180, 'ITEM #9180__ITEM #9180', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9181, 'ITEM #9181__ITEM #9181', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9182, 'ITEM #9182__ITEM #9182', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9183, 'ITEM #9183__ITEM #9183', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9184, 'ITEM #9184__ITEM #9184', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9185, 'ITEM #9185__ITEM #9185', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9186, 'ITEM #9186__ITEM #9186', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9187, 'ITEM #9187__ITEM #9187', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9188, 'ITEM #9188__ITEM #9188', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9189, 'ITEM #9189__ITEM #9189', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9190, 'ITEM #9190__ITEM #9190', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9191, 'ITEM #9191__ITEM #9191', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9192, 'ITEM #9192__ITEM #9192', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9193, 'ITEM #9193__ITEM #9193', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9194, 'ITEM #9194__ITEM #9194', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9195, 'ITEM #9195__ITEM #9195', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9196, 'ITEM #9196__ITEM #9196', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9197, 'ITEM #9197__ITEM #9197', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9198, 'ITEM #9198__ITEM #9198', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9199, 'ITEM #9199__ITEM #9199', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9200, 'ITEM #9200__ITEM #9200', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9201, 'ITEM #9201__ITEM #9201', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9202, 'ITEM #9202__ITEM #9202', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9203, 'ITEM #9203__ITEM #9203', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9204, 'ITEM #9204__ITEM #9204', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9205, 'ITEM #9205__ITEM #9205', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9206, 'ITEM #9206__ITEM #9206', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9207, 'ITEM #9207__ITEM #9207', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9208, 'ITEM #9208__ITEM #9208', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9209, 'ITEM #9209__ITEM #9209', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9210, 'ITEM #9210__ITEM #9210', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9211, 'ITEM #9211__ITEM #9211', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9212, 'ITEM #9212__ITEM #9212', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9213, 'ITEM #9213__ITEM #9213', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9214, 'ITEM #9214__ITEM #9214', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9215, 'ITEM #9215__ITEM #9215', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9216, 'ITEM #9216__ITEM #9216', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9217, 'ITEM #9217__ITEM #9217', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9218, 'ITEM #9218__ITEM #9218', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9219, 'ITEM #9219__ITEM #9219', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9220, 'ITEM #9220__ITEM #9220', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9221, 'ITEM #9221__ITEM #9221', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9222, 'ITEM #9222__ITEM #9222', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9223, 'ITEM #9223__ITEM #9223', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9224, 'ITEM #9224__ITEM #9224', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9225, 'ITEM #9225__ITEM #9225', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9226, 'ITEM #9226__ITEM #9226', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9227, 'ITEM #9227__ITEM #9227', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9228, 'ITEM #9228__ITEM #9228', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9229, 'ITEM #9229__ITEM #9229', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9230, 'ITEM #9230__ITEM #9230', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9231, 'ITEM #9231__ITEM #9231', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9232, 'ITEM #9232__ITEM #9232', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9233, 'ITEM #9233__ITEM #9233', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9234, 'ITEM #9234__ITEM #9234', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9235, 'ITEM #9235__ITEM #9235', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9236, 'ITEM #9236__ITEM #9236', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9237, 'ITEM #9237__ITEM #9237', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9238, 'ITEM #9238__ITEM #9238', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9239, 'ITEM #9239__ITEM #9239', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9240, 'ITEM #9240__ITEM #9240', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9241, 'ITEM #9241__ITEM #9241', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9242, 'ITEM #9242__ITEM #9242', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9243, 'ITEM #9243__ITEM #9243', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9244, 'ITEM #9244__ITEM #9244', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9245, 'ITEM #9245__ITEM #9245', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9246, 'ITEM #9246__ITEM #9246', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9247, 'ITEM #9247__ITEM #9247', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9248, 'ITEM #9248__ITEM #9248', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9249, 'ITEM #9249__ITEM #9249', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9250, 'ITEM #9250__ITEM #9250', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9251, 'ITEM #9251__ITEM #9251', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9252, 'ITEM #9252__ITEM #9252', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9253, 'ITEM #9253__ITEM #9253', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9254, 'ITEM #9254__ITEM #9254', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9255, 'ITEM #9255__ITEM #9255', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9256, 'ITEM #9256__ITEM #9256', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9257, 'ITEM #9257__ITEM #9257', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9258, 'ITEM #9258__ITEM #9258', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9259, 'ITEM #9259__ITEM #9259', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9260, 'ITEM #9260__ITEM #9260', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9261, 'ITEM #9261__ITEM #9261', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9262, 'ITEM #9262__ITEM #9262', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9263, 'ITEM #9263__ITEM #9263', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9264, 'ITEM #9264__ITEM #9264', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9265, 'ITEM #9265__ITEM #9265', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9266, 'ITEM #9266__ITEM #9266', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9267, 'ITEM #9267__ITEM #9267', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9268, 'ITEM #9268__ITEM #9268', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9269, 'ITEM #9269__ITEM #9269', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9270, 'ITEM #9270__ITEM #9270', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9271, 'ITEM #9271__ITEM #9271', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9272, 'ITEM #9272__ITEM #9272', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9273, 'ITEM #9273__ITEM #9273', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9274, 'ITEM #9274__ITEM #9274', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9275, 'ITEM #9275__ITEM #9275', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9276, 'ITEM #9276__ITEM #9276', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9277, 'ITEM #9277__ITEM #9277', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9278, 'ITEM #9278__ITEM #9278', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9279, 'ITEM #9279__ITEM #9279', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9280, 'ITEM #9280__ITEM #9280', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9281, 'ITEM #9281__ITEM #9281', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9282, 'ITEM #9282__ITEM #9282', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9283, 'ITEM #9283__ITEM #9283', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9284, 'ITEM #9284__ITEM #9284', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9285, 'ITEM #9285__ITEM #9285', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9286, 'ITEM #9286__ITEM #9286', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9287, 'ITEM #9287__ITEM #9287', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9288, 'ITEM #9288__ITEM #9288', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9289, 'ITEM #9289__ITEM #9289', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9290, 'ITEM #9290__ITEM #9290', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9291, 'ITEM #9291__ITEM #9291', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9292, 'ITEM #9292__ITEM #9292', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9293, 'ITEM #9293__ITEM #9293', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9294, 'ITEM #9294__ITEM #9294', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9295, 'ITEM #9295__ITEM #9295', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9296, 'ITEM #9296__ITEM #9296', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9297, 'ITEM #9297__ITEM #9297', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9298, 'ITEM #9298__ITEM #9298', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9299, 'ITEM #9299__ITEM #9299', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9300, 'ITEM #9300__ITEM #9300', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9301, 'ITEM #9301__ITEM #9301', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9302, 'ITEM #9302__ITEM #9302', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9303, 'ITEM #9303__ITEM #9303', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9304, 'ITEM #9304__ITEM #9304', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9305, 'ITEM #9305__ITEM #9305', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9306, 'ITEM #9306__ITEM #9306', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9307, 'ITEM #9307__ITEM #9307', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9308, 'ITEM #9308__ITEM #9308', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9309, 'ITEM #9309__ITEM #9309', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9310, 'ITEM #9310__ITEM #9310', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9311, 'ITEM #9311__ITEM #9311', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9312, 'ITEM #9312__ITEM #9312', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9313, 'ITEM #9313__ITEM #9313', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9314, 'ITEM #9314__ITEM #9314', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9315, 'ITEM #9315__ITEM #9315', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9316, 'ITEM #9316__ITEM #9316', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9317, 'ITEM #9317__ITEM #9317', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9318, 'ITEM #9318__ITEM #9318', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9319, 'ITEM #9319__ITEM #9319', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9320, 'ITEM #9320__ITEM #9320', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9321, 'ITEM #9321__ITEM #9321', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9322, 'ITEM #9322__ITEM #9322', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9323, 'ITEM #9323__ITEM #9323', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9324, 'ITEM #9324__ITEM #9324', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9325, 'ITEM #9325__ITEM #9325', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9326, 'ITEM #9326__ITEM #9326', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9327, 'ITEM #9327__ITEM #9327', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9328, 'ITEM #9328__ITEM #9328', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9329, 'ITEM #9329__ITEM #9329', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9330, 'ITEM #9330__ITEM #9330', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9331, 'ITEM #9331__ITEM #9331', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9332, 'ITEM #9332__ITEM #9332', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9333, 'ITEM #9333__ITEM #9333', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9334, 'ITEM #9334__ITEM #9334', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9335, 'ITEM #9335__ITEM #9335', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9336, 'ITEM #9336__ITEM #9336', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9337, 'ITEM #9337__ITEM #9337', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9338, 'ITEM #9338__ITEM #9338', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9339, 'ITEM #9339__ITEM #9339', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9340, 'ITEM #9340__ITEM #9340', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9341, 'ITEM #9341__ITEM #9341', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9342, 'ITEM #9342__ITEM #9342', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9343, 'ITEM #9343__ITEM #9343', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9344, 'ITEM #9344__ITEM #9344', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9345, 'ITEM #9345__ITEM #9345', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9346, 'ITEM #9346__ITEM #9346', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9347, 'ITEM #9347__ITEM #9347', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9348, 'ITEM #9348__ITEM #9348', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9349, 'ITEM #9349__ITEM #9349', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9350, 'ITEM #9350__ITEM #9350', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9351, 'ITEM #9351__ITEM #9351', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9352, 'ITEM #9352__ITEM #9352', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9353, 'ITEM #9353__ITEM #9353', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9354, 'ITEM #9354__ITEM #9354', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9355, 'ITEM #9355__ITEM #9355', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9356, 'ITEM #9356__ITEM #9356', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9357, 'ITEM #9357__ITEM #9357', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9358, 'ITEM #9358__ITEM #9358', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9359, 'ITEM #9359__ITEM #9359', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9360, 'ITEM #9360__ITEM #9360', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9361, 'ITEM #9361__ITEM #9361', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9362, 'ITEM #9362__ITEM #9362', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9363, 'ITEM #9363__ITEM #9363', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9364, 'ITEM #9364__ITEM #9364', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9365, 'ITEM #9365__ITEM #9365', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9366, 'ITEM #9366__ITEM #9366', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9367, 'ITEM #9367__ITEM #9367', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9368, 'ITEM #9368__ITEM #9368', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9369, 'ITEM #9369__ITEM #9369', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9370, 'ITEM #9370__ITEM #9370', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9371, 'ITEM #9371__ITEM #9371', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9372, 'ITEM #9372__ITEM #9372', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9373, 'ITEM #9373__ITEM #9373', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9374, 'ITEM #9374__ITEM #9374', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9375, 'ITEM #9375__ITEM #9375', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9376, 'ITEM #9376__ITEM #9376', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9377, 'ITEM #9377__ITEM #9377', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9378, 'ITEM #9378__ITEM #9378', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9379, 'ITEM #9379__ITEM #9379', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9380, 'ITEM #9380__ITEM #9380', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9381, 'ITEM #9381__ITEM #9381', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9382, 'ITEM #9382__ITEM #9382', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9383, 'ITEM #9383__ITEM #9383', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9384, 'ITEM #9384__ITEM #9384', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9385, 'ITEM #9385__ITEM #9385', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9386, 'ITEM #9386__ITEM #9386', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9387, 'ITEM #9387__ITEM #9387', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9388, 'ITEM #9388__ITEM #9388', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9389, 'ITEM #9389__ITEM #9389', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9390, 'ITEM #9390__ITEM #9390', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9391, 'ITEM #9391__ITEM #9391', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9392, 'ITEM #9392__ITEM #9392', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9393, 'ITEM #9393__ITEM #9393', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9394, 'ITEM #9394__ITEM #9394', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9395, 'ITEM #9395__ITEM #9395', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9396, 'ITEM #9396__ITEM #9396', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9397, 'ITEM #9397__ITEM #9397', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9398, 'ITEM #9398__ITEM #9398', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9399, 'ITEM #9399__ITEM #9399', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9400, 'ITEM #9400__ITEM #9400', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9401, 'ITEM #9401__ITEM #9401', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9402, 'ITEM #9402__ITEM #9402', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9403, 'ITEM #9403__ITEM #9403', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9404, 'ITEM #9404__ITEM #9404', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9405, 'ITEM #9405__ITEM #9405', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9406, 'ITEM #9406__ITEM #9406', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9407, 'ITEM #9407__ITEM #9407', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9408, 'ITEM #9408__ITEM #9408', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9409, 'ITEM #9409__ITEM #9409', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9410, 'ITEM #9410__ITEM #9410', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9411, 'ITEM #9411__ITEM #9411', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9412, 'ITEM #9412__ITEM #9412', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9413, 'ITEM #9413__ITEM #9413', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9414, 'ITEM #9414__ITEM #9414', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9415, 'ITEM #9415__ITEM #9415', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9416, 'ITEM #9416__ITEM #9416', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9417, 'ITEM #9417__ITEM #9417', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9418, 'ITEM #9418__ITEM #9418', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9419, 'ITEM #9419__ITEM #9419', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9420, 'ITEM #9420__ITEM #9420', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9421, 'ITEM #9421__ITEM #9421', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9422, 'ITEM #9422__ITEM #9422', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9423, 'ITEM #9423__ITEM #9423', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9424, 'ITEM #9424__ITEM #9424', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9425, 'ITEM #9425__ITEM #9425', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9426, 'ITEM #9426__ITEM #9426', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9427, 'ITEM #9427__ITEM #9427', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9428, 'ITEM #9428__ITEM #9428', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9429, 'ITEM #9429__ITEM #9429', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9430, 'ITEM #9430__ITEM #9430', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9431, 'ITEM #9431__ITEM #9431', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9432, 'ITEM #9432__ITEM #9432', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9433, 'ITEM #9433__ITEM #9433', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9434, 'ITEM #9434__ITEM #9434', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9435, 'ITEM #9435__ITEM #9435', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9436, 'ITEM #9436__ITEM #9436', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9437, 'ITEM #9437__ITEM #9437', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9438, 'ITEM #9438__ITEM #9438', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9439, 'ITEM #9439__ITEM #9439', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9440, 'ITEM #9440__ITEM #9440', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9441, 'ITEM #9441__ITEM #9441', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9442, 'ITEM #9442__ITEM #9442', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9443, 'ITEM #9443__ITEM #9443', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9444, 'ITEM #9444__ITEM #9444', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9445, 'ITEM #9445__ITEM #9445', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9446, 'ITEM #9446__ITEM #9446', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9447, 'ITEM #9447__ITEM #9447', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9448, 'ITEM #9448__ITEM #9448', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9449, 'ITEM #9449__ITEM #9449', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9450, 'ITEM #9450__ITEM #9450', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9451, 'ITEM #9451__ITEM #9451', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9452, 'ITEM #9452__ITEM #9452', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9453, 'ITEM #9453__ITEM #9453', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9454, 'ITEM #9454__ITEM #9454', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9455, 'ITEM #9455__ITEM #9455', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9456, 'ITEM #9456__ITEM #9456', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9457, 'ITEM #9457__ITEM #9457', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9458, 'ITEM #9458__ITEM #9458', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9459, 'ITEM #9459__ITEM #9459', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9460, 'ITEM #9460__ITEM #9460', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9461, 'ITEM #9461__ITEM #9461', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9462, 'ITEM #9462__ITEM #9462', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9463, 'ITEM #9463__ITEM #9463', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9464, 'ITEM #9464__ITEM #9464', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9465, 'ITEM #9465__ITEM #9465', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9466, 'ITEM #9466__ITEM #9466', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9467, 'ITEM #9467__ITEM #9467', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9468, 'ITEM #9468__ITEM #9468', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9469, 'ITEM #9469__ITEM #9469', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9470, 'ITEM #9470__ITEM #9470', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9471, 'ITEM #9471__ITEM #9471', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9472, 'ITEM #9472__ITEM #9472', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9473, 'ITEM #9473__ITEM #9473', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9474, 'ITEM #9474__ITEM #9474', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9475, 'ITEM #9475__ITEM #9475', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9476, 'ITEM #9476__ITEM #9476', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9477, 'ITEM #9477__ITEM #9477', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9478, 'ITEM #9478__ITEM #9478', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9479, 'ITEM #9479__ITEM #9479', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9480, 'ITEM #9480__ITEM #9480', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9481, 'ITEM #9481__ITEM #9481', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9482, 'ITEM #9482__ITEM #9482', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9483, 'ITEM #9483__ITEM #9483', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9484, 'ITEM #9484__ITEM #9484', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9485, 'ITEM #9485__ITEM #9485', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9486, 'ITEM #9486__ITEM #9486', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9487, 'ITEM #9487__ITEM #9487', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9488, 'ITEM #9488__ITEM #9488', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9489, 'ITEM #9489__ITEM #9489', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9490, 'ITEM #9490__ITEM #9490', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9491, 'ITEM #9491__ITEM #9491', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9492, 'ITEM #9492__ITEM #9492', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9493, 'ITEM #9493__ITEM #9493', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9494, 'ITEM #9494__ITEM #9494', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9495, 'ITEM #9495__ITEM #9495', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9496, 'ITEM #9496__ITEM #9496', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9497, 'ITEM #9497__ITEM #9497', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9498, 'ITEM #9498__ITEM #9498', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9499, 'ITEM #9499__ITEM #9499', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9500, 'ITEM #9500__ITEM #9500', NULL);

COMMIT WORK;

INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9501, 'ITEM #9501__ITEM #9501', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9502, 'ITEM #9502__ITEM #9502', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9503, 'ITEM #9503__ITEM #9503', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9504, 'ITEM #9504__ITEM #9504', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9505, 'ITEM #9505__ITEM #9505', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9506, 'ITEM #9506__ITEM #9506', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9507, 'ITEM #9507__ITEM #9507', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9508, 'ITEM #9508__ITEM #9508', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9509, 'ITEM #9509__ITEM #9509', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9510, 'ITEM #9510__ITEM #9510', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9511, 'ITEM #9511__ITEM #9511', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9512, 'ITEM #9512__ITEM #9512', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9513, 'ITEM #9513__ITEM #9513', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9514, 'ITEM #9514__ITEM #9514', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9515, 'ITEM #9515__ITEM #9515', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9516, 'ITEM #9516__ITEM #9516', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9517, 'ITEM #9517__ITEM #9517', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9518, 'ITEM #9518__ITEM #9518', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9519, 'ITEM #9519__ITEM #9519', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9520, 'ITEM #9520__ITEM #9520', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9521, 'ITEM #9521__ITEM #9521', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9522, 'ITEM #9522__ITEM #9522', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9523, 'ITEM #9523__ITEM #9523', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9524, 'ITEM #9524__ITEM #9524', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9525, 'ITEM #9525__ITEM #9525', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9526, 'ITEM #9526__ITEM #9526', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9527, 'ITEM #9527__ITEM #9527', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9528, 'ITEM #9528__ITEM #9528', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9529, 'ITEM #9529__ITEM #9529', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9530, 'ITEM #9530__ITEM #9530', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9531, 'ITEM #9531__ITEM #9531', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9532, 'ITEM #9532__ITEM #9532', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9533, 'ITEM #9533__ITEM #9533', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9534, 'ITEM #9534__ITEM #9534', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9535, 'ITEM #9535__ITEM #9535', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9536, 'ITEM #9536__ITEM #9536', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9537, 'ITEM #9537__ITEM #9537', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9538, 'ITEM #9538__ITEM #9538', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9539, 'ITEM #9539__ITEM #9539', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9540, 'ITEM #9540__ITEM #9540', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9541, 'ITEM #9541__ITEM #9541', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9542, 'ITEM #9542__ITEM #9542', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9543, 'ITEM #9543__ITEM #9543', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9544, 'ITEM #9544__ITEM #9544', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9545, 'ITEM #9545__ITEM #9545', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9546, 'ITEM #9546__ITEM #9546', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9547, 'ITEM #9547__ITEM #9547', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9548, 'ITEM #9548__ITEM #9548', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9549, 'ITEM #9549__ITEM #9549', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9550, 'ITEM #9550__ITEM #9550', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9551, 'ITEM #9551__ITEM #9551', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9552, 'ITEM #9552__ITEM #9552', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9553, 'ITEM #9553__ITEM #9553', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9554, 'ITEM #9554__ITEM #9554', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9555, 'ITEM #9555__ITEM #9555', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9556, 'ITEM #9556__ITEM #9556', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9557, 'ITEM #9557__ITEM #9557', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9558, 'ITEM #9558__ITEM #9558', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9559, 'ITEM #9559__ITEM #9559', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9560, 'ITEM #9560__ITEM #9560', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9561, 'ITEM #9561__ITEM #9561', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9562, 'ITEM #9562__ITEM #9562', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9563, 'ITEM #9563__ITEM #9563', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9564, 'ITEM #9564__ITEM #9564', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9565, 'ITEM #9565__ITEM #9565', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9566, 'ITEM #9566__ITEM #9566', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9567, 'ITEM #9567__ITEM #9567', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9568, 'ITEM #9568__ITEM #9568', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9569, 'ITEM #9569__ITEM #9569', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9570, 'ITEM #9570__ITEM #9570', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9571, 'ITEM #9571__ITEM #9571', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9572, 'ITEM #9572__ITEM #9572', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9573, 'ITEM #9573__ITEM #9573', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9574, 'ITEM #9574__ITEM #9574', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9575, 'ITEM #9575__ITEM #9575', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9576, 'ITEM #9576__ITEM #9576', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9577, 'ITEM #9577__ITEM #9577', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9578, 'ITEM #9578__ITEM #9578', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9579, 'ITEM #9579__ITEM #9579', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9580, 'ITEM #9580__ITEM #9580', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9581, 'ITEM #9581__ITEM #9581', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9582, 'ITEM #9582__ITEM #9582', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9583, 'ITEM #9583__ITEM #9583', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9584, 'ITEM #9584__ITEM #9584', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9585, 'ITEM #9585__ITEM #9585', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9586, 'ITEM #9586__ITEM #9586', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9587, 'ITEM #9587__ITEM #9587', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9588, 'ITEM #9588__ITEM #9588', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9589, 'ITEM #9589__ITEM #9589', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9590, 'ITEM #9590__ITEM #9590', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9591, 'ITEM #9591__ITEM #9591', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9592, 'ITEM #9592__ITEM #9592', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9593, 'ITEM #9593__ITEM #9593', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9594, 'ITEM #9594__ITEM #9594', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9595, 'ITEM #9595__ITEM #9595', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9596, 'ITEM #9596__ITEM #9596', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9597, 'ITEM #9597__ITEM #9597', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9598, 'ITEM #9598__ITEM #9598', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9599, 'ITEM #9599__ITEM #9599', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9600, 'ITEM #9600__ITEM #9600', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9601, 'ITEM #9601__ITEM #9601', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9602, 'ITEM #9602__ITEM #9602', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9603, 'ITEM #9603__ITEM #9603', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9604, 'ITEM #9604__ITEM #9604', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9605, 'ITEM #9605__ITEM #9605', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9606, 'ITEM #9606__ITEM #9606', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9607, 'ITEM #9607__ITEM #9607', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9608, 'ITEM #9608__ITEM #9608', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9609, 'ITEM #9609__ITEM #9609', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9610, 'ITEM #9610__ITEM #9610', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9611, 'ITEM #9611__ITEM #9611', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9612, 'ITEM #9612__ITEM #9612', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9613, 'ITEM #9613__ITEM #9613', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9614, 'ITEM #9614__ITEM #9614', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9615, 'ITEM #9615__ITEM #9615', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9616, 'ITEM #9616__ITEM #9616', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9617, 'ITEM #9617__ITEM #9617', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9618, 'ITEM #9618__ITEM #9618', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9619, 'ITEM #9619__ITEM #9619', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9620, 'ITEM #9620__ITEM #9620', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9621, 'ITEM #9621__ITEM #9621', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9622, 'ITEM #9622__ITEM #9622', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9623, 'ITEM #9623__ITEM #9623', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9624, 'ITEM #9624__ITEM #9624', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9625, 'ITEM #9625__ITEM #9625', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9626, 'ITEM #9626__ITEM #9626', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9627, 'ITEM #9627__ITEM #9627', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9628, 'ITEM #9628__ITEM #9628', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9629, 'ITEM #9629__ITEM #9629', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9630, 'ITEM #9630__ITEM #9630', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9631, 'ITEM #9631__ITEM #9631', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9632, 'ITEM #9632__ITEM #9632', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9633, 'ITEM #9633__ITEM #9633', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9634, 'ITEM #9634__ITEM #9634', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9635, 'ITEM #9635__ITEM #9635', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9636, 'ITEM #9636__ITEM #9636', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9637, 'ITEM #9637__ITEM #9637', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9638, 'ITEM #9638__ITEM #9638', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9639, 'ITEM #9639__ITEM #9639', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9640, 'ITEM #9640__ITEM #9640', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9641, 'ITEM #9641__ITEM #9641', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9642, 'ITEM #9642__ITEM #9642', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9643, 'ITEM #9643__ITEM #9643', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9644, 'ITEM #9644__ITEM #9644', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9645, 'ITEM #9645__ITEM #9645', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9646, 'ITEM #9646__ITEM #9646', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9647, 'ITEM #9647__ITEM #9647', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9648, 'ITEM #9648__ITEM #9648', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9649, 'ITEM #9649__ITEM #9649', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9650, 'ITEM #9650__ITEM #9650', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9651, 'ITEM #9651__ITEM #9651', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9652, 'ITEM #9652__ITEM #9652', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9653, 'ITEM #9653__ITEM #9653', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9654, 'ITEM #9654__ITEM #9654', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9655, 'ITEM #9655__ITEM #9655', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9656, 'ITEM #9656__ITEM #9656', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9657, 'ITEM #9657__ITEM #9657', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9658, 'ITEM #9658__ITEM #9658', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9659, 'ITEM #9659__ITEM #9659', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9660, 'ITEM #9660__ITEM #9660', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9661, 'ITEM #9661__ITEM #9661', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9662, 'ITEM #9662__ITEM #9662', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9663, 'ITEM #9663__ITEM #9663', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9664, 'ITEM #9664__ITEM #9664', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9665, 'ITEM #9665__ITEM #9665', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9666, 'ITEM #9666__ITEM #9666', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9667, 'ITEM #9667__ITEM #9667', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9668, 'ITEM #9668__ITEM #9668', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9669, 'ITEM #9669__ITEM #9669', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9670, 'ITEM #9670__ITEM #9670', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9671, 'ITEM #9671__ITEM #9671', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9672, 'ITEM #9672__ITEM #9672', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9673, 'ITEM #9673__ITEM #9673', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9674, 'ITEM #9674__ITEM #9674', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9675, 'ITEM #9675__ITEM #9675', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9676, 'ITEM #9676__ITEM #9676', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9677, 'ITEM #9677__ITEM #9677', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9678, 'ITEM #9678__ITEM #9678', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9679, 'ITEM #9679__ITEM #9679', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9680, 'ITEM #9680__ITEM #9680', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9681, 'ITEM #9681__ITEM #9681', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9682, 'ITEM #9682__ITEM #9682', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9683, 'ITEM #9683__ITEM #9683', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9684, 'ITEM #9684__ITEM #9684', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9685, 'ITEM #9685__ITEM #9685', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9686, 'ITEM #9686__ITEM #9686', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9687, 'ITEM #9687__ITEM #9687', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9688, 'ITEM #9688__ITEM #9688', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9689, 'ITEM #9689__ITEM #9689', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9690, 'ITEM #9690__ITEM #9690', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9691, 'ITEM #9691__ITEM #9691', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9692, 'ITEM #9692__ITEM #9692', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9693, 'ITEM #9693__ITEM #9693', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9694, 'ITEM #9694__ITEM #9694', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9695, 'ITEM #9695__ITEM #9695', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9696, 'ITEM #9696__ITEM #9696', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9697, 'ITEM #9697__ITEM #9697', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9698, 'ITEM #9698__ITEM #9698', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9699, 'ITEM #9699__ITEM #9699', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9700, 'ITEM #9700__ITEM #9700', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9701, 'ITEM #9701__ITEM #9701', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9702, 'ITEM #9702__ITEM #9702', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9703, 'ITEM #9703__ITEM #9703', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9704, 'ITEM #9704__ITEM #9704', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9705, 'ITEM #9705__ITEM #9705', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9706, 'ITEM #9706__ITEM #9706', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9707, 'ITEM #9707__ITEM #9707', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9708, 'ITEM #9708__ITEM #9708', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9709, 'ITEM #9709__ITEM #9709', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9710, 'ITEM #9710__ITEM #9710', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9711, 'ITEM #9711__ITEM #9711', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9712, 'ITEM #9712__ITEM #9712', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9713, 'ITEM #9713__ITEM #9713', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9714, 'ITEM #9714__ITEM #9714', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9715, 'ITEM #9715__ITEM #9715', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9716, 'ITEM #9716__ITEM #9716', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9717, 'ITEM #9717__ITEM #9717', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9718, 'ITEM #9718__ITEM #9718', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9719, 'ITEM #9719__ITEM #9719', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9720, 'ITEM #9720__ITEM #9720', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9721, 'ITEM #9721__ITEM #9721', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9722, 'ITEM #9722__ITEM #9722', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9723, 'ITEM #9723__ITEM #9723', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9724, 'ITEM #9724__ITEM #9724', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9725, 'ITEM #9725__ITEM #9725', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9726, 'ITEM #9726__ITEM #9726', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9727, 'ITEM #9727__ITEM #9727', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9728, 'ITEM #9728__ITEM #9728', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9729, 'ITEM #9729__ITEM #9729', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9730, 'ITEM #9730__ITEM #9730', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9731, 'ITEM #9731__ITEM #9731', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9732, 'ITEM #9732__ITEM #9732', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9733, 'ITEM #9733__ITEM #9733', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9734, 'ITEM #9734__ITEM #9734', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9735, 'ITEM #9735__ITEM #9735', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9736, 'ITEM #9736__ITEM #9736', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9737, 'ITEM #9737__ITEM #9737', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9738, 'ITEM #9738__ITEM #9738', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9739, 'ITEM #9739__ITEM #9739', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9740, 'ITEM #9740__ITEM #9740', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9741, 'ITEM #9741__ITEM #9741', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9742, 'ITEM #9742__ITEM #9742', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9743, 'ITEM #9743__ITEM #9743', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9744, 'ITEM #9744__ITEM #9744', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9745, 'ITEM #9745__ITEM #9745', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9746, 'ITEM #9746__ITEM #9746', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9747, 'ITEM #9747__ITEM #9747', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9748, 'ITEM #9748__ITEM #9748', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9749, 'ITEM #9749__ITEM #9749', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9750, 'ITEM #9750__ITEM #9750', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9751, 'ITEM #9751__ITEM #9751', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9752, 'ITEM #9752__ITEM #9752', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9753, 'ITEM #9753__ITEM #9753', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9754, 'ITEM #9754__ITEM #9754', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9755, 'ITEM #9755__ITEM #9755', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9756, 'ITEM #9756__ITEM #9756', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9757, 'ITEM #9757__ITEM #9757', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9758, 'ITEM #9758__ITEM #9758', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9759, 'ITEM #9759__ITEM #9759', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9760, 'ITEM #9760__ITEM #9760', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9761, 'ITEM #9761__ITEM #9761', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9762, 'ITEM #9762__ITEM #9762', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9763, 'ITEM #9763__ITEM #9763', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9764, 'ITEM #9764__ITEM #9764', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9765, 'ITEM #9765__ITEM #9765', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9766, 'ITEM #9766__ITEM #9766', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9767, 'ITEM #9767__ITEM #9767', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9768, 'ITEM #9768__ITEM #9768', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9769, 'ITEM #9769__ITEM #9769', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9770, 'ITEM #9770__ITEM #9770', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9771, 'ITEM #9771__ITEM #9771', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9772, 'ITEM #9772__ITEM #9772', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9773, 'ITEM #9773__ITEM #9773', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9774, 'ITEM #9774__ITEM #9774', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9775, 'ITEM #9775__ITEM #9775', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9776, 'ITEM #9776__ITEM #9776', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9777, 'ITEM #9777__ITEM #9777', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9778, 'ITEM #9778__ITEM #9778', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9779, 'ITEM #9779__ITEM #9779', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9780, 'ITEM #9780__ITEM #9780', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9781, 'ITEM #9781__ITEM #9781', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9782, 'ITEM #9782__ITEM #9782', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9783, 'ITEM #9783__ITEM #9783', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9784, 'ITEM #9784__ITEM #9784', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9785, 'ITEM #9785__ITEM #9785', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9786, 'ITEM #9786__ITEM #9786', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9787, 'ITEM #9787__ITEM #9787', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9788, 'ITEM #9788__ITEM #9788', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9789, 'ITEM #9789__ITEM #9789', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9790, 'ITEM #9790__ITEM #9790', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9791, 'ITEM #9791__ITEM #9791', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9792, 'ITEM #9792__ITEM #9792', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9793, 'ITEM #9793__ITEM #9793', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9794, 'ITEM #9794__ITEM #9794', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9795, 'ITEM #9795__ITEM #9795', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9796, 'ITEM #9796__ITEM #9796', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9797, 'ITEM #9797__ITEM #9797', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9798, 'ITEM #9798__ITEM #9798', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9799, 'ITEM #9799__ITEM #9799', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9800, 'ITEM #9800__ITEM #9800', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9801, 'ITEM #9801__ITEM #9801', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9802, 'ITEM #9802__ITEM #9802', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9803, 'ITEM #9803__ITEM #9803', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9804, 'ITEM #9804__ITEM #9804', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9805, 'ITEM #9805__ITEM #9805', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9806, 'ITEM #9806__ITEM #9806', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9807, 'ITEM #9807__ITEM #9807', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9808, 'ITEM #9808__ITEM #9808', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9809, 'ITEM #9809__ITEM #9809', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9810, 'ITEM #9810__ITEM #9810', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9811, 'ITEM #9811__ITEM #9811', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9812, 'ITEM #9812__ITEM #9812', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9813, 'ITEM #9813__ITEM #9813', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9814, 'ITEM #9814__ITEM #9814', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9815, 'ITEM #9815__ITEM #9815', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9816, 'ITEM #9816__ITEM #9816', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9817, 'ITEM #9817__ITEM #9817', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9818, 'ITEM #9818__ITEM #9818', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9819, 'ITEM #9819__ITEM #9819', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9820, 'ITEM #9820__ITEM #9820', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9821, 'ITEM #9821__ITEM #9821', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9822, 'ITEM #9822__ITEM #9822', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9823, 'ITEM #9823__ITEM #9823', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9824, 'ITEM #9824__ITEM #9824', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9825, 'ITEM #9825__ITEM #9825', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9826, 'ITEM #9826__ITEM #9826', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9827, 'ITEM #9827__ITEM #9827', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9828, 'ITEM #9828__ITEM #9828', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9829, 'ITEM #9829__ITEM #9829', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9830, 'ITEM #9830__ITEM #9830', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9831, 'ITEM #9831__ITEM #9831', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9832, 'ITEM #9832__ITEM #9832', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9833, 'ITEM #9833__ITEM #9833', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9834, 'ITEM #9834__ITEM #9834', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9835, 'ITEM #9835__ITEM #9835', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9836, 'ITEM #9836__ITEM #9836', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9837, 'ITEM #9837__ITEM #9837', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9838, 'ITEM #9838__ITEM #9838', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9839, 'ITEM #9839__ITEM #9839', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9840, 'ITEM #9840__ITEM #9840', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9841, 'ITEM #9841__ITEM #9841', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9842, 'ITEM #9842__ITEM #9842', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9843, 'ITEM #9843__ITEM #9843', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9844, 'ITEM #9844__ITEM #9844', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9845, 'ITEM #9845__ITEM #9845', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9846, 'ITEM #9846__ITEM #9846', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9847, 'ITEM #9847__ITEM #9847', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9848, 'ITEM #9848__ITEM #9848', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9849, 'ITEM #9849__ITEM #9849', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9850, 'ITEM #9850__ITEM #9850', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9851, 'ITEM #9851__ITEM #9851', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9852, 'ITEM #9852__ITEM #9852', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9853, 'ITEM #9853__ITEM #9853', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9854, 'ITEM #9854__ITEM #9854', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9855, 'ITEM #9855__ITEM #9855', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9856, 'ITEM #9856__ITEM #9856', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9857, 'ITEM #9857__ITEM #9857', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9858, 'ITEM #9858__ITEM #9858', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9859, 'ITEM #9859__ITEM #9859', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9860, 'ITEM #9860__ITEM #9860', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9861, 'ITEM #9861__ITEM #9861', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9862, 'ITEM #9862__ITEM #9862', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9863, 'ITEM #9863__ITEM #9863', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9864, 'ITEM #9864__ITEM #9864', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9865, 'ITEM #9865__ITEM #9865', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9866, 'ITEM #9866__ITEM #9866', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9867, 'ITEM #9867__ITEM #9867', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9868, 'ITEM #9868__ITEM #9868', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9869, 'ITEM #9869__ITEM #9869', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9870, 'ITEM #9870__ITEM #9870', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9871, 'ITEM #9871__ITEM #9871', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9872, 'ITEM #9872__ITEM #9872', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9873, 'ITEM #9873__ITEM #9873', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9874, 'ITEM #9874__ITEM #9874', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9875, 'ITEM #9875__ITEM #9875', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9876, 'ITEM #9876__ITEM #9876', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9877, 'ITEM #9877__ITEM #9877', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9878, 'ITEM #9878__ITEM #9878', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9879, 'ITEM #9879__ITEM #9879', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9880, 'ITEM #9880__ITEM #9880', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9881, 'ITEM #9881__ITEM #9881', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9882, 'ITEM #9882__ITEM #9882', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9883, 'ITEM #9883__ITEM #9883', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9884, 'ITEM #9884__ITEM #9884', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9885, 'ITEM #9885__ITEM #9885', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9886, 'ITEM #9886__ITEM #9886', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9887, 'ITEM #9887__ITEM #9887', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9888, 'ITEM #9888__ITEM #9888', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9889, 'ITEM #9889__ITEM #9889', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9890, 'ITEM #9890__ITEM #9890', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9891, 'ITEM #9891__ITEM #9891', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9892, 'ITEM #9892__ITEM #9892', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9893, 'ITEM #9893__ITEM #9893', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9894, 'ITEM #9894__ITEM #9894', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9895, 'ITEM #9895__ITEM #9895', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9896, 'ITEM #9896__ITEM #9896', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9897, 'ITEM #9897__ITEM #9897', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9898, 'ITEM #9898__ITEM #9898', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9899, 'ITEM #9899__ITEM #9899', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9900, 'ITEM #9900__ITEM #9900', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9901, 'ITEM #9901__ITEM #9901', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9902, 'ITEM #9902__ITEM #9902', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9903, 'ITEM #9903__ITEM #9903', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9904, 'ITEM #9904__ITEM #9904', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9905, 'ITEM #9905__ITEM #9905', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9906, 'ITEM #9906__ITEM #9906', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9907, 'ITEM #9907__ITEM #9907', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9908, 'ITEM #9908__ITEM #9908', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9909, 'ITEM #9909__ITEM #9909', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9910, 'ITEM #9910__ITEM #9910', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9911, 'ITEM #9911__ITEM #9911', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9912, 'ITEM #9912__ITEM #9912', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9913, 'ITEM #9913__ITEM #9913', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9914, 'ITEM #9914__ITEM #9914', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9915, 'ITEM #9915__ITEM #9915', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9916, 'ITEM #9916__ITEM #9916', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9917, 'ITEM #9917__ITEM #9917', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9918, 'ITEM #9918__ITEM #9918', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9919, 'ITEM #9919__ITEM #9919', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9920, 'ITEM #9920__ITEM #9920', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9921, 'ITEM #9921__ITEM #9921', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9922, 'ITEM #9922__ITEM #9922', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9923, 'ITEM #9923__ITEM #9923', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9924, 'ITEM #9924__ITEM #9924', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9925, 'ITEM #9925__ITEM #9925', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9926, 'ITEM #9926__ITEM #9926', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9927, 'ITEM #9927__ITEM #9927', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9928, 'ITEM #9928__ITEM #9928', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9929, 'ITEM #9929__ITEM #9929', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9930, 'ITEM #9930__ITEM #9930', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9931, 'ITEM #9931__ITEM #9931', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9932, 'ITEM #9932__ITEM #9932', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9933, 'ITEM #9933__ITEM #9933', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9934, 'ITEM #9934__ITEM #9934', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9935, 'ITEM #9935__ITEM #9935', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9936, 'ITEM #9936__ITEM #9936', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9937, 'ITEM #9937__ITEM #9937', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9938, 'ITEM #9938__ITEM #9938', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9939, 'ITEM #9939__ITEM #9939', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9940, 'ITEM #9940__ITEM #9940', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9941, 'ITEM #9941__ITEM #9941', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9942, 'ITEM #9942__ITEM #9942', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9943, 'ITEM #9943__ITEM #9943', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9944, 'ITEM #9944__ITEM #9944', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9945, 'ITEM #9945__ITEM #9945', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9946, 'ITEM #9946__ITEM #9946', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9947, 'ITEM #9947__ITEM #9947', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9948, 'ITEM #9948__ITEM #9948', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9949, 'ITEM #9949__ITEM #9949', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9950, 'ITEM #9950__ITEM #9950', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9951, 'ITEM #9951__ITEM #9951', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9952, 'ITEM #9952__ITEM #9952', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9953, 'ITEM #9953__ITEM #9953', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9954, 'ITEM #9954__ITEM #9954', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9955, 'ITEM #9955__ITEM #9955', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9956, 'ITEM #9956__ITEM #9956', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9957, 'ITEM #9957__ITEM #9957', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9958, 'ITEM #9958__ITEM #9958', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9959, 'ITEM #9959__ITEM #9959', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9960, 'ITEM #9960__ITEM #9960', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9961, 'ITEM #9961__ITEM #9961', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9962, 'ITEM #9962__ITEM #9962', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9963, 'ITEM #9963__ITEM #9963', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9964, 'ITEM #9964__ITEM #9964', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9965, 'ITEM #9965__ITEM #9965', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9966, 'ITEM #9966__ITEM #9966', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9967, 'ITEM #9967__ITEM #9967', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9968, 'ITEM #9968__ITEM #9968', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9969, 'ITEM #9969__ITEM #9969', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9970, 'ITEM #9970__ITEM #9970', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9971, 'ITEM #9971__ITEM #9971', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9972, 'ITEM #9972__ITEM #9972', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9973, 'ITEM #9973__ITEM #9973', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9974, 'ITEM #9974__ITEM #9974', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9975, 'ITEM #9975__ITEM #9975', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9976, 'ITEM #9976__ITEM #9976', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9977, 'ITEM #9977__ITEM #9977', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9978, 'ITEM #9978__ITEM #9978', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9979, 'ITEM #9979__ITEM #9979', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9980, 'ITEM #9980__ITEM #9980', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9981, 'ITEM #9981__ITEM #9981', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9982, 'ITEM #9982__ITEM #9982', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9983, 'ITEM #9983__ITEM #9983', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9984, 'ITEM #9984__ITEM #9984', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9985, 'ITEM #9985__ITEM #9985', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9986, 'ITEM #9986__ITEM #9986', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9987, 'ITEM #9987__ITEM #9987', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9988, 'ITEM #9988__ITEM #9988', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9989, 'ITEM #9989__ITEM #9989', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9990, 'ITEM #9990__ITEM #9990', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9991, 'ITEM #9991__ITEM #9991', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9992, 'ITEM #9992__ITEM #9992', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9993, 'ITEM #9993__ITEM #9993', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9994, 'ITEM #9994__ITEM #9994', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9995, 'ITEM #9995__ITEM #9995', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9996, 'ITEM #9996__ITEM #9996', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9997, 'ITEM #9997__ITEM #9997', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9998, 'ITEM #9998__ITEM #9998', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (9999, 'ITEM #9999__ITEM #9999', NULL);
INSERT INTO BIGTABLE (ID, NAME, LAST_UPDATE) VALUES (10000, 'ITEM #10000__ITEM #10000', NULL);

COMMIT WORK;


SET BLOBFILE 'metadata.lob';

INSERT INTO BLOBFLT (GUID, NAME, BLOBDATA) VALUES ('mbg9L-LT', 'D:\1.sql', :h0_1C0);
INSERT INTO BLOBFLT (GUID, NAME, BLOBDATA) VALUES ('Cc_0RB_UnRs', 'D:\33.sql', :h1C0_4CF);

COMMIT WORK;

INSERT INTO COUNTRY (COUNTRY, CURRENCY) VALUES ('USA', 'Dollar');
INSERT INTO COUNTRY (COUNTRY, CURRENCY) VALUES ('England', 'Pound');
INSERT INTO COUNTRY (COUNTRY, CURRENCY) VALUES ('Canada', 'CdnDlr');
INSERT INTO COUNTRY (COUNTRY, CURRENCY) VALUES ('Switzerland', 'SFranc');
INSERT INTO COUNTRY (COUNTRY, CURRENCY) VALUES ('Japan', 'Yen');
INSERT INTO COUNTRY (COUNTRY, CURRENCY) VALUES ('Italy', 'Lira');
INSERT INTO COUNTRY (COUNTRY, CURRENCY) VALUES ('France', 'FFranc');
INSERT INTO COUNTRY (COUNTRY, CURRENCY) VALUES ('Germany', 'D-Mark');
INSERT INTO COUNTRY (COUNTRY, CURRENCY) VALUES ('Australia', 'ADollar');
INSERT INTO COUNTRY (COUNTRY, CURRENCY) VALUES ('Hong Kong', 'HKDollar');
INSERT INTO COUNTRY (COUNTRY, CURRENCY) VALUES ('Netherlands', 'Guilder');
INSERT INTO COUNTRY (COUNTRY, CURRENCY) VALUES ('Belgium', 'BFranc');
INSERT INTO COUNTRY (COUNTRY, CURRENCY) VALUES ('Austria', 'Schilling');
INSERT INTO COUNTRY (COUNTRY, CURRENCY) VALUES ('Fiji', 'FDollar');

COMMIT WORK;

INSERT INTO CUSTOMER (CUST_NO, CUSTOMER, CONTACT_FIRST, CONTACT_LAST, PHONE_NO, ADDRESS_LINE1, ADDRESS_LINE2, CITY, STATE_PROVINCE, COUNTRY, POSTAL_CODE, ON_HOLD) VALUES (1001, 'Signature Design', 'Dale J.', 'Little', '(619) 530-2710', '15500 Pacific Heights Blvd.', NULL, 'San Diego', 'CA', 'USA', '92121', NULL);
INSERT INTO CUSTOMER (CUST_NO, CUSTOMER, CONTACT_FIRST, CONTACT_LAST, PHONE_NO, ADDRESS_LINE1, ADDRESS_LINE2, CITY, STATE_PROVINCE, COUNTRY, POSTAL_CODE, ON_HOLD) VALUES (1002, 'Dallas Technologies', 'Glen', 'Brown', '(214) 960-2233', 'P. O. Box 47000', NULL, 'Dallas', 'TX', 'USA', '75205', '*');
INSERT INTO CUSTOMER (CUST_NO, CUSTOMER, CONTACT_FIRST, CONTACT_LAST, PHONE_NO, ADDRESS_LINE1, ADDRESS_LINE2, CITY, STATE_PROVINCE, COUNTRY, POSTAL_CODE, ON_HOLD) VALUES (1003, 'Buttle, Griffith and Co.', 'James', 'Buttle', '(617) 488-1864', '2300 Newbury Street', 'Suite 101', 'Boston', 'MA', 'USA', '02115', NULL);
INSERT INTO CUSTOMER (CUST_NO, CUSTOMER, CONTACT_FIRST, CONTACT_LAST, PHONE_NO, ADDRESS_LINE1, ADDRESS_LINE2, CITY, STATE_PROVINCE, COUNTRY, POSTAL_CODE, ON_HOLD) VALUES (1004, 'Central Bank', 'Elizabeth', 'Brocket', '61 211 99 88', '66 Lloyd Street', NULL, 'Manchester', NULL, 'England', 'M2 3LA', NULL);
INSERT INTO CUSTOMER (CUST_NO, CUSTOMER, CONTACT_FIRST, CONTACT_LAST, PHONE_NO, ADDRESS_LINE1, ADDRESS_LINE2, CITY, STATE_PROVINCE, COUNTRY, POSTAL_CODE, ON_HOLD) VALUES (1005, 'DT Systems, LTD.', 'Tai', 'Wu', '(852) 850 43 98', '400 Connaught Road', NULL, 'Central Hong Kong', NULL, 'Hong Kong', NULL, NULL);
INSERT INTO CUSTOMER (CUST_NO, CUSTOMER, CONTACT_FIRST, CONTACT_LAST, PHONE_NO, ADDRESS_LINE1, ADDRESS_LINE2, CITY, STATE_PROVINCE, COUNTRY, POSTAL_CODE, ON_HOLD) VALUES (1006, 'DataServe International', 'Tomas', 'Bright', '(613) 229 3323', '2000 Carling Avenue', 'Suite 150', 'Ottawa', 'ON', 'Canada', 'K1V 9G1', NULL);
INSERT INTO CUSTOMER (CUST_NO, CUSTOMER, CONTACT_FIRST, CONTACT_LAST, PHONE_NO, ADDRESS_LINE1, ADDRESS_LINE2, CITY, STATE_PROVINCE, COUNTRY, POSTAL_CODE, ON_HOLD) VALUES (1007, 'Mrs. Beauvais', NULL, 'Mrs. Beauvais', NULL, 'P.O. Box 22743', NULL, 'Pebble Beach', 'CA', 'USA', '93953', NULL);
INSERT INTO CUSTOMER (CUST_NO, CUSTOMER, CONTACT_FIRST, CONTACT_LAST, PHONE_NO, ADDRESS_LINE1, ADDRESS_LINE2, CITY, STATE_PROVINCE, COUNTRY, POSTAL_CODE, ON_HOLD) VALUES (1008, 'Anini Vacation Rentals', 'Leilani', 'Briggs', '(808) 835-7605', '3320 Lawai Road', NULL, 'Lihue', 'HI', 'USA', '96766', NULL);
INSERT INTO CUSTOMER (CUST_NO, CUSTOMER, CONTACT_FIRST, CONTACT_LAST, PHONE_NO, ADDRESS_LINE1, ADDRESS_LINE2, CITY, STATE_PROVINCE, COUNTRY, POSTAL_CODE, ON_HOLD) VALUES (1009, 'Max', 'Max', NULL, '22 01 23', '1 Emerald Cove', NULL, 'Turtle Island', NULL, 'Fiji', NULL, '*');
INSERT INTO CUSTOMER (CUST_NO, CUSTOMER, CONTACT_FIRST, CONTACT_LAST, PHONE_NO, ADDRESS_LINE1, ADDRESS_LINE2, CITY, STATE_PROVINCE, COUNTRY, POSTAL_CODE, ON_HOLD) VALUES (1010, 'MPM Corporation', 'Miwako', 'Miyamoto', '3 880 77 19', '2-64-7 Sasazuka', NULL, 'Tokyo', NULL, 'Japan', '150', NULL);
INSERT INTO CUSTOMER (CUST_NO, CUSTOMER, CONTACT_FIRST, CONTACT_LAST, PHONE_NO, ADDRESS_LINE1, ADDRESS_LINE2, CITY, STATE_PROVINCE, COUNTRY, POSTAL_CODE, ON_HOLD) VALUES (1011, 'Dynamic Intelligence Corp', 'Victor', 'Granges', '01 221 16 50', 'Florhofgasse 10', NULL, 'Zurich', NULL, 'Switzerland', '8005', NULL);
INSERT INTO CUSTOMER (CUST_NO, CUSTOMER, CONTACT_FIRST, CONTACT_LAST, PHONE_NO, ADDRESS_LINE1, ADDRESS_LINE2, CITY, STATE_PROVINCE, COUNTRY, POSTAL_CODE, ON_HOLD) VALUES (1012, '3D-Pad Corp.', 'Michelle', 'Roche', '1 43 60 61', '22 Place de la Concorde', NULL, 'Paris', NULL, 'France', '75008', NULL);
INSERT INTO CUSTOMER (CUST_NO, CUSTOMER, CONTACT_FIRST, CONTACT_LAST, PHONE_NO, ADDRESS_LINE1, ADDRESS_LINE2, CITY, STATE_PROVINCE, COUNTRY, POSTAL_CODE, ON_HOLD) VALUES (1013, 'Lorenzi Export, Ltd.', 'Andreas', 'Lorenzi', '02 404 6284', 'Via Eugenia, 15', NULL, 'Milan', NULL, 'Italy', '20124', NULL);
INSERT INTO CUSTOMER (CUST_NO, CUSTOMER, CONTACT_FIRST, CONTACT_LAST, PHONE_NO, ADDRESS_LINE1, ADDRESS_LINE2, CITY, STATE_PROVINCE, COUNTRY, POSTAL_CODE, ON_HOLD) VALUES (1014, 'Dyno Consulting', 'Greta', 'Hessels', '02 500 5940', 'Rue Royale 350', NULL, 'Brussels', NULL, 'Belgium', '1210', NULL);
INSERT INTO CUSTOMER (CUST_NO, CUSTOMER, CONTACT_FIRST, CONTACT_LAST, PHONE_NO, ADDRESS_LINE1, ADDRESS_LINE2, CITY, STATE_PROVINCE, COUNTRY, POSTAL_CODE, ON_HOLD) VALUES (1015, 'GeoTech Inc.', 'K.M.', 'Neppelenbroek', '(070) 44 91 18', 'P.0.Box 702', NULL, 'Den Haag', NULL, 'Netherlands', '2514', NULL);

COMMIT WORK;

INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('000', 'Corporate Headquarters', NULL, 105, 1000000, 'Monterey', '(408) 555-1234', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('100', 'Sales and Marketing', '000', 85, 2000000, 'San Francisco', '(415) 555-1234', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('600', 'Engineering', '000', 2, 1100000, 'Monterey', '(408) 555-1234', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('900', 'Finance', '000', 46, 400000, 'Monterey', '(408) 555-1234', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('180', 'Marketing', '100', NULL, 1500000, 'San Francisco', '(415) 555-1234', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('620', 'Software Products Div.', '600', NULL, 1200000, 'Monterey', '(408) 555-1234', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('621', 'Software Development', '620', NULL, 400000, 'Monterey', '(408) 555-1234', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('622', 'Quality Assurance', '620', 9, 300000, 'Monterey', '(408) 555-1234', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('623', 'Customer Support', '620', 15, 650000, 'Monterey', '(408) 555-1234', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('670', 'Consumer Electronics Div.', '600', 107, 1150000, 'Burlington, VT', '(802) 555-1234', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('671', 'Research and Development', '670', 20, 460000, 'Burlington, VT', '(802) 555-1234', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('672', 'Customer Services', '670', 94, 850000, 'Burlington, VT', '(802) 555-1234', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('130', 'Field Office: East Coast', '100', 11, 500000, 'Boston', '(617) 555-1234', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('140', 'Field Office: Canada', '100', 72, 500000, 'Toronto', '(416) 677-1000', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('110', 'Pacific Rim Headquarters', '100', 34, 600000, 'Kuaui', '(808) 555-1234', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('115', 'Field Office: Japan', '110', 118, 500000, 'Tokyo', '3 5350 0901', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('116', 'Field Office: Singapore', '110', NULL, 300000, 'Singapore', '3 55 1234', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('120', 'European Headquarters', '100', 36, 700000, 'London', '71 235-4400', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('121', 'Field Office: Switzerland', '120', 141, 500000, 'Zurich', '1 211 7767', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('123', 'Field Office: France', '120', 134, 400000, 'Cannes', '58 68 11 12', NULL);
INSERT INTO DEPARTMENT (DEPT_NO, DEPARTMENT, HEAD_DEPT, MNGR_NO, BUDGET, LOCATION, PHONE_NO, DEPT_NO1) VALUES ('125', 'Field Office: Italy', '120', 121, 400000, 'Milan', '2 430 39 39', NULL);

COMMIT WORK;

INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('CEO', 1, 'USA', 'Chief Executive Officer', 130000, 250000, :h68F_1A, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('CFO', 1, 'USA', 'Chief Financial Officer', 85000, 140000, :h6A9_5A, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('VP', 2, 'USA', 'Vice President', 80000, 130000, :h703_1A, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Dir', 2, 'USA', 'Director', 75000, 120000, :h71D_54, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Mngr', 3, 'USA', 'Manager', 60000, 100000, :h771_50, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Mngr', 4, 'USA', 'Manager', 30000, 60000, :h7C1_27, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Admin', 4, 'USA', 'Administrative Assistant', 35000, 55000, :h7E8_7D, :h865_7D);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Admin', 5, 'USA', 'Administrative Assistant', 20000, 40000, :h8E2_62, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Admin', 5, 'England', 'Administrative Assistant', 13400, 26800, NULL, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('PRel', 4, 'USA', 'Public Relations Rep.', 25000, 65000, NULL, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Mktg', 3, 'USA', 'Marketing Analyst', 40000, 80000, :h944_3D, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Mktg', 4, 'USA', 'Marketing Analyst', 20000, 50000, :h981_65, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Accnt', 4, 'USA', 'Accountant', 28000, 55000, :h9E6_60, :hA46_7D);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Finan', 3, 'USA', 'Financial Analyst', 35000, 85000, :hAC3_5F, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Eng', 2, 'USA', 'Engineer', 70000, 110000, :hB22_3D, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Eng', 3, 'USA', 'Engineer', 50000, 90000, :hB5F_3A, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Eng', 3, 'Japan', 'Engineer', 5400000, 9720000, :hB99_7F, :hC18_7D);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Eng', 4, 'USA', 'Engineer', 30000, 65000, :hC95_20, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Eng', 4, 'England', 'Engineer', 20100, 43550, :hCB5_66, :hD1B_7D);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Eng', 5, 'USA', 'Engineer', 25000, 35000, :hD98_31, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Doc', 3, 'USA', 'Technical Writer', 38000, 60000, :hDC9_99, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Doc', 5, 'USA', 'Technical Writer', 22000, 40000, :hE62_7D, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Sales', 3, 'USA', 'Sales Co-ordinator', 40000, 70000, :hEDF_77, NULL);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('Sales', 3, 'England', 'Sales Co-ordinator', 26800, 46900, :hF56_A8, :hFFE_7D);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('SRep', 4, 'USA', 'Sales Representative', 20000, 100000, :h107B_E0, :h115B_7D);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('SRep', 4, 'England', 'Sales Representative', 13400, 67000, :h11D8_ED, :h12C5_7D);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('SRep', 4, 'Canada', 'Sales Representative', 26400, 132000, :h1342_F0, :h1432_7D);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('SRep', 4, 'Switzerland', 'Sales Representative', 28000, 149000, :h14AF_107, :h15B6_7D);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('SRep', 4, 'Japan', 'Sales Representative', 2160000, 10800000, :h1633_DC, :h170F_7D);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('SRep', 4, 'Italy', 'Sales Representative', 33600000, 168000000, :h178C_F2, :h187E_7D);
INSERT INTO JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY, JOB_TITLE, MIN_SALARY, MAX_SALARY, JOB_REQUIREMENT, LANGUAGE_REQ) VALUES ('SRep', 4, 'France', 'Sales Representative', 118200, 591000, :h18FB_F9, :h19F4_7D);

COMMIT WORK;

INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (2, 'Robert', 'Nelson', '250', '1988-12-28 00:00:00', '600', 'VP', 2, 'USA', 105900);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (4, 'Bruce Lee', 'Young!', '233', '1988-12-28 00:00:00', '621', 'Eng', 2, 'USA', 97500);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (5, 'Kim', 'Lambert', '22', '1989-02-06 00:00:00', '130', 'Eng', 2, 'USA', 102750);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (8, 'Leslie', 'Johnson', '410', '1989-04-05 00:00:00', '180', 'Mktg', 3, 'USA', 64635);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (9, 'Phil', 'Forest', '229', '1989-04-17 00:00:00', '622', 'Mngr', 3, 'USA', 75060);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (11, 'K. J.', 'Weston', '34', '1990-01-17 00:00:00', '130', 'SRep', 4, 'USA', 86292.9375);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (12, 'Terri', 'Lee', '256', '1990-05-01 00:00:00', '000', 'Admin', 4, 'USA', 53793);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (14, 'Stewart', 'Hall', '227', '1990-06-04 00:00:00', '900', 'Finan', 3, 'USA', 69482.625);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (15, 'Katherine', 'Young', '231', '1990-06-14 00:00:00', '623', 'Mngr', 3, 'USA', 67241.25);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (20, 'Chris', 'Papadopoulos', '887', '1990-01-01 00:00:00', '671', 'Mngr', 3, 'USA', 89655);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (24, 'Pete', 'Fisher', '888', '1990-09-12 00:00:00', '671', 'Eng', 3, 'USA', 81810.1875);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (28, 'Ann', 'Bennet', '5', '1991-02-01 00:00:00', '120', 'Admin', 5, 'England', 22935);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (29, 'Roger', 'De Souza', '288', '1991-02-18 00:00:00', '623', 'Eng', 3, 'USA', 69482.625);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (34, 'Janet', 'Baldwin', '2', '1991-03-21 00:00:00', '110', 'Sales', 3, 'USA', 61637.8125);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (36, 'Roger', 'Reeves', '6', '1991-04-25 00:00:00', '120', 'Sales', 3, 'England', 33620.625);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (37, 'Willie', 'Stansbury', '7', '1991-04-25 00:00:00', '120', 'Eng', 4, 'England', 39224.0625);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (44, 'Leslie', 'Phong', '216', '1991-06-03 00:00:00', '623', 'Eng', 4, 'USA', 56034.375);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (45, 'Ashok', 'Ramanathan', '209', '1991-08-01 00:00:00', '621', 'Eng', 3, 'USA', 80689.5);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (46, 'Walter', 'Steadman', '210', '1991-08-09 00:00:00', '900', 'CFO', 1, 'USA', 116100);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (52, 'Carol', 'Nordstrom', '420', '1991-10-02 00:00:00', '180', 'PRel', 4, 'USA', 42742.5);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (61, 'Luke', 'Leung', '3', '1992-02-18 00:00:00', '110', 'SRep', 4, 'USA', 68805);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (65, 'Sue Anne', 'O''Brien', '877', '1992-03-23 00:00:00', '670', 'Admin', 5, 'USA', 31275);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (71, 'Jennifer M.', 'Burbank', '289', '1992-04-15 00:00:00', '622', 'Eng', 3, 'USA', 53167.5);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (72, 'Claudia', 'Sutherland', NULL, '1992-04-20 00:00:00', '140', 'SRep', 4, 'Canada', 100914);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (83, 'Dana', 'Bishop', '290', '1992-06-01 00:00:00', '621', 'Eng', 3, 'USA', 62550);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (85, 'Mary S.', 'MacDonald', '477', '1992-06-01 00:00:00', '100', 'VP', 2, 'USA', 111262.5);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (94, 'Randy', 'Williams', '892', '1992-08-08 00:00:00', '672', 'Mngr', 4, 'USA', 56295);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (105, 'Oliver H.', 'Bender', '255', '1992-10-08 00:00:00', '000', 'CEO', 1, 'USA', 212850);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (107, 'Kevin', 'Cook', '894', '1993-02-01 00:00:00', '670', 'Dir', 2, 'USA', 111262.5);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (109, 'Kelly', 'Brown', '202', '1993-02-04 00:00:00', '600', 'Admin', 5, 'USA', 27000);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (110, 'Yuki', 'Ichida', '22', '1993-02-04 00:00:00', '115', 'Eng', 3, 'Japan', 6000000);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (113, 'Mary', 'Page', '845', '1993-04-12 00:00:00', '671', 'Eng', 4, 'USA', 48000);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (114, 'Bill', 'Parker', '247', '1993-06-01 00:00:00', '623', 'Eng', 5, 'USA', 35000);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (118, 'Takashi', 'Yamamoto', '23', '1993-07-01 00:00:00', '115', 'SRep', 4, 'Japan', 7480000);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (121, 'Roberto', 'Ferrari', '1', '1993-07-12 00:00:00', '125', 'SRep', 4, 'Italy', 99000000);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (127, 'Michael', 'Yanowski', '492', '1993-08-09 00:00:00', '100', 'SRep', 4, 'USA', 44000);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (134, 'Jacques', 'Glon', NULL, '1993-08-23 00:00:00', '123', 'SRep', 4, 'France', 390500);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (136, 'Scott', 'Johnson', '265', '1993-09-13 00:00:00', '623', 'Doc', 3, 'USA', 60000);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (138, 'T.J.', 'Green', '218', '1993-11-01 00:00:00', '621', 'Eng', 4, 'USA', 36000);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (141, 'Pierre', 'Osborne', NULL, '1994-01-03 00:00:00', '121', 'SRep', 4, 'Switzerland', 110000);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (144, 'John', 'Montgomery', '820', '1994-03-30 00:00:00', '672', 'Eng', 5, 'USA', 35000);
INSERT INTO EMPLOYEE (EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY) VALUES (145, 'Mark', 'Guckenheimer', '221', '1994-05-02 00:00:00', '622', 'Eng', 5, 'USA', 32000);

COMMIT WORK;

INSERT INTO PROJECT (PROJ_ID, PROJ_NAME, PROJ_DESC, TEAM_LEADER, PRODUCT) VALUES ('VBASE', 'Video Database', :h1A71_59, 45, 'software');
INSERT INTO PROJECT (PROJ_ID, PROJ_NAME, PROJ_DESC, TEAM_LEADER, PRODUCT) VALUES ('DGPII', 'DigiPizza', :h1ACA_77, 24, 'other');
INSERT INTO PROJECT (PROJ_ID, PROJ_NAME, PROJ_DESC, TEAM_LEADER, PRODUCT) VALUES ('GUIDE', 'AutoMap', :h1B41_55, 20, 'hardware');
INSERT INTO PROJECT (PROJ_ID, PROJ_NAME, PROJ_DESC, TEAM_LEADER, PRODUCT) VALUES ('MAPDB', 'MapBrowser port', :h1B96_48, 4, 'software');
INSERT INTO PROJECT (PROJ_ID, PROJ_NAME, PROJ_DESC, TEAM_LEADER, PRODUCT) VALUES ('HWRII', 'Translator upgrade', :h1BDE_56, NULL, 'software');
INSERT INTO PROJECT (PROJ_ID, PROJ_NAME, PROJ_DESC, TEAM_LEADER, PRODUCT) VALUES ('MKTPR', 'Marketing project 3', :h1C34_61, 85, 'N/A');

COMMIT WORK;

INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (144, 'DGPII');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (113, 'DGPII');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (24, 'DGPII');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (8, 'VBASE');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (136, 'VBASE');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (15, 'VBASE');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (71, 'VBASE');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (145, 'VBASE');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (44, 'VBASE');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (4, 'VBASE');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (83, 'VBASE');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (138, 'VBASE');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (45, 'VBASE');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (20, 'GUIDE');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (24, 'GUIDE');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (113, 'GUIDE');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (8, 'GUIDE');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (4, 'MAPDB');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (71, 'MAPDB');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (46, 'MKTPR');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (105, 'MKTPR');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (12, 'MKTPR');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (85, 'MKTPR');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (110, 'MKTPR');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (34, 'MKTPR');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (8, 'MKTPR');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (14, 'MKTPR');
INSERT INTO EMPLOYEE_PROJECT (EMP_NO, PROJ_ID) VALUES (52, 'MKTPR');

COMMIT WORK;

INSERT INTO FIB$DATASETS_INFO (DS_ID, DESCRIPTION, SELECT_SQL, UPDATE_SQL, INSERT_SQL, DELETE_SQL, REFRESH_SQL, NAME_GENERATOR, KEY_FIELD, UPDATE_TABLE_NAME, UPDATE_ONLY_MODIFIED_FIELDS, CONDITIONS, FIB$VERSION) VALUES (1, 'Emloyee Data', :h1C95_2A, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 66);
INSERT INTO FIB$DATASETS_INFO (DS_ID, DESCRIPTION, SELECT_SQL, UPDATE_SQL, INSERT_SQL, DELETE_SQL, REFRESH_SQL, NAME_GENERATOR, KEY_FIELD, UPDATE_TABLE_NAME, UPDATE_ONLY_MODIFIED_FIELDS, CONDITIONS, FIB$VERSION) VALUES (2, 'Customer Data', :h1CBF_3A, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 67);
INSERT INTO FIB$DATASETS_INFO (DS_ID, DESCRIPTION, SELECT_SQL, UPDATE_SQL, INSERT_SQL, DELETE_SQL, REFRESH_SQL, NAME_GENERATOR, KEY_FIELD, UPDATE_TABLE_NAME, UPDATE_ONLY_MODIFIED_FIELDS, CONDITIONS, FIB$VERSION) VALUES (3, 'Projects Data', :h1CF9_15, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 68);
INSERT INTO FIB$DATASETS_INFO (DS_ID, DESCRIPTION, SELECT_SQL, UPDATE_SQL, INSERT_SQL, DELETE_SQL, REFRESH_SQL, NAME_GENERATOR, KEY_FIELD, UPDATE_TABLE_NAME, UPDATE_ONLY_MODIFIED_FIELDS, CONDITIONS, FIB$VERSION) VALUES (4, 'afasdf', :h1D0E_43, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 69);
INSERT INTO FIB$DATASETS_INFO (DS_ID, DESCRIPTION, SELECT_SQL, UPDATE_SQL, INSERT_SQL, DELETE_SQL, REFRESH_SQL, NAME_GENERATOR, KEY_FIELD, UPDATE_TABLE_NAME, UPDATE_ONLY_MODIFIED_FIELDS, CONDITIONS, FIB$VERSION) VALUES (10, 'asfasf', :h1D51_C6, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 70);

COMMIT WORK;

INSERT INTO FIB$ERROR_MESSAGES (CONSTRAINT_NAME, MESSAGE_STRING, FIB$VERSION, CONSTR_TYPE) VALUES ('PK_FIB$FIELDS_INFO', NULL, 48, 'PRIMARY KEY');
INSERT INTO FIB$ERROR_MESSAGES (CONSTRAINT_NAME, MESSAGE_STRING, FIB$VERSION, CONSTR_TYPE) VALUES ('INTEG_28', 'Enter valid Department', 49, 'FOREIGN KEY');
INSERT INTO FIB$ERROR_MESSAGES (CONSTRAINT_NAME, MESSAGE_STRING, FIB$VERSION, CONSTR_TYPE) VALUES ('INTEG_29', 'Job Code, Job Grade and Job Country must be equal in Job Table', 50, 'FOREIGN KEY');
INSERT INTO FIB$ERROR_MESSAGES (CONSTRAINT_NAME, MESSAGE_STRING, FIB$VERSION, CONSTR_TYPE) VALUES ('INTEG_30', 'Salary not valid for selected Country, Job Grade and Job Code', 51, 'CHECK');
INSERT INTO FIB$ERROR_MESSAGES (CONSTRAINT_NAME, MESSAGE_STRING, FIB$VERSION, CONSTR_TYPE) VALUES ('INTEG_27', '', 52, 'PRIMARY KEY');

COMMIT WORK;

INSERT INTO FIB$FIELDS_INFO (TABLE_NAME, FIELD_NAME, DISPLAY_LABEL, VISIBLE, DISPLAY_FORMAT, EDIT_FORMAT, TRIGGERED, DISPLAY_WIDTH, FIB$VERSION, EDIT_MASK) VALUES ('CUSTOMER', 'CUST_NO', 'Cust No', 0, NULL, NULL, 0, 0, 53, NULL);
INSERT INTO FIB$FIELDS_INFO (TABLE_NAME, FIELD_NAME, DISPLAY_LABEL, VISIBLE, DISPLAY_FORMAT, EDIT_FORMAT, TRIGGERED, DISPLAY_WIDTH, FIB$VERSION, EDIT_MASK) VALUES ('CUSTOMER', 'CUSTOMER', 'Customer', 1, NULL, NULL, 0, 0, 54, NULL);
INSERT INTO FIB$FIELDS_INFO (TABLE_NAME, FIELD_NAME, DISPLAY_LABEL, VISIBLE, DISPLAY_FORMAT, EDIT_FORMAT, TRIGGERED, DISPLAY_WIDTH, FIB$VERSION, EDIT_MASK) VALUES ('CUSTOMER', 'CONTACT_FIRST', 'Last Contact', 1, NULL, NULL, 0, 0, 55, NULL);
INSERT INTO FIB$FIELDS_INFO (TABLE_NAME, FIELD_NAME, DISPLAY_LABEL, VISIBLE, DISPLAY_FORMAT, EDIT_FORMAT, TRIGGERED, DISPLAY_WIDTH, FIB$VERSION, EDIT_MASK) VALUES ('CUSTOMER', 'CONTACT_LAST', 'Contact First', 1, NULL, NULL, 0, 0, 56, NULL);
INSERT INTO FIB$FIELDS_INFO (TABLE_NAME, FIELD_NAME, DISPLAY_LABEL, VISIBLE, DISPLAY_FORMAT, EDIT_FORMAT, TRIGGERED, DISPLAY_WIDTH, FIB$VERSION, EDIT_MASK) VALUES ('CUSTOMER', 'PHONE_NO', 'Phone Number', 1, NULL, NULL, 0, 0, 57, '00 09 99 99;1;_');
INSERT INTO FIB$FIELDS_INFO (TABLE_NAME, FIELD_NAME, DISPLAY_LABEL, VISIBLE, DISPLAY_FORMAT, EDIT_FORMAT, TRIGGERED, DISPLAY_WIDTH, FIB$VERSION, EDIT_MASK) VALUES ('CUSTOMER', 'ADDRESS_LINE1', 'Address Line 1', 1, NULL, NULL, 0, 0, 58, NULL);
INSERT INTO FIB$FIELDS_INFO (TABLE_NAME, FIELD_NAME, DISPLAY_LABEL, VISIBLE, DISPLAY_FORMAT, EDIT_FORMAT, TRIGGERED, DISPLAY_WIDTH, FIB$VERSION, EDIT_MASK) VALUES ('CUSTOMER', 'ADDRESS_LINE2', 'Address Line 2', 1, NULL, NULL, 0, 0, 59, NULL);
INSERT INTO FIB$FIELDS_INFO (TABLE_NAME, FIELD_NAME, DISPLAY_LABEL, VISIBLE, DISPLAY_FORMAT, EDIT_FORMAT, TRIGGERED, DISPLAY_WIDTH, FIB$VERSION, EDIT_MASK) VALUES ('CUSTOMER', 'CITY', 'City', 1, NULL, NULL, 0, 0, 60, NULL);
INSERT INTO FIB$FIELDS_INFO (TABLE_NAME, FIELD_NAME, DISPLAY_LABEL, VISIBLE, DISPLAY_FORMAT, EDIT_FORMAT, TRIGGERED, DISPLAY_WIDTH, FIB$VERSION, EDIT_MASK) VALUES ('CUSTOMER', 'STATE_PROVINCE', 'State', 1, NULL, NULL, 0, 0, 61, NULL);
INSERT INTO FIB$FIELDS_INFO (TABLE_NAME, FIELD_NAME, DISPLAY_LABEL, VISIBLE, DISPLAY_FORMAT, EDIT_FORMAT, TRIGGERED, DISPLAY_WIDTH, FIB$VERSION, EDIT_MASK) VALUES ('CUSTOMER', 'COUNTRY', 'Country', 1, NULL, NULL, 0, 0, 62, NULL);
INSERT INTO FIB$FIELDS_INFO (TABLE_NAME, FIELD_NAME, DISPLAY_LABEL, VISIBLE, DISPLAY_FORMAT, EDIT_FORMAT, TRIGGERED, DISPLAY_WIDTH, FIB$VERSION, EDIT_MASK) VALUES ('CUSTOMER', 'POSTAL_CODE', 'Postal Code', 1, NULL, NULL, 0, 0, 63, NULL);
INSERT INTO FIB$FIELDS_INFO (TABLE_NAME, FIELD_NAME, DISPLAY_LABEL, VISIBLE, DISPLAY_FORMAT, EDIT_FORMAT, TRIGGERED, DISPLAY_WIDTH, FIB$VERSION, EDIT_MASK) VALUES ('CUSTOMER', 'ON_HOLD', 'On Hold', 1, NULL, NULL, 0, 0, 64, NULL);
INSERT INTO FIB$FIELDS_INFO (TABLE_NAME, FIELD_NAME, DISPLAY_LABEL, VISIBLE, DISPLAY_FORMAT, EDIT_FORMAT, TRIGGERED, DISPLAY_WIDTH, FIB$VERSION, EDIT_MASK) VALUES ('ALIAS', 'SALES_QUANTITY', 'Quantity of Sales', 1, NULL, NULL, 0, 0, 65, NULL);

COMMIT WORK;

INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (28, '1992-12-15 00:00:00', 'admin2', 20000, 10);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (2, '1992-12-15 00:00:00', 'admin2', 98000, 8.06122448979592);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (4, '1992-12-15 00:00:00', 'admin2', 90000, 8.33333333333333);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (5, '1992-12-15 00:00:00', 'admin2', 95000, 8.1578947368421);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (11, '1992-12-15 00:00:00', 'admin2', 70000, 7.5);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (12, '1992-12-15 00:00:00', 'admin2', 48000, 7.5);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (14, '1992-12-15 00:00:00', 'admin2', 62000, 7.5);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (15, '1992-12-15 00:00:00', 'admin2', 60000, 7.5);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (20, '1992-12-15 00:00:00', 'admin2', 80000, 7.5);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (24, '1992-12-15 00:00:00', 'admin2', 73000, 7.5);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (29, '1992-12-15 00:00:00', 'admin2', 62000, 7.5);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (34, '1992-12-15 00:00:00', 'admin2', 55000, 7.5);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (36, '1992-12-15 00:00:00', 'admin2', 30000, 7.5);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (37, '1992-12-15 00:00:00', 'admin2', 35000, 7.5);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (44, '1992-12-15 00:00:00', 'admin2', 50000, 7.5);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (45, '1992-12-15 00:00:00', 'admin2', 72000, 7.5);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (8, '1993-09-08 00:00:00', 'elaine', 62000, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (9, '1993-09-08 00:00:00', 'elaine', 72000, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (11, '1993-09-08 00:00:00', 'elaine', 75250, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (12, '1993-09-08 00:00:00', 'elaine', 51600, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (14, '1993-09-08 00:00:00', 'elaine', 66650, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (15, '1993-09-08 00:00:00', 'elaine', 64500, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (20, '1993-09-08 00:00:00', 'elaine', 86000, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (24, '1993-09-08 00:00:00', 'elaine', 78475, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (28, '1993-09-08 00:00:00', 'elaine', 22000, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (29, '1993-09-08 00:00:00', 'elaine', 66650, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (34, '1993-09-08 00:00:00', 'elaine', 59125, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (36, '1993-09-08 00:00:00', 'elaine', 32250, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (37, '1993-09-08 00:00:00', 'elaine', 37625, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (44, '1993-09-08 00:00:00', 'elaine', 53750, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (45, '1993-09-08 00:00:00', 'elaine', 77400, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (52, '1993-09-08 00:00:00', 'elaine', 41000, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (61, '1993-09-08 00:00:00', 'elaine', 60000, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (65, '1993-09-08 00:00:00', 'elaine', 30000, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (71, '1993-09-08 00:00:00', 'elaine', 51000, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (72, '1993-09-08 00:00:00', 'elaine', 88000, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (83, '1993-09-08 00:00:00', 'elaine', 60000, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (94, '1993-09-08 00:00:00', 'elaine', 54000, 4.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (46, '1993-12-20 00:00:00', 'tj', 120000, -3.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (85, '1993-12-20 00:00:00', 'tj', 115000, -3.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (105, '1993-12-20 00:00:00', 'tj', 220000, -3.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (107, '1993-12-20 00:00:00', 'tj', 115000, -3.25);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (11, '1993-12-20 00:00:00', 'elaine', 78448.125, 10);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (61, '1993-12-20 00:00:00', 'elaine', 62550, 10);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (72, '1993-12-20 00:00:00', 'elaine', 91740, 10);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (118, '1993-12-20 00:00:00', 'elaine', 6800000, 10);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (121, '1993-12-20 00:00:00', 'elaine', 90000000, 10);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (127, '1993-12-20 00:00:00', 'elaine', 40000, 10);
INSERT INTO SALARY_HISTORY (EMP_NO, CHANGE_DATE, UPDATER_ID, OLD_SALARY, PERCENT_CHANGE) VALUES (134, '1993-12-20 00:00:00', 'elaine', 355000, 10);

COMMIT WORK;

INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V91E0210', 1004, 11, 'shipped', '1991-03-04 00:00:00', '1991-03-05 00:00:00', NULL, 'y', 10, 5000, 0.100000001490116, 'hardware');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V92E0340', 1004, 11, 'shipped', '1992-10-15 00:00:00', '1992-10-16 00:00:00', '1992-10-17 00:00:00', 'y', 7, 70000, 0, 'hardware');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V92J1003', 1010, 61, 'shipped', '1992-07-26 00:00:00', '1992-08-04 00:00:00', '1992-09-15 00:00:00', 'y', 15, 2985, 0, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V93J2004', 1010, 118, 'shipped', '1993-10-30 00:00:00', '1993-12-02 00:00:00', '1993-11-15 00:00:00', 'y', 3, 210, 0, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V93J3100', 1010, 118, 'shipped', '1993-08-20 00:00:00', '1993-08-20 00:00:00', NULL, 'y', 16, 18000.4, 0.100000001490116, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V92F3004', 1012, 11, 'shipped', '1992-10-15 00:00:00', '1993-01-16 00:00:00', '1993-01-16 00:00:00', 'y', 3, 2000, 0, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V93F3088', 1012, 134, 'shipped', '1993-08-27 00:00:00', '1993-09-08 00:00:00', NULL, 'n', 10, 10000, 0, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V93F2030', 1012, 134, 'open', '1993-12-12 00:00:00', NULL, NULL, 'y', 15, 450000.49, 0, 'hardware');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V93F2051', 1012, 134, 'waiting', '1993-12-18 00:00:00', NULL, '1994-03-01 00:00:00', 'n', 1, 999.98, 0, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V93H0030', 1005, 118, 'open', '1993-12-12 00:00:00', NULL, '1994-01-01 00:00:00', 'y', 20, 5980, 0.200000002980232, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V94H0079', 1005, 61, 'open', '1994-02-13 00:00:00', NULL, '1994-04-20 00:00:00', 'n', 10, 9000, 0.0500000007450581, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V9324200', 1001, 72, 'shipped', '1993-08-09 00:00:00', '1993-08-09 00:00:00', '1993-08-17 00:00:00', 'y', 1000, 560000, 0.200000002980232, 'hardware');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V9324320', 1001, 127, 'shipped', '1993-08-16 00:00:00', '1993-08-16 00:00:00', '1993-09-01 00:00:00', 'y', 1, 0, 1, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V9320630', 1001, 127, 'open', '1993-12-12 00:00:00', NULL, '1993-12-15 00:00:00', 'n', 3, 60000, 0.200000002980232, 'hardware');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V9420099', 1001, 127, 'open', '1994-01-17 00:00:00', NULL, '1994-06-01 00:00:00', 'n', 100, 3399.15, 0.150000005960464, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V9427029', 1001, 127, 'shipped', '1994-02-07 00:00:00', '1994-02-10 00:00:00', '1994-02-10 00:00:00', 'n', 17, 422210.97, 0, 'hardware');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V9333005', 1002, 11, 'shipped', '1993-02-03 00:00:00', '1993-03-03 00:00:00', NULL, 'y', 2, 600.5, 0, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V9333006', 1002, 11, 'shipped', '1993-04-27 00:00:00', '1993-05-02 00:00:00', '1993-05-02 00:00:00', 'n', 5, 20000, 0, 'other');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V9336100', 1002, 11, 'waiting', '1993-12-27 00:00:00', '1994-01-01 00:00:00', '1994-01-01 00:00:00', 'n', 150, 14850, 0.0500000007450581, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V9346200', 1003, 11, 'waiting', '1993-12-31 00:00:00', NULL, '1994-01-24 00:00:00', 'n', 3, 0, 1, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V9345200', 1003, 11, 'shipped', '1993-11-11 00:00:00', '1993-12-02 00:00:00', '1993-12-01 00:00:00', 'y', 900, 27000, 0.300000011920929, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V9345139', 1003, 127, 'shipped', '1993-09-09 00:00:00', '1993-09-20 00:00:00', '1993-10-01 00:00:00', 'y', 20, 12582.12, 0.100000001490116, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V93C0120', 1006, 72, 'shipped', '1993-03-22 00:00:00', '1993-05-31 00:00:00', '1993-04-17 00:00:00', 'y', 1, 47.5, 0, 'other');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V93C0990', 1006, 72, 'shipped', '1993-08-09 00:00:00', '1993-09-02 00:00:00', NULL, 'y', 40, 399960.5, 0.100000001490116, 'hardware');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V9456220', 1007, 127, 'open', '1994-01-04 00:00:00', NULL, '1994-01-30 00:00:00', 'y', 1, 3999.99, 0, 'hardware');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V93S4702', 1011, 121, 'shipped', '1993-10-27 00:00:00', '1993-10-28 00:00:00', '1993-12-15 00:00:00', 'y', 4, 120000, 0, 'hardware');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V94S6400', 1011, 141, 'waiting', '1994-01-06 00:00:00', NULL, '1994-02-15 00:00:00', 'y', 20, 1980.72, 0.400000005960464, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V93H3009', 1008, 61, 'shipped', '1993-08-01 00:00:00', '1993-12-02 00:00:00', '1993-12-01 00:00:00', 'n', 3, 9000, 0.0500000007450581, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V93H0500', 1008, 61, 'open', '1993-12-12 00:00:00', NULL, '1993-12-15 00:00:00', 'n', 3, 16000, 0.200000002980232, 'hardware');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V93F0020', 1009, 61, 'shipped', '1993-10-10 00:00:00', '1993-11-11 00:00:00', '1993-11-11 00:00:00', 'n', 1, 490.69, 0, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V93I4700', 1013, 121, 'open', '1993-10-27 00:00:00', NULL, '1993-12-15 00:00:00', 'n', 5, 2693, 0, 'hardware');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V93B1002', 1014, 134, 'shipped', '1993-09-20 00:00:00', '1993-09-21 00:00:00', '1993-09-25 00:00:00', 'y', 1, 100.02, 0, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V93N5822', 1015, 134, 'shipped', '1993-12-18 00:00:00', '1994-01-14 00:00:00', NULL, 'n', 2, 1500, 0, 'software');
INSERT INTO SALES (PO_NUMBER, CUST_NO, SALES_REP, ORDER_STATUS, ORDER_DATE, SHIP_DATE, DATE_NEEDED, PAID, QTY_ORDERED, TOTAL_VALUE, DISCOUNT, ITEM_TYPE) VALUES ('V-XX-33 ', 1001, 2, 'new', '2009-11-19 16:19:05', NULL, NULL, 'n', 5, 2500, 0, 'software');

COMMIT WORK;



/******************************************************************************/
/***                           Check constraints                            ***/
/******************************************************************************/

ALTER TABLE JOB ADD CHECK (min_salary < max_salary);
ALTER TABLE EMPLOYEE ADD CHECK ( salary >= (SELECT min_salary FROM job WHERE
                        job.job_code = employee.job_code AND
                        job.job_grade = employee.job_grade AND
                        job.job_country = employee.job_country) AND
            salary <= (SELECT max_salary FROM job WHERE
                        job.job_code = employee.job_code AND
                        job.job_grade = employee.job_grade AND
                        job.job_country = employee.job_country));
ALTER TABLE SALARY_HISTORY ADD CHECK (percent_change between -50 and 50);
ALTER TABLE CUSTOMER ADD CHECK (on_hold IS NULL OR on_hold = '*');
ALTER TABLE SALES ADD CHECK (order_status in
                            ('new', 'open', 'shipped', 'waiting'));
ALTER TABLE SALES ADD CHECK (ship_date >= order_date OR ship_date IS NULL);
ALTER TABLE SALES ADD CHECK (date_needed > order_date OR date_needed IS NULL);
ALTER TABLE SALES ADD CHECK (paid in ('y', 'n'));
ALTER TABLE SALES ADD CHECK (qty_ordered >= 1);
ALTER TABLE SALES ADD CHECK (total_value >= 0);
ALTER TABLE SALES ADD CHECK (discount >= 0 AND discount <= 1);
ALTER TABLE SALES ADD CHECK (NOT (order_status = 'shipped' AND ship_date IS NULL));
ALTER TABLE SALES ADD CHECK (NOT (order_status = 'shipped' AND
            EXISTS (SELECT on_hold FROM customer
                    WHERE customer.cust_no = sales.cust_no
                    AND customer.on_hold = '*')));


/******************************************************************************/
/***                           Unique constraints                           ***/
/******************************************************************************/

ALTER TABLE DEPARTMENT ADD UNIQUE (DEPARTMENT);
ALTER TABLE PROJECT ADD UNIQUE (PROJ_NAME);


/******************************************************************************/
/***                              Primary keys                              ***/
/******************************************************************************/

ALTER TABLE BLOBFLT ADD CONSTRAINT PK_BLOBFLT PRIMARY KEY (GUID);
ALTER TABLE COUNTRY ADD PRIMARY KEY (COUNTRY);
ALTER TABLE CUSTOMER ADD PRIMARY KEY (CUST_NO);
ALTER TABLE DEPARTMENT ADD PRIMARY KEY (DEPT_NO);
ALTER TABLE EMPLOYEE ADD PRIMARY KEY (EMP_NO);
ALTER TABLE EMPLOYEE_PROJECT ADD PRIMARY KEY (EMP_NO, PROJ_ID);
ALTER TABLE FIB$APP_STATISTICS ADD CONSTRAINT PK_FIB$APP_STATISTICS PRIMARY KEY (ID);
ALTER TABLE FIB$DATASETS_INFO ADD CONSTRAINT PK_FIB$DATASETS_INFO PRIMARY KEY (DS_ID);
ALTER TABLE FIB$ERROR_MESSAGES ADD CONSTRAINT PK_FIB$ERROR_MESSAGES PRIMARY KEY (CONSTRAINT_NAME);
ALTER TABLE FIB$FIELDS_INFO ADD CONSTRAINT PK_FIB$FIELDS_INFO PRIMARY KEY (TABLE_NAME, FIELD_NAME);
ALTER TABLE JOB ADD PRIMARY KEY (JOB_CODE, JOB_GRADE, JOB_COUNTRY);
ALTER TABLE PROJECT ADD PRIMARY KEY (PROJ_ID);
ALTER TABLE PROJ_DEPT_BUDGET ADD PRIMARY KEY (PROJ_YEAR, PROJ_ID, DEPT_NO);
ALTER TABLE SALARY_HISTORY ADD PRIMARY KEY (EMP_NO, CHANGE_DATE, UPDATER_ID);
ALTER TABLE SALES ADD PRIMARY KEY (PO_NUMBER);


/******************************************************************************/
/***                              Foreign keys                              ***/
/******************************************************************************/

ALTER TABLE CUSTOMER ADD FOREIGN KEY (COUNTRY) REFERENCES COUNTRY (COUNTRY);
ALTER TABLE DEPARTMENT ADD FOREIGN KEY (HEAD_DEPT) REFERENCES DEPARTMENT (DEPT_NO);
ALTER TABLE DEPARTMENT ADD FOREIGN KEY (MNGR_NO) REFERENCES EMPLOYEE (EMP_NO);
ALTER TABLE EMPLOYEE ADD FOREIGN KEY (DEPT_NO) REFERENCES DEPARTMENT (DEPT_NO);
ALTER TABLE EMPLOYEE ADD FOREIGN KEY (JOB_CODE, JOB_GRADE, JOB_COUNTRY) REFERENCES JOB (JOB_CODE, JOB_GRADE, JOB_COUNTRY);
ALTER TABLE EMPLOYEE_PROJECT ADD FOREIGN KEY (EMP_NO) REFERENCES EMPLOYEE (EMP_NO);
ALTER TABLE EMPLOYEE_PROJECT ADD FOREIGN KEY (PROJ_ID) REFERENCES PROJECT (PROJ_ID);
ALTER TABLE JOB ADD FOREIGN KEY (JOB_COUNTRY) REFERENCES COUNTRY (COUNTRY);
ALTER TABLE PROJECT ADD FOREIGN KEY (TEAM_LEADER) REFERENCES EMPLOYEE (EMP_NO);
ALTER TABLE PROJ_DEPT_BUDGET ADD FOREIGN KEY (DEPT_NO) REFERENCES DEPARTMENT (DEPT_NO);
ALTER TABLE PROJ_DEPT_BUDGET ADD FOREIGN KEY (PROJ_ID) REFERENCES PROJECT (PROJ_ID);
ALTER TABLE SALARY_HISTORY ADD FOREIGN KEY (EMP_NO) REFERENCES EMPLOYEE (EMP_NO);
ALTER TABLE SALES ADD FOREIGN KEY (CUST_NO) REFERENCES CUSTOMER (CUST_NO);
ALTER TABLE SALES ADD FOREIGN KEY (SALES_REP) REFERENCES EMPLOYEE (EMP_NO);


/******************************************************************************/
/***                                Indices                                 ***/
/******************************************************************************/

CREATE INDEX IDX_BIGTABLE_NAME ON BIGTABLE (NAME);
CREATE DESCENDING INDEX IDX_BIGTABLE_NAME_DESC ON BIGTABLE (NAME);
CREATE DESCENDING INDEX IDX_BIGTABLE_VER_DESC ON BIGTABLE (LAST_UPDATE);
CREATE INDEX IDX_VER_ASC ON BIGTABLE (LAST_UPDATE);
CREATE INDEX IDX_BIGTABLE_DETAIL_BIGTABLE_ID ON BIGTABLE_DETAIL (BIGTABLE_ID);
CREATE INDEX CUSTNAMEX ON CUSTOMER (CUSTOMER);
CREATE INDEX CUSTREGION ON CUSTOMER (COUNTRY, CITY);
CREATE DESCENDING INDEX BUDGETX ON DEPARTMENT (BUDGET);
CREATE INDEX NAMEX ON EMPLOYEE (LAST_NAME, FIRST_NAME);
CREATE DESCENDING INDEX MAXSALX ON JOB (JOB_COUNTRY, MAX_SALARY);
CREATE INDEX MINSALX ON JOB (JOB_COUNTRY, MIN_SALARY);
CREATE UNIQUE INDEX PRODTYPEX ON PROJECT (PRODUCT, PROJ_NAME);
CREATE DESCENDING INDEX CHANGEX ON SALARY_HISTORY (CHANGE_DATE);
CREATE INDEX UPDATERX ON SALARY_HISTORY (UPDATER_ID);
CREATE INDEX NEEDX ON SALES (DATE_NEEDED);
CREATE DESCENDING INDEX QTYX ON SALES (ITEM_TYPE, QTY_ORDERED);
CREATE INDEX SALESTATX ON SALES (ORDER_STATUS, PAID);


/******************************************************************************/
/***                                Triggers                                ***/
/******************************************************************************/



SET TERM ^ ;



/******************************************************************************/
/***                          Triggers for tables                           ***/
/******************************************************************************/



/* Trigger: AI_DEPARTMENT_DEPT_NO1 */
CREATE TRIGGER AI_DEPARTMENT_DEPT_NO1 FOR DEPARTMENT
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  IF (NEW.DEPT_NO1 IS NULL) THEN
      NEW.DEPT_NO1 = GEN_ID(DEPT_NO_GEN, 1);
END
^

/* Trigger: BI_FIB$ERROR_MESSAGES */
CREATE TRIGGER BI_FIB$ERROR_MESSAGES FOR FIB$ERROR_MESSAGES
ACTIVE BEFORE INSERT POSITION 0
AS
begin
new.fib$version=gen_id(fib$field_info_version,1);
 end
^

/* Trigger: BU_FIB$ERROR_MESSAGES */
CREATE TRIGGER BU_FIB$ERROR_MESSAGES FOR FIB$ERROR_MESSAGES
ACTIVE BEFORE UPDATE POSITION 0
AS
begin
new.fib$version=gen_id(fib$field_info_version,1);
 end
^

/* Trigger: FIB$APP_STATISTICS_BI */
CREATE TRIGGER FIB$APP_STATISTICS_BI FOR FIB$APP_STATISTICS
ACTIVE BEFORE INSERT POSITION 0
AS BEGIN
IF (NEW.ID IS NULL) THEN
NEW.ID = GEN_ID(FIB$APP_STATISTICS_GEN_ID,1);
NEW.log_date ='NOW';
END
^

/* Trigger: FIB$DATASETS_INFO_BI */
CREATE TRIGGER FIB$DATASETS_INFO_BI FOR FIB$DATASETS_INFO
ACTIVE BEFORE INSERT POSITION 0
as
begin
new.fib$version=gen_id(fib$field_info_version,1);
end
^

/* Trigger: FIB$DATASETS_INFO_BU */
CREATE TRIGGER FIB$DATASETS_INFO_BU FOR FIB$DATASETS_INFO
ACTIVE BEFORE UPDATE POSITION 0
as
begin
new.fib$version=gen_id(fib$field_info_version,1);
end
^

/* Trigger: FIB$FIELDS_INFO_BI */
CREATE TRIGGER FIB$FIELDS_INFO_BI FOR FIB$FIELDS_INFO
ACTIVE BEFORE INSERT POSITION 0
as
begin
new.fib$version=gen_id(fib$field_info_version,1);
end
^

/* Trigger: FIB$FIELDS_INFO_BU */
CREATE TRIGGER FIB$FIELDS_INFO_BU FOR FIB$FIELDS_INFO
ACTIVE BEFORE UPDATE POSITION 0
as
begin
new.fib$version=gen_id(fib$field_info_version,1);
end
^

/* Trigger: POST_NEW_ORDER */
CREATE TRIGGER POST_NEW_ORDER FOR SALES
ACTIVE AFTER INSERT POSITION 0
AS
BEGIN
    POST_EVENT "new_order";
END
^

/* Trigger: SAVE_SALARY_CHANGE */
CREATE TRIGGER SAVE_SALARY_CHANGE FOR EMPLOYEE
ACTIVE AFTER UPDATE POSITION 0
AS
BEGIN
    IF (old.salary <> new.salary) THEN
        INSERT INTO salary_history
            (emp_no, change_date, updater_id, old_salary, percent_change)
        VALUES (
            old.emp_no,
            'now',
            user,
            old.salary,
            (new.salary - old.salary) * 100 / old.salary);
END
^

/* Trigger: SET_CUST_NO */
CREATE TRIGGER SET_CUST_NO FOR CUSTOMER
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
    new.cust_no = gen_id(cust_no_gen, 1);
END
^

/* Trigger: SET_EMP_NO */
CREATE TRIGGER SET_EMP_NO FOR EMPLOYEE
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
    new.emp_no = gen_id(emp_no_gen, 1);
END
^
SET TERM ; ^



/******************************************************************************/
/***                           Stored procedures                            ***/
/******************************************************************************/



SET TERM ^ ;

ALTER PROCEDURE ADD_EMP_PROJ (
    EMP_NO SMALLINT,
    PROJ_ID CHAR(5))
AS
BEGIN
 BEGIN
 INSERT INTO employee_project (emp_no, proj_id) VALUES (:emp_no, :proj_id);
 WHEN SQLCODE -530 DO
  EXCEPTION unknown_emp_id;
 END
 SUSPEND;
END^


ALTER PROCEDURE ALL_LANGS
RETURNS (
    CODE VARCHAR(5),
    GRADE VARCHAR(5),
    COUNTRY VARCHAR(15),
    LANG VARCHAR(15))
AS
    BEGIN
 FOR SELECT job_code, job_grade, job_country FROM job 
  INTO :code, :grade, :country

 DO
 BEGIN
     FOR SELECT languages FROM show_langs 
       (:code, :grade, :country) INTO :lang DO
         SUSPEND;
     /* Put nice separators between rows */
     code = "=====";
     grade = "=====";
     country = "===============";
     lang = "==============";
     SUSPEND;
 END
    END^


ALTER PROCEDURE DELETE_EMPLOYEE (
    EMP_NUM INTEGER)
AS
 DECLARE VARIABLE any_sales INTEGER;
BEGIN
 any_sales = 0;

 /*
  * If there are any sales records referencing this employee,
  * can't delete the employee until the sales are re-assigned
  * to another employee or changed to NULL.
  */
 SELECT count(po_number)
 FROM sales
 WHERE sales_rep = :emp_num
 INTO :any_sales;

 IF (any_sales > 0) THEN
 BEGIN
  EXCEPTION reassign_sales;
  SUSPEND;
 END

 /*
  * If the employee is a manager, update the department.
  */
 UPDATE department
 SET mngr_no = NULL
 WHERE mngr_no = :emp_num;

 /*
  * If the employee is a project leader, update project.
  */
 UPDATE project
 SET team_leader = NULL
 WHERE team_leader = :emp_num;

 /*
  * Delete the employee from any projects.
  */
 DELETE FROM employee_project
 WHERE emp_no = :emp_num;

 /*
  * Delete old salary records.
  */
 DELETE FROM salary_history
 WHERE emp_no = :emp_num;

 /*
  * Delete the employee.
  */
 DELETE FROM employee
 WHERE emp_no = :emp_num;

 SUSPEND;
END^


ALTER PROCEDURE DEPT_BUDGET (
    DNO CHAR(3))
RETURNS (
    TOT NUMERIC(15,2))
AS
 DECLARE VARIABLE sumb DECIMAL(12, 2);
 DECLARE VARIABLE rdno CHAR(3);
 DECLARE VARIABLE cnt INTEGER;
BEGIN
 tot = 0;

 SELECT budget FROM department WHERE dept_no = :dno INTO :tot;

 SELECT count(budget) FROM department WHERE head_dept = :dno INTO :cnt;

 IF (cnt = 0) THEN
  SUSPEND;

 FOR SELECT dept_no
  FROM department
  WHERE head_dept = :dno
  INTO :rdno
 DO
  BEGIN
   EXECUTE PROCEDURE dept_budget :rdno RETURNING_VALUES :sumb;
   tot = tot + sumb;
  END

 SUSPEND;
END^


ALTER PROCEDURE GEN_BIGTABLE_CONTENT (
    CNT INTEGER)
RETURNS (
    PROGRESS INTEGER)
AS
 DECLARE VARIABLE STR VARCHAR(20);
 DECLARE VARIABLE RES VARCHAR(84);
BEGIN
  DELETE FROM BIGTABLE;
  DELETE FROM BIGTABLE_DETAIL;

  PROGRESS = 1;
  WHILE (PROGRESS <= CNT) DO
  BEGIN
  /*STR = LPAD(CAST(I AS VARCHAR(10)), 8, '0');*/
    STR = CAST(PROGRESS AS VARCHAR(10));
    STR = 'ITEM #' || STR;
    RES = STR ||'__'|| STR;

    INSERT INTO BIGTABLE (ID, NAME)
    VALUES(:PROGRESS, :RES);

    /*    INSERT INTO BIGTABLE_DETAIL (ID, INT_VALUE, BIGTABLE_ID)
    VALUES ((:I-1) * 2 , :I, :I);

    INSERT INTO BIGTABLE_DETAIL (ID, INT_VALUE, BIGTABLE_ID)
    VALUES ((:I-1) * 2 + 1 , :I, :I + 2);
    */
    PROGRESS = PROGRESS + 1;
    SUSPEND;
  END
END^


ALTER PROCEDURE GET_EMP_PROJ (
    EMP_NO SMALLINT)
RETURNS (
    PROJ_ID CHAR(5))
AS
BEGIN
 FOR SELECT proj_id
  FROM employee_project
  WHERE emp_no = :emp_no
  INTO :proj_id
 DO
  SUSPEND;
END^


ALTER PROCEDURE MAIL_LABEL (
    CUST_NO INTEGER)
RETURNS (
    LINE1 CHAR(40),
    LINE2 CHAR(40),
    LINE3 CHAR(40),
    LINE4 CHAR(40),
    LINE5 CHAR(40),
    LINE6 CHAR(40))
AS
 DECLARE VARIABLE customer VARCHAR(25);
 DECLARE VARIABLE first  VARCHAR(15);
 DECLARE VARIABLE last  VARCHAR(20);
 DECLARE VARIABLE addr1  VARCHAR(30);
 DECLARE VARIABLE addr2  VARCHAR(30);
 DECLARE VARIABLE city  VARCHAR(25);
 DECLARE VARIABLE state  VARCHAR(15);
 DECLARE VARIABLE country VARCHAR(15);
 DECLARE VARIABLE postcode VARCHAR(12);
 DECLARE VARIABLE cnt  INTEGER;
BEGIN
 line1 = "";
 line2 = "";
 line3 = "";
 line4 = "";
 line5 = "";
 line6 = "";

 SELECT customer, contact_first, contact_last, address_line1,
  address_line2, city, state_province, country, postal_code
 FROM CUSTOMER
 WHERE cust_no = :cust_no
 INTO :customer, :first, :last, :addr1, :addr2,
  :city, :state, :country, :postcode;

 IF (customer IS NOT NULL) THEN
  line1 = customer;
 IF (first IS NOT NULL) THEN
  line2 = first || " " || last;
 ELSE
  line2 = last;
 IF (addr1 IS NOT NULL) THEN
  line3 = addr1;
 IF (addr2 IS NOT NULL) THEN
  line4 = addr2;

 IF (country = "USA") THEN
 BEGIN
  IF (city IS NOT NULL) THEN
   line5 = city || ", " || state || "  " || postcode;
  ELSE
   line5 = state || "  " || postcode;
 END
 ELSE
 BEGIN
  IF (city IS NOT NULL) THEN
   line5 = city || ", " || state;
  ELSE
   line5 = state;
  line6 = country || "    " || postcode;
 END

 SUSPEND;
END^


ALTER PROCEDURE ORG_CHART
RETURNS (
    HEAD_DEPT CHAR(25),
    DEPARTMENT CHAR(25),
    MNGR_NAME CHAR(20),
    TITLE CHAR(5),
    EMP_CNT INTEGER)
AS
 DECLARE VARIABLE mngr_no INTEGER;
 DECLARE VARIABLE dno CHAR(3);
BEGIN
 FOR SELECT h.department, d.department, d.mngr_no, d.dept_no
  FROM department d
  LEFT OUTER JOIN department h ON d.head_dept = h.dept_no
  ORDER BY d.dept_no
  INTO :head_dept, :department, :mngr_no, :dno
 DO
 BEGIN
  IF (:mngr_no IS NULL) THEN
  BEGIN
   mngr_name = "--TBH--";
   title = "";
  END

  ELSE
   SELECT full_name, job_code
   FROM employee
   WHERE emp_no = :mngr_no
   INTO :mngr_name, :title;

  SELECT COUNT(emp_no)
  FROM employee
  WHERE dept_no = :dno
  INTO :emp_cnt;

  SUSPEND;
 END
END^


ALTER PROCEDURE SHIP_ORDER (
    PO_NUM CHAR(8))
AS
 DECLARE VARIABLE ord_stat CHAR(7);
 DECLARE VARIABLE hold_stat CHAR(1);
 DECLARE VARIABLE cust_no INTEGER;
 DECLARE VARIABLE any_po CHAR(8);
BEGIN
 SELECT s.order_status, c.on_hold, c.cust_no
 FROM sales s, customer c
 WHERE po_number = :po_num
 AND s.cust_no = c.cust_no
 INTO :ord_stat, :hold_stat, :cust_no;

 /* This purchase order has been already shipped. */
 IF (ord_stat = "shipped") THEN
 BEGIN
  EXCEPTION order_already_shipped;
  SUSPEND;
 END

 /* Customer is on hold. */
 ELSE IF (hold_stat = "*") THEN
 BEGIN
  EXCEPTION customer_on_hold;
  SUSPEND;
 END

 /*
  * If there is an unpaid balance on orders shipped over 2 months ago,
  * put the customer on hold.
  */
 FOR SELECT po_number
  FROM sales
  WHERE cust_no = :cust_no
  AND order_status = "shipped"
  AND paid = "n"
  AND ship_date < 'NOW' - 60
  INTO :any_po
 DO
 BEGIN
  EXCEPTION customer_check;

  UPDATE customer
  SET on_hold = "*"
  WHERE cust_no = :cust_no;

  SUSPEND;
 END

 /*
  * Ship the order.
  */
 UPDATE sales
 SET order_status = "shipped", ship_date = 'NOW'
 WHERE po_number = :po_num;

 SUSPEND;
END^


ALTER PROCEDURE SHOW_LANGS (
    CODE VARCHAR(5),
    GRADE SMALLINT,
    CTY VARCHAR(15))
RETURNS (
    LANGUAGES VARCHAR(15))
AS
DECLARE VARIABLE i INTEGER;
BEGIN
  i = 1;
  WHILE (i <= 5) DO
  BEGIN
    SELECT language_req[:i] FROM joB
    WHERE ((job_code = :code) AND (job_grade = :grade) AND (job_country = :cty)
           AND (language_req IS NOT NULL))
    INTO :languages;
    IF (languages = " ") THEN  /* Prints "NULL" instead of blanks */
       languages = "NULL";         
    i = i +1;
    SUSPEND;
  END
END^


ALTER PROCEDURE SUB_TOT_BUDGET (
    HEAD_DEPT CHAR(3))
RETURNS (
    TOT_BUDGET NUMERIC(15,2),
    AVG_BUDGET NUMERIC(15,2),
    MIN_BUDGET NUMERIC(15,2),
    MAX_BUDGET NUMERIC(15,2))
AS
BEGIN
 SELECT SUM(budget), AVG(budget), MIN(budget), MAX(budget)
  FROM department
  WHERE head_dept = :head_dept
  INTO :tot_budget, :avg_budget, :min_budget, :max_budget;
 SUSPEND;
END^



SET TERM ; ^

