import { Toaster as Sonner } from "sonner";
import {toast as Toast} from "sonner";
import { useXbeshProviderCheck } from "../../../..";

type ToasterProps = React.ComponentProps<typeof Sonner>;

const SonnerStack = ({ ...props }: ToasterProps) => {
  const isBrowser = typeof window !== "undefined";
  if (!isBrowser) return null;
  useXbeshProviderCheck();
  return (
    <Sonner
      className="toaster group"
      toastOptions={{
        classNames: {
          toast:
            "group toast group-[.toaster]:bg-background group-[.toaster]:text-foreground group-[.toaster]:border-border group-[.toaster]:shadow-lg",
          description: "group-[.toast]:text-muted-foreground",
          actionButton:
            "group-[.toast]:bg-primary group-[.toast]:text-primary-foreground",
          cancelButton:
            "group-[.toast]:bg-muted group-[.toast]:text-muted-foreground",
        },
      }}
      {...props}
    />
  );
};
SonnerStack.displayName = "SonnerStack";
export { SonnerStack, Toast };
