# build-generative-ai-apps-with-langchain

"Build Generative AI Apps with LangChain" is a repository that contains a comprehensive framework for building generative AI applications using LangChain, an innovative language modeling platform. This repository includes all the necessary code and documentation to help developers quickly build and deploy generative AI applications

### Installation
      pip -q install openai langchain huggingface_hub
      pip install --upgrade openai 
      
  create cadentials.yaml which has below template
            
      OPENAI_API_KEY: <<OPENAI_API_KEY>>
      HUGGINGFACEHUB_API_TOKEN: <<HUGGINGFACEHUB_API_TOKEN>>

### LangChain Notebooks
- Basic LLM Prompting with Langchain [Notebook](https://github.com/1zuu/build-generative-ai-apps-with-langchain/blob/main/LLM-Prompting-Basics.ipynb)

- Build First Sequential Chain with Langchain [Notebook](https://github.com/1zuu/build-generative-ai-apps-with-langchain/blob/main/The-First-Sequential-Chain.ipynb)

- ChatGPT meets LangChain , The Brothers of Destruction 🔥[Notebook](https://github.com/1zuu/build-generative-ai-apps-with-langchain/blob/main/ChatGPT🤝LangChain🔥.ipynb)

- Maintain Conversations with Memory 🔥[Notebook](https://github.com/1zuu/build-generative-ai-apps-with-langchain/blob/main/Conversations-with-Memory.ipynb)

- HuggingFaceHub IN🔥 OpenAI OUT[Notebook](https://github.com/1zuu/build-generative-ai-apps-with-langchain/blob/main/Chat-with-Flang20B-LangChain-HuggingFace.ipynb)

- HuggingFaceHub🤝LangChain Work Local[Notebook](https://github.com/1zuu/build-generative-ai-apps-with-langchain/blob/main/HuggingFaceHub🤝LangChain-Work-Local.ipynb)

- PAL : The Chain of Thought Modeling[Notebook](https://github.com/1zuu/build-generative-ai-apps-with-langchain/blob/main/PAL-Chain-of-Thought-Modeling.ipynb)