<?php

/**
 * StealingApples
 *
 * @author   Pu ShaoWei <marco0727@gamil.com>
 * @date     2017/8/26
 * @license  MIT
 * -------------------------------------------------------------
 * 思路分析：
 * -------------------------------------------------------------
 * 有5个人偷了一堆苹果，准备在第二天分赃。
 * 晚上，有一人遛出来，把所有苹果分成5份，但是多了一个，顺手把这个扔给树上的猴了，自己先拿1/5藏了。
 * 没想到其他四人也都是这么想的，都如第一个人一样分成5份把多的那一个扔给了猴，偷走了1/5。
 * 第二天，大家分赃，也是分成5份多一个扔给猴了。最后一人分了一份。
 * 问：共有多少苹果？N 个人呢？
 * -------------------------------------------------------------
 */

// +--------------------------------------------------------------------------
// | 解题方式    | 这儿，可能有用的解决方案
// +--------------------------------------------------------------------------

$i = 1;
while (true) {
    if ($i % 5 == 1) {
        //第一个人取五分之一，还剩$t
        $t = $i - round($i / 5) - 1;
        if ($t % 5 == 1) {
            //第二个人取五分之一，还剩$r
            $r = $t - round($t / 5) - 1;
            if ($r % 5 == 1) {
                //第三个人取五分之一，还剩$s
                $s = $r - round($r / 5) - 1;
                if ($s % 5 == 1) {
                    //第四个人取五分之一，还剩$x
                    $x = $s - round($s / 5) - 1;
                    if ($x % 5 == 1) {
                        //第五个人取五分之一，还剩$y
                        $y = $x - round($x / 5) - 1;
                        if ($y % 5 == 1) {
                            echo $i;
                            break;
                        }
                    }
                }
            }
        }
    }
    $i++;
}

// +----------------------------------------------------------------------
// |                        方法二
// +----------------------------------------------------------------------
/**
 * @author    Openset <openset.wang@gmail.com>
 * @link      https://github.com/openset
 * @date      2017/9/7
 * @param int $n N个人
 * @param int $r 共有多少苹果
 */
for ($r = 1, $n = 5; ; $r++) {
    $t = $r;
    for ($i = 0; $i <= $n; $i++) {
        if ($t % $n == 1) {
            $t = $t - round($t / $n) - 1;
        } else {
            continue 2;
        }
    }
    echo $r;
    break;
}

//15621

// +--------------------------------------------------------------------------
// | 方案测试    | php `this.php` || PHPStorm -> 右键 -> Run `this.php`
// +--------------------------------------------------------------------------

