#pragma mark - Depend ESP8266Audio and ESP8266_Spiram libraries
/*
cd ~/Arduino/libraries
git clone https://github.com/earlephilhower/ESP8266Audio
git clone https://github.com/Gianbacchio/ESP8266_Spiram

Use the "Tools->ESP32 Sketch Data Upload" menu to write the MP3 to SPIFFS
Then upload the sketch normally.
https://github.com/me-no-dev/arduino-esp32fs-plugin
*/

#include <M5Stack.h>
#include <WiFi.h>

#include "AudioFileSourceID3.h"
#include "AudioFileSourceSPIFFS.h"
#include "AudioGeneratorMP3.h"
#include "AudioOutputI2S.h"
#include "SPIFFS.h"

AudioGeneratorMP3 *mp3;
AudioFileSourceSPIFFS *file;
AudioOutputI2S *out;
AudioFileSourceID3 *id3;

void setup() {
    M5.begin();
    M5.Power.begin();
    WiFi.mode(WIFI_OFF);
    SPIFFS.begin();
    delay(500);

    M5.Lcd.setTextFont(2);
    M5.Lcd.printf("Sample MP3 playback begins...\n");
    Serial.printf("Sample MP3 playback begins...\n");

    // pno_cs from https://ccrma.stanford.edu/~jos/pasp/Sound_Examples.html
    file = new AudioFileSourceSPIFFS("/pno-cs.mp3");
    id3  = new AudioFileSourceID3(file);
    out  = new AudioOutputI2S(0, 1);  // Output to builtInDAC
    out->SetOutputModeMono(true);
    mp3 = new AudioGeneratorMP3();
    mp3->begin(id3, out);
}

void loop() {
    if (mp3->isRunning()) {
        if (!mp3->loop()) mp3->stop();
    } else {
        Serial.printf("MP3 done\n");
        delay(1000);
    }
}
