# Breakout board for Ebyte E78 (ASR6501 or ASR6601) module

![](https://github.com/lyusupov/Ebyte-E78-breakout-PCB/blob/master/images/SoftRF-E78-pcb-1.jpg)

# Schematics

![](https://github.com/lyusupov/Ebyte-E78-breakout-PCB/blob/master/images/SoftRF-E78-pcb-4.jpg)

# Layout

![](https://github.com/lyusupov/Ebyte-E78-breakout-PCB/blob/master/images/SoftRF-E78-pcb-2.jpg)

![](https://github.com/lyusupov/Ebyte-E78-breakout-PCB/blob/master/images/SoftRF-E78-pcb-3.jpg)

<br>

**ATTENTION**: Silkscreen labels on PCB are applicable for ASR6**5**01 _(PSoC4 - ARM Cortex-M0+ core)_ version of the E78 only.<br>
These labels may or may not match to the ASR6**6**01 _(ARM Cortex-M4F core)_ version of the module.

# PCB manufacturing

You can order the PCB direct from manufacturer: <!-- <sup>1</sup> -->

&nbsp;&nbsp;&nbsp;&nbsp; <a href="https://pcbs.io/share/4Be2g"><img src="https://s3.amazonaws.com/pcbs.io/share.png" alt="Order from PCBs.io"></img></a><br>

Estimated price for minimum 4 pcs of the PCB with basic international shipping included in is around 4 USD.<br>

Expect to wait:
- 1 week for panelization
- 2 weeks for fabrication 
- 1-2 weeks for delivery to your location

Alternatively you may pick [these Gerber files](https://github.com/lyusupov/Ebyte-E78-breakout-PCB/raw/master/gerber/SoftRF-E78-breakout.zip) and order the PCB from a local manufacturer of your preference.

<!--
<sup>1</sup> - SSL Cert error warning may come up - it is known to be safely ignored<br>
-->
<br>

<!--
![](https://github.com/lyusupov/SoftRF/raw/master/documents/images/ESP32-NODEMCU-ADAPTER-PCB.JPG)
-->

# Bill of materials

Number|Part|Qty|Picture|Source
---|---|---|---|---
1|PCB|1|![](https://s3.amazonaws.com/pcbsio/svgs/acd266beceb42dce520aaae332e4949056265371ca9e6ebcc58d4baeb6bc7b27/top.svg.s.png)|<a href="https://PCBs.io/share/4Be2g"><img src="https://s3.amazonaws.com/pcbs.io/share.png" alt="Order from PCBs.io"></img></a>
2|1x40 male header 2.54mm|1|![](https://github.com/lyusupov/SoftRF/blob/master/documents/images/bom/m40.jpg)|[AliExpress](https://www.aliexpress.com/item/10pcs-40-Pin-1x40-Single-Row-Male-2-54-Breakable-Pin-Header-Connector-Strip-for-Arduino/32806313091.html)
3|Female SMA-KHD|1|![](https://github.com/lyusupov/SoftRF/raw/master/documents/images/bom/sma-khd.jpg)|[AliExpress](https://www.aliexpress.com/item/10-Pcs-SMA-Female-Jack-Solder-Edge-1-6mm-Space-PCB-Mount-Straight-RF-Connector-New/32842094243.html) <!-- (https://www.aliexpress.com/item/Free-Shipping-10pcs-SMA-KE-Jack-Female-Connector-To-Edge-Mount-PCB-Board-Receptacle-Adaptor/1432181391.html) -->

# Use cases

The adapter is known to be good enough for prototyping with just single module on a breadboard

![](https://user-images.githubusercontent.com/5849637/164167850-12099496-d6ea-43e4-806b-b43191270118.png)

<br>

and with multiple modules as well

<br>

![](https://github.com/lyusupov/SoftRF/blob/master/documents/images/Octave-1.jpg)

