# 霞鹜臻楷 v0.700 版本更新（2024.10.18）

## 概述

- 本字体一度于 2022 年 6 月放弃更新，后来想到还有很多喜爱这款字体的用户对这款字体的停更表示可惜，经过反复考虑，决定正式恢复更新维护，但是后续版本的汉字字形均由 AI 生成。
- 利用 zi2zi，以「霞鹜臻楷」v0.600 包含的手调字形为目标字形，从「霞鹜文楷」生成了更多字形（详见下方「新增汉字」），并重新生成了原有手调字形。目前本字体共收录了 13 170 个汉字。
- 新增「霞鹜臻楷 GB」，采用中国大陆规范字形，符合楷体书写习惯，其字形同样由 zi2zi 生成。
- 由于 zi2zi 生成的是位图而非矢量图，直接导入到字体文件后轮廓曲线质量会下降（如会出现锯齿、坑洼等），因而将字形字形位图转换成了 SVG 矢量图，并使用 [SVG2FontBuilder](https://github.com/NightFurySL2001/SVG2FontBuilder) 构建成汉字字体，生成的字体曲线轮廓会有所提升。不过，转换成矢量图后锚点较多，字体文件体积会增大。
- 根据 [Unicode 16.0 相关文档](https://www.unicode.org/Public/16.0.0/ucd/StandardizedVariants.txt)，新增 Unicode 变体序列（UVS）支持，在允许使用 UVS 的情况下，可通过该功能实现标点符号的切换，详情[点击此处了解](..\uvs.pdf)。

## 汉字部分

### 新增汉字

#### 1. GB/T 2312 剩余汉字

鼗赜籴黉馘衮脔裒蠃诓诔诜诮诳诹诼谂谇谖谘谝谠谡谥谫谮谯谳谵阢阽阼陔陧陬陴隈邙邴邶郏邾郐郄郇郛郫郾鄣鄹酃酆畚巯鼙芊芎芰苈苊芘苌苁芴芟芤苡苤茇苴茑茚茆苠荑荛荜茈茼莛荇茺茳荦荨茛荩荬荭荮莰莳莪莜莶莩荽莸莨莼萁菥菘菝萜萑萆菔菟萏菸菹菪菀菰菡葜葑葚葙蒇蒈蒉葸葶蒌蒎葭蓁蓍蓐蒽蒺蓠蒹蒴蒗蓣蔌甍蔸蓰蔹蔟蕖蓼蕈蕞蕺瞢蕻薤薨薏蕹薮薜薅薷藿蘧蘅蘩蘼抟拊拚挢挹捃掭捱掎掊捩掼揲揸揠揞揎掾摅搋搛搠搌搦撄摭撖摺撙撺擐擗擤攉弑辔帙帔帱帻幞嵛嵝嵫嵴嶝豳嶷後徭徵徼狎狒狨狯狲狴狷猁狳猃狻猓猊猞猢猸猱獍獬獯獾飧饧饬馀馇馑馓馔庹庳廒廑廛廨廪怃忪怍怫怊恂悝悃悒悛惝愠愦愀愎慊憷懔隳闱闳闶闼阃阄阊阋阌阍阏阒阗泐沲泖泫洧洌洫洚洳涑涠浠浼淠渖涫渌渫湫溲溆湓湔溱滠漭溽溻溷滗滏溏潆漤漶潋潴澉澌潲澶濞瀹瀵甯搴褰迓迕迮迳迨逋逦逑逡逭逯遄遘彖羼艴鬻胬驵驺驽骀骈骒骓骖骘骟骠骢骣绁绋绗绠绨绲缍绺绻绾缁缂缇缋缌缏缑缒缗缛缟缡缢缣缦缧缯缱缲缳缵玳顼琊珧瑁瑗瑷瑭璎璁璩瓒璺韪杌枘枧枞枋栊栌柙柝柃柢柁柽栲栳桠桡桄桤梃栝桕桀桊桴桷桫楮棼椠棹椤棰椋楗椐楱椹榘楸椴榇楦榧槔榱槁槊槠榍樯槭樗樘橥槲樾檠橐橛檎橼檑檗檫殛殪轫轭轳轵轸轷轹轺轾辁辂辇辋辎辏辚軎戢戡戥戤瓿甏甑甓曷晡晷暌暝暾曛曩贳贶贽赀赆赇赍赕赙觋觌觏牮牾牿犋犍犏挈挲搿毪毳毵毹氅氇氆氍氙敕敫牖爰虢肟肼朊肱肫肭肷胨胩胪胛胂胙胍胗胝胴脎胲胼脒脶脞脬脘脲腙腠腩腽腭腧膂膣膪臌膻臁膦欷欹歃飑飚彀觳齑旒烀炱焐焓煳煨煸煺熘熳熵燠燔燹爝戽扃祓祢祗祧禊禚禳恝恚恧悫愆愍慝憝戆泶砉砗砘砑砜砹砟砩硎硭硖硗砦硐硇硪碛碚碇碡碹碥磔磙磉磲礅磴礓礤礞黹黻黼眚眢眭眦眵睇睃睚睨睥瞍瞀瞵瞽畎畋畛詈罨罴罱罾蠲钆钇钋钌钍钏钐钔钫钪钭钬钯钲钶钷钸钽钿铈铊铍铑铒铕铖铗铙铘铞铟铥铪铩铫铯铳铴铷铹铼铽锇锊锍锎锓锔锕锖锘锛锝锞锪锫锩锬锱锸锼锾锿镄镅镆镎镏镔镘镙镞镟镡镤镥镦镧镨镩镪镫镬镱镲锺矧稆稃稂稹穑穰皤瓞瓠鸨鸫鸬鸲鸱鸶鸸鸷鸹鸺鹁鹆鹇鹈鹋鹎鹕鹚鹛鹞鹣鹨鹩鹪鹬鹱疠疬疣疳痄疰痃痖痨痦痤痧瘃瘐瘅瘌瘗瘊瘥瘕瘙瘛瘼瘢癀瘭瘰瘿瘵癃瘳癍癔竦穸窀窆窬窨窭窳衲衽衿袢袷袼裉裢裎裣裥裼裾裰褡褙褊褫襦襻皲皴耔耖耜耠耢耥耧耩耨耱聃聍聒顸颀颃颏颚颛颞颟颡颢颥虮虿虺虼虻蚨蚍蚋蚩蛄蚵蚰蚺蛏蚴蛩蛱蛲蛞蛴蛘蛑蛸蜊蜣蜞蜮蜾蜱蜩蝽蝾蝻蝰蝮螋蝓蝼蝤蝥螓螈螅螭螗螫蟥螬螵蟓螽蟊蟛蟪蟮蠖蠓蠊蠛蠼罅笄笕笊笫笏筇笸笪笮笱笥笾笞筘筚筅筌筮筻筢筲箦箧箸箬箝箨箅箪箜箢篁篌篚篥篪篼簏簖簋簟簦籀舂舄臬衄舡舣舭舯舨舻舳舴舾艄艉艋艏艚艟艨衾袈裟襞羝羧羰粝粜粞粢糁糇糌糍糈糗糨翕翥翦翮翳絷綮繇纛麴趑趱赧酎酏酤酢酡酽酾酲酴酹醌醅醐醍醑醢醣醪醭醮醯醵醺鹾跫踅蹙蹩趵趿趼趺跖跗跞跏跬跸跣跽踔踬踣踺蹀蹁蹯躔躐躜躞貊貅貘貔斛觖觚觜觥觫觯謦雩霈霪霰龀龅龆鼋鼍雎雒雠銎鋈錾鍪鏊鐾鲂鲆鲋鲎鲐鲒鲔鲕鲚鲛鲞鲠鲡鲣鲥鲦鲧鲩鲭鲮鲰鲱鲴鲵鲶鲺鲼鲽鳆鳇鳊鳋鳎鳐鳓鳔鳕鳘鳙鳢鞅鞒鞔鞯鞫鞲鞴骱骰鹘骶骺髁髀髂髌髑魃魉魈魍魑餍餮饕饔髡髫髻髭髹鬈鬏鬟鬣麽縻麇麈黢黩黧黥黪鼢鼬鼯鼷鼽齄

#### 2. 《通用规范汉字表》《现代汉语通用字表》所收字

芼牤玭茀杻𬉼祇挦柈𠳐眊郤疭竑闿羑恓牁珰珣琤栟眬鸮盉訚烜牂骎琇捯捽棻梿棁秾鸻馃阇焗郿琫琯揳靰靸椪雱睄嵖嵎铻鲀颎焜湜湲湉愔祾翚瑄蒟楯跶跐锜鹐瘆滫滃滪窣璈摽榖靺靿豨箓魆粿熥鋆瞋颙踒𥻗熜潟褟璟璠璘縠螠镚镠膙獴澥窸璪鞡鞬罽鳀鞨鞧藠蹚鹮霨蹽蹾齁巉镴臜瓘镵卬𠙶毌邘圢伋冮氿汈氾𬣙讱扞圲圫芃朳朸𨙸邨屼屾辿伣伈癿甪邠𬇕汋䜣讻𬣞孖𬘓玒玓玘玚刬𫭟坉扽𫭢坋扺㧑毐芣苉芠𫇭杕杙杄杧尪尨轪𫐄坒旴旵㕮𫵷岠呇冏觃伾㑇伭佖佁飏汧汫𣲘𣲗沄沘𬇙汭㳇沇忳忺𬣡祃诇邲诐屃𫸩岊䢺妧妘𨚕纮驲𫘜纻𬘘𫘝纼玤玞玱邽邿坥坰坬坽弆䢼𦭜茋苧苾枅㭎枍矼矻匼𬨂𬀩𬀪旿昇昄昒昈咉咇咍岨岞峂㟃囷𬬩钖牥垈侁侹佸佺㑊侂佽侘郈舠郃攽肸狉狝饳忞炌炆泙沺泂泜泃泇峃祋祊𫍣𬣳𬩽鸤弢弨陑𬮿陎𬯀乸妭姈𫰛叕𬳵𬳶䌹𫠊㛃玶珇珅𬍛珋玹珌玿韨垚垯垙垍耇鿍垎垟垞挓垵垏荖荁荙茽荄𬜬荓𦰡㭕柷柊枹栐柖郚剅䴓迺厖砆砄耏奓䶮昺𪾢昽盷咡咺昳昣昤昫昡咥昪虷虸哃峘耑峛𪨰峗峧帡钘𫓧𬬮𬬱𬬭秬俫俙俍垕衎弇侴鸧䏡胠𦙶胈胣朏飐訄饻庤疢炣炟㶲洭洘洓洿㳚泚浉洸洑洢洈洺洨浐㳘洴洣恔宬扂袆祏祐祕叚陞娀姞姱姤姶姽枲绖骃𬘡𬳽𬘩𫄧骉珪珛珹玼珖𪟝珽珦珫珒𬍤珢珕珝𫭼埗垾垺埆垿埌埇茝𬜯鄀莝䓖莙栻𬂩梠栴梴栒𫠆砵砠砫硁翃郪𨐈辀𬌗剕哢晅晊唝哱冔晐畖蚄蚆𫑡崁峿𪨶崄帨崀𬬸𬬻𬬹𬬿𬭁甡倻倴脩倕倞𫢸倓倧衃虒舥鸰朓虓鱽峱𫗧勍竘羖羓烠烔烶烻𬊈涍浡浭浬涄涢涐浰浟浛浲涘悈悢𬒈宧窅窊窎扅扆袪袗袯隺堲疍𨺙烝砮㛚翀翂剟𬳿𫄨绤骍𬘫䂮琎珸珵琄琈琀珺堎堐埼埫堌晢𫮃掞埪壸㙍萚莿䓫勚䓬菂菍菼萣䓨菉䓛梼梽桲梾桯梣梌桹敔硔鿎硙硚硊硍勔䴕龁逴啫翈㫰晙畤𬱖跂蛃蚲𬟽啴䎃崟崒崌崡铏𫓯𫟹𫟼铚牻笯偰偡偭偲偁㿠鄅偓徛衒舲鸼悆鄃瓻䝙脟䏲鱾猇猄𠅤庱庼痓䴔竫堃羕焆烺焌淏𬇹淟淜淴淯湴涴𬍡㥄惛惔悰惙寁𬤇𫍯裈祲𬤊𫍲谞弸弶𬯎隃婞娵婼媖婳婍婌婫婤婘婠𬘬𬘭𬴂𫘦绹𫟅𬘯骕𫘧絜珷琲琡琟琔琭堾堼揕㙘堧喆堨塅𪣻𡎚惎萳靬葴鄚蓇萩蒐葰葎鄑葖蒄萹棤棽棫椓椑𬃊鹀椆棓棬棪椀𬷕甦酦奡皕詟𫐐辌棐龂𬹼牚睎晫晪晱𧿹畯斝喤崶嵁𫶇嵅崿嵚翙𫖮圌圐赑赒鿏𬭊𨱇𫓶𬭎犇颋稌筀筜筥傃傉翛傒傕畬𫖯脿腘䐃腒𬱟鲃猰𫛭猯㺄馉凓鄗𫷷廋廆鄌遆旐𬮱焞𬊤欻𣸣溚溁湝渰㴔渟溠渼溇湣湑溞愐愃敩棨扊祼婻媆媞㛹媓媂媄矞𬴃𫘨缊缐骙瑃瑓瑅瑆䴖瑖瑝瑔瑀𤧛瑳瑂嶅瑑髢堽赪摛塝搒蒱蒨蓏蔀蓢蓂蒻楪榃榅楒楩椸楙歅𬪩碃碏𬒔碈䃅硿鄠辒𬨎𫐓䣘暕鹍𫫇㬊暅跱蜐蜎嵲赗𫓹锳锧𬭚𬭛稑稙䅟𬕂筼筶筦筤僇艅谼貆腨腯鲉鲊鲌䲟𬶋𬶍鲏雊猺飔觟𦝼馌裛鄘鹒鄜麀阘𫔶煁煃煴煋煟煓溍溹滆滉溦溵漷滧滘滍愭慥慆塱𫌀禋禔禘禒鹔𫖳嫄媱勠戣𫘪𫘬缞耤瑧𫞩瑨瑱瑢斠摏墕墈墐墘摴𡐓𪤗靽鞁蔈蔊榰榑槚𣗋槜疐𬸘酺碶䃎𬒗碨𥔲𫚖䴗鹖㬎幖嶍圙𨱏锽𬭤镃馝鹙箖劄僔僎槃㙦𫚕鲖鲗鲘鲙𬶐𬶏𩽾夐飗𬸚凘廙鲝鄫熇漹漖潩漼漴㽏漈漋漻慬㮾𬤝褕禛隩嫕嫭嫪𬙂㻬麹璆漦叇墣墦墡薁蕰蔃鼒槱鹝磏殣慭霅暵暲暶踦䗖蝘蝲噇噂噀罶嶲嶓㠇嶟嶒镈镋𬭩镕皞皛䴘艎鹟𩾃鲪鲬觭鹠鹡鹢熛潖潵㵐澂澛瑬潽潾潏憭憕𬸣戭褯禤𫍽嫽遹𬴊璥璲璒憙薳黇𬞟蕗薢橞橑橦觱磡𥕢磜豮𫟦𬺈𫠜虤暿曌曈㬚蹅踶䗛疁㠓幪𪩘嶦𬭬𨱑𬭯馞穄篯簉衠盦螣縢鲯鲹𫗴亸𬸦羱糒燋熻燊燚燏濩濋澪澽澴澭澼憺嬛翯𫄷璱𤩽璬璮髽擿薿薸櫆檞醨繄磹磻瞫蹐蟏㘎𬭳𬭶𫔍𬭸𨱔𬭼𫔎矰穙穜穟簕簃儦魋斶𬸪谿䲠𬶟鲾𬶠鲿鳁鳂鳈鳉䗪襕襚𬶨螱嬬嬥𦈡𫄸瓀釐鬶爇鞳鞮𬟁藟藦藨鹲黡礌𥖨蹢蹜蟫䗴嚚髃镮酂馧簠簝簰鼫鼩皦臑䲢鳑鳒鹯癗𦒍旞翷䎖瀔瀍瀌襜䴙𬙊嚭㰀鬷蠋翾儳儴𬶭𩾌鳚鳛麑麖彟嬿鬒蘘欂甗𨟠巇酅髎犨𬶮𨭉㸌爔瀱瀼襫孅骦𬙋耰𤫉瓖鬘趯𬺓罍鼱鳠鳡鳣爟爚灈韂糵礵鹴皭龢鳤亹籥𫚭玃醾齇觿朘塃揾葓湨塈塮蹓檵礳耲

#### 3. 其他汉字

㑳㓤㕷㖡㖭㖿㗎㗳㗾㘚㠣㥠㥮㧸㧾㨘㩒㩧㩳㬹㷧㷫㹴㻐䁥䁪䂻䃟䃮䄷䌷䓣䓪䘆䜩䟴䡵䢵䣅䣓䥑䥕䦆䧑䨒䪸䮄䰾䱽䲁䲅䲘䲡䲳䴈䴉丗丟両並丱丼乕乗乢乪乫乭乶乷亀亂亅亊亐亙亜亞亰亼仏仭仮仼伀伃伕伜伝伨伹佇佈佔佢佫佮併佷來侊侒侖侚価侫侭侶侷俁係俉俋俓俔俛俠俤俥俬俿倀倂倅倆倈倉個們倖倢倣値倫倲倶倹偀偂偆偉偐偖偯側偵偸偺偽傌傑傔傖傘備傚傜傢傪傭傯傳傴債傷傾僂僅僉僊働僑僕僘僞僣僤僥僨僩僫僱僴價僿儀儁儂億儅儈儉儐儔儕儖儘儚償優儲儷儸儺儻儼兇兊兌兎児兒兗兙兛兝兞兡兣兤內兩兪円冇冊冐冑冓冚冝冦冧冨冩冪冴冾凃凅凈凊凍凖凜凞処凧凩凪凬凱凴凾刄刋刔刕別刧刪剄則剉剎剏剗剛剝剣剤剮剰剱剳剴創剷劃劇劉劊劌劍劏劑劒劔劜劤劦劯労劵効劻勀勁勅動勗務勛勝勞勢勣勦勧勩勱勲勳勵勷勸勻匁匂匇匋匤匭匯匱匳匸區卄卆卍協単卨卲卹卻卽厎厓厙厠厭厰厲厳厴參叄収叝叡叢叺叾吋吔吳吶呂呉呎呑呟呪呯呰呿咁咈咊咓咗咜咢咲咹咼咾哋哖哘員唄唎唓唖唚唜唞唥唭唸唹啀啅啋啌啍問啓啗啝啞啟啣啩啱啲啹喎喚喞喨喩喪喫喬單喰喲営喺喼嗆嗇嗊嗎嗗嗚嗧嗩嗰嗱嗶嗹嘅嘆嘍嘐嘓嘔嘖嘗嘜嘢嘥嘩嘮嘯嘰嘵嘸嘽噁噃噏噐噒噓噚噛噝噠噥噦噯噲噴噸噹噺嚀嚇嚉嚊嚌嚐嚔嚕嚙嚟嚠嚡嚢嚤嚥嚦嚨嚬嚮嚱嚲嚳嚴嚶嚹嚿囀囁囂囃囅囈囉囌囍囎囑囓囖囘団囧囪囮囲図圀圇國圍圏園圓圖團圦圧圷圸坔坙坮坵坿垉垪垬垰垳垻埀埈埓埖埜埞埡埣埧埨埰執埻堅堈堊堖堗堝堣堭堯報場堺塀塁塊塋塏塒塗塙塚塡塢塤塩塭塯塰塲塳塵塸塹塼塽塿墊増墜墠墫墬墮墲墳墶墸墹墺墻墾壂壆壇壊壋壌壎壓壗壘壙壚壜壞壟壠壢壥壩壪壯壱売壷壺壻壼壽夆変夊夋夌夘夛夠夢夲夽夾奀奐奛奝奣奧奨奩奪奫奬奮奼妏妛妝妬妳妸妺姃姅姉姍姙姦姪姫姵姸娍娙娚娛娫娭娯娳婁婦婬婭媗媜媤媧媬媯媴媺媼媽嫈嫋嫐嫗嫙嫤嫲嫵嫺嫻嫿嬀嬃嬅嬈嬋嬌嬙嬝嬡嬢嬤嬪嬰嬶嬸嬾孃孋孌孍孫孭學孻孼孿宂宍宖実宮寀寃寉寍寔寗寘寛寢實寧審寫寬寯寳寵寶対専尅將專尋對導尓尙尞尠尭尷屄屆屌屍屓屘屛屜屝屢層屨屬屭屶岡岦岶岺岻岼岾峀峅峇峠峩峯峴峵島峺峽崋崍崐崑崕崗崘崙崠崢崬嵂嵄嵐嵒嵓嵙嵜嵭嵳嵶嵽嶁嶄嶇嶋嶌嶐嶔嶗嶠嶢嶧嶨嶪嶬嶮嶴嶸嶹嶺嶼嶽巋巌巐巒巓巔巖巘巣巪巰巵巻巿帋帟帥師帯帰帳帶帿幀幃幇幎幗幘幟幣幤幫幬幵幷幹幾庁広庫庴廁廂廃廄廈廍廎廏廐廔廚廝廞廟廠廡廢廣廩廬廰廱廳廸廻廼弉弌弍弐弒弔弖弡弳弴張強弾彁彄彅彆彈彊彌彎彑彔彙彛彜彞彠彣彥彫彿徃徑従從徠徧復徫徬徳徴徹応忟忰忼怐怱怺恆恊恟恠恥恵恷悁悅悊悋悗悤悧悩悪悳悵悶悽惓惞惡惣惱惲惷惻愑愒愓愖愛愜愡愨愬愰愴愷愼愽愾慂慄慇態慍慓慘慙慚慜慟慣慤慪慫慮慯慱慳慴慶慼慽慾憁憂憇憊憐憑憒憓憖憘憚憤憫憮憲憶懃懆懇應懌懍懐懞懟懣懨懲懴懶懷懸懺懼懽懾戀戇戉戓戔戙戝戞戦戧戩戯戰戱戲戶戸戻払扙扠扥扨扱抂抆抜択抦抮拋拏拑拝拠拡拵挌挙挧挵挻挾挿捗捜捨捫捲捿掃掄掙掛掟採掫掯掲掵掹掻揀揃揚換揦揮揵揷揹揺揼搆搇損搖搗搢搣搥搧搨搵搶搾摀摂摃摎摑摜摟摠摯摰摳摵摶摷摻撃撈撍撏撐撓撚撝撟撢撣撥撫撲撳撴撹撻撾撿擁擄擇擊擋擓擔據擝擠擡擣擥擧擬擭擯擰擱擲擴擶擷擺擻擼擽擾攄攅攆攏攔攖攙攛攜攝攞攢攣攤攪攬攰攷敃敍敎敗敘敭敵數敻敾斂斃斅斆斈斉斎斕斬斲斷旂旙旛旡旣旲旼旽昐昑昜昞昮昰昻昿時晄晉晛晝晥晧晩晬晳晸晹暁暃暈暉暋暍暎暐暘暙暠暢暣暦暪暫暱暳暸暻暼曁曄曆曇曉曖曚曠曣曨曬曱曵書曺曻曽會朎朖朞朧朮朶朷朿杁杋杗杢杣杤杦杮東杴枌枏枒枓枠枡枦枩枱枴枻枾柀柆柎柤柧柮柵柶柺査柾栁栂栃栄栘栞栢栫栯桍桒桙桜桝桟桭桾桿梂梇梍梔梘梛梜條梟梡梱梲梶梹梺棄棅棆棈棊棏棔棖棗棟棡棧棯棲棶椄椈椌椏椙椚椛検椡椢椣椥椦椧椨椶楊楓楕楛楜楡楢楨楬業楳楴極楽楾榁榊榎榠榣榥榦榪榮榲榾榿槇構槍槓様槙槝槞槢槤槧槨槪槫槳槹槻樁樂樅樋樌樑樒樓樔標樛樞樢樣権樫樮樰樶樸樹樺橆橈橋橒橓橚機橢橫橲橳橸橽橾橿檁檇檉檍檔檜檟檢檣檨檪檮檯檳檸檻櫁櫂櫃櫈櫍櫑櫓櫚櫛櫝櫞櫟櫢櫤櫥櫧櫨櫪櫫櫬櫱櫳櫶櫸櫺櫻欄欅欉權欌欏欐欒欓欖欗欝欞欟欽歎歐歓歔歛歜歟歡歩歯歲歳歴歷歸歿殀殕殘殞殤殫殭殮殯殱殲殺殻殼毀毆毎毑毘毚毟毬毿氂氈氊氌気氣氫氬氳氶氷氹汍汎汙汚汢汮汯汳決沍沒沕沖沢沬況泝洐洟洩洶浄浤浹浿涇涊涏涖涙涜涬涷涼淃淍淒淕淚淥淨淩淪淲淵淶淸淺渇済渉渋渓渕渙減渢渦渧測渮渶渹渽渾湊湋湞湡湧湩湯湳湶湺満溂溈溌準溝溫溮溳溼溿滄滅滌滎滙滝滬滯滲滷滸滻滾滿漁漊漌漍漑漚漢漣漥漧漬漲漵漸漿潁潅潑潔潕潗潙潚潛潠潣潤潯潰潷潿澀澁澆澇澐澑澔澗澠澣澤澦澩澫澮澯澱澵澾濁濃濆濊濔濕濘濚濛濜濟濤濨濫濬濰濱濳濵濶濺濼濾瀁瀂瀅瀆瀇瀉瀋瀏瀕瀘瀜瀝瀞瀟瀠瀦瀧瀨瀬瀯瀰瀲瀷瀾灃灄灐灑灕灘灝灠灣灤灥灧灩災炚炡炤為烇烋烏烓烚烱烴焄焏焔焠無焢焼焿煀煆煇煉煏煐煒煕煖煙煚煢煥煩煬熀熅熈熉熒熕熗熢熰熱熲熺熾燀燁燄燈燉燐燒燖燗燙燜營燦燬燭燴燵燶燸燻燼燾燿爀爌爍爐爛爭爲爺爼爾牀牆牋牘牠牴牽犂犖犛犠犡犢犧犱犲犽犾狀狆狛狢狹狽猙猟猤猶猻獁獃獄獅獎獏獢獣獤獨獪獫獮獰獲獵獷獸獺獻獼玀玆玔玗玧玨玽珎珗珡珤珮珱現琁琍琓琠琩琸琺琿瑋瑌瑒瑠瑣瑤瑥瑩瑪瑯瑲瑽璂璉璊璕璗璡璢璣璤璦璫環璵璸璹璽璿瓅瓆瓈瓊瓏瓓瓔瓚瓛瓧瓩瓰瓱瓲瓸甁甃甅甌甎甕甛甞產産甴甼甽畄畆畇畉畊畍畑畓畝畠畢畧畩畫畭異畳畵當畷畺疂疇疉疊疎疪痀痙痠痩痲痳痺痾瘂瘉瘋瘍瘓瘖瘜瘝瘞瘡瘧瘮瘲瘺瘻療癆癇癈癉癎癒癘癟癡癢癤癥癦癧癨癩癪癬癭癮癰癱癲癶発發皀皃皐皚皜皰皷皸皹皺盃盌盜盞盡監盤盧盪盬盻県眛眞眤眥眾睆睍睏睜睞睪瞇瞓瞘瞜瞞瞶瞹瞼矇矋矓矚矯砇砈砕砡砱砲砿硃硏硓硜硤硦硨硯硲硴硺碁碆碕碖碩碪碭碯碵碸確碻碼磆磎磑磚磣磧磯磵磽磾礄礆礇礎礐礑礒礖礙礡礦礪礫礬礰礱礽祂祅祿禍禎禑禕禝禡禦禪禮禰禱禿秈秊秞秡稅稈稘稜稟種稱稲稶稾穀穂穃穇穉穋穌積穎穏穐穠穡穢穣穦穨穩穫穽窓窩窪窮窯窰窵窶窺竃竄竅竇竈竊竍竏竒竓竕竗竚竜竝竡竢竧竪竰競竸笂笘笭笵笶笹筆筈筊筍筧筩筬筯筰筴筺筽箄箆箇箋箎箏箒箘箙箚箞箟箠節範築篋篏篒篔篛篠篢篤篩篭篳篶簀簍簑簒簓簔簗簞簡簣簫簷簹簽簾籃籌籏籐籓籔籖籗籘籙籛籜籟籠籣籤籩籪籬籮籲籵籸籾粁粂粃粄粋粍粐粛粡粧粨粩粫粭粵粺糀糂糉糎糘糝糞糢糧糬糰糲糴糶糹糺糾紀紂紃約紅紆紇紈紉紋納紐紓純紕紖紗紘紙級紛紜紝紞紡紬紮細紱紲紳紵紹紺紼紿絀終絃組絅絆絈絋経絎絏結絓絕絖絛絝絞絡絢絣給絨絪絰統絲絳絵絶絹絺絽絿綁綃綄綆綈綉綌綎綏綑經綖継続綛綜綝綞綟綠綡綢綣綧綪綫綬維綯綰綱網綳綴綵綷綸綹綺綻綽綾綿緄緇緊緋総緑緒緔緕緖緗緘緙線緜緝緞締緡緣緤緦編緩緬緯緱緲練緶緹緻緼縁縄縅縈縉縊縋縐縑縒縕縗縛縝縞縟縡縣縦縧縫縭縮縯縱縲縳縴縵縶縷縹縺總績縿繃繅繆繈繊繋繍繒織繕繖繙繚繝繞繡繢繦繧繩繪繫繭繮繯繰繳繶繹繻繼繽繾繿纁纃纆纈纉纊續纍纎纏纐纒纓纔纕纖纘纜缽罃罇罈罌罎罠罣罧罫罰罵罷罸羂羃羅羆羇羈羋羣羥羨義羮羶翆習翫翬翹翺翽耈耉耡耬耭耮聖聞聟聡聢聨聯聰聲聳聴聵聶職聹聽聾肅肏肬胇脅脇脈脗脛脝脢脣脤脫脰脳脷脹腎腖腟腡腦腫腳腸膃膓膕膚膞膠膢膤膥膩膰膵膶膸膽膾膿臈臉臍臏臓臘臙臚臟臠臢臥臨臺與興舉舊舎舖舗舘舦舩舮舺艀艙艝艢艤艦艪艫艱艶艷艸芚芛芧芵芻芿苅苖苙苳苺苽茍茖茘茣茲荅荊荘荢荳荵荺荿莇莊莕莖莚莟莢莧莵菈菎菑菓菫華菴菶菷菻萇萊萓萠萢萪萬萵葈葉葒葢葤葦葮葯葷葹蒍蒓蒔蒝蒞蒭蒼蓀蓆蓋蓙蓚蓜蓪蓮蓯蓳蓴蓽蔄蔆蔔蔕蔘蔞蔣蔥蔦蔭蔯蔴蔵蔿蕀蕁蕆蕋蕎蕒蕓蕕蕘蕚蕢蕣蕩蕪蕫蕭蕷薀薈薊薌薐薑薔薗薘薙薟薦薩薫薬薴薶薺薾藍藎藝藥藪藭藴藶藷藹藺藾蘀蘂蘄蘆蘇蘊蘋蘒蘓蘗蘚蘞蘢蘦蘭蘯蘰蘺蘿虉處虛虜號虧虯蚫蛍蛬蛯蛺蛻蜆蜑蝀蝋蝕蝟蝦蝨蝪蝸蝿螄螆螞螢螮螻蟄蟇蟈蟎蟐蟣蟧蟬蟯蟲蟳蟶蟷蟻蠄蠅蠆蠇蠍蠎蠏蠐蠑蠔蠟蠣蠧蠨蠱蠵蠶蠻衂衆衊術衖衛衝衞衵衹袓袙袞袮袰袴袵袿裃裄裇裊裏補裝裡裯裲裵製褄複褌褔褘褜褝褞褲褳褵褸褻褽襀襃襇襌襍襏襖襝襠襤襪襬襭襯襲襴襷襾覇覈覊見覎規覓視覗覘覚覜覡覤覦覧覩親覬覯覲観覷覺覽覿觀觔觝觧觴觶觸觼訁訂訃計訊訌討訏訐訑訒訓訕訖託記訛訝訟訢訣訥訩訪設許訳訴訶訷診註証詁詆詎詐詑詒詔評詖詗詘詛詝詞詠詡詢詣試詨詩詪詫詬詭詮詰話該詳詵詷詻詼詿誂誄誅誆誇誌認誑誒誕誘誚語誠誡誣誤誥誦誧誨說説読誰課誶誹誼誾調諂諄談諉請諌諍諏諑諒諓論諗諚諛諜諝諞諟諠諡諢諤諦諧諪諫諭諮諱諲諳諴諶諷諸諺諼諾謀謁謂謄謅謊謌謎謏謐謔謖謗謙謚講謝謠謡謢謨謫謬謭謮謳謹謾譁譆證譊譌譎譏譓譖識譙譚譛譜譞譟譠譪譫譭譯議譱譲譴護譽譿讀讃變讋讌讎讐讒讓讕讖讙讚讜讞谺豈豊豎豐豔豬豭豶豼貍貎貓貙貝貞負財貢貧貨販貪貫責貭貮貯貰貲貳貴貶買貸貺費貼貽貿賀賁賂賃賄賅資賈賊賍賎賑賒賓賕賙賚賛賜賞賠賡賢賣賤賦賧質賫賬賭賰賱賴賵賸賺賻購賽賾贄贅贇贈贊贋贍贏贐贒贓贔贖贗贛贜赬赱趕趖趙趨趲跡跦跩跼跿踈踎踐踜踡踫踭踰踴踼蹌蹔蹕蹟蹠蹣蹤蹧蹺蹻躀躂躄躉躊躋躍躑躒躓躕躙躚躡躥躦躪躭躰躱躾軀軅軆軈車軋軌軍軏軑軒軔軚軛軝軟転軣軤軨軫軲軸軹軺軻軼軽軾較輄輅輇輈載輊輋輌輒輓輔輕輗輙輛輜輝輞輟輥輦輧輩輪輬輭輮輯輳輶輸輹輻輼輾輿轀轂轄轅轆轉轌轍轎轔轗轜轝轟轡轢轣轤辦辧辭辮辯農辵辷辺辻込迆迚迯迲迴逈逎逓逕這連逧週進逹遅遉遊運過達違遖遙遜遝遞遠遡遧適遯遲遶遷選遺遼邁還邇邉邊邏邐郞郟郵郷鄆鄉鄒鄔鄕鄖鄧鄩鄭鄰鄲鄳鄴鄶鄺酇酈酔酖酘酜酳醂醃醖醗醜醞醤醫醬醱醲醸釀釁釃釅釆釈釋釒釓釔釕釖釗釘釙釚釛針釞釟釡釣釤釥釦釧釩釪釭釮釴釵釶釷釹釺釼釿鈀鈁鈃鈄鈆鈇鈈鈉鈊鈍鈎鈐鈑鈒鈔鈕鈗鈜鈞鈣鈥鈦鈧鈩鈪鈬鈮鈰鈳鈴鈷鈸鈹鈺鈼鈽鈾鈿鉀鉄鉅鉆鉈鉉鉊鉋鉍鉎鉐鉑鉕鉗鉙鉚鉛鉝鉞鉢鉤鉥鉦鉧鉨鉬鉭鉮鉱鉲鉳鉶鉷鉸鉺鉻鉼鉾鉿銀銃銅銈銊銍銑銓銕銖銘銚銛銜銠銣銥銦銧銨銩銪銫銬銭銱銲銳銶銷銹銻銼鋁鋂鋃鋅鋇鋉鋌鋏鋐鋒鋓鋕鋗鋙鋝鋟鋠鋣鋤鋥鋦鋧鋨鋩鋪鋭鋮鋯鋰鋱鋲鋳鋶鋸鋹鋺鋻鋼鋿錀錁錂錄錆錇錈錏錐錒錕錘錙錚錛錝錞錟錠錡錢錣錤錥錦錧錨錩錫錬錮錯録錳錵錶錸錺錻錼鍀鍁鍃鍄鍅鍆鍇鍈鍊鍋鍍鍑鍔鍖鍗鍘鍙鍚鍛鍜鍠鍤鍥鍩鍬鍭鍮鍰鍵鍶鍺鍼鍾鎂鎄鎇鎊鎌鎓鎔鎖鎗鎘鎚鎛鎝鎡鎢鎣鎤鎦鎧鎩鎪鎬鎭鎮鎯鎰鎲鎳鎵鎶鎷鎸鎹鎿鏃鏄鏆鏇鏈鏋鏌鏍鏏鏐鏑鏗鏘鏜鏝鏞鏟鏡鏢鏤鏥鏨鏰鏵鏶鏷鏸鏹鏺鏻鏽鐃鐄鐇鐋鐍鐏鐐鐒鐓鐔鐘鐙鐚鐝鐠鐡鐥鐦鐧鐨鐩鐫鐮鐯鐱鐲鐳鐵鐶鐸鐺鐽鐿鑀鑁鑂鑄鑅鑈鑊鑌鑑鑒鑓鑔鑕鑚鑛鑞鑠鑢鑣鑤鑥鑪鑭鑰鑱鑲鑵鑷鑹鑼鑽鑾鑿钁钂铓長門閂閃閆閇閉閊開閌閎閏閑閒間閔閖閘閙閠閡関閣閤閥閧閨閩閪閫閬閭閱閲閶閹閻閼閽閾閿闃闆闇闈闉闊闋闌闍闐闑闒闓闔闕闖闘關闞闡闢闥阨阬阭阯陏陘陜陝陣陥陦陰陳陸険陽隄隉隊階隑隕際隝隠隣隤隨險隮隯隱隲隴隷隸隻雃雋雑雖雙雛雜雞離難雫雰雲電霂霊霑霙霤霦霧霳霻霽靂靃靄靆靈靉靍靏靑靕靚靜靤靦靨靫靭靱靷靹鞀鞄鞆鞏鞐鞜鞦鞽韁韃韆韈韉韋韌韍韓韙韜韞韡韮韱韲韹韻韾響頀頁頂頃項順頇須頊頌頍頎頏預頑頒頓頔頗領頚頜頠頡頤頦頫頬頭頰頲頴頵頷頸頹頻頼頽顆顋題額顎顏顒顓顔顕顗願顙顚顛類顢顥顧顫顬顯顰顱顳顴風颪颭颮颯颱颳颶颸颺颼飀飃飄飆飇飈飛飜飠飡飢飣飩飪飫飭飮飯飲飴飼飽飾飿餃餄餅餉養餌餎餏餑餒餓餔餖餗餘餚餛餜餝餞餠餡餤餧館餬餱餳餵餶餷餸餼餽餾餿饁饂饃饅饈饉饊饋饌饍饐饑饒饗饘饜饞饢饤饾馬馭馮馱馳馴馹馼駁駃駄駅駆駈駉駐駑駒駓駔駕駘駙駛駝駟駡駢駪駭駮駰駱駲駸駻駼駿騁騂騄騅騈騊騍騎騏騑騒験騖騙騞騠騤騨騫騭騮騯騰騱騵騶騷騸騾驀驁驂驃驄驅驊驌驍驎驏驕驗驚驛驟驢驤驥驦驩驪驫骭骯骹骾髄髏髒體髕髖髙髜髞髣髥髪髮髱髴髷鬆鬍鬚鬢鬥鬧鬨鬩鬪鬮鬱鬹魎魘魚魛魟魠魢魨魩魯魲魴魵魷魽鮀鮁鮃鮆鮈鮊鮋鮍鮎鮏鮐鮑鮒鮓鮕鮖鮗鮘鮚鮜鮝鮞鮟鮠鮡鮣鮦鮨鮪鮫鮭鮮鮱鮴鮶鮸鮹鮺鮻鯀鯁鯆鯇鯈鯉鯊鯏鯑鯒鯓鯔鯕鯖鯗鯙鯛鯝鯡鯢鯣鯤鯧鯨鯪鯫鯭鯰鯱鯲鯴鯵鯷鯻鯽鯿鰀鰁鰂鰃鰄鰆鰈鰉鰊鰌鰍鰏鰐鰒鰓鰔鰕鰛鰜鰟鰠鰡鰣鰤鰥鰧鰨鰩鰭鰮鰯鰰鰱鰲鰳鰵鰶鰷鰹鰺鰻鰼鰾鱀鱂鱅鱆鱇鱈鱉鱒鱔鱖鱗鱘鱙鱚鱝鱟鱠鱣鱤鱧鱨鱭鱯鱲鱶鱷鱸鱺鳥鳧鳩鳫鳬鳰鳲鳳鳴鳶鳾鴃鴆鴇鴈鴉鴎鴒鴕鴛鴝鴞鴟鴣鴦鴨鴪鴫鴬鴯鴰鴴鴷鴻鴽鴾鴿鵁鵂鵃鵄鵆鵈鵏鵐鵑鵒鵓鵙鵜鵝鵞鵟鵠鵡鵤鵪鵫鵬鵮鵯鵰鵲鵺鵾鶄鶆鶇鶉鶊鶏鶓鶖鶘鶚鶠鶡鶤鶥鶩鶪鶫鶬鶯鶱鶲鶴鶸鶹鶺鶻鶼鶿鷀鷁鷂鷄鷆鷈鷉鷊鷏鷓鷗鷙鷚鷟鷥鷦鷫鷭鷯鷲鷳鷴鷸鷹鷺鷽鷿鸇鸊鸌鸏鸑鸕鸘鸙鸚鸛鸝鸞鹵鹸鹹鹺鹼鹽麁麌麕麗麥麩麪麭麯麵麺麼麿黃黌黐黒黙點黨黲黴黶黷黽黿鼇鼈鼉鼕鼡鼴齊齋齎齏齒齔齕齗齘齙齜齟齠齡齢齣齦齧齪齬齮齯齲齶齷齼龍龐龑龔龕龜龝鿔鿫鿬鿭𠜎𠜱𠝹𠮟𠱓𠱸𠲖𠳏𠳕𠴕𠵼𠵿𠸎𠸏𠹷𠺝𠺢𠻗𠻹𠻺𠼭𠼮𠽌𠾴𠾼𠿪𡁜𡁯𡁵𡁶𡁻𡃁𡃉𡇙𡑍𢃇𢞵𢫕𢭃𢯊𢱑𢱕𢳂𢴈𢵌𢵧𢺳𣲷𤓓𤶸𤷪𥄫𥗽𦉘𦟌𦧲𦧺𧨾𨅝𨈇𨋢𨧀𨨏𨭆𨭎𨳊𨳍𨳒𩶘𫟷
