<!-- markdown-link-check-disable -->

# 超赞的 Linux 软件

![Tux](img/tux.png)

🐧 这个仓库收集了对**任何用户/开发者**都**超赞**的 Linux 应用软件。

🐧 请随意 **contribute** / **star** / **fork** / **pull request**。欢迎一切**推荐**和**建议**。

_更新：上发布，中文版阅读地址戳[这里](https://alim0x.gitbooks.io/awesome-linux-software-zh_cn/content/)。你可以将这个链接分享给新用户，因为在上面阅读相比于在 github 上阅读会更加友好。可以在[这里](https://goo.gl/xhiKla)下载英文 pdf 版本。_

## 目录

- [超赞的 Linux 软件](#超赞的-linux-软件)
  - [目录](#目录)
  - [应用](#应用)
    - [音频](#音频)
    - [聊天客户端](#聊天客户端)
    - [数据备份与恢复](#数据备份与恢复)
    - [桌面个性化](#桌面个性化)
    - [开发](#开发)
    - [电子书工具](#电子书工具)
    - [编辑器](#编辑器)
    - [教育](#教育)
    - [电子邮件](#电子邮件)
    - [文件管理器](#文件管理器)
    - [游戏](#游戏)
      - [City Building Simulation](#city-building-simulation)
      - [Command Line Games](#command-line-games)
      - [Engine Re-creations (require the actual game)](#engine-re-creations-require-the-actual-game)
      - [FPS](#fps)
      - [Gaming Applications](#gaming-applications)
      - [Machine emulators](#machine-emulators)
      - [Miscellaneous](#miscellaneous)
      - [RPG](#rpg)
      - [RTS](#rts)
      - [Turn Based Strategy](#turn-based-strategy)
    - [图形](#图形)
    - [互联网](#互联网)
    - [办公](#办公)
    - [生产力](#生产力)
    - [安全](#安全)
    - [代理](#代理)
    - [文件共享](#文件共享)
    - [终端](#终端)
    - [实用工具](#实用工具)
    - [视频](#视频)
    - [其它](#其它)
  - [命令行工具](#命令行工具)
  - [桌面环境](#桌面环境)
  - [显示管理](#显示管理)
    - [控制台](#控制台)
    - [图形界面](#图形界面)
  - [窗口管理](#窗口管理)
    - [合成器](#合成器)
    - [叠加式窗口管理器](#叠加式窗口管理器)
    - [平铺式窗口管理器](#平铺式窗口管理器)
    - [动态窗口管理器](#动态窗口管理器)
  - [设置](#设置)
    - [Arch Linux](#arch-linux)
    - [CentOS](#centos)
    - [openSUSE](#opensuse)
    - [Ubuntu](#ubuntu)
    - [其它发行版](#其它发行版)
  - [论坛](#论坛)
    - [Arch Linux Forums](#arch-linux-forums)
    - [CentOS Forums](#centos-forums)
    - [Ubuntu Forums](#ubuntu-forums)
    - [openSUSE Forums](#opensuse-forums)
    - [IRC 频道](#irc-频道)
    - [Linux 新闻，应用，以及更多...](#linux-新闻应用以及更多)
    - [Reddit](#reddit)
  - [学习 Linux](#学习-linux)
  - [Linux Hacking/开发](#linux-hacking开发)
  - [贡献者](#贡献者)
  - [贡献指南](#贡献指南)
  - [许可证](#许可证)

---

- [设置](#设置)
  - [ArchLinux](#arch-linux)
  - [CentOS](#centos)
  - [openSUSE](#opensuse)
  - [Ubuntu](#ubuntu)
- [论坛](#论坛)
  - [ArchLinux 论坛](#arch-linux-forums)
  - [CentOS 论坛](#centos-forums)
  - [Ubuntu 论坛](#ubuntu-forums)
  - [openSUSE 论坛](#opensuse-forums)
  - [IRC 频道](#irc-channels)
  - [Linux 新闻，应用，以及更多...](#linux-news-apps-and-more-)
  - [Reddit](#reddit)
- [学习 Linux](#learn-linux)
- [Linux Hacking/开发](#linux-hackingdevelopment)
- [贡献者](#贡献者)
- [贡献指南](#贡献指南)

---

## 应用

### 音频

- [Cmus](https://cmus.github.io/) - cmus 是一款类 Unix 系统下小巧，快速且强大的终端音乐播放器。
- [![Open-Source Software][oss icon]](https://github.com/sourcefabric/Airtime) [Airtime](https://www.sourcefabric.org/software/airtime) - Airtime 是一款用于调度和远程站点管理的开放广播软件
- [Ardour](https://ardour.org/) - 在 Linux 上录音，编辑，和混音
- [Audacious](http://audacious-media-player.org/) - 开源音频播放器，按你想要的方式播放你的音乐，不占用你其它任务的电脑资源。[![Open-Source Software][oss icon]](http://audacious-media-player.org/developers)
- [![Open-Source Software][oss icon]](https://github.com/audacity/audacity) [Audacity](http://www.audacityteam.org/download/linux/) - 免费，开源，跨平台的声音录制、编辑软件。
- [![Open-Source Software][oss icon]](https://bazaar.launchpad.net/~audio-recorder/audio-recorder/trunk/files) [Audio Recorder](https://launchpad.net/~audio-recorder) - 简单的声音录制软件，就在 ubuntu ppa。
- [![Open-Source Software][oss icon]](https://github.com/clementine-player/Clementine) [Clementine](https://www.clementine-player.org/) - 播放无数的有损和无损音频格式。
- [![Open-Source Software][oss icon]](https://github.com/MarshallOfSound/Google-Play-Music-Desktop-Player-UNOFFICIAL-) [Google Play Music](https://www.googleplaymusicdesktopplayer.com/) - 非官方但很漂亮的跨平台 Google Play Music 桌面客户端。
- [Hydrogen](http://hydrogen-music.org/) - GNU/Linux 上的高级电子鼓。
- [![Open-Source Software][oss icon]](https://github.com/trazyn/ieaseMusic) [ieaseMusic](https://github.com/trazyn/ieaseMusic) - 优雅的 NeteaseMusic 桌面应用程序，Rock with NeteaseMusic。
- [![Open-Source Software][oss icon]](https://github.com/KDE/k3b) [K3b](http://www.k3b.org/) - K3b - Linux 上的 CD/DVD 创建工具 - 为 KDE 特别优化。
- [Kid3Qt](https://apps.ubuntu.com/cat/applications/precise/kid3-qt/) - 编辑多媒体文件的标签，如一个专辑所有 mp3 文件的艺术家，专辑，年代，流派。
- [KxStudio](http://kxstudio.linuxaudio.org/) - KXStudio 是专业声音创作应用和插件的集合。
- [Let's make music](https://lmms.io/download/#linux) - 在你的 PC 上制作音乐，创造旋律和节拍，合成，混音，编曲小样以及更多内容。
- [![Open-Source Software][oss icon]](https://github.com/gnumdk/lollypop) [Lollypop](https://wildskyf.github.io/lollypop-web/) - Lollypop 是一款新的 GNOME 音乐播放应用。
- [![Open-Source Software][oss icon]](https://github.com/emilioastarita/lyricfier) [Lyricfier](https://github.com/emilioastarita/lyricfier) - 一个 Spotify Lyrics 的替代选择。
- [![Open-Source Software][oss icon]](https://github.com/mixxxdj/mixxx) [Mixxx](http://www.mixxx.org/download/) - 免费的 DJ 软件，给你一切现场混音所需要的，名副其实的 Traktor 替代品。
- [![Open-Source Software][oss icon]](https://github.com/mopidy/mopidy) [Mopidy](https://www.mopidy.com/) - An extensible music server written in Python.
- [![Open-Source Software][oss icon]](https://github.com/KeitIG/museeks) [Museek](http://museeks.io/) - 一款简单，干净，跨平台的音乐播放器。
- [![Open-Source Software][oss icon]](https://github.com/musescore/MuseScore) [MuseScore](https://musescore.org) - Create, play and print beautiful sheet music.
- [![Open-Source Software][oss icon]](https://github.com/metabrainz/picard) [MusicBrainz Picard](https://picard.musicbrainz.org/) - Picard is a cross-platform music tagger written in Python.
- [Netease Music](https://music.163.com/#/download) - 网易云音乐播放器
- [Oceanaudio](http://www.ocenaudio.com/whatis) - ocenaudio 是一款跨平台，易用，快速且功能强大的音频编辑器。对需要编辑和分析音频文件的人来说是个理想的软件。
- [![Open-Source Software][oss icon]](https://github.com/PedroHLC/osdlyrics) [OSD Lyrics](https://aur.archlinux.org/packages/osdlyrics-git/) - 与你最爱的媒体播放器显示歌词。
- [![Open-Source Software][oss icon]](https://github.com/quodlibet/quodlibet) [Quod Libet](https://quodlibet.readthedocs.io) - 一款编写时就考虑了很多库的 GTK+ 音乐播放器。Quod Libet 支持基于搜索的动态播放列表，正则，标签，回放增益，播客以及互联网广播。
- [![Open-Source Software][oss icon]](https://github.com/GNOME/rhythmbox) [Rhythmbox](https://wiki.gnome.org/Apps/Rhythmbox) - 来自 GNOME 的音乐播放器。
- [![Open-Source Software][oss icon]](https://sayonara-player.com/downloads/#Source) [Sayonara Player](https://sayonara-player.com/downloads/) - Sayonara 是一款小巧干净，快速的音频播放器，使用 C++ 编写，基于 Qt 框架。
- [SoundJuicer](http://www.howtogeek.com/howto/20126/rip-audio-cds-with-sound-juicer/) - CD 抓取工具，for GNOME
- [![Open-Source Software][oss icon]](https://github.com/Soundnode/soundnode-app) [Soundnode](https://soundnode.github.io/soundnode-website/) - 一款开源的 SoundCloud 桌面应用。
- [![Open-Source Software][oss icon]](https://github.com/devinhalladay/spotio) [Spotio](https://github.com/devinhalladay/spotio) - 受 Rdio 启发的 Spotify 桌面应用亮色主题。
- [![Open-Source Software][oss icon]](https://github.com/VCVRack/Rack) [VCV Rack](https://vcvrack.com/) - An open-source virtual modular synthesizer.
- [![Open-Source Software][oss icon]](https://github.com/yktoo/indicator-sound-switcher) [Yktoo Sound Switcher Indicator](https://yktoo.com/en/software/indicator-sound-switcher) - Sound input/output selector indicator for Ubuntu/Unity.

### 聊天客户端

- [![Open-Source Software][oss icon]](https://github.com/chatty/chatty) [Chatty](http://chatty.github.io/) - Chatty 是一款 Twitch 聊天客户端，它是为那些想尝试不同于 web 聊天的新事物，又不想像 IRC 客户端那样复杂或错过 Twitch 特色功能的用户准备的。
- [Discord](https://discord.com/) - 为玩家准备的多合一语音文本聊天工具，免费，安全，同时支持桌面和手机。
- [Franz](http://meetfranz.com/) - Franz 是一个免费的消息应用，结合了许多聊天及消息服务到单独的一个客户端中。[![Open-Source-Software][oss icon]](https://github.com/meetfranz/franz)
- [![Open-Source Software][oss icon]](https://github.com/stanfieldr/ghetto-skype) [GhettoSkype](https://github.com/stanfieldr/ghetto-skype) - Skype 的开源 web 封装。
- [![Open-Source Software][oss icon]](https://github.com/gitterHQ/services) [Gitter](https://gitter.im/) - Gitter — 开发者交流的地方。Gitter 的设计目标是让社区消息，协作和发现尽可能地简单。
- [![Open-Source Software][oss icon]](https://github.com/hexchat) [HexChat](https://hexchat.github.io/) - HexChat 是一款基于 XChat 的 IRC 客户端，但和 XChat 不一样的是它对 Windows 和 Unix-like 系统都是完全自由的。
- [![Open-Source Software][oss icon]](https://github.com/jitsi) [Jitsi](https://jitsi.org/) - Jitsi 是一款免费，开源的多平台语音，视频会议以及即时通讯应用，在 Windows, Linux, Mac OS X 和 Android 上可用。
- [![Open-Source Software][oss icon]](https://github.com/Aluxian/Facebook-Messenger-Desktop) [Messenger for Desktop](https://messengerfordesktop.com/#download) - Facebook messenger 应用。
- [Pidgin](http://askubuntu.com/questions/307622/update-pidgin-using-apt-get) - 一款通用聊天客户端。
- [![Open-Source Software][oss icon]](https://github.com/qTox/qTox) [qTox](https://qtox.github.io/) - 一款简单的分布式，安全的通讯软件，支持音频和视频聊天。
- [![Open-Source Software][oss icon]](https://github.com/saenzramiro/rambox) [Rambox](http://rambox.pro/) - 免费，开源且跨平台的消息及邮件应用，整合常见的 web 应用为一体。
- [![Open-Source Software][oss icon]](https://github.com/raelgc/scudcloud/) [ScudCloud](https://github.com/raelgc/scudcloud/) - 一款 Linux 下的 Slack 客户端。
- [Skype](https://www.skype.com/en/) - Skype 让世界保持沟通，免费的。
- [Slack](https://slack.com/downloads/linux) - 现代团队的即时通讯，归档及搜索沟通工具。
- [![Open-Source Software][oss icon]](https://github.com/telegramdesktop/tdesktop) [Telegram](https://desktop.telegram.org/) - 一款专注于速度和安全的消息应用，它非常快，简单而且免费。
- [Viber](https://www.viber.com/en/products/linux) - Viber for Linux 让你在任何设备，网络和国家给其他 Viber 用户免费发送消息和通话。
- [![Open-Source Software][oss icon]](https://github.com/weechat) [Weechat](https://weechat.org/) - WeeChat 是一款快速，轻量级，可扩展的聊天客户端。

### 数据备份与恢复

- [![Open-Source Software][oss icon]](https://borgbackup.readthedocs.io/en/stable/development.html) [Borg Backup](https://borgbackup.readthedocs.io/en/stable/) - 一款不错的的备份工具。
- [![Open-Source Software][oss icon]](https://launchpad.net/deja-dup) [Deja Dup](https://www.linux.com/learn/total-system-backup-and-recall-deja-dup) - 一款内置加密的简单备份工具。
- [![Open-Source Software][oss icon]](https://launchpad.net/duplicity) [Duplicity](http://duplicity.nongnu.org/) - Duplicity 通过生成加密的 tar 格式卷备份目录，并且可以上传备份到远端或本地文件服务器。
- [Photorec](http://www.cgsecurity.org/wiki/PhotoRec) - PhotoRec 一款数据恢复应用，为恢复硬盘，CD-ROM 上包括视频，文档以及归档等文件而设计，以及数码相机存储中丢失的相片（Photorec 的由来）。
- [![Open-Source Software][oss icon]](https://borgbackup.readthedocs.io/en/stable/) [Qt4-fsarchiver](https://sourceforge.net/projects/qt4-fsarchiver/) - qt4-fsarchiver 是 fsarchiver 的图形化界面，能够保存/恢复分区，文件夹和 MBR/GPT 分区。这个程序是基于 Debian 的系统，Suse 以及 Fedora 适用的。
- [![Open-Source Software][oss icon]](https://github.com/ncw/rclone) [rclone](http://rclone.org/) - Rclone 是一款命令行工具，用于同步文件和目录到不同的云存储方案。它还允许备份加密。
- [System Rescue CD](https://www.system-rescue.org/SystemRescueCd_Homepage) - SystemRescueCd 是一款 Linux 系统急救盘，提供可启动的 CD-ROM 或 U 盘，用于管理系统在崩溃后修复系统和数据。
- [Test Disk](http://www.cgsecurity.org/wiki/TestDisk) - TestDisk 是一款强大的免费数据恢复软件！它主要设计用于帮助回去丢失的分区和/或修复由软件错误导致的硬盘无法启动引导。
- [Timeshift](https://launchpad.net/timeshift) - TimeShift 是一款系统还原工具，它用 rsync 和硬链接创建系统的增量快照。快照可以在一段时间后用于恢复，撤销快照生成以来所做的所有更改。快照可以手动生成或用定时任务自动生成。

### 桌面个性化

- ![Open-Source Software][oss icon] [Adapta Theme](https://github.com/tista500/Adapta) - 一款自适应的 Gtk+ 主题，遵循 Material 设计指南。
- ![Open-Source Software][oss icon] [Arc Icon Theme](https://github.com/horst3180/arc-icon-theme) - 一款可以和 Moka 图标主题一同使用的现代图标主题。
- ![Open-Source Software][oss icon] [Arc Theme](https://github.com/jnsh/arc-theme) - 带有透明元素的扁平化主题
- [Compiz Config settings manager](https://apps.ubuntu.com/cat/applications/compizconfig-settings-manager/) - OpenCompositing 项目带来的提高 X Window 系统可用性和生产力的 3D 桌面视觉特效。
- [![Open-Source Software][oss icon]](https://github.com/brndnmtthws/conky) [Conky](https://github.com/brndnmtthws/conky) - Conky 是 X 下一款免费，轻量的系统监视器，可以在你桌面显示任何类型的信息。
- [![Open-Source Software][oss icon]](https://github.com/andreisergiu98/arc-flatabulous-theme) [Flatabulous Arc Theme](https://github.com/andreisergiu98/arc-flatabulous-theme) - 我最爱的 ubuntu 主题。
- ![Open-Source Software][oss icon] [Flatabulous](https://github.com/anmoljagetia/Flatabulous) - 一款扁平化主题，适用于 Ubuntu 以及其它基于 Gnome 的 Linux 系统。
- [Gnome Extensions](http://extensions.gnome.org/) - Gnome 桌面环境扩展插件。
- [Gnome Look](https://www.gnome-look.org/) - 大量社区创建的图标，shell 主题，字体，以及其他更多的可用来个性化你的 Gnome 桌面环境的资源，都在这一个站点。
- [![Open-Source Software][oss icon]](https://github.com/bil-elmoussaoui/Hardcode-Tray) [Hardcode Tray](https://github.com/bil-elmoussaoui/Hardcode-Tray) - 这个脚本通过在 Linux 中自动探测你默认主题，正确的图标尺寸，硬编码内嵌图标应用，以及正确的状态图标来修正硬编码的托盘图标。
- [![Open-Source Software][oss icon]](https://github.com/bsundman/Irradiance) [Irradiance Theme](https://github.com/bsundman/Irradiance) - 一款受 OSX Yosemite 启发的 Unity 主题，基于 Radiance。
- [![Open-Source Software][oss icon]](https://github.com/numixproject/numix-icon-theme) [Numix Icon Theme](http://www.noobslab.com/2014/04/install-numix-icon-packs-in-ubuntulinux.html) - Ubuntu 最好的图标主题之一。
- [![Open-Source Software][oss icon]](https://github.com/numixproject/numix-gtk-theme) [Numix Theme](https://itsfoss.com/install-numix-ubuntu/) - 一款很流行的主题。
- [Paper Icon Theme](https://snwh.org/paper/icons) - Paper 是一款现代 freedesktop 图标主题，它的图表设计注重强烈的色彩和简单的几何形状。
- [![Open-Source Software][oss icon]](https://github.com/PapirusDevelopmentTeam/papirus-icon-theme-gtk/) [Papirus Icon Theme](https://github.com/PapirusDevelopmentTeam/papirus-icon-theme-gtk/) - Linux 系统 SVG 图标主题，基于 Paper 主题并有一些额外的特性（如硬编码托盘支持，kde 颜色方案支持，libreoffice 图标主题，filezilla 主题，smplayer 主题...）以及其它的修改。这个主题适用于 GTK 以及 KDE。
- [![Open-Source Software][oss icon]](https://github.com/ianyh/Amethyst) [Unity Tweak Tool](https://apps.ubuntu.com/cat/applications/unity-tweak-tool/) - Ubuntu unity 个性化必备应用。
- [![Open-Source Software][oss icon]](https://github.com/bsundman/Yosembiance) [Yosembiance theme](https://github.com/bsundman/Yosembiance) - 一款受 OSX Yosemite 启发的 Ambiance 改款主题。
- [La Capitaine Icon Theme](https://github.com/keeferrourke/la-capitaine-icon-theme) - 一款受 macOS 和 Material 设计启发的图标主题，目标是适配大部分桌面环境。

### 开发

- [Clion](https://www.jetbrains.com/clion/) - 一款强大的跨平台 C 以及 C++ IDE。
- [Android studio](https://developer.android.com/studio/index.html) - Android 的官方 IDE：Android Studio 提供在各种类型的安卓设备上构建应用最快的工具。
- [Aptana](https://www.axway.com/en/aptana) - Aptana Studio 利用了 Eclipse 的灵活性并且专注于让它成为强大的 web 开发引擎。
- [![Open-Source Software][oss icon]](https://github.com/arduino/arduino-ide) [Arduino IDE](https://www.arduino.cc/en/Main/Software) - 开源的 Arduino 软件（IDE）让编写代码和上传代码到开发板变得简单。
- [BlueJ](http://bluej.org/) - 一款为新手设计的免费 Java 开发环境，世界范围内数百万人使用。
- [Code::Blocks](https://www.codeblocks.org/) - Code::Blocks 是一款为满足大部分用户需求构建的免费的 C，C++ 以及 Fortran IDE。它可扩展并且可配置性强。
- [Codelite](http://codelite.org/) - 一款免费，开源，跨平台的 C，C++，PHP，以及 Node.js IDE。
- [![Open-Source Software][oss icon]](https://github.com/serge-rider/dbeaver/) [DBeaver](http://dbeaver.jkiss.org/) - 一款通用数据库客户端，支持多个平台及多种数据库。
- [![Open-Source Software][oss icon]](https://cgit.kde.org/kexi.git/about/) [Kexi](http://kexi-project.org/) - Kexi is an open source visual database applications creator, a long-awaited competitor for programs like MS Access or Filemaker.
- [Eclipse](https://eclipse.org/ide/) - Eclipse 以 Java 集成开发环境而闻名，但它的 C/C++ IDE 和 PHP IDE 同样出色。
- [![Open-Source Software][oss icon]](https://github.com/fisherman/fisherman) [Fisherman](https://github.com/fisherman/fisherman) - 一款 fish shell 插件管理器。
- [![Open-Source Software][oss icon]](https://github.com/fish-shell/fish-shell) [Fish](https://fishshell.com/) - 一款智能且用户友好的命令行 shell。
- [![Open-Source Software][oss icon]](https://www.fossil-scm.org/index.html/dir?ci=tip) [Fossil](https://www.fossil-scm.org) - 自包含，分布式软件配置管理系统，带有集成 bug 追踪，wiki，技术说明和 web 界面。
- [![Open-Source Software][oss icon]](https://github.com/fritzing/fritzing-app) [Fritzing](https://fritzing.org/) - Fritzing 是一个开源硬件项目，它让电子部件变成人人都能接触到的创造性材料。
- [![Open-Source Software][oss icon]](https://www.geany.org/Download/Git) [Geany](https://www.geany.org/) - Geany 是一款基于 GTK+ 的文本编辑器，带有基本的集成开发环境特性。它的开发是为了提供一个小型并且快速的 IDE，对其它包只有很少的的依赖。
- [Genymotion](https://www.genymotion.com/features/) - Genymotion 是一款可以用来替代默认安卓模拟器的第三方模拟器。
- [![Open-Source Software][oss icon]](https://git.gnome.org//browse/giggle/) [Giggle](https://wiki.gnome.org/action/show/Apps/giggle?action=show&redirect=giggle) - Giggle 一款 git 内容追踪的图形化前端。
- [![Open-Source Software][oss icon]](https://github.com/git/git) [Git](https://git-scm.com/) - Git is a free and open source distributed version control system designed to handle everything from small to very large projects with speed and efficiency.
- [![Open-Source Software][oss icon]](https://github.com/git-cola/git-cola) [GitCola](http://git-cola.github.io/) - Git Cola 是一款整洁且强大的图形化 Git 客户端。用 Python 写就并签署于 GPL 协议。
- [![Open-Source Software][oss icon]](https://wiki.gnome.org/Apps/Gitg#Development_Resources) [Gitg](https://wiki.gnome.org/Apps/Gitg) - gitg is the GNOME GUI client to view git repositories.
- [GitKraken](https://www.gitkraken.com/) - 强大酷炫的 Git 图形化客户端，支持 Windows，Mac 以及 Linux。
- [Git](https://git-scm.com/) - Git 是一款免费和开源的分布式版本管理系统，被设计用来快速和高效地处理从小项目到大项目的一切内容。
- [Insomnia](https://insomnia.rest/) - 一款简单，漂亮且免费的 REST API 客户端。
- [![Open-Source Software][oss icon]](https://github.com/JetBrains/intellij-community) [IntelliJ IDEA](https://www.jetbrains.com/idea/) - 强大的 Java IDE。
- [![Open-Source Software][oss icon]](https://github.com/ipython/ipython) [Ipython](https://ipython.org/) - 强大的 Python shell。
- [![Open-Source Software][oss icon]](https://docs.jupyter.org/en/latest/install.html) [Jupyter Notebook](https://jupyter.org/) - 开源，交互式数据科学和科学计算，支持超过 40 种编程语言。
- [KDevelop](https://www.kdevelop.org/) - 免费，开源 IDE，全功能，支持插件扩展的 C/C++ 以及其它编程语言 IDE。
- [Komodo Edit](http://komodoide.com/komodo-edit/) - 免费，开源的多语言开发环境。
- [Netbeans](https://netbeans.org/downloads/) - NetBeans IDE 让你快速而且容易地开发 Java 桌面，移动以及 web 应用，还有基于 HTML，JavaScript 以及 CSS 的 HTML5 应用。
- [NodeJS](https://nodejs.org/en/) - Node.js® 是一个基于 Chrome V8 JavaScript 引擎的 JavaScript 运行时环境。
- [![Open-Source Software][oss icon]](https://github.com/oh-my-fish/oh-my-fish) [Oh-my-fish](https://github.com/oh-my-fish/oh-my-fish) - 提供各种插件和主题以扩展你的 fish shell 功能。
- [Postgresql](https://www.postgresql.org/download/) - PostgreSQL 是一款强大，开源的对象-关系型数据库系统。
- [Postman](https://www.postman.com/) - Postman，帮助我们快速测试 API。
- [PyCharm](https://www.jetbrains.com/pycharm/) - 强大的 Python IDE。
- [QT Creator](https://www.qt.io/ide/) - 全功能跨平台集成开发环境，轻松创建互联设备，用户界面以及应用程序。
- [![Open-Source Software][oss icon]](https://github.com/rabbitvcs/rabbitvcs) [Rabbit VCS](http://rabbitvcs.org/) - RabbitVCS 是一个图形工具的集合，提供一个与你使用的版本控制系统简单而直接的访问方式。
- [![Open-Source Software][oss icon]](https://github.com/jantje/arduino-eclipse-plugin) [Sloeber IDE](http://eclipse.baeyens.it/) - Sloeber IDE。Eclipse 的 Arduino IDE。我很喜欢它。
- [StarUML](https://staruml.io/) - 一款精致的软件塑造者。
- [Swift](https://swift.org/download/) - Swift 是一个通用编程语言，基于更现代的安全，性能，和软件设计模式为目标设计。
- [Ubuntu-SDK](https://developer.ubuntu.com/en/phone/platform/sdk/installing-the-sdk/) - Ubuntu 官方 SDK。
- [![Open-Source Software][oss icon]](https://github.com/zealdocs/zeal) [Zeal](https://zealdocs.org/) - Zeal 是一款面向软件开发者的离线文档阅读器。
- [![Open-Source Software][oss icon]](https://mariadb.org/get-involved/getting-started-for-developers/) [MariaDB](https://mariadb.org/) - 最流行的数据库服务器之一。由原 MySQL 开发者打造。
- [![Open-Source Software][oss icon]](https://www.monodevelop.com/developers/) [MonoDevelop](http://www.monodevelop.com/) - 跨平台的 C#，F# 以及更多语言的 IDE。
- [![Open-Source Software][oss icon]](https://github.com/robbyrussell/oh-my-zsh) [Oh-my-zsh](https://github.com/robbyrussell/oh-my-zsh) - 一个由社区驱动，优雅的 zsh 配置管理框架。
- [![Open-Source Software][oss icon]](https://github.com/stuartlangridge/ColourPicker) [Pick](http://kryogenix.org/code/pick/) - 简单的拾色器。
- [![Open-Source Software][oss icon]](https://github.com/sqlitebrowser/sqlitebrowser) [Sqlite Browser](http://sqlitebrowser.org/) - 可视化创建，管理，以及查看 sqlite 数据库文件。
- [![Open-Source Software][oss icon]](https://sourceforge.net/p/zsh/code/ci/master/tree/) [Zsh](http://www.zsh.org/) - 一款强大的命令行 shell。
- [SmartGit](http://www.syntevo.com/smartgit/) - SmartGit 是一款 Git 客户端，支持 Github 的 Pull Requests 和评论以及 SVN。
- [![Open-Source Software][oss icon]](https://gitlab.com/wireshark/wireshark/-/tree/master) [Wireshark](https://www.wireshark.org/) - Wireshark 是世界领先的网络协议分析器。它让你可以在微观层级观察你的网络上发生了什么。它是许多工业和教育行业事实上的（经常也是法律上的）标准。

### 电子书工具

- [![Open-Source Software][oss icon]](https://github.com/oguzhaninan/Buka) [Buka](https://github.com/oguzhaninan/Buka/releases) - 电子书管理。
- [![Open-Source Software][oss icon]](https://github.com/kovidgoyal/calibre) [Calibre](http://calibre-ebook.com/) - 难以置信的丑但很强大的电子书管理和转换软件。
- [![Open-Source Software][oss icon]](https://wiki.gnome.org/Apps/Evince/GettingEvince) [Evince](https://wiki.gnome.org/Apps/Evince) - Evince 是一款支持多种格式的文档查看器。Evince 的目标是用一个简单的应用取代已经存在于 GNOME 桌面的多种文档查看器。
- [FBReader](https://fbreader.org/content/fbreader-beta-linux-desktop) - 最流行的电子阅读应用之一。
- [Foxit](https://www.foxitsoftware.com/products/pdf-reader/) - Foxit Reader 8.0——获得殊荣的 PDF 阅读器。
- [Lucidor](http://www.lucidor.org/lucidor/) - Lucidor 是一个阅读和处理电子书的电脑软件。Lucidor 支持 EPUB 格式的电子书和 OPDS 格式的目录。
- [MasterPDF editor](https://code-industry.net/free-pdf-editor/) - Master PDF Editor 一款方便而智能的 Linux PDF 编辑器。
- [![Open-Source Software][oss icon]](https://git.ghostscript.com/?p=mupdf.git;a=summary) [MuPDF](http://mupdf.com/) - 一款轻量级的 PDF 和 XPS 查看器。
- [Okular](https://okular.kde.org/) - Okular 由 KDE 原始开发的通用文档查看器。Okular 可以在多个平台上工作，包括但不限于 Linux，Windows，Mac OS X，\*BSD 等等。
- [![Open-Source Software][oss icon]](https://launchpad.net/qpdfview) [qpdf](https://launchpad.net/qpdfview) - qpdfview 是一款标签页式文档查看器。
- [![Open-Source Software][oss icon]](https://github.com/Sigil-Ebook/Sigil) [Sigil](https://github.com/Sigil-Ebook/Sigil) - Sigil 是一款多平台 EPUB 电子书编辑器。

### 编辑器

- [![Open-Source Software][oss icon]](https://github.com/atom/atom) [Atom](https://atom.io/) - 21 世纪的可 hack 文本编辑器。
- [Bluefish](https://bluefish.openoffice.nl/index.html) - Bluefish 是一款面向程序员和 web 开发者的强大编辑器，带有很多编写网站，脚本和代码的选项。
- [![Open-Source Software][oss icon]](https://github.com/adobe/brackets) [Brackets](https://brackets.io/) - 懂 web 设计的现代文本编辑器。
- [![Open-Source Software][oss icon]](https://github.com/emacs-mirror/emacs) [Emacs](https://www.gnu.org/software/emacs/) - 可扩展，可个性化，免费/自由的文本编辑器——还有更多。
- [![Open-Source Software][oss icon]](https://www.geany.org/Download/Git) [Geany](https://www.geany.org/) - Geany 是一款使用了 GTK+ 工具集的文本编辑器，带有基本的集成开发环境功能。它的开发是为了成为一个小型又快速的 IDE，对其它包仅有不多的依赖。
- [Gedit](https://wiki.gnome.org/Apps/Gedit) - gedit 是 GNOME 文本编辑器。尽管以简单易用为目标，gedit 仍然是个强大的多功能编辑器。
- [![Open-Source Software][oss icon]](https://github.com/GNOME/gnome-builder) [Gnome Builder](https://wiki.gnome.org/Apps/Builder) - Powerful IDE for modern C / C++ / Bash / JavaScript development, made by Gnome Team. One of the best IDE for C/C++ developement (Cmake integrated).
- [Kakoune](http://kakoune.org/) - 受 Vim 启发。更少的击键次数带来更快的速度。多重选中。直角设计。它的命令与 vi 的相似，并且适用 Vi 的“快捷键作为文本编辑语言”模型。专注于交互，大部分命令提供直接和增量的结果，相对 Vim 还是很有竞争力的（击键次数上）。 [(Github)](https://github.com/mawww/kakoune)
- [![Open-Source Software][oss icon]](https://kate-editor.org/build-it/) [Kate](https://kate-editor.org/get-it/) - Kate 是一个多文档编辑器，从 KDE 2.2 开始就是 KDE 的一部分了。
- [Gnome Builder](https://wiki.gnome.org/Apps/Builder) - 功能强大的 IDE 用于现代 C / C ++ / Bash / JavaScript 开发，由 Gnome Team 制作。 用于 C / C ++开发的最佳 IDE 之一（Cmake 集成）
- [Lighttable](http://lighttable.com/) - 下一代代码编辑器！支持实时编码。
- [![Open-Source Software][oss icon]](https://github.com/syl20bnr/spacemacs) [Spacemacs](http://spacemacs.org) - 社区驱动的 Emacs 版本。
- [Sublime](https://www.sublimetext.com/) - 有史以来最好的编辑器之一。
- [![Open-Source Software][oss icon]](https://github.com/orbitalquark/textadept) [Textadept](https://orbitalquark.github.io/textadept/) - 程序员的极简编辑器。支持 Lua 编程语言扩展。
- [![Open-Source Software][oss icon]](https://github.com/vim/vim) [Vim](http://www.vim.org/download.php) -Vim 是一个高级文本编辑器，寻求以更完整的功能集提供事实上的 Unix 编辑器“Vi”的强大功能。无论你已经在使用 vi 或其它编辑器，它都十分有用。
- [VSCode](https://code.visualstudio.com) - Visual Studio Code 是一款轻量但强大的代码编辑器，提供 Windows，OS X 以及 Linux 版本。它内置了 JavaScript，TypeScript 以及 Node.js 支持，并且对其它语言（C++，C#，Python，PHP）还有丰富的插件系统和运行环境。

### 教育

- [![Open-Source Software][oss icon]](https://github.com/bibletime/bibletime) [BibleTime](http://bibletime.info/) - BibleTime 是一款基于 Sword 库和 Qt 工具集的圣经学习应用。
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/celestia/files/Celestia-source/1.6.1/celestia-1.6.1.tar.gz/download) [Celestia](http://celestiaproject.net/) - 免费的空间模拟器，让你在三维空间中探索我们的宇宙。
- [![Open-Source Software][oss icon]](https://github.com/opp11/chemtool/blob/master/README.md) [Chemtool](http://ruby.chemie.uni-freiburg.de/~martin/chemtool/) - Chemtool 是一款在 Linux 上绘制化学结构的小程序。
- [![Open-Source Software][oss icon]](https://code.launchpad.net/epoptes) [Epoptes](http://www.epoptes.org/) - 一款开源的计算机实验室管理和监视工具。
- [![Open-Source Software][oss icon]](https://github.com/gap-system/gap) [GAP](http://www.gap-system.org/) - 计算离散代数领域内的一个优秀系统,主要专注于计算群论的计算。
- [![Open-Source Software][oss icon]](https://gcompris.net/wiki/Developer%27s_corner) [Gcompris](http://gcompris.net/index-en.html) - GCompris 是一款高质量教育软件，由无数适合 2 到 10 岁儿童的活动组成。
- [Geogebra](https://www.geogebra.org/download) - 图形计算器，支持函数，几何，代数，微积分，统计以及 3D 数学。
- [![Open-Source Software][oss icon]](http://ftp.gnu.org/gnu/gtypist/) [GNU Typist](https://www.gnu.org/software/gtypist/index.html) - 基于 ncurses 的免费打字教学软件
- [![Open-Source Software][oss icon]](https://gitlab.com/gnukhata) [GNUKhata](http://www.gnukhata.in/) - 开源会计软件。
- [Google Earth](https://itsfoss.com/install-google-earth-ubunu/) - Google Earth 是一款虚拟地球，地图以及地理信息程序。
- [GPeriodic](http://gperiodic.seul.org/) - GPeriodic 是一个 Linux 上的元素周期表应用。

- [KDE Edu Suite](https://apps.kde.org/education/) - 基于 KDE 技术的免费教育软件。
- [![Open-Source Software][oss icon]](https://github.com/KDE/ktouch) [Ktouch](https://github.com/KDE/ktouch) - KTouch 是一款学习和练习触摸输入的程序。
- [MAPLE](http://www.maplesoft.com/products/maple/) - Maple 是一款数学软件，它结合了世界上最强大的数学引擎以及一个让它十分易于分析，探索，可视化以及解决数学问题的界面。
- [MATLAB](http://www.mathworks.com/products/matlab/?requestedDomain=www.mathworks.com) - MATLAB 平台专为剞劂工程和科学问题优化。MATLAB 让你的想法不仅仅停留在桌面。你可以在巨大的数据集上进行你的分析并按比例增加你的集群和云。
- [![Open-Source Software][oss icon]](http://maxima.sourceforge.net/project.html) [Maxima](http://maxima.sourceforge.net/) - Maxima 是一个处理符号和数值表达式的系统，包括微分，积分，泰勒级数，拉普拉斯变换，常微分方程，线性方程组....
- [![Open-Source Software][oss icon]](https://github.com/moodle/moodle) [Moodle](https://download.moodle.org/) - 在线学习课程管理系统。
- [OpenEuclid](http://coulon.publi.free.fr/openeuclide/) - OpenEuclide 是一款 2D 几何软件：数据由描述形式化的几何约束动态定义。
- [OpenSIS](http://www.opensis.com/home) - 学校管理软件。
- [![Open-Source Software][oss icon]](http://pari.math.u-bordeaux.fr/cgi-bin/gitweb.cgi?p=pari.git;a=summary) [PARI/GP](http://pari.math.u-bordeaux.fr/) - 一种针对数论中的快速计算(大数分解，代数数论，椭圆曲线...) 而设计的广泛应用的计算机代数系统。
- [![Open-Source Software][oss icon]](https://git.sagemath.org/sage.git/) [SageMath](http://www.sagemath.org/) - 一个覆盖许多数学功能的应用软件，包括代数、组合数学、计算数学和微积分。
- [![Open-Source Software][oss icon]](https://github.com/scipy/scipy) [Scipy](https://scipy.org/install.html) - SciPy 是一个基于 Python 的开源软件生态系统，面向数学，科学，以及工程学。
- [Scratch](https://scratch.mit.edu/) - 有了 Scratch，你可以编程你自己的互动故事，游戏，以及动画——并且在在线社区和其他人分享你的创造。
- [![Open-Source Software][oss icon]](https://sourceforge.net/p/stellarium/code/HEAD/tree/) [Stellarium](http://www.stellarium.org/) - Stellarium 是一个为你电脑准备的免费开源天文馆。
- [![Open-Source Software][oss icon]](https://github.com/ugeneunipro/ugene) [UGENE](http://ugene.net/) - UGENE 是一款免费开源，跨平台，基于图形界面的生物信息学软件。
- [![Open-Source Software][oss icon]](https://github.com/veyon/veyon) [Veyon](https://github.com/veyon/veyon/releases) - Veyon 是一款为老师准备的实用并且强大的教学工具。它让你有多种方式查看和控制你网络中的其它计算机。

### 电子邮件

- [Evolution](https://wiki.gnome.org/Apps/Evolution/) - Evolution 是一款个人信息管理应用，集成了邮件，日历以及地址簿功能。
- [Geary](https://wiki.gnome.org/Apps/Geary) - Geary 是一款为 GNOME 3 构建的电子邮件应用。它让你可以在一个简单，现代的界面上阅读和发送邮件。
- [Kmail](https://kde.org/applications/internet/org.kde.kmail2) - Kmail 是 KDE Plasma 套件中的邮件客户端，支持 POP3 在内的多种协议，支持收发附件，是一款功能完善的邮件应用。
- [![Open-Source Software][oss icon]](https://github.com/pulb/mailnag) [Mailnag](https://launchpad.net/~pulb/+archive/ubuntu/mailnag) - Mailnag 是一个向 POP3 和 IMAP 服务器检查新邮件的守护程序。
- [![Open-Source Software][oss icon]](https://github.com/nylas/N1)[N1](https://nylas.com/N1) - 在现代 web 上构建的可扩展桌面邮件应用。
- [![Open-Source Software][oss icon]](https://sylpheed.sraoss.jp/en/download.html#stable) [Sylpheed](http://sylpheed.sraoss.jp/en/) - 轻量化，用户友好的电子邮件客户端。
- [Thunderbird](https://www.mozilla.org/en-US/thunderbird/) - Thunderbird 是一款免费的电子邮件客户端，设置以及个性化简单方便，功能强大。
- [![Open-Source Software][oss icon]](https://github.com/Thomas101/wmail) [Wmail](https://github.com/Thomas101/wmail) - Gmail & Google Inbox 的非官方 Linux 桌面客户端。

### 文件管理器

- [7Zip](http://www.7-zip.org/download.html) - 解压任何压缩文件
- [![Open-Source Software][oss icon]](https://github.com/DoTheEvo/ANGRYsearch) [AngrySearch](https://github.com/DoTheEvo/ANGRYsearch) - Linux 文件搜索，结果输入即得。
- [![Open-Source Software][oss icon]](https://github.com/KDE/dolphin) [Dolphin](https://userbase.kde.org/Dolphin) - Dolphin 是 KDE 桌面环境的默认文件管理器，易用且功能强大。
- [Double Commander](http://doublecmd.sourceforge.net/) - Double Commander 是一款跨平台的开源双栏文件管理器。它受 Total Commander 启发并有自己的新想法。
- [![Open-Source Software][oss icon]](https://github.com/cboxdoerfer/fsearch) [fsearch](https://github.com/cboxdoerfer/fsearch) - Unix-like 系统文件搜索 ，基于 GTK+3. 支持正则表达式，文件类型搜索等。
- [![Open-Source Software][oss icon]](https://github.com/MidnightCommander) [Midnight Commander](https://www.midnight-commander.org/) - 一个功能丰富的全屏文件管理器，你可以复制，移动和删除文件以及整个文件夹树。
- [Nautilus](https://wiki.gnome.org/Apps/Nautilus) - Nautilus（Files）鹦鹉螺是为适配 Gnome 桌面设计和行为所设计的文件管理器，给用户一个简单的方式导航和管理文件。
- [![Open-Source Software][oss icon]](https://github.com/linuxmint/nemo) [Nemo](http://askubuntu.com/questions/294421/how-do-i-install-nemo-file-manager) - Nemo 是一款 Cinnamon 桌面环境下的文件管理器。
- [![Open-Source Software][oss icon]](https://github.com/shundhammer/qdirstat) [QDirStat](https://github.com/shundhammer/qdirstat#ubuntu) - 基于 Qt 的文件夹统计——不用 KDE 的 KDirStat，来自原 KDirStat 开发者的作品。
- [![Open-Source Software][oss icon]](https://github.com/ranger/ranger) [Ranger](http://ranger.nongnu.org/) - Ranger 是一款使用 VI 快捷键的终端文件管理器。
- [Synapse](https://launchpad.net/ubuntu/xenial/+source/synapse) - Linux 上最好的应用启动器。
- [![Open-Source Software][oss icon]](https://github.com/luisgg/thunar) [Thunar](https://apps.ubuntu.com/cat/applications/precise/thunar/) - Thunar 被设计成为 Xfce 4.6 的默认文件管理器，为快速和易用设计。

### 游戏

#### City Building Simulation

- [Dwarf Fortress](http://www.bay12games.com/dwarves/) - A famously complex simulation of a High Fantasy Dwarf Fortress, fight goblins, and slay massive legendary beasts. Strike the earth!
- [![Open-Source Software][oss icon]](https://github.com/OpenTTD/OpenTTD) [OpenTTD](https://www.openttd.org/) - An open-source clone of Transport Tycoon Plus with major improvements.
- [![Open-Source Software][oss icon]](https://github.com/aburch/simutrans) [Simutrans](https://www.simutrans.com/en/) - Simutrans 是一个免费而且开源的运输模拟器。
- [![Open-Source Software][oss icon]](https://github.com/unknown-horizons/unknown-horizons) [Unknown Horizons](https://unknown-horizons.org/) - A 2D realtime strategy simulation with an emphasis on economy and city building. Multiplayer currently broken.

#### Command Line Games

- [![Open-Source Software][oss icon]](https://itsfoss.com/best-command-line-games-linux/) [2048](https://itsfoss.com/best-command-line-games-linux/) - Play the famous 2048 in commandline.
- [![Open-Source Software][oss icon]](https://itsfoss.com/best-command-line-games-linux/) [Backgammon](https://itsfoss.com/best-command-line-games-linux/) - Play Backgammon in commandline.
- [![Open-Source Software][oss icon]](https://github.com/fph/bastet) [Bastet](https://github.com/fph/bastet) - Play Tetris in commandline.
- [![Open-Source Software][oss icon]](https://itsfoss.com/best-command-line-games-linux/) [Greed](https://itsfoss.com/best-command-line-games-linux/) - Tron game in the linux command line.
- [![Open-Source Software][oss icon]](https://itsfoss.com/best-command-line-games-linux/) [Ninvaders](https://itsfoss.com/best-command-line-games-linux/) - Play Space Invaders on the command line.
- [![Open-Source Software][oss icon]](https://itsfoss.com/best-command-line-games-linux/) [nSnake](https://itsfoss.com/best-command-line-games-linux/) - Play the classic Nokia snake game on the command line.
- [![Open-Source Software][oss icon]](https://github.com/alexdantas/pacman4console.debian) [Pacman4console](https://launchpad.net/ubuntu/+source/pacman4console) - Play Pacman game in console.
- [![Open-Source Software][oss icon]](https://itsfoss.com/best-command-line-games-linux/) [Tron](https://itsfoss.com/best-command-line-games-linux/) - Play the best action game, Tron in the command line.

#### Engine Re-creations (require the actual game)

- ![Open-Source Software][oss icon] [NXEngine](http://nxengine.sourceforge.net/) - A source port of Cave Story that runs natively on Linux, source needs to be built.
- [![Open-Source Software][oss icon]](https://github.com/SFTtech/openage) [openage](http://openage.sft.mx/) - Free (as in freedom) open source clone of the Age of Empires II engine, source needs to be built.
- [![Open-Source Software][oss icon]](https://github.com/OpenMW/openmw) [OpenMW](http://openmw.org) - A recreation of the Morrowind engine, expanding upon the original. It can be used to play legitimate copies of original game.
- [![Open-Source Software][oss icon]](https://github.com/OpenRA/OpenRA) [OpenRA](http://www.openra.net/) - Classic strategy games, rebuilt for the modern era. Open source.
- [![Open-Source Software][oss icon]](https://github.com/OpenRCT2/OpenRCT2) [OpenRCT2](https://openrct2.website/) - A recreation of the Rollercoaster Tycoon 2 engine. Requires the original games assests.

#### FPS

- [![Open-Source Software][oss icon]](https://gitlab.com/groups/xonotic) [ChaosEsqueAnthology Disc 1](https://sourceforge.net/projects/chaosesqueanthology/) [ChaosEsqueAnthology Disc 2](https://sourceforge.net/projects/chaosesqueanthologyvolume2/) - A modification of Xonotic which included extended weapons, maps, vehicles, buildable buildings, mounted weapons, spell casting, monsters, player characters, textures, and game mode (such as colorwar (think liquidwar))
- [![Open-Source Software][oss icon]](https://github.com/freedoom/freedoom) [Freedoom](https://freedoom.github.io/) - The Freedoom project aims to create a complete free content game based on the Doom engine.
- [![Open-Source Software][oss icon]](https://github.com/red-eclipse/base) [Red Eclipse](https://redeclipse.net/) - Red Eclipse 是一款免费、开源的 FPS 游戏，支持单人和多人游戏模式，是已中断的 Blood Frontier 项目的延续。
- ![Open-Source Software][oss icon] [Urban Terror](http://www.urbanterror.info) - A "Hollywood" tactical shooter - realism based, but the motto is "fun over realism".
- [![Open-Source Software][oss icon]](https://gitlab.com/groups/xonotic) [Xonotic](http://xonotic.org/) - 受 Unreal Tournament 以及 Quake 启发的竞技场射击游戏。
- [![Open-Source Software][oss icon]](https://osdn.net/projects/zandronum/scm/) [Zandronum](http://zandronum.com/) - Leading the way in newschool multiplayer Doom online.
- [![Open-Source Software][oss icon]](https://github.com/coelckers/gzdoom) [Zdoom](https://zdoom.org/index) - ZDoom is a source port for the modern era, supporting current hardware and operating systems and sporting a vast array of user options.

#### Gaming Applications

- [![Open-Source Software][oss icon]](https://github.com/itchio/itch) [itch](https://itch.io/) - The itch.io app. All of your downloads are kept in a single place and are automatically updated. Plenty of free games.
- [![Open-Source Software][oss icon]](https://github.com/lutris/lutris) [Lutris](https://lutris.net/) - Lutris is an open gaming platform for Linux. It helps you install and manage your games in a unified interface.
- [![Open-Source Software][oss icon]](http://repository.playonlinux.com/) [PlayOnLinux](https://www.playonlinux.com/en/) - 在 Linux 玩 Windows 游戏。
- [![Open-Source Software][oss icon]](https://github.com/libretro/RetroArch) [RetroArch](http://www.retroarch.com/) - A front-end for a lot of game emulators.
  [Steam](http://store.steampowered.com/) - 超赞的游戏平台，打开众多游戏的大门。
- [![Open-Source Software][oss icon]](https://dl.winehq.org/wine/source/) [Wine](https://www.winehq.org/) - Wine（“Wine Is Not an Emulator”的首字母缩写）是一个兼容层，可以在若干 POSIX 兼容的系统上运行 Windows 程序，比如 Linux，Mac OS X，以及 BSD

#### Machine emulators

- [![Open-Source Software][oss icon]](https://github.com/dolphin-emu/dolphin) [Dolphin Emulator](https://dolphin-emu.org/) - Dolphin is a GameCube / Wii emulator, allowing you to play games for these two platforms on PC with improvements.
- [![Open-Source Software][oss icon]](https://sourceforge.net/p/fuse-emulator/fuse/ci/master/tree/) [Fuse](https://fuse-emulator.sourceforge.net/) - Fuse (the Free Unix Spectrum Emulator) is a ZX Spectrum emulator for Unix.
- [![Open-Source Software][oss icon]](https://github.com/GNOME/gnome-video-arcade) [GNOME Video Arcade](https://wiki.gnome.org/action/show/Apps/GnomeVideoArcade?action=show&redirect=GnomeVideoArcade) - GNOME Video Arcade is a simple Mame frontend for any freedesktop.org compliant desktop environment.
- [![Open-Source Software][oss icon]](https://github.com/mamedev/mame) [MAME](http://mamedev.org/) - MAME is an Arcade Cabinet emulator that strives for accuracy, and can play a huge number of different arcade games.
- [![Open-Source Software][oss icon]](https://github.com/0ldsk00l/nestopia) [nestopia](http://0ldsk00l.ca/nestopia/) - nestopia is a Nintendo Entertainment System/Famicon emulator.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/qmc2/files/qmc2/) [qmc2](https://qmc2.batcom-it.net/) - QMC2 is the successor to QMamecat, it is a gui for MAME and a ROM manager.
- [![Open-Source Software][oss icon]](https://github.com/snes9xgit/snes9x) [Snes9x](http://www.snes9x.com/) - Is a multiplatform Super Nintendo Entertainment System emulator that has gone through many incarnations, but is still being actively developed.
- [![Open-Source Software][oss icon]](https://github.com/stella-emu/stella) [Stella](https://stella-emu.github.io/) - is an Atari 2600 Emulator that is multiplatform.
- [![Open-Source Software][oss icon]](https://github.com/visualboyadvance-m/visualboyadvance-m) [Visual Boy Advance-M](http://vba-m.com/) - A Gameboy and Gameboy Advance Emulator that is still undergoing active development and can even emulate a system link between two gameboys.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/zsnes/files/zsnes/ZSNES%20v1.51/) [ZSNES](http://www.zsnes.com/) - A capable and commonly used Super Nintendo Entertainment System/Super Famicom emulator, many consider it the gold standard in SNES/Super Famicom emulation.

#### Miscellaneous

- [![Open-Source Software][oss icon]](https://github.com/Cockatrice) [Cockatrice](https://cockatrice.github.io/) - Cockatrice 是一个开源的多平台网络桌面卡牌游戏支持程序。
- [![Open-Source Software][oss icon]](https://download.savannah.gnu.org/releases/galois/source/) [Galois](http://www.nongnu.org/galois/) - Galois is a Falling Blocks type game that isn't limited to the standard tetrominoes that most games in it's genre are limited to.
- [![Open-Source Software][oss icon]](https://wiki.gnome.org/action/show/Apps/gbrainy?action=show&redirect=gbrainy#Source_code) [GBrainy](https://wiki.gnome.org/action/show/Apps/gbrainy?action=show&redirect=gbrainy) - Gbrainy 是一个脑筋急转弯游戏，获得乐趣并且锻炼你的大脑。
- ![Nonfree][money icon] [Minecraft](https://minecraft.net/en/download/?ref=m) - Minecraft 是一个关于放置方块和冒险的游戏。探索随机生成的世界，建造惊奇的事物，从最简单的家到最伟大的城堡
- [![Open-Source Software][oss icon]](https://github.com/minetest/minetest/) [Minetest](http://www.minetest.net/) - 开源的 Minecraft 实现，由 C++ 写就（占用更少的资源），还包含模组扩展 API。
- ![Open-Source Software][oss icon] [Mudlet](mudlet.org) - A cross-platform, open source, and super fast MUD (text-only MMORPGs) client with scripting in Lua.
- [OhMyGiraffe](http://www.ohmygiraffe.com/) - 令人愉快的生存游戏。一款关于吃水果和被狮子吃的长颈鹿的游戏。
- [![Open-Source Software][oss icon]](https://github.com/alpcoskun/snake) [Snake Game](https://alpcoskun.com/snake/) - Cross-platform Classic Snake Game based on Node.js.
- [![Open-Source Software][oss icon]](https://github.com/supertuxkart/stk-code) [SuperTuxCar](https://supertuxkart.net/Main_Page) - SuperTuxKart 是一款 3D 开源的赛车竞技游戏，有不同的人物，赛道以及模式。

#### RPG

- ![Open-Source Software][oss icon] [Tales of Maj'Eyal](https://te4.org/) - Tales of Maj’Eyal (ToME) is a free, open source roguelike RPG, featuring tactical turn-based combat and advanced character building.
- ![Open-Source Software][oss icon] [Zelda Classic](http://www.zeldaclassic.com/) - A tribute to Nintendo's The Legend of Zelda with additional quests, items and challenges.
- ![Open-Source Software][oss icon] [Zelda: Mystery of Solarus DX](https://www.solarus-games.org) - A direct sequel to The Legend of Zelda: A Link to the Past on the SNES, using the same graphics and game mechanisms.

#### RTS

- [![Open-Source Software][oss icon]](http://releases.wildfiregames.com/) [0 A.D](https://play0ad.com/) - 类帝国时代的开源即时战略游戏。
- [![Open-Source Software][oss icon]](https://sourceforge.net/p/nethack/NetHack/ci/NetHack-3.6.0/tree/) [Nethack](https://www.nethack.org/) - Open-source rogue-like with ASCII graphics.
- [![Open-Source Software][oss icon]](https://github.com/triplea-game/triplea/) [TripleA](http://www.triplea-game.org/) - 世界著名的开源策略游戏。
- [![Open-Source Software][oss icon]](https://github.com/Warzone2100/warzone2100) [Warzone2100](https://wz2100.net/) - 开源即时策略/即时战术游戏。
- [![Open-Source Software][oss icon]](https://bazaar.launchpad.net/~widelands-dev/widelands/trunk/changes) [Widelands](https://www.widelands.org/) - Widelands is a open source RTS game with singleplayer campaigns and a multiplayer mode inspired by Settlers II.

#### Turn Based Strategy

- [![Open-Source Software][oss icon]](https://github.com/wesnoth/wesnoth) [The Battle for Wesnoth](http://www.wesnoth.org/) - 免费，回合制策略游戏，幻想世界主题，有单人以及在线多人对战模式。
- [Civilization5](http://www.civilization5.com/) - 席德梅尔的文明 ® 被认为是有史以来最伟大的策略经营类游戏之一。
- [![Open-Source Software][oss icon]](https://github.com/freeciv/freeciv) [FreeCiv](http://www.freeciv.org/) - Freeciv is a Free and Open Source empire-building strategy game inspired by the history of human civilization.

### 图形

- [Aftershot](http://www.aftershotpro.com/en/products/aftershot/pro/) - 一个强大的 Adobe Photoshop 替代品！
- [Agave](http://home.gna.org/colorscheme/) - Agave 是 GNOME 桌面下一个很简单的程序，让你可以从一个颜色开始生成各种不同的配色方案
- [![Open-Source Software][oss icon]](https://github.com/aseprite/aseprite/) [Aseprite](https://www.aseprite.org/) - Animated sprite editor & pixel art tool.
- [![Open-Source Software][oss icon]](http://archive.blender.org/download/source-code/index.html) [Blender](https://www.blender.org/) - 面向艺术家和小团队的免费开源的完整 3D 创作流水线。
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/cinepaint/) [Cinepaint](http://cinepaint.org/) - 开源绘画软件
- [Darktable](http://www.darktable.org/) - darktable 是一个开源的摄影处理软件，支持 RAW 文件处理
- [Digikam](http://www.digikam.org/) - digiKam 是一个高级的 Linux 数字相片管理应用
- [Fotoxx](http://www.kornelix.net/fotoxx/fotoxx.html) - Fotoxx 是一个免费开源的图像编辑和收藏管理程序。
- [![Open-Source Software][oss icon]](https://github.com/lettier/gifcurry) [Gifcurry](https://lettier.github.io/gifcurry/) - Your open source video to GIF maker built with Haskell.
- [gThumb](https://wiki.gnome.org/Apps/gthumb) - gThumb 是一款图片查看和浏览器（它还包含一个导入工具，用于从相机导入照片）。
- [![Open-Source Software][oss icon]](https://cgit.kde.org/gwenview.git/tree//?) [gwenview](https://userbase.kde.org/Gwenview) - KDE 桌面简单但强大的图片查看器和管理工具。
- [Hugin](https://hugin.sourceforge.io/) - 基于 Panorama Tools 的一款易用的跨平台全景图像工具链。
- [![Open-Source Software][oss icon]](https://github.com/inkscape/inkscape) [Inkscape](https://inkscape.org/en/) - 不管你是插画家，设计师，web 设计师还是仅仅是需要创建一些矢量图像，它都是一款强大，免费的设计工具
- [Krita](https://krita.org/en/) - 面向概念艺术家，数字画家以及插画艺术家的开源软件。
- [KColorChooser](https://kde.org/applications/graphics/org.kde.kcolorchooser) - KColorChooser 是 KDE Plasma 桌面套件中的取色器工具。
- [![Open-Source Software][oss icon]](https://github.com/OpenShot/openshot-qt) [OpenShot](http://www.openshot.org/) - OpenShot 是一款免费，易用，功能丰富的 Linxu 视频编辑器。
- [![Open-Source Software][oss icon]](https://gitlab.gnome.org/GNOME/pitivi) [Pitivi](https://www.pitivi.org/) - 一款带有漂亮直观的用户界面的免费视频编辑器，有干净的代码库和出色的社区。
- [Radiance](http://www.radiance-online.org/) - Radiance - 一款经过验证的光照模拟工具
- [![Open-Source Software][oss icon]](https://github.com/mltframework/shotcut) [Shotcut](https://www.shotcut.org/) - Shotcut 是一款免费，开源，跨平台的视频编辑器。
- [Shotwell](https://wiki.gnome.org/Apps/Shotwell) - Shotwell 是 GNOME 3 的图片管理器。
- [StopMotion](http://linuxstopmotion.org/) - Linux Stopmotion 是一款免费，开源的定格动画创作应用。它可以帮你捕捉和编辑你动画的帧，并导出为一个单独的文件。
- [Xara Extreme](http://www.xaraxtreme.org/) - Xara Xtreme for Linux 是一款强大，通用，适用于 Unix 平台（包括 Linux， FreeBSD）的图形处理程序。
- [Lightworks](https://www.lwks.com/) - 专业的非线性视频编辑程序，有免费版本可用
- [![Open-Source Software][oss icon]](https://git.finalrewind.org/feh) [Feh](https://feh.finalrewind.org/) - 轻量且快速的图片查看器。
- [![Open-Source Software][oss icon]](https://github.com/GNOME/gimp) [GIMP](https://www.gimp.org/downloads/) - GIMP 是一个自由分发的程序，可以进行照片修版，图像合成，图像编辑等操作
- [![Open-Source Software][oss icon]](http://www.graphicsmagick.org/) [GraphicsMagick](http://www.graphicsmagick.org/) - GraphicsMagick is the swiss army knife of image processing.
- [![Open-Source Software][oss icon]](https://git.gnome.org/browse/gthumb/) [Heron Animation](https://heronanimation.brunolefevre.net/) - 免费的定格动画制作程序。
- [![Open-Source Software][oss icon]](https://www.kde.org/applications/graphics/karbon/development) [Karbon](https://www.calligra.org/karbon/) - 一款开源的矢量绘图程序。
- [Kdenlive](https://kdenlive.org/) - Kdenlive 是一款非线性视频编辑器，比入门级的（线性）编辑器强大得多。 [![Open-Source Software][oss icon]](https://github.com/KDE/kdenlive)
- [![Open-Source Software][oss icon]](https://github.com/LuminanceHDR/LuminanceHDR) [Luminance HDR](https://sourceforge.net/projects/qtpfsgui/) - Luminance HDR 是一款开源的图形化用户界面应用，它的目标是提供一整套的 HDR 图像工作流程。
- [![Open-Source Software][oss icon]](https://github.com/mypaint/mypaint/releases) [Mypaint](http://mypaint.org/about/) - Mypaint 是一款配合画板使用的绘画程序。
- [![Open-Source Software][oss icon]](https://github.com/peterlevi/ojo) [Ojo](https://github.com/peterlevi/ojo) - 一款快速且漂亮的图像查看器。
- [![Open-Source Software][oss icon]](https://github.com/jonata/opendvdproducer) [Open DVD Producer](http://opendvdproducer.jonata.org/) - 现代，开源，跨平台的 DVD 镜像生产软件。
- [![Open-Source Software][oss icon]](https://github.com/oferkv/phototonic) [Photonic](https://github.com/oferkv/phototonic) - Phototonic 是一款图片查看和组织工具。
- [![Open-Source Software][oss icon]](https://github.com/PintaProject/Pinta)[Pinta](https://pinta-project.com/pintaproject/pinta/) - Pinta 是一款免费，开源的绘画及图片编辑程序。
- [![Open-Source Software][oss icon]](https://github.com/terkelg/ramme) [Ramme](https://github.com/terkelg/ramme) - 非官方 Instagram 桌面应用。
- [![Open-Source Software][oss icon]](https://github.com/Beep6581/RawTherapee) [RawTherapee](http://rawtherapee.com/) - 一款漂亮的但不那么著名的照片编辑应用。
- [![Open-Source Software][oss icon]](https://github.com/synfig/synfig) [Synfig Studio](http://www.synfig.org/) - 开源 2D 动画软件。
- [![Open-Source Software][oss icon]](https://github.com/ozmartian/vidcutter) [Vidcutter](http://vidcutter.ozmartians.com/) - 跨平台 Qt5 应用，用于快速简单的视频剪辑分段和合并编辑。

### 互联网

- [Chrome](https://www.google.com/chrome/browser/desktop/index.html) - 一款流行的浏览器，有着无数插件和应用。
- [Falkon](https://www.falkon.org) - Falkon 是基于 Qt 技术构建的网络浏览器，在力求资源占用低的前提下，具有丰富的功能，是相对火狐和 Chrome 浏览器来讲十分轻量的选择。
- [Konqueror](https://kde.org/applications/internet/org.kde.konqueror) - Konqueror 是 KDE Plasma 桌面环境中集成了文件管理和网络浏览器的工具，使用 Khtml 内核渲染网页。
- [![Open-Source Software][oss icon]](https://developer.mozilla.org/en-US/docs/Mozilla/Developer_guide) [Firefox](https://www.mozilla.org/en-US/firefox/new/) - 一款流行的浏览器，有着无数插件和应用。
- [Opera](http://www.opera.com/) - Opera 浏览器是你畅游网络所需的一切。
- [![Open-Source Software][oss icon]](https://gitweb.torproject.org/tor.git) [Tor](https://www.torproject.org/) - Tor 是免费软件和一个开放网络，帮助你对抗流量分析（一种网络检测的方式，威胁个人自由与隐私）。
- [Vivaldi](https://vivaldi.com/?lang=en) - 一款新兴的浏览器，有着许多的个性化配置。
- [Yandex](https://browser.yandex.com/desktop/main/) - 快速方便的浏览器。
- [![Open-Source Software][oss icon]](https://github.com/sindresorhus/anatine) [Anatine](https://github.com/sindresorhus/anatine) - 带有众多个性化的 twitter 桌面客户端。
- [![Open-Source Software][oss icon]](https://github.com/brave/browser-laptop) [Brave](https://brave.com/) - Brave 是 macOS，Windows，Linux 平台上一款快速，优秀的桌面浏览器。
- [![Open-Source Software][oss icon]](https://www.chromium.org/) [Chromium](http://askubuntu.com/questions/250773/how-do-i-install-chromium-from-the-command-line) - Chromium 是一个开源浏览器项目，专注于为所有用户带来更安全、快速和稳定的 web 体验。
- [![Open-Source Software][oss icon]](https://github.com/baedert/corebird) [Corebird](http://corebird.baedert.org/) - corebird 是一款原生 gtk+ twitter 桌面客户端。
- [![Open-Source Software][oss icon]](https://github.com/jangernert/FeedReader) [FeedReader](https://github.com/jangernert/FeedReader) - 一款现代的桌面应用，被设计用于补充已有的基于 web 的 RSS 账户，将所有的 web 服务优势集中到一个现代桌面应用中。
- [![Open-Source Software][oss icon]](https://github.com/vinszent/gnome-twitch) [GnomeTwitch](http://gnome-twitch.vinszent.com/) - 在你的 GNU/Linux 桌面上用这款非 Adobe-flash Twitch 客户端享受 Twitch。
- [![Open-Source Software][oss icon]](https://github.com/EragonJ/Kaku) [Kaku](https://github.com/EragonJ/Kaku/releases) - Ubuntu 开源 youtube 音乐播放器。
- [![Open-Source Software][oss icon]](https://launchpad.net/~midori/+archive/ubuntu/ppa). [Midori](https://astian.org/midori-browser/download/) - 一款轻量级的免费浏览器，在低端机器上可以完美运行。
- [![Open-Source Software][oss icon]](https://github.com/minbrowser/min) [Min](https://minbrowser.org/min/) - 智能，快速的 web 浏览器。
- [![Open-Source Software][oss icon]](https://github.com/rg3/youtube-dl). [youtube-dl](https://github.com/rg3/youtube-dl) - YouTube 视频下载神器，是一个 Python 编写的命令行视频下载器，同时支持其它一些视频网站或平台。注意：国内用户若要下载 YouTube 视频，需要给它添加 --proxy 参数，指定代理下载。

### 办公

#### 会计

- [![Open-Source Software][oss icon]](https://github.com/Gnucash/) [GnuCash](https://www.gnucash.org/) - GnuCash 是一款自由的会计程序，实现了复式记账系统。它最初的目标是开发出与 Intuit, Inc. 的 Quicken 类似的功能，但它还有针对小企业会计的功能。
- [![Open-Source Software][oss icon]](https://github.com/simonmichael/hledger) [hledger](https://hledger.org/) - 简单易用的会计工具。
- [![Open-Source Software][oss icon]](https://code.launchpad.net/homebank) [HomeBank](https://homebank.free.fr/en/index.php) - 一款免费软件，可以管理个人账目。
- [![Open-Source Software][oss icon]](https://github.com/KDE/kmymoney) [KMyMoney](https://kmymoney.org/) - KMyMoney 是 KDE 的一款个人金融管理器。它的操作类似 Microsoft Money 以及 Quicken。
- [![Open-Source Software][oss icon]](https://github.com/KDE/kmymoney) [Skrooge](https://skrooge.org/) - KDE的一款个人金融管理器.

#### 办公套件

- [Caligra Office](https://www.calligra.org/) - 提供满足办公，图形以及管理需要的综合应用套件。
- [LibreOffice](https://www.libreoffice.org/) - Linux 上的最佳办公套件。
- [OnlyOffice](https://www.onlyoffice.com/) - 最佳的 Linux 办公套件之一。
- [WPS office](http://wps-community.org/) - Linux 上的最佳办公套件之一。

#### LaTex

- [![Open-Source Software][oss icon]](https://gitlab.gnome.org/swilmet/gnome-latex) [GNOME LaTeX](https://gitlab.gnome.org/swilmet/gnome-latex) - GNOME LaTeX 是GNOME桌面下的 LaTeX 编辑器。
- [![Open-Source Software][oss icon]](https://github.com/alexandervdm/gummi) [Gummi](https://gummi.app/) - 带有模板，拼写检查以及向导的简单 latex 编辑器。
- [![Open-Source Software][oss icon]](https://git.gnome.org/browse/latexila) [LaTeXila](https://wiki.gnome.org/Apps/LaTeXila) - LaTeXila 是一款 GNOME 桌面下的 LaTeX 编辑器。
- [![Open-Source Software][oss icon]](https://github.com/yihui/lyx) [LyX](http://www.lyx.org/) - 成熟的 LaTeX 渲染文档编辑器。
- [![Open-Source Software][oss icon]](https://www.tug.org/texlive/build.html) [TexLive](https://www.tug.org/texlive/) - TeX Live 是个轻松获取和运行 TeX 文档生产系统的好方式。
- [![Open-Source Software][oss icon]](https://savannah.gnu.org/projects/texmacs) [TeXmacs](http://www.texmacs.org/) - 一款所见即所得的科学文本编辑器，并可用作一系列计算机代数系统的前端。
- [Texmaker](https://www.xm1math.net/texmaker/) - 免费跨平台的 LaTeX 编辑器。
- [![Open-Source Software][oss icon]](https://github.com/texstudio-org/texstudio) [TeXstudio](https://www.texstudio.org/) - TeXstudio 的目标是让写 LaTex 更简单更舒服。
- [![Open-Source Software][oss icon]](https://github.com/TeXworks/texworks) [TeXworks](https://www.tug.org/texworks/) - TeXworks 是一个用于编写 TeX（LaTeX、ConTeXt 等）文档的环境，具有基于统一编码、可识别 TeX 的编辑器、集成 PDF 查看器以及简洁的界面，适合普通用户和非技术用户使用。

#### Markdown

- [![Open-Source Software][oss icon]](https://github.com/wereturtle/ghostwriter) [Ghost Writer](https://ghostwriter.kde.org/) - 适用于 Windows 和 Linux 的专注性 Markdown 编辑器。
- [![Open-Source Software][oss icon]](https://github.com/fabiocolacio/Marker) [Marker](https://github.com/fabiocolacio/Marker) - Marker 是一款使用 GTK+-3.0 制作的 Linux Markdown 编辑器。
- [![Open-Source Software][oss icon]](https://github.com/marktext/marktext) [MarkText](https://github.com/marktext/marktext) - 一款简洁的文本编辑器，致力于提高写作效率。
- [![Open-Source Software][oss icon]](https://github.com/jamiemcg/remarkable) [Remarkable](https://remarkableapp.github.io/) - 一款 GFM 变体的功能强大的 Markdown 编辑器。
- [![Open-Source Software][oss icon]](https://github.com/retext-project/retext) [Retext](https://github.com/retext-project/retext) - 一款简单但功能强大的 Markdown 和 reStructuredText 编辑器。
- [Typora](https://typora.io/) - 实时可视化的 Markdown 编辑器。

#### 小说写作

- [![Open-Source Software][oss icon]](https://github.com/andreafeccomandi/bibisco) [Bibisco](https://www.bibisco.com/) - 一款注重思想和人物的小说写作软件。
- [![Open-Source Software][oss icon]](https://github.com/olivierkes/manuskript) [Manuskript](https://www.theologeek.ch/manuskript/) - 对于喜欢在写作前组织和计划的作家来说，Manuskript 是一个完美的工具。
- [![Open-Source Software][oss icon]](https://github.com/jacquetc/skribisto) [Skribisto](www.skribisto.eu) - Software for writers- [![Open-Source Software][oss icon]](https://github.com/scribusproject/scribus) [Scribus](https://www.scribus.net/downloads/) - Scribus 是一款桌面出版应用程序。
- [![Open-Source Software][oss icon]](https://github.com/trelby/trelby) [Trelby](https://www.trelby.org/) - 简单、快速且布局优雅的工具，使剧本创作变得简单。

### 生产力

- [![Open-Source Software][oss icon]](https://github.com/alarm-clock-applet/alarm-clock) [Alarm Clock](https://alarm-clock-applet.github.io/) - Alarm Clock 是一款全功能的 GNOME 或其它面板的闹钟。
- [Ambient Noise](https://itsfoss.com/ambient-noise-music-player-ubuntu/) - 在 Linux 上安装环境噪声提高专注。
- [Autokey](https://github.com/autokey/autokey) - 一款 Linux 桌面自动化工具，让你可以管理你的脚本和短语集合，并给它们分配缩写或者快捷键。
- [![Open-Source Software][oss icon]](https://github.com/KDE/basket) [Basket Note Pads](https://apps.kde.org/basket/) - 这个多用途的笔记应用帮助你记下所有类型的笔记。
- [Brightness](https://launchpad.net/indicator-brightness) - Ubuntu 下的一个亮度指示器。
- [![Open-Source Software][oss icon]](https://github.com/Cairo-Dock) [Cairo-Dock](http://glx-dock.org/) - Cairo-Dock 是一个可自定义 dock，插件，面板等的桌面界面。
- [![Open-Source Software][oss icon]](https://git.calcurse.org/calcurse.git/) [calcurse](http://calcurse.org/) - A calendar and scheduling application for the command line.
- [California](https://wiki.gnome.org/Apps/California) - Calendar 应用的完整替代方案，可使用自然语言创建事件。
- [![Open-Source Software][oss icon]](https://github.com/KELiON/cerebro) [Cerebro](https://cerebroapp.com/) - 开源生产力提升工具/MacOS Spotlight 替代工具。
- [CopyQ](http://hluk.github.io/CopyQ/) -CopyQ 是一款高级剪贴板管理器，带有编辑和脚本功能。
- [![Open-Source Software][oss icon]](https://launchpad.net/docky/+download) [Docky](www.go-docky.com/) -Docky 是一款成熟的 dock 应用，让打开常用应用和管理窗口变得更加简单和快速。
- [f.lux](https://justgetflux.com/linux.html) - 根据光线自动调节你的电脑屏屏幕显示。
- [Go For It](http://manuel-kehl.de/projects/go-for-it/) - Go For It! 是一款简单又时尚的生产力工具，主打待办清单，结合定时器让你专注于当前的任务。
- [![Open-Source Software][oss icon]](https://github.com/thezbyg/gpick) [Gpick](https://www.gpick.org/) - Gpick 让你可以从桌面任何地方取色，并且它还提供一些其它的高级特性！
- [![Open-Source Software][oss icon]](https://github.com/mohamed-aziz/mytodo) [My Todo](https://github.com/mohamed-aziz/mytodo) - Mytodo 是一款开源的待办事项程序，让你能够掌控一切。
- [My Weather Indicator](http://ubuntuhandbook.org/index.php/2016/04/weather-indicator-desktop-widget-ubuntu-16-04/) - Ubuntu 下的天气指示器和插件。
- [![Open-Source Software][oss icon]](https://sourceforge.net/p/nevernote/code/ci/master/tree/) [NixNote](https://sourceforge.net/projects/nevernote/) - EverNote 开源客户端。
- [![Open-Source Software][oss icon]](https://github.com/notepadqq/notepadqq) [Notepadqq](https://notepadqq.com/s/) - Notepadqq 是 Linux 下一款类 Notepad++ 的编辑器。
- [![Open-Source Software][oss icon]](https://github.com/nuttyartist/notes) [Notes](http://www.get-notes.com/) - 一款干净又简单的 Linux 笔记应用。
- [![Open-Source Software][oss icon]](https://github.com/Aseman-Land/Papyrus) [Papyrus](http://aseman.co/en/products/papyrus/) - Papyrus 是一款不一样的笔记管理器，它专注于安全和更佳的用户界面。Papyrus 尝试给用户提供一个易用和智能的用户界面。
- [RoundPie App](https://theroundpie.com/) - RoundPie App 使用番茄钟技术 ®，是在你当前任务管理服务上追踪你的工作流最简单的方法。
- [![Open-Source Software][oss icon]](https://userbase.kde.org/RSIBreak) [RSIBreak](https://userbase.kde.org/RSIBreak) - RSIBreak takes care of your health and regularly breaks your work to avoid repetitive strain injury.
- [Recent Noti](https://itsfoss.com/7-best-indicator-applets-for-ubuntu-13-10/) - 一款显示最近通知消息的指示器。
- [![Open-Source Software][oss icon]](https://github.com/jonls/redshift) [Redshift](http://jonls.dk/redshift/) - Redshift 根据你的周边调整你屏幕的色温。当你夜晚在屏幕前工作时，它也许能帮助你减少对眼睛的伤害。
- [![Open-Source Software][oss icon]](https://launchpad.net/shutter/) [Shutter](http://shutter-project.org/) - Shutter 基于 Linux 的系统上（比如 Ubuntu）的一款功能丰富的截屏软件。
- [Simplenote](https://simplenote.com/) - 跨平台笔记软件。Evernote 的竞争者。
- [![Open-Source Software][oss icon]](https://www.speedcrunch.org/) [SpeedCrunch](https://www.speedcrunch.org/) - 一个漂亮，开源，高精度的科学计算器。
- [![Open-Source Software][oss icon]](https://github.com/spsdco/notes) [Springseed](https://github.com/spsdco/notes) - 面向日常用户简单又漂亮的一款笔记软件。
- [Stickynote](https://itsfoss.com/indicator-stickynotes-windows-like-sticky-note-app-for-ubuntu/) - Linux 桌面的便利贴。
- [![Open-Source Software][oss icon]](https://git.tasktools.org/projects) [TaskWarrior](https://taskwarrior.org/) - Taskwarrior 是一款免费，开源的的软件，它可以从命令行管理你的待办事项列表。
- [![Open-Source Software][oss icon]](https://github.com/Jermolene/TiddlyDesktop) [TiddlyDesktop on GitHub](https://github.com/TiddlyDesktop) - [TiddlyDesktop on TiddlyWiki.com](https://github.com/TiddlyDesktop) - A desktop app for TiddlyWiki, an open-source personal wiki written in javascript, great if you're still searching for a good note-taking (and more) app.
- [Todo.txt](http://todotxt.org/) - todo.txt-专注的编辑器，用最少的组合键和点击帮助你管理你的任务。
- [![Open-Source Software][oss icon]](https://github.com/kamhix/todoist-linux) [Todoist](https://github.com/kamhix/todoist-linux) - Todoist 的非官方客户端。Todoist 是带有移动客户端的跨平台待办事项管理器，有着优秀的用户界面以及一些可选的高级特性。
- [![Open-Source Software][oss icon]](https://wiki.gnome.org/Apps/Tomboy) [Tomboy](https://wiki.gnome.org/Apps/Tomboy) - Tomboy 是一款简单易用的桌面笔记应用。
- [![Open-Source Software][oss icon]](https://github.com/jml/undistract-me) [Undistract me](https://github.com/jml/undistract-me) - 在长时间执行的终端命令结束的时候提醒你。
- [![Open-Source Software][oss icon]](https://github.com/CellarD0-0r/whatever) [Whatever](https://github.com/CellarD0-0r/whatever) - 非官方 Evernote Linux 桌面客户端。
- [![Open-Source Software][oss icon]](https://github.com/wizteam/wizqtclient) [WizNote](https://github.com/wizteam/wizqtclient) - 一个跨平台云笔记客户端。
- [![Open-Source Software][oss icon]](https://launchpad.net/zim) [Zim](https://zim-wiki.org/) - 一款图形化的文本编辑器，用来维护一系列的维基页面，对笔记和文档而言也很棒。资料以纯文本的形式保存，更便于版本管理。
- [Gnome-dictionary](https://wiki.gnome.org/Apps/Dictionary) - GNOME 下的一款强大的字典。
- [Plank](https://launchpad.net/plank) - Plank 注定要成为这个星球上最简洁的应用 dock。
- [Xmind](http://www.xmind.net/) - 脑图工具。

### 安全

- [ClamAV](https://www.clamav.net/) - Clam 防病毒
- [Fail2ban](http://www.fail2ban.org/wiki/index.php/Main_Page) - Fail2ban 扫描日志文件（例如 /var/log/apache/error_log）并将有恶意气息的 IP 封禁——过多的错误密码尝试，寻找可利用漏洞等行为。
- [GnuPG](https://www.gnupg.org/) - Gnu 隐私守卫
- [OpenSSH](http://www.openssh.com/) - OpenSSH 安全 Shell 服务器以及客户端。
- [Seahorse](https://wiki.gnome.org/Apps/Seahorse) - GnuPG 的 Gnome 前端。
- [Tcpdump](http://www.tcpdump.org/) - TCP 调试/抓包工具。
- [![Open-Source Software][oss icon]](https://github.com/usbkey9/uktools) [Uktools](https://github.com/usbkey9/uktools) - 保持您的系统与最新的内核可用。 也可以清理旧内核。
- [![Open-Source Software][oss icon]](https://code.launchpad.net/gui-ufw) [GuFW](http://gufw.org/) - Linux 世界中最简单的防火墙之一。

### 代理

- [![Open-Source Software][oss icon]](https://github.com/erguotou520/electron-ssr/releases) [electron-ssr](https://github.com/erguotou520/electron-ssr) - electron 版 跨平台 Shadowsocksr 桌面客户端。
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/ijbswa/) [Privoxy](https://www.privoxy.org/) - Privoxy 是一款无缓存 web 代理，有高级过滤功能，用以加强隐私，修改 web 页面数据以及 HTTP 头部，访问控制，还有去广告和烦人的网络垃圾的功能。
- [![Open-Source Software][oss icon]](https://github.com/haad/proxychains) [ProxyChains](https://github.com/haad/proxychains) - 强制指定的应用发起的任何 TCP 连接通过像 TOR 或其它 SOCKS4，SOCKS5 或 HTTP(S) 代理进行。
- [Shadowsocks](https://shadowsocks.org/) - 一个 socks5 代理工具，保护你的互联网流量。 [![Open-Source Software][oss icon]](https://github.com/shadowsocks/shadowsocks-qt5/releases)

### 文件共享

- [![Open-Source Software][oss icon]](https://github.com/aria2/aria2) [Aria2](https://aria2.github.io/) - aria2 是一个轻量级的多协议以及多来源命令行下载工具。
- [CrossFTP](http://www.crossftp.com/ftp-client.htm) - CrossFTP 让 FTP 相关的任务管理变得无比简单。
- [D-lan](https://www.d-lan.net/) - 一个免费的局域网文件分享软件。
- [![Open-Source Software][oss icon]](http://dev.deluge-torrent.org/wiki/Development#SourceCode)[Deluge](http://deluge-torrent.org/) - Deluge 是一款轻量级，免费的跨平台 BT 客户端。
- [Dropbox](https://www.dropbox.com/install?os=lnx) - Dropbox 是一个免费的云存储服务，让你可以将照片，文档和视频带到任何地方并轻松分享。
- [![Open-Source Software][oss icon]](https://filezilla-project.org/sourcecode.php)[Filezilla](https://filezilla-project.org/) - 免费的 FTP 解决方案
- [Flareget](https://flareget.com/) - 全功能，多线程下载管理器以及加速器。
- [ownCloud](https://owncloud.com/products/desktop-clients/) - ownCloud 的目标是不论在哪都能让你访问到你的文件。
- [PushBullet](https://www.pushbullet.com/) - Pushbullet 将你的设备连接，让它们感觉像是一体的。
- [![Open-Source Software][oss icon]](https://github.com/qbittorrent/qBittorrent)[qBittorent](http://www.qbittorrent.org/) - qBittorrent 计划的目标是提提供一个 µTorrent 的自由软件替代方案。
- [Quazaa](https://sourceforge.net/projects/quazaa/) - 一款跨平台的多重网络点对点（P2P）文件分享客户端。
- [SpiderOak](https://spideroak.com/) - 关注隐私的团队及商业实时协作。
- [![Open-Source Software][oss icon]](https://github.com/syncthing/syncthing)[Syncthing](https://syncthing.net/) - Syncthing 用开放，值得信赖，去中心化的方案取代专有的同步和云服务。
- [Teamviewer](https://www.teamviewer.com/) - PC 远程控制/远程访问软件，对个人使用免费。
- [![Open-Source Software][oss icon]](https://trac.transmissionbt.com/browser/trunk) [Transmission](https://www.transmissionbt.com/download/) - 简单，轻量级，多平台的 torrent 客户端。
- [![Open-Source Software][oss icon]](https://ugetdm.com/downloads/source-code/) [uGet](http://ugetdm.com/) - Linux 下最好的下载管理器。
- [uTorrent](http://www.utorrent.com) - 优雅，高效的 torrent 下载。
- [Vuze](http://www.vuze.com) - Bittorrent 点对点下载客户端，满足你的所有 torrent 下载需要。
- [![Open-Source Software][oss icon]](https://github.com/meganz/MEGAsync) [Mega](https://mega.nz/#sync) - 在你的电脑和 MEGA 云存储间轻松自动同步。

### 终端

- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/dban/) [DBAN](https://dban.org/) - Delete information stored on hard disk drives (HDDs) in PC laptops, desktops or servers.
- [GnomeTerminal](https://help.gnome.org/users/gnome-terminal/stable/) - Linux 世界广泛预装的终端模拟器。
- [Guake](http://guake.org/) - Guake 是 Gnome 下的一款顶部下拉式的终端。
- [![Open-Source Software][oss icon]](https://github.com/zeit/hyper) [Hyper](https://hyper.is/) - 基于 web 技术打造的终端。
- [Konsole](https://konsole.kde.org/) - KDE 桌面环境的最佳终端。
- [![Open-Source Software][oss icon]](rxvt.http://cvs.schmorp.de/rxvt-unicode/) [RXVT-Unicode](http://software.schmorp.de/pkg/rxvt-unicode.html) - rxvt-unicode 是著名的终端模拟器的一个分支。
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/rxvt/) [RXVT](https://rxvt.sourceforge.net/) - 一款 X11 终端模拟器，流行的‘xterm’替代品。
- [![Open-Source Software][oss icon]](https://launchpad.net/sakura) [Sakura](https://launchpad.net/sakura) - 简单但是强大，基于 libvte 的终端模拟器，支持 utf-8 并且通过 gtk+ 和 pango 库提供输入法。
- [![Open-Source Software][oss icon]](https://github.com/gnome-terminator/terminator) [Terminator](https://gnome-terminator.org/) - 很明显 Linux 上最强大的终端模拟器是功能丰富的 Terminator（终结者）。
- [![Open-Source Software][oss icon]](https://github.com/gnunn1/terminix) [Terminix](https://gnunn1.github.io/terminix-web/#packages) - 使用 GTK+3 的 Linux 平铺终端模拟器。
- [![Open-Source Software][oss icon]](https://github.com/thestinger/termite) [Termite](https://github.com/thestinger/termite) - 以键盘为中心，基于 VTE 的终端，旨在在一个支持平铺和/或标签的窗口管理器中使用。
- [![Open-Source Software][oss icon]](https://github.com/nonstop/termit/wiki) [Termit](https://github.com/nonstop/termit/wiki) - 基于 vte 库的简单终端模拟器，可通过 Lua 扩展。
- [![Open-Source Software][oss icon]](https://github.com/cosmos72/twin) [Twin](https://github.com/cosmos72/twin/) - Fast, lightweight text-mode window environment with mouse support. Enables multiple terminals in a single Linux console, terminal or X11 window. It can be detached (keeps running in background) and reattached to a different console, terminal or X11 server. Works on Linux, Mac OS X and BSD
- [![Open-Source Software][oss icon]](https://github.com/railsware/upterm) [Upterm](https://github.com/railsware/upterm) - Upterm (formerly Black Screen) is an IDE in the world of terminals. Strictly speaking, it's both a terminal emulator and an interactive shell based on [Electron](https://electron.atom.io/).
- [Xterm](http://invisible-island.net/xterm/) - Xterm 是一个 X 窗口系统的终端模拟器。它给不直接使用窗口系统的程序提供了 DEC VT102 和 Tektronix 4014 兼容终端。
- [Yakuake](https://apps.kde.org/yakuake/) - 一款基于 KDE Konsole 技术的 Quake 风格的终端模拟器。

### 实用工具

- [Actionaz](http://actionaz.org/) - Ubuntu/Linux 下的任务自动化工具。
- [![Open-Source Software][oss icon]](https://github.com/albertlauncher/albert) [Albert](https://github.com/albertlauncher/albert) - Linux 桌面超赞的应用启动器。
- [![Open-Source Software][oss icon]](https://github.com/bleachbit/bleachbit) [Bleach bit](https://www.bleachbit.org/) - BleachBit 快速释放磁盘空间并不知疲倦地守卫你的隐私。释放缓存，删除 cookie，清除互联网浏览历史，清理临时文件，删除日志，以及更多功能...
- [Brasero](https://wiki.gnome.org/Apps/Brasero) - CD/DVD 烧录软件。
- [Caffeine](https://launchpad.net/caffeine) - 防止 ubuntu 自动睡眠。
- [Convertall](https://sourceforge.net/projects/convertall/) - 全能单位换算。
- [![Open-Source Software][oss icon]](https://github.com/thjaeger/easystroke) [EasyStroke](https://github.com/thjaeger/easystroke/wiki#download) - Easystroke 是一个 X11 手势识别应用。
- [Enpass](https://www.enpass.io/) - Enpass 安全地管理你的密码和重要信息，让你的生活更轻松。
- [GD map](https://gdmap.sourceforge.net/) - 可视化磁盘使用量的工具。
- [![Open-Source Software][oss icon]](https://github.com/antonio-malcolm/gloobus-preview) [Gloobus-Preview](https://github.com/antonio-malcolm/gloobus-preview) - 它能给你提供文件的快速预览，类似 [Sushi](https://github.com/GNOME/sushi)。
- [![Open-Source Software][oss icon]](https://github.com/codito/gnome-pomodoro) [Gnome Pomodoro](https://gnomepomodoro.org/#download) - 全功能 GNOME 番茄钟。
- [GnomePie](http://simmesimme.github.io/news/2016/08/24/gnome-pie-069) - Linux 桌面的一个圆形启动器。[![Open-Source Software][oss icon]](http://simmesimme.github.io/news/2016/08/24/gnome-pie-069)
- [Gnormalize](http://gnormalize.sourceforge.net/) - 音频转换工具。
- [GParted](http://gparted.org/) - Ubuntu/Linux 磁盘分区工具。
- [![Open-Source Software][oss icon]](https://github.com/haecker-felix/gradio/releases/) [GRadio](https://github.com/haecker-felix/gradio/releases/) - Ubuntu linux 无线电广播软件。
- [Handbrake](https://handbrake.fr/) - 视频转换工具。
- [ImageMagik](http://www.imagemagick.org/script/index.php) - ImageMagick 是一套图片修改和处理的命令行工具。
- [![Open-Source Software][oss icon]](https://github.com/fossfreedom/indicator-sysmonitor)[Indicator-SysMonitor](https://github.com/fossfreedom/indicator-sysmonitor) - 一款可显示 cpu 温度，内存，网速，cpu 使用率，公网 IP 地址以及联网状态的应用指示器。
- [![Open-Source Software][oss icon]](https://github.com/keepassx/keepassx)[KeePassX](https://www.keepassx.org/) - 跨平台密码管理器。KeePass 的移植成果。
- [KeePass](https://www.keepass.info/) - 专注于 Windows 的密码管理器，通过 Mono 提供一些跨平台支持。
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/kvm/files/)[KVM](http://www.linux-kvm.org/page/Main_Page) - KVM （表示 Kernel-based Virtual Machine，基于内核的虚拟机）是一个支持虚拟化扩展（Intel VT 或 AMD-V）Linux 的完全虚拟化方案。
- [Peazip](http://www.peazip.org/) - 解压任何文件的工具。
- [![Open-Source Software][oss icon]](https://github.com/phw/peek) [Peek](https://github.com/phw/peek/releases) - 一款让你能够从你的屏幕录制简短的动画 GIF 图片的小工具。
- [Powertop](https://01.org/powertop/downloads) - 能源消耗诊断工具。
- [![Open-Source Software][oss icon]](http://git.wpitchoune.net/psensor.git/)[Psensor](http://wpitchoune.net/psensor/) - Linux 图形化硬件温度监视器。
- [Pulse Audio](https://wiki.ubuntu.com/PulseAudio) - 通过个性化的配置改善 Linux 的音频。
- [Remarkable](https://remarkableapp.github.io/) - Ubuntu/Linux 上最佳的 Markdown 编辑器。
- [![Open-Source Software][oss icon]](https://github.com/FreeRDP/Remmina) [Remmina](http://www.remmina.org/wp/) - 一款功能丰富的远程桌面应用，支持 Linux 以及其它 Unix。
- [![Open-Source Software][oss icon]](https://github.com/sahib/rmlint) [rmlint](https://rmlint.readthedocs.io/en/latest/) - rmlint finds space waste and other broken things on your filesystem and offers to remove it.
- [![Open-Source Software][oss icon]](https://github.com/oguzhaninan/Stacer) [Stacer](https://github.com/oguzhaninan/Stacer) - Ubuntu 系统优化器。
- [![Open-Source Software][oss icon]](https://github.com/GNOME/sushi) [Sushi](https://github.com/GNOME/sushi) - Sushi 是 GNOME 桌面文件管理器鹦鹉螺（Nautilus）的快速预览工具。
- [![Open-Source Software][oss icon]](https://github.com/MaartenBaert/ssr) [SimpleScreenRecorder](http://www.maartenbaert.be/simplescreenrecorder/) - SimpleScreenRecorder 是一款功能丰富的录屏软件，支持 X11 和 openGL。它拥有基于 Qt 的图形化用户界面。
- [Synaptic](http://www.nongnu.org/synaptic/) - Synaptic 是一款图形化的 apt 包管理程序。
- [Systemload](http://www.omgubuntu.co.uk/2014/06/system-monitor-indicator-ubuntu-ppa) - 在状态栏显示系统负载。
- ![Open-Source Software][oss icon] [TightVNC](http://www.tightvnc.com/) - 免费，轻量，快速且可靠的远程控制/远程桌面软件。
- [TLP](http://linrunner.de/en/tlp/docs/tlp-linux-advanced-power-management.html) - 优化 Linux 下的电池表现。
- [![Open-Source Software][oss icon]](https://github.com/Kilian/Trimage) [Trimage](https://trimage.org/) - 跨平台无损 PNG 及 JPG 文件调整工具。
- [![Open-Source Software][oss icon]](https://github.com/gerardpuig/ubuntu-cleaner) [UbuntuCleaner](https://github.com/gerardpuig/ubuntu-cleaner) - 使用 Ubuntu Cleaner 轻松清理你的 ubuntu 系统。
- [![Open-Source Software][oss icon]](https://github.com/Ulauncher/Ulauncher/) [ULauncher](http://ulauncher.io/) - Linux 应用启动器。
- [![Open-Source Software][oss icon]](https://github.com/peterlevi/variety-slideshow) [Variety](http://peterlevi.com/variety/) - Variety 是一款开源的 Linux 壁纸更换软件，拥有众多功能，轻巧又易用。
- [![Open-Source Software][oss icon]](https://www.virtualbox.org/wiki/Contributor_information) [Virtualbox](https://www.virtualbox.org/wiki/Downloads) - VirtualBox 是一款通用的 x86 硬件虚拟机软件，面向服务器，桌面以及嵌入式。
- [WallpaperChange](https://apps.ubuntu.com/cat/applications/raring/wallch/) - 自动更换你的壁纸。
- [![Open-Source Software][oss icon]](https://github.com/rcaelers/workrave) [Workrave](https://www.workrave.org/) - 一款帮助恢复以及防止重复性劳损的程序（RSI）。
- [![Open-Source Software][oss icon]](https://github.com/KaOS-Community-Packages/xdm) [Xtreme Download Manager](http://xdman.sourceforge.net/) - 一款有着新鲜用户界面的下载管理器。
- [LastPass](https://lastpass.com/misc_download2.php) - 跨平台密码管理器。
- [![Open-Source Software][oss icon]](https://clonezilla.org/related-links/) [Clonezilla](http://clonezilla.org/) - Clonezilla 是一款分区以及磁盘镜像/克隆程序，类似 True Image® 或 Norton Ghost®。
- [![Open-Source Software][oss icon]](https://launchpad.net/cpug) [CPU-G](http://www.omgubuntu.co.uk/2016/09/monitor-battery-life-ubuntu-cpu-g) - 轻松监控你的 Ubuntu 笔记本的电池寿命。
- [![Open-Source Software][oss icon]](https://github.com/wereturtle/ghostwriter) [Ghost Writer](https://ghostwriter.kde.org/) - 一款专注的 Windows 及 Linux Markdown 编辑器。
- [PlexyDesk](http://www.omgubuntu.co.uk/2016/09/plexydesk-widgets-linux-desktop-ppa) - Plexydesk 支持 Linux 多插件工作空间/桌面。
- [![Open-Source Software][oss icon]](http://github.com/wereturtle/ghostwriter) [Ghost Writer](https://ghostwriter.kde.org/) - 一款专注的 Windows 及 Linux Markdown 编辑器。
- [PlexyDesk](https://www.omgubuntu.co.uk/2016/09/plexydesk-widgets-linux-desktop-ppa) - Plexydesk 支持 Linux 多插件工作空间/桌面。

### 视频

- [![Open-Source Software][oss icon]](https://github.com/xylosper/bomi) [Bomi Player](https://bomi-player.github.io/) - 一款强大易用的多媒体播放器。
- [![Open-Source Software][oss icon]](https://github.com/GNOME/cheese) [Cheese](https://wiki.gnome.org/Apps/Cheese) - Cheese 用你的摄像头拍照和录像，还能加上神奇的特效，让你能够和别人分享快乐。
- [![Open-Source Software][oss icon]](https://github.com/xbmc/xbmc) [Kodi](https://kodi.tv/about/) - 一款获得殊荣的免费开源（GPL）软件，支持视频，音乐，图片，游戏以及更多内容的媒体中心。
- [![Open-Source Software][oss icon]](https://github.com/pculture/miro) [Miro](http://www.getmiro.com/) - 免费，开放的视频，音乐以及互联网电视应用；它从成千上万的资源中带来视频频道，并且还有比其它平台更丰富的免费高清资源。
- [![Open-Source Software][oss icon]](https://github.com/lettier/movie-monad) [Movie Monad](https://lettier.github.io/movie-monad) - A free and simple to use video player made with Haskell.
- [MPlayer](http://www.mplayerhq.hu/design7/news.html) - MPlayer 是一款支持多种系统和各种视频的视频播放器。
- [![Open-Source Software][oss icon]](https://github.com/mpv-player/mpv) [MPV](https://www.mpv.io) - 一款免费，开源，跨平台的媒体播放器。
- [![Open-Source Software][oss icon]](https://sourceforge.net/p/smplayer/code/HEAD/tree/) [SMPlayer](http://smplayer.sourceforge.net/) - 内置解码器的免费媒体播放器。可播放所有的音频和视频格式。
- [![Open-Source Software][oss icon]](https://gitlab.com/jonata/subtitld) [Subtitld](https://subtitld.org/) - Subtitld 是一款用于编辑、转录和创建字幕的开源软件。
- [SVP](https://www.svp-team.com/w/index.php?title=Main_Page) - SVP 让你可以使用帧插值在你的桌面电脑上观看任何视频，就像高端电视和投影仪支持的那样。
- [![Open-Source Software][oss icon]](https://www.videolan.org/vlc/download-sources.html) [VLC](http://www.videolan.org/vlc/index.html) - VLC 是一个免费且开源的跨平台媒体播放器以及框架，可以播放大多数格式的多媒体文件以及 DVS，音频 CD，VCD，以及各种流媒体协议。

### 其它

- [![Open-Source Software][oss icon]](https://displaycal.net/#download) [DisplayCAL](https://displaycal.net/) - Open Source Display Calibration and Characterization powered by ArgyllCMS.
- [![Open-Source Software][oss icon]](https://github.com/fontforge/fontforge) [FontForge](https://fontforge.org/) - Free (libre) font editor for Windows, Mac OS X and GNU+Linux.
- [GrubCustomizer](https://launchpad.net/grub-customizer) - Grub Customizer 是一个让你可以配置 GRUB2/BURG 设置和启动项的图形化界面。 [![Open-Source Software][oss icon]](https://code.launchpad.net/grub-customizer)
- [Infinality bundle & fonts](https://bohoomil.com/) - _注：Infinality 目前开发者不再维护，如果在滚动发行版上，可能不可用_。Infinality bundle & fonts 是一个开源项目，致力于让 Linux 管理员和个人用户有个轻松的方式改善字体渲染质量。
- [![Open-Source Software][oss icon]](https://github.com/MycroftAI/mycroft-core) [Mycroft](https://github.com/MycroftAI/mycroft-core) - 给所有人的 A.I.

## 命令行工具

- [![Open-Source Software][oss icon]](https://github.com/fph/bastet) [Bastet](https://github.com/fph/bastet) - 在命令行玩俄罗斯方块。
- [![Open-Source Software][oss icon]](https://github.com/jarun/Buku) [Buku](https://github.com/jarun/Buku) - 命令行书签管理器。
- [![Open-Source Software][oss icon]](https://github.com/AlDanial/cloc) [Cloc](https://github.com/AlDanial/cloc) - Count Lines of Code: cloc counts blank lines, comment lines, and physical lines of source code in many programming languages.
- [Clipgrab](https://clipgrab.org/) - A friendly downloader for YouTube and other sites.
- [![Open-Source Software][oss icon]](https://github.com/jarun/ddgr) [ddgr](https://github.com/jarun/ddgr) - DuckDuckGo from the command line.
- [![Open-Source Software][oss icon]](https://github.com/ssimunic/Daily-Reddit-Wallpaper) [Daily Reddit Wallpaper](https://github.com/ssimunic/Daily-Reddit-Wallpaper) - 开机时将壁纸更换为 /r/wallpapers 或其它子版块的今日最高票壁纸。
- [![Open-Source Software][oss icon]](https://github.com/LubuntuFu/fishfry) [Fishfry](https://github.com/LubuntuFu/fishfry) - 将 fish 的历史记录替换成为渗透测试人员量身定制的高效版本以及方便新手学习。
- [![Open-Source Software][oss icon]](https://github.com/jarun/googler) [Googler](https://itsfoss.com/review-googler-linux/) - 从命令行 Google 一切。
- [![Open-Source Software][oss icon]](https://github.com/hishamhm/htop) [htop](http://hisham.hm/htop/) - 带有改进的特性和用户体验的 top。
- [![Open-Source Software][oss icon]](https://github.com/mps-youtube/mps-youtube) [mps-youtube](https://github.com/mps-youtube/mps-youtube) - 基于终端的程序，用于搜索，流媒体以及下载音乐。这个实现使用 Youtue 作为内容源，能够播放和下载视频和音频。
- [![Open-Source Software][oss icon]](https://gitlab.com/muttmua/mutt) [Mutt](http://www.mutt.org/) - 终端邮件客户端，vim 快捷键，强大灵活可定制。
- [![Open-Source Software][oss icon]](https://github.com/dylanaraps/neofetch) [Neofetch](https://github.com/dylanaraps/neofetch/releases) - 快速，高度定制化的系统信息获取脚本，支持 Linux，MacOS，iOS，BSD，Solaris，Android，Haiku，GNU Hurd，MINIX，AIX 以及 Windows。
- [![Open-Source Software][oss icon]](https://github.com/alexdantas/pacman4console.debian) [Pacman4console](https://launchpad.net/ubuntu/+source/pacman4console) - 在控制台玩吃豆人。
- [![Open-Source Software][oss icon]](https://github.com/nvbn/thefuck) [TheFuck](https://github.com/nvbn/thefuck) - 杰出的应用，它能纠正你的输入的错误命令。
- [![Open-Source Software][oss icon]](https://github.com/tmux/tmux) [Tmux](https://tmux.github.io/) - 它让你在一个终端中在多个程序间方便地切换，分离他们（保持在后台运行）并另一个终端中重新连接上去。以及还有好多事情可以做。
- [PathPicker](https://github.com/facebook/PathPicker) - 一个简单的命令行工具，用来处理选择 bash 文件输出时的问题
- [wicd-curses](https://wiki.archlinux.org/index.php/wicd#Running_Wicd_in_Text_Mode) - 命令行 WiFi 连接管理器。
- [十佳命令行工具](http://lifehacker.com/399468/top-10-command-line-tools)

## 桌面环境

- [![Open-Source Software][oss icon]](https://github.com/solus-project/budgie-desktop) [Budgie](https://solus-project.com/budgie/) - Budgie 是一个面向现代用户思想设计的桌面环境，专注于简洁与优雅。
- [![Open-Source Software][oss icon]](https://github.com/linuxmint/Cinnamon) [Cinammon](http://cinnamon.linuxmint.com/) - Cinnamon 努力提供一种传统的用户体验。Cinnamon 是一个 GNOME 3 的 fork。
- [Enlightenment](https://www.enlightenment.org) - Enlightenment 源自 1996 年的 X11 桌面管理器项目，整体外观颇具复古风尚，桌面布局可以使用经典（类 Windows）和 Dock（类 Mac）两种，也可以自定义布局和风格，是 KDE 和 Gnome 之外，不可多得的优秀桌面环境项目，但项目目前仍在开发阶段，最新版本为 0.23.1。
- [![Open-Source Software][oss icon]](https://github.com/GNOME/gnome-flashback) [GNOME Flashback](https://wiki.gnome.org/Projects/GnomeFlashback) - GNOME Flashback 是 GNOME 3 的一个 shell，最初叫 GNOME fallback 模式。桌面的布局和底层技术都与 GNOME 2 相似。
- [![Open-Source Software][oss icon]](https://github.com/GNOME/gnome-desktop) [Gnome](https://www.gnome.org/) - GNOME 桌面环境是一个有吸引力且直观的的桌面，同时有现代（GNOME）和经典（GNOME Classic）会话模式。
- [![Open-Source Software][oss icon]](https://github.com/KDE/plasma-desktop) [KDE Plasma](https://www.kde.org/workspaces/plasmadesktop/) - KDE Plasma 桌面环境是一个熟悉的工作环境。Plasma Desktop 提供现代桌面环境体验所需的所有工具，所以你可以从开始就充满生产力。
- [![Open-Source Software][oss icon]](https://github.com/lxde) [LXDE](http://lxde.org/) - Lightweight X11 Desktop Environment （轻量化 X11 桌面环境）是一个快速且节能的桌面环境。
- [![Open-Source Software][oss icon]](https://github.com/lxde/lxqt) [LXQt](http://lxqt.org/) - LXQt 是 LXDE 的 Qt 移植和即将到来的版本，轻量化的桌面环境。
- [![Open-Source Software][oss icon]](https://github.com/mate-desktop/) [Mate](http://mate-desktop.com/) - Mate 用传统隐喻给 Linux 用户提供一个直观又有吸引力的桌面。MATE 是 GNOME 2 的一个 fork。
- [Pantheon](https://elementary.io/) - Pantheon 是最初为发行版 elementary OS 创建的桌面环境，同时也是它的默认桌面环境。
- [Unity](https://unity.ubuntu.com/) - Unity 是 GNOME 的一个 shell，由 Canonical 为 Ubuntu 设计。 [guide](http://www.omgubuntu.co.uk/2016/04/ubuntu-16-04-unity-8-desktop-progress-video) on how to install unity 8 on Ubuntu 16.04.
- [![Open-Source Software][oss icon]](https://github.com/xfce-mirror) [Xfce](https://www.xfce.org/) - Xfce 体现了模块化和可重用的传统 UNIX 哲学。

## 显示管理

### 控制台

- [![Open-Source Software][oss icon]](https://github.com/ghost1227/cdm) [CDM](https://github.com/ghost1227/cdm) - 超简化，又功能丰富，用 bash 写就的登陆管理器。
- [![Open-Source Software][oss icon]](https://github.com/dopsi/console-tdm) [Console TDM](https://github.com/dopsi/console-tdm) - 纯 bash 写就的 xinit 扩展。
- [![Open-Source Software][oss icon]](https://github.com/spanezz/nodm) [nodm](https://github.com/spanezz/nodm) - 简约的自动登陆显示管理器。

### 图形界面

- [![Open-Source Software][oss icon]](https://github.com/tomas/entrance) [Entrance](http://enlightenment.org) - 基于 EFL 的显示管理器，高度实验性质。
- [![Open-Source Software][oss icon]](https://github.com/GNOME/gdm) [GDM](https://wiki.gnome.org/Projects/GDM) - GNOME 显示管理器。
- [KDM](http://www.kde.org) - KDE4 显示管理器（不再继续开发）。
- [![Open-Source Software][oss icon]](https://github.com/davvid/lightdm) [LightDM](https://www.freedesktop.org/wiki/Software/LightDM) - 跨桌面显示管理器，可以使用任何工具集写就的各种前端。
- [LXDM](https://sourceforge.net/projects/lxdm/) - LXDE 显示管理器，可以独立于 LXDE 桌面环境使用。
- [![Open-Source Software][oss icon]](https://github.com/linuxmint/mdm) [MDM](https://github.com/linuxmint/mdm) - MDM 显示管理器，在 Linux Mint 中使用， GDM 2 的一个 fork。
- [![Open-Source Software][oss icon]](https://github.com/sddm/sddm) [SDDM](https://github.com/sddm/sddm) - 基于 QML 的显示管理器，KDE 4 的 kdm 的继任者；Plasma 5 以及 LXQt 推荐。
- [![Open-Source Software][oss icon]](https://github.com/gsingh93/slim-display-manager) [SLiM](https://sourceforge.net/projects/slim.berlios/) - 轻量且优雅的图形化登录解决方案（不再继续开发）。
- [![Open-Source Software][oss icon]](https://github.com/bbidulock/xdm) [XDM](https://www.x.org/archive/X11R7.5/doc/man/man1/xdm.1.html) - 带有 XDMCP，主机选择支持的 X 显示管理器。

## 窗口管理

### 合成器

- ![Open-Source Software][oss icon] [Picom](https://github.com/yshui/picom) - Picom 是一款独立的合成管理器，适合同没有原生提供合成功能的窗口管理器一同使用。
- [![Open-Source Software][oss icon]](https://cgit.freedesktop.org/xorg/app/xcompmgr)
  [Xcompmgr](https://cgit.freedesktop.org/xorg/app/xcompmgr) - Xcompmgr 是一个简单的合成管理器，能够渲染下拉阴影，使用 transset 工具的话，还可以实现简单的窗口透明。

### 叠加式窗口管理器

- [![Open-Source Software][oss icon]](https://github.com/venam/2bwm) [2bwm](https://github.com/venam/2bwm) - 快速的浮动窗口管理，有两个特殊边界，基于 XCB 库，由 mcwm 衍生。
- [![Open-Source Software][oss icon]](https://github.com/bbidulock/blackboxwm) [Blackbox](http://blackboxwm.sourceforge.net) - 快速，轻量化的 X 窗口系统窗口管理器，没有那些烦人的库依赖。
- [![Open-Source Software][oss icon]](https://github.com/fluxbox/fluxbox) [Fluxbox](http://fluxbox.org) - 基于 Blackbox 0.61.1 代码的 X 窗口管理器。
- [![Open-Source Software][oss icon]](https://github.com/danakj/openbox) [Openbox](http://openbox.org) - 高度可配置，带有可扩展标准支持的下一代窗口管理器。

### 平铺式窗口管理器

- [![Open-Source Software][oss icon]](https://github.com/baskerville/bspwm) [Bspwm](https://github.com/baskerville/bspwm/wiki) - bspwm 是一个平铺式窗口管理器，将窗口以二叉树的叶结点的方式展现。
- [![Open-Source Software][oss icon]](https://github.com/herbstluftwm/herbstluftwm) [Herbstluftwm](https://herbstluftwm.org) - 使用 Xlib 和 Glib 的手工平铺式窗口管理器。

### 动态窗口管理器

- [![Open-Source Software][oss icon]](https://github.com/awesomeWM/awesome) [awesome](https://awesome.naquadah.org) - 高度可配置，下一代 X 框架窗口管理器。
- [![Open-Source Software][oss icon]](https://github.com/cdown/dwm) [dwm](http://dwm.suckless.org) - X 动态窗口管理器。它以平铺，单片镜以及浮动布局的方式管理窗口。
- [![Open-Source Software][oss icon]](https://github.com/i3/i3) [i3](https://i3wm.org) - 完全重写的平铺式窗口管理器。
- [![Open-Source Software][oss icon]](https://github.com/conformal/spectrwm) [spectrwm](https://github.com/conformal/spectrwm/wiki) - X11 小型动态窗口管理器，很大程度上受了 xmonad 和 dwm 的启发。
- [![Open-Source Software][oss icon]](https://github.com/xmonad/xmonad) [xmonad](http://xmonad.org) - 动态平铺式 X11 窗口管理器，用 Haskell 写就和配置。

## 设置

- [什么是 Linux](https://www.linux.com/what-is-linux)
- [Linux 基础术语](http://www.makeuseof.com/tag/linux-confusing-key-terms-definitions/)
- [选择最适合你的发行版](http://i.imgur.com/TV21DgN.jpg)

### Arch Linux

- [新手指南](https://wiki.archlinux.org/index.php/Beginners%27_guide)
- [安装指南](https://wiki.archlinux.org/index.php/Installation_guide)
- [通用推荐](https://wiki.archlinux.org/index.php/General_recommendations)
- [应用列表](https://wiki.archlinux.org/index.php/List_of_applications)

### CentOS

- [官方网站](https://www.centos.org)
- [关于](https://wiki.centos.org/About)
- [下载](https://wiki.centos.org/Download)
- [指南](https://www.centos.org/docs/)
- [提示和技巧](https://wiki.centos.org/TipsAndTricks)
- [常见问题](https://www.centos.org/forums/faq.php?sid=4e6d260284c7936505dcf75564717272)

### openSUSE

- [openSUSE 社区官网]（https://www.opensuse.org）
- [什么是 openSUSE](https://www.techopedia.com/definition/28543/opensuse)
- [尝试 openSUSE 的理由](http://www.pcworld.com/article/222065/5_reasons_to_try_opensuse_114.html)
- [新手常见问题解答](https://en.opensuse.org/openSUSE:OpenSUSE_for_beginners)
- [如何安装 openSUSE](https://en.opensuse.org/Portal:Installation)
- [openSUSE 容器化: Kubic(基于 openSUSE MicroOS)](https://kubic.opensuse.org)
- [评测](https://www.linux.com/news/opensuse-leap-421-review-most-mature-linux-distribution)

### Ubuntu

- [什么是 Ubuntu](<https://en.wikipedia.org/wiki/Ubuntu_(operating_system)>)
- [如何安装 Ubuntu](http://www.ubuntu.com/download/desktop/install-ubuntu-desktop)
- [如何安装 Ubuntu 和 Windows 双系统启动](http://www.everydaylinuxuser.com/2014/05/install-ubuntu-1404-alongside-windows.html)
- [安装 ubuntu 后要做什么](http://www.omgubuntu.co.uk/2016/04/10-things-to-do-after-installing-ubuntu-16-04-lts)

### 其它发行版

> 待添加

## 论坛

### Arch Linux Forums

- [Arch Linux 论坛](https://bbs.archlinux.org/)
- [Arch Linux ARM 论坛](https://archlinuxarm.org/forum/viewforum.php?f=31)

### CentOS Forums

- [CentOS 论坛](https://www.centos.org/forums/)

### Ubuntu Forums

- [Ubuntu 论坛](https://ubuntuforums.org/)
- [Ask Ubuntu](askubuntu.com/)

### openSUSE Forums

- [openSUSE 论坛](https://forums.opensuse.org/forum.php)

### IRC 频道

- [#ubuntu](https://webchat.freenode.net/?channels=ubuntu)

### Linux 新闻，应用，以及更多...

- [OMG!Ubuntu](http://www.omgubuntu.co.uk/)
- [ITSFOSS](https://itsfoss.com/)
- [Linux 官方](https://www.linux.com/)
- [Webupd8](http://www.webupd8.org/)
- [Noobslab](http://www.noobslab.com/)
- [Make use of](http://www.makeuseof.com/service/linux/)
- [TecMint](http://www.tecmint.com/)
- [AllTop](http://linux.alltop.com/)
- [Unixmen](https://www.unixmen.com/)
- [DistroWatch](http://distrowatch.com/)
- [Phoronix](http://www.phoronix.com/)
- [Dedoimedo](http://www.dedoimedo.com/)
- [How-To Geek](http://www.howtogeek.com/t/linux/)
- [Liliputing](http://liliputing.com/)
- [FAMILUG](http://www.familug.org/)
- [Ubuntu Geek](http://www.ubuntugeek.com/)

### Reddit

- [Arch Linux](https://www.reddit.com/r/archlinux/)
- [CentOS](https://www.reddit.com/r/CentOS/)
- [Linux](https://www.reddit.com/r/linux/)
- [Open Source](https://www.reddit.com/r/opensource/)
- [Ubuntu](https://www.reddit.com/r/Ubuntu/)
- [Unix Porn](https://www.reddit.com/r/unixporn/)
- [Linux Kernel](https://www.reddit.com/r/kernel/)
- [Linux Gaming](https://www.reddit.com/r/linux_gaming/)

## 学习 Linux

- [学习 Linux 命令](http://linuxcommand.org/)
- [GNU/Linux 命令行工具总结](http://tldp.org/LDP/GNU-Linux-Tools-Summary/html/book1.htm)
- [学习 Linux](https://linuxjourney.com/)
- [Linux 课程](https://www.edx.org/course/introduction-linux-linuxfoundationx-lfs101x-0)
- [Linus 口袋指南](http://www.opencore.eesc.usp.br/bruno/livros/Linux_Pocket_Guide.pdf)
- [Linux Bash 命令行 - Tek Linux](https://www.youtube.com/watch?v=ltjPIpilqow)

## Linux Hacking/开发

- [内核新手](https://kernelnewbies.org/)
- [Linux Insides](https://0xax.gitbooks.io/linux-insides/content/index.html)
- [Linux 内核](http://www.tldp.org/LDP/tlk/tlk.html)
- [Linux 内核归档（官方站点）](https://www.kernel.org/)
- [Linux Kernel Internals (PDF)](http://www.tldp.org/LDP/lki/lki.pdf)
- [Linux 内核邮件列表归档](https://lkml.org/)
- [Linux 内核模块编程指南（PDF）](http://www.tldp.org/LDP/lkmpg/2.6/lkmpg.pdf)

## 贡献者

[**贡献者列表**](https://github.com/VoLuong/Awesome-Ubuntu-Linux/graphs/contributors) :

1.  [LuongVo](https://github.com/VoLuong)
2.  [anewuser](https://github.com/anewuser)
3.  [nathanmusoke](https://github.com/nathanmusoke)
4.  [bpearson](https://github.com/bpearson)
5.  [orestisf1993](https://github.com/orestisf1993)
6.  [lasseborly](https://github.com/lasseborly)
7.  [sebasspf](https://github.com/sebasspf)
8.  [buivnhai](https://github.com/buivnhai)
9.  [ankurk91](https://github.com/ankurk91)
10. [mAzurkovic](https://github.com/mAzurkovic)
11. [bocklund](https://github.com/bocklund)
12. [grebenschikov](https://github.com/grebenschikov)
13. [fareez-ahamed](https://github.com/fareezahamed)
14. [MichaelAquilina](https://github.com/MichaelAquilina)
15. [Wamadahama](https://github.com/wamadahama)
16. [Alasin](https://github.com/alasin)
17. [LYF610400210](https://github.com/LYF610400210)
18. [willmtemple](https://github.com/willmtemple) 纠正库名称
19. [jakub-olczyk](https://github.com/jakub-olczyk)
20. [shakib609](https://github.com/shakib609)
21. [talisk](https://github.com/talisk)
22. [smdrz](https://github.com/smdrz)
23. [bishoyh](https://github.com/bishoyh)
24. [Voicu](https://github.com/vpop)
25. [ryandaniels](https://github.com/ryandaniels)
26. [mame98](https://github.com/mame98)
27. [Kastmeski](https://github.com/kasmetski)
28. [johnjago](https://github.com/johnjago)
29. [shuliandre](https://github.com/shuliandre)
30. [stelariusinfinitek](https://github.com/stelariusinfinitek)
31. [tnga](https://github.com/tnga)
32. [hg8](https://github.com/hg8)
33. [ChrisLeeGit](https://github.com/ChrisLeeGit)
34. [alim0x](https://github.com/alim0x)
35. [Spacebody](https://github.com/Spacebody)
36. [AyoIsaiah](https://github.com/ayoisaiah)
37. _在 @ reddit.com/r/linux & reddit.com/r/ubuntu & vozforums.com 上每个提出建议和赞赏的人_
    ...

(_以上列表更新于 10th January 2017_)

**[⬆ 返回顶部](#目录)**

<br>

## 贡献指南

> 将**应用**的名称放入列表。
> 链接到它的**主页**或**安装指南**。
> 再给应用写一小段**简短的介绍** + 添加**图标**。
> 确保应用放在了**合适的主题**下。
> 如果应用不在以上任何一个**已有的主题**内，为它**新建一个**主题。
> 确保所有项都是按**字母表顺序排序**的。

_标有 ![Open-Source Software][oss icon] 的是开源软件并且链接到源代码。标有 的意为免费（就如免费的啤酒）。_

<br>

_原作者注：最近我收到了一些关于列表中一些应用软件的质量的反馈。我自己测试了其中的大部分应用（但不是全部）。如果你对应用有任何问题：-> 去往开发页面（如果有的话）-> 给开发提个 issue -> 在这里提个 issue 以便我考虑是否将应用移出列表。记住：所有东西都有它自己的质量，所以这里永远不会有“最佳应用”或“选择性的列表”，谢谢。_

<br>

## 许可证

[![Creative Commons License](http://i.creativecommons.org/l/by/4.0/88x31.png)](https://creativecommons.org/licenses/by/4.0/)

该作品签署于 [Creative Commons Attribution 4.0 International License](http://creativecommons.org/licenses/by/4.0/)。

[oss icon]: https://cdn.rawgit.com/iCHAIT/awesome-osx/master/media/oss.svg
[freeware icon]: https://cdn.rawgit.com/iCHAIT/awesome-osx/master/media/free.svg

<!-- markdown-link-check-enable -->
