<!-- markdown-link-check-disable -->

# Increíble Software de Linux

![Tux](img/tux.png)

🐧 este repositorio es una colección de **increíbles** aplicaciones Linux y herramientas para **cualquier persona usuaria y desarrolladora**.
<br>
🐧 Siéntete libre de **contribuir** / **dar star** / **hacer fork** / **crear un pull request**. Cualquier **recomendación** y **sugerencia** son bienvenidos.

**Reconocimiento:** _Todo lo escrito a continuación es desde mi propia experiencia en la escuela y después leyendo varios materiales. No soy ni un profesional ni un experto, pero un estudiante apasionado. Cualquiera puede abrir una discusión en la sección "Issues", o hacer un "pull request" si considera que algo debe ser modificado o agregado._

- versión china : [aquí](https://github.com/LewisVo/Awesome-Linux-Software/blob/master/README_zh-CN.md) o [aquí](https://github.com/alim0x/Awesome-Linux-Software-zh_CN) o [aquí](https://github.com/0xE8551CCB/awesome-linux-software-cn).
- versión alternativa en español : [aqui](https://github.com/SaintFenix/Awesome-Linux-Software/blob/master/README_es-ES.md).
- versión Portugués Brasileño : [aquí](https://github.com/LewisVo/Awesome-Linux-Software/blob/master/README_pt-BR.md).
- versión inglesa : [aquí](https://github.com/LewisVo/Awesome-Linux-Software/blob/master/README.md).
- versión tailandés : [aquí](https://github.com/LewisVo/Awesome-Linux-Software/blob/master/README_th-TH.md).

## Índice de Contenidos

- [Aplicaciones](#aplicaciones)
  - [Audio](#audio)
  - [Clientes de mensajería instantánea](#clientes-de-mensajería-instantánea)
  - [Copia de seguridad y recuperación](#copia-de-seguridad-y-recuperación)
  - [Personalización del escritorio](#personalización-del-escritorio)
  - [Desarrollo de software](#desarrollo-de-software)
  - [Utilitarios de libros electrónicos](#utilitarios-de-Libros-electrónicos)
  - [Editor de texto](#editor-de-texto)
  - [Software educativo](#software-educativo)
  - [Herramientas para email](#herramientas-para-email)
  - [Administrador de archivos](#administrador-de-archivos)
  - [Juegos](#juegos)
  - [Gráficos](#gráficos)
  - [Herramientas para internet](#herramientas-para-internet)
  - [Oficina](#oficina)
  - [Productividad](#productividad)
  - [Software de proxy](#software-de-proxy)
  - [Seguridad](#seguridad)
  - [Intercambio de archivos](#intercambio-de-archivos)
  - [Emulador de terminal](#emulador-de-terminal)
  - [Herramientas](#herramientas)
  - [Vídeo](#vídeo)
  - [Wiki software](#wiki-software)
  - [Diverso](#diverso)
- [Herramientas de línea de comandos](#Herramientas-de-línea-de-comandos)
- [Los Entornos des escritorios](#Los-Entornos-des-escritorios)
- [Gestors de pantallas](#Gestors-de-pantallas)
  - [Console](#console)
  - [Gráficos](#gráficos)
- [Gestor de ventanas](#gestor-de-ventanas)
  - [Gestor de composición](#gestor-de-composición)
  - [Gestor de apilables](#gestor-de-apilables)
  - [Gestor de embaldosado](#Gestor-de-embaldosado)
  - [Gestor de dinámico](#Gestor-de-dinámico)

---

- [Instalación de](#instalación-de)
  - [ArchLinux](#arch-linux)
  - [Bodhi](#bodhi)
  - [CentOS](#centos)
  - [Fedora](#fedora)
  - [openSUSE](#opensuse)
  - [Ubuntu](#ubuntu)
- [Los Foros](#los-Foros)
  - [ArchLinux Foros](#arch-linux-foros)
  - [CentOS Foros](#centos-foros)
  - [Fedora Foros](#fedora-foros)
  - [Ubuntu Foros](#ubuntu-foros)
  - [openSUSE Foros](#opensuse-foros)
  - [Canales de IRC](#canales-de-irc)
  - [Linux News, Aplicaciones y mucho más](#Linux-News,-aplicaciones-y-mucho-más)
  - [Reddit](#reddit)
- [Aprender linux](#aprender-linux)
- [Desarrollo de linux](#desarrollo-de-linux)
- [Linux avanzado](#Linux-avanzado)
- [Las otras listas impresionantes](#las-otras-listas-impresionantes)
- [Contribuidores](#contribuidores)
- [Reglas para contribuir](#reglas-para-contribuir)
- [Cómo contribuir](#cómo-contribuir)

---

## Aplicaciones

### Audio

_para consultar una lista más larga de software de audio oprima [aquí](https://github.com/nodiscc/awesome-linuxaudio)_

- [![Open-Source Software][oss icon]](https://github.com/sourcefabric/Airtime) [Airtime](https://www.sourcefabric.org/software/airtime) - Un programa para radiodifusión y emisoras de radio.
- [![Open-Source Software][oss icon]](https://ardour.org/development.html) [Ardour](https://ardour.org/) - Un programa para grabar sonido, editarlo y remixar en Linux
- [![Open-Source Software][oss icon]](http://audacious-media-player.org/developers) [Audacious](http://audacious-media-player.org/) - Una programa código abierto, poder reproductor de audio que no requiere muchos recursos.
- [![Open-Source Software][oss icon]](https://github.com/audacity/audacity) [Audacity](http://www.audacityteam.org/download/linux/) - Gratis y código abierto, software Multiplataforma para grabar y editar sonido.
- [![Open-Source Software][oss icon]](https://bazaar.launchpad.net/~audio-recorder/audio-recorder/trunk/files) [Audio Recorder](https://launchpad.net/~audio-recorder) - una grabadora de audio fácil de usar disponible en los repositorios de software de ubuntu.
- [![Open-Source Software][oss icon]](https://github.com/Superjo149/auryo) [Auryo](http://auryo.com/) - Una programa Multiplataforma de SoundCloud® no oficial para linux.
- [![Open-Source Software][oss icon]](https://github.com/CDrummond/cantata) [Cantata](https://www.linux-apps.com/content/show.php/Cantata?content=147733) - Un demonio programa de música hecho con Qt5 hay un cliente para Linux, windows, macOS.
- [![Open-Source Software][oss icon]](https://github.com/clementine-player/Clementine) [Clementine](https://www.clementine-player.org/) - Es útil para escuchar música con el algoritmo de compresión con o sin pérdida de formato de audio.
- [![Open-Source Software][oss icon]](https://github.com/cmus/cmus) [Cmus](https://cmus.github.io/#download) - Un pequeño y rápido programa de console para escuchando música para los systemas operativos Unix-like.
- [![Open-Source Software][oss icon]](https://github.com/linuxdeepin/deepin-music) [Deepin Music](https://www.deepin.org/en/original/deepin-music/) - Una programa desarrollado de la equipo de Deepin Technology, es un reproductor de música local.
- [![Open-Source Software][oss icon]](https://github.com/enzo1982/freac) [fre:ac](https://www.freac.org/index.php) - fre:ac es un conversor de audio gratuito y un destripador de CD compatible con varios formatos y codificadores populares. Actualmente se convierte entre formatos MP3, MP4/M4A, WMA, Ogg Vorbis, FLAC, AAC, WAV y Bonk.
- [![Open-Source Software][oss icon]](http://gnormalize.sourceforge.net) [Gnormalize](http://gnormalize.sourceforge.net/) - Un convertidor de audio y extractor de cd con los algoritmos "ReplayGain normalization", un editor de metadatos y un reproductor de audio. El programa utiliza gtk2-perl cuando se ejecuta en linux.
- [![Open-Source Software][oss icon]](https://github.com/MarshallOfSound/Google-Play-Music-Desktop-Player-UNOFFICIAL-) [Google Play Music](https://www.googleplaymusicdesktopplayer.com/) - Una multiplataforma no oficial pero hermosa reproductor de medios para musica de Google Play.
- [![Open-Source Software][oss icon]](https://github.com/gpodder/gpodder) [Gpodder](https://gpodder.github.io/) - Un agregador de podcasts y cliente.
- [![Open-Source Software][oss icon]](https://github.com/haecker-felix/gradio/releases/) [GRadio](https://github.com/haecker-felix/gradio/releases/) - Software de radio para Linux Ubuntu.
- [![Open-Source Software][oss icon]](https://github.com/mtytel/helm) [Helm](http://tytel.org/helm/) - Un Sintetizador en Software, que puede funcionar solo o con muchos complementos como: LV2, VST, VST3 o AU plugin.
- [![Open-Source Software][oss icon]](https://github.com/hydrogen-music/hydrogen) [Hydrogen](http://hydrogen-music.org/) - Uno caja de ritmos avanzado para GNU/Linux.
- [![Open-Source Software][oss icon]](https://github.com/trazyn/ieaseMusic) [ieaseMusic](https://github.com/trazyn/ieaseMusic) - es una aplicación multiplataforma para escuchar música en la música de NetEase.
- [![Open-Source Software][oss icon]](https://github.com/KDE/k3b) [K3b](http://www.k3b.org/) - Un creador de CD y DVD para linux, optimizado para KDE.
- [Kid3Qt](https://apps.ubuntu.com/cat/applications/precise/kid3-qt/) - Para editar etiquetas de archivos, por ejemplo el nombre del artista, el álbum, el género y el año de los archivos de música.
- [KxStudio](http://kxstudio.linuxaudio.org/) - Una colección de aplicaciones y plugins para la producción de audio profesional.
- [![Open-Source Software][oss icon]](https://github.com/LibreTime/libretime) [Libretime](http://libretime.org/) - Una alternativa a Airtime, Libretime es un programa para la radiodifusión.
- [![Open-Source Software][oss icon]](https://github.com/LMMS/lmms) [LMMS](https://lmms.io/download/#linux) - Este programa es un fabricante de música para tu PC.
- [![Open-Source Software][oss icon]](https://github.com/gnumdk/lollypop) [Lollypop](https://wildskyf.github.io/lollypop-web/) - Una programa capaz reproductor de medios de GNOME.
- [![Open-Source Software][oss icon]](https://github.com/emilioastarita/lyricfier) [Lyricfier](https://github.com/emilioastarita/lyricfier) - Un programa para encontrar letras paraSpotify.
- [![Open-Source Software][oss icon]](https://github.com/ColinDuquesnoy/MellowPlayer) [Mellow Player](https://colinduquesnoy.github.io/MellowPlayer/) - Una aplicación integrada en la nube para reproductor de medios para tu PC.
- [![Open-Source Software][oss icon]](https://github.com/mixxxdj/mixxx) [Mixxx](http://www.mixxx.org/download/) - Uno software gratis Disc-jockey para crear música y es una alternativa de Traktor.
- [![Open-Source Software][oss icon]](https://github.com/mopidy/mopidy) [Mopidy](https://www.mopidy.com/) - Un servidor de música extensible escrito en python.
- [![Open-Source Software][oss icon]](https://github.com/KeitIG/museeks) [Museek](http://museeks.io/) - Un reproductor de música multi-plataforma simple.
- [![Open-Source Software][oss icon]](https://github.com/musescore/MuseScore) [MuseScore](https://musescore.org) - una aplicación para la creación, reproducción e impresión de partituras.
- [![Open-Source Software][oss icon]](https://github.com/metabrainz/picard) [MusicBrainz Picard](https://picard.musicbrainz.org/) - Picard es una aplicación multiplataforma para edición de multidatos de música.
- [![Open-Source Software][oss icon]](https://about.musixmatch.com/apps/) [MusixMatch](https://about.musixmatch.com/apps/) - Una programa para búsqueda de las letras de canciones. Se puede sincronizar con la música.
- [Netease Music](https://music.163.com/#/download) - Un reproductor de música para netease - un servicio de música en China.
- [![Open-Source Software][oss icon]](https://github.com/nukeop/nuclear) [Nuclear](http://nuclear.gumblert.tech/) - Basado en Electron, Nuclear es una programa multiplatforma para el reproductor de medios puede utilizar múltiples fuentes para la reproducción.
- [Ocenaudio](http://www.ocenaudio.com/whatis) - Una programa multiplataforma fácil, es rápido e funcional editor de música. Es un buen programa para editar y analizar archivos de música.
- [![Open-Source Software][oss icon]](https://github.com/PedroHLC/osdlyrics) [OSD Lyrics](https://aur.archlinux.org/packages/osdlyrics-git/) - El programa muestra letras para otros reproductores des medios.
- [![Open-Source Software][oss icon]](https://github.com/gkarsay/parlatype) [Parlatype](http://gkarsay.github.io/parlatype/) - Un reproductor de audio para transcribir escrito para GNOME.
- [![Open-Source Software][oss icon]](https://github.com/pithos/pithos) [Pithos](https://pithos.github.io/) - Un cliente nativo para Pandora en linux.
- [![Open-Source Software][oss icon]](https://github.com/wwmm/pulseeffects) [PulseEffect](https://github.com/wwmm/pulseeffects) - Un limitador, compresor, creador de reverberación y efectos de volumen automático para aplicaciones de Pulseaudio.
- [![Open-Source Software][oss icon]](https://github.com/quodlibet/quodlibet) [Quod Libet](https://quodlibet.readthedocs.io) - Un reproductor de medios GTK +, fue diseñado para grandes colecciones de música. Tiene algoritmos capaces de búsqueda y puede reproducir podcastos y radio del Internet.
- [![Open-Source Software][oss icon]](https://github.com/ebruck/radiotray-ng) [RadioTray-NG](https://github.com/ebruck/radiotray-ng) - Un reproductor de medios de internet para Linux.
- [![Open-Source Software][oss icon]](https://github.com/GNOME/rhythmbox) [Rhythmbox](https://wiki.gnome.org/Apps/Rhythmbox) - Un reproductor de medios de GNOME.
- [![Open-Source Software][oss icon]](https://sayonara-player.com/downloads/#Source) [Sayonara Player](https://sayonara-player.com/downloads/) - Un pequeño y rápido reproductor de medios para Linux. Fue escrito en C ++, y es apoyado por el marco QT.
- [![Open-Source Software][oss icon]](https://github.com/multani/sonata/) [Sonata](http://www.nongnu.org/sonata/) - Sonata es un reproductor de música con una interfaz fácil de usar, para reproducir su colección de música del "Music Player Daemon" (MPD).
- [![Open-Source Software][oss icon]](https://launchpad.net/soundconverter/trunk/2.1.6) [Soundconverter](https://soundconverter.org/) - un popular convertidor de archivos de audio. Es fácil de usar, y muy rápido.
- [![Open-Source Software][oss icon]](https://wiki.gnome.org/Apps/SoundJuicer) [SoundJuicer](http://www.howtogeek.com/howto/20126/rip-audio-cds-with-sound-juicer/) - una programa para Ripear uno CD para GNOME.
- [![Open-Source Software][oss icon]](https://github.com/Soundnode/soundnode-app) [Soundnode](https://soundnode.github.io/soundnode-website/) - Una aplicacion de código abierto para SoundCloud.
- [![Open-Source Software][oss icon]](https://github.com/devinhalladay/spotio) [Spotio](https://github.com/devinhalladay/spotio) - Un tema inspirado en Rdio para la aplicación del applicacion Spotify oficial.
- [![Open-Source Software][oss icon]](https://github.com/VCVRack/Rack) [VCV Rack](https://vcvrack.com/) - Un sintetizador modular virtual de código abierto.
- [![Open-Source Software][oss icon]](https://github.com/needle-and-thread/vocal) [Vocal](http://vocalproject.net/) - Un cliente para podcasts para el moderno escritorio.

### Clientes de mensajería instantánea

#### Clientes no oficiales

- [![Open-Source Software][oss icon]](https://github.com/sindresorhus/caprine) [Caprine](https://github.com/sindresorhus/caprine) - Un programa que está muy bien diseñado para Facebook.
- [![Open-Source Software][oss icon]](https://github.com/chatty/chatty) [Chatty](http://chatty.github.io/) - Chatty es una a cliente twitch para mensajes.
- [![Open-Source Software][oss icon]](https://github.com/stanfieldr/ghetto-skype) [GhettoSkype](https://github.com/stanfieldr/ghetto-skype) - Un Software código abierto envoltura el programma web para Skype.
- [![Open-Source Software][oss icon]](https://github.com/Aluxian/Facebook-Messenger-Desktop) [Messenger for Desktop](https://messengerfordesktop.com/#download) - Una Programa para mensajería instantánea de Facebook.
- [![Open-Source Software][oss icon]](https://github.com/raelgc/scudcloud/) [ScudCloud](https://github.com/raelgc/scudcloud/) - Un Cliente para slack no oficial para Linux.
- [![Open-Source Software][oss icon]](https://github.com/yakyak/yakyak) [YakYak](https://github.com/yakyak/yakyak) - Cliente de Google Hangouts para escritorio.

#### Mensajería instantánea cliente herramientas

- [![Open-Source Software][oss icon]](https://github.com/Cog-Creators/Red-DiscordBot) [Red Discord Bot](https://index.discord.red/) - "Red Discord Bot" este una programa servidor auto-alojamiento para Discord. El Programa puede instalar más "Cogs" para funciones adicionales. Puede funcionar en un Raspberri Pi.

#### Clientes todo en uno

- [![Open-Source-Software][oss icon]](https://github.com/meetfranz/franz) [Franz](http://meetfranz.com/) - Franz es un programa de mensajería que agrega muchos servicios de mensajería instantánea.
- [![Open-Source Software][oss icon]](https://developer.pidgin.im/) [Pidgin](https://pidgin.im/) - Un cliente de mensajería instantánea que es universal.
- [![Open-Source Software][oss icon]](https://github.com/saenzramiro/rambox) [Rambox](http://rambox.pro/) - Un programa que es libre y de código abierto, Rambox agrega mensajería instantánea y correo electrónico en un solo lugar.

#### Clientes des IRC

- [![Open-Source Software][oss icon]](https://github.com/hexchat) [HexChat](https://hexchat.github.io/) - Hexchat es una cliente para IRC que está diseñada desde XChat, sin embargo en comparación con Xchat es gratis y de código abierto.
- [![Open-Source Software][oss icon]](https://github.com/irssi/irssi) [Irssi](https://github.com/irssi/irssi) - Irssi es una cliente para mensajería instantánea de IRC. Es un cliente modular que es conocido por el modo de texto.
- [![Open-Source Software][oss icon]](https://github.com/kvirc/KVIrc) [KVIrc](https://www.kvirc.net/) - KVIrc es un cliente IRC gratuito diseñado a partir de QT.

#### Clientes oficiales

- [![Open-Source-Software][oss icon]](hhttps://sourceforge.net/p/beebeep/code/HEAD/tree/) [BeeBEEP](http://beebeep.sourceforge.net) - BeeBEEP es un mensajero instantáneo LAN de fuente abierta. Puede hablar y compartir archivos con cualquier persona dentro de su red de área local. No necesita un servidor, simplemente descárguelo, descomprímalo e inícielo. Simple, rápido y seguro.
- [![Open-Source Software][oss icon]](https://github.com/dino/dino) [Dino](https://dino.im) - Un cliente de mensajería instantánea jabber / XMPP que es moderno.
- [Discord](https://discord.com/) - y todo en una sola voz y servicio de mensajería instantánea de texto, diseñado para los jugadores, y funciona en computadoras y teléfonos celulares.
- [![Open-Source Software][oss icon]](https://github.com/gitterHQ/services) [Gitter](https://gitter.im/) - Gitter, es un servicio para mensajería comunitaria, colaboración y descubrimiento de comunidades que es muy fácil de usar. Se centra en los desarrolladores.
- [![Open-Source Software][oss icon]](https://github.com/jitsi) [Jitsi](https://jitsi.org/) - Jitsi es una aplicación de mensajería instantánea multiplataforma gratuita y de código abierto. Funciona en Windows, Linux, Mac OS X y droid.
- [![Open-Source Software][oss icon]](https://github.com/qTox/qTox) [qTox](https://qtox.github.io/) - Un mensajero instantáneo que es seguro y puede hacer video. El programa utiliza Computación Distribuida.
- [![Open-Source Software][oss icon]](https://ring.cx/en/documentation/faq#node-106) [Ring](https://ring.cx/) - Ring es una plataforma de comunicación abierta y universal que se ocupa de la privacidad del usuario.
- [![Open-Source Software][oss icon]](https://github.com/vector-im/riot-web) [Riot](https://riot.im/) - Una colaboración Matrix para la web.
- [Skype](https://www.skype.com/en/) - Skype es un mensajero gratuito en línea.
- [Slack](https://slack.com/downloads/linux) - Una mensajería en tiempo real, con archivado y buenas capacidades de búsqueda para los equipos.
- [![Open-Source Software][oss icon]](https://github.com/telegramdesktop/tdesktop) [Telegram](https://desktop.telegram.org/) - Una aplicación de mensajería que se centra en la velocidad y la seguridad. Es facil y gratis.
- [Viber](https://www.viber.com/en/products/linux) - Viber le permite hablar con otros usuarios de la red de Viber, de forma gratuita a cualquier país.
- [![Open-Source Software][oss icon]](https://github.com/weechat) [Weechat](https://weechat.org/) - Weechat es un cliente rápido y extensible para la mensajería instantánea.
- [![Open-Source Software][oss icon]](https://github.com/wireapp) [Wire](https://wire.com/en/) - Una aplicación de mensajería instantánea con comunicación segura y completa privacidad.

### Copia de seguridad y recuperación

- [![Open-Source Software][oss icon]](https://borgbackup.readthedocs.io/en/stable/development.html) [Borg Backup](https://borgbackup.readthedocs.io/en/stable/) - Una herramienta sencilla para la copia de seguridad de datos.
- [![Open-Source Software][oss icon]](https://launchpad.net/deja-dup) [Deja Dup](https://www.linux.com/learn/total-system-backup-and-recall-deja-dup) - Una sencilla herramienta de copia de seguridad que admite el cifrado.
- [![Open-Source Software][oss icon]](https://launchpad.net/duplicity) [Duplicity](http://duplicity.nongnu.org/) - Duplicity crea copias de seguridad de directorios mediante la creación de archivos cifrados en el formato Tar.
- [![Open-Source Software][oss icon]](https://www.freefilesync.org/download.php) [FreeFileSync](https://www.freefilesync.org) - FreeFileSync es un software de comparación y sincronización de carpetas que crea y administra copias de seguridad de todos sus archivos importantes. En lugar de copiar cada archivo cada vez, FreeFileSync determina las diferencias entre una carpeta de origen y de destino y transfiere solo la cantidad mínima de datos necesarios.
- [![Open-Source Software][oss icon]](https://github.com/cgsecurity/testdisk) [Photorec](http://www.cgsecurity.org/wiki/PhotoRec) - Photorec es un software de recuperación de datos de archivos, diseñado para volver a crear archivos de datos incorrectos. Funciona en discos compactos y tarjetas de memoria de la cámara.
- [![Open-Source Software][oss icon]](https://borgbackup.readthedocs.io/en/stable/) [Qt4-fsarchiver](https://sourceforge.net/projects/qt4-fsarchiver/) - Una GUI del programa de archivado para fsarchiver, está diseñada para guardar y restaurar particiones de disco, carpetas y tablas MBR / GPT. Funciona en Ubuntu, Opensuse y Fedora.
- [![Open-Source Software][oss icon]](https://github.com/ncw/rclone) [rclone](http://rclone.org/) - Rclone es un programa de línea de comandos para sincronizar archivos y directorios de la nube. También permite copia de seguridad cifrada.
- [![Open-Source Software][oss icon]](https://github.com/rsnapshot/rsnapshot.git) [rsnapshot](http://rsnapshot.org/) - La programa rsnapshot es una utilidad de línea de comandos basada en rsync para realizar instantáneas temporizadas de equipos locales y remotos.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/systemrescuecd/files/sysresccd-x86/) [System Rescue CD](https://www.system-rescue.org/SystemRescueCd_Homepage) - SystemRescueCD es un disco de rescate del sistema linux diseñado para ser ejecutado desde un CD-ROM o memoria USB para reparar un sistema después de un problema.
- [![Open-Source Software][oss icon]](https://github.com/cgsecurity/testdisk) [Test Disk](http://www.cgsecurity.org/wiki/TestDisk) - TestDisk es un programa de recuperación gratuito que fue diseñado para recuperar particiones rotas o hacer que los discos que no se pueden arrancar funcionen de nuevo.
- [![Open-Source Software][oss icon]](https://code.launchpad.net/timeshift) [Timeshift](https://launchpad.net/timeshift) - TimeShift es una utilidad de restauración del sistema que toma copias de seguridad incrementales de un sistema informático utilizando rsync y enlaces duros.

### Personalización del escritorio

#### Los temas de escritorio

- [![Open-Source Software][oss icon]](https://github.com/adapta-project/adapta-gtk-theme) [Adapta Theme](https://github.com/tista500/Adapta) - Un tema adaptativo hecho de GTK + se basa en las directrices de Google Material Design.
- [![Open-Source Software][oss icon]](https://github.com/EliverLara/Ant) [Ant Theme](http://www.omgubuntu.co.uk/2017/09/ant-flat-gtk-theme-bloody-bite) - Ant es un diseño plano de GTK para Ubuntu y otros escritorios Linux basados en GNOME. Tiene tres variedades: vanilla, Bloody, y Dracula.
- [![Open-Source Software][oss icon]](https://github.com/jnsh/arc-theme) [Arc Theme](https://github.com/jnsh/arc-theme) - Un tema plano con elementos transparentes.
- [![Open-Source Software][oss icon]](https://github.com/solus-project/evopop-gtk-theme) [EvoPop Theme](https://github.com/solus-project/evopop-gtk-theme) - Evopop es un moderno tema de escritorio para Solus Linux. Es un tema plano con algún uso de sombras.
- [![Open-Source Software][oss icon]](https://github.com/anmoljagetia/Flatabulous) [Flatabulous](https://github.com/anmoljagetia/Flatabulous) - Un tema plano para Ubuntu linux y otros sistemas operativos Linux basados en GNOME.
- [![Open-Source Software][oss icon]](https://github.com/andreisergiu98/arc-flatabulous-theme) [Flatabulous Arc Theme](https://github.com/andreisergiu98/arc-flatabulous-theme) - Un tema GTK plano y azul que tiene una versión oscura alternativa.
- [![Open-Source Software][oss icon]](https://github.com/bsundman/Irradiance) [Irradiance Theme](https://github.com/bsundman/Irradiance) - Un tema para Unity inspirado por OSX Yosemite, y se basa en el tema de Radiance.
- [![Open-Source Software][oss icon]](https://github.com/numixproject/numix-gtk-theme) [Numix Theme](https://itsfoss.com/install-numix-ubuntu/) - Un tema plano y colorido para los escritorios basados en GTK.
- [![Open-Source Software][oss icon]](https://github.com/bsundman/Yosembiance) [Yosembiance theme](https://github.com/bsundman/Yosembiance) - Una versión modificada del tema Ambiance.

#### Widgets y utilidades de tema para el escritorio.

- [Compiz Config settings manager](https://apps.ubuntu.com/cat/applications/compizconfig-settings-manager/) - Este programa permite que los efectos visuales de escritorio 3D aumenten la productividad.
- [![Open-Source Software][oss icon]](https://github.com/brndnmtthws/conky) [Conky](https://github.com/brndnmtthws/conky) - Conky es un monitor de sistema abierto y rápido para el escritorio. Puede mostrar una variedad de información del sistema para un fácil acceso.
- [Gnome Extensions](http://extensions.gnome.org/) - Estas son extensiones para el entorno de escritorio de Gnome.
- [Gnome Look](https://www.gnome-look.org/) - Un sitio web que agrega iconos creados por la comunidad, temas de shell, fuentes y más partes que se pueden utilizar en un escritorio de GNOME.
- [![Open-Source Software][oss icon]](https://github.com/bil-elmoussaoui/Hardcode-Tray) [Hardcode Tray](https://github.com/bil-elmoussaoui/Hardcode-Tray) - Se trata de una secuencia de comandos automatizada que corrige los iconos de la bandeja detectando el tema predeterminado de un sistema, el tamaño de icono perfecto y las aplicaciones codificadas.
- [Macbuntu](http://www.noobslab.com/2017/06/macbuntu-transformation-pack-ready-for.html) - Un programa que cambia tu escritorio para que parezca MacOS.
- [![Open-Source Software][oss icon]](https://github.com/opendesktop/ocsstore) [OCS store](https://github.com/opendesktop/ocsstore) - La aplicación oficial de OpenDesktop.org, donde los desarrolladores y artistas comparten aplicaciones, temas e iconos.
- [![Open-Source Software][oss icon]](https://github.com/actionless/oomox) [Oomox theme generator](https://github.com/actionless/oomox) - Una aplicación gráfica para generar diferentes variaciones de color de varios temas de escritorio GTK2 y GTK3.
- [![Open-Source Software][oss icon]](https://github.com/ianyh/Amethyst) [Unity Tweak Tool](https://apps.ubuntu.com/cat/applications/unity-tweak-tool/) - Una aplicación muy capaz para la personalización de Ubuntu Unity.
- [![Open-Source Software][oss icon]](https://github.com/deviantfero/wpgtk) [Wpgtk](http://deviantfero.github.io/wpgtk) - Un software de temas universales para temas que se definen en archivos de texto. Es compatible con todos los terminales y utiliza pywal como componente generador.

#### Paquetes de iconos de escritorio

- [![Open-Source Software][oss icon]](https://github.com/horst3180/arc-icon-theme) [Arc Icon Theme](https://github.com/horst3180/arc-icon-theme) - Un tema de icono Plano que requiere que el tema de Icono de Moka funcione.
- [![Open-Source Software][oss icon]](https://github.com/keeferrourke/la-capitaine-icon-theme) [La Capitaine Icon Theme](https://github.com/keeferrourke/la-capitaine-icon-theme) - Un tema inspirado en MacOS y en el diseño de Google Material. Está diseñado para quedar bien con casi cualquier entorno de escritorio.
- [![Open-Source Software][oss icon]](https://github.com/snwh/moka-icon-theme) [Moka Icon Theme](https://snwh.org/moka) - Moka fue creado como un simple tema de iconos, con geometría sencilla y colores brillantes.
- [![Open-Source Software][oss icon]](https://github.com/numixproject/numix-icon-theme) [Numix Icon Theme](http://www.noobslab.com/2014/04/install-numix-icon-packs-in-ubuntulinux.html) - Un tema de icono plano que viene en dos variedades, Numix Main, y Numix circle.
- [![Open-Source Software][oss icon]](https://github.com/PapirusDevelopmentTeam/papirus-icon-theme-gtk/) [Papirus Icon Theme](https://github.com/PapirusDevelopmentTeam/papirus-icon-theme-gtk/) - Un tema de icono SVG para Linux que soporta muchos programas y modificaciones. El tema está disponible para GTK y KDE.

### Desarrollo de software

#### Android

- [![Open-Source Software][oss icon]](https://github.com/anbox/anbox) [Anbox](https://anbox.io) - Anbox permite que un sistema operativo Linux ejecute programas de Android.
- [Android studio](https://developer.android.com/studio/index.html) - El Entorno oficial de desarrollo integrado de Android.

#### C\+\+

- ![Nonfree][money icon] [Clion](https://www.jetbrains.com/clion/) - Una plataforma multi-plataforma y capaz Entorno de desarrollo integrado para C y C++.
- [Code::Blocks](https://www.codeblocks.org/) - Code::Blocks es un Entorno de desarrollo integrado gratuito para C, C++ y Fortran. Está diseñado para ser extensible y muy personalizable.
- [Codelite](http://codelite.org/) - Un IDE de plataforma multiplataforma código abierto para C,C++,PHP and Node.js.
- [![Open-Source Software][oss icon]](https://github.com/qt-creator/qt-creator) [QT Creator](https://www.qt.io/ide/) - Una multiplataforma Entorno de desarrollo integrado para la fácil creación de dispositivos conectados en varias plataformas, Interfaz de usuario y aplicaciones.

#### Base de datos

- [![Open-Source Software][oss icon]](https://github.com/apache/cassandra) [Cassandra](http://cassandra.apache.org/) - Base de datos de Apache Cassandra es un software de base de datos escalable y ampliable. Tiene buena tolerancia a fallos y funciona bien en el hardware personal, y el hardware de la nube.
- [![Open-Source Software][oss icon]](https://github.com/apache?query=couchdb) [CouchDB](http://couchdb.apache.org/) - CouchDB se sincroniza fácilmente entre diferentes bases de datos y es capaz de ejecutarse en hardware de nube y hardware móvil, tiene una intuitiva HTTP / JSON APT y está diseñado para la fiabilidad.
- [DataGrip](https://www.jetbrains.com/datagrip/) - Datagrip es uno Entorno de desarrollo integrado que está diseñado para ayudar a los analistas y desarrolladores de bases de datos que trabajan con bases de datos SQL. Datagrip puede trabajar con DB2, Derby, H2, HSQLDB, MySQL, Oracle, PostgreSQL, SQL Server, Sqlite y Sybase
- [![Open-Source Software][oss icon]](https://github.com/serge-rider/dbeaver/) [DBeaver](http://dbeaver.jkiss.org/) - Un cliente de base de datos universal que es multiplataforma y puede soportar diferentes bases de datos.
- [![Open-Source Software][oss icon]](https://cgit.kde.org/kexi.git/about/) [Kexi](http://kexi-project.org/) - Kexi es un creador de aplicaciones de bases de datos visuales de código abierto.
- [![Open-Source Software][oss icon]](https://mariadb.org/get-involved/getting-started-for-developers/) [MariaDB](https://mariadb.org/) - Un servidor de base de datos muy popular, fue creado por los desarrolladores originales de MySQL.
- [![Open-Source Software][oss icon]](https://github.com/mongodb/mongo) [MongoDB](https://www.mongodb.com/) - MongoDB es un programa de código abierto, que es multiplataforma y orientado a documentos.
- [![Open-Source Software][oss icon]](https://github.com/dbcli/mycli) [MyCLI](http://www.mycli.net/) - MyCLI es una interfaz de línea de comandos para MySQL, MariaDB y Percona. Cuenta con auto-completar y resaltado de sintaxis.
- [![Open-Source Software][oss icon]](https://github.com/mysql/mysql-server) [MySQL](https://dev.mysql.com/doc/refman/5.7/en/linux-installation.html) - MySQL es el software de base de datos más popular del mundo. Es fiable, rápido y fácil de usar. Muchos sitios web famosos lo utilizan, como Facebook, Twitter, Youtube, y Yahoo!.
- [![Open-Source Software][oss icon]](https://github.com/mysql/mysql-workbench) [MySQL Workbench](https://www.mysql.com/products/workbench/) - Es una herramienta visual unificada para arquitectos de bases de datos visuales, desarrolladores y asistentes de bases de datos.
- [OmniDB](https://omnidb.org) - Una herramienta basada en el navegador para crear, ver y administrar bases de datos.
- [OracleDB](http://www.oracle.com/technetwork/database/enterprise-edition/downloads/index.html) - Un sistema de gestión de bases de datos producido por Oracle Corporation. Es una base de datos basada en objetos.
- [![Open-Source Software][oss icon]](https://github.com/percona/percona-server-mongodb) [Percona MongoDB](https://www.percona.com/software/mongo-database/percona-server-for-mongodb) - El servidor Percona para MongoDB es un servidor alternativo para MongoDB.
- [![Open-Source Software][oss icon]](https://github.com/percona/pmm-server) [Percona Monitoring](https://www.percona.com/software/database-tools/percona-monitoring-and-management) - Percona Monitoring and Management (PMM) es una plataforma de código abierto para administrar y supervisar el rendimiento de MySQL, MariaDB y MongoDB.
- [![Open-Source Software][oss icon]](https://github.com/percona/percona-server) [Percona MySQL](https://www.percona.com/software/mysql-database/percona-server) - El servidor Percona para MySQL es un reemplazo de código abierto, compatible y fácil para el servidor MySQL que es muy rápido y tiene escalabilidad.
- [![Open-Source Software][oss icon]](https://github.com/percona/percona-xtradb-cluster) [Percona XtraDB Cluster](https://www.percona.com/software/mysql-database/percona-xtradb-cluster) - Percona XtraDB Clúster tiene alta escalabilidad y es un programa de código abierto para un MySQL Clúster.
- [![Open-Source Software][oss icon]](https://github.com/dbcli/pgcli) [pgcli](https://www.pgcli.com/) - Pgcli es una interfaz de línea de comando para Postgres que puede completar automáticamente y resaltar la sintaxis.
- [![Open-Source Software][oss icon]](https://github.com/postgres/postgres) [PostgreSQL](https://www.postgresql.org/download/) - PostgreSQL es un sistema de base de datos capaz y codigo abierto.
- [![Open-Source Software][oss icon]](https://www.sqlite.org/src/doc/trunk/README.md) [Sqlite](https://sqlite.org/download.html) - SQLite es una biblioteca de software que crea un motor de base de datos SQL sin servidor y autónomo.
- [![Open-Source Software][oss icon]](https://github.com/sqlitebrowser/sqlitebrowser) [Sqlite Browser](http://sqlitebrowser.org/) - Un programa para crear visualmente, administrar y ver bases de datos sqlite.

#### Golang

- [GoLand](https://www.jetbrains.com/go/) - GoLand es el nombre en clave de un IDE comercial de la empresa Jetbrains.

#### Java

- [![Open-Source Software][oss icon]](https://www.bluej.org/versions.html) [BlueJ](http://bluej.org/) - Un entorno de desarrollo Java de código abierto diseñado para nuevos usuarios.
- [Eclipse](https://eclipse.org/ide/) - Eclipse es un popular entorno de desarrollo integrado de Java. También puede descargar paquetes para soportar C, C ++ y PHP.
- - [![Open-Source Software][oss icon]](https://github.com/JetBrains/intellij-community) [IntelliJ IDEA](https://www.jetbrains.com/idea/) - Un IDE muy capaz para Java.
    La versión de la comunidad es un software de código abierto.

#### Javascript

- [Webstorm](https://www.jetbrains.com/webstorm/) - Un potente Entorno de desarrollo integrado para javascript moderno. Está hecho por la compañía Jetbrains.

#### Microcomputadora y Sistema embebido

- [![Open-Source Software][oss icon]](https://github.com/arduino/arduino-ide) [Arduino IDE](https://www.arduino.cc/en/Main/Software) - El Arduino Oficial Entorno de desarrollo integrado.
- [![Open-Source Software][oss icon]](https://github.com/fritzing/fritzing-app) [Fritzing](https://fritzing.org/) - Fritzing es un sitio web de hardware de código abierto que hace que la electrónica sea accesible para todos.
- [![Open-Source Software][oss icon]](https://github.com/jantje/arduino-eclipse-plugin) [Sloeber IDE](http://eclipse.baeyens.it/) - Sloeber IDE. Un Arduino Entorno de desarrollo integrado para Eclipse.

#### Puede soportar otros idiomas

- [Aptana](https://www.axway.com/en/aptana) - Aptana Studio es similar a eclipse, pero está diseñado principalmente para el desarrollo web.
- [![Open-Source Software][oss icon]](https://phabricator.kde.org/dashboard/view/8/) [KDevelop](https://www.kdevelop.org/) - La programa es un Entorno de desarrollo integrado libre con complementos para C y C ++ y más.
- [![Open-Source Software][oss icon]](https://www.monodevelop.com/developers/) [MonoDevelop](http://www.monodevelop.com/) - Un Entorno multiplataforma de desarrollo integrado para C #, F # y más..
- [Netbeans](https://netbeans.org/downloads/) - NetBeans IDE es un programa para ayudar a desarrollar Java para computadoras, teléfonos móviles y aplicaciones web. También funciona con HTML5, Javascript y CSS.

#### PHP

- [PHPStorm](https://www.jetbrains.com/phpstorm/) - Un poderoso y potente Entorno de desarrollo integrado para PHP. Está hecho por la compañía Jetbrain.

#### Python

- [PyCharm](https://www.jetbrains.com/pycharm/) - Un poderoso Entorno de desarrollo integrado para Python.

#### Shell

- [![Open-Source Software][oss icon]](https://github.com/fish-shell/fish-shell) [Fish](https://fishshell.com/) - Un shell de línea de comandos inteligente y fácil de usar.
- [![Open-Source Software][oss icon]](https://github.com/fisherman/fisherman) [Fisherman](https://github.com/fisherman/fisherman) - Un administrador para los complementos de Fish Shell..
- [![Open-Source Software][oss icon]](https://github.com/ipython/ipython) [Ipython](https://ipython.org/) - Un shell de python capaz.
- [![Open-Source Software][oss icon]](https://github.com/oh-my-fish/oh-my-fish) [Oh-my-fish](https://github.com/oh-my-fish/oh-my-fish) - Un marco que le permite instalar complementos para el Fish Shell.
- [![Open-Source Software][oss icon]](https://github.com/robbyrussell/oh-my-zsh) [Oh-my-zsh](https://github.com/robbyrussell/oh-my-zsh) - Un marco para el ZSH que es dirigido por la comunidad.
- [![Open-Source Software][oss icon]](https://sourceforge.net/p/zsh/code/ci/master/tree/) [Zsh](http://www.zsh.org/) - Un popular y poderoso shell de línea de comandos.

#### Herramientas de apoyo

- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/cscope/) [Cscope](https://cscope.sourceforge.net/) - Cscope es una herramienta para desarrolladores que están inspeccionando el código fuente del navegador. Es para la línea de comandos, pero funciona con el editor VIM.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/diffuse/files/?source=navbar) [Diffuse](https://sourceforge.net/projects/diffuse/) - Diffuse es una herramienta gráfica para comparar y fusionar el texto dentro de archivos. Puede recuperar archivos de muchos tipos diferentes de repositorios, en ejemplo: Bazaar, CVS, Darcs, Git, Mercurial, Monotone, RCS, Subversion, y SVK.
- [![Open-Source Software][oss icon]](https://www.fossil-scm.org/index.html/dir?ci=tip) [Fossil](https://www.fossil-scm.org) - un programa que le permite administrar el desarrollo de software a través de Internet, tiene muchas características como el seguimiento de errores, una wiki y una interfaz web.
- [Genymotion](https://www.genymotion.com/features/) - Genymotion es un emulador rápido que reemplaza al emulador predeterminado de Android.
- [![Open-Source Software][oss icon]](https://git.gnome.org//browse/giggle/) [Giggle](https://wiki.gnome.org/action/show/Apps/giggle?action=show&redirect=giggle) - Giggle es una GUI para el Git Content Tracker.
- [![Open-Source Software][oss icon]](https://github.com/Gisto/Gisto) [Gisto](http://www.gistoapp.com/) - Gisto es un administrador de fragmentos de código que opera en Github Gists. Agrega características como búsqueda, etiquetado y uso compartido.
- [![Open-Source Software][oss icon]](https://github.com/git/git) [Git](https://git-scm.com/) - Git es un sistema de control de versiones distribuidas de código abierto que puede funcionar con proyectos grandes y pequeños, de manera eficiente.
- [![Open-Source Software][oss icon]](https://github.com/git-cola/git-cola) [GitCola](http://git-cola.github.io/) - Git Cola es un elegante y potente cliente gráfico para Git. Es de código abierto y escrito en Python.
- [![Open-Source Software][oss icon]](https://wiki.gnome.org/Apps/Gitg#Development_Resources) [Gitg](https://wiki.gnome.org/Apps/Gitg) - Gitg es un cliente de la GUI de GNOME para ver los Repositorios de Git.
- [GitKraken](https://www.gitkraken.com/) - Un lujoso cliente Git que opera en Weendows, MacOS y Linux.
- [![Open-Source Software][oss icon]](https://github.com/gitlabhq/gitlabhq) [GitLab](https://github.com/gitlabhq/gitlabhq) - GitLab es un gestor de repositorio Git basado en la web. Puede crear y administrar un wiki y realizar un seguimiento de los problemas.
- [![Open-Source Software][oss icon]](https://github.com/sitaramc/gitolite) [Gitolite](https://gitolite.com/gitolite/index.html) - Gitolite le permite configurar git hosting en un servidor central, con controles de acceso seguros y muchas más características de gran alcance.
- [Insomnia](https://insomnia.rest/) - Un simple y hermoso, cliente del REST API.
- [![Open-Source Software][oss icon]](https://docs.jupyter.org/en/latest/install.html) [Jupyter Notebook](https://jupyter.org/) - Un programa de código abierto que proporciona información interactiva de datos e información científica sobre más de 40 lenguajes de programación.
- [![Open-Source Software][oss icon]](http://meldmerge.org/development.html) [Meld](http://meldmerge.org/) - Meld es una herramienta de modelado de diferencias visuales diseñada para ayudar a comparar archivos, directorios y proyectos controlados por versiones.
- [Mockitt](https://mockitt.wondershare.com/home.html) - Mockitt es una herramienta de prototipado simple de utilizar.
- [![Open-Source Software][oss icon]](https://github.com/evolus/pencil) [Pencil](http://pencil.evolus.vn/) - Una herramienta de creación de prototipos GUI de código abierto, que funciona en diferentes plataformas.
- [![Open-Source Software][oss icon]](https://github.com/stuartlangridge/ColourPicker) [Pick](http://kryogenix.org/code/pick/) - Un selector de color.
- [Postman](https://www.postman.com/) - Postman, permite a un usuario desarrollar y probar API rápidamente.
- [![Open-Source Software][oss icon]](https://github.com/rabbitvcs/rabbitvcs) [Rabbit VCS](http://rabbitvcs.org/) - RabbitVCS es un conjunto de herramientas gráficas creadas para ser fáciles de usar con sistemas de control de versiones.
- ![Nonfree][money icon] [SmartGit](http://www.syntevo.com/smartgit/) - SmartGit es un cliente git con soporte para peticiones de Github y comentarios. También es compatible con SVN.
- [StarUML](https://staruml.io/) - Un sofisticado modelador de software.
- [![Open-Source Software][oss icon]](http://uncrustify.sourceforge.net) [Uncrustify](https://uncrustify.sourceforge.net/) - Un programa que hace que el código fuente se vea mejor. El programa funciona con C, C ++, Objetivo C, D, Java, Peón y VALA.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/universalindent/files/uigui/) [UniversalIndentGUI](https://universalindent.sourceforge.net/) - UniversalIndentGUI muestra una vista previa de la configuración de los indentadores.
- [![Open-Source Software][oss icon]](https://www.gnu.org/software/wdiff/devguide) [Wdiff](https://www.gnu.org/software/wdiff/) - Es un programa GNU GUI para diff para comparar palabras entre archivos.
- [![Open-Source Software][oss icon]](https://gitlab.com/wireshark/wireshark/-/tree/master) [Wireshark](https://www.wireshark.org/) - Wireshark es un analizador de protocolo de red muy popular.
- [![Open-Source Software][oss icon]](https://github.com/zealdocs/zeal) [Zeal](https://zealdocs.org/) - Zeal es un navegador de documentación para desarrolladores de software.

### Utilitarios des libros electrónicos

- [![Open-Source Software][oss icon]](https://github.com/babluboy/bookworm) [Bookworm](https://babluboy.github.io/bookworm/) - Un simple y fácil de usar lector de libros electrónicos.
- [![Open-Source Software][oss icon]](https://github.com/oguzhaninan/Buka) [Buka](https://github.com/oguzhaninan/Buka/releases) - Un programa para la gestión de libros electrónicos.
- [![Open-Source Software][oss icon]](https://github.com/kovidgoyal/calibre) [Calibre](http://calibre-ebook.com/) - Un gestor de libros no muy bonito pero muy eficaz y un convertidor.
- [![Open-Source Software][oss icon]](https://github.com/janeczku/calibre-web) [Calibre-web](https://github.com/janeczku/calibre-web) - Calibre Web es una aplicación web que proporciona una interfaz simple y fácil de usar para navegar, leer y descargar libros electrónicos utilizando una base de datos de calibre existente.
- [![Open-Source Software][oss icon]](https://github.com/michaldaniel/Ebook-Viewer) [Easy Ebook Viewer](https://github.com/michaldaniel/Ebook-Viewer) - Un lector de libros electrónicos GTK moderno escrito en Python.
- [![Open-Source Software][oss icon]](https://wiki.gnome.org/Apps/Evince/GettingEvince) [Evince](https://wiki.gnome.org/Apps/Evince) - Evince es un visor de documentos para muchos formatos de documentos diferentes. El objetivo del proyecto es reemplazar a varios visores de documentos por uno centralizado en GNOME.
- [![Open-Source Software][oss icon]](https://github.com/geometer/FBReader) [FBReader](https://fbreader.org/content/fbreader-beta-linux-desktop) - Una de las aplicaciones de lectores más populares para libros electrónicos.
- [Foxit](https://www.foxitsoftware.com/products/pdf-reader/) - Foxit Reader 8.0 es un lector muy popular en Linux y Windows.
- [![Open-Source Software][oss icon]](https://github.com/martamilakovic/gnome-books) [Gnome Books](https://github.com/martamilakovic/gnome-books) - GNOME Books es una aplicación para catalogar, buscar y leer libros electrónicos.
- [Lucidor](http://www.lucidor.org/lucidor/) - Lucidor es un programa informático para leer y gestionar libros electrónicos. Lucidor soporta los libros electrónicos en formato EPUB y los cataloga en formato OPDS.
- [MasterPDF editor](https://code-industry.net/free-pdf-editor/) - Master PDF Editor Es un práctico y elegante editor de PDF para Linux.
- [![Open-Source Software][oss icon]](https://sourceforge.net/p/mcomix/git/ci/master/tree/) [Mcomix](https://sourceforge.net/projects/mcomix/) - GTK+ es un espectador de historietas.
- [![Open-Source Software][oss icon]](https://git.ghostscript.com/?p=mupdf.git;a=summary) [MuPDF](http://mupdf.com/) - un visor rápido de PDF y XPS.
- [![Open-Source Software][oss icon]](https://github.com/KDE/okular) [Okular](https://okular.kde.org/) - Okular es un visor universal de documentos, diseñado para el proyecto KDE. Okular Es multiplataforma y se ejecutará en Linux, Windows, MacOS y BSD.
- [![Open-Source Software][oss icon]](https://github.com/torakiki/pdfsam) [PDFsam](https://www.pdfsam.org/) - Una aplicación para el escritorio que puede dividir, rotar, mezclar, combinar y extraer páginas de archivos PDF.
- [![Open-Source Software][oss icon]](https://download.kde.org/stable/peruse/peruse-1.2.tar.xz.mirrorlist) [Peruse](https://peruse.kde.org/) - Una manera relajante de leer cómics.
- [![Open-Source Software][oss icon]](https://launchpad.net/qpdfview) [qpdf](https://launchpad.net/qpdfview) - qpdfview es un visor de documentos con pestañas.
- [![Open-Source Software][oss icon]](https://github.com/Sigil-Ebook/Sigil) [Sigil](https://github.com/Sigil-Ebook/Sigil) - Sigil es un lector de libros electrónicos EPUB multiplataforma.
- [![Open-Source Software][oss icon]](https://github.com/pwmt/zathura) [Zathura](https://pwmt.org/projects/zathura/) - Zathura es un visor de documentos muy personalizable y funcional.

### Editor de texto

- [![Open-Source Software][oss icon]](https://github.com/atom/atom) [Atom](https://atom.io/) - El editor de textos Hackable para el siglo XXI.
- [![Open-Source Software][oss icon]](https://sourceforge.net/p/bluefish/code/HEAD/tree/trunk/bluefish/) [Bluefish](https://bluefish.openoffice.nl/index.html) - Bluefish es un editor de texto capaz dirigido a programadores y desarrolladores web.
- [![Open-Source Software][oss icon]](https://github.com/adobe/brackets) [Brackets](https://brackets.io/) - Un editor de texto moderno que entiende el diseño web.
- [![Open-Source Software][oss icon]](https://github.com/emacs-mirror/emacs) [Emacs](https://www.gnu.org/software/emacs/) - Un editor de texto extensible, personalizable y de código abierto.
- [![Open-Source Software][oss icon]](https://www.geany.org/Download/Git) [Geany](https://www.geany.org/) - Es un editor de texto escrito GTK + toolkit, que tiene las características básicas de un Entorno de desarrollo integrado. Fue desarrollado para ser pequeño y rápido.
- [Gedit](https://wiki.gnome.org/Apps/Gedit) -gedit es el editor de texto oficial de GNOME, está diseñado para ser fácil de usar, y para ser un editor de propósito general.
- [![Open-Source Software][oss icon]](https://github.com/GNOME/gnome-builder) [Gnome Builder](https://wiki.gnome.org/Apps/Builder) - Potente IDE para el desarrollo moderno de C / C ++ / Bash / JavaScript, hecho por Gnome Team. Uno de los mejores IDE para el desarrollo de C / C ++ (Cmake integrado).
- [![Open-Source Software][oss icon]](https://github.com/mawww/kakoune) [Kakoune](http://kakoune.org/) - Kakoune editor de código, fue inspirado por Vim. Es rápido y tiene buenos atajos de teclado para mejorar la eficiencia.
- [![Open-Source Software][oss icon]](https://kate-editor.org/build-it/) [Kate](https://kate-editor.org/get-it/) - Kate es un editor de documentos múltiples que forma oficialmente parte de KDE.
- [![Open-Source Software][oss icon]](https://github.com/Komodo/KomodoEdit) [Komodo Edit](https://github.com/Komodo/KomodoEdit) - Un entorno multilenguaje de código abierto, diseñado exclusivamente para el desarrollo.
- [![Open-Source Software][oss icon]](https://github.com/LightTable/LightTable) [Lighttable](http://lighttable.com/) - El editor de código del futuro. Es compatible con la edición de código en vivo.
- [![Open-Source Software][oss icon]](http://git.savannah.gnu.org/cgit/nano.git/) [Nano](https://www.nano-editor.org/) - GNU Nano Es un editor de texto que pretende ser un simple editor de texto de línea de comandos.
- [![Open-Source Software][oss icon]](https://github.com/neovim/neovim) [Neovim](https://neovim.io/) - Neovim es una forma de vim que espera mejorar la experiencia del usuario, a través de complementos, y con una variedad de interfaces gráficas.
- [![Open-Source Software][oss icon]](https://github.com/syl20bnr/spacemacs) [Spacemacs](http://spacemacs.org) - Una versión desarrollada por la comunidad de emacs.
- [Sublime](https://www.sublimetext.com/) -un editor de texto muy capaz con avanzadas habilidades de búsqueda. Puede instalar complementos para agregar más funcionalidad.
- [![Open-Source Software][oss icon]](https://github.com/orbitalquark/textadept) [Textadept](https://orbitalquark.github.io/textadept/) - Un editor de texto minimalista para programadores, Text adept es extensible con plugins de lenguaje de programación Lua.
- [![Open-Source Software][oss icon]](https://github.com/vim/vim) [Vim](http://www.vim.org/download.php) -Es un editor de texto avanzado que busca proporcionar el poder de vi pero con más capacidades.
- [![Open-Source Software][oss icon]](https://github.com/Microsoft/vscode) [VSCode](https://code.visualstudio.com) - Es un rápido editor de código fuente que funciona en Windows, MacOS y Linux. Es compatible con muchos lenguajes de programación diferentes.

### Software educativo

- [![Open-Source Software][oss icon]](https://apps.ankiweb.net/) [Anki](https://apps.ankiweb.net/) - Anki es un programa que ofrece tarjetas de aprendizaje, es de código abierto y fácil de usar.
- [![Open-Source Software][oss icon]](http://artha.sourceforge.net/wiki/index.php/Download#Source) [Artha](http://artha.sourceforge.net/wiki/index.php/Home) - Artha es un tesauro inglés multiplataforma que funciona sin Internet, y se basa en wordnet.
- [![Open-Source Software][oss icon]](https://github.com/bibletime/bibletime) [BibleTime](http://bibletime.info/) - BibleTime es una aplicación para ayudar en el estudio de la Biblia, se basa en el software de espada librarym y utiliza el QT toolkit.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/celestia/files/Celestia-source/1.6.1/celestia-1.6.1.tar.gz/download) [Celestia](http://celestiaproject.net/) - Un programa que simula el espacio para que puedas explorarlo en tres dimensiones.
- [![Open-Source Software][oss icon]](https://github.com/opp11/chemtool/blob/master/README.md) [Chemtool](http://ruby.chemie.uni-freiburg.de/~martin/chemtool/) - Chemtool es un pequeño programa para dibujar estructuras químicas en linux.
- [![Open-Source Software][oss icon]](https://code.launchpad.net/epoptes) [Epoptes](http://www.epoptes.org/) - Es una herramienta de gestión y supervisión de laboratorio de código abierto.
- [![Open-Source Software][oss icon]](https://github.com/gap-system/gap) [GAP](http://www.gap-system.org/) - un programa que le permite hacer álgebra, que se centra en la teoría de grupos computacionales.
- [![Open-Source Software][oss icon]](https://gcompris.net/wiki/Developer%27s_corner) [Gcompris](http://gcompris.net/index-en.html) - GCompris es un grupo de software con muchas actividades para niños de 2 a 10 años.
- [![Open-Source Software][oss icon]](https://github.com/geogebra/geogebra) [Geogebra](https://www.geogebra.org/download) - Una calculadora gráfica para funciones, geometría, álgebra, cálculo y estadística. También puede hacer matemáticas en 3D.
- [![Open-Source Software][oss icon]](https://wiki.gnome.org/Apps/Dictionary) [Gnome-dictionary](https://wiki.gnome.org/Apps/Dictionary) - Un diccionario capaz para GNOME.
- [![Open-Source Software][oss icon]](https://opensis.sourceforge.net/) [GNU Octave](http://www.gnu.org/software/octave/) - GNU Octave es un lenguaje de programación matemático, diseñado para cálculos numéricos, que es principalmente compatible con MATLAB.
- [![Open-Source Software][oss icon]](http://ftp.gnu.org/gnu/gtypist/) [GNU Typist](https://www.gnu.org/software/gtypist/index.html) - Una instrucción de escritura de código abierto basada en ncurses.
- [![Open-Source Software][oss icon]](https://gitlab.com/gnukhata) [GNUKhata](http://www.gnukhata.in/) - Software de cuenta que es de código abierto.
- [Google Earth](https://itsfoss.com/install-google-earth-ubunu/) - Google Earth es un programa que te permite ver un globo virtual con mapas y características geográficas.
- [![Open-Source Software][oss icon]](http://gperiodic.seul.org/cvs/) [GPeriodic](http://gperiodic.seul.org/) - GPeriodic es un programa que muestra una tabla periódica, para Linux.
- [KDE Edu Suite](https://apps.kde.org/education/) - Un software libre diseñado para la educación. Está diseñado con KDE.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/klavaro) [Klavaro](http://klavaro.sourceforge.net/en/index.html) - Un programa que te enseña cómo escribir sin mirar el teclado. También le puede enseñar cómo escribir en las nuevas disposiciones de teclado.
- [![Open-Source Software][oss icon]](https://github.com/KDE/ktouch) [Ktouch](https://github.com/KDE/ktouch) - KTouch es un programa que te enseña a escribir sin mirar el teclado.
- ![Nonfree][money icon] [MAPLE](http://www.maplesoft.com/products/maple/) - Maple es un software de matemáticas que es muy capaz, y tiene una interfaz fácil de usar para ayudar a explicar los problemas de matemáticas.
- ![Nonfree][money icon] [MapTiler](https://www.maptiler.com/) - MapTiler crea un mapa ráster ampliable a partir de imágenes en un sistema de coordenadas definido por el usuario.
- [![Open-Source Software][oss icon]](https://github.com/KDE/marble) [Marble](https://marble.kde.org/) - Marble es un mundo virtual y atlas.
- ![Nonfree][money icon] [MATLAB](http://www.mathworks.com/products/matlab/?requestedDomain=www.mathworks.com) - Matlab es un programa diseñado para resolver problemas de ingeniería y científicos. Le permite ejecutar análisis sobre los problemas con los equipos, o incluso los clústeres de computadora.
- [![Open-Source Software][oss icon]](http://maxima.sourceforge.net/project.html) [Maxima](http://maxima.sourceforge.net/) - Maxima es un programa que te permite trabajar con expresiones simbólicas y numéricas. Esto incluye: diferenciación, integración, serie de Taylor, transformadas de Laplace, ecuaciones diferenciales ordinarias y sistemas de ecuaciones lineales.
- [![Open-Source Software][oss icon]](https://github.com/moodle/moodle) [Moodle](https://download.moodle.org/) - Un sistema de gestión escolar para el aprendizaje en línea.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/openeuclide/) [OpenEuclid](http://coulon.publi.free.fr/openeuclide/) - OpenEuclide es un software de geometría de 2 dimensiones: y puede mostrar cifras dinámicamente dándole fórmulas.
- [![Open-Source Software][oss icon]](https://github.com/openmaptiles) [OpenMapTiles](https://openmaptiles.org/) - OpenMapTiles es un conjunto de herramientas de código abierto para autohospedaje de OpenStreetMaps en más de 50 idiomas.
- [OpenSIS](http://www.opensis.com/home) - Un software de administración escolar que ayuda a los estudiantes a tener éxito, y puede decirte cómo están haciendo los maestros.
- [![Open-Source Software][oss icon]](http://pari.math.u-bordeaux.fr/cgi-bin/gitweb.cgi?p=pari.git;a=summary) [PARI/GP](http://pari.math.u-bordeaux.fr/) - Un programa para Algebra que es muy rápido, y trabaja con la teoría numérica.
- [![Open-Source Software][oss icon]](https://git.sagemath.org/sage.git/) [SageMath](http://www.sagemath.org/) - Un software matemático que puede trabajar con álgebra, combinatoria, matemática numérica, teoría numérica y cálculo.
- [![Open-Source Software][oss icon]](https://github.com/scipy/scipy) [Scipy](https://scipy.org/install.html) - SciPy Un grupo basado en python de software para matemáticas, ciencias e ingeniería.
- [![Open-Source Software][oss icon]](https://github.com/LLK/scratch-flash) [Scratch](https://scratch.mit.edu/) - Scratches es un programa que te permite crear historias interactivas, juegos y animaciones. También le permite compartir estas creaciones con personas en línea.
- [![Open-Source Software][oss icon]](https://sourceforge.net/p/stellarium/code/HEAD/tree/) [Stellarium](http://www.stellarium.org/) - Es un programa de planetario de código abierto.
- [![Open-Source Software][oss icon]](https://github.com/ugeneunipro/ugene) [UGENE](http://ugene.net/) - UGENE es un software multiplataforma basado en GUI basado en la bioinformática.
- [![Open-Source Software][oss icon]](https://github.com/veyon/veyon) [Veyon](https://github.com/veyon/veyon/releases) - veyon es un software de gestión informática para aulas, que permite a un profesor controlar las computadoras de los estudiantes y guiar a los estudiantes a través de una red de ordenadores.

### Herramientas para email

- [![Open-Source Software][oss icon]](http://git.claws-mail.org/) [Claws](http://www.claws-mail.org/) - Claws es un cliente de correo electrónico y lector de noticias, tiene una interfaz impresionante, es fácil de configurar, y tiene muchas características.
- [![Open-Source Software][oss icon]](https://wiki.gnome.org/Apps/Evolution/#Get_the_Source_Code) [Evolution](https://wiki.gnome.org/Apps/Evolution/) - Evolution es un sistema de gestión de información personal, que puede trabajar con correo electrónico, un calendario y una libreta de direcciones.
- [![Open-Source Software][oss icon]](https://git.gnome.org//browse/geary/) [Geary](https://wiki.gnome.org/Apps/Geary) - Geary es una aplicación de correo electrónico que fue construida para GNOME3 que le permite leer y enviar correo electrónico con un fácil de usar, y la interfaz moderna.
- [Hiri](https://www.hiri.com/) - Hiri es un cliente de correo electrónico diseñado para negocios, que puede enviar y recibir correos electrónicos, administrar un calendario, establecer una lista de tareas y trabajar con contactos.
- [![Open-Source Software][oss icon]](https://cgit.kde.org/kmail.git/) [KMail](https://apps.kde.org/de/kmail2/) - KMail es la parte de correo electrónico de Kontact, los gestores de información personal integrados en KDE.
- [![Open-Source Software][oss icon]](https://github.com/pulb/mailnag) [Mailnag](https://launchpad.net/~pulb/+archive/ubuntu/mailnag) - Mailnag es un daemon que descarga correos electrónicos desde servidores POP3 e IMAP.
- [Mailspring](https://getmailspring.com/) - Mailspring es un cliente de correo electrónico hermoso y rápido.
- [![Open-Source Software][oss icon]](https://sylpheed.sraoss.jp/en/download.html#stable) [Sylpheed](http://sylpheed.sraoss.jp/en/) - Un cliente de correo electrónico rápido y fácil de usar.
- [![Open-Source Software][oss icon]](https://releases.mozilla.org/pub/thunderbird/) [Thunderbird](https://www.mozilla.org/en-US/thunderbird/) - Thunderbird es una aplicación de correo electrónico de código abierto que es fácil de configurar y personalizar.
- [![Open-Source Software][oss icon]](https://github.com/KDE/trojita) [Trojita](https://apps.kde.org/trojita/) - Es un pequeño y rápido cliente de correo electrónico para Linux.
- [![Open-Source Software][oss icon]](https://github.com/danchoi/vmail) [Vmail](https://danielchoi.com/software/vmail.html) - Un cliente de Gmail diseñado para funcionar como el editor de texto de Vim.
- [![Open-Source Software][oss icon]](https://github.com/Thomas101/wmail) [Wmail](https://github.com/Thomas101/wmail) - Un cliente para Gmail y Google Inbox que no es oficial.

### Administrador de archivos

- [7Zip](http://www.7-zip.org/download.html) - Un programa que puede descomprimir casi cualquier formato de archivo.
- [![Open-Source Software][oss icon]](https://github.com/mate-desktop/caja) [Caja](https://mate-desktop.org/) - Es el gestor de archivos predeterminado para el entorno de escritorio MATE, es muy rápido y sencillo de usar.
- [![Open-Source Software][oss icon]](https://github.com/KDE/dolphin) [Dolphin](https://userbase.kde.org/Dolphin) - Dolphin es el gestor de archivos predeterminado para el entorno de escritorio KDE, que es fácil de usar y muy funcional.
- [Double Commander](http://doublecmd.sourceforge.net/) - Double Commander es un gestor de archivos de código abierto multiplataforma que tiene dos paneles lado a lado. Está inspirado en Total Commander y tiene muchas otras características.
- [![Open-Source Software][oss icon]](https://krusader.org/get-involved/index.html) [Krusader](https://krusader.org) - Krusader es un gestor de archivos de doble panel diseñado para KDE. Es similar a Midnight Commander, y Total Commander.
- [![Open-Source Software][oss icon]](https://github.com/MidnightCommander) [Midnight Commander](https://www.midnight-commander.org/) - Un administrador de archivos con muchas características, que le permite copiar, mover y eliminar archivos fácilmente.
- [![Open-Source Software][oss icon]](https://github.com/GNOME/nautilus) [Nautilus](https://wiki.gnome.org/Apps/Nautilus) - Nautilus es el gestor de archivos oficial del entorno de escritorio GNOME, y es muy fácil de usar.
- [![Open-Source Software][oss icon]](https://github.com/linuxmint/nemo) [Nemo](http://askubuntu.com/questions/294421/how-do-i-install-nemo-file-manager) - Nemo es el gestor de archivos predeterminado para el entorno de escritorio de Cinnamon. Es rápido y fácil de usar.
- [![Open-Source Software][oss icon]](https://github.com/jarun/nnn) [nnn](https://github.com/jarun/nnn) - nnn es un programa que es un administrador de archivos muy rápido para la línea de comando.
- [![Open-Source Software][oss icon]](https://github.com/teejee2008/polo) [Polo](https://github.com/teejee2008/polo) - Polo es un administrador de archivos moderno y rápido para Linux que admite múltiples pestañas, acceso a archivos y más.
- [![Open-Source Software][oss icon]](https://github.com/shundhammer/qdirstat) [QDirStat](https://github.com/shundhammer/qdirstat#ubuntu) - QDirStat es un programa de estadísticas de directorios diseñado para permitirle comparar visualmente el tamaño de los archivos.
- [![Open-Source Software][oss icon]](https://github.com/ranger/ranger) [Ranger](http://ranger.nongnu.org/) - Ranger es un gestor de archivos basado en la línea de comandos que tiene asignaciones de teclas como el editor de texto Vi. Viene con "Rifle" un programa que encuentra programas para abrir archivos.
- [![Open-Source Software][oss icon]](https://github.com/luisgg/thunar) [Thunar](https://apps.ubuntu.com/cat/applications/precise/thunar/) - Thunar es el gestor de archivos predeterminado para el escritorio XFCE. Está diseñado para ser rápido y fácil de usar.
- [![Open-Source Software][oss icon]](https://github.com/vifm/vifm) [Vifm](https://vifm.info/) - Vifm es un gestor de archivos basado en ncurses, que utiliza asignaciones de teclas del editor de texto VI.

### Juegos

#### Videojuego de construcción de ciudades

- [Dwarf Fortress](http://www.bay12games.com/dwarves/) - Una famosa simulación compleja de una Fortaleza Enana de Alta Fantasía, lucha contra los duendes y mata bestias legendarias masivas. ¡Golpea la tierra!
- [![Open-Source Software][oss icon]](https://github.com/OpenTTD/OpenTTD) [OpenTTD](hptts://www.openttd.org) - Un clon de código abierto de "Transport Tycoon Plus" con muchas mejoras que el original.
- [![Open-Source Software][oss icon]](https://github.com/aburch/simutrans) [Simutrans](https://www.simutrans.com) - Simutrans es un simulador de transporte de código abierto.
- [![Open-Source Software][oss icon]](https://github.com/unknown-horizons/unknown-horizons) [Unknown Horizons](https://unknown-horizons.org/) - Es un juego 2D estrategia en tiempo real, donde se construye una ciudad y economía.

#### Juegos de Línea De Comando

- [![Open-Source Software][oss icon]](https://itsfoss.com/best-command-line-games-linux/) [2048](https://itsfoss.com/best-command-line-games-linux/) - Un programa para jugar el famoso juego 2048 en la línea de comandos.
- [![Open-Source Software][oss icon]](https://itsfoss.com/best-command-line-games-linux/) [Backgammon](https://itsfoss.com/best-command-line-games-linux/) - Un juego de backgammon de línea de comandos.
- [![Open-Source Software][oss icon]](https://github.com/fph/bastet) [Bastet](https://github.com/fph/bastet) - Una línea de comandos tetris juego.
- [![Open-Source Software][oss icon]](https://itsfoss.com/best-command-line-games-linux/) [Greed](https://itsfoss.com/best-command-line-games-linux/) - Un juego Tron para la línea de comandos.
- [![Open-Source Software][oss icon]](https://itsfoss.com/best-command-line-games-linux/) [Ninvaders](https://itsfoss.com/best-command-line-games-linux/) - Un juego de 'Space invaders' para la línea de comandos.
- [![Open-Source Software][oss icon]](https://itsfoss.com/best-command-line-games-linux/) [nSnake](https://itsfoss.com/best-command-line-games-linux/) - El juego 'snake' para la línea de comandos.
- [![Open-Source Software][oss icon]](https://github.com/alexdantas/pacman4console.debian) [Pacman4console](https://launchpad.net/ubuntu/+source/pacman4console) - El juego 'pacman' para la línea de comandos.
- [![Open-Source Software][oss icon]](https://itsfoss.com/best-command-line-games-linux/) [Tron](https://itsfoss.com/best-command-line-games-linux/) - Un juego "Tron" para la línea de comandos.

#### Re-creaciones de motor de juegos de video (Requiere el juego real)

- [![Open-Source Software][oss icon]] [NXEngine](http://nxengine.sourceforge.net/) - Una versión de "Cave Story" que funciona en Linux.
- [![Open-Source Software][oss icon]](https://github.com/SFTtech/openage) [openage](http://openage.sft.mx/) - un software libre e codigo abierto, este es un clon de Age of Empires, requiere compilación.
- [![Open-Source Software][oss icon]] [OpenMW](http://openmw.org) - Una recreación del motor para el juego "Morrowind" Puede hacer más que el original, y puede jugar el juego real también.
- [![Open-Source Software][oss icon]] [OpenRA](http://www.openra.net/) - Una selección de juegos clásicos de estrategia que es de código abierto.
- [![Open-Source Software][oss icon]] [OpenRCT2](https://openrct2.website/) - Una recreación del "Roller Coaster Tycoon 2" motor que requiere el juego original para jugar.

#### Videojuego de disparos en primera persona

- [![Open-Source Software][oss icon]](https://gitlab.com/groups/xonotic) [ChaosEsqueAnthology Disc 1](https://sourceforge.net/projects/chaosesqueanthology/) [ChaosEsqueAnthology Disc 2](https://sourceforge.net/projects/chaosesqueanthologyvolume2/) - Una modificación de Xonotic que incluía armas extendidas, mapas, vehículos, edificios construibles, armas montadas, lanzamiento de hechizos, monstruos, personajes de jugadores, texturas y modo de juego (como colorwar (piense en guerra líquida))
- [![Open-Source Software][oss icon]](https://github.com/freedoom/freedoom) [Freedoom](https://freedoom.github.io/) - Freedoom es un puerto de código abierto de archivos de juegos doom, que pronto tendrá un motor de dooms de código abierto.
- [![Open-Source Software][oss icon]](https://github.com/red-eclipse/base) [Red Eclipse](https://redeclipse.net/) - Red Eclipse es un entretenido juego de tiro en primera persona. Tiene un tema de agilidad y velocidad.
- [![Open-Source Software][oss icon]] [Urban Terror](http://www.urbanterror.info) - Un juego de disparos tácticos que se basa en el realismo, pero no siempre.
- [![Open-Source Software][oss icon]](https://gitlab.com/groups/xonotic) [Xonotic](http://www.xonotic.org/) - Es un juego inspirado en "Unreal Tournament" y "Quake".
- [![Open-Source Software][oss icon]](https://osdn.net/projects/zandronum/scm/) [Zandronum](http://zandronum.com/) - Un juego que es como "Doom", pero en línea y con muchas más características.
- [![Open-Source Software][oss icon]](https://github.com/coelckers/gzdoom) [Zdoom](https://zdoom.org/index) - Zdoom es un puerto de origen de condena moderno que es de código abierto y es muy personalizable.

#### Aplicaciones de juego

- [![Open-Source Software][oss icon]](https://github.com/itchio/itch) [itch](https://itch.io/) - Una mercado de juegos que centraliza tus descargas y las actualiza automáticamente. Un montón de juegos gratuitos están disponibles.
- [![Open-Source Software][oss icon]](https://github.com/lutris/lutris) [Lutris](https://lutris.net/) - Lutris es una plataforma de código abierto para organizar juegos en Linux.
- [![Open-Source Software][oss icon]] [PlayOnLinux](https://www.playonlinux.com) - Un programa que hace que "WINE" sea más fácil de usar.
- [![Open-Source Software][oss icon]] [RetroArch](http://www.retroarch.com/) - Un programa que te permite agregar emuladores de juego en un solo lugar.
- [Steam](steampowered.com) - Una tienda de juegos donde puedes comprar juegos en línea.
- [![Open-Source Software][oss icon]] [Wine](https://www.winehq.org/) - Wine ("Wine Is Not an Emulator") es una capa de compatibilidad que permite que las aplicaciones de Windows funcionen en Linux. Los resultados dependen del programa que se esté utilizando.

#### Emulador de videoconsola e plataformas

- [![Open-Source Software][oss icon]](https://github.com/dolphin-emu/dolphin) [Dolphin Emulator](https://dolphin-emu.org/) - Dolphin es un emulador de Gamecube / Wii que te permite jugar estos juegos en Linux.
- [![Open-Source Software][oss icon]](https://sourceforge.net/p/fuse-emulator/fuse/ci/master/tree/) [Fuse](https://fuse-emulator.sourceforge.net/) - Fuse es un emulador de espectro ZX para Linux.
- [![Open-Source Software][oss icon]](https://github.com/GNOME/gnome-video-arcade) [GNOME Video Arcade](https://wiki.gnome.org/action/show/Apps/GnomeVideoArcade?action=show&redirect=GnomeVideoArcade) - GNOME Video Arcade is a simple Mame frontend for any freedesktop.org compliant desktop environment.
  es un emulador multiplataforma para estas consolas: NES, SNES, GameBoy, GameBoy Color, Gameboy Advance, NEC PC Engine, Sega Master System y más. Esta es una guía para instalarlo en inglés. [Instalación de Higan en inglés](https://higan.readthedocs.io/en/stable/install/linux/)
- [![Open-Source Software][oss icon]](https://github.com/mamedev/mame) [MAME](http://mamedev.org/) - MAME es un emulador de arcade que puede jugar muchos juegos antiguos de arcade.
- [![Open-Source Software][oss icon]](https://github.com/0ldsk00l/nestopia) [nestopia](http://0ldsk00l.ca/nestopia/) - nestopia es un emulador de Nintendo.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/qmc2/files/qmc2/) [qmc2](https://qmc2.batcom-it.net/) - QMC2 is the successor to QMamecat, it is a gui for MAME and a ROM manager.
- [![Open-Source Software][oss icon]](https://github.com/snes9xgit/snes9x) [Snes9x](http://www.snes9x.com/) - Snes9x es un emulador de SNES multiplataforma que existe desde hace mucho tiempo.
- [![Open-Source Software][oss icon]](https://github.com/stella-emu/stella) [Stella](https://stella-emu.github.io/) - Stella es un emulador ATARI 2600 que está disponible en múltiples plataformas.
- [![Open-Source Software][oss icon]](https://github.com/visualboyadvance-m/visualboyadvance-m) [Visual Boy Advance-M](http://vba-m.com/) - Un emulador para Gameboy y Gameboy Advance, que también puede simular dos sistemas de enlace.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/zsnes/files/zsnes/ZSNES%20v1.51/) [ZSNES](http://www.zsnes.com/) - Un emulador de SNES capaz y popular.

#### Vario

- [![Open-Source Software][oss icon]] [Cockatrice](https://cockatrice.github.io/) - Cockatrice es un programa multiplataforma de código abierto para jugar juegos de cartas en una red o en Internet.
- [![Open-Source Software][oss icon]](https://download.savannah.gnu.org/releases/galois/source/) [Galois](http://www.nongnu.org/galois/) - Galois es un juego de bloques que cae que usa tetrominoes y otras formas.
- [![Open-Source Software][oss icon]](https://wiki.gnome.org/action/show/Apps/gbrainy?action=show&redirect=gbrainy#Source_code) [GBrainy](https://wiki.gnome.org/action/show/Apps/gbrainy?action=show&redirect=gbrainy) - Gbrainy es un programa que mejora la memoria y resuelve acertijos de lógica.
- ![Nonfree][money icon] [Minecraft](https://minecraft.net) - Minecraft es un juego sobre la colocación de bloques y la construcción de un mundo entero. Ha generado al azar mundos que son masivos en tamaño, donde se puede construir cualquier cosa.
- [![Open-Source Software][oss icon]](https://github.com/minetest/minetest/) [Minetest](https://minetest.net) - Una versión de código abierto de "Minecraft" que está escrito en C ++ y tiene una API de modificación.
- [![Open-Source Software][oss icon]] [Mudlet](mudlet.org) - Un cliente multiplataforma y de código abierto para texto solo videojuego de rol multijugador masivo en línea.
- [OhMyGiraffe](https://ohmygiraffe.com) - Un juego sobre la supervivencia, donde usted es una jirafa siendo perseguido por los leones.
- [![Open-Source Software][oss icon]](https://github.com/alpcoskun/snake) [Snake Game](https://alpcoskun.com/snake/) - Un juego multiplataforma "snake" que está escrito en Node.js.
- [![Open-Source Software][oss icon]](https://github.com/supertuxkart/stk-code) [SuperTuxKart](https://supertuxkart.net) - SuperTuxKart es un juego de carreras de código abierto 3D con una variedad de pistas y modos para jugar.

#### JDR

- [![Open-Source Software][oss icon]] [Tales of Maj'Eyal](https://te4.org/) - Tales of Maj’Eyal (ToME) es una exploración de mazmorras de código abierto JDR, que tiene un combate basado en turnos, y la construcción de personajes.
- [![Open-Source Software][oss icon]] [Zelda Classic](http://www.zeldaclassic.com/) - Un homenaje al juego de Nintendo "The Legend of Zelda".
- [![Open-Source Software][oss icon]] [Zelda: Mystery of Solarus DX](https://www.solarus-games.org) - Una secuela de "La leyenda de Zelda: un vínculo con el pasado" tiene los mismos gráficos, y utiliza la misma mecánica de juego.

#### Videojuego de estrategia en tiempo real

- [![Open-Source Software][oss icon]](http://releases.wildfiregames.com/) [0 AD](https://play0ad.com/) - Un juego que es mucho como "Age of Empires", pero es de código abierto, y sobre la guerra antigua.
- [![Open-Source Software][oss icon]](https://sourceforge.net/p/nethack/NetHack/ci/NetHack-3.6.0/tree/) [Nethack](https://www.nethack.org/) - Un videojuego roguelike que es de código abierto y usa gráficos ASCII.
- [![Open-Source Software][oss icon]](https://github.com/triplea-game/triplea/) [TripleA](http://www.triplea-game.org/) - Un juego de estrategia de código abierto que es como "Axis and Allies".
- [![Open-Source Software][oss icon]](https://github.com/Warzone2100/warzone2100) [Warzone 2100](https://www.wz2100.net/) - Un juego que es de código abierto, es una estrategia en tiempo real que sucede después de una guerra nuclear.
- [![Open-Source Software][oss icon]](https://bazaar.launchpad.net/~widelands-dev/widelands/trunk/changes) [Widelands](https://www.widelands.org/) - Widelands es un juego de estrategia en tiempo real que tiene juego para un solo jugador y multijugador. Está inspirado en el juego: Settlers II.

#### Videojuego de estrategia por turnos

- [![Open-Source Software][oss icon]](https://github.com/wesnoth/wesnoth) [Battle for Wesnoth](https://wesnoth.org/) - El Battle for Wesnoth es una fuente abierta, tiene un tema de Alta fantasía. Tiene un solo jugador y un modo multijugador.
- [![Open-Source Software][oss icon]](https://github.com/freeciv/freeciv) [FreeCiv](http://www.freeciv.org/) - Freeciv es un juego de estrategia de construcción de imperio de código abierto inspirado en la historia humana.

### Gráficos

#### Creación de gráficos

- [![Open-Source Software][oss icon]](https://github.com/aseprite/aseprite/) [Aseprite](https://www.aseprite.org/) - Un programa para crear sprites animados.
  -- [![Open-Source Software][oss icon]](http://archive.blender.org/download/source-code/index.html) [Blender](https://www.blender.org/) - Una fuente abierta y un flujo de trabajo completo para crear gráficos en 3D, diseñados para artistas solos o equipos enteros.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/cinepaint/) [Cinepaint](http://cinepaint.org/) - Un software de pintura capaz y de código abierto.
- [![Open-Source Software][oss icon]](https://github.com/lettier/gifcurry) [Gifcurry](https://lettier.github.io/gifcurry/) -
  es un creador de imágenes GIF de código abierto.
- [Heron Animation](https://heronanimation.brunolefevre.net/) - Es un programa de animación "Stop motion" gratuito.
- [![Open-Source Software][oss icon]](https://github.com/inkscape/inkscape) [Inkscape](https://inkscape.org/en/) - Es una herramienta de diseño capaz y gratuita para imágenes vectoriales.
- [![Open-Source Software][oss icon]](https://www.kde.org/applications/graphics/karbon/development) [Karbon](https://www.calligra.org/karbon/) - Es un programa de dibujo vectorial de código abierto.
- [![Open-Source Software][oss icon]](https://github.com/mbasaglia/Knotter) [Knotter](https://knotter.mattbas.org/Knotter) - Knotter es un programa que ayuda a diseñar nudos celtas.
- [![Open-Source Software][oss icon]](https://github.com/KDE/krita) [Krita](https://krita.org/en/) - Un programa de código abierto para artistas y pintores digitales.
- [![Open-Source Software][oss icon]](https://github.com/mypaint/mypaint/releases) [Mypaint](http://mypaint.org/about/) - Mypaint es un programa de pintura que está diseñado para su uso con Tabletas digitalizadoras.
- [![Open-Source Software][oss icon]](https://github.com/jonata/opendvdproducer) [Open DVD Producer](http://opendvdproducer.jonata.org/) - Es un software multiplataforma de código abierto y moderno que crea imágenes de DVD.
- [![Open-Source Software][oss icon]](https://github.com/PintaProject/Pinta) [Pinta](https://pinta-project.com/pintaproject/pinta/) - Pinta Es un programa de código abierto para dibujar y editar imágenes.
- [![Open-Source Software][oss icon]](https://launchpad.net/lsm) [StopMotion](http://linuxstopmotion.org/) - Linux Stopmotion es una aplicación de código abierto para crear animaciones "Stop Motion". Puede ayudar en cada paso del proceso.
- [![Open-Source Software][oss icon]](https://github.com/synfig/synfig) [Synfig Studio](http://www.synfig.org/) - Es un software de animación 2D de código abierto.
- [Vectr](https://vectr.com/) - Vectr es un software gráfico gratuito y fácil de usar para crear imágenes vectoriales. Es multi plataforma y funciona en una computadora, así como en la web.
- [![Open-Source Software][oss icon]](http://www.xaraxtreme.org/Developers/develeopers-source-code-a-building.html) [Xara Extreme](http://www.xaraxtreme.org/) - Xara Xtreme es un programa de gráficos de propósito general que funciona en sistemas Unix.
- [yEd Graph Editor](https://www.yworks.com/products/yed) - yEd es un creador de Diagramas y editor que puede importar datos para ser analizados. Tiene algoritmos para trabajar con conjuntos de datos incluso grandes fácilmente.

#### Editor de imagen

- ![Nonfree][money icon] [Aftershot](http://www.aftershotpro.com/en/products/aftershot/pro/) - Una alternativa capaz e impresionante de "Adobe Photoshop".
- [![Open-Source Software][oss icon]](https://github.com/darktable-org/darktable) [Darktable](http://www.darktable.org/) - Darktable es una aplicación de flujo de trabajo de código abierto para fotografía y imágenes en formato RAW.
- [![Open-Source Software][oss icon]](https://github.com/GNOME/gimp) [GIMP](https://www.gimp.org/downloads/) - Es un programa Open Source para edición de fotos, composición de imágenes y creación de imágenes.
- [![Open-Source Software][oss icon]](http://www.graphicsmagick.org/) [GraphicsMagick](http://www.graphicsmagick.org/) - GraphicsMagick es un programa de sistema de procesamiento de imágenes que permite transformaciones y cambios en las imágenes.
- [Hugin](https://hugin.sourceforge.io/) - Es un programa multiplataforma fácil de usar para editar y trabajar con panoramas.
- [ImageMagik](http://www.imagemagick.org/script/index.php) - ImageMagick es un grupo de programas para la línea de comandos para modificar imágenes.
- [![Open-Source Software][oss icon]](https://github.com/LuminanceHDR/LuminanceHDR) [Luminance HDR](https://sourceforge.net/projects/qtpfsgui/) - Luminance HDR es un programa de código abierto que proporciona un flujo de trabajo para imágenes HDR.
- [![Open-Source Software][oss icon]](https://github.com/google-code-export/photivo) [Photivo](https://photivo.org/) - Photivo es un procesador de foto de código abierto, que puede trabajar con RAW, BMP, TIFF, JPEG, PNG, y muchos más formatos de archivo. Se puede integrar con GIMP y está diseñado para ser utilizado también con Digikam / F-Spot / Shotwell.
- [![Open-Source Software][oss icon]](https://github.com/lbalazscs/Pixelitor) [Pixelitor](https://pixelitor.sourceforge.io/) - Pixelitor es un software de edición de imágenes de código abierto que admite capas, puede deshacer varias veces y mucho más.
- [![Open-Source Software][oss icon]](https://github.com/Beep6581/RawTherapee) [RawTherapee](http://rawtherapee.com/) - Es un muy buen aspecto, la aplicación de edición de fotos.

#### Organizador de imágenes

- [Digikam](http://www.digikam.org/) - DigiKam es una avanzada aplicación de gestión de fotos digitales.
- [![Open-Source Software][oss icon]](https://git.finalrewind.org/feh) [Feh](https://feh.finalrewind.org/) - Un pequeño y muy rápido visor de imágenes..
- [Fotoxx](http://www.kornelix.net/fotoxx/fotoxx.html) - Fotoxx es un programa de código abierto para la edición y organización de imágenes.
- [![Open-Source Software][oss icon]](https://git.gnome.org/browse/gthumb/) [gThumb](https://wiki.gnome.org/Apps/gthumb) - gThumb es un visor de imágenes y navegador.
- [![Open-Source Software][oss icon]](https://cgit.kde.org/gwenview.git/tree//?) [gwenview](https://userbase.kde.org/Gwenview) - Es un sencillo y potente visualizador de imágenes y organizador para el entorno de escritorio de KDE.
- [![Open-Source Software][oss icon]](https://github.com/meowtec/Imagine) [Imagine](https://github.com/meowtec/Imagine) - Un programa para la optimización de imágenes.
- [![Open-Source Software][oss icon]](https://github.com/nomacs/nomacs/tree/master) [nomacs](https://nomacs.org/) - nomacs es un visor de imágenes que puede ver casi cualquier formato de imagen, y tiene potentes herramientas de cambio de nombre y clasificación.
- [![Open-Source Software][oss icon]](https://github.com/peterlevi/ojo) [Ojo](https://github.com/peterlevi/ojo) - Un visor hermoso y rápido de la imagen.
- [![Open-Source Software][oss icon]](https://github.com/ivandokov/phockup) [Phockup](https://github.com/ivandokov/phockup) - Una herramienta de clasificación de medios que puede organizar fotos y videos en una variedad de formatos de fecha.
- [![Open-Source Software][oss icon]](https://github.com/oferkv/phototonic) [Photonic](https://github.com/oferkv/phototonic) - Phototonic es un visor de imágenes y organizador.
- [![Open-Source Software][oss icon]](https://wiki.gnome.org/Apps/Shotwell) [Shotwell](https://wiki.gnome.org/Apps/Shotwell) - Shotwell es un administrador de fotos para el entorno de escritorio GNOME 3.

#### Vario

- [![Open-Source Software][oss icon]](https://github.com/HandBrake/HandBrake) [Handbrake](https://handbrake.fr/) - HandBrake es una herramienta para convertir casi cualquier tipo de formato de vídeo a otro, y puede utilizar una variedad de codecs para hacerlo.
- [![Open-Source Software][oss icon]](https://potrace.sourceforge.net/#downloading) [Potrace](https://potrace.sourceforge.net/) - Potrace es una herramienta para rastrear y transformar un mapa de bits en una imagen escalable.
- [![Open-Source Software][oss icon]](https://www.radiance-online.org/download-install/radiance-source-code) [Radiance](http://www.radiance-online.org/) - Radiance Una herramienta de simulación de iluminación que es de código abierto.
- [![Open-Source Software][oss icon]](https://github.com/terkelg/ramme) [Ramme](https://github.com/terkelg/ramme) - Una aplicación no oficial de Instagram.
- [![Open-Source Software][oss icon]](https://launchpad.net/rapid/pyqt/0.9.0b2) [Rapid Photo Downloader](http://damonlynch.net/rapid/download.html) - Rapid Photo Downloader es un programa que facilita la importación de fotos desde una cámara o Smartphone.

#### PSD, sketch inspección

- ![Nonfree][money icon] [Avocode](https://avocode.com/) - Avocode un programa para compartir e inspeccionar imágenes de Photoshop y Sketch fácilmente.

#### Grabador de escritorio

- [![Open-Source Software][oss icon]](https://github.com/asciinema/asciinema) [asciinema](https://asciinema.org) - Un programa que registra la entrada en la línea de comandos.
- [![Open-Source Software][oss icon]](https://github.com/foss-project/green-recorder) [Green Recorder](https://github.com/foss-project/green-recorder) - Un grabador de escritorio fácil de usar para Linux. Puede hacer audio, y puede trabajar en una variedad de ambientes de escritorio.
- [![Open-Source Software][oss icon]](https://code.launchpad.net/kazam) [Kazam](https://launchpad.net/kazam) - Un programa de grabación de escritorio fácil de usar que creará un archivo de vídeo desde su escritorio.
- [![Open-Source Software][oss icon]](https://github.com/jp9000/OBS) [OBS Studio](https://obsproject.com/) - Un programa de código abierto para la grabación de vídeo y transmisión en vivo. Es multiplataforma y puede crear muchos tipos diferentes de flujos en línea.
- [![Open-Source Software][oss icon]](https://github.com/phw/peek) [Peek](https://github.com/phw/peek) - Un sencillo y fácil de usar grabador de escritorio GIF.
- [![Open-Source Software][oss icon]](https://github.com/colinkeenan/silentcast) [Silentcast](https://github.com/colinkeenan/silentcast) - Una grabadora de escritorio que crea archivos MKV, y también puede hacer archivos GIF animados.
- [![Open-Source Software][oss icon]](https://github.com/MaartenBaert/ssr) [SimpleScreenRecorder](http://www.maartenbaert.be/simplescreenrecorder/) - SimpleScreenRecorder, es una simple grabadora de escritorio para Linux.
- [![Open-Source Software][oss icon]](https://github.com/vkohaupt/vokoscreenNG) [vokoscreenNG](https://linuxecke.volkoh.de/vokoscreen/vokoscreen.html) - Una grabadora de screencast multilingüe de código abierto para Linux.

#### Captura de pantalla

- [![Open-Source Software][oss icon]](https://github.com/lupoDharkael/flameshot) [Flameshot](https://github.com/lupoDharkael/flameshot) - Un software de captura de pantalla fácil de usar y capaz.
- [![Open-Source Software][oss icon]](https://github.com/olav-st/screencloud) [Screencloud](http://screencloud.net/) - ScreenCloud es una herramienta de captura de pantalla fácil de usar que te permite compartir las imágenes en línea. Funciona en múltiples plataformas.
- [![Open-Source Software][oss icon]](https://github.com/ShareX/ShareX) [ShareX](https://getsharex.com) - ShareX es un programa gratuito y de código abierto que le permite capturar o grabar cualquier área de su pantalla y compartirla con solo presionar una tecla. También permite subir imágenes, texto u otros tipos de archivos a más de 80 destinos admitidos entre los que puede elegir. -[![Open-Source Software][oss icon]](https://launchpad.net/shutter/) [Shutter](http://shutter-project.org/) - Shutter es un programa de captura de pantalla con muchas características para Linux.

#### Transmisión

- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/minidlna) [ReadyMedia](https://minidlna.sourceforge.net/) - El programa se llamaba **MiniDLNA** pero es un software de servidor de medios simple y rápido. Está diseñado para trabajar con clientes DLNA / UPnP-AV. Puede servir imágenes, música y video a teléfonos inteligentes, televisores, computadoras y algunas consolas de juegos.

#### Editor de video

- [![Open-Source Software][oss icon]](https://github.com/cinelerra-cv-team/cinelerra-cv) [Cinelerra-cv](http://cinelerra.org/) - Un software profesional y de video y edición, que también es un entorno de composición.
- [![Open-Source Software][oss icon]](https://github.com/jliljebl/flowblade) [Flowblade](https://github.com/jliljebl/flowblade/releases/tag/1.12.2) - Un editor de video multipista no lineal.
- [![Open-Source Software][oss icon]](https://github.com/KDE/kdenlive) [Kdenlive](https://kdenlive.org/) - Kdenlive es un editor de vídeo no lineal, que es potente y muy capaz.
- [![Nonfree][money icon] [Lightworks](https://www.lwks.com/) - Es un software de edición de vídeo profesional no lineal que también tiene una versión gratuita.
- [![Open-Source Software][oss icon]](https://github.com/OpenShot/openshot-qt) [OpenShot](http://www.openshot.org/) - OpenShot es un editor de video gratuito y fácil de usar para Linux.
- [![Open-Source Software][oss icon]](https://gitlab.gnome.org/GNOME/pitivi) [Pitivi](https://www.pitivi.org/) - es un editor de video gratuito que tiene una interfaz de usuario hermosa y fácil de usar. Tiene una comunidad muy amigable.
- [![Open-Source Software][oss icon]](https://github.com/mltframework/shotcut) [Shotcut](https://www.shotcut.org/) - Shotcut es un editor de video multiplataforma de código abierto que soporta cientos de formatos de archivo de video y audio.
- [![Open-Source Software][oss icon]](https://github.com/ozmartian/vidcutter) [Vidcutter](http://vidcutter.ozmartians.com/) - Una plataforma multiplataforma basada en QT5 diseña para la edición de vídeo pequeña y fácil.

### Internet

#### Navegador web

- [![Open-Source Software][oss icon]](https://github.com/brave/browser-laptop) [Brave](https://brave.com/) - Brave es un navegador web rápido y fácil de usar, que bloquea los anuncios de forma predeterminada.
- [Chrome](https://www.google.com/chrome/browser/desktop/index.html) - el navegador web más popular del mundo.
- [![Open-Source Software][oss icon]](https://www.chromium.org/) [Chromium](http://askubuntu.com/questions/250773/how-do-i-install-chromium-from-the-command-line) - Chromium es el proyecto de código abierto en el que se basa Google Chrome.
- [![Open-Source Software][oss icon]](https://developer.mozilla.org/en-US/docs/Mozilla/Developer_guide) [Firefox](https://www.mozilla.org/en-US/firefox/new/) - Un popular navegador web que es bien conocido por tener muchos complementos para mejorar la funcionalidad.
- [![Open-Source Software][oss icon]](https://git.savannah.gnu.org/cgit/gnuzilla.git) [IceCat](https://www.gnu.org/software/gnuzilla/) - Una versión de código abierto del navegador web de Firefox. Sólo utiliza software de código abierto.
- [![Open-Source Software][oss icon]](https://launchpad.net/~midori/+archive/ubuntu/ppa) [Midori](https://astian.org/midori-browser/download/) - Un navegador web diseñado para no utilizar mucha potencia del sistema.
- [![Open-Source Software][oss icon]](https://github.com/minbrowser/min) [Min](https://minbrowser.org/min/) - es un navegador web muy minimalista y elegante.
- [Opera](http://www.opera.com/) - Es un navegador web capaz, también fue el primero en tener "Smart Dial" funcionalidad.
- [![Open-Source Software][oss icon]](https://github.com/qutebrowser/qutebrowser) [QuteBrowser](https://www.qutebrowser.org/) - es un navegador diseñado para ser utilizado con el teclado, y tiene muchos VIM como atajos.
- [Vivaldi](https://vivaldi.com/?lang=en) - Un navegador que está creciendo en popularidad, es el navegador más personalizable que puedes descargar.
- [Yandex](https://browser.yandex.com/desktop/main/) - un navegador web rápido y fácil de usar.

#### Herramienta de navegador web

- [Clipgrab](https://clipgrab.org/) - Un descargador fácil de usar para youtube y otros sitios web.
- [![Open-Source Software][oss icon]](https://gitweb.torproject.org/tor.git) [Tor](https://www.torproject.org/) - Tor es un software libre y una red que le permite navegar en la privacidad.
- [![Open-Source Software][oss icon]](https://github.com/rg3/youtube-dl) [youtube-dl](https://github.com/rg3/youtube-dl) - Es un programa que puede descargar videos de youtube.com y otros sitios web de video.
- [![Open-Source Software][oss icon]](https://github.com/MrS0m30n3/youtube-dl-gui) [youtube-dlg](https://mrs0m30n3.github.io/youtube-dl-gui/#downloads) - Youtube-dlg Es una GUI para youtube-dl que te permite copiar y pegar el enlace de un sitio web de video, y puede procesar las descargas en paralelo.
- [![Open-Source Software][oss icon]](https://github.com/zerotier/ZeroTierOne) [Zerotier](https://my.zerotier.com) - Zerotier es un programa que crea una red virtual solo para tus dispositivos, esta se envía completamente encriptada a través de Internet.

#### Cliente de servicios web

- [![Open-Source Software][oss icon]](https://cgit.kde.org/akregator.git/) [Akregator](https://userbase.kde.org/Akregator) - Un lector de feeds para KDE.
- [![Open-Source Software][oss icon]](http://choqok.gnufolks.org/) [Choqok](http://choqok.gnufolks.org/) - Choqok es un cliente escrito en QT5 para Twitter, GNU Social, Friendica y Pump.IO.
- [![Open-Source Software][oss icon]](https://github.com/baedert/corebird) [Corebird](http://corebird.baedert.org/) - Corebird es una aplicación diseñada en GTK + para twitter.
- [![Open-Source Software][oss icon]](https://github.com/jangernert/FeedReader) [FeedReader](https://github.com/jangernert/FeedReader) - Una aplicación de escritorio moderna que está diseñada para aceptar feeds RSS.
- [![Open-Source Software][oss icon]](https://github.com/jeena/FeedTheMonkey) [FeedTheMonkey](https://github.com/jeena/FeedTheMonkey/releases) - FeedTheMonkey es un cliente de escritorio para TinyTinyRSS.
- [![Open-Source Software][oss icon]](https://github.com/vinszent/gnome-twitch) [GnomeTwitch](http://gnome-twitch.vinszent.com/) - Un cliente Twitch que no requiere Adobe Flash.
- [![Open-Source Software][oss icon]](https://github.com/EragonJ/Kaku) [Kaku](https://github.com/EragonJ/Kaku/releases) - Un reproductor de música de código abierto para youtube.
- [![Open-Source Software][oss icon]](https://github.com/popcorn-official/) [Popcorntime](https://popcorntime.sh/) - Una aplicación que te permite transmitir películas, mediante el uso de torrents.

### Oficina

#### Contabilidad

- [![Open-Source Software][oss icon]](https://github.com/Gnucash/) [GnuCash](https://www.gnucash.org/) - GnuCash es un software de código abierto que es un sistema de contabilidad. Está diseñado para ser similar a Intuit Quicken.
- [![Open-Source Software][oss icon]](https://code.launchpad.net/homebank) [HomeBank](https://homebank.free.fr/en/index.php) - HomeBank es un software gratuito que lo ayudará a administrar su contabilidad personal.
- [![Open-Source Software][oss icon]](https://github.com/KDE/kmymoney) [KMyMoney](https://kmymoney.org/) - KMyMoney es un administrador de finanzas personales creado por el proyecto KDE.
- [![Open-Source Software][oss icon]](https://cgit.kde.org/skrooge.git) [Skrooge](https://skrooge.org/) - Un gerente de finanzas personales para el escritorio de KDE.

#### Suite ofimática

- [Caligra Office](https://www.calligra.org/) - Un conjunto de ocho aplicaciones que permiten al usuario las necesidades de una hoja de cálculo, un procesador de textos y un gestor de presentaciones.
- [![Open-Source Software][oss icon]](https://www.libreoffice.org/about-us/source-code/) [LibreOffice](https://www.libreoffice.org/) - El programa de oficina más popular para Linux. Siempre está mejorando, y está incluido con muchas versiones de Linux.
- [![Open-Source Software][oss icon]](https://github.com/ONLYOFFICE) [OnlyOffice](https://www.onlyoffice.com/) - Un conjunto de programas de oficina que es gratuito, pero puede ser pagado para trabajar en la nube.
- [WPS office](http://wps-community.org/) - Un conjunto de programas de oficina popular en China. Se traduce y funciona bien en otros idiomas.

#### LaTeX

- [![Open-Source Software][oss icon]](https://github.com/alexandervdm/gummi) [Gummi](https://gummi.app/) -Gummi es un editor sencillo con plantillas, corrector ortográfico y guías.
- [![Open-Source Software][oss icon]](https://git.gnome.org/browse/latexila) [LaTeXila](https://wiki.gnome.org/Apps/LaTeXila) - LaTeXila es un editor LaTex para el entorno de escritorio de GNOME.
- [![Open-Source Software][oss icon]](https://github.com/yihui/lyx) [LyX](http://www.lyx.org/) - Un editor de documentos que puede procesar archivos LaTex.
- [![Open-Source Software][oss icon]](https://www.tug.org/texlive/build.html) [TexLive](https://www.tug.org/texlive/) - TeX Live proporciona una manera fácil de crear un sistema de producción de documentos "Tex".
- [![Open-Source Software][oss icon]](https://savannah.gnu.org/projects/texmacs) [TeXmacs](http://www.texmacs.org/) - Un editor de texto científico gratuito, está inspirado en GNU Emacs y TeX.
- [![Open-Source Software][oss icon]](https://www.xm1math.net/texmaker/download.html) [Texmaker](https://www.xm1math.net/texmaker/) - Un editor código abierto multiplataforma LaTeX.
- [![Open-Source Software][oss icon]](https://github.com/TeXworks/texworks) [TeXworks](https://www.tug.org/texworks/) - TeXworks es un entorno para la creación de archivos de documentos TeX. Incluye un visor de PDF, y tiene una interfaz fácil de usar.

#### Markdown

- [![Open-Source Software][oss icon]](https://github.com/wereturtle/ghostwriter). [Ghost Writer](https://ghostwriter.kde.org/) - Un editor de Markdown que no tiene distracciones. Funciona en Windows y Linux.
- [![Open-Source Software][oss icon]](https://github.com/jamiemcg/remarkable) [Remarkable](https://remarkableapp.github.io/) - Un editor de Markdown capaz de usar una versión diferente de GitHub Markdown.
- [Typora](https://typora.io/) - Un editor de Markdown mínimo y fácil de usar.

#### Escribiendo una Novela

- [![Open-Source Software][oss icon]](https://github.com/andreafeccomandi/bibisco) [Bibisco](https://www.bibisco.com/) - Un programa para escribir novelas que se centra en la creación de ideas y personajes.
- [![Open-Source Software][oss icon]](https://github.com/olivierkes/manuskript) [Manuskript](http://www.theologeek.ch/manuskript/) - Manuskript es una herramienta para ayudar a un escritor a organizar y planificar antes de escribir.
- [![Open-Source Software][oss icon]](https://github.com/jacquetc/skribisto) [Skribisto](www.skribisto.eu) - Software for writers
- [![Open-Source Software][oss icon]](https://github.com/scribusproject/scribus) [Scribus](https://www.scribus.net/downloads/) - Es un programa para ayudar a publicar libros. Puede gestionar la tipografía y la preparación de archivos para equipos de configuración de imágenes.
- [![Open-Source Software][oss icon]](https://github.com/trelby/trelby) [Trelby](http://www.trelby.org/) - Trelby es un simple, rápido y elegante diseño de software de guión.

### Productividad

#### Automatización

- [Actionaz](http://actionaz.org/) - Un programa para automatizar tareas en Linux.
- [Autokey](https://github.com/autokey/autokey) - Un programa para Linux, que le permite asignar scripts y abreviaturas a las teclas de acceso rápido.
- [Caffeine](https://launchpad.net/caffeine) - Un programa que evita que Linux se quede dormido.

#### Barra de tareas

- [![Open-Source Software][oss icon]](https://github.com/Cairo-Dock) [Cairo-Dock](http://glx-dock.org/) - Cairo-Dock es una aplicación de interfaz de escritorio que crea una barra de tareas.
- [![Open-Source Software][oss icon]](https://launchpad.net/docky/+download) [Docky](http://wiki.go-docky.com/index.php?title=Welcome_to_the_Docky_wiki) - Docky es una aplicación completa de barra de tareas. Hace que las aplicaciones comunes de apertura sean más fáciles y rápidas.
- [![Open-Source Software][oss icon]](https://code.launchpad.net/plank) [Plank](https://launchpad.net/plank) - Plank es un programa muy simple que proporciona una barra de tareas para Linux.

#### Busqueda local

- [![Open-Source Software][oss icon]](https://github.com/albertlauncher/albert) [Albert](https://github.com/albertlauncher/albert) - Un lanzador de aplicaciones muy capaz para Linux.
- [![Open-Source Software][oss icon]](https://github.com/DoTheEvo/ANGRYsearch) [AngrySearch](https://github.com/DoTheEvo/ANGRYsearch) - Un programa que busca archivos en linux, y funciona mientras escribe.
- [![Open-Source Software][oss icon]](https://code.launchpad.net/catfish-search) [Catfish](https://launchpad.net/catfish-search) - Catfish es una herramienta de búsqueda muy versátil.
- [![Open-Source Software][oss icon]](https://github.com/KELiON/cerebro) [Cerebro](https://cerebroapp.com/) - Un programa que es de código abierto y ayuda a aumentar la productividad.
- [![Open-Source Software][oss icon]](https://github.com/cboxdoerfer/fsearch) [fsearch](https://github.com/cboxdoerfer/fsearch) - Una utilidad de búsqueda de archivos escrita en GTK + 3
- [![Open-Source Software][oss icon]](https://github.com/p-e-w/plotinus) [Plotinus](https://github.com/p-e-w/plotinus) - Un programa que le permite buscar comandos válidos para cada aplicación GTK.

#### Verio

- [Ambient Noise](https://itsfoss.com/ambient-noise-music-player-ubuntu/) - Un generador de ruido ambiental para linux.
- [![Open-Source Software][oss icon]](https://github.com/hluk/CopyQ) [CopyQ](http://hluk.github.io/CopyQ/) -CopyQ es un gestor de portapapeles que es muy avanzado y le permite editar y script elementos en él.
- [f.lux](https://justgetflux.com/linux.html) - Un programa que enrojezca su pantalla para permitirle dormir mejor.
- [![Open-Source Software][oss icon]](https://github.com/thezbyg/gpick) [Gpick](https://www.gpick.org/) - Gpick es un sampler de color que le permite elegir un color de cualquier cosa abierta en su escritorio.
- [![Open-Source Software][oss icon]](https://github.com/jonls/redshift) [Redshift](http://jonls.dk/redshift/) - Redshift Ajuste la temperatura de color de su pantalla para que coincida con su entorno. Esto ayuda a proteger los ojos por la noche.
- [![Open-Source Software][oss icon]](https://www.speedcrunch.org/) [SpeedCrunch](https://www.speedcrunch.org/) - Una calculadora de código abierto de alta precisión.
- [![Open-Source Software][oss icon]](https://github.com/jml/undistract-me) [Undistract me](https://github.com/jml/undistract-me) - Notifica al usuario cuando se ha completado un comando de línea de comandos muy largo.
- [Xmind](http://www.xmind.net/) - Una herramienta para el mapeo de la mente.

#### Tomar nota

- [![Open-Source Software][oss icon]](https://github.com/KDE/basket) [Basket Note Pads](https://apps.kde.org/basket/) - Esta es una aplicación multiuso para tomar notas.
- [![Open-Source Software][oss icon]](https://github.com/BoostIO/BoostNote-App) [Boostnote](https://boostnote.io/) - Boostnote es una aplicación de notas de código abierto diseñada para programadores.
- ![Nonfree][money icon] [Inkdrop](https://www.inkdrop.info/) - Una aplicación para tomar notas diseñadas para Markdown, tiene una interfaz simple y está orientado a la seguridad.
- [![Open-Source Software][oss icon]](https://github.com/laurent22/joplin) [Joplin](http://joplin.cozic.net) - Una aplicación de toma de notas con una lista de tareas pendientes que se puede sincronizar en varios sistemas operativos.
- [![Open-Source Software][oss icon]](https://sourceforge.net/p/nevernote/code/ci/master/tree/) [NixNote](https://sourceforge.net/projects/nevernote/) - Un cliente de código abierto para Evernote.
- [![Open-Source Software][oss icon]](https://github.com/notepadqq/notepadqq) [Notepadqq](https://notepadqq.com/s/) - Notepadqq es un Notepad ++ como editor para Linux.
- [![Open-Source Software][oss icon]](https://github.com/nuttyartist/notes) [Notes](http://www.get-notes.com/) - Una simple aplicación de toma de notas para Linux.
- [![Open-Source Software][oss icon]](https://github.com/patrikx3/onenote) [OneNote](https://www.corifeus.com/onenote) - Un programa de toma de notas escrito en Electron para Linux. Es un cliente de escritorio para OneNote.
- [![Open-Source Software][oss icon]](https://git.savannah.gnu.org/cgit/emacs/org-mode.git/) [Org mode](https://orgmode.org/) - Org mode un programa para mantener notas, mantener listas de trabajo, planear proyectos y crear documentos.
- [![Open-Source Software][oss icon]](https://github.com/Aseman-Land/Papyrus) [Papyrus](http://aseman.co/en/products/papyrus/) - Papyrus Es un organizador de notas que se centra en la seguridad, y una interfaz fácil de usar.
- [![Open-Source Software][oss icon]](https://github.com/pbek/QOwnNotes) [QOwnNotes](https://github.com/pbek/QOwnNotes) - QOwnNotes es un administrador de listas de archivos, bloc de notas y tareas de texto sin formato que admite el descuento y puede integrarse con Nextcloud / Owncloud.
- [Simplenote](https://simplenote.com/) - Un organizador de notas multiplataforma, que es un competidor de Evernote.
- [![Open-Source Software][oss icon]](https://github.com/spsdco/notes) [Springseed](https://github.com/spsdco/notes) - Una nota simple y hermosa que toma el organizador para el uso diario.
- [Stickynote](https://itsfoss.com/indicator-stickynotes-windows-like-sticky-note-app-for-ubuntu/) - Una aplicación de notas adhesivas para Linux.
- [![Open-Source Software][oss icon]](https://wiki.gnome.org/Apps/Tomboy) [Tomboy](https://wiki.gnome.org/Apps/Tomboy) - Tomboy es una aplicación de toma de notas que es simple y fácil de usar.
- [![Open-Source Software][oss icon]](https://github.com/CellarD0-0r/whatever) [Whatever](https://github.com/CellarD0-0r/whatever) - Un cliente de escritorio no oficial para Evernote.
- [![Open-Source Software][oss icon]](https://github.com/wizteam/wizqtclient) [WizNote](https://github.com/wizteam/wizqtclient) - Una nota multiplataforma que toma el cliente en la nube.

#### Tiempo y tareas orientadas

- [![Open-Source Software][oss icon]](https://github.com/alarm-clock-applet/alarm-clock) [Alarm Clock](https://alarm-clock-applet.github.io/) - Alarm Clock es un despertador con muchas características.
- [![Open-Source Software][oss icon]](https://git.calcurse.org/calcurse.git/) [calcurse](http://calcurse.org/) - Un calendario y planificador para la línea de comando.
- [California](https://wiki.gnome.org/Apps/California) - Un reemplazo de la aplicación de calendario, que puede aceptar entrada de lenguaje natural.
- ![Nonfree][money icon] [Everdo](https://everdo.net/linux) - Everdo es una aplicación para el desarrollo y la gestión del trabajo que es multiplataforma y no un Software como servicio.
- [![Open-Source Software][oss icon]](https://github.com/codito/gnome-pomodoro) [Gnome Pomodoro](https://gnomepomodoro.org/#download) - Un temporizador Pomodoro para GNOME que tiene muchas características.
- [Go For It](http://manuel-kehl.de/projects/go-for-it/) - Go For It! es una simple lista de tareas, y el programa de temporizador.
- [![Open-Source Software][oss icon]](https://github.com/mohamed-aziz/mytodo) [My Todo](https://github.com/mohamed-aziz/mytodo) - Mytodo es una lista de tareas pendientes de código abierto que le da un control completo.
- ![Nonfree][money icon] [RoundPie App](https://theroundpie.com/) - RoundPie App es una aplicación que gestiona su flujo de trabajo utilizando la técnica Pomodoro.
- [![Open-Source Software][oss icon]](https://userbase.kde.org/RSIBreak) [RSIBreak](https://userbase.kde.org/RSIBreak) - RSIBreak es una aplicación para la salud a las muñecas, para prevenir Lesiones por esfuerzo repetitivo.
- [![Open-Source Software][oss icon]](https://git.tasktools.org/projects) [TaskWarrior](https://taskwarrior.org/) - Taskwarrior es un software de código abierto que gestiona una lista de tareas desde la línea de comandos.
- [Todo.txt](http://todotxt.org/) - todo.txt- editores de texto que le ayudan a administrar sus tareas con el menor número de pulsaciones de teclas posible.
- [![Open-Source Software][oss icon]](https://github.com/kamhix/todoist-linux) [Todoist](https://github.com/kamhix/todoist-linux) - Un cliente no oficial de Todoist, es una lista de tareas y organizador multiplataforma.

#### Widget e indicador

- [Brightness](https://launchpad.net/indicator-brightness) - Un indicador de brillo para Ubuntu Linux.
- [My Weather Indicator](http://ubuntuhandbook.org/index.php/2016/04/weather-indicator-desktop-widget-ubuntu-16-04/) - Un indicador de tiempo y un widget para Ubuntu Linux.
- [Recent Noti](https://itsfoss.com/7-best-indicator-applets-for-ubuntu-13-10/) - Un indicador para las notificaciones recientes.

### Proxy

- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/ijbswa/) [Privoxy](https://www.privoxy.org/) - Privoxy es un proxy web no caché que tiene filtros para mejorar la privacidad.
- [![Open-Source Software][oss icon]](https://github.com/haad/proxychains) [ProxyChains](https://github.com/haad/proxychains) - una herramienta que puede hacer una conexión tcp pasar por TOR, o un proxy.
- [![Open-Source Software][oss icon]](https://github.com/shadowsocks/shadowsocks-qt5/releases) [Shadowsocks](https://shadowsocks.org/) - un proxy SOCKS5 diseñado para ofrecer privacidad en línea.

### Seguridad

- [ClamAV](https://www.clamav.net/) - Clamav es un antivirus que es de código abierto y puede proteger un equipo contra virus.
- [Fail2ban](http://www.fail2ban.org/wiki/index.php/Main_Page) - Fail2ban puede escanear archivos de registro y prohibir las direcciones IP que muestren signos maliciosos, como demasiados intentos de contraseña, o cavar para exploits.
- [![Open-Source Software][oss icon]](https://github.com/firehol/firehol) [FireHOL](https://firehol.org) - Un controlador de firewall para (`iptables`) Linux, que es fácil de usar.
- [![Open-Source Software][oss icon]](https://github.com/netblue30/firejail) [Firejail](https://firejail.wordpress.com/) -
  es un programa SUID que crea seguridad mediante la restricción de aplicaciones que utilizan espacios de nombres de Linux. [Espacios de Nombres de Linux](https://lwn.net/Articles/531114/) e [seccomp-bpf](https://l3net.wordpress.com/2015/04/13/firejail-seccomp-guide/).
- [![Open-Source Software][oss icon]](https://firehol.org/tutorial/fireqos-new-user/) [FireQoS](https://github.com/firehol/netdata/wiki/You-should-install-QoS-on-all-your-servers) - Un firewall de Linux QoS (Calidad de servicio) de gestión que es fácil de usar.
- [![Open-Source Software][oss icon]](https://github.com/firewalld/firewalld) [Firewalld](https://github.com/firewalld/firewalld) - Firewalld es un firewall gestionado dinámicamente con soporte para zonas de red y firewall, para proporcionar diferentes niveles de confianza para diferentes conexiones.
- [GnuPG](https://www.gnupg.org/) - GnuPG le permite cifrar sus archivos con un sistema de gestión de claves.
- [![Open-Source Software][oss icon]](https://code.launchpad.net/gui-ufw) [GuFW](http://gufw.org/) - Un administrador de cortafuegos muy fácil de usar.
- [![Open-Source Software][oss icon]](https://github.com/firehol/iprange) [IPrange](https://github.com/firehol/iprange) - Una herramienta para procesar listas de IP muy rápidamente.
- [![Open-Source Software][oss icon]](https://github.com/CISOfy/lynis) [Lynis](https://cisofy.com/lynis/) - Una herramienta de auditoría de seguridad para sistemas Unix. Puede comprobar el cumplimiento de HIPAA / ISO27001 / PCI DSS, y el sistema de endurecimiento.
- [OpenSSH](http://www.openssh.com/) - OpenSSH servidor y cliente de shell seguros.
- [![Open-Source Software][oss icon]](https://git.zx2c4.com/password-store/) [Pass](https://www.passwordstore.org/) - El administrador de contraseñas Unix estándar.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/passwordsafe/) [Password Safe](https://pwsafe.org/) - Password Safe es un programa que te permite crear una lista segura y encriptada de contraseñas y nombres de cuentas.
- [![Open-Source Software][oss icon]](https://wiki.gnome.org/Apps/Seahorse) [Seahorse](https://wiki.gnome.org/Apps/Seahorse) - Una GUI de GNOME para GnuPG.
- [![Open-Source Software][oss icon]](http://www.tcpdump.org/#source) [Tcpdump](http://www.tcpdump.org/) - Una herramienta de captura y depuración de TCP.
- [![Open-Source Software][oss icon]](https://github.com/usbkey9/uktools) [Uktools](https://github.com/usbkey9/uktools) - Mantenga su sistema actualizado con el último núcleo disponible. Posibilidad de limpiar kernel viejo también.
- [![Open-Source Software][oss icon]](https://github.com/firehol/blocklist-ipsets) [Update-IPsets](https://iplists.firehol.org) - Un gestor de los ataques de ciberdelincuencia que puede descargar e instalar el netfilter `ipsets`.

### Intercambio de archivos

- [![Open-Source Software][oss icon]](https://github.com/aria2/aria2) [aria2](https://aria2.github.io/) - aria2 es un programa de descarga de línea de comandos rápido y multiprotocolo y multi-fuente.
- [CrossFTP](http://www.crossftp.com/ftp-client.htm) - CrossFTP es un programa que facilita la administración de FTP.
- [D-lan](https://www.d-lan.net/) - Es un programa que te permite compartir archivos en un Red de área local
- [![Open-Source Software][oss icon]](http://dev.deluge-torrent.org/wiki/Development#SourceCode) [Deluge](http://deluge-torrent.org/) - Deluge es un cliente multiplataforma rápido y de código abierto de bittorrent.
- [Dropbox](https://www.dropbox.com/install?os=lnx) - Dropbox es un servicio gratuito que le permite almacenar archivos en la nube.
- [![Open-Source Software][oss icon]](https://filezilla-project.org/sourcecode.php) [Filezilla](https://filezilla-project.org/) - Un servidor FTP de código abierto y un cliente.
- [Flareget](https://flareget.com/) - Un gestor de descargas y un acelerador con muchas características.
- [![Open-Source Software][oss icon]](https://invent.kde.org/network/ktorrent) [KTorrent](https://apps.kde.org/ktorrent/) - KTorrent una aplicación bittorrent creada por KDE.
- [![Open-Source Software][oss icon]](https://github.com/meganz/MEGAsync) [Mega](https://mega.nz/#sync) - Un cliente de Mega.co.nz que sincroniza automáticamente los archivos de su computadora con su cuenta MEGA.
- [![Open-Source Software][oss icon]](https://github.com/nitroshare/nitroshare-desktop) [NitroShare](https://nitroshare.net/) - Un programa de transferencia de archivos de red multiplataforma.
- [ownCloud](https://owncloud.com/products/desktop-clients/) - Un programa que te permite acceder a tus archivos sin importar donde estés.
- [PushBullet](https://www.pushbullet.com/) - Pushbullet un servicio que conecta sus dispositivos para que pueda compartir archivos y mensajes y vínculos entre ellos.
- [![Open-Source Software][oss icon]](https://github.com/sidneys/pb-for-desktop) [PushBullet for desktop](https://sidneys.github.io/pb-for-desktop/) - Un cliente de escritorio para Linux para Pushbullet.
- [![Open-Source Software][oss icon]](https://github.com/qbittorrent/qBittorrent) [qBittorent](http://www.qbittorrent.org/) - qBittorrent es un cliente de bittorrent de código abierto que es similar a μTorrent.
- [Quazaa](https://sourceforge.net/projects/quazaa/) - Un programa multiplataforma y red multipares para compartir archivos.
- [![Open-Source Software][oss icon]](https://github.com/haiwen/seafile) [Seafile](https://www.seafile.com/en/home/) - Seafile es una plataforma de alojamiento de archivos empresariales con alta confiabilidad y rendimiento. Coloque archivos en su propio servidor. Sincronice y comparta archivos en diferentes dispositivos, o acceda a todos los archivos como un disco virtual.
- [SpiderOak](https://spideroak.com/) - Un software de colaboración en tiempo real para equipos y empresas.
- [![Open-Source Software][oss icon]](https://github.com/syncthing/syncthing) [Syncthing](https://syncthing.net/) - Syncthing es un programa que reemplaza los servicios estándar de sincronización y nube con uno que es de código abierto.
- [Teamviewer](https://www.teamviewer.com/) - Un programa que permite el acceso remoto de otras computadoras a través de una red o el Internet.
- [Tixati](https://www.tixati.com/) - Un cliente de torrents gratuito que tiene funciones avanzadas y también tiene una interfaz web.
- [![Open-Source Software][oss icon]](https://trac.transmissionbt.com/browser/trunk) [Transmission](https://www.transmissionbt.com/download/) - un cliente multiplataforma simple y rápido para bittorrent.
- [![Open-Source Software][oss icon]](https://github.com/leonsoft-kras/transmisson-remote-gui) [Transmission Remote GUI](https://sourceforge.net/projects/transgui/) - es un programa para controlar un "Transmission Bittorent Client" a través de una red vía RPC.
- [![Open-Source Software][oss icon]](https://ugetdm.com/downloads/source-code/) [uGet](http://ugetdm.com/) - Un gestor de descargas que puede controlar el portapapeles, y puede descargar varios archivos al mismo tiempo.
- [Vuze](http://www.vuze.com) - Un cliente bittorrent que tiene muchas características.
- [![Open-Source Software][oss icon]](https://github.com/webtorrent/webtorrent-desktop) [Web Torrent Desktop](https://webtorrent.io/desktop/) - Es un cliente torrent para streaming torrent, y se conectará a bittorrent y webtorrent.
- [![Open-Source Software][oss icon]](https://github.com/warner/magic-wormhole) [Wormhole](https://github.com/warner/magic-wormhole) - Un programa que te permite compartir archivos de cualquier tamaño o incluso texto de una computadora a otra.

### Emulador de terminal

- [![Open-Source Software][oss icon]](https://github.com/jwilm/alacritty) [Alacritty](https://github.com/jwilm/alacritty) - un multiplataforma y un acelerador de terminal acelerado por GPU.
- [![Open-Source Software][oss icon]](https://github.com/Swordfish90/cool-retro-term) [Cool Retro Term](https://github.com/Swordfish90/cool-retro-term) - Un terminal diseñado para imitar la apariencia de una pantalla de cátodo.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/dban/) [DBAN](https://dban.org/) - Un ISO independiente que elimina información de los Unidades de discos duros y Unidades de estados sólidos en una computadora.
- [GnomeTerminal](https://help.gnome.org/users/gnome-terminal/stable/) - Un emulador de terminal Linux preinstalado muy común.
- [Guake](http://guake.org/) - Guake es un terminal de arriba hacia abajo diseñado para GNOME.
- [![Open-Source Software][oss icon]](https://github.com/zeit/hyper) [Hyper](https://hyper.is/) - Un terminal que está construido con tecnologías web.
- [![Open-Source Software][oss icon]](https://github.com/KeyLo99/k3rmit) [K3rmit](https://github.com/KeyLo99/k3rmit) - A VTE-based terminal emulator that aims to be simple, fast and effective.
- [![Open-Source Software][oss icon]](https://github.com/kovidgoyal/kitty) [Kitty](https://github.com/kovidgoyal/kitty) - Un emulador de terminal rápido multiplataforma con muchas características.
- [Konsole](https://konsole.kde.org/) - Un emulador de terminal alternativo para el entorno de escritorio KDE.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/rxvt/) [RXVT](https://rxvt.sourceforge.net/) - Un emulador de terminal diseñado para el entorno X11. Es un reemplazo popular para "xterm".
- [![Open-Source Software][oss icon]](rxvt.http://cvs.schmorp.de/rxvt-unicode/) [RXVT-Unicode](http://software.schmorp.de/pkg/rxvt-unicode.html) - rxvt-unicode es una bifurcación de un emulador de terminal bien conocido.
- [![Open-Source Software][oss icon]](https://launchpad.net/sakura) [Sakura](https://launchpad.net/sakura) - Un emulador de terminal potente compra sencillo basado en libvte.
- [![Open-Source Software][oss icon]](https://github.com/gnome-terminator/terminator) [Terminator](https://gnome-terminator.org/) - Terminator es un muy capaz, y poderoso emulador de terminal con un montón de características. Es muy popular.
- [![Open-Source Software][oss icon]](https://github.com/billiob/terminology) [Terminology](https://www.enlightenment.org/about-terminology) - La terminal bonita y rápida del escritorio Enlightenment. Tiene una cantidad sorprendente de características.
- [![Open-Source Software][oss icon]](https://github.com/Eugeny/terminus) [Terminus](https://eugeny.github.io/terminus/) - Una aplicación terminal moderna y muy personalizable basada en tecnologías web.
- [![Open-Source Software][oss icon]](https://github.com/nonstop/termit/wiki) [Termit](https://github.com/nonstop/termit/wiki) - un emulador de terminal simple basado en VTE, y extensible con Lua.
- [![Open-Source Software][oss icon]](https://github.com/thestinger/termite) [Termite](https://github.com/thestinger/termite) - Un terminal basado en VTE que se centra en el teclado..
- [Termius](https://www.termius.com/) - Un terminal multiplataforma con un cliente SSH incorporado y Telnet.
- [![Open-Source Software][oss icon]](https://github.com/gnunn1/tilix) [Tilix](https://gnunn1.github.io/tilix-web/) - un emulador de terminal embaldosado usando GTK3.
- [![Open-Source Software][oss icon]](https://github.com/tmux/tmux) [Tmux](https://tmux.github.io/) - Un programa que le permite multiplexar terminales en cualquier terminal.
- [![Open-Source Software][oss icon]](https://github.com/cosmos72/twin) [Twin](https://github.com/cosmos72/twin/) - Un entorno de ventana de modo de texto rápido y liviano que admite el mouse. Tiene muchas características.
- [![Open-Source Software][oss icon]](https://github.com/railsware/upterm) [Upterm](https://github.com/railsware/upterm) - Upterm es un emulador de terminal que tiene características de Entorno de desarrollo integrado. Está basado en [Electron](https://electron.atom.io/).
- [Xterm](http://invisible-island.net/xterm/) - Xterm es un programa que es un emulador de terminal para el sistema de ventanas X.
- [Yakuake](https://apps.kde.org/yakuake/) - Un emulador de terminal en el estilo de "Quake" y basado en KDE Konsole.

### Herramientas

- [![Open-Source Software][oss icon]](https://github.com/angryip/ipscan) [Angry IP Scanner](http://angryip.org/) - Un escáner de red rápido y fácil de usar.
- [![Open-Source Software][oss icon]](https://code.launchpad.net/~teejee2008/apt-toolkit/trunk) [Aptik](https://teejeetech.com/2019/07/14/aptik-v19-07/) - Una herramienta que le permite organizar su PPA y paquetes favoritos fácilmente.
- [![Open-Source Software][oss icon]](https://github.com/bleachbit/bleachbit) [Bleach bit](https://www.bleachbit.org/) - Este programa limpia los archivos adicionales e innecesarios. también puede eliminar las cookies del sitio web, borrar el historial de Internet y eliminar los registros.
- [![Open-Source Software][oss icon]](https://github.com/GNOME/brasero) [Brasero](https://wiki.gnome.org/Apps/Brasero) - Una grabadora de DVD fácil de usar y efectiva.
- [![Open-Source Software][oss icon]](https://github.com/chrisallenlane/cheat) [Cheat](https://github.com/chrisallenlane/cheat) - es un programa que le permite ver una guía para comandos en la línea de comandos.
- [![Open-Source Software][oss icon]](https://clonezilla.org/related-links/) [Clonezilla](http://clonezilla.org/) - Clonezilla es un programa de clonación de particiones y discos similar al Norton Ghost.
- [Convertall](https://sourceforge.net/projects/convertall/) - Un programa para convertir unidades de una medida en otra unidad.
- [![Open-Source Software][oss icon]](https://launchpad.net/cpug) [CPU-G](http://www.omgubuntu.co.uk/2016/09/monitor-battery-life-ubuntu-cpu-g) - Un programa que hace que sea fácil de monitorear cuánta batería ha dejado una computadora.
- [![Open-Source Software][oss icon]](https://github.com/chamfay/Curlew) [Curlew](https://github.com/chamfay/Curlew) - Un convertidor de medios diseñado para el entorno de escritorio GNOME.
- [![Open-Source Software][oss icon]](https://github.com/keepassxreboot/keepassxc) [KeePassXC](https://keepassxc.org/) - Un administrador de contraseñas multiplataforma, es una comunidad mantenida bifurcacion de: KeePassX([dead](https://github.com/keepassx/keepassx/pull/204))
- [![Open-Source Software][oss icon]](https://github.com/thjaeger/easystroke) [EasyStroke](https://github.com/thjaeger/easystroke/wiki#download) - Easystroke es un programa para reconocer gestos para el entorno X11.
- [![Open-Source Software][oss icon]](https://github.com/OzymandiasTheGreat/emoji-keyboard) [Emoji Keyboard](https://github.com/OzymandiasTheGreat/emoji-keyboard) - Un teclado diseñado para emojis.
- [![Open-Source Software][oss icon]](https://github.com/SpiderOak/Encryptr) [Encryptr](https://spideroak.com/personal/encryptr) - Encryptr es un fácil de usar e-wallet y administrador de contraseñas.
- [Enpass](https://www.enpass.io/) - Enpass es un administrador de contraseñas y también puede almacenar otra información importante.
- [![Open-Source Software][oss icon]](https://github.com/resin-io/etcher) [Etcher](https://etcher.balena.io/) - Flash OS a tarjetas SD y unidades USB de forma segura y sencilla.
- [![Open-Source Software][oss icon]](https://github.com/FreeRDP/FreeRDP) [FreeRDP](http://www.freerdp.com/) - FreeRDP es una implementación de código abierto del "Remote Desktop Protocol (RDP)".
- [GD map](https://gdmap.sourceforge.net/) - Un programa que ayuda a visualizar el uso del disco.
- [![Open-Source Software][oss icon]](http://simmesimme.github.io/news/2016/08/24/gnome-pie-069) [GnomePie](http://simmesimme.github.io/news/2016/08/24/gnome-pie-069) - Un lanzador de aplicaciones que es un círculo.
- [GParted](http://gparted.org/) - Una herramienta de partición de disco para linux.
- [![Open-Source Software][oss icon]](https://github.com/gramps-project/gramps) [Gramps](https://github.com/gramps-project/gramps) - Un programa para ayudar a investigar y construir un árbol genealógico.
- [indicator-cpufreq](https://launchpad.net/indicator-cpufreq) - Programa que muestra la frecuencia actual de la CPU.
- [indicator-multiload](https://launchpad.net/ubuntu/+source/indicator-multiload) - Un programa que muestra la carga actual del sistema.
- [![Open-Source Software][oss icon]](https://github.com/fossfreedom/indicator-sysmonitor) [Indicator-SysMonitor](https://github.com/fossfreedom/indicator-sysmonitor) - Una aplicación que muestra la temperatura de la CPU, la memoria, la velocidad de red actual y más.
- [![Open-Source Software][oss icon]](https://github.com/KDE/kdeconnect-kde) [KDE-Connect](https://community.kde.org/KDEConnect) - Un programa que le permite vincular un teléfono Android con un escritorio Linux y usar el teléfono como mouse, controlar un reproductor de música y más.
- [KeePass](https://www.keepass.info/) - Un administrador de contraseñas centrado en Windows, pero también funciona en Linux.
- [![Open-Source Software][oss icon]](https://github.com/keeweb/keeweb) [KeeWeb](https://github.com/keeweb/keeweb) - Un administrador de contraseñas multiplataforma.
- [![Open-Source Software][oss icon]](https://github.com/jordansissel/keynav) [Keynav](http://www.semicomplete.com/projects/keynav/) - Keynav es un programa que le permite presionar una tecla para mover el cursor del mouse a un área específica de un escritorio.
- [![Open-Source Software][oss icon]](https://github.com/iabem97/komorebi) [Komorebi](https://github.com/iabem97/komorebi/releases) - Komorebi es un gestor de fondo para Linux, que te permite usar el video como fondo.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/kvm/files/) [KVM](http://www.linux-kvm.org/page/Main_Page) - KVM (Kernel-based Virtual Machine) es un programa para la virtualización de computadoras en Linux y funciona con extensiones de virtualización de Intel VT o AMD-V.
- [LastPass](https://lastpass.com/misc_download2.php) - LastPass es un servicio de gestión de contraseñas multiplataforma que almacena contraseñas.
- [![Open-Source Software][oss icon]](https://github.com/mobile-shell/mosh) [Mosh](https://mosh.org/#getting) - Mosh es una aplicación de terminal remoto que puede trabajar con conectividad intermitente.
- [![Open-Source Software][oss icon]](https://github.com/jiahaog/nativefier) [Nativefier](https://github.com/jiahaog/nativefier) - Un programa que puede convertir cualquier sitio web en una aplicación de escritorio.
- [![Open-Source Software][oss icon]](https://g.blicky.net/ncdu.git/) [Ncdu](https://dev.yorhel.nl/ncdu) - Un analizador de uso de disco que utiliza Ncurses.
- [![Open-Source Software][oss icon]](https://github.com/firehol/netdata) [NetData](https://www.netdata.cloud/) - Un monitor de rendimiento y salud basado en web de próxima generación para servidores físicos y virtuales.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/peaextractor/) [PeaExtractor](http://www.peazip.org/peaextractor-unace-unrar-unzip.html) Una herramienta diseñada para descomprimir archivos que es muy fácil de usar.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/peautils/) [PeaUtilities](http://www.peazip.org/peautils-hash-secure-delete.html) PeaUtils es un conjunto de utilidades de administración de archivos, que puede hacer hash checksum, borrar de forma segura y comparar archivos.
- [![Open-Source Software][oss icon]](https://sourceforge.net/projects/peazip/files/Resources/) [Peazip](http://www.peazip.org/) - Una herramienta que puede descomprimir una gran variedad de formatos de compresión.
- [![Open-Source Software][oss icon]](https://github.com/pi-hole/pi-hole) [Pi-Hole](https://pi-hole.net) - Un programa que utiliza el filtrado DNS y puede bloquear anuncios en toda una red LAN.
- [PlexyDesk](https://www.omgubuntu.co.uk/2016/09/plexydesk-widgets-linux-desktop-ppa) - Plexydesk es un programa que crea múltiples escritorios y puede crear widgets en el escritorio.
- [Powertop](https://01.org/powertop/downloads) - Una herramienta que puede ayudar a diagnosticar problemas con el consumo de energía en Linux.
- [![Open-Source Software][oss icon]](http://git.wpitchoune.net/psensor.git/) [Psensor](http://wpitchoune.net/psensor/) - Un monitor gráfico de temperatura para Linux.
- [Pulse Audio](https://wiki.ubuntu.com/PulseAudio) - Un programa que mejora el sonido de Linux con perfiles de audio.
- [![Open-Source Software][oss icon]](https://github.com/FreeRDP/Remmina) [Remmina](http://www.remmina.org/wp/) - Una aplicación de escritorio remoto para Linux, también funciona con otros sistemas unix.
- [![Open-Source Software][oss icon]](https://github.com/sahib/rmlint) [rmlint](https://rmlint.readthedocs.io/en/latest/) - rmlint es un programa que encuentra espacio adicional en un sistema de archivos y lo hace disponible.
- [![Open-Source Software][oss icon]](https://github.com/oguzhaninan/Stacer) [Stacer](https://github.com/oguzhaninan/Stacer) - Un popular programa utilizado para optimizar Ubuntu Linux.
- [![Open-Source Software][oss icon]](https://github.com/antonio-malcolm/gloobus-preview) [Gloobus-Preview](https://github.com/antonio-malcolm/gloobus-preview) - Un programa que prevé sus archivos. Esto es similar a [Sushi](https://github.com/GNOME/sushi)
- [![Open-Source Software][oss icon]](https://github.com/GNOME/sushi) [Sushi](https://github.com/GNOME/sushi) - Sushi es un previsualizador de archivos para Nautilus.
- [Synaptic](http://www.nongnu.org/synaptic/) - Synaptic es una aplicación gráfica de gestión de paquetes para apt.
- [Systemload](http://www.omgubuntu.co.uk/2014/06/system-monitor-indicator-ubuntu-ppa) - Un programa que muestra la carga actual del sistema en la barra de tareas.
- ![Open-Source Software][oss icon] [TightVNC](http://www.tightvnc.com/) - Una aplicación rápida y fiable. Le permite conectarse remotamente a una computadora y controlar su escritorio.
- [TLP](http://linrunner.de/en/tlp/docs/tlp-linux-advanced-power-management.html) - Una aplicación que puede ayudar a optimizar la duración de la batería en Linux.
- [![Open-Source Software][oss icon]](https://github.com/Kilian/Trimage) [Trimage](https://trimage.org/) - Una herramienta multiplataforma para optimizar archivos de imagen PNG y JPG.
- [![Open-Source Software][oss icon]](https://github.com/adgellida/ubunsys) [Ubunsys](https://github.com/adgellida/ubunsys) - Una aplicación diseñada para permitirle cambiar las características del sistema en profundidad sin la línea de comandos.
- [![Open-Source Software][oss icon]](https://github.com/gerardpuig/ubuntu-cleaner) [UbuntuCleaner](https://github.com/gerardpuig/ubuntu-cleaner) - Ubuntu Cleaner es una herramienta que ayuda a limpiar su sistema Ubuntu.
- [![Open-Source Software][oss icon]](https://github.com/Ulauncher/Ulauncher/) [ULauncher](http://ulauncher.io/) - Un lanzador de aplicaciones para Linux.
- [![Open-Source Software][oss icon]](https://github.com/unetbootin/unetbootin) [Unetbootin](https://unetbootin.github.io) - UNetbootin le permite crear unidades USB activas de arranque para Ubuntu y otras distribuciones de Linux. Puede dejar que UNetbootin descargue una de las muchas distribuciones admitidas de fábrica o suministrar su propio archivo .iso de Linux.
- [USB network gate](https://www.eltima.com/products/usb-over-ip-linux/) - Un programa que le permite compartir un puerto USB a través de una red.
- [![Open-Source Software][oss icon]](https://github.com/peterlevi/variety-slideshow) [Variety](http://peterlevi.com/variety/) - Variety es un programa que es de código abierto que cambia su papel tapiz automáticamente y puede aplicar efectos usando Imagemagick.
- [![Open-Source Software][oss icon]](https://www.virtualbox.org/wiki/Contributor_information) [Virtualbox](https://www.virtualbox.org/wiki/Downloads) - VirtualBox es un programa de virtualización de uso general que es de código abierto.
- [WallpaperChange](https://apps.ubuntu.com/cat/applications/raring/wallch/) - Un programa que cambia automáticamente el fondo de pantalla de tu escritorio.
- [![Open-Source Software][oss icon]](https://github.com/rcaelers/workrave) [Workrave](https://www.workrave.org/) - Un programa que ayuda a prevenir trastornos musculoesquéleticos (TME).
- [![Open-Source Software][oss icon]](https://github.com/KaOS-Community-Packages/xdm) [Xtreme Download Manager](http://xdman.sourceforge.net/) - Un gestor de descargas capaz con una interfaz fácil de usar para Linux.

### Vídeo

- [![Open-Source Software][oss icon]](https://github.com/xylosper/bomi) [Bomi Player](https://bomi-player.github.io/) - Un reproductor multimedia capaz y fácil de usar.
- [![Open-Source Software][oss icon]](https://github.com/GNOME/cheese) [Cheese](https://wiki.gnome.org/Apps/Cheese) - Es una aplicación que puede utilizar tu cámara web para tomar fotos y videos, y aplicar efectos especiales al resultado.
- [![Open-Source Software][oss icon]](https://github.com/xbmc/xbmc) [Kodi](https://kodi.tv/about/) - Un programa de código abierto para reproducir videos, música, fotos, juegos y más en tu sala de estar.
- [![Open-Source Software][oss icon]](https://github.com/pculture/miro) [Miro](http://www.getmiro.com/) - Una aplicación gratuita que puede reproducir muchos canales de video y transmisiones en línea.
- [![Open-Source Software][oss icon]](https://github.com/lettier/movie-monad) [Movie Monad](https://lettier.github.io/movie-monad) - Es un reproductor de video fácil de usar, escrito en haskell.
- [![Open-Source Software][oss icon]](http://www.mplayerhq.hu/design7/dload.html) [MPlayer](http://www.mplayerhq.hu/design7/news.html) - MPlayer es un reproductor de películas que se ejecuta en muchos sistemas operativos, y puede reproducir muchos tipos de videos.
- [![Open-Source Software][oss icon]](https://github.com/mpv-player/mpv) [MPV](https://www.mpv.io) - Un reproductor multimedia de código abierto y multiplataforma.
- [![Open-Source Software][oss icon]](https://sourceforge.net/p/smplayer/code/HEAD/tree/) [SMPlayer](http://smplayer.sourceforge.net/) - Un reproductor multimedia gratuito con códecs incorporados.
- [![Open-Source Software][oss icon]](https://gitlab.com/jonata/subtitld) [Subtitld](https://subtitld.org/) - Subtitld es un software de código abierto para editar, transcribir y crear subtítulos.
- [SVP](https://www.svp-team.com/w/index.php?title=Main_Page) - un programa que te permite ver videos en tu escritorio usando interpolación de cuadros.
- [![Open-Source Software][oss icon]](https://www.videolan.org/vlc/download-sources.html) [VLC](http://www.videolan.org/vlc/index.html) - es un reproductor multimedia multiplataforma de código abierto que reproduce casi cualquier tipo de archivo multimedia.

### Wiki software

- [![Open-Source Software][oss icon]](https://git.joeyh.name/git/ikiwiki.git/) [ikiwiki](https://ikiwiki.info/) - es un compilador para wiki. Convierte las páginas wiki en HTML para su publicación en un sitio web.
- [![Open-Source Software][oss icon]](https://github.com/Jermolene/TiddlyDesktop) [TiddlyDesktop on GitHub](https://github.com/TiddlyDesktop) - [TiddlyDesktop on TiddlyWiki.com](https://github.com/TiddlyDesktop) -un software de escritorio para TiddlyWiki, una aplicación de código abierto para escribir en JavaScript.
- [![Open-Source Software][oss icon]](https://launchpad.net/zim) [Zim](https://zim-wiki.org/) - Un editor de texto gráfico que se puede utilizar para mantener páginas wiki, notas y documentos. Está diseñado para hacer páginas wiki fácil.

### Diverso

- [![Open-Source Software][oss icon]](https://displaycal.net/#download) [DisplayCAL](https://displaycal.net/) - Una aplicación de código abierto para la calibración de monitores, con la tecnología de argyllCMS.
- [![Open-Source Software][oss icon]](https://github.com/fontforge/fontforge) [FontForge](https://fontforge.org/) - Una aplicación multiplataforma libre de la creación de fuentes.
- [![Open-Source Software][oss icon]](https://code.launchpad.net/grub-customizer) [GrubCustomizer](https://launchpad.net/grub-customizer) - Grub Customizer es una interfaz gráfica para configurar los parámetros de GRUB2 / BURG.
- [![Open-Source Software][oss icon]](https://github.com/bohoomil/fontconfig-ultimate) [Infinality bundle & fonts](https://github.com/bohoomil/fontconfig-ultimate) - _Preámbulo: Infinality no es mantenido por un desarrollador, puede que no funcione en un futuro próximo._. Infinality bundle & fonts es un proyecto de código abierto creado para administradores y usuarios de linux que desean mejorar la calidad de renderizado de fuentes en Linux.
- [![Open-Source Software][oss icon]](https://github.com/MycroftAI/mycroft-core) [Mycroft](https://github.com/MycroftAI/mycroft-core) - Mycroft es un asistente de voz de código abierto.
- [![Open-Source Software][oss icon]](https://github.com/lah7/polychromatic) [Polychromatic](https://github.com/lah7/polychromatic) - Un GUI y un applet de bandeja para configurar Peripherals para Razer en Linux.

## Herramientas de línea de comandos

- [![Open-Source Software][oss icon]](https://github.com/jarun/Buku) [Buku](https://github.com/jarun/Buku) - Un administrador de marcadores para la línea de comandos.
- [Cloc](https://github.com/AlDanial/cloc) - un programa que cuenta las líneas de código en un archivo de texto.
- [![Open-Source Software][oss icon]](https://github.com/athityakumar/colorls) [Color LS](http://www.omgubuntu.co.uk/2017/07/add-bling-ls-bash-command-colorls) - Color LS es una "Ruby Gem" que hace que el comando 'ls' en Linux sea más bonito y muestre más información.
- [![Open-Source Software][oss icon]](https://github.com/ssimunic/Daily-Reddit-Wallpaper) [Daily Reddit Wallpaper](https://github.com/ssimunic/Daily-Reddit-Wallpaper) - Un programa que cambia tu fondo de pantalla a la imagen más actualizada en /r/Wallpapers o cualquier subreddit en Reddit.
- [![Open-Source Software][oss icon]](https://github.com/jarun/ddgr) [ddgr](https://github.com/jarun/ddgr) - Utiliza duckduckgo desde la línea de comandos.
- [![Open-Source Software][oss icon]](https://github.com/balena-io/balena-cli) [Balena CLI](https://www.balena.io/docs/reference/balena-cli/) - Balena CLI es una herramienta de línea de comandos que tiene como objetivo proporcionar todos los beneficios de la aplicación de escritorio Balena de una manera que se puede ejecutar desde un terminal, o incluso utilizar desde un script.
- [![Open-Source Software][oss icon]](https://github.com/ogham/exa) [exa](https://the.exa.website/) - exa es un reemplazo moderno para el comando 'ls'.
- [![Open-Source Software][oss icon]](https://github.com/LubuntuFu/fishfry) [Fishfry](https://github.com/LubuntuFu/fishfry) - Reemplaza el historial de la línea de comandos de pescado con uno diseñado para pentesters.
- [fzf](https://github.com/junegunn/fzf) - Un programa de búsqueda que puede encontrar cualquier cosa, como un comando en el historial de línea de comandos, una imagen, un git commit o una dirección IP desde la línea de comandos.
- [![Open-Source Software][oss icon]](https://github.com/heppu/gkill) [Gkill](https://github.com/heppu/gkill) - Un proceso asesino para Linux.
- [![Open-Source Software][oss icon]](https://github.com/nicolargo/glances) [Glances](https://nicolargo.github.io/glances/) - Glances es un sistema que supervisa la aplicación del terminal que puede mostrar el uso del disco, el uso del carnero y muchas más cosas en la línea de comandos.
- [![Open-Source Software][oss icon]](https://github.com/jarun/googler) [Googler](https://itsfoss.com/review-googler-linux/) - Un programa que te dará resultados de google en la línea de comandos.
- [![Open-Source Software][oss icon]](https://github.com/aksakalli/gtop) [gtop](https://github.com/aksakalli/gtop) - Un panel de control de sistema para la línea de comandos. Puede mostrar más que el comando 'top'.
- [![Open-Source Software][oss icon]](https://github.com/hishamhm/htop) [htop](http://hisham.hm/htop/) - Un visor de procesos que muestra más que el comando 'top'.
- [Las 10 mejores herramientas de línea de comandos.](http://lifehacker.com/399468/top-10-command-line-tools)
- [![Open-Source Software][oss icon]](https://github.com/nojhan/liquidprompt) [Liquidprompt](https://github.com/nojhan/liquidprompt) - Un símbolo de comando multipropósito diseñado para Bash y Zsh.
- [![Open-Source Software][oss icon]](https://github.com/mps-youtube/mps-youtube) [mps-youtube](https://github.com/mps-youtube/mps-youtube) - Un programa diseñado para buscar y reproducir música para la línea de comandos. Encuentra esta música de Youtube.
- [![Open-Source Software][oss icon]](https://gitlab.com/muttmua/mutt) [Mutt](http://www.mutt.org/) - Un cliente basado en la línea de comandos para correo electrónico.
- [![Open-Source Software][oss icon]](https://github.com/dylanaraps/neofetch) [Neofetch](https://github.com/dylanaraps/neofetch/releases) - Un script del sistema que puede mostrar información sobre su sistema, funciona en muchos sistemas operativos diferentes, tales como: Linux, MacOS, iOS, BSD, Solaris, Android, Haiku, GNU Hurd, MINIX, AIX y Windows.
- [PathPicker](https://github.com/facebook/PathPicker) - Un programa que le permite seleccionar la salida de un comando y buscarlo por archivos y luego permitirle ejecutar un comando en esos archivos.
- [pywal](https://github.com/dylanaraps/pywal) - Es un script que cambia los colores de la línea de comandos para que coincida con el fondo de pantalla u otra imagen.
- [![Open-Source Software][oss icon]](https://github.com/amanusk/s-tui) [s-tui](https://amanusk.github.io/s-tui/) - s-tui es un programa de línea de comandos que le permite controlar la temperatura de su CPU, la frecuencia de la CPU, y más de la línea de comandos.
- [![Open-Source Software][oss icon]](https://github.com/ggreer/the_silver_searcher) [The Silver Searcher / Ag](https://github.com/ggreer/the_silver_searcher) - Una herramienta de búsqueda de código que es similar al comando 'ack'.
- [![Open-Source Software][oss icon]](https://github.com/nvbn/thefuck) [TheFuck](https://github.com/nvbn/thefuck) - Una aplicación que corrige el comando anterior.
- [![Open-Source Software][oss icon]](https://github.com/tmux/tmux) [Tmux](https://tmux.github.io/) - un comando que le permite cambiar entre diferentes programas en un terminal, y adjuntar y separar las tareas de la línea de comandos.
- [![Open-Source Software][oss icon]](https://github.com/jml/undistract-me) [undistract-me](https://github.com/jml/undistract-me) - Un programa de línea de comando que reproduce un sonido o envía una notificación cuando un comando largo ha terminado de ejecutarse en la línea de comando.
- [wicd-curses](https://wiki.archlinux.org/index.php/wicd#Running_Wicd_in_Text_Mode) - Un encargado del wifi para la línea de comando.

## Los Entornos des escritorios

- [![Open-Source Software][oss icon]](https://github.com/solus-project/budgie-desktop) [Budgie](http://www.omgubuntu.co.uk/2016/09/install-budgie-desktop-on-ubuntu) - Budgie es un entorno de escritorio diseñado para parecer moderno, y es simple y elegante.
- [![Open-Source Software][oss icon]](https://github.com/linuxmint/Cinnamon) [Cinnamon](http://cinnamon.linuxmint.com/) - Cinnamon es un entorno de escritorio diseñado para ser tradicional. Cinnamon es un bifurcacion de GNOME 3.
- [![Open-Source Software][oss icon]](https://github.com/linuxdeepin/dde-desktop) [Deepin DE](https://www.deepin.org/en/dde/) - DDE (Deepin escritorio diseñado) es el entorno de escritorio predeterminado de Linux Deepin. Es muy simple y se basa en una barra de tareas en la parte inferior de la pantalla.
- [![Open-Source Software][oss icon]](https://git.enlightenment.org/enlightenment/efl) [Enlightenment](https://www.enlightenment.org/about) - Un entorno de escritorio rápido y hermoso que está diseñado para ser personalizable.
- [![Open-Source Software][oss icon]](https://github.com/GNOME/gnome-desktop) [Gnome](https://www.gnome.org/) - El GNOME escritorio es un escritorio diseñado atractivo y fácil de usar que puede ejecutarse en el estilo moderno o clásico.
- [![Open-Source Software][oss icon]](https://github.com/GNOME/gnome-flashback) [GNOME Flashback](https://wiki.gnome.org/Projects/GnomeFlashback) - GNOME Flashback es un entorno de escritorio diseñado para parecer GNOME 2.
- [![Open-Source Software][oss icon]](https://github.com/KDE/plasma-desktop) [KDE Plasma](https://www.kde.org/workspaces/plasmadesktop/) - El KDE Plasma escritorio diseñado está diseñado para parecer familiar. Tiene todas las herramientas que necesita para ser productivo.
- [![Open-Source Software][oss icon]](https://github.com/lxde) [LXDE](http://lxde.org/) - El X11 escritorio está diseñado para ser rápido y ahorro de energía.
- [![Open-Source Software][oss icon]](https://github.com/lxde/lxqt) [LXQt](http://lxqt.org/) - LXQt es el portal QT de LXDE, es un entorno de escritorio ligero.
- [![Open-Source Software][oss icon]](https://github.com/mate-desktop/) [Mate](http://mate-desktop.com/) - Mate se nombra después de Yerba Mate argentino, está diseñado para ser intuitivo y atractivo. Es un bifurcacion de GNOME 2.
- [Pantheon](https://elementary.io/) - Pantheon es el entorno de escritorio predeterminado creado para el sistema operativo "Elementary OS".
- [Unity](https://unity.ubuntu.com/) - Unity es el entorno de escritorio predeterminado para Ubuntu. Se basa en GNOME 3. [Una guia de la instalación inglés](http://www.omgubuntu.co.uk/2016/04/ubuntu-16-04-unity-8-desktop-progress-video) - Una guía sobre cómo instalar Unity 8 para Ubuntu 16.04
- [![Open-Source Software][oss icon]](https://github.com/xfce-mirror) [Xfce](https://www.xfce.org/) - Xfce es un entorno de escritorio ligero diseñado para ser modular y muy personalizable.

## Gestores de pantallas

### Console

- [![Open-Source Software][oss icon]](https://github.com/ghost1227/cdm) [CDM](https://github.com/ghost1227/cdm) - Un administrador de inicio de sesión muy minimalista escrito en Bash.
- [![Open-Source Software][oss icon]](https://github.com/dopsi/console-tdm) [Console TDM](https://github.com/dopsi/console-tdm) - Una extensión para xinit escrita en Bash.
- [![Open-Source Software][oss icon]](https://github.com/spanezz/nodm) [nodm](https://github.com/spanezz/nodm) - Un gestor de visualización minimalista para los inicios de sesión automáticos.

### Gráficos

- [![Open-Source Software][oss icon]](https://github.com/tomas/entrance) [Entrance](http://enlightenment.org) - Un gestor de visualización basado en EFL, que es experimental.
- [![Open-Source Software][oss icon]](https://github.com/GNOME/gdm) [GDM](https://wiki.gnome.org/Projects/GDM) - El gestor oficial de GNOME.
- [KDM](http://www.kde.org) - El gestor de visualización de KDE4 actualmente descontinuado.
- [![Open-Source Software][oss icon]](https://github.com/davvid/lightdm) [LightDM](https://www.freedesktop.org/wiki/Software/LightDM) - Un gestor de pantallas multiplataforma que puede utilizar Front-end de otros toolkits.
- [LXDM](https://sourceforge.net/projects/lxdm/) - El gestor des pantallas LXDE, puede ser utilizado independientemente de LXDE.
- [![Open-Source Software][oss icon]](https://github.com/linuxmint/mdm) [MDM](https://github.com/linuxmint/mdm) - El gestor des pantallas de MDM, uso en Linux Mint.
- [![Open-Source Software][oss icon]](https://github.com/sddm/sddm) [SDDM](https://github.com/sddm/sddm) - El gestor des pantallas basado en QML y sucesor de KDM.
- [![Open-Source Software][oss icon]](https://github.com/gsingh93/slim-display-manager) [SLiM](https://sourceforge.net/projects/slim.berlios/) - Un gestor des pantallas ligero y sencillo. Se suspende.
- [![Open-Source Software][oss icon]](https://github.com/bbidulock/xdm) [XDM](https://www.x.org/archive/X11R7.5/doc/man/man1/xdm.1.html) - El gestor des pantallas X que apoya XDMCP.

## Gestor de ventanas

### Gestors de composiciónes

- [![Open-Source Software][oss icon]](https://github.com/yshui/picom) [Picom](https://github.com/yshui/picom) - Picom es un gestor compuesto independiente, que puede trabajar con gestores de ventanas que no tienen composición.
- [![Open-Source Software][oss icon]](https://cgit.freedesktop.org/xorg/app/xcompmgr) [Xcompmgr](https://cgit.freedesktop.org/xorg/app/xcompmgr) - Xcompmgr es un gestor compuesto simple que puede renderizar, sombras, y otros efectos.

### Gestor de apilables

- [![Open-Source Software][oss icon]](https://github.com/venam/2bwm) [2bwm](https://github.com/venam/2bwm) - 2bwm es un gestor de ventanas flotante que tiene dos bordes.
- [![Open-Source Software][oss icon]](https://github.com/bbidulock/blackboxwm) [Blackbox](http://blackboxwm.sourceforge.net) - es un gestor de ventanas rápido y ligero para el "Sistema X Window" sin tantas dependencias bibliotecas.
- [![Open-Source Software][oss icon]](https://github.com/fluxbox/fluxbox) [Fluxbox](http://fluxbox.org) - Un administrador de ventanas para X, basado en Blackbox.
- [![Open-Source Software][oss icon]](https://github.com/danakj/openbox) [Openbox](http://openbox.org) - Un gestor de ventanas de próxima generación configurable.

### Gestor de embaldosado

- [![Open-Source Software][oss icon]](https://github.com/baskerville/bspwm) [Bspwm](https://github.com/baskerville/bspwm/wiki) - bspwm es un gestor de embaldosado que representa las ventanas como partes de un árbol.
- [![Open-Source Software][oss icon]](https://github.com/herbstluftwm/herbstluftwm) [Herbstluftwm](https://herbstluftwm.org) - Es un manual gestor de embaldosado para X11.
- [![Open-Source Software][oss icon]](https://github.com/i3/i3) [i3 WM](https://i3wm.org/) - i3 WM es un gestor de ambaldosado y dinámico que es administrador de ventanas capaz escrito desde cero.
- [![Open-Source Software][oss icon]](https://github.com/qtile/qtile) [Qtile](https://qtile.org/) - qtile es un gestor de embaldosado hackable completo en python.
- [![Open-Source Software][oss icon]](https://github.com/swaywm/sway) [Sway](http://swaywm.org) - Sway está embaldosando el compositor Wayland y reemplazando al administrador de ventanas i3 para X11.

### Gestor de dinámico

- [![Open-Source Software][oss icon]](https://github.com/awesomeWM/awesome) [awesome](https://awesomewm.org) - Un gestor de marcos configurable para X.
- [![Open-Source Software][oss icon]](https://github.com/cdown/dwm) [dwm](http://dwm.suckless.org) - Un gestor de dinámico para X, tiene tres modos de "layouts".
- [![Open-Source Software][oss icon]](https://github.com/i3/i3) [i3](https://i3wm.org) - Un Gestor de embaldosado que se escribe desde cero.
- [![Open-Source Software][oss icon]](https://github.com/conformal/spectrwm) [spectrwm](https://github.com/conformal/spectrwm/wiki) - Un pequeño Gestor de dinámico para X11, está inspirado en xmonad y dwm.
- [![Open-Source Software][oss icon]](https://github.com/xmonad/xmonad) [xmonad](http://xmonad.org) - Un Gestor de dinámico y embaldosado para X11 que está escrito en Haskell.

## Instalación de

- [38 tareas después de instalar Ubuntu (Inglés)](https://www.lifewire.com/things-to-do-installing-ubuntu-2200611)
- [Elegir una buena distribución de Linux (Inglés)](http://i.imgur.com/TV21DgN.jpg)
- [¿Qué significan los comandos de línea de comando? (Inglés)](https://www.explainshell.com) [![Open-Source Software][oss icon]](https://github.com/idank/explainshell)
- [Términos básicos de linux (Inglés)](http://www.makeuseof.com/tag/linux-confusing-key-terms-definitions/)
- [¿Qué es Linux? (Inglés)](https://www.linux.com/what-is-linux)

### Arch Linux

- [Descargar e instalar Arch](<https://wiki.archlinux.org/title/Installation_guide_(Espa%C3%B1ol)>)
- [Guía de instalación](<https://wiki.archlinux.org/index.php/Installation_guide_(Espa%C3%B1ol)>)
- [lista de aplicaciones](<https://wiki.archlinux.org/index.php/List_of_applications_(Espa%C3%B1ol)>)
- [Recomendaciones generales](<https://wiki.archlinux.org/index.php/General_recommendations_(Espa%C3%B1ol)>)

### Bodhi

- [dónde descargar Bodhi? (Inglés)](http://www.bodhilinux.com/download/)
- [¿Cómo instalo Bodhi? (Inglés)](http://www.bodhilinux.com/w/installation-instructions/)
- [¿Qué es Bodhi?](https://es.wikipedia.org/wiki/Bodhi_Linux)

### CentOS

- [Acerca de CentOS (Inglés)](https://wiki.centos.org/About)
- [consejos y trucos (Inglés)](https://wiki.centos.org/TipsAndTricks)
- [Descargas (Inglés)](https://wiki.centos.org/Download)
- [Lista de preguntas frecuentes (Inglés)](https://www.centos.org/forums/faq.php?sid=4e6d260284c7936505dcf75564717272)
- [Manuales (Inglés)](https://www.centos.org/docs/)
- [página web oficial (Inglés)](https://www.centos.org)

### Fedora

- [Descargar Fedora (Inglés)](https://getfedora.org)
- [Guía de instalación (Inglés)](https://docs.fedoraproject.org/f26/install-guide/install/Preparing_for_Installation.html)
- [Preguntar Fedora](https://ask.fedoraproject.org/es/questions/)
- [¿Qué es Fedora?](https://docs-old.fedoraproject.org/es-ES/index.html)

### openSUSE

- [Cómo instalar OpenSUSE](https://es.opensuse.org/Portal:Instalaci%C3%B3n)
- [lista de razones por las cuales probar openSUSE (Inglés)](http://www.pcworld.com/article/222065/5_reasons_to_try_opensuse_114.html)
- [Preguntas frecuentes](https://es.opensuse.org/openSUSE:Preguntas_frecuentes)
- [una revisión de openSUSE (Inglés)](https://www.linux.com/news/opensuse-leap-421-review-most-mature-linux-distribution)
- [¿Qué es OpenSUSE?](https://es.wikipedia.org/wiki/OpenSUSE)

### Ubuntu

- [Cómo instalar Ubuntu (Inglés)](http://www.ubuntu.com/download/desktop/install-ubuntu-desktop)
- [Cómo Multiarranque con Windows y Ubuntu (Inglés)](http://www.everydaylinuxuser.com/2014/05/install-ubuntu-1404-alongside-windows.html)
- [Qué hacer después de instalar Ubuntu (Inglés)](http://www.omgubuntu.co.uk/2016/04/10-things-to-do-after-installing-ubuntu-16-04-lts)
- [¿Qué es Ubuntu?](https://es.wikipedia.org/wiki/Ubuntu)

### Otras distribuciones

> Más por venir

## Los Foros

### Arch Linux Foros

- [Foros de Arch Linux](https://bbs.archlinux.org/viewforum.php?id=30)
- [Foros de Arch Linux ARM (Inglés)](https://archlinuxarm.org/forum/viewforum.php?f=31)

### Bodhi Linux Foros

- [Foros de Bodhi Linux (Inglés)](http://forums.bodhilinux.com/)

### CentOS Foros

- [Foros de CentOS (Inglés)](https://www.centos.org/forums/)

### Fedora Foros

- [Foros de Fedora (Inglés)](https://forums.fedoraforum.org/index.php)

### Ubuntu Foros

- [Foros de Ubuntu](http://www.ubuntu-es.org/forum)
- [pregunta a ubuntu (Inglés)](askubuntu.com/)

### openSUSE Foros

- [Foros de openSUSE](http://www.forosuse.org/forosuse/)

### Canales IRC

- [#linux](http://webchat.freenode.net/?channels=#linux)
- [#ubuntu](https://webchat.freenode.net/?channels=ubuntu)
- [#archlinux](http://webchat.freenode.net/?channels=archlinux)
- [#debian](http://webchat.freenode.net/?channels=debian)
- [#gentoo](http://webchat.freenode.net/?channels=gentoo)
- [#docker](http://webchat.freenode.net/?channels=docker)
- [#bash](http://webchat.freenode.net/?channels=bash)

### Linux News, Aplicaciones y mucho más

- [OMG!Ubuntu](http://www.omgubuntu.co.uk/)
- [ITSFOSS](https://itsfoss.com/)
- [Linux official](https://www.linux.com/)
- [Webupd8](http://www.webupd8.org/)
- [Noobslab](http://www.noobslab.com/)
- [Make use of](http://www.makeuseof.com/service/linux/)
- [TecMint](http://www.tecmint.com/)
- [AllTop](http://linux.alltop.com/)
- [Unixmen](https://www.unixmen.com/)
- [DistroWatch](http://distrowatch.com/)
- [Phoronix](http://www.phoronix.com/)
- [Dedoimedo](http://www.dedoimedo.com/)
- [How-To Geek](https://www.howtogeek.com/category/linux/)
- [Liliputing](http://liliputing.com/)
- [FAMILUG](http://www.familug.org/)
- [Ubuntu Geek](http://www.ubuntugeek.com/)

### Reddit

- [Arch Linux](https://www.reddit.com/r/archlinux/)
- [CentOS](https://www.reddit.com/r/CentOS/)
- [Fedora](https://www.reddit.com/r/Fedora/)
- [Linux](https://www.reddit.com/r/linux/)
- [Open Source](https://www.reddit.com/r/opensource/)
- [Ubuntu](https://www.reddit.com/r/Ubuntu/)
- [Unix Porn](https://www.reddit.com/r/unixporn/)
- [Linux Kernel](https://www.reddit.com/r/kernel/)
- [Linux Gaming](https://www.reddit.com/r/linux_gaming/)

## Aprender linux

- [Aprenda los comandos de Linux (Inglés)](http://linuxcommand.org/)
- [Aprende Linux (Inglés)](https://linuxjourney.com/)
- [La pequeña guía de Linux (Inglés)](http://www.tldp.org/LDP/Pocket-Linux-Guide/Pocket-Linux-Guide.pdf)
- [Resumen de herramientas de línea de comandos de GNU/Linux (Inglés)](http://tldp.org/LDP/GNU-Linux-Tools-Summary/html/book1.htm)
- [Una clase de linux (Inglés)](https://www.edx.org/course/introduction-linux-linuxfoundationx-lfs101x-0)
- [Una guía para principiantes a Linux (Inglés)](https://www.linux.com/learn/complete-beginners-guide-linux%20)

## Desarrollo de linux

- [Archivo de correo de Linux Kernel (Inglés)](https://lkml.org/)
- [Archivos Kernel de Linux (página web oficial) (Inglés)](https://www.kernel.org/)
- [Dentro de Linux (Inglés)](https://0xax.gitbooks.io/linux-insides/content/index.html)
- [El kernel de Linux (Inglés)](http://www.tldp.org/LDP/tlk/tlk.html)
- [El kernel de Linux para principiantes (Inglés)](https://kernelnewbies.org/)
- [Guía de programación del módulo Linux Kernel (PDF) (Inglés)](http://www.tldp.org/LDP/lkmpg/2.6/lkmpg.pdf)
- [Linux kernel interno (PDF) (Inglés)](http://www.tldp.org/LDP/lki/lki.pdf)

## Linux avanzado

- [Contenedores virtuales (Inglés)](https://github.com/Citrix-TechSpecialist/Docker-101)
- [Virtualización con Virtualbox (Inglés)](https://www.virtualbox.org/manual/ch01.html)

## Los otros listas impresionantes

_Estas son otras listas recomendadas:_

- [Awesome Linux Audio](https://github.com/nodiscc/awesome-linuxaudio)
- [Awesome Self-hosted](https://github.com/kickball/awesome-selfhosted)
- [Awesome Sysadmin](https://github.com/n1trux/awesome-sysadmin)

## Contribuidores

Muchas gracias a [**Todos los colaboradores de Github**](https://github.com/LewisVo/Awesome-Linux-Software/graphs/contributors) por hacer esta lista posible y
_todos en reddit.com/r/linux y reddit.com/r/ubuntu y vozforums.com y otros foros por todas las sugerencias y elogios._
...

**[⬆ volver arriba](#el-índice-de-contenidos)**

<br>

## Reglas para contribuir

> Simplemente agregue el nombre de la **aplicación** en la lista.
> Enlace a su **página de inicio** o una **guía** sobre cómo instalarlo.
> Escriba también una **breve descripción** para la aplicación y añada un **icono**.
> Asegúrese de ponerlo bajo el **tema apropiado**.
> Si la aplicación no encaja en ningún **tema existente**, haga uno **nuevo**.
> Asegúrese de que todo esté **ordenado alfabéticamente**.

## Cómo contribuir

- [Cómo usar github (Inglés)](https://docs.github.com/en/get-started/exploring-projects-on-github/contributing-to-a-project)
- [Cómo utilizar Git desde la línea de comandos.](https://rogerdudler.github.io/git-guide/index.es.html)
- [¿Qué es Markdown?](https://github.com/LewisVo/Markdown-Tutorial/blob/master/Translation:Spanish.md) - Markdown es el método de escritura usado para crear esta lista, si quieres aprender el formato apropiado, lo mejor es que aprendas cómo usar Github Markdown.
- [Guía alternativa para Markdown (Inglés)](https://docs.github.com/en/get-started/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax)

_Los artículos marcados ![Open-Source Software][oss icon] son software de código abierto y tienen un enlace al código fuente. Los artículos marcados [![Nonfree][money icon] cuesta dinero (como en cerveza que cuesta dinero)._

<br>

_Nota del autor: Recientemente, recibí comentarios de ustedes sobre la calidad de algunas aplicaciones en esta lista. Yo mismo probé muchas de ellas, pero no todas. Si tienes algún problema con las aplicaciones, por favor: -> ve a la página del dev (si está disponible) -> Levanta un "issue" para el dev allí -> haz un "issue" aquí para que pueda considerar si debo sacar la aplicación de la lista. Recuerde: Todo tiene su propia calidad, por lo que nunca habrá algo como "mejor aplicación" o "lista selectiva" aquí, gracias._

<br>

## Licencia

[![Licencias Creative Commons](http://i.creativecommons.org/l/by/4.0/88x31.png)](https://creativecommons.org/licenses/by/4.0/deed.es_ES)

Este trabajo está licenciado con [Creative Commons Reconocimiento 4.0 Internacional](https://creativecommons.org/licenses/by/4.0/deed.es_ES).

[oss icon]: https://cdn.rawgit.com/iCHAIT/awesome-osx/master/media/oss.svg
[money icon]: https://rawgit.com/LewisVo/Awesome-Linux-Software/master/img/money.svg

<!-- markdown-link-check-enable -->
