<!-- markdown-link-check-disable -->
# Guidelines to Contribute

## English

> Simply put the name of the **application** in the list.
> Link to its **homepage** or a **guide** on how to install it.
> Also write a **short description** for the application + add **icon**.
> Make sure it is put under the **appropriate topic**.
> If the application doesn't fit in any **existing topic**, make a **new one** for it.
> Ensure everything is **alphabetically sorted**.

### Unsure how to contribute?

- [How to Use Github](https://docs.github.com/en/get-started/exploring-projects-on-github/contributing-to-a-project)
- [How to Git from the Command Line](https://rogerdudler.github.io/git-guide/)
- [What is Markdown?](https://github.com/LewisVo/Markdown-Tutorial) - Markdown is the writing method used to create this list, if you want to know how to format properly, it's best that you learn how to use Github Markdown.
- [Alternative Markdown Guide:](https://docs.github.com/en/get-started/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax)

*Items marked with [![Open-Source Software][OSS Icon] are open-source software and link to the source code. Items marked with [![Nonfree][Money Icon] are nonfree (as in nonfree beer) and may cost money to use.*

## Español

> Simplemente cree el nombre de la **aplicación** en la lista.
> Enlace a su **página de inicio** o **una guía** sobre cómo instalarlo.
> Escriba también una **breve descripción** para la aplicación + añadir **icono**.
> Asegúrese de que se pone bajo el **tema apropiado**.
> Si la aplicación no encaja en ningún **tema existente**, haga un **nuevo** para ello.
> Asegúrese de que todo esté **ordenado alfabéticamente**.

### Cómo contribuir

- [How to Use Github (Inglés)](https://docs.github.com/en/get-started/exploring-projects-on-github/contributing-to-a-project)
- [Cómo utilizar Git desde la línea de comandos.](https://rogerdudler.github.io/git-guide/index.es.html)
- [¿Qué es Markdown?](https://github.com/LewisVo/Markdown-Tutorial/blob/master/Translation:Spanish.md) - Markdown es un tipo de código utilizado para crear esta lista, que utiliza un tipo específico llamado: GitHub Markdown.
- [Alternative Markdown Guide (Inglés)](https://docs.github.com/en/get-started/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax)

*Artículos marcados [![Open-Source Software][OSS Icon] son software de código abierto y tienen un enlace al código fuente. Artículos marcados [![Nonfree][Money Icon] cuesta dinero (como en cerveza que cuesta dinero).*

<br>

*Nota del autor: Recientemente, recibí comentarios de usted sobre la calidad de algunas aplicaciones en esta lista. Yo mismo los probé mucho (no todos ellos, sin embargo). Si tienes algún problema con las aplicaciones, por favor: -> ir a la página de dev (si está disponible) -> hacer un problema para el dev allí -> hacer un problema aquí para que pueda considerar si debo sacar la aplicación de la lista. Recuerde: Todo tiene su propia calidad, por lo que nunca habrá algo como "mejor aplicación" o "lista selectiva" aquí, gracias.*

<br>

## Português

> Basta colocar o nome da **aplicação** na lista.
> Link para a sua **página inicial** ou um **guia** como instalá-la.
> Escreva tambÃ©m uma **breve descrição** para uma aplicação + adicionando um **icone**.
> Certifique-se de que o software está escrito no seu **tópico apropriado**.
> Se o aplicativo não se encaixa em nenhum **tópico existente**, faça **um novo** para ele.
> Certifique que tudo seja classificado em ordem **alfabética**.

### Unsure how to contribute?

- [How to Use Github](https://docs.github.com/en/get-started/exploring-projects-on-github/contributing-to-a-project)
- [How to Git from the Command Line](https://rogerdudler.github.io/git-guide/)
- [What is Markdown?](https://github.com/LewisVo/Markdown-Tutorial) - Markdown is the writing method used to create this list, if you want to know how to format properly, it's best that you learn how to use Github Markdown.
- [Alternative Markdown Guide:](https://docs.github.com/en/get-started/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax)

*Itens marcados com [![open-Source Software][OSS Icon] são software de código aberto e link para o código-fonte. Os itens marcados com ![Nonfree][Money Icon] são não livres (as in nonfree beer) e pode custar dinheiro para poder utilizá-lo.*

## 汉语

将应用的名称放入列表。 链接到它的主页或安装指南。 再给应用写一小段简短的介绍 + 添加图标。 确保应用放在了合适的主题下。 如果应用不在以上任何一个已有的主题内，为它新建一个主题。 确保所有项都是按字母表顺序排序的。
标有 Open-Source Software 的是开源软件并且链接到源代码。标有 Freeware 的意为免费（就如免费的啤酒）。


原作者注：最近我收到了一些关于列表中一些应用软件的质量的反馈。我自己测试了其中的大部分应用（但不是全部）。如果你对应用有任何问题：-> 去往开发页面（如果有的话）-> 给开发提个 issue -> 在这里提个 issue 以便我考虑是否将应用移出列表。记住：所有东西都有它自己的质量，所以这里永远不会有“最佳应用”或“选择性的列表”，谢谢。
<!-- markdown-link-check-enable -->
