import { CheckLogic } from "shared";
import { useProjectMutation, useProjectSWR } from ".";
import { fetcher } from "../fetcher";

interface CreateEvaluatorData {
  ownerId?: string;
  name: string;
  slug: string;
  description?: string;
  type: string;
  mode: string;
  params: Record<string, any>;
  filters?: CheckLogic;
}

export function useEnrichers() {
  const { data, isLoading, mutate } = useProjectSWR(`/evaluators`);

  const { trigger: insertMutation } = useProjectMutation(
    `/evaluators`,
    fetcher.post,
  );

  async function insert(data: CreateEvaluatorData) {
    insertMutation(data);
  }

  return {
    enrichers: data,
    mutate,
    isLoading,
    insert,
  };
}

export function useEnricher(id: string, initialData?: any) {
  const { mutate: mutateEvaluators } = useEnrichers();

  const { data, isLoading, mutate } = useProjectSWR(id && `/evaluators/${id}`, {
    fallbackData: initialData,
  });

  const { trigger: updateMutation } = useProjectMutation(
    `/evaluators/${id}`,
    fetcher.patch,
  );

  const { trigger: deleteMutation } = useProjectMutation(
    `/evaluators/${id}`,
    fetcher.delete,
    {
      onSuccess() {
        mutateEvaluators((evaluators) => evaluators.filter((r) => r.id !== id));
      },
    },
  );

  return {
    enricher: data,
    update: updateMutation,
    delete: deleteMutation,
    mutate,
    isLoading,
  };
}
