// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: chat/chat.proto

package chatconnect

import (
	context "context"
	errors "errors"
	connect_go "github.com/bufbuild/connect-go"
	chat "github.com/lunabrain-ai/lunabrain/pkg/gen/chat"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect_go.IsAtLeastVersion0_1_0

const (
	// ChatServiceName is the fully-qualified name of the ChatService service.
	ChatServiceName = "chat.ChatService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// ChatServiceSendMessageProcedure is the fully-qualified name of the ChatService's SendMessage RPC.
	ChatServiceSendMessageProcedure = "/chat.ChatService/SendMessage"
	// ChatServiceReceiveMessagesProcedure is the fully-qualified name of the ChatService's
	// ReceiveMessages RPC.
	ChatServiceReceiveMessagesProcedure = "/chat.ChatService/ReceiveMessages"
	// ChatServiceBanUserProcedure is the fully-qualified name of the ChatService's BanUser RPC.
	ChatServiceBanUserProcedure = "/chat.ChatService/BanUser"
)

// ChatServiceClient is a client for the chat.ChatService service.
type ChatServiceClient interface {
	SendMessage(context.Context, *connect_go.Request[chat.SendMessageRequest]) (*connect_go.Response[chat.SendMessageResponse], error)
	ReceiveMessages(context.Context, *connect_go.Request[chat.ReceiveMessagesRequest]) (*connect_go.ServerStreamForClient[chat.Message], error)
	BanUser(context.Context, *connect_go.Request[chat.BanUserRequest]) (*connect_go.Response[chat.BanUserResponse], error)
}

// NewChatServiceClient constructs a client for the chat.ChatService service. By default, it uses
// the Connect protocol with the binary Protobuf Codec, asks for gzipped responses, and sends
// uncompressed requests. To use the gRPC or gRPC-Web protocols, supply the connect.WithGRPC() or
// connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewChatServiceClient(httpClient connect_go.HTTPClient, baseURL string, opts ...connect_go.ClientOption) ChatServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &chatServiceClient{
		sendMessage: connect_go.NewClient[chat.SendMessageRequest, chat.SendMessageResponse](
			httpClient,
			baseURL+ChatServiceSendMessageProcedure,
			opts...,
		),
		receiveMessages: connect_go.NewClient[chat.ReceiveMessagesRequest, chat.Message](
			httpClient,
			baseURL+ChatServiceReceiveMessagesProcedure,
			opts...,
		),
		banUser: connect_go.NewClient[chat.BanUserRequest, chat.BanUserResponse](
			httpClient,
			baseURL+ChatServiceBanUserProcedure,
			opts...,
		),
	}
}

// chatServiceClient implements ChatServiceClient.
type chatServiceClient struct {
	sendMessage     *connect_go.Client[chat.SendMessageRequest, chat.SendMessageResponse]
	receiveMessages *connect_go.Client[chat.ReceiveMessagesRequest, chat.Message]
	banUser         *connect_go.Client[chat.BanUserRequest, chat.BanUserResponse]
}

// SendMessage calls chat.ChatService.SendMessage.
func (c *chatServiceClient) SendMessage(ctx context.Context, req *connect_go.Request[chat.SendMessageRequest]) (*connect_go.Response[chat.SendMessageResponse], error) {
	return c.sendMessage.CallUnary(ctx, req)
}

// ReceiveMessages calls chat.ChatService.ReceiveMessages.
func (c *chatServiceClient) ReceiveMessages(ctx context.Context, req *connect_go.Request[chat.ReceiveMessagesRequest]) (*connect_go.ServerStreamForClient[chat.Message], error) {
	return c.receiveMessages.CallServerStream(ctx, req)
}

// BanUser calls chat.ChatService.BanUser.
func (c *chatServiceClient) BanUser(ctx context.Context, req *connect_go.Request[chat.BanUserRequest]) (*connect_go.Response[chat.BanUserResponse], error) {
	return c.banUser.CallUnary(ctx, req)
}

// ChatServiceHandler is an implementation of the chat.ChatService service.
type ChatServiceHandler interface {
	SendMessage(context.Context, *connect_go.Request[chat.SendMessageRequest]) (*connect_go.Response[chat.SendMessageResponse], error)
	ReceiveMessages(context.Context, *connect_go.Request[chat.ReceiveMessagesRequest], *connect_go.ServerStream[chat.Message]) error
	BanUser(context.Context, *connect_go.Request[chat.BanUserRequest]) (*connect_go.Response[chat.BanUserResponse], error)
}

// NewChatServiceHandler builds an HTTP handler from the service implementation. It returns the path
// on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewChatServiceHandler(svc ChatServiceHandler, opts ...connect_go.HandlerOption) (string, http.Handler) {
	chatServiceSendMessageHandler := connect_go.NewUnaryHandler(
		ChatServiceSendMessageProcedure,
		svc.SendMessage,
		opts...,
	)
	chatServiceReceiveMessagesHandler := connect_go.NewServerStreamHandler(
		ChatServiceReceiveMessagesProcedure,
		svc.ReceiveMessages,
		opts...,
	)
	chatServiceBanUserHandler := connect_go.NewUnaryHandler(
		ChatServiceBanUserProcedure,
		svc.BanUser,
		opts...,
	)
	return "/chat.ChatService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case ChatServiceSendMessageProcedure:
			chatServiceSendMessageHandler.ServeHTTP(w, r)
		case ChatServiceReceiveMessagesProcedure:
			chatServiceReceiveMessagesHandler.ServeHTTP(w, r)
		case ChatServiceBanUserProcedure:
			chatServiceBanUserHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedChatServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedChatServiceHandler struct{}

func (UnimplementedChatServiceHandler) SendMessage(context.Context, *connect_go.Request[chat.SendMessageRequest]) (*connect_go.Response[chat.SendMessageResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("chat.ChatService.SendMessage is not implemented"))
}

func (UnimplementedChatServiceHandler) ReceiveMessages(context.Context, *connect_go.Request[chat.ReceiveMessagesRequest], *connect_go.ServerStream[chat.Message]) error {
	return connect_go.NewError(connect_go.CodeUnimplemented, errors.New("chat.ChatService.ReceiveMessages is not implemented"))
}

func (UnimplementedChatServiceHandler) BanUser(context.Context, *connect_go.Request[chat.BanUserRequest]) (*connect_go.Response[chat.BanUserResponse], error) {
	return nil, connect_go.NewError(connect_go.CodeUnimplemented, errors.New("chat.ChatService.BanUser is not implemented"))
}
