// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/google/uuid"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/content"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/groupuser"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/predicate"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/schema"
	entuser "github.com/lunabrain-ai/lunabrain/pkg/ent/user"
	"github.com/markbates/goth"
)

// UserUpdate is the builder for updating User entities.
type UserUpdate struct {
	config
	hooks    []Hook
	mutation *UserMutation
}

// Where appends a list predicates to the UserUpdate builder.
func (uu *UserUpdate) Where(ps ...predicate.User) *UserUpdate {
	uu.mutation.Where(ps...)
	return uu
}

// SetEmail sets the "email" field.
func (uu *UserUpdate) SetEmail(s string) *UserUpdate {
	uu.mutation.SetEmail(s)
	return uu
}

// SetPasswordHash sets the "password_hash" field.
func (uu *UserUpdate) SetPasswordHash(s string) *UserUpdate {
	uu.mutation.SetPasswordHash(s)
	return uu
}

// SetNillablePasswordHash sets the "password_hash" field if the given value is not nil.
func (uu *UserUpdate) SetNillablePasswordHash(s *string) *UserUpdate {
	if s != nil {
		uu.SetPasswordHash(*s)
	}
	return uu
}

// ClearPasswordHash clears the value of the "password_hash" field.
func (uu *UserUpdate) ClearPasswordHash() *UserUpdate {
	uu.mutation.ClearPasswordHash()
	return uu
}

// SetData sets the "data" field.
func (uu *UserUpdate) SetData(se schema.UserEncoder) *UserUpdate {
	uu.mutation.SetData(se)
	return uu
}

// SetVerified sets the "verified" field.
func (uu *UserUpdate) SetVerified(b bool) *UserUpdate {
	uu.mutation.SetVerified(b)
	return uu
}

// SetNillableVerified sets the "verified" field if the given value is not nil.
func (uu *UserUpdate) SetNillableVerified(b *bool) *UserUpdate {
	if b != nil {
		uu.SetVerified(*b)
	}
	return uu
}

// SetVerifySecret sets the "verify_secret" field.
func (uu *UserUpdate) SetVerifySecret(u uuid.UUID) *UserUpdate {
	uu.mutation.SetVerifySecret(u)
	return uu
}

// SetNillableVerifySecret sets the "verify_secret" field if the given value is not nil.
func (uu *UserUpdate) SetNillableVerifySecret(u *uuid.UUID) *UserUpdate {
	if u != nil {
		uu.SetVerifySecret(*u)
	}
	return uu
}

// ClearVerifySecret clears the value of the "verify_secret" field.
func (uu *UserUpdate) ClearVerifySecret() *UserUpdate {
	uu.mutation.ClearVerifySecret()
	return uu
}

// SetOauthUser sets the "oauth_user" field.
func (uu *UserUpdate) SetOauthUser(_go goth.User) *UserUpdate {
	uu.mutation.SetOauthUser(_go)
	return uu
}

// SetNillableOauthUser sets the "oauth_user" field if the given value is not nil.
func (uu *UserUpdate) SetNillableOauthUser(_go *goth.User) *UserUpdate {
	if _go != nil {
		uu.SetOauthUser(*_go)
	}
	return uu
}

// AddContentIDs adds the "content" edge to the Content entity by IDs.
func (uu *UserUpdate) AddContentIDs(ids ...uuid.UUID) *UserUpdate {
	uu.mutation.AddContentIDs(ids...)
	return uu
}

// AddContent adds the "content" edges to the Content entity.
func (uu *UserUpdate) AddContent(c ...*Content) *UserUpdate {
	ids := make([]uuid.UUID, len(c))
	for i := range c {
		ids[i] = c[i].ID
	}
	return uu.AddContentIDs(ids...)
}

// AddGroupUserIDs adds the "group_users" edge to the GroupUser entity by IDs.
func (uu *UserUpdate) AddGroupUserIDs(ids ...uuid.UUID) *UserUpdate {
	uu.mutation.AddGroupUserIDs(ids...)
	return uu
}

// AddGroupUsers adds the "group_users" edges to the GroupUser entity.
func (uu *UserUpdate) AddGroupUsers(g ...*GroupUser) *UserUpdate {
	ids := make([]uuid.UUID, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return uu.AddGroupUserIDs(ids...)
}

// Mutation returns the UserMutation object of the builder.
func (uu *UserUpdate) Mutation() *UserMutation {
	return uu.mutation
}

// ClearContent clears all "content" edges to the Content entity.
func (uu *UserUpdate) ClearContent() *UserUpdate {
	uu.mutation.ClearContent()
	return uu
}

// RemoveContentIDs removes the "content" edge to Content entities by IDs.
func (uu *UserUpdate) RemoveContentIDs(ids ...uuid.UUID) *UserUpdate {
	uu.mutation.RemoveContentIDs(ids...)
	return uu
}

// RemoveContent removes "content" edges to Content entities.
func (uu *UserUpdate) RemoveContent(c ...*Content) *UserUpdate {
	ids := make([]uuid.UUID, len(c))
	for i := range c {
		ids[i] = c[i].ID
	}
	return uu.RemoveContentIDs(ids...)
}

// ClearGroupUsers clears all "group_users" edges to the GroupUser entity.
func (uu *UserUpdate) ClearGroupUsers() *UserUpdate {
	uu.mutation.ClearGroupUsers()
	return uu
}

// RemoveGroupUserIDs removes the "group_users" edge to GroupUser entities by IDs.
func (uu *UserUpdate) RemoveGroupUserIDs(ids ...uuid.UUID) *UserUpdate {
	uu.mutation.RemoveGroupUserIDs(ids...)
	return uu
}

// RemoveGroupUsers removes "group_users" edges to GroupUser entities.
func (uu *UserUpdate) RemoveGroupUsers(g ...*GroupUser) *UserUpdate {
	ids := make([]uuid.UUID, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return uu.RemoveGroupUserIDs(ids...)
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (uu *UserUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, uu.sqlSave, uu.mutation, uu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (uu *UserUpdate) SaveX(ctx context.Context) int {
	affected, err := uu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (uu *UserUpdate) Exec(ctx context.Context) error {
	_, err := uu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (uu *UserUpdate) ExecX(ctx context.Context) {
	if err := uu.Exec(ctx); err != nil {
		panic(err)
	}
}

func (uu *UserUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(entuser.Table, entuser.Columns, sqlgraph.NewFieldSpec(entuser.FieldID, field.TypeUUID))
	if ps := uu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := uu.mutation.Email(); ok {
		_spec.SetField(entuser.FieldEmail, field.TypeString, value)
	}
	if value, ok := uu.mutation.PasswordHash(); ok {
		_spec.SetField(entuser.FieldPasswordHash, field.TypeString, value)
	}
	if uu.mutation.PasswordHashCleared() {
		_spec.ClearField(entuser.FieldPasswordHash, field.TypeString)
	}
	if value, ok := uu.mutation.Data(); ok {
		_spec.SetField(entuser.FieldData, field.TypeJSON, value)
	}
	if value, ok := uu.mutation.Verified(); ok {
		_spec.SetField(entuser.FieldVerified, field.TypeBool, value)
	}
	if value, ok := uu.mutation.VerifySecret(); ok {
		_spec.SetField(entuser.FieldVerifySecret, field.TypeUUID, value)
	}
	if uu.mutation.VerifySecretCleared() {
		_spec.ClearField(entuser.FieldVerifySecret, field.TypeUUID)
	}
	if value, ok := uu.mutation.OauthUser(); ok {
		_spec.SetField(entuser.FieldOauthUser, field.TypeJSON, value)
	}
	if uu.mutation.ContentCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   entuser.ContentTable,
			Columns: []string{entuser.ContentColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(content.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uu.mutation.RemovedContentIDs(); len(nodes) > 0 && !uu.mutation.ContentCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   entuser.ContentTable,
			Columns: []string{entuser.ContentColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(content.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uu.mutation.ContentIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   entuser.ContentTable,
			Columns: []string{entuser.ContentColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(content.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if uu.mutation.GroupUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   entuser.GroupUsersTable,
			Columns: []string{entuser.GroupUsersColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupuser.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uu.mutation.RemovedGroupUsersIDs(); len(nodes) > 0 && !uu.mutation.GroupUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   entuser.GroupUsersTable,
			Columns: []string{entuser.GroupUsersColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupuser.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uu.mutation.GroupUsersIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   entuser.GroupUsersTable,
			Columns: []string{entuser.GroupUsersColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupuser.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, uu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{entuser.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	uu.mutation.done = true
	return n, nil
}

// UserUpdateOne is the builder for updating a single User entity.
type UserUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *UserMutation
}

// SetEmail sets the "email" field.
func (uuo *UserUpdateOne) SetEmail(s string) *UserUpdateOne {
	uuo.mutation.SetEmail(s)
	return uuo
}

// SetPasswordHash sets the "password_hash" field.
func (uuo *UserUpdateOne) SetPasswordHash(s string) *UserUpdateOne {
	uuo.mutation.SetPasswordHash(s)
	return uuo
}

// SetNillablePasswordHash sets the "password_hash" field if the given value is not nil.
func (uuo *UserUpdateOne) SetNillablePasswordHash(s *string) *UserUpdateOne {
	if s != nil {
		uuo.SetPasswordHash(*s)
	}
	return uuo
}

// ClearPasswordHash clears the value of the "password_hash" field.
func (uuo *UserUpdateOne) ClearPasswordHash() *UserUpdateOne {
	uuo.mutation.ClearPasswordHash()
	return uuo
}

// SetData sets the "data" field.
func (uuo *UserUpdateOne) SetData(se schema.UserEncoder) *UserUpdateOne {
	uuo.mutation.SetData(se)
	return uuo
}

// SetVerified sets the "verified" field.
func (uuo *UserUpdateOne) SetVerified(b bool) *UserUpdateOne {
	uuo.mutation.SetVerified(b)
	return uuo
}

// SetNillableVerified sets the "verified" field if the given value is not nil.
func (uuo *UserUpdateOne) SetNillableVerified(b *bool) *UserUpdateOne {
	if b != nil {
		uuo.SetVerified(*b)
	}
	return uuo
}

// SetVerifySecret sets the "verify_secret" field.
func (uuo *UserUpdateOne) SetVerifySecret(u uuid.UUID) *UserUpdateOne {
	uuo.mutation.SetVerifySecret(u)
	return uuo
}

// SetNillableVerifySecret sets the "verify_secret" field if the given value is not nil.
func (uuo *UserUpdateOne) SetNillableVerifySecret(u *uuid.UUID) *UserUpdateOne {
	if u != nil {
		uuo.SetVerifySecret(*u)
	}
	return uuo
}

// ClearVerifySecret clears the value of the "verify_secret" field.
func (uuo *UserUpdateOne) ClearVerifySecret() *UserUpdateOne {
	uuo.mutation.ClearVerifySecret()
	return uuo
}

// SetOauthUser sets the "oauth_user" field.
func (uuo *UserUpdateOne) SetOauthUser(_go goth.User) *UserUpdateOne {
	uuo.mutation.SetOauthUser(_go)
	return uuo
}

// SetNillableOauthUser sets the "oauth_user" field if the given value is not nil.
func (uuo *UserUpdateOne) SetNillableOauthUser(_go *goth.User) *UserUpdateOne {
	if _go != nil {
		uuo.SetOauthUser(*_go)
	}
	return uuo
}

// AddContentIDs adds the "content" edge to the Content entity by IDs.
func (uuo *UserUpdateOne) AddContentIDs(ids ...uuid.UUID) *UserUpdateOne {
	uuo.mutation.AddContentIDs(ids...)
	return uuo
}

// AddContent adds the "content" edges to the Content entity.
func (uuo *UserUpdateOne) AddContent(c ...*Content) *UserUpdateOne {
	ids := make([]uuid.UUID, len(c))
	for i := range c {
		ids[i] = c[i].ID
	}
	return uuo.AddContentIDs(ids...)
}

// AddGroupUserIDs adds the "group_users" edge to the GroupUser entity by IDs.
func (uuo *UserUpdateOne) AddGroupUserIDs(ids ...uuid.UUID) *UserUpdateOne {
	uuo.mutation.AddGroupUserIDs(ids...)
	return uuo
}

// AddGroupUsers adds the "group_users" edges to the GroupUser entity.
func (uuo *UserUpdateOne) AddGroupUsers(g ...*GroupUser) *UserUpdateOne {
	ids := make([]uuid.UUID, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return uuo.AddGroupUserIDs(ids...)
}

// Mutation returns the UserMutation object of the builder.
func (uuo *UserUpdateOne) Mutation() *UserMutation {
	return uuo.mutation
}

// ClearContent clears all "content" edges to the Content entity.
func (uuo *UserUpdateOne) ClearContent() *UserUpdateOne {
	uuo.mutation.ClearContent()
	return uuo
}

// RemoveContentIDs removes the "content" edge to Content entities by IDs.
func (uuo *UserUpdateOne) RemoveContentIDs(ids ...uuid.UUID) *UserUpdateOne {
	uuo.mutation.RemoveContentIDs(ids...)
	return uuo
}

// RemoveContent removes "content" edges to Content entities.
func (uuo *UserUpdateOne) RemoveContent(c ...*Content) *UserUpdateOne {
	ids := make([]uuid.UUID, len(c))
	for i := range c {
		ids[i] = c[i].ID
	}
	return uuo.RemoveContentIDs(ids...)
}

// ClearGroupUsers clears all "group_users" edges to the GroupUser entity.
func (uuo *UserUpdateOne) ClearGroupUsers() *UserUpdateOne {
	uuo.mutation.ClearGroupUsers()
	return uuo
}

// RemoveGroupUserIDs removes the "group_users" edge to GroupUser entities by IDs.
func (uuo *UserUpdateOne) RemoveGroupUserIDs(ids ...uuid.UUID) *UserUpdateOne {
	uuo.mutation.RemoveGroupUserIDs(ids...)
	return uuo
}

// RemoveGroupUsers removes "group_users" edges to GroupUser entities.
func (uuo *UserUpdateOne) RemoveGroupUsers(g ...*GroupUser) *UserUpdateOne {
	ids := make([]uuid.UUID, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return uuo.RemoveGroupUserIDs(ids...)
}

// Where appends a list predicates to the UserUpdate builder.
func (uuo *UserUpdateOne) Where(ps ...predicate.User) *UserUpdateOne {
	uuo.mutation.Where(ps...)
	return uuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (uuo *UserUpdateOne) Select(field string, fields ...string) *UserUpdateOne {
	uuo.fields = append([]string{field}, fields...)
	return uuo
}

// Save executes the query and returns the updated User entity.
func (uuo *UserUpdateOne) Save(ctx context.Context) (*User, error) {
	return withHooks(ctx, uuo.sqlSave, uuo.mutation, uuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (uuo *UserUpdateOne) SaveX(ctx context.Context) *User {
	node, err := uuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (uuo *UserUpdateOne) Exec(ctx context.Context) error {
	_, err := uuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (uuo *UserUpdateOne) ExecX(ctx context.Context) {
	if err := uuo.Exec(ctx); err != nil {
		panic(err)
	}
}

func (uuo *UserUpdateOne) sqlSave(ctx context.Context) (_node *User, err error) {
	_spec := sqlgraph.NewUpdateSpec(entuser.Table, entuser.Columns, sqlgraph.NewFieldSpec(entuser.FieldID, field.TypeUUID))
	id, ok := uuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "User.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := uuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, entuser.FieldID)
		for _, f := range fields {
			if !entuser.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != entuser.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := uuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := uuo.mutation.Email(); ok {
		_spec.SetField(entuser.FieldEmail, field.TypeString, value)
	}
	if value, ok := uuo.mutation.PasswordHash(); ok {
		_spec.SetField(entuser.FieldPasswordHash, field.TypeString, value)
	}
	if uuo.mutation.PasswordHashCleared() {
		_spec.ClearField(entuser.FieldPasswordHash, field.TypeString)
	}
	if value, ok := uuo.mutation.Data(); ok {
		_spec.SetField(entuser.FieldData, field.TypeJSON, value)
	}
	if value, ok := uuo.mutation.Verified(); ok {
		_spec.SetField(entuser.FieldVerified, field.TypeBool, value)
	}
	if value, ok := uuo.mutation.VerifySecret(); ok {
		_spec.SetField(entuser.FieldVerifySecret, field.TypeUUID, value)
	}
	if uuo.mutation.VerifySecretCleared() {
		_spec.ClearField(entuser.FieldVerifySecret, field.TypeUUID)
	}
	if value, ok := uuo.mutation.OauthUser(); ok {
		_spec.SetField(entuser.FieldOauthUser, field.TypeJSON, value)
	}
	if uuo.mutation.ContentCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   entuser.ContentTable,
			Columns: []string{entuser.ContentColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(content.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uuo.mutation.RemovedContentIDs(); len(nodes) > 0 && !uuo.mutation.ContentCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   entuser.ContentTable,
			Columns: []string{entuser.ContentColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(content.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uuo.mutation.ContentIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   entuser.ContentTable,
			Columns: []string{entuser.ContentColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(content.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if uuo.mutation.GroupUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   entuser.GroupUsersTable,
			Columns: []string{entuser.GroupUsersColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupuser.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uuo.mutation.RemovedGroupUsersIDs(); len(nodes) > 0 && !uuo.mutation.GroupUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   entuser.GroupUsersTable,
			Columns: []string{entuser.GroupUsersColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupuser.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uuo.mutation.GroupUsersIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   entuser.GroupUsersTable,
			Columns: []string{entuser.GroupUsersColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupuser.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &User{config: uuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, uuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{entuser.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	uuo.mutation.done = true
	return _node, nil
}
