// Code generated by ent, DO NOT EDIT.

package entuser

import (
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"github.com/google/uuid"
	"github.com/markbates/goth"
)

const (
	// Label holds the string label denoting the user type in the database.
	Label = "user"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldEmail holds the string denoting the email field in the database.
	FieldEmail = "email"
	// FieldPasswordHash holds the string denoting the password_hash field in the database.
	FieldPasswordHash = "password_hash"
	// FieldData holds the string denoting the data field in the database.
	FieldData = "data"
	// FieldVerified holds the string denoting the verified field in the database.
	FieldVerified = "verified"
	// FieldVerifySecret holds the string denoting the verify_secret field in the database.
	FieldVerifySecret = "verify_secret"
	// FieldOauthUser holds the string denoting the oauth_user field in the database.
	FieldOauthUser = "oauth_user"
	// EdgeContent holds the string denoting the content edge name in mutations.
	EdgeContent = "content"
	// EdgeGroupUsers holds the string denoting the group_users edge name in mutations.
	EdgeGroupUsers = "group_users"
	// Table holds the table name of the user in the database.
	Table = "users"
	// ContentTable is the table that holds the content relation/edge.
	ContentTable = "contents"
	// ContentInverseTable is the table name for the Content entity.
	// It exists in this package in order to avoid circular dependency with the "content" package.
	ContentInverseTable = "contents"
	// ContentColumn is the table column denoting the content relation/edge.
	ContentColumn = "user_content"
	// GroupUsersTable is the table that holds the group_users relation/edge.
	GroupUsersTable = "group_users"
	// GroupUsersInverseTable is the table name for the GroupUser entity.
	// It exists in this package in order to avoid circular dependency with the "groupuser" package.
	GroupUsersInverseTable = "group_users"
	// GroupUsersColumn is the table column denoting the group_users relation/edge.
	GroupUsersColumn = "user_group_users"
)

// Columns holds all SQL columns for user fields.
var Columns = []string{
	FieldID,
	FieldEmail,
	FieldPasswordHash,
	FieldData,
	FieldVerified,
	FieldVerifySecret,
	FieldOauthUser,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultVerified holds the default value on creation for the "verified" field.
	DefaultVerified bool
	// DefaultOauthUser holds the default value on creation for the "oauth_user" field.
	DefaultOauthUser goth.User
	// DefaultID holds the default value on creation for the "id" field.
	DefaultID func() uuid.UUID
)

// OrderOption defines the ordering options for the User queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByEmail orders the results by the email field.
func ByEmail(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldEmail, opts...).ToFunc()
}

// ByPasswordHash orders the results by the password_hash field.
func ByPasswordHash(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldPasswordHash, opts...).ToFunc()
}

// ByVerified orders the results by the verified field.
func ByVerified(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldVerified, opts...).ToFunc()
}

// ByVerifySecret orders the results by the verify_secret field.
func ByVerifySecret(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldVerifySecret, opts...).ToFunc()
}

// ByContentCount orders the results by content count.
func ByContentCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newContentStep(), opts...)
	}
}

// ByContent orders the results by content terms.
func ByContent(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newContentStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByGroupUsersCount orders the results by group_users count.
func ByGroupUsersCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newGroupUsersStep(), opts...)
	}
}

// ByGroupUsers orders the results by group_users terms.
func ByGroupUsers(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newGroupUsersStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}
func newContentStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(ContentInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, ContentTable, ContentColumn),
	)
}
func newGroupUsersStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(GroupUsersInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, GroupUsersTable, GroupUsersColumn),
	)
}
