// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"sync"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/google/uuid"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/content"
	entevent "github.com/lunabrain-ai/lunabrain/pkg/ent/event"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/group"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/groupinvite"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/groupuser"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/predicate"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/schema"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/session"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/tag"
	entuser "github.com/lunabrain-ai/lunabrain/pkg/ent/user"
	"github.com/lunabrain-ai/lunabrain/pkg/gen/event"
	"github.com/lunabrain-ai/lunabrain/pkg/gen/user"
	"github.com/markbates/goth"
)

const (
	// Operation types.
	OpCreate    = ent.OpCreate
	OpDelete    = ent.OpDelete
	OpDeleteOne = ent.OpDeleteOne
	OpUpdate    = ent.OpUpdate
	OpUpdateOne = ent.OpUpdateOne

	// Node types.
	TypeContent     = "Content"
	TypeEvent       = "Event"
	TypeGroup       = "Group"
	TypeGroupInvite = "GroupInvite"
	TypeGroupUser   = "GroupUser"
	TypeSession     = "Session"
	TypeTag         = "Tag"
	TypeUser        = "User"
)

// ContentMutation represents an operation that mutates the Content nodes in the graph.
type ContentMutation struct {
	config
	op              Op
	typ             string
	id              *uuid.UUID
	root            *bool
	data            **schema.ContentEncoder
	created_at      *time.Time
	updated_at      *time.Time
	clearedFields   map[string]struct{}
	user            *uuid.UUID
	cleareduser     bool
	tags            map[uuid.UUID]struct{}
	removedtags     map[uuid.UUID]struct{}
	clearedtags     bool
	children        map[uuid.UUID]struct{}
	removedchildren map[uuid.UUID]struct{}
	clearedchildren bool
	parents         map[uuid.UUID]struct{}
	removedparents  map[uuid.UUID]struct{}
	clearedparents  bool
	groups          map[uuid.UUID]struct{}
	removedgroups   map[uuid.UUID]struct{}
	clearedgroups   bool
	done            bool
	oldValue        func(context.Context) (*Content, error)
	predicates      []predicate.Content
}

var _ ent.Mutation = (*ContentMutation)(nil)

// contentOption allows management of the mutation configuration using functional options.
type contentOption func(*ContentMutation)

// newContentMutation creates new mutation for the Content entity.
func newContentMutation(c config, op Op, opts ...contentOption) *ContentMutation {
	m := &ContentMutation{
		config:        c,
		op:            op,
		typ:           TypeContent,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withContentID sets the ID field of the mutation.
func withContentID(id uuid.UUID) contentOption {
	return func(m *ContentMutation) {
		var (
			err   error
			once  sync.Once
			value *Content
		)
		m.oldValue = func(ctx context.Context) (*Content, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Content.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withContent sets the old Content of the mutation.
func withContent(node *Content) contentOption {
	return func(m *ContentMutation) {
		m.oldValue = func(context.Context) (*Content, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m ContentMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m ContentMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Content entities.
func (m *ContentMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *ContentMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *ContentMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Content.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetRoot sets the "root" field.
func (m *ContentMutation) SetRoot(b bool) {
	m.root = &b
}

// Root returns the value of the "root" field in the mutation.
func (m *ContentMutation) Root() (r bool, exists bool) {
	v := m.root
	if v == nil {
		return
	}
	return *v, true
}

// OldRoot returns the old "root" field's value of the Content entity.
// If the Content object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ContentMutation) OldRoot(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRoot is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRoot requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRoot: %w", err)
	}
	return oldValue.Root, nil
}

// ResetRoot resets all changes to the "root" field.
func (m *ContentMutation) ResetRoot() {
	m.root = nil
}

// SetData sets the "data" field.
func (m *ContentMutation) SetData(se *schema.ContentEncoder) {
	m.data = &se
}

// Data returns the value of the "data" field in the mutation.
func (m *ContentMutation) Data() (r *schema.ContentEncoder, exists bool) {
	v := m.data
	if v == nil {
		return
	}
	return *v, true
}

// OldData returns the old "data" field's value of the Content entity.
// If the Content object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ContentMutation) OldData(ctx context.Context) (v *schema.ContentEncoder, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldData is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldData requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldData: %w", err)
	}
	return oldValue.Data, nil
}

// ResetData resets all changes to the "data" field.
func (m *ContentMutation) ResetData() {
	m.data = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *ContentMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *ContentMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Content entity.
// If the Content object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ContentMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *ContentMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *ContentMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *ContentMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the Content entity.
// If the Content object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ContentMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ClearUpdatedAt clears the value of the "updated_at" field.
func (m *ContentMutation) ClearUpdatedAt() {
	m.updated_at = nil
	m.clearedFields[content.FieldUpdatedAt] = struct{}{}
}

// UpdatedAtCleared returns if the "updated_at" field was cleared in this mutation.
func (m *ContentMutation) UpdatedAtCleared() bool {
	_, ok := m.clearedFields[content.FieldUpdatedAt]
	return ok
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *ContentMutation) ResetUpdatedAt() {
	m.updated_at = nil
	delete(m.clearedFields, content.FieldUpdatedAt)
}

// SetUserID sets the "user" edge to the User entity by id.
func (m *ContentMutation) SetUserID(id uuid.UUID) {
	m.user = &id
}

// ClearUser clears the "user" edge to the User entity.
func (m *ContentMutation) ClearUser() {
	m.cleareduser = true
}

// UserCleared reports if the "user" edge to the User entity was cleared.
func (m *ContentMutation) UserCleared() bool {
	return m.cleareduser
}

// UserID returns the "user" edge ID in the mutation.
func (m *ContentMutation) UserID() (id uuid.UUID, exists bool) {
	if m.user != nil {
		return *m.user, true
	}
	return
}

// UserIDs returns the "user" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserID instead. It exists only for internal usage by the builders.
func (m *ContentMutation) UserIDs() (ids []uuid.UUID) {
	if id := m.user; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUser resets all changes to the "user" edge.
func (m *ContentMutation) ResetUser() {
	m.user = nil
	m.cleareduser = false
}

// AddTagIDs adds the "tags" edge to the Tag entity by ids.
func (m *ContentMutation) AddTagIDs(ids ...uuid.UUID) {
	if m.tags == nil {
		m.tags = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.tags[ids[i]] = struct{}{}
	}
}

// ClearTags clears the "tags" edge to the Tag entity.
func (m *ContentMutation) ClearTags() {
	m.clearedtags = true
}

// TagsCleared reports if the "tags" edge to the Tag entity was cleared.
func (m *ContentMutation) TagsCleared() bool {
	return m.clearedtags
}

// RemoveTagIDs removes the "tags" edge to the Tag entity by IDs.
func (m *ContentMutation) RemoveTagIDs(ids ...uuid.UUID) {
	if m.removedtags == nil {
		m.removedtags = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.tags, ids[i])
		m.removedtags[ids[i]] = struct{}{}
	}
}

// RemovedTags returns the removed IDs of the "tags" edge to the Tag entity.
func (m *ContentMutation) RemovedTagsIDs() (ids []uuid.UUID) {
	for id := range m.removedtags {
		ids = append(ids, id)
	}
	return
}

// TagsIDs returns the "tags" edge IDs in the mutation.
func (m *ContentMutation) TagsIDs() (ids []uuid.UUID) {
	for id := range m.tags {
		ids = append(ids, id)
	}
	return
}

// ResetTags resets all changes to the "tags" edge.
func (m *ContentMutation) ResetTags() {
	m.tags = nil
	m.clearedtags = false
	m.removedtags = nil
}

// AddChildIDs adds the "children" edge to the Content entity by ids.
func (m *ContentMutation) AddChildIDs(ids ...uuid.UUID) {
	if m.children == nil {
		m.children = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.children[ids[i]] = struct{}{}
	}
}

// ClearChildren clears the "children" edge to the Content entity.
func (m *ContentMutation) ClearChildren() {
	m.clearedchildren = true
}

// ChildrenCleared reports if the "children" edge to the Content entity was cleared.
func (m *ContentMutation) ChildrenCleared() bool {
	return m.clearedchildren
}

// RemoveChildIDs removes the "children" edge to the Content entity by IDs.
func (m *ContentMutation) RemoveChildIDs(ids ...uuid.UUID) {
	if m.removedchildren == nil {
		m.removedchildren = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.children, ids[i])
		m.removedchildren[ids[i]] = struct{}{}
	}
}

// RemovedChildren returns the removed IDs of the "children" edge to the Content entity.
func (m *ContentMutation) RemovedChildrenIDs() (ids []uuid.UUID) {
	for id := range m.removedchildren {
		ids = append(ids, id)
	}
	return
}

// ChildrenIDs returns the "children" edge IDs in the mutation.
func (m *ContentMutation) ChildrenIDs() (ids []uuid.UUID) {
	for id := range m.children {
		ids = append(ids, id)
	}
	return
}

// ResetChildren resets all changes to the "children" edge.
func (m *ContentMutation) ResetChildren() {
	m.children = nil
	m.clearedchildren = false
	m.removedchildren = nil
}

// AddParentIDs adds the "parents" edge to the Content entity by ids.
func (m *ContentMutation) AddParentIDs(ids ...uuid.UUID) {
	if m.parents == nil {
		m.parents = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.parents[ids[i]] = struct{}{}
	}
}

// ClearParents clears the "parents" edge to the Content entity.
func (m *ContentMutation) ClearParents() {
	m.clearedparents = true
}

// ParentsCleared reports if the "parents" edge to the Content entity was cleared.
func (m *ContentMutation) ParentsCleared() bool {
	return m.clearedparents
}

// RemoveParentIDs removes the "parents" edge to the Content entity by IDs.
func (m *ContentMutation) RemoveParentIDs(ids ...uuid.UUID) {
	if m.removedparents == nil {
		m.removedparents = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.parents, ids[i])
		m.removedparents[ids[i]] = struct{}{}
	}
}

// RemovedParents returns the removed IDs of the "parents" edge to the Content entity.
func (m *ContentMutation) RemovedParentsIDs() (ids []uuid.UUID) {
	for id := range m.removedparents {
		ids = append(ids, id)
	}
	return
}

// ParentsIDs returns the "parents" edge IDs in the mutation.
func (m *ContentMutation) ParentsIDs() (ids []uuid.UUID) {
	for id := range m.parents {
		ids = append(ids, id)
	}
	return
}

// ResetParents resets all changes to the "parents" edge.
func (m *ContentMutation) ResetParents() {
	m.parents = nil
	m.clearedparents = false
	m.removedparents = nil
}

// AddGroupIDs adds the "groups" edge to the Group entity by ids.
func (m *ContentMutation) AddGroupIDs(ids ...uuid.UUID) {
	if m.groups == nil {
		m.groups = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.groups[ids[i]] = struct{}{}
	}
}

// ClearGroups clears the "groups" edge to the Group entity.
func (m *ContentMutation) ClearGroups() {
	m.clearedgroups = true
}

// GroupsCleared reports if the "groups" edge to the Group entity was cleared.
func (m *ContentMutation) GroupsCleared() bool {
	return m.clearedgroups
}

// RemoveGroupIDs removes the "groups" edge to the Group entity by IDs.
func (m *ContentMutation) RemoveGroupIDs(ids ...uuid.UUID) {
	if m.removedgroups == nil {
		m.removedgroups = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.groups, ids[i])
		m.removedgroups[ids[i]] = struct{}{}
	}
}

// RemovedGroups returns the removed IDs of the "groups" edge to the Group entity.
func (m *ContentMutation) RemovedGroupsIDs() (ids []uuid.UUID) {
	for id := range m.removedgroups {
		ids = append(ids, id)
	}
	return
}

// GroupsIDs returns the "groups" edge IDs in the mutation.
func (m *ContentMutation) GroupsIDs() (ids []uuid.UUID) {
	for id := range m.groups {
		ids = append(ids, id)
	}
	return
}

// ResetGroups resets all changes to the "groups" edge.
func (m *ContentMutation) ResetGroups() {
	m.groups = nil
	m.clearedgroups = false
	m.removedgroups = nil
}

// Where appends a list predicates to the ContentMutation builder.
func (m *ContentMutation) Where(ps ...predicate.Content) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the ContentMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *ContentMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Content, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *ContentMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *ContentMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Content).
func (m *ContentMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *ContentMutation) Fields() []string {
	fields := make([]string, 0, 4)
	if m.root != nil {
		fields = append(fields, content.FieldRoot)
	}
	if m.data != nil {
		fields = append(fields, content.FieldData)
	}
	if m.created_at != nil {
		fields = append(fields, content.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, content.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *ContentMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case content.FieldRoot:
		return m.Root()
	case content.FieldData:
		return m.Data()
	case content.FieldCreatedAt:
		return m.CreatedAt()
	case content.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *ContentMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case content.FieldRoot:
		return m.OldRoot(ctx)
	case content.FieldData:
		return m.OldData(ctx)
	case content.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case content.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown Content field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ContentMutation) SetField(name string, value ent.Value) error {
	switch name {
	case content.FieldRoot:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRoot(v)
		return nil
	case content.FieldData:
		v, ok := value.(*schema.ContentEncoder)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetData(v)
		return nil
	case content.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case content.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown Content field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *ContentMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *ContentMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ContentMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Content numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *ContentMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(content.FieldUpdatedAt) {
		fields = append(fields, content.FieldUpdatedAt)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *ContentMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *ContentMutation) ClearField(name string) error {
	switch name {
	case content.FieldUpdatedAt:
		m.ClearUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown Content nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *ContentMutation) ResetField(name string) error {
	switch name {
	case content.FieldRoot:
		m.ResetRoot()
		return nil
	case content.FieldData:
		m.ResetData()
		return nil
	case content.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case content.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown Content field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *ContentMutation) AddedEdges() []string {
	edges := make([]string, 0, 5)
	if m.user != nil {
		edges = append(edges, content.EdgeUser)
	}
	if m.tags != nil {
		edges = append(edges, content.EdgeTags)
	}
	if m.children != nil {
		edges = append(edges, content.EdgeChildren)
	}
	if m.parents != nil {
		edges = append(edges, content.EdgeParents)
	}
	if m.groups != nil {
		edges = append(edges, content.EdgeGroups)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *ContentMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case content.EdgeUser:
		if id := m.user; id != nil {
			return []ent.Value{*id}
		}
	case content.EdgeTags:
		ids := make([]ent.Value, 0, len(m.tags))
		for id := range m.tags {
			ids = append(ids, id)
		}
		return ids
	case content.EdgeChildren:
		ids := make([]ent.Value, 0, len(m.children))
		for id := range m.children {
			ids = append(ids, id)
		}
		return ids
	case content.EdgeParents:
		ids := make([]ent.Value, 0, len(m.parents))
		for id := range m.parents {
			ids = append(ids, id)
		}
		return ids
	case content.EdgeGroups:
		ids := make([]ent.Value, 0, len(m.groups))
		for id := range m.groups {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *ContentMutation) RemovedEdges() []string {
	edges := make([]string, 0, 5)
	if m.removedtags != nil {
		edges = append(edges, content.EdgeTags)
	}
	if m.removedchildren != nil {
		edges = append(edges, content.EdgeChildren)
	}
	if m.removedparents != nil {
		edges = append(edges, content.EdgeParents)
	}
	if m.removedgroups != nil {
		edges = append(edges, content.EdgeGroups)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *ContentMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case content.EdgeTags:
		ids := make([]ent.Value, 0, len(m.removedtags))
		for id := range m.removedtags {
			ids = append(ids, id)
		}
		return ids
	case content.EdgeChildren:
		ids := make([]ent.Value, 0, len(m.removedchildren))
		for id := range m.removedchildren {
			ids = append(ids, id)
		}
		return ids
	case content.EdgeParents:
		ids := make([]ent.Value, 0, len(m.removedparents))
		for id := range m.removedparents {
			ids = append(ids, id)
		}
		return ids
	case content.EdgeGroups:
		ids := make([]ent.Value, 0, len(m.removedgroups))
		for id := range m.removedgroups {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *ContentMutation) ClearedEdges() []string {
	edges := make([]string, 0, 5)
	if m.cleareduser {
		edges = append(edges, content.EdgeUser)
	}
	if m.clearedtags {
		edges = append(edges, content.EdgeTags)
	}
	if m.clearedchildren {
		edges = append(edges, content.EdgeChildren)
	}
	if m.clearedparents {
		edges = append(edges, content.EdgeParents)
	}
	if m.clearedgroups {
		edges = append(edges, content.EdgeGroups)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *ContentMutation) EdgeCleared(name string) bool {
	switch name {
	case content.EdgeUser:
		return m.cleareduser
	case content.EdgeTags:
		return m.clearedtags
	case content.EdgeChildren:
		return m.clearedchildren
	case content.EdgeParents:
		return m.clearedparents
	case content.EdgeGroups:
		return m.clearedgroups
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *ContentMutation) ClearEdge(name string) error {
	switch name {
	case content.EdgeUser:
		m.ClearUser()
		return nil
	}
	return fmt.Errorf("unknown Content unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *ContentMutation) ResetEdge(name string) error {
	switch name {
	case content.EdgeUser:
		m.ResetUser()
		return nil
	case content.EdgeTags:
		m.ResetTags()
		return nil
	case content.EdgeChildren:
		m.ResetChildren()
		return nil
	case content.EdgeParents:
		m.ResetParents()
		return nil
	case content.EdgeGroups:
		m.ResetGroups()
		return nil
	}
	return fmt.Errorf("unknown Content edge %s", name)
}

// EventMutation represents an operation that mutates the Event nodes in the graph.
type EventMutation struct {
	config
	op            Op
	typ           string
	id            *uuid.UUID
	data          **event.Metric
	created_at    *time.Time
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*Event, error)
	predicates    []predicate.Event
}

var _ ent.Mutation = (*EventMutation)(nil)

// eventOption allows management of the mutation configuration using functional options.
type eventOption func(*EventMutation)

// newEventMutation creates new mutation for the Event entity.
func newEventMutation(c config, op Op, opts ...eventOption) *EventMutation {
	m := &EventMutation{
		config:        c,
		op:            op,
		typ:           TypeEvent,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withEventID sets the ID field of the mutation.
func withEventID(id uuid.UUID) eventOption {
	return func(m *EventMutation) {
		var (
			err   error
			once  sync.Once
			value *Event
		)
		m.oldValue = func(ctx context.Context) (*Event, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Event.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withEvent sets the old Event of the mutation.
func withEvent(node *Event) eventOption {
	return func(m *EventMutation) {
		m.oldValue = func(context.Context) (*Event, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m EventMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m EventMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Event entities.
func (m *EventMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *EventMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *EventMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Event.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetData sets the "data" field.
func (m *EventMutation) SetData(e *event.Metric) {
	m.data = &e
}

// Data returns the value of the "data" field in the mutation.
func (m *EventMutation) Data() (r *event.Metric, exists bool) {
	v := m.data
	if v == nil {
		return
	}
	return *v, true
}

// OldData returns the old "data" field's value of the Event entity.
// If the Event object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *EventMutation) OldData(ctx context.Context) (v *event.Metric, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldData is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldData requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldData: %w", err)
	}
	return oldValue.Data, nil
}

// ResetData resets all changes to the "data" field.
func (m *EventMutation) ResetData() {
	m.data = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *EventMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *EventMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Event entity.
// If the Event object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *EventMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *EventMutation) ResetCreatedAt() {
	m.created_at = nil
}

// Where appends a list predicates to the EventMutation builder.
func (m *EventMutation) Where(ps ...predicate.Event) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the EventMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *EventMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Event, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *EventMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *EventMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Event).
func (m *EventMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *EventMutation) Fields() []string {
	fields := make([]string, 0, 2)
	if m.data != nil {
		fields = append(fields, entevent.FieldData)
	}
	if m.created_at != nil {
		fields = append(fields, entevent.FieldCreatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *EventMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case entevent.FieldData:
		return m.Data()
	case entevent.FieldCreatedAt:
		return m.CreatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *EventMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case entevent.FieldData:
		return m.OldData(ctx)
	case entevent.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown Event field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *EventMutation) SetField(name string, value ent.Value) error {
	switch name {
	case entevent.FieldData:
		v, ok := value.(*event.Metric)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetData(v)
		return nil
	case entevent.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown Event field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *EventMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *EventMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *EventMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Event numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *EventMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *EventMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *EventMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Event nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *EventMutation) ResetField(name string) error {
	switch name {
	case entevent.FieldData:
		m.ResetData()
		return nil
	case entevent.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	}
	return fmt.Errorf("unknown Event field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *EventMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *EventMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *EventMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *EventMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *EventMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *EventMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *EventMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Event unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *EventMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Event edge %s", name)
}

// GroupMutation represents an operation that mutates the Group nodes in the graph.
type GroupMutation struct {
	config
	op                 Op
	typ                string
	id                 *uuid.UUID
	data               **user.Group
	clearedFields      map[string]struct{}
	group_users        map[uuid.UUID]struct{}
	removedgroup_users map[uuid.UUID]struct{}
	clearedgroup_users bool
	invites            map[int]struct{}
	removedinvites     map[int]struct{}
	clearedinvites     bool
	content            map[uuid.UUID]struct{}
	removedcontent     map[uuid.UUID]struct{}
	clearedcontent     bool
	tags               map[uuid.UUID]struct{}
	removedtags        map[uuid.UUID]struct{}
	clearedtags        bool
	done               bool
	oldValue           func(context.Context) (*Group, error)
	predicates         []predicate.Group
}

var _ ent.Mutation = (*GroupMutation)(nil)

// groupOption allows management of the mutation configuration using functional options.
type groupOption func(*GroupMutation)

// newGroupMutation creates new mutation for the Group entity.
func newGroupMutation(c config, op Op, opts ...groupOption) *GroupMutation {
	m := &GroupMutation{
		config:        c,
		op:            op,
		typ:           TypeGroup,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withGroupID sets the ID field of the mutation.
func withGroupID(id uuid.UUID) groupOption {
	return func(m *GroupMutation) {
		var (
			err   error
			once  sync.Once
			value *Group
		)
		m.oldValue = func(ctx context.Context) (*Group, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Group.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withGroup sets the old Group of the mutation.
func withGroup(node *Group) groupOption {
	return func(m *GroupMutation) {
		m.oldValue = func(context.Context) (*Group, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m GroupMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m GroupMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Group entities.
func (m *GroupMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *GroupMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *GroupMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Group.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetData sets the "data" field.
func (m *GroupMutation) SetData(u *user.Group) {
	m.data = &u
}

// Data returns the value of the "data" field in the mutation.
func (m *GroupMutation) Data() (r *user.Group, exists bool) {
	v := m.data
	if v == nil {
		return
	}
	return *v, true
}

// OldData returns the old "data" field's value of the Group entity.
// If the Group object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *GroupMutation) OldData(ctx context.Context) (v *user.Group, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldData is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldData requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldData: %w", err)
	}
	return oldValue.Data, nil
}

// ResetData resets all changes to the "data" field.
func (m *GroupMutation) ResetData() {
	m.data = nil
}

// AddGroupUserIDs adds the "group_users" edge to the GroupUser entity by ids.
func (m *GroupMutation) AddGroupUserIDs(ids ...uuid.UUID) {
	if m.group_users == nil {
		m.group_users = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.group_users[ids[i]] = struct{}{}
	}
}

// ClearGroupUsers clears the "group_users" edge to the GroupUser entity.
func (m *GroupMutation) ClearGroupUsers() {
	m.clearedgroup_users = true
}

// GroupUsersCleared reports if the "group_users" edge to the GroupUser entity was cleared.
func (m *GroupMutation) GroupUsersCleared() bool {
	return m.clearedgroup_users
}

// RemoveGroupUserIDs removes the "group_users" edge to the GroupUser entity by IDs.
func (m *GroupMutation) RemoveGroupUserIDs(ids ...uuid.UUID) {
	if m.removedgroup_users == nil {
		m.removedgroup_users = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.group_users, ids[i])
		m.removedgroup_users[ids[i]] = struct{}{}
	}
}

// RemovedGroupUsers returns the removed IDs of the "group_users" edge to the GroupUser entity.
func (m *GroupMutation) RemovedGroupUsersIDs() (ids []uuid.UUID) {
	for id := range m.removedgroup_users {
		ids = append(ids, id)
	}
	return
}

// GroupUsersIDs returns the "group_users" edge IDs in the mutation.
func (m *GroupMutation) GroupUsersIDs() (ids []uuid.UUID) {
	for id := range m.group_users {
		ids = append(ids, id)
	}
	return
}

// ResetGroupUsers resets all changes to the "group_users" edge.
func (m *GroupMutation) ResetGroupUsers() {
	m.group_users = nil
	m.clearedgroup_users = false
	m.removedgroup_users = nil
}

// AddInviteIDs adds the "invites" edge to the GroupInvite entity by ids.
func (m *GroupMutation) AddInviteIDs(ids ...int) {
	if m.invites == nil {
		m.invites = make(map[int]struct{})
	}
	for i := range ids {
		m.invites[ids[i]] = struct{}{}
	}
}

// ClearInvites clears the "invites" edge to the GroupInvite entity.
func (m *GroupMutation) ClearInvites() {
	m.clearedinvites = true
}

// InvitesCleared reports if the "invites" edge to the GroupInvite entity was cleared.
func (m *GroupMutation) InvitesCleared() bool {
	return m.clearedinvites
}

// RemoveInviteIDs removes the "invites" edge to the GroupInvite entity by IDs.
func (m *GroupMutation) RemoveInviteIDs(ids ...int) {
	if m.removedinvites == nil {
		m.removedinvites = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.invites, ids[i])
		m.removedinvites[ids[i]] = struct{}{}
	}
}

// RemovedInvites returns the removed IDs of the "invites" edge to the GroupInvite entity.
func (m *GroupMutation) RemovedInvitesIDs() (ids []int) {
	for id := range m.removedinvites {
		ids = append(ids, id)
	}
	return
}

// InvitesIDs returns the "invites" edge IDs in the mutation.
func (m *GroupMutation) InvitesIDs() (ids []int) {
	for id := range m.invites {
		ids = append(ids, id)
	}
	return
}

// ResetInvites resets all changes to the "invites" edge.
func (m *GroupMutation) ResetInvites() {
	m.invites = nil
	m.clearedinvites = false
	m.removedinvites = nil
}

// AddContentIDs adds the "content" edge to the Content entity by ids.
func (m *GroupMutation) AddContentIDs(ids ...uuid.UUID) {
	if m.content == nil {
		m.content = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.content[ids[i]] = struct{}{}
	}
}

// ClearContent clears the "content" edge to the Content entity.
func (m *GroupMutation) ClearContent() {
	m.clearedcontent = true
}

// ContentCleared reports if the "content" edge to the Content entity was cleared.
func (m *GroupMutation) ContentCleared() bool {
	return m.clearedcontent
}

// RemoveContentIDs removes the "content" edge to the Content entity by IDs.
func (m *GroupMutation) RemoveContentIDs(ids ...uuid.UUID) {
	if m.removedcontent == nil {
		m.removedcontent = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.content, ids[i])
		m.removedcontent[ids[i]] = struct{}{}
	}
}

// RemovedContent returns the removed IDs of the "content" edge to the Content entity.
func (m *GroupMutation) RemovedContentIDs() (ids []uuid.UUID) {
	for id := range m.removedcontent {
		ids = append(ids, id)
	}
	return
}

// ContentIDs returns the "content" edge IDs in the mutation.
func (m *GroupMutation) ContentIDs() (ids []uuid.UUID) {
	for id := range m.content {
		ids = append(ids, id)
	}
	return
}

// ResetContent resets all changes to the "content" edge.
func (m *GroupMutation) ResetContent() {
	m.content = nil
	m.clearedcontent = false
	m.removedcontent = nil
}

// AddTagIDs adds the "tags" edge to the Tag entity by ids.
func (m *GroupMutation) AddTagIDs(ids ...uuid.UUID) {
	if m.tags == nil {
		m.tags = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.tags[ids[i]] = struct{}{}
	}
}

// ClearTags clears the "tags" edge to the Tag entity.
func (m *GroupMutation) ClearTags() {
	m.clearedtags = true
}

// TagsCleared reports if the "tags" edge to the Tag entity was cleared.
func (m *GroupMutation) TagsCleared() bool {
	return m.clearedtags
}

// RemoveTagIDs removes the "tags" edge to the Tag entity by IDs.
func (m *GroupMutation) RemoveTagIDs(ids ...uuid.UUID) {
	if m.removedtags == nil {
		m.removedtags = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.tags, ids[i])
		m.removedtags[ids[i]] = struct{}{}
	}
}

// RemovedTags returns the removed IDs of the "tags" edge to the Tag entity.
func (m *GroupMutation) RemovedTagsIDs() (ids []uuid.UUID) {
	for id := range m.removedtags {
		ids = append(ids, id)
	}
	return
}

// TagsIDs returns the "tags" edge IDs in the mutation.
func (m *GroupMutation) TagsIDs() (ids []uuid.UUID) {
	for id := range m.tags {
		ids = append(ids, id)
	}
	return
}

// ResetTags resets all changes to the "tags" edge.
func (m *GroupMutation) ResetTags() {
	m.tags = nil
	m.clearedtags = false
	m.removedtags = nil
}

// Where appends a list predicates to the GroupMutation builder.
func (m *GroupMutation) Where(ps ...predicate.Group) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the GroupMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *GroupMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Group, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *GroupMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *GroupMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Group).
func (m *GroupMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *GroupMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m.data != nil {
		fields = append(fields, group.FieldData)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *GroupMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case group.FieldData:
		return m.Data()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *GroupMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case group.FieldData:
		return m.OldData(ctx)
	}
	return nil, fmt.Errorf("unknown Group field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GroupMutation) SetField(name string, value ent.Value) error {
	switch name {
	case group.FieldData:
		v, ok := value.(*user.Group)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetData(v)
		return nil
	}
	return fmt.Errorf("unknown Group field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *GroupMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *GroupMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GroupMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Group numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *GroupMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *GroupMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *GroupMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Group nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *GroupMutation) ResetField(name string) error {
	switch name {
	case group.FieldData:
		m.ResetData()
		return nil
	}
	return fmt.Errorf("unknown Group field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *GroupMutation) AddedEdges() []string {
	edges := make([]string, 0, 4)
	if m.group_users != nil {
		edges = append(edges, group.EdgeGroupUsers)
	}
	if m.invites != nil {
		edges = append(edges, group.EdgeInvites)
	}
	if m.content != nil {
		edges = append(edges, group.EdgeContent)
	}
	if m.tags != nil {
		edges = append(edges, group.EdgeTags)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *GroupMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case group.EdgeGroupUsers:
		ids := make([]ent.Value, 0, len(m.group_users))
		for id := range m.group_users {
			ids = append(ids, id)
		}
		return ids
	case group.EdgeInvites:
		ids := make([]ent.Value, 0, len(m.invites))
		for id := range m.invites {
			ids = append(ids, id)
		}
		return ids
	case group.EdgeContent:
		ids := make([]ent.Value, 0, len(m.content))
		for id := range m.content {
			ids = append(ids, id)
		}
		return ids
	case group.EdgeTags:
		ids := make([]ent.Value, 0, len(m.tags))
		for id := range m.tags {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *GroupMutation) RemovedEdges() []string {
	edges := make([]string, 0, 4)
	if m.removedgroup_users != nil {
		edges = append(edges, group.EdgeGroupUsers)
	}
	if m.removedinvites != nil {
		edges = append(edges, group.EdgeInvites)
	}
	if m.removedcontent != nil {
		edges = append(edges, group.EdgeContent)
	}
	if m.removedtags != nil {
		edges = append(edges, group.EdgeTags)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *GroupMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case group.EdgeGroupUsers:
		ids := make([]ent.Value, 0, len(m.removedgroup_users))
		for id := range m.removedgroup_users {
			ids = append(ids, id)
		}
		return ids
	case group.EdgeInvites:
		ids := make([]ent.Value, 0, len(m.removedinvites))
		for id := range m.removedinvites {
			ids = append(ids, id)
		}
		return ids
	case group.EdgeContent:
		ids := make([]ent.Value, 0, len(m.removedcontent))
		for id := range m.removedcontent {
			ids = append(ids, id)
		}
		return ids
	case group.EdgeTags:
		ids := make([]ent.Value, 0, len(m.removedtags))
		for id := range m.removedtags {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *GroupMutation) ClearedEdges() []string {
	edges := make([]string, 0, 4)
	if m.clearedgroup_users {
		edges = append(edges, group.EdgeGroupUsers)
	}
	if m.clearedinvites {
		edges = append(edges, group.EdgeInvites)
	}
	if m.clearedcontent {
		edges = append(edges, group.EdgeContent)
	}
	if m.clearedtags {
		edges = append(edges, group.EdgeTags)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *GroupMutation) EdgeCleared(name string) bool {
	switch name {
	case group.EdgeGroupUsers:
		return m.clearedgroup_users
	case group.EdgeInvites:
		return m.clearedinvites
	case group.EdgeContent:
		return m.clearedcontent
	case group.EdgeTags:
		return m.clearedtags
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *GroupMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown Group unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *GroupMutation) ResetEdge(name string) error {
	switch name {
	case group.EdgeGroupUsers:
		m.ResetGroupUsers()
		return nil
	case group.EdgeInvites:
		m.ResetInvites()
		return nil
	case group.EdgeContent:
		m.ResetContent()
		return nil
	case group.EdgeTags:
		m.ResetTags()
		return nil
	}
	return fmt.Errorf("unknown Group edge %s", name)
}

// GroupInviteMutation represents an operation that mutates the GroupInvite nodes in the graph.
type GroupInviteMutation struct {
	config
	op            Op
	typ           string
	id            *int
	secret        *string
	clearedFields map[string]struct{}
	group         *uuid.UUID
	clearedgroup  bool
	done          bool
	oldValue      func(context.Context) (*GroupInvite, error)
	predicates    []predicate.GroupInvite
}

var _ ent.Mutation = (*GroupInviteMutation)(nil)

// groupinviteOption allows management of the mutation configuration using functional options.
type groupinviteOption func(*GroupInviteMutation)

// newGroupInviteMutation creates new mutation for the GroupInvite entity.
func newGroupInviteMutation(c config, op Op, opts ...groupinviteOption) *GroupInviteMutation {
	m := &GroupInviteMutation{
		config:        c,
		op:            op,
		typ:           TypeGroupInvite,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withGroupInviteID sets the ID field of the mutation.
func withGroupInviteID(id int) groupinviteOption {
	return func(m *GroupInviteMutation) {
		var (
			err   error
			once  sync.Once
			value *GroupInvite
		)
		m.oldValue = func(ctx context.Context) (*GroupInvite, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().GroupInvite.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withGroupInvite sets the old GroupInvite of the mutation.
func withGroupInvite(node *GroupInvite) groupinviteOption {
	return func(m *GroupInviteMutation) {
		m.oldValue = func(context.Context) (*GroupInvite, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m GroupInviteMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m GroupInviteMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *GroupInviteMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *GroupInviteMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().GroupInvite.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetSecret sets the "secret" field.
func (m *GroupInviteMutation) SetSecret(s string) {
	m.secret = &s
}

// Secret returns the value of the "secret" field in the mutation.
func (m *GroupInviteMutation) Secret() (r string, exists bool) {
	v := m.secret
	if v == nil {
		return
	}
	return *v, true
}

// OldSecret returns the old "secret" field's value of the GroupInvite entity.
// If the GroupInvite object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *GroupInviteMutation) OldSecret(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldSecret is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldSecret requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSecret: %w", err)
	}
	return oldValue.Secret, nil
}

// ResetSecret resets all changes to the "secret" field.
func (m *GroupInviteMutation) ResetSecret() {
	m.secret = nil
}

// SetGroupID sets the "group" edge to the Group entity by id.
func (m *GroupInviteMutation) SetGroupID(id uuid.UUID) {
	m.group = &id
}

// ClearGroup clears the "group" edge to the Group entity.
func (m *GroupInviteMutation) ClearGroup() {
	m.clearedgroup = true
}

// GroupCleared reports if the "group" edge to the Group entity was cleared.
func (m *GroupInviteMutation) GroupCleared() bool {
	return m.clearedgroup
}

// GroupID returns the "group" edge ID in the mutation.
func (m *GroupInviteMutation) GroupID() (id uuid.UUID, exists bool) {
	if m.group != nil {
		return *m.group, true
	}
	return
}

// GroupIDs returns the "group" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// GroupID instead. It exists only for internal usage by the builders.
func (m *GroupInviteMutation) GroupIDs() (ids []uuid.UUID) {
	if id := m.group; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetGroup resets all changes to the "group" edge.
func (m *GroupInviteMutation) ResetGroup() {
	m.group = nil
	m.clearedgroup = false
}

// Where appends a list predicates to the GroupInviteMutation builder.
func (m *GroupInviteMutation) Where(ps ...predicate.GroupInvite) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the GroupInviteMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *GroupInviteMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.GroupInvite, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *GroupInviteMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *GroupInviteMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (GroupInvite).
func (m *GroupInviteMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *GroupInviteMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m.secret != nil {
		fields = append(fields, groupinvite.FieldSecret)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *GroupInviteMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case groupinvite.FieldSecret:
		return m.Secret()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *GroupInviteMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case groupinvite.FieldSecret:
		return m.OldSecret(ctx)
	}
	return nil, fmt.Errorf("unknown GroupInvite field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GroupInviteMutation) SetField(name string, value ent.Value) error {
	switch name {
	case groupinvite.FieldSecret:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSecret(v)
		return nil
	}
	return fmt.Errorf("unknown GroupInvite field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *GroupInviteMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *GroupInviteMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GroupInviteMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown GroupInvite numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *GroupInviteMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *GroupInviteMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *GroupInviteMutation) ClearField(name string) error {
	return fmt.Errorf("unknown GroupInvite nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *GroupInviteMutation) ResetField(name string) error {
	switch name {
	case groupinvite.FieldSecret:
		m.ResetSecret()
		return nil
	}
	return fmt.Errorf("unknown GroupInvite field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *GroupInviteMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.group != nil {
		edges = append(edges, groupinvite.EdgeGroup)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *GroupInviteMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case groupinvite.EdgeGroup:
		if id := m.group; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *GroupInviteMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *GroupInviteMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *GroupInviteMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedgroup {
		edges = append(edges, groupinvite.EdgeGroup)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *GroupInviteMutation) EdgeCleared(name string) bool {
	switch name {
	case groupinvite.EdgeGroup:
		return m.clearedgroup
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *GroupInviteMutation) ClearEdge(name string) error {
	switch name {
	case groupinvite.EdgeGroup:
		m.ClearGroup()
		return nil
	}
	return fmt.Errorf("unknown GroupInvite unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *GroupInviteMutation) ResetEdge(name string) error {
	switch name {
	case groupinvite.EdgeGroup:
		m.ResetGroup()
		return nil
	}
	return fmt.Errorf("unknown GroupInvite edge %s", name)
}

// GroupUserMutation represents an operation that mutates the GroupUser nodes in the graph.
type GroupUserMutation struct {
	config
	op            Op
	typ           string
	id            *uuid.UUID
	role          *string
	clearedFields map[string]struct{}
	user          *uuid.UUID
	cleareduser   bool
	group         *uuid.UUID
	clearedgroup  bool
	done          bool
	oldValue      func(context.Context) (*GroupUser, error)
	predicates    []predicate.GroupUser
}

var _ ent.Mutation = (*GroupUserMutation)(nil)

// groupuserOption allows management of the mutation configuration using functional options.
type groupuserOption func(*GroupUserMutation)

// newGroupUserMutation creates new mutation for the GroupUser entity.
func newGroupUserMutation(c config, op Op, opts ...groupuserOption) *GroupUserMutation {
	m := &GroupUserMutation{
		config:        c,
		op:            op,
		typ:           TypeGroupUser,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withGroupUserID sets the ID field of the mutation.
func withGroupUserID(id uuid.UUID) groupuserOption {
	return func(m *GroupUserMutation) {
		var (
			err   error
			once  sync.Once
			value *GroupUser
		)
		m.oldValue = func(ctx context.Context) (*GroupUser, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().GroupUser.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withGroupUser sets the old GroupUser of the mutation.
func withGroupUser(node *GroupUser) groupuserOption {
	return func(m *GroupUserMutation) {
		m.oldValue = func(context.Context) (*GroupUser, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m GroupUserMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m GroupUserMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of GroupUser entities.
func (m *GroupUserMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *GroupUserMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *GroupUserMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().GroupUser.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetRole sets the "role" field.
func (m *GroupUserMutation) SetRole(s string) {
	m.role = &s
}

// Role returns the value of the "role" field in the mutation.
func (m *GroupUserMutation) Role() (r string, exists bool) {
	v := m.role
	if v == nil {
		return
	}
	return *v, true
}

// OldRole returns the old "role" field's value of the GroupUser entity.
// If the GroupUser object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *GroupUserMutation) OldRole(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRole is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRole requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRole: %w", err)
	}
	return oldValue.Role, nil
}

// ResetRole resets all changes to the "role" field.
func (m *GroupUserMutation) ResetRole() {
	m.role = nil
}

// SetUserID sets the "user" edge to the User entity by id.
func (m *GroupUserMutation) SetUserID(id uuid.UUID) {
	m.user = &id
}

// ClearUser clears the "user" edge to the User entity.
func (m *GroupUserMutation) ClearUser() {
	m.cleareduser = true
}

// UserCleared reports if the "user" edge to the User entity was cleared.
func (m *GroupUserMutation) UserCleared() bool {
	return m.cleareduser
}

// UserID returns the "user" edge ID in the mutation.
func (m *GroupUserMutation) UserID() (id uuid.UUID, exists bool) {
	if m.user != nil {
		return *m.user, true
	}
	return
}

// UserIDs returns the "user" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserID instead. It exists only for internal usage by the builders.
func (m *GroupUserMutation) UserIDs() (ids []uuid.UUID) {
	if id := m.user; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUser resets all changes to the "user" edge.
func (m *GroupUserMutation) ResetUser() {
	m.user = nil
	m.cleareduser = false
}

// SetGroupID sets the "group" edge to the Group entity by id.
func (m *GroupUserMutation) SetGroupID(id uuid.UUID) {
	m.group = &id
}

// ClearGroup clears the "group" edge to the Group entity.
func (m *GroupUserMutation) ClearGroup() {
	m.clearedgroup = true
}

// GroupCleared reports if the "group" edge to the Group entity was cleared.
func (m *GroupUserMutation) GroupCleared() bool {
	return m.clearedgroup
}

// GroupID returns the "group" edge ID in the mutation.
func (m *GroupUserMutation) GroupID() (id uuid.UUID, exists bool) {
	if m.group != nil {
		return *m.group, true
	}
	return
}

// GroupIDs returns the "group" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// GroupID instead. It exists only for internal usage by the builders.
func (m *GroupUserMutation) GroupIDs() (ids []uuid.UUID) {
	if id := m.group; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetGroup resets all changes to the "group" edge.
func (m *GroupUserMutation) ResetGroup() {
	m.group = nil
	m.clearedgroup = false
}

// Where appends a list predicates to the GroupUserMutation builder.
func (m *GroupUserMutation) Where(ps ...predicate.GroupUser) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the GroupUserMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *GroupUserMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.GroupUser, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *GroupUserMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *GroupUserMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (GroupUser).
func (m *GroupUserMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *GroupUserMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m.role != nil {
		fields = append(fields, groupuser.FieldRole)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *GroupUserMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case groupuser.FieldRole:
		return m.Role()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *GroupUserMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case groupuser.FieldRole:
		return m.OldRole(ctx)
	}
	return nil, fmt.Errorf("unknown GroupUser field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GroupUserMutation) SetField(name string, value ent.Value) error {
	switch name {
	case groupuser.FieldRole:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRole(v)
		return nil
	}
	return fmt.Errorf("unknown GroupUser field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *GroupUserMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *GroupUserMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GroupUserMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown GroupUser numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *GroupUserMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *GroupUserMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *GroupUserMutation) ClearField(name string) error {
	return fmt.Errorf("unknown GroupUser nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *GroupUserMutation) ResetField(name string) error {
	switch name {
	case groupuser.FieldRole:
		m.ResetRole()
		return nil
	}
	return fmt.Errorf("unknown GroupUser field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *GroupUserMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.user != nil {
		edges = append(edges, groupuser.EdgeUser)
	}
	if m.group != nil {
		edges = append(edges, groupuser.EdgeGroup)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *GroupUserMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case groupuser.EdgeUser:
		if id := m.user; id != nil {
			return []ent.Value{*id}
		}
	case groupuser.EdgeGroup:
		if id := m.group; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *GroupUserMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *GroupUserMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *GroupUserMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.cleareduser {
		edges = append(edges, groupuser.EdgeUser)
	}
	if m.clearedgroup {
		edges = append(edges, groupuser.EdgeGroup)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *GroupUserMutation) EdgeCleared(name string) bool {
	switch name {
	case groupuser.EdgeUser:
		return m.cleareduser
	case groupuser.EdgeGroup:
		return m.clearedgroup
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *GroupUserMutation) ClearEdge(name string) error {
	switch name {
	case groupuser.EdgeUser:
		m.ClearUser()
		return nil
	case groupuser.EdgeGroup:
		m.ClearGroup()
		return nil
	}
	return fmt.Errorf("unknown GroupUser unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *GroupUserMutation) ResetEdge(name string) error {
	switch name {
	case groupuser.EdgeUser:
		m.ResetUser()
		return nil
	case groupuser.EdgeGroup:
		m.ResetGroup()
		return nil
	}
	return fmt.Errorf("unknown GroupUser edge %s", name)
}

// SessionMutation represents an operation that mutates the Session nodes in the graph.
type SessionMutation struct {
	config
	op            Op
	typ           string
	id            *int
	token         *string
	data          *[]byte
	expiry        *time.Time
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*Session, error)
	predicates    []predicate.Session
}

var _ ent.Mutation = (*SessionMutation)(nil)

// sessionOption allows management of the mutation configuration using functional options.
type sessionOption func(*SessionMutation)

// newSessionMutation creates new mutation for the Session entity.
func newSessionMutation(c config, op Op, opts ...sessionOption) *SessionMutation {
	m := &SessionMutation{
		config:        c,
		op:            op,
		typ:           TypeSession,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withSessionID sets the ID field of the mutation.
func withSessionID(id int) sessionOption {
	return func(m *SessionMutation) {
		var (
			err   error
			once  sync.Once
			value *Session
		)
		m.oldValue = func(ctx context.Context) (*Session, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Session.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withSession sets the old Session of the mutation.
func withSession(node *Session) sessionOption {
	return func(m *SessionMutation) {
		m.oldValue = func(context.Context) (*Session, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m SessionMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m SessionMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *SessionMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *SessionMutation) IDs(ctx context.Context) ([]int, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []int{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Session.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetToken sets the "token" field.
func (m *SessionMutation) SetToken(s string) {
	m.token = &s
}

// Token returns the value of the "token" field in the mutation.
func (m *SessionMutation) Token() (r string, exists bool) {
	v := m.token
	if v == nil {
		return
	}
	return *v, true
}

// OldToken returns the old "token" field's value of the Session entity.
// If the Session object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SessionMutation) OldToken(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldToken is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldToken requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldToken: %w", err)
	}
	return oldValue.Token, nil
}

// ResetToken resets all changes to the "token" field.
func (m *SessionMutation) ResetToken() {
	m.token = nil
}

// SetData sets the "data" field.
func (m *SessionMutation) SetData(b []byte) {
	m.data = &b
}

// Data returns the value of the "data" field in the mutation.
func (m *SessionMutation) Data() (r []byte, exists bool) {
	v := m.data
	if v == nil {
		return
	}
	return *v, true
}

// OldData returns the old "data" field's value of the Session entity.
// If the Session object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SessionMutation) OldData(ctx context.Context) (v []byte, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldData is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldData requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldData: %w", err)
	}
	return oldValue.Data, nil
}

// ResetData resets all changes to the "data" field.
func (m *SessionMutation) ResetData() {
	m.data = nil
}

// SetExpiry sets the "expiry" field.
func (m *SessionMutation) SetExpiry(t time.Time) {
	m.expiry = &t
}

// Expiry returns the value of the "expiry" field in the mutation.
func (m *SessionMutation) Expiry() (r time.Time, exists bool) {
	v := m.expiry
	if v == nil {
		return
	}
	return *v, true
}

// OldExpiry returns the old "expiry" field's value of the Session entity.
// If the Session object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SessionMutation) OldExpiry(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldExpiry is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldExpiry requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldExpiry: %w", err)
	}
	return oldValue.Expiry, nil
}

// ResetExpiry resets all changes to the "expiry" field.
func (m *SessionMutation) ResetExpiry() {
	m.expiry = nil
}

// Where appends a list predicates to the SessionMutation builder.
func (m *SessionMutation) Where(ps ...predicate.Session) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the SessionMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *SessionMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Session, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *SessionMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *SessionMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Session).
func (m *SessionMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *SessionMutation) Fields() []string {
	fields := make([]string, 0, 3)
	if m.token != nil {
		fields = append(fields, session.FieldToken)
	}
	if m.data != nil {
		fields = append(fields, session.FieldData)
	}
	if m.expiry != nil {
		fields = append(fields, session.FieldExpiry)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *SessionMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case session.FieldToken:
		return m.Token()
	case session.FieldData:
		return m.Data()
	case session.FieldExpiry:
		return m.Expiry()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *SessionMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case session.FieldToken:
		return m.OldToken(ctx)
	case session.FieldData:
		return m.OldData(ctx)
	case session.FieldExpiry:
		return m.OldExpiry(ctx)
	}
	return nil, fmt.Errorf("unknown Session field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *SessionMutation) SetField(name string, value ent.Value) error {
	switch name {
	case session.FieldToken:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetToken(v)
		return nil
	case session.FieldData:
		v, ok := value.([]byte)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetData(v)
		return nil
	case session.FieldExpiry:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetExpiry(v)
		return nil
	}
	return fmt.Errorf("unknown Session field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *SessionMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *SessionMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *SessionMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Session numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *SessionMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *SessionMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *SessionMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Session nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *SessionMutation) ResetField(name string) error {
	switch name {
	case session.FieldToken:
		m.ResetToken()
		return nil
	case session.FieldData:
		m.ResetData()
		return nil
	case session.FieldExpiry:
		m.ResetExpiry()
		return nil
	}
	return fmt.Errorf("unknown Session field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *SessionMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *SessionMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *SessionMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *SessionMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *SessionMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *SessionMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *SessionMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Session unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *SessionMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Session edge %s", name)
}

// TagMutation represents an operation that mutates the Tag nodes in the graph.
type TagMutation struct {
	config
	op              Op
	typ             string
	id              *uuid.UUID
	name            *string
	clearedFields   map[string]struct{}
	group           *uuid.UUID
	clearedgroup    bool
	contents        map[uuid.UUID]struct{}
	removedcontents map[uuid.UUID]struct{}
	clearedcontents bool
	done            bool
	oldValue        func(context.Context) (*Tag, error)
	predicates      []predicate.Tag
}

var _ ent.Mutation = (*TagMutation)(nil)

// tagOption allows management of the mutation configuration using functional options.
type tagOption func(*TagMutation)

// newTagMutation creates new mutation for the Tag entity.
func newTagMutation(c config, op Op, opts ...tagOption) *TagMutation {
	m := &TagMutation{
		config:        c,
		op:            op,
		typ:           TypeTag,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withTagID sets the ID field of the mutation.
func withTagID(id uuid.UUID) tagOption {
	return func(m *TagMutation) {
		var (
			err   error
			once  sync.Once
			value *Tag
		)
		m.oldValue = func(ctx context.Context) (*Tag, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Tag.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withTag sets the old Tag of the mutation.
func withTag(node *Tag) tagOption {
	return func(m *TagMutation) {
		m.oldValue = func(context.Context) (*Tag, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m TagMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m TagMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Tag entities.
func (m *TagMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *TagMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *TagMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Tag.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetName sets the "name" field.
func (m *TagMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *TagMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the Tag entity.
// If the Tag object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TagMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *TagMutation) ResetName() {
	m.name = nil
}

// SetGroupID sets the "group" edge to the Group entity by id.
func (m *TagMutation) SetGroupID(id uuid.UUID) {
	m.group = &id
}

// ClearGroup clears the "group" edge to the Group entity.
func (m *TagMutation) ClearGroup() {
	m.clearedgroup = true
}

// GroupCleared reports if the "group" edge to the Group entity was cleared.
func (m *TagMutation) GroupCleared() bool {
	return m.clearedgroup
}

// GroupID returns the "group" edge ID in the mutation.
func (m *TagMutation) GroupID() (id uuid.UUID, exists bool) {
	if m.group != nil {
		return *m.group, true
	}
	return
}

// GroupIDs returns the "group" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// GroupID instead. It exists only for internal usage by the builders.
func (m *TagMutation) GroupIDs() (ids []uuid.UUID) {
	if id := m.group; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetGroup resets all changes to the "group" edge.
func (m *TagMutation) ResetGroup() {
	m.group = nil
	m.clearedgroup = false
}

// AddContentIDs adds the "contents" edge to the Content entity by ids.
func (m *TagMutation) AddContentIDs(ids ...uuid.UUID) {
	if m.contents == nil {
		m.contents = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.contents[ids[i]] = struct{}{}
	}
}

// ClearContents clears the "contents" edge to the Content entity.
func (m *TagMutation) ClearContents() {
	m.clearedcontents = true
}

// ContentsCleared reports if the "contents" edge to the Content entity was cleared.
func (m *TagMutation) ContentsCleared() bool {
	return m.clearedcontents
}

// RemoveContentIDs removes the "contents" edge to the Content entity by IDs.
func (m *TagMutation) RemoveContentIDs(ids ...uuid.UUID) {
	if m.removedcontents == nil {
		m.removedcontents = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.contents, ids[i])
		m.removedcontents[ids[i]] = struct{}{}
	}
}

// RemovedContents returns the removed IDs of the "contents" edge to the Content entity.
func (m *TagMutation) RemovedContentsIDs() (ids []uuid.UUID) {
	for id := range m.removedcontents {
		ids = append(ids, id)
	}
	return
}

// ContentsIDs returns the "contents" edge IDs in the mutation.
func (m *TagMutation) ContentsIDs() (ids []uuid.UUID) {
	for id := range m.contents {
		ids = append(ids, id)
	}
	return
}

// ResetContents resets all changes to the "contents" edge.
func (m *TagMutation) ResetContents() {
	m.contents = nil
	m.clearedcontents = false
	m.removedcontents = nil
}

// Where appends a list predicates to the TagMutation builder.
func (m *TagMutation) Where(ps ...predicate.Tag) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the TagMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *TagMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Tag, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *TagMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *TagMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Tag).
func (m *TagMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *TagMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m.name != nil {
		fields = append(fields, tag.FieldName)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *TagMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case tag.FieldName:
		return m.Name()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *TagMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case tag.FieldName:
		return m.OldName(ctx)
	}
	return nil, fmt.Errorf("unknown Tag field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *TagMutation) SetField(name string, value ent.Value) error {
	switch name {
	case tag.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	}
	return fmt.Errorf("unknown Tag field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *TagMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *TagMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *TagMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Tag numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *TagMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *TagMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *TagMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Tag nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *TagMutation) ResetField(name string) error {
	switch name {
	case tag.FieldName:
		m.ResetName()
		return nil
	}
	return fmt.Errorf("unknown Tag field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *TagMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.group != nil {
		edges = append(edges, tag.EdgeGroup)
	}
	if m.contents != nil {
		edges = append(edges, tag.EdgeContents)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *TagMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case tag.EdgeGroup:
		if id := m.group; id != nil {
			return []ent.Value{*id}
		}
	case tag.EdgeContents:
		ids := make([]ent.Value, 0, len(m.contents))
		for id := range m.contents {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *TagMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	if m.removedcontents != nil {
		edges = append(edges, tag.EdgeContents)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *TagMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case tag.EdgeContents:
		ids := make([]ent.Value, 0, len(m.removedcontents))
		for id := range m.removedcontents {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *TagMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedgroup {
		edges = append(edges, tag.EdgeGroup)
	}
	if m.clearedcontents {
		edges = append(edges, tag.EdgeContents)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *TagMutation) EdgeCleared(name string) bool {
	switch name {
	case tag.EdgeGroup:
		return m.clearedgroup
	case tag.EdgeContents:
		return m.clearedcontents
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *TagMutation) ClearEdge(name string) error {
	switch name {
	case tag.EdgeGroup:
		m.ClearGroup()
		return nil
	}
	return fmt.Errorf("unknown Tag unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *TagMutation) ResetEdge(name string) error {
	switch name {
	case tag.EdgeGroup:
		m.ResetGroup()
		return nil
	case tag.EdgeContents:
		m.ResetContents()
		return nil
	}
	return fmt.Errorf("unknown Tag edge %s", name)
}

// UserMutation represents an operation that mutates the User nodes in the graph.
type UserMutation struct {
	config
	op                 Op
	typ                string
	id                 *uuid.UUID
	email              *string
	password_hash      *string
	data               *schema.UserEncoder
	verified           *bool
	verify_secret      *uuid.UUID
	oauth_user         *goth.User
	clearedFields      map[string]struct{}
	content            map[uuid.UUID]struct{}
	removedcontent     map[uuid.UUID]struct{}
	clearedcontent     bool
	group_users        map[uuid.UUID]struct{}
	removedgroup_users map[uuid.UUID]struct{}
	clearedgroup_users bool
	done               bool
	oldValue           func(context.Context) (*User, error)
	predicates         []predicate.User
}

var _ ent.Mutation = (*UserMutation)(nil)

// userOption allows management of the mutation configuration using functional options.
type userOption func(*UserMutation)

// newUserMutation creates new mutation for the User entity.
func newUserMutation(c config, op Op, opts ...userOption) *UserMutation {
	m := &UserMutation{
		config:        c,
		op:            op,
		typ:           TypeUser,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withUserID sets the ID field of the mutation.
func withUserID(id uuid.UUID) userOption {
	return func(m *UserMutation) {
		var (
			err   error
			once  sync.Once
			value *User
		)
		m.oldValue = func(ctx context.Context) (*User, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().User.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withUser sets the old User of the mutation.
func withUser(node *User) userOption {
	return func(m *UserMutation) {
		m.oldValue = func(context.Context) (*User, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m UserMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m UserMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of User entities.
func (m *UserMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *UserMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *UserMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().User.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetEmail sets the "email" field.
func (m *UserMutation) SetEmail(s string) {
	m.email = &s
}

// Email returns the value of the "email" field in the mutation.
func (m *UserMutation) Email() (r string, exists bool) {
	v := m.email
	if v == nil {
		return
	}
	return *v, true
}

// OldEmail returns the old "email" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldEmail(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldEmail is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldEmail requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEmail: %w", err)
	}
	return oldValue.Email, nil
}

// ResetEmail resets all changes to the "email" field.
func (m *UserMutation) ResetEmail() {
	m.email = nil
}

// SetPasswordHash sets the "password_hash" field.
func (m *UserMutation) SetPasswordHash(s string) {
	m.password_hash = &s
}

// PasswordHash returns the value of the "password_hash" field in the mutation.
func (m *UserMutation) PasswordHash() (r string, exists bool) {
	v := m.password_hash
	if v == nil {
		return
	}
	return *v, true
}

// OldPasswordHash returns the old "password_hash" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldPasswordHash(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPasswordHash is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPasswordHash requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPasswordHash: %w", err)
	}
	return oldValue.PasswordHash, nil
}

// ClearPasswordHash clears the value of the "password_hash" field.
func (m *UserMutation) ClearPasswordHash() {
	m.password_hash = nil
	m.clearedFields[entuser.FieldPasswordHash] = struct{}{}
}

// PasswordHashCleared returns if the "password_hash" field was cleared in this mutation.
func (m *UserMutation) PasswordHashCleared() bool {
	_, ok := m.clearedFields[entuser.FieldPasswordHash]
	return ok
}

// ResetPasswordHash resets all changes to the "password_hash" field.
func (m *UserMutation) ResetPasswordHash() {
	m.password_hash = nil
	delete(m.clearedFields, entuser.FieldPasswordHash)
}

// SetData sets the "data" field.
func (m *UserMutation) SetData(se schema.UserEncoder) {
	m.data = &se
}

// Data returns the value of the "data" field in the mutation.
func (m *UserMutation) Data() (r schema.UserEncoder, exists bool) {
	v := m.data
	if v == nil {
		return
	}
	return *v, true
}

// OldData returns the old "data" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldData(ctx context.Context) (v schema.UserEncoder, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldData is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldData requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldData: %w", err)
	}
	return oldValue.Data, nil
}

// ResetData resets all changes to the "data" field.
func (m *UserMutation) ResetData() {
	m.data = nil
}

// SetVerified sets the "verified" field.
func (m *UserMutation) SetVerified(b bool) {
	m.verified = &b
}

// Verified returns the value of the "verified" field in the mutation.
func (m *UserMutation) Verified() (r bool, exists bool) {
	v := m.verified
	if v == nil {
		return
	}
	return *v, true
}

// OldVerified returns the old "verified" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldVerified(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldVerified is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldVerified requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldVerified: %w", err)
	}
	return oldValue.Verified, nil
}

// ResetVerified resets all changes to the "verified" field.
func (m *UserMutation) ResetVerified() {
	m.verified = nil
}

// SetVerifySecret sets the "verify_secret" field.
func (m *UserMutation) SetVerifySecret(u uuid.UUID) {
	m.verify_secret = &u
}

// VerifySecret returns the value of the "verify_secret" field in the mutation.
func (m *UserMutation) VerifySecret() (r uuid.UUID, exists bool) {
	v := m.verify_secret
	if v == nil {
		return
	}
	return *v, true
}

// OldVerifySecret returns the old "verify_secret" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldVerifySecret(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldVerifySecret is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldVerifySecret requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldVerifySecret: %w", err)
	}
	return oldValue.VerifySecret, nil
}

// ClearVerifySecret clears the value of the "verify_secret" field.
func (m *UserMutation) ClearVerifySecret() {
	m.verify_secret = nil
	m.clearedFields[entuser.FieldVerifySecret] = struct{}{}
}

// VerifySecretCleared returns if the "verify_secret" field was cleared in this mutation.
func (m *UserMutation) VerifySecretCleared() bool {
	_, ok := m.clearedFields[entuser.FieldVerifySecret]
	return ok
}

// ResetVerifySecret resets all changes to the "verify_secret" field.
func (m *UserMutation) ResetVerifySecret() {
	m.verify_secret = nil
	delete(m.clearedFields, entuser.FieldVerifySecret)
}

// SetOauthUser sets the "oauth_user" field.
func (m *UserMutation) SetOauthUser(_go goth.User) {
	m.oauth_user = &_go
}

// OauthUser returns the value of the "oauth_user" field in the mutation.
func (m *UserMutation) OauthUser() (r goth.User, exists bool) {
	v := m.oauth_user
	if v == nil {
		return
	}
	return *v, true
}

// OldOauthUser returns the old "oauth_user" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldOauthUser(ctx context.Context) (v goth.User, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldOauthUser is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldOauthUser requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOauthUser: %w", err)
	}
	return oldValue.OauthUser, nil
}

// ResetOauthUser resets all changes to the "oauth_user" field.
func (m *UserMutation) ResetOauthUser() {
	m.oauth_user = nil
}

// AddContentIDs adds the "content" edge to the Content entity by ids.
func (m *UserMutation) AddContentIDs(ids ...uuid.UUID) {
	if m.content == nil {
		m.content = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.content[ids[i]] = struct{}{}
	}
}

// ClearContent clears the "content" edge to the Content entity.
func (m *UserMutation) ClearContent() {
	m.clearedcontent = true
}

// ContentCleared reports if the "content" edge to the Content entity was cleared.
func (m *UserMutation) ContentCleared() bool {
	return m.clearedcontent
}

// RemoveContentIDs removes the "content" edge to the Content entity by IDs.
func (m *UserMutation) RemoveContentIDs(ids ...uuid.UUID) {
	if m.removedcontent == nil {
		m.removedcontent = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.content, ids[i])
		m.removedcontent[ids[i]] = struct{}{}
	}
}

// RemovedContent returns the removed IDs of the "content" edge to the Content entity.
func (m *UserMutation) RemovedContentIDs() (ids []uuid.UUID) {
	for id := range m.removedcontent {
		ids = append(ids, id)
	}
	return
}

// ContentIDs returns the "content" edge IDs in the mutation.
func (m *UserMutation) ContentIDs() (ids []uuid.UUID) {
	for id := range m.content {
		ids = append(ids, id)
	}
	return
}

// ResetContent resets all changes to the "content" edge.
func (m *UserMutation) ResetContent() {
	m.content = nil
	m.clearedcontent = false
	m.removedcontent = nil
}

// AddGroupUserIDs adds the "group_users" edge to the GroupUser entity by ids.
func (m *UserMutation) AddGroupUserIDs(ids ...uuid.UUID) {
	if m.group_users == nil {
		m.group_users = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.group_users[ids[i]] = struct{}{}
	}
}

// ClearGroupUsers clears the "group_users" edge to the GroupUser entity.
func (m *UserMutation) ClearGroupUsers() {
	m.clearedgroup_users = true
}

// GroupUsersCleared reports if the "group_users" edge to the GroupUser entity was cleared.
func (m *UserMutation) GroupUsersCleared() bool {
	return m.clearedgroup_users
}

// RemoveGroupUserIDs removes the "group_users" edge to the GroupUser entity by IDs.
func (m *UserMutation) RemoveGroupUserIDs(ids ...uuid.UUID) {
	if m.removedgroup_users == nil {
		m.removedgroup_users = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.group_users, ids[i])
		m.removedgroup_users[ids[i]] = struct{}{}
	}
}

// RemovedGroupUsers returns the removed IDs of the "group_users" edge to the GroupUser entity.
func (m *UserMutation) RemovedGroupUsersIDs() (ids []uuid.UUID) {
	for id := range m.removedgroup_users {
		ids = append(ids, id)
	}
	return
}

// GroupUsersIDs returns the "group_users" edge IDs in the mutation.
func (m *UserMutation) GroupUsersIDs() (ids []uuid.UUID) {
	for id := range m.group_users {
		ids = append(ids, id)
	}
	return
}

// ResetGroupUsers resets all changes to the "group_users" edge.
func (m *UserMutation) ResetGroupUsers() {
	m.group_users = nil
	m.clearedgroup_users = false
	m.removedgroup_users = nil
}

// Where appends a list predicates to the UserMutation builder.
func (m *UserMutation) Where(ps ...predicate.User) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the UserMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *UserMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.User, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *UserMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *UserMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (User).
func (m *UserMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *UserMutation) Fields() []string {
	fields := make([]string, 0, 6)
	if m.email != nil {
		fields = append(fields, entuser.FieldEmail)
	}
	if m.password_hash != nil {
		fields = append(fields, entuser.FieldPasswordHash)
	}
	if m.data != nil {
		fields = append(fields, entuser.FieldData)
	}
	if m.verified != nil {
		fields = append(fields, entuser.FieldVerified)
	}
	if m.verify_secret != nil {
		fields = append(fields, entuser.FieldVerifySecret)
	}
	if m.oauth_user != nil {
		fields = append(fields, entuser.FieldOauthUser)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *UserMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case entuser.FieldEmail:
		return m.Email()
	case entuser.FieldPasswordHash:
		return m.PasswordHash()
	case entuser.FieldData:
		return m.Data()
	case entuser.FieldVerified:
		return m.Verified()
	case entuser.FieldVerifySecret:
		return m.VerifySecret()
	case entuser.FieldOauthUser:
		return m.OauthUser()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *UserMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case entuser.FieldEmail:
		return m.OldEmail(ctx)
	case entuser.FieldPasswordHash:
		return m.OldPasswordHash(ctx)
	case entuser.FieldData:
		return m.OldData(ctx)
	case entuser.FieldVerified:
		return m.OldVerified(ctx)
	case entuser.FieldVerifySecret:
		return m.OldVerifySecret(ctx)
	case entuser.FieldOauthUser:
		return m.OldOauthUser(ctx)
	}
	return nil, fmt.Errorf("unknown User field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) SetField(name string, value ent.Value) error {
	switch name {
	case entuser.FieldEmail:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEmail(v)
		return nil
	case entuser.FieldPasswordHash:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPasswordHash(v)
		return nil
	case entuser.FieldData:
		v, ok := value.(schema.UserEncoder)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetData(v)
		return nil
	case entuser.FieldVerified:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetVerified(v)
		return nil
	case entuser.FieldVerifySecret:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetVerifySecret(v)
		return nil
	case entuser.FieldOauthUser:
		v, ok := value.(goth.User)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOauthUser(v)
		return nil
	}
	return fmt.Errorf("unknown User field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *UserMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *UserMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown User numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *UserMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(entuser.FieldPasswordHash) {
		fields = append(fields, entuser.FieldPasswordHash)
	}
	if m.FieldCleared(entuser.FieldVerifySecret) {
		fields = append(fields, entuser.FieldVerifySecret)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *UserMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *UserMutation) ClearField(name string) error {
	switch name {
	case entuser.FieldPasswordHash:
		m.ClearPasswordHash()
		return nil
	case entuser.FieldVerifySecret:
		m.ClearVerifySecret()
		return nil
	}
	return fmt.Errorf("unknown User nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *UserMutation) ResetField(name string) error {
	switch name {
	case entuser.FieldEmail:
		m.ResetEmail()
		return nil
	case entuser.FieldPasswordHash:
		m.ResetPasswordHash()
		return nil
	case entuser.FieldData:
		m.ResetData()
		return nil
	case entuser.FieldVerified:
		m.ResetVerified()
		return nil
	case entuser.FieldVerifySecret:
		m.ResetVerifySecret()
		return nil
	case entuser.FieldOauthUser:
		m.ResetOauthUser()
		return nil
	}
	return fmt.Errorf("unknown User field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *UserMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.content != nil {
		edges = append(edges, entuser.EdgeContent)
	}
	if m.group_users != nil {
		edges = append(edges, entuser.EdgeGroupUsers)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *UserMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case entuser.EdgeContent:
		ids := make([]ent.Value, 0, len(m.content))
		for id := range m.content {
			ids = append(ids, id)
		}
		return ids
	case entuser.EdgeGroupUsers:
		ids := make([]ent.Value, 0, len(m.group_users))
		for id := range m.group_users {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *UserMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	if m.removedcontent != nil {
		edges = append(edges, entuser.EdgeContent)
	}
	if m.removedgroup_users != nil {
		edges = append(edges, entuser.EdgeGroupUsers)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *UserMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case entuser.EdgeContent:
		ids := make([]ent.Value, 0, len(m.removedcontent))
		for id := range m.removedcontent {
			ids = append(ids, id)
		}
		return ids
	case entuser.EdgeGroupUsers:
		ids := make([]ent.Value, 0, len(m.removedgroup_users))
		for id := range m.removedgroup_users {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *UserMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedcontent {
		edges = append(edges, entuser.EdgeContent)
	}
	if m.clearedgroup_users {
		edges = append(edges, entuser.EdgeGroupUsers)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *UserMutation) EdgeCleared(name string) bool {
	switch name {
	case entuser.EdgeContent:
		return m.clearedcontent
	case entuser.EdgeGroupUsers:
		return m.clearedgroup_users
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *UserMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown User unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *UserMutation) ResetEdge(name string) error {
	switch name {
	case entuser.EdgeContent:
		m.ResetContent()
		return nil
	case entuser.EdgeGroupUsers:
		m.ResetGroupUsers()
		return nil
	}
	return fmt.Errorf("unknown User edge %s", name)
}
